<%@  page pageEncoding="utf-8" contentType="text/html;charset=utf-8"
   import="com.novell.webaccess.common.JSPConduit,
           com.novell.emframe.dev.eMFrameUtils,
           com.novell.emframe.dev.DirUtils,
           com.novell.emframe.fw.FwUtils,
           com.novell.emframe.fw.EmailEventService" %>

<%
   JSPConduit c = JSPConduit.getJSPConduit(request);
   c.stringTable("DevResources");
   c.stringTable("FwResources");
%>

<%@ taglib uri="/WEB-INF/iman.tld" prefix="iman" %>
<%@ taglib uri="/WEB-INF/c.tld" prefix="c" %>
<%@ taglib uri="/WEB-INF/x.tld" prefix="x" %>

<iman:stringtable bundle="FwResources"/>
<iman:stringtable bundle="DevResources"/>

<HTML>
<HEAD>
   <LINK rel="stylesheet" href="<c:out value="${ContextPath}" />/portal/modules/dev/css/hf_style.css">
   <iman:eMFrameScripts/>

      <SCRIPT>

   /*******************
    * FUNCTION HEADER *
    *******************/
   function onExit()
   {
      window.location = "webacc?NPService=fw.LaunchService&NPAction=Return&returnID=<c:out value="${GI_ID}"/>";
   }

   function onApplyAndExit()
   {
      var form = document.SMTPServerForm;
      if(checkEmailConfigInput()){
	      form.submit();
      }
   }
   
   function checkEmailConfigInput(){
   
   		var strSenderAddressInput = document.forms[0].SenderAddr.value;
	   	var primarySMTPServerInput = document.forms[0].server1.value;
	   	var primaryUserInput = document.forms[0].user1.value;
   		var primaryPasswordInput = document.forms[0].password1.value;
	   	var secondarySMTPServerInput = document.forms[0].server2.value;
   		var secondaryUserInput = document.forms[0].user2.value;
	   	var secondaryPasswordInput = document.forms[0].password2.value;
   	
   		if ((null == strSenderAddressInput) || (0 == strSenderAddressInput.length)){
        	 alert("<iman:string key="Email.SMTPSenderAddressEmptyField"/>");
           	 return false;
    	}
	   	if ((null == primarySMTPServerInput) || (0 == primarySMTPServerInput.length)){
			 alert("<iman:string key="Email.SMTPPrimaryEmptyField"/>");
        	 return false;
	    }
		
    	if(!validateEmailAddress(strSenderAddressInput)){
	    	 alert("<iman:string key="Email.SMTPSenderAddressInvalid"/>");
   			return false;
	   	}
   		if(!validateSecondaryConfigInputs(secondarySMTPServerInput,secondaryUserInput,secondaryPasswordInput)){
   			return false;
	   	}
   		return true;
   }
   
   function validateSecondaryConfigInputs(secServer,secUserName,secPassword){
   
   		if((secUserName == null ||secUserName.length == 0) 
	   		   &&(secPassword == null ||secPassword.length == 0)
	   		   &&(secServer == null || secServer == "")){
   		   		return true;
   		}
   		if(secServer != "" || secServer != null){
   				if(secUserName == null ||secUserName.length == 0){
			       alert("<iman:string key="Email.SMTPSecondaryUserNameRequired"/>");   		    		
					return false;   
   	    		}
   	        	if(secPassword == null ||secPassword.length == 0){
			       alert("<iman:string key="Email.SMTPSecondaryPasswordRequired"/>");			       	
					return false;   
				}
		}
		if((secServer == null || secServer == "")
	    	   && ((secUserName != "" || secUserName != null)
	       		|| (secPassword != "" || secPassword != null))){
		       alert("<iman:string key="Email.SMTPSecondaryRequired"/>");
				return false;       
		}
	return true;
   }
   
   function validateEmailAddress(email) {

		var at="@"
		var dot="."
		var lat=email.indexOf(at)
		var lemail=email.length
		var ldot=email.indexOf(dot)
		var msg = "";
		if (email.indexOf(at)==-1){
		   return false
		}

		if (email.indexOf(at)==-1 || email.indexOf(at)==0 || email.indexOf(at)==lemail){
		   return false
		}

		if (email.indexOf(dot)==-1 || email.indexOf(dot)==0 || email.indexOf(dot)==lemail){
		    return false
		}

		 if (email.indexOf(at,(lat+1))!=-1){
		    return false
		 }

		 if (email.substring(lat-1,lat)==dot || email.substring(lat+1,lat+2)==dot){
		    return false
		 }

		 if (email.indexOf(dot,(lat+2))==-1){
		    return false
		 }
		
		 if (email.indexOf(" ")!=-1){
		    return false
		 }
		 
		 if (email.indexOf("..") >=0) {
			return false;
		 }
		 if (email.lastIndexOf(".") == email.length -1) {
			return false;
         }

 		 return true;
	}
   

   </SCRIPT>
   </HEAD>
   <BODY>
      <% String taskId = (String) request.getAttribute("taskId"); %>
      <FORM name="SMTPServerForm" method="POST" action="webacc">
        <input type="hidden" name="taskId" value="<%=taskId%>" />
        <input type="hidden" name="NumSMTPServers" value="2" />
         <% c.set("TaskHeader.title",  c.toHTML(c.string("Email.SMTPConfigHeader")));
            c.set("TaskHeader.iconUrl", "dev/bullet_default_16.gif");
            c.set("TaskHeader.helpFile", "base/mailserverconfiguration.html"); 
	         c.set("TaskHeader.HelpWindowWidth", "500");
	         c.set("TaskHeader.HelpWindowHeight", "500"); %>
         <jsp:include page='<%= c.getPath("dev/TaskHeader_inc.jsp") %>' flush="true" />
         <div class="formdescriptextml0"  style="width: 70%"><%= c.toHTML(c.string("Email.SMTPConfigInstructions")) %></div>
         <div class="margintop3">
             <% if (request.getAttribute("SETTINGS_APPLIED") != null) {
                 %>
                 <tr style="background-color: #efeee9">
                      <td colspan="2"><%= c.toHTML(c.string("Email.SMTPNewSettinsSaved")) %></td>
                 </tr>
                 <%
             }
                 %>
             <% if (request.getAttribute("ERROR") != null) {
                 %>
                 <tr style="background-color: #efeee9">
                      <td colspan="2"><%=request.getAttribute("ERROR")%></td>
                 </tr>
                 <%
             }
                 %>
            <div class="tablesubhead1"  style="width: 94%; margin-top: 1em"><%= c.toHTML(c.string("Email.SMTPConfigSubHeader")) %></div>
            <table border="0" cellspacing="0" cellpadding="3" style="white-space: nowrap">
                    <tr>
                        <td class="smalltext" align="right"><%= c.toHTML(c.string("Email.SMTPSenderAddress")) %></td>
                        <td class="smalltext">
                            <input type="text" name="SenderAddr" size="30" value="<%=request.getAttribute(EmailEventService.EMAIL_SMTP_SENDER)%>" />
                        </td>
                    </tr>
                    <tr>
                        <td class="smalltext" colspan="2"><img src="/nps/portal/modules/fw/images/1px_spacer.gif" alt="" height="15" width="15" border="0"></td>
                    </tr>

                    <tr>
                        <td class="smalltext" align="right"><%= c.toHTML(c.string("Email.SMTPPrimary")) %></td>
                        <td class="smalltext"><input type="text" name="server1" size="30" value="<%=request.getAttribute("server1")%>"><span class="textblue1"> (smtp.novell.com)</span></td>
                    </tr>
                    <tr>
                        <td class="smalltext" align="right"><%= c.toHTML(c.string("Email.SMTPUsername")) %></td>
                        <td class="smalltext"><input type="text" name="user1" size="30" value="<%=request.getAttribute("user1")%>"></td>
                    </tr>
                    <tr>
                        <td class="smalltext" align="right"><%= c.toHTML(c.string("Email.SMTPPassword")) %></td>
                        <td class="smalltext"><input type="password" name="password1" size="30" value="<%=request.getAttribute("password1")%>" ></td>
                    </tr>
                    <tr>
                        <td class="smalltext" colspan="2"><img src="/nps/portal/modules/fw/images/1px_spacer.gif" alt="" height="15" width="15" border="0"></td>
                    </tr>
                    <tr>
                        <td class="smalltext" align="right"><%= c.toHTML(c.string("Email.SMTPSecondary")) %></td>
                        <td class="smalltext"><input type="text" name="server2" size="30" value="<%=request.getAttribute("server2")%>"><span class="textblue1"> <%= c.toHTML(c.string("Email.SMTPOptional")) %></span></td>
                    </tr>
                    <tr>
                        <td class="smalltext" align="right"><%= c.toHTML(c.string("Email.SMTPUsername")) %></td>
                        <td class="smalltext"><input type="text" name="user2" size="30" value="<%=request.getAttribute("user2")%>"></td>
                    </tr>
			    	<tr>
				    	<td class="smalltext" align="right"><%= c.toHTML(c.string("Email.SMTPPassword")) %></td>
					    <td class="smalltext"><input type="password" name="password2" size="30" value="<%=request.getAttribute("password2")%>" ></td>
		    		</tr>
	    		</table>

         <iman:bar/>
         <div id="buttondiv" style="display: block">
            <iman:button key="OK" onClick="onApplyAndExit();" />
            <iman:button key="Cancel" onClick="onExit();" />
         </div>
    </FORM>
   </BODY>
</HTML>
