<%@  page pageEncoding="utf-8" contentType="text/html;charset=utf-8" import="com.novell.webaccess.common.JSPConduit, com.novell.emframe.dev.eMFrameUtils,
                                                                             com.novell.nps.utils.Utils" %>
<%   JSPConduit c = JSPConduit.getJSPConduit(request);
   c.stringTable("DevResources");
   c.stringTable("FwResources"); %>

<HTML>
<HEAD>
<TITLE><%= JSPConduit.toHTML(c.string("RBSManagement.ModifyRoleAssociationsTitle")) %></TITLE>
<jsp:include page='<%= c.getPath("dev/eMFrameScripts_inc.jsp") %>' flush="true" />
<jsp:include page='<%= c.getPath("dev/MVStringEditorScripts_inc.jsp") %>' flush="true" />
<jsp:include page='<%= c.getPath("dev/OSScripts_inc.jsp") %>' flush="true" />

<LINK href="<%= c.getModulesUrl() + "/dev/css/hf_style.css" %>" rel="styleSheet" type="text/css">

<SCRIPT language="JavaScript">

   //Global variables
   var deleteItemsArray 			= new Array();
   var modifyScopeArray 			= new Array();
   var inheritanceKeyArray 		= new Array();
   var inheritanceValueArray 		= new Array();
   var combinedInheritanceArray 	= new Array();
   var assignRightsKeyArray 		= new Array();
   var assignRightsValueArray 	= new Array();
   var combinedAssignRightsArray = new Array();
   var userInterface 				= "<%= c.var("User.interface") %>";
   var myWindow;
   var m_sMemberList;
   var m_aMembers                = new Array();
   var m_sMemberScopeList;
   var m_aMembersAndScopes       = new Array();
   var newInheritanceValue;

   //==================================
   // onPageLoad()
   //==================================
   function onPageLoad()
   {
      m_sMemberList        = document.ModifyAssociationsForm.elements["NewMemberList"].value;
      m_aMembers           = m_sMemberList.split(";");
      m_sMemberScopeList   = document.ModifyAssociationsForm.elements["NewMemberScopeList"].value;
      m_aMembersAndScopes  = m_sMemberScopeList.split(";");

      returnFromOS(); //Set this for the ObjectSelector
      setGeneralMsgUrl();
      setFocusToFormElement();
   }

   //==================================
   // setFocusToFormElement()
   //==================================
   function setFocusToFormElement()
   {
      mvFocus("NameTextField");
   }

   //==================================
   // setWaitCursor()
   // cursorStyle is either set to 'wait' or 'default'
   //==================================
   function setWaitCursor(cursorStyle)
   {
	   document.body.style.cursor=cursorStyle;
   }

   function isEmpty(inputStr)
   {
   	if (inputStr == null || inputStr == "")
      {
         return true;
      }
      else
      {
         return false;
      }
   }

   function checkForMissingScopes()
   {
      var elementCount = document.forms[0].elements.length;

      for (var i = 0; i < elementCount; i++)
      {
      	if (document.forms[0].elements[i].type == "checkbox")
        	{
            if (document.forms[0].elements[i].name.search("RowCheckBox") != -1)
	         {
	            var memberScope	= parseScope(document.forms[0].elements[i].value);

	            if (memberScope == null || memberScope == "" )
	            {
	               alert("<%= Utils.toScript(c.string("RBSManagement.MissingScope")) %>");
	               return false;
	            }
            }
         }
      }

      return true;
   }

   function OKButtonClicked()
   {
      bTableComplete 	= checkForMissingScopes();
      var newMemberStr 	= cleanupMVPackStrings(mvGetValuesAsPack("NameTextField"));
      var newScopeStr	= "";

      // If it is a selfprovisioning role we don't show the scopetextfield
      <% if (c.var("SelfProvisioningRole").equals("false")) { %>
      	newScopeStr = cleanupMVPackStrings(mvGetValuesAsPack("ScopeTextField"));
      <% } %>

      if (!isEmpty(newMemberStr) || !isEmpty(newScopeStr))
      {
      	var message = "<%= Utils.toScript(c.string("RBSManagement.DataLeftInTextfields")) %>";

	      if (!confirm(message))
	      {
	         return false;
	      }
      }

      setGeneralMsgUrl();
      setWaitCursor("wait");

      if (bTableComplete == true)
      {
         document.ModifyAssociationsForm.elements["merge"].value="dev.GenConf";
		   document.ModifyAssociationsForm.elements["nextState"].value="updateModifyRoleAssociations";
		   document.ModifyAssociationsForm.submit();
      }
      else
      {
         setWaitCursor("default");
         return false;
      }
   }

   function setGeneralMsgUrl()
   {
   }

   function nameRemoveButtonSelected()
   {
      var count = 0;

      // Get all of the checked items
      if (rowsAreSelected() == true)
      {
         var elementCount = document.forms[0].elements.length;

         for (var i = 0; i < elementCount; i++)
	      {
	      	if (document.forms[0].elements[i].type == "checkbox")
	        	{
	            if (document.forms[0].elements[i].name.search("RowCheckBox") != -1)
		         {
		            if (document.forms[0].elements[i].checked)
		            {
	                  var memberName		= parseName(document.forms[0].elements[i].value);
	                  var memberScope	= parseScope(document.forms[0].elements[i].value);

	                  if (memberScope != null && memberScope != "")
	                  {
	                     deleteItemsArray[count] = urlEncode(memberName) + ";" + urlEncode(memberScope) + "$";
		                  count++;
	                  }
	                  else
	                  {
	                  	deleteItemsArray[count] = urlEncode(memberName) + ";" + "[no scope]" + "$";
		                  count++;
	                  }
	               }
               }
	         }
	      }

         if (deleteItemsArray != null && deleteItemsArray.length > 0)
         {
	         setWaitCursor("wait");
            document.ModifyAssociationsForm.elements["DeleteMemberList"].value = deleteItemsArray.join("$");
	         document.ModifyAssociationsForm.elements["DeleteMemberListCount"].value = count;

	         // make the changes to DS and return
		      document.ModifyAssociationsForm.elements["merge"].value="fw.ModifyRoleAssociations";
		      document.ModifyAssociationsForm.elements["nextState"].value="deleteMembersFromTable";
		      document.ModifyAssociationsForm.submit();
         }
      }
      else
      {
      	alert("<%= Utils.toScript(c.string("RBSManagement.NoObjectsSelected")) %>");
      }
   }



   // ============================================================================================
   //	This function is called when the user has clicked on the "Add" button and the role type is
   // the default 'iManager' role.
   //	============================================================================================
   function addButtonSelected()
   {
      var newMemberStr 	= cleanupMVPackStrings(mvGetValuesAsPack("NameTextField"));
      var newScopeStr 	= cleanupMVPackStrings(mvGetValuesAsPack("ScopeTextField"));

      if (!isEmpty(newMemberStr) && !isEmpty(newScopeStr))
      {
         addMembersAndScopes();
      }
      else if (!isEmpty(newMemberStr))
      {
         addNamesToTable(newMemberStr);
      }
      else if (!isEmpty(newScopeStr))
      {
         addScopesToTable(newScopeStr);
      }
      else
      {
         alert("<%= Utils.toScript(c.string("RBSManagement.TextfieldsEmpty")) %> ");
      }
   }

	// ============================================================================================
   //	This function is called when the user has clicked on the "Add" button and the role type is
   // 'Self-Provisioning'. There is no ScopeTextField to test for a value.
   //	============================================================================================
   function addNameButtonSelected()
   {
      var newMemberStr 	= mvGetValuesAsPack("NameTextField");

      if (!isEmpty(newMemberStr))
      {
         addNamesToTable(newMemberStr);
      }
      else
      {
      	alert("<%= Utils.toScript(c.string("RBSManagement.FieldEmpty")) %> ");
      }
   }

   // This function is passed in the member name from an OS browse and uses the scope that has
   // been typed into the scope textfield for the association. None of the rows have to be selected
   // as with the case of adding a scope name to an existing member.
   function addMembersAndScopes()
   {
	  	var memberList 			= document.ModifyAssociationsForm.elements["NewMemberList"].value;
      var memberArray 			= memberList.split(";");
      var duplicateName 		= false;
      var duplicateScope 		= false;
      var finalArray				= new Array();
      var searchResultsArray 	= new Array();
      var duplicateScopeArray = new Array();
      var count 					= 0;
      var dupCount				= 0;
      var newMemberString		= "";
      var memberArray 			= unpack(mvGetValuesAsPack("NameTextField"));
      var scopeArray				= unpack(mvGetValuesAsPack("ScopeTextField"));
		var dupScopesFound		= false;
      var newScopeName;

      if (memberArray != null)
      {
         for (var i = 0; i < memberArray.length; i++)
	      {
            duplicateName = isMemberInArray(memberArray[i]);

            if (duplicateName)
            {
               for (var j = 0; j < scopeArray.length; j++)
               {
						if (scopeArray[j].toUpperCase() == "[ROOT]")
						{
							var rbsIsnvds = "<%= c.var("rbs_isNVDS") %>";
                     if (rbsIsnvds == "false")
                     {
                        // Replace [Root] with tree name
                        newScopeName = document.ModifyAssociationsForm.elements["RoleManagementTask.TreeName"].value;
                     }
                     else
                     {
                        // For Kepler keep the tree name as [Root]
                        newScopeName = scopeArray[j];
                     }
						}
						else
						{
							newScopeName = scopeArray[j];
						}
						duplicateScope = isScopeInArray(memberArray[i], newScopeName);
                  if (duplicateScope == false)
                  {
                     finalArray[count] = urlEncode(memberArray[i]) + ";" + urlEncode(scopeArray[j]);
                     count++;
                  }
                  else
                  {
                     var duplicateNameScope = checkArrayForDuplicates(duplicateScopeArray, memberArray[i], scopeArray[j]);
                     if (duplicateNameScope == false && dupCount < 20)
							{
								duplicateScopeArray[dupCount] = ("<%= Utils.toScript(c.string("ModifyRoleAssociations.NameColon")) %>" + " " + memberArray[i] + "   " + "<%= Utils.toScript(c.string("ModifyRoleAssociations.ScopeColon")) %>" + " " + scopeArray[j]);
								dupScopesFound = true;
								dupCount++;
                     }
                  }
		       	}
		    	}
            else
            {
               // The member does not exist in the table. Assign all of the selected scopes to the member
               for (var k = 0; k < scopeArray.length; k++)
         	   {
               	finalArray[count] = urlEncode(memberArray[i]) + ";" + urlEncode(scopeArray[k]);
         		  	count++;
		       	}
		    	}
         }
      }

      if (dupScopesFound == true)
		{
			var endString = " ";

			if (dupCount >= 20)
			{
				endString = ".";
			}
			var dupArrayString = duplicateScopeArray.join("\n");
			alert("<%= Utils.toScript(c.string("RBSManagement.MemberAndScopeAlreadyInTable")) %>" + "\n\n" + dupArrayString + "\n" + endString + "\n" + endString + "\n" + endString);
		}

      if (finalArray != null && finalArray.length > 0)
      {
         if (finalArray.length > 0)
         {
            setWaitCursor("wait");
            document.ModifyAssociationsForm.elements["NewMemberAndScope"].value = finalArray.join("$");
            document.ModifyAssociationsForm.elements["merge"].value="fw.ModifyRoleAssociations";
				document.ModifyAssociationsForm.elements["nextState"].value="addMemberAndScopeToTable";
				document.ModifyAssociationsForm.submit();
         }
      }
   }

   function addNamesToTable(mvString)
   {
      var memberList 			= document.ModifyAssociationsForm.elements["NewMemberList"].value;
      var memberArray 			= memberList.split(";");
      var duplicateName 		= false;
      var finalArray				= new Array();
      var searchResultsArray 	= new Array();
      var count 					= 0;
      var newMemberString		= "";
      var resultsArray 			= unpack(mvString);

      if (resultsArray != null)
      {
         for (var j = 0; j < resultsArray.length; j++)
	      {
          	newMemberString = resultsArray[j].toString();

            // Compare new name to existing member list
	         for (var k = 0; k < memberArray.length; k++)
	         {
               if (newMemberString.toUpperCase() == memberArray[k].toUpperCase())
		         {
                  alert("<%= Utils.toScript(c.string("AssignUsers.MemberAlreadyInTable")) %> " + newMemberString);
	               duplicateName = true;
	               break;
		         }
	         }

	         if (duplicateName == false)
	         {
               finalArray[count] = urlEncode(resultsArray[j]);
	            count++;
	         }
	         else
	         {
	         	duplicateName = false; // reset the value
	         }
	      }
      }

      if (finalArray != null && finalArray.length > 0)
      {
         if (finalArray.length > 0)
         {
            setWaitCursor("wait");

            document.ModifyAssociationsForm.elements["NewRoleMembers"].value = finalArray.join("$");
            document.ModifyAssociationsForm.elements["merge"].value="fw.ModifyRoleAssociations";
				document.ModifyAssociationsForm.elements["nextState"].value="addMembersToTable";
				document.ModifyAssociationsForm.submit();
         }
      }
   }

	// Checks to see if any checkboxes are checked and then launches the ObjectSelector
   function addScopesToTable(mvScopeString)
   {
      var updateTable 		   = false;
      var elementCount 		   = document.forms[0].elements.length;
      var count				   = 0;
      var dupCount				= 0;
      var duplicateScope 	   = false;
      var scopeArray 		   = unpack(mvScopeString);
      var dupScopesFound	   = false;
      var duplicateScopeArray = new Array();
      var newScopeName;

      // Go through the table and check for selected rows to add the scope(s) to.
      if (rowsAreSelected() == true)
      {
         for (var i = 0; i < elementCount; i++)
	     {
	      	if (document.forms[0].elements[i].type == "checkbox")
	        {
	            if (document.forms[0].elements[i].name.search("RowCheckBox") != -1)
		        {
                   if (document.forms[0].elements[i].checked)
                   {
                     var memberName	= parseName(document.forms[0].elements[i].value);

                     for (var j = 0; j < scopeArray.length; j++)
                     {
                        if (scopeArray[j].toUpperCase() == "[ROOT]")
								{
									var rbsIsnvds = "<%= c.var("rbs_isNVDS") %>";
                           if (rbsIsnvds == "false")
                           {
                              // Replace [Root] with tree name
                              newScopeName = document.ModifyAssociationsForm.elements["RoleManagementTask.TreeName"].value;
                           }
                           else
                           {
                              // For Kepler keep the tree name as [Root]
                              newScopeName = scopeArray[j];
                           }
								}
								else
								{
									newScopeName = scopeArray[j];
								}
                        duplicateScope = isScopeInArray(memberName, newScopeName);

                        if (duplicateScope == false)
                        {
                           modifyScopeArray[count++] = urlEncode(memberName) + ";" + urlEncode(scopeArray[j]) + "$";
                        }
                        else
								{
									var duplicateNameScope = checkArrayForDuplicates(duplicateScopeArray, memberName, scopeArray[j]);
									if (duplicateNameScope == false && dupCount < 20)
									{
										duplicateScopeArray[dupCount] = ("<%= Utils.toScript(c.string("ModifyRoleAssociations.NameColon")) %>" + " " + memberName + "   " + "<%= Utils.toScript(c.string("ModifyRoleAssociations.ScopeColon")) %>" + " " + scopeArray[j]);
										dupScopesFound = true;
										dupCount++;
									}
								}
                     }
                  }
               }
	         }
	      }

			if (dupScopesFound == true)
			{
				var endString = " ";

				if (dupCount >= 20)
				{
					endString = ".";
				}
				var dupArrayString = duplicateScopeArray.join("\n");
				alert("<%= Utils.toScript(c.string("RBSManagement.MemberAndScopeAlreadyInTable")) %>" + "\n\n" + dupArrayString + "\n" + endString + "\n" + endString + "\n" + endString);
			}

			if (modifyScopeArray.length > 0)
			{
				setWaitCursor("wait");

				document.ModifyAssociationsForm.elements["ModifyScopeList"].value=modifyScopeArray.join("$");
				document.ModifyAssociationsForm.elements["merge"].value="fw.ModifyRoleAssociations";
				document.ModifyAssociationsForm.elements["nextState"].value="addScopeToTableMember";
				document.ModifyAssociationsForm.submit();
			}
      }
      else
      {
      	alert("<%= Utils.toScript(c.string("RBSManagement.NoNamesSelected")) %>");
      }
   }

   function checkArrayForDuplicates(duplicateScopeArray, memberName, scope)
   {
      for (var i = 0; i < duplicateScopeArray.length; i++)
      {
         if (duplicateScopeArray[i].search(memberName) != -1 && duplicateScopeArray[i].search(scope) != -1)
         {
            return true;
         }
      }
      return false;
   }

   function parseScope(scopeAndName)
   {
      var nameScopeArray = scopeAndName.split(":"); // The name and scope strings are encoded
      var unEncodedScope = urlDecode(nameScopeArray[0]); // Unencode the strings
      return unEncodedScope;
   }

   function parseName(scopeAndName)
   {
      var nameScopeArray 	= scopeAndName.split(":");
      var unEncodedName		= urlDecode(nameScopeArray[1]);
      return unEncodedName;
   }

   function modifyScopeSelected(memberName, scopeName)
   {
      document.ModifyAssociationsForm.elements["ModifyMemberFullName"].value=memberName;
   	document.ModifyAssociationsForm.elements["ModifyMemberOldScope"].value=scopeName;

      if (!myWindow || myWindow.closed)
      {
         myWindow = window.open("webacc?taskId=dev.Empty&merge=fw.ModifyRoleScope&User.context=<%= JSPConduit.toHTML(c.var("User.context")) %>&RoleScopeFilter=<%= c.var("RoleScopeFilter")%>", "", "toolbar=no,location=no,directories=no,menubar=no,scrollbars=yes,resizable=yes,width=520,height=330");
      }
      else
      {
      	myWindow.focus();
      }
   }

   function AssignRightsCheckBoxChange(fullName, scopeName, checkedValue, checkboxNumber)
   {
      var stringInArray 			= false;
      var newNameScope 				= urlEncode(fullName) + ";" + urlEncode(scopeName);
      var newAssignRightsValue 	= checkedValue.toString();
		var inheritNumber 			= "InheritanceCheckBox" + checkboxNumber;

      if (assignRightsKeyArray != null) // Global array of Names and scopes used as key
      {
         // Check array for existing memberId
         for (var i = 0; i < assignRightsKeyArray.length; i++)
         {
            var arrayNameScopeString = assignRightsKeyArray[i];

            // Compare new name and scope to existing name and scope key
            if (arrayNameScopeString == urlDecode(newNameScope))
            {
               stringInArray = true;

               // compare
               assignRightsValueArray[i] = newAssignRightsValue;
               break;
            }
         }

         // Not in the array
         if (stringInArray == false)
         {
         	assignRightsKeyArray[assignRightsKeyArray.length] = newNameScope;
            assignRightsValueArray[assignRightsValueArray.length] = newAssignRightsValue;
         }

         for (var j = 0; j < assignRightsKeyArray.length; j++)
         {
            combinedAssignRightsArray[j] = assignRightsKeyArray[j] + ";" + assignRightsValueArray[j];
         }

         document.ModifyAssociationsForm.elements["MemberAssignRightsChanged"].value="true";
      	document.ModifyAssociationsForm.elements["MemberAssignRightsList"].value=combinedAssignRightsArray.join("$");
      }

      inheritanceScopeChange(fullName, scopeName, checkedValue, checkboxNumber, "true");
      //inheritanceCheckboxChange(fullName, scopeName, checkedValue, checkboxNumber, "true");
   }

   /*****************************
    * inheritanceCheckboxChange *
    *****************************/
   function inheritanceCheckboxChange(fullName, scopeName, checkedValue, checkboxNumber, assignRightsChanged)
   {
      if(assignRightsChanged == "true")
      {
         var elementCount 	= document.forms[0].elements.length;

         // Set all rowCheckBoxes to true
         for (var i = 0; i < elementCount; i++)
         {
            if (document.forms[0].elements[i].type == "checkbox")
            {
               if (document.forms[0].elements[i].name.search("InheritanceCheckBox" + checkboxNumber) != -1)
               {
                  if(checkedValue == false)
                  {
                     document.forms[0].elements[i].disabled = true;
                     document.forms[0].elements[i].checked = false;
                  }
                  else
                  {
                     document.forms[0].elements[i].disabled = false;
                     document.forms[0].elements[i].checked = true;
                  }

                  break;
               }
            }
         }
      }

      var stringInArray 		= false;
      var newNameScope 			= urlEncode(fullName) + ";" + urlEncode(scopeName);
      var newInheritanceValue = checkedValue.toString();

      if (inheritanceKeyArray != null) // Global array of Names and scopes used as key
      {
         // Check array for existing memberId
         for (var i = 0; i < inheritanceKeyArray.length; i++)
         {
            var arrayNameScopeString = inheritanceKeyArray[i];

            // Compare new name and scope to existing name and scope key
            if (arrayNameScopeString == urlDecode(newNameScope))
            {
               stringInArray = true;

               // compare
               inheritanceValueArray[i] = newInheritanceValue;
               break;
            }
         }

         // Not in the array
         if (stringInArray == false)
         {
         	inheritanceKeyArray[inheritanceKeyArray.length] = newNameScope;
            inheritanceValueArray[inheritanceValueArray.length] = newInheritanceValue;
         }

         for (var j = 0; j < inheritanceKeyArray.length; j++)
         {
            combinedInheritanceArray[j] = inheritanceKeyArray[j] + ";" + inheritanceValueArray[j];
         }

         document.ModifyAssociationsForm.elements["MemberInheritanceChanged"].value="true";
      	document.ModifyAssociationsForm.elements["MemberInheritanceList"].value=combinedInheritanceArray.join("$");
      }
   }

   /**************************
    * inheritanceScopeChange *
    **************************/
   function inheritanceScopeChange(fullName, scopeName, optionValue, checkboxNumber, assignRightsChanged)
   {
      if (assignRightsChanged == "true")
      {
         var elementCount = document.forms[0].elements.length;
         // Set all select options to wholeSubtree
         for (var i = 0; i < elementCount; i++)
         {
            if (document.forms[0].elements[i].type == "select-one")
            {
               if (document.forms[0].elements[i].name.search("InheritanceScopeBox" + checkboxNumber) != -1)
               {
                  if (optionValue == false)
                  {
                     document.forms[0].elements[i].disabled = true;
                  }
                  else
                  {
                     document.forms[0].elements[i].disabled = false;
                  }
                  break;
               }
            }
         }
      }

      var stringInArray 	= false;
      var newNameScope 		= urlEncode(fullName) + ";" + urlEncode(scopeName);
      newInheritanceValue  = optionValue;

      if (inheritanceKeyArray != null) // Global array of Names and scopes used as key
      {
         // Check array for existing memberId
         for (var i = 0; i < inheritanceKeyArray.length; i++)
         {
            var arrayNameScopeString = inheritanceKeyArray[i];

            // Compare new name and scope to existing name and scope key
            if (arrayNameScopeString == urlDecode(newNameScope))
            {
               stringInArray = true;

               // compare
               inheritanceValueArray[i] = newInheritanceValue;
               break;
            }
         }

         // Not in the array
         if (stringInArray == false)
         {
            inheritanceKeyArray[inheritanceKeyArray.length] = newNameScope;
            //inheritanceValueArray[inheritanceValueArray.length] = newInheritanceValue;
            var rbsIsnvds = "<%= c.var("rbs_isNVDS") %>";
            if (rbsIsnvds == "false")
            {
               if (newInheritanceValue == "wholeSubtree")
               {
                  newInheritanceValue = "true";
               }
               else
               {
                  newInheritanceValue = "false";
               }
            }
            inheritanceValueArray[inheritanceValueArray.length] = newInheritanceValue;
         }

         for (var j = 0; j < inheritanceKeyArray.length; j++)
         {
            combinedInheritanceArray[j] = inheritanceKeyArray[j] + ";" + inheritanceValueArray[j];
         }

         document.ModifyAssociationsForm.elements["MemberInheritanceChanged"].value="true";
      	document.ModifyAssociationsForm.elements["MemberInheritanceList"].value=combinedInheritanceArray.join("$");
      }
   }

   // Returns true if any scope checkboxes are checked
   function rowsAreSelected()
   {
   	var elementCount 	= document.forms[0].elements.length;

      for (var i = 0; i < elementCount; i++)
      {
      	if (document.forms[0].elements[i].type == "checkbox")
        	{
            if (document.forms[0].elements[i].name.search("RowCheckBox") != -1)
	         {
	            if (document.forms[0].elements[i].checked)
	            {
	               return true;
	            }
            }
         }
      }

      return false;
   }

	function setRowCheckBoxValues(checkBoxValue)
   {
   	var elementCount 	= document.forms[0].elements.length;

      // Set all rowCheckBoxes to true
      for (var i = 0; i < elementCount; i++)
      {
      	if (document.forms[0].elements[i].type == "checkbox")
        	{
            if (document.forms[0].elements[i].name.search("RowCheckBox") != -1)
	         {
		         {
		            document.forms[0].elements[i].checked = checkBoxValue;
		         }
            }
         }
      }
   }

   function checkKey(evt)
   {
      var keyCode = evt.which ? evt.which : evt.keyCode;
      if (keyCode == 13)
      {
         <% if (c.var("SelfProvisioningRole").equals("true")) { %>
            addNameButtonSelected();
         <% } else { %>
            addButtonSelected();
         <% } %>

         return false;
      }

      return true;
   }

   function isMemberInTable(member)
   {
	  // Check to see if the scope is assigned to the name
	  var elementCount 	= document.forms[0].elements.length;
	  var duplicateName = false;
      var memberName;

	  for (var j = 0; j < elementCount; j++)
	  {
	   	 if (document.forms[0].elements[j].type == "checkbox")
	     {
	        if (document.forms[0].elements[j].name.search("RowCheckBox") != -1)
	        {
	            memberName	= parseName(document.forms[0].elements[j].value);

	            if (member.toUpperCase() == memberName.toUpperCase())
	            {
	              duplicateName = true;
	              break;
               }
	      	}
	     }
	  }
      return duplicateName;
   }

   function isMemberInArray(member)
   {
	  // Check to see if the scope is assigned to the name
	  var duplicateName = false;

	  for (var j = 0; j < m_aMembers.length; j++)
	  {
         if (member.toUpperCase() == m_aMembers[j].toUpperCase())
         {
            duplicateName = true;
            break;
         }
	  }
      return duplicateName;
   }

   function isScopeAssignedToMember(member, scope)
   {
	   // Check to see if the scope is assigned to the name
	   var elementCount    = document.forms[0].elements.length;
	   var duplicateScope  = false;
      var memberName;
      var memberScope;

      for (var j = 0; j < elementCount; j++)
	   {
	   	if (document.forms[0].elements[j].type == "checkbox")
	     	{
	         if (document.forms[0].elements[j].name.search("RowCheckBox") != -1)
	         {
	            memberName	= parseName(document.forms[0].elements[j].value);
	            memberScope	= parseScope(document.forms[0].elements[j].value);

	            if (member.toUpperCase() == memberName.toUpperCase())
	            {
	               if (scope.toUpperCase() == memberScope.toUpperCase())
	               {
	               	// The name and scope are already in the table
	                  duplicateScope = true;
	                  break;
	               }
	            }
	      	}
	      }
	   }

      return duplicateScope;
   }

   function isScopeInArray(member, scope)
   {
		// Check to see if the scope is assigned to the name
	  	var duplicateScope   = false;
      var memberScopeArray = new Array();

	  	for (var j = 0; j < m_aMembersAndScopes.length; j++)
	  	{
         if (m_aMembersAndScopes[j].toUpperCase().search(member.toUpperCase()) != -1)
         {
            var rbsIsnvds = "<%= c.var("rbs_isNVDS") %>";
            if (rbsIsnvds == "true")
            {
               memberScopeArray = m_aMembersAndScopes[j].split("$,$");
            }
            else
            {
               memberScopeArray = m_aMembersAndScopes[j].split(",");
            }
            //memberScopeArray = m_aMembersAndScopes[j].split(",");
            if (memberScopeArray[1].toUpperCase() == scope.toUpperCase())
            {
               duplicateScope = true;
               break;
            }
         }
	  	}
      return duplicateScope;
   }


   function cleanupMVPackStrings(packString)
   {
      if (packString != null && packString == "PP")
      {
      	return "";
      }
      else
      {
      	return packString;
      }
   }

	function popup(strUrl)
	{
		var strOptions = "location=yes,toolbar=yes,menubar=yes,status=yes,scrollbars=yes,resizable=yes,top=20,left=20,width=800,height=400;";
		window.open(strUrl, "novell", strOptions);
	}


</SCRIPT>
</HEAD>
<BODY TEXT="#000000" LINK="#000000" VLINK="#000000" ALINK="#000000" bgcolor="#FFFFFF" onload="onPageLoad();">
<FORM name="ModifyAssociationsForm" method=post action="webacc" onsubmit="return(checkForMissingScopes())">
   <input type=hidden name="taskId" value="<%= c.var("taskId") %>">
   <input type=hidden name="merge" value="dev.GenConf">
   <input type=hidden name="error" value="dev.MooGenErr">
   <input type=hidden name="User.context" value="<%= c.var("User.context") %>">
   <input type=hidden name="nextState" value="updateModifyRoleAssociations">
   <input type=hidden name="Role.Member.Count" value="<%= c.var("Role.Member.Count") %>">
   <input type=hidden name="DeleteMemberList" value="">
   <input type=hidden name="DeleteMemberListCount" value="">
   <input type=hidden name="ModifyMemberFullName" value="">
   <input type=hidden name="ModifyMemberDisplayName" value="">
   <input type=hidden name="ModifyMemberOldScope" value="">
   <input type=hidden name="ModifyScopeList" value="">
   <input type=hidden name="ModifyMemberInheritance" value="">
   <input type=hidden name="ModifyMemberId" value="">
   <input type=hidden name="MemberInheritanceChanged" value="false">
   <input type=hidden name="MemberInheritanceList" value="">
   <input type=hidden name="MemberAssignRightsChanged" value="false">
   <input type=hidden name="MemberAssignRightsList" value="">
   <input type=hidden name="NewRoleMembers" value="">
   <input type=hidden name="NewMemberAndScope" value="">
   <input type=hidden name="NewMemberList" value="<%= c.var("NewMemberList") %>">
   <input type=hidden name="NewMemberScopeList" value="<%= c.var("NewMemberScopeList") %>">
   <input type=hidden name="RBSAdmin_RoleType" value="<%= c.var("RBSAdmin_RoleType") %>">
   <input type=hidden name="SelfProvisioningRole" value="<%= c.var("SelfProvisioningRole") %>">
   <input type=hidden name="GeneralMsg.Url" value="">
   <input type=hidden name="RoleManagementTask.TreeName" value="<%= c.var("RoleManagementTask.TreeName") %>">
   <input type=hidden name="RBSAdmin_TaskDelegate" value="<%= c.var("RBSAdmin_TaskDelegate") %>">
   <!-- End of hidden tags -->

   <% if (c.var("RBSAdmin_RoleType").equals("iManager")) {
   	   c.set("TaskHeader.title", JSPConduit.toHTML(c.string("ModifyRoleAssociations.ModifyImanagerMembers")));
      } else {
   	   c.set("TaskHeader.title", JSPConduit.toHTML(c.string("ModifyRoleAssociations.ModifyEguideMembers")));
      }
      c.set("TaskHeader.helpFile", "base/modifyroleassociations.html");
	   c.set("TaskHeader.HelpWindowWidth", "500");
	   c.set("TaskHeader.HelpWindowHeight", "500"); %>
   <jsp:include page='<%= c.getPath("dev/TaskHeader_inc.jsp") %>' flush="true" />

   <BR>
   <TABLE width="100%" border="0" cellspacing="0" cellpadding="3">
      <TR bgcolor="#FFFFFF">
	     <TD colspan="2" class="mediumtext" nowrap valign="top"><b><%= JSPConduit.toHTML(c.string("ModifyRoleAssociations.RoleName")) %></b>&nbsp;<%= JSPConduit.toHTML(c.var("RoleDisplayName")) %></TD>
      </TR>
	  	<TR bgcolor="#FFFFFF">
	     <TD colspan="2" nowrap valign="top">&nbsp;</TD>
	  	</TR>
      <TR bgcolor="#FFFFFF">
	     <TD colspan="2" class="instructions" valign="top"><b><%= JSPConduit.toHTML(c.string("RBSManagement.SecurityNote")) %></b> <%= JSPConduit.toHTML(c.string("RBSManagement.SecurityMessage")) %></TD>
      </TR>
      <TR bgcolor="#FFFFFF">
        <TD colspan="2" class="instructions" valign="top"><a href="http://<%= c.string("RBSManagement.SecurityMessageURL") %>" onmouseover="parent.status='http://<%= c.string("RBSManagement.SecurityMessageURL") %>';return true;" onclick="popup('http://<%= c.string("RBSManagement.SecurityMessageURL") %>'); return false;"><%= Utils.toDisplay(c.string("RBSManagement.SecurityMessageURL")) %></a></TD>
      </TR>
      <TR bgcolor="#FFFFFF">
	     <TD colspan="2" nowrap valign="top">&nbsp;</TD>
	  	</TR>
     	<TR bgcolor="#FFFFFF">
	      <TD colspan="2" nowrap valign="top" class="instructions">
				<% if (c.var("SelfProvisioningRole").equals("true")) { %>
            	<%= JSPConduit.toHTML(c.string("ModifyRoleAssociations.EnterOrBrowse_SelfManagement")) %>
            <% } else { %>
            	<%= JSPConduit.toHTML(c.string("ModifyRoleAssociations.EnterOrBrowse")) %>
            <% } %>
				<BR>
			</TD>
	   </TR>
      <TR bgcolor="#FFFFFF">
         <TD colspan="2" nowrap valign="top"><P>&nbsp;</P></TD>
      </TR>
   	  <TR bgcolor="#FFFFFF">
      	<TD class="mediumtext" width="5%" nowrap valign="middle"><%= JSPConduit.toHTML(c.string("ModifyRoleAssociations.NameColon")) %></TD>
      	<TD class="mediumtext" width="70%">
         	<% c.set("MVStringEditor_name", "NameTextField");
               c.set("MVStringEditor_dnMode", "true");
               c.set("MVStringEditor_ignoreCase", "true");
               c.set("MVStringEditor_enforceUnique", "true");
               c.set("MVStringEditor_history", "true");
				   c.set("MVStringEditor_objectTypeName", c.var("RoleMemberFilter"));
               if (c.var("User.interface").equals("browse")) {
            	   c.set("MVStringEditor_size", "5");
               } %>
            <jsp:include page='<%= c.getPath("dev/MVStringEditor_inc.jsp") %>' flush="true" />
         </TD>
      </TR>
    	<% if (c.var("SelfProvisioningRole").equals("true")) { %>
      <TR bgcolor="#FFFFFF">
      	<TD width="5%">&nbsp;</TD>
         <TD width="70%">
      		<a href="#" onClick="javascript:addNameButtonSelected();return false"><IMG src="<%= c.getModulesUrl() + "/dev/images/" + c.string("Button.Add.image") %>" alt="<%= JSPConduit.toHTML(c.string("Button.Add.alt")) %>" title="<%= JSPConduit.toHTML(c.string("Button.Add.alt")) %>" border=0></a>
      	</TD>
      </TR>
      <% } else { %>
      <TR bgcolor="#FFFFFF">
      	<TD class="mediumtext" width="5%" nowrap valign="top"><%= JSPConduit.toHTML(c.string("ModifyRoleAssociations.ScopeColon")) %></TD>
         <TD width="70%">
            <% c.set("MVStringEditor_name", "ScopeTextField");
               c.set("MVStringEditor_dnMode", "true");
               c.set("MVStringEditor_ignoreCase", "true");
               c.set("MVStringEditor_enforceUnique", "true");
               c.set("MVStringEditor_history", "true");
               c.set("MVStringEditor_objectTypeName", c.var("RoleScopeFilter"));
               if (c.var("User.interface").equals("browse")) {
            	   c.set("MVStringEditor_size", "5");
               } %>
            <jsp:include page='<%= c.getPath("dev/MVStringEditor_inc.jsp") %>' flush="true" />
            <a href="#" onClick="javascript:addButtonSelected();return false"><IMG src="<%= c.getModulesUrl() + "/dev/images/" + c.string("Button.Add.image") %>" alt="<%= JSPConduit.toHTML(c.string("Button.Add.alt")) %>" title="<%= JSPConduit.toHTML(c.string("Button.Add.alt")) %>" border=0></a>
			</TD>
		</TR>
      <% } %>
      <TR bgcolor="#FFFFFF">
         <TD nowrap valign="top">&nbsp;</TD>
      </TR>
	</TABLE>
 	<TABLE width="100%" border="0" cellspacing="0" cellpadding="3">
      <TR bgcolor="#FFFFFF">
      	<TD valign="top" colspan="6">
         	<a href="#" onClick="javascript:nameRemoveButtonSelected();return false"><IMG src="<%= c.getModulesUrl() + "/dev/images/" + c.string("Button.RemoveSmall.image") %>" alt="<%= JSPConduit.toHTML(c.string("Button.RemoveSmall.alt")) %>" title="<%= JSPConduit.toHTML(c.string("Button.RemoveSmall.alt")) %>" border=0></a>
      	</TD>
      </TR>
      <TR  bgcolor="#DFDDD5" >
      	<TD width="5%" height="24" class="tablecolumnhead1">
        		<DIV align="center"><input type="checkbox" name="NameCheckBox" value="checkbox" onclick="setRowCheckBoxValues(this.checked)"></DIV>
      	</TD>
   		<TD width="35%" height="24" class="tablecolumnhead1">
     			<DIV align="left"><font color="#FFFFFF"><b><font color="#000000"><%= JSPConduit.toHTML(c.string("ModifyRoleAssociations.Name")) %></font></b></font></DIV>
   		</TD>
   		<TD width="10%" height="24" class="tablecolumnhead1">
     			<DIV align="left"><font color="#FFFFFF"><b><font color="#000000"><%= JSPConduit.toHTML(c.string("ModifyRoleAssociations.Type")) %></font></b></font></DIV>
   		</TD>
   		<TD width="30%" height="24" class="tablecolumnhead1">
     			<DIV align="left"><font color="#FFFFFF"><b><font color="#000000"><%= JSPConduit.toHTML(c.string("ModifyRoleAssociations.Scope")) %></font></b></font></DIV>
   		</TD>
         <TD width="10%" height="24" class="tablecolumnhead1">
     			<DIV align="center" nowrap><font color="#FFFFFF"><b><font color="#000000"><%= JSPConduit.toHTML(c.string("ModifyRoleAssociations.AssignRights")) %></font></b></font></DIV>
   		</TD>
   		<TD width="10%" height="24" class="tablecolumnhead1">
     			<DIV align="center"><font color="#FFFFFF"><b><font color="#000000"><%= JSPConduit.toHTML(c.string("ModifyRoleAssociations.Inheritable")) %></font></b></font></DIV>
   		</TD>
      </TR>
    	<!-- Load table info -->
      <% c.set("i", "0");
         c.set("color", "#FFFFFF");
   	   c.set("previousName", "");
         while (c.lt(c.var("i"), c.var("Role.Member.Count")))
         { %>
            <TR bgcolor=<%= c.var("color") %>>
              <TD class="mediumtext">
                <DIV align="center"><input type="checkbox" name="RowCheckBox<%= c.var("i") %>" width="16" height="16" value="<%= Utils.urlEncode(c.var("Role.Member."+c.var("i")+ ".ScopeFullName")) %>:<%= Utils.urlEncode(c.var("Role.Member."+c.var("i")+ ".FullName")) %>"
                     <% if (c.var("Role.Member."+c.var("i")+ ".ScopeDisplayName").equals("")) { %>
                     checked >
                     <% } else { %>
                        >
                     <% } %>
                  </DIV>
               </TD>
             <TD class="mediumtext">
                  <% if (JSPConduit.toLower(c.var("Role.Member."+c.var("i")+ ".FullName")).equals(JSPConduit.toLower(c.var("previousName")))) { %>
                  &nbsp;
                  <% } else { %>
                  <%= JSPConduit.toHTML(c.var("Role.Member."+c.var("i")+ ".FullName")) %>
                  <% }
                     c.set("previousName", c.var("Role.Member."+c.var("i")+ ".FullName")); %>
              </TD>
             <TD class="mediumtext">
                <IMG name="<%= JSPConduit.toHTML(c.var("Role.Member."+c.var("i")+ ".Type")) %>" alt="<%= JSPConduit.toHTML(c.string("ModifyRoleAssociations.TypeColon")) %> <%= JSPConduit.toHTML(c.var("Role.Member."+c.var("i")+ ".Type")) %>" title="<%= JSPConduit.toHTML(c.string("ModifyRoleAssociations.TypeColon")) %> <%= JSPConduit.toHTML(c.var("Role.Member."+c.var("i")+ ".TypeNoGif")) %>" src="<%= c.getModulesUrl() + "/dev/images/dir/" + c.var("Role.Member."+c.var("i")+ ".Type") %>" border=0>
               <% if (c.var("Role.Member."+c.var("i")+ ".DynamicGroupAux").equals("true")) { %>
               <IMG name="DynamicGroupAux" alt="<%= JSPConduit.toHTML(c.string("ModifyRoleAssociations.TypeDynamicGroupAux")) %>" title="<%= JSPConduit.toHTML(c.string("ModifyRoleAssociations.TypeDynamicGroupAux")) %>" src="<%= c.getModulesUrl() + "/dev/images/dir/dynamicGroup.gif" %>" border=0>
               <% } %>
             </TD>
             <% if (c.var("Role.Member."+c.var("i")+ ".ScopeDisplayName").equals("") == false) { %>
             <TD class="mediumtext">
                  <% if (c.var("SelfProvisioningRole").equals("true")) { %>
                  <%= JSPConduit.toHTML(c.string("RBSManagement.SelfManagement")) %>
                  <% } else { %>
                     <a href="#" onClick="javascript:modifyScopeSelected('<%= JSPConduit.toHTML((Utils.toScript(c.var("Role.Member."+c.var("i")+ ".FullName")))) %>','<%= JSPConduit.toHTML((Utils.toScript(c.var("Role.Member."+c.var("i")+ ".ScopeFullName")))) %>');return false"><%= JSPConduit.toHTML(c.var("Role.Member."+c.var("i")+ ".ScopeDisplayName")) %></a>
               <% } %>
              </TD>
               <TD class="mediumtext">
                <DIV align="center">
                     <input type="checkbox" name="AssignRightsCheckBox<%= c.var("i") %>" onclick="AssignRightsCheckBoxChange('<%= JSPConduit.toHTML((Utils.toScript(c.var("Role.Member."+c.var("i")+ ".FullName")))) %>','<%= JSPConduit.toHTML((Utils.toScript(c.var("Role.Member."+c.var("i")+ ".ScopeFullName")))) %>',this.checked,<%= c.var("i") %>)"
                     <% if (JSPConduit.toHTML(c.var("Role.Member."+c.var("i")+ ".AssignRights")).equals("true"))
                     { %>
                        CHECKED
                     <% } %> width="15%" height="16"
                        >
                  </DIV>
             </TD>
             <TD class="mediumtext">
             <DIV align="center">
             <SELECT name="InheritanceScopeBox<%= c.var("i") %>" size=1 style="WIDTH: 150px" onchange="inheritanceScopeChange('<%= JSPConduit.toHTML((Utils.toScript(c.var("Role.Member."+c.var("i")+ ".FullName")))) %>','<%= JSPConduit.toHTML((Utils.toScript(c.var("Role.Member."+c.var("i")+ ".ScopeFullName")))) %>',this.value, <%= c.var("i") %>, 'false')"
            <% if (c.var("RBSXMLAttributeDefined").equals("true"))
               {
                  if (c.var("SelfProvisioningRole").equals("true"))
                  { %>
                     disabled>
                <%}
                  else if (JSPConduit.toHTML(c.var("Role.Member."+c.var("i")+ ".AssignRights")).equals("false"))
                  { %>
                    disabled>
               <% }
                  else
                  { %>
                    >
               <% } %>
            <% }
               else
               { %>
                  disabled >
            <% }
               c.set("j", "0");
               while (c.lt(c.var("j"), c.var("Role.AclScopeValues.Count")))
               { %>
                  <OPTION value="<%= c.var("Role.AclScopeValue"+c.var("j")) %>"
                     <% if (JSPConduit.toHTML(c.var("Role.Member."+c.var("i")+ ".Inheritance")).equals( c.var("Role.AclScopeValue"+c.var("j"))))
                        { %>
                           selected >
                     <% }
                        else if (JSPConduit.toHTML(c.var("Role.Member."+c.var("i")+ ".Inheritance")).equals("true") && ( c.var("Role.AclScopeValue"+c.var("j"))).equals("wholeSubtree"))
                        { %>
                           selected >
                     <% }
                        else if (JSPConduit.toHTML(c.var("Role.Member."+c.var("i")+ ".Inheritance")).equals("false") && ( c.var("Role.AclScopeValue"+c.var("j"))).equals("baseObject"))
                        { %>
                           selected >
                     <% }
                        else
                        { %>
                          >
                     <% } %>
                        <%= JSPConduit.toHTML(c.string("ModifyRoleAssociations." + c.var("Role.AclScopeValue"+c.var("j")))) %>
                  </OPTION>
                  <% c.inc("j");
               } %>
               </SELECT>
            </DIV>
            </TD>
         <% } else { %>
            <TD class="mediumtext"><%= JSPConduit.toHTML(c.string("ModifyRoleAssociations.NoScope")) %></TD>
            <TD>&nbsp;</TD>
            <TD>&nbsp;</TD>
             <% } %>
        </TR>
   	   <% c.inc("i");
         if (JSPConduit.toLower(c.var("Role.Member."+c.var("i")+ ".FullName")).equals(JSPConduit.toLower(c.var("previousName"))) == false)
         {
            if (c.var("color").equals("#FFFFFF"))
            {
	      	   c.set("color", "#EFEEE9");
	         }
            else
            {
	      	   c.set("color", "#FFFFFF");
	         }
         }
  	  } %>
	</TABLE>
	<BR>
   <TABLE width="100%" border="0" cellspacing="0" cellpadding="0" align="left">
  		<TR>
      	<% if (c.var("SelfProvisioningRole").equals("false")) { %>
         	<TD colspan="2" class="instructions"><%= JSPConduit.toHTML(c.string("ModifyRoleAssociations.Note")) %></TD>
         <% } %>
      </TR>
      <TR>
	      <TD colspan="2">&nbsp;</TD>
	   </TR>
      <TR>
      	<TD align="left" class="ruleabove">
            <a href="#" onClick="javascript:OKButtonClicked();return false"><IMG name="Ok" alt="<%= JSPConduit.toHTML(c.string("Button.OK.alt")) %>" title="<%= JSPConduit.toHTML(c.string("Button.OK.alt")) %>" src="<%= c.getModulesUrl() + "/dev/images/" + c.string("Button.OK.image") %>" border=0></a>
            <jsp:include page='<%= c.getPath("dev/Cancel_inc.jsp") %>' flush="true" />
         </TD>
      </TR>
   </TABLE>
   </FONT>
</FORM>
<jsp:include page='<%= c.getPath("dev/OSFooter_inc.jsp") %>' flush="true" />
</BODY></HTML>
