<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:template match="com.novell.emframe.fw.NetWareServiceLauncher">
		<html>
			<head>
				<META HTTP-EQUIV="Pragma" CONTENT="no-cache"/>
				<META HTTP-EQUIV="Cache-Control" CONTENT="no-cache"/>
				<META HTTP-EQUIV="Pragma" VALUE="no-store"/>
				<META HTTP-EQUIV="Cache-Control" VALUE="no-store"/>
				<META HTTP-EQUIV="expires" CONTENT="0"/>
				<title>
					<xsl:value-of select="$fw.Common.ProductName"/>
				</title>
			</head>
			<xsl:choose>
				<xsl:when test="RequestType='true' or RequestType='1'"><!-- basic authentication -->
					<body bgcolor="#ffffff">
						&#160;
						<script>
							window.open('<xsl:value-of select="wlLoginUrl"/>','_blank','width=800,height=600,resizable=yes,menubar=yes,scrollbars=yes,location=no,status=no,toolbar=yes');
						</script>
						<xsl:call-template name="SwapServiceInfoPage"/>
					</body>
				</xsl:when>
				<!-- stupid iFolder admin -->
				<xsl:when test="formMethod='get' and not(FormParams/Param)"><!-- if the form method is a get & there are not params -->
					<body bgcolor="#ffffff">
						&#160;
						<script>
							window.open('<xsl:value-of select="wlLoginUrl"/>','_blank','width=800,height=600,resizable=yes,menubar=yes,scrollbars=yes,location=no,status=no,toolbar=yes');
						</script>
						<xsl:call-template name="SwapServiceInfoPage"/>
					</body>
				</xsl:when>
				<xsl:otherwise>
					<body bgcolor="#ffffff">
						<form method="{formMethod}" name="Login" target="_blank">
							<xsl:choose>
								<xsl:when test="CustomFormParams">
									<xsl:attribute name="action"><xsl:value-of select="wlLoginUrl"/>?<xsl:value-of select="CustomFormParams"/></xsl:attribute>
								</xsl:when>
								<xsl:otherwise>
									<xsl:attribute name="action"><xsl:value-of select="wlLoginUrl"/></xsl:attribute>
								</xsl:otherwise>
							</xsl:choose>
							<xsl:for-each select="FormParams/Param">
								<input type="hidden" name="{Name}" value="{Value}"/>
							</xsl:for-each>
						</form>
						<script>												
							document.Login.submit();
						</script>
						<xsl:call-template name="SwapServiceInfoPage"/>
					</body>
				</xsl:otherwise>
			</xsl:choose>
		</html>
	</xsl:template>
	<xsl:template name="SwapServiceInfoPage">
		<xsl:if test="string-length(serviceInfoLink) != 0">
			<form method="get" name="Info" action="/welcome/{serviceInfoLink}"/>
			<script>
				document.Info.submit();
			</script>
		</xsl:if>
	</xsl:template>
</xsl:stylesheet>
