<%@  page pageEncoding="utf-8" contentType="text/html;charset=utf-8"
   import="
         java.util.List,
         java.util.Iterator,
         com.novell.emframe.dev.dataTable.*,
         com.novell.emframe.fw.ModuleData,
         com.novell.webaccess.common.JSPConduit"
 %>

<%
   JSPConduit c = JSPConduit.getJSPConduit(request);
   c.stringTable("DevResources");
   c.stringTable("FwResources");
%>
<%@ taglib uri="/WEB-INF/iman.tld" prefix="iman" %>
<%@ taglib uri="/WEB-INF/c.tld" prefix="c" %>

<iman:stringtable bundle="FwResources"/>
<iman:stringtable bundle="DevResources"/>

<HTML>
   <HEAD>
      <iman:eMFrameScripts/>
      <iman:dataTableScripts/>
      <iman:stylesheet/>

      <SCRIPT>

      /*******************
       * FUNCTION HEADER *
       *******************/
      function backToCollectionList()
      {
         var form = document.OutOfDateModules;
         form.nextState.value = "backToCollectionList";
         form.merge.value = "fw.CollectionMain";
         form.submit();
      }

      /*******************
       * FUNCTION HEADER *
       *******************/
      function contentEventHandler(menuItemId, selectedIndices, tableData)
      {
         if(menuItemId=="UpdateModules")
         {
            updateModules(selectedIndices, tableData);
         }
         else if(menuItemId=="UninstallModules")
         {
            uninstallModules(selectedIndices, tableData);
         }

         return;
      }

      /*******************
       * FUNCTION HEADER *
       *******************/
      function updateModules(selectedIndices, tableData)
      {
         if(selectedIndices.length > 0)
         {
            if(confirm("<%= c.string("RBS.UpdateModules") %>"))
            {
               var modulesToUpdate = new Array(selectedIndices.length);

               for(var i=0; i < selectedIndices.length; i++)
               {
                  var index = selectedIndices[i];
                  modulesToUpdate[i] = tableData[index][1];
               }

                  var form = document.OutOfDateModules;
                  form.nextState.value = "delegateOutOfDateModules";
                  form.selectedCollectionName.value = urlEncode("<c:out value="${selectedCollectionName}"/>");
                  form.ModuleListPacked.value = pack(modulesToUpdate);
                  form.submit();
            }
         }
         else
         {
            alert("<%= c.string("RBS.CheckOneOrMoreObjectsToPerformOperation") %>");
         }

         return;
      }

      /*******************
       * FUNCTION HEADER *
       *******************/
      function uninstallModules(selectedIndices, tableData)
      {
         if(selectedIndices.length > 0)
         {
            if(confirm("<%= c.string("RBS.UninstallModules") %>"))
            {
               var modulesToUnInstall = new Array(selectedIndices.length);

               for(var i=0; i < selectedIndices.length; i++)
               {
                  var index = selectedIndices[i];
                  modulesToUnInstall[i] = tableData[index][1];
               }

                  var form = document.OutOfDateModules;
                  form.nextState.value = "delegateInstalledModules";
                  form.selectedCollectionName.value = urlEncode("<c:out value="${selectedCollectionName}"/>");
                  form.ModuleListPacked.value = pack(modulesToUnInstall);
                  form.submit();
            }
         }
         else
         {
            alert("<%= c.string("RBS.CheckOneOrMoreObjectsToPerformOperation") %>");
         }

         return;
      }

      /*******************
       * FUNCTION HEADER *
       *******************/
      function objectSortHandler(tableName, column, direction, tableData)
      {
         var form = document.OutOfDateModules;
         form.nextState.value = "outOfDateModules";
         form.sortModuleStatusColumn.value = column;
         form.sortModuleStatusDirection.value = direction;
         form.merge.value = "fw.OutOfDateModules";
         form.submit();
      }

      </SCRIPT>
   </HEAD>
   <BODY>
      <FORM name="OutOfDateModules">
      <INPUT type="hidden" name="nextState">
      <INPUT type="hidden" name="taskId" value="<c:out value="${taskId}"/>">
      <INPUT type="hidden" name="merge">
      <INPUT type="hidden" name="delegatedFrom"  value="OutOfDateModules">
      <INPUT type="hidden" name="ModuleListPacked">
      <INPUT type="hidden" name="error" value="dev.GenErr">
      <INPUT type="hidden" name="selectedCollectionName" value="<c:out value="${selectedCollectionName}"/>">
      <INPUT type="hidden" name="sortModuleStatusColumn" value="<c:out value="${sortModuleStatusColumn}"/>">
      <INPUT type="hidden" name="sortModuleStatusDirection" value="<c:out value="${sortModuleStatusDirection}"/>">

      <div class="smalltext" style="margin-bottom: 1em">
         <a href="#" onClick="backToCollectionList()"><iman:string key="RBS.Configuration"/></a><img src="/nps/portal/modules/dev/images/breadspace.gif" width="17" height="9" border="0" align="absmiddle" alt=""><iman:string key="RBS.OutOfDateModules"/>
      </div>
         <%
            c.set("taskHeaderTitle", c.string("RBS.CollectionColon") + " " + c.var("selectedCollectionName"));
         %>
         <iman:taskHeader title="${taskHeaderTitle}" iconUrl="dev/dir/rbsCollection2.gif" helpFile="fw/outofdatemodules.html" /><BR>
         <iman:include page="dev/Messagebar_inc.jsp"/>
         <div class="formdescriptextml0" style="width: 80%"><iman:string key="RBS.OutOfDateModulesInstructions"/></div>

         <iman:dataTable id="myTable" titleKey="RBS.OutOfDateModules" tableData="${tableData}" menuActionHandler="contentEventHandler" sortHandler="objectSortHandler" sortedColumn="${sortModuleStatusColumn}" sortedDirection="${sortModuleStatusDirection}">
            <iman:menuItem textKey="RBS.Update" id="UpdateModules"/>
            <iman:menuItem textKey="RBS.Uninstall" id="UninstallModules"/>

            <iman:columnHeader textKey="RBS.Type" sortable="false"/>
            <iman:columnHeader textKey="RBS.Name"/>
            <iman:columnHeader textKey="RBSConfiguration.InstalledVersion"/>
            <iman:columnHeader textKey="RBSConfiguration.AvailableVersion"/>
         </iman:dataTable>

         <iman:spacer/>
         <iman:bar/>
         <iman:button key="Close" onClick="backToCollectionList(); return false;"/>
      </FORM>
   </BODY>
</HTML>
