<%@  page pageEncoding="utf-8" contentType="text/html;charset=utf-8" import="com.novell.webaccess.common.JSPConduit, com.novell.emframe.dev.eMFrameUtils" %>
<%   JSPConduit c = JSPConduit.getJSPConduit(request);
   c.stringTable("DevResources");
   c.stringTable("FwResources"); %>
<HTML>
<HEAD>
<TITLE><%= c.toHTML(c.string("OwnedCollections")) %></TITLE>
<LINK   href="<%= c.getModulesUrl() + "/dev/css/hf_style.css" %>"
        rel="styleSheet"
        type="text/css">

<jsp:include page='<%= c.getPath("dev/MoveListItems_inc.jsp") %>' flush="true" />
<jsp:include page='<%= c.getPath("dev/eMFrameScripts_inc.jsp") %>' flush="true" />
<jsp:include page='<%= c.getPath("dev/OSScripts_inc.jsp") %>' flush="true" />

<script language="JavaScript">


   /*******************
    * FUNCTION HEADER *
    *******************/
    function onPageLoad()
    {
        var list = document.OwnedCollections.CollectionList;

        if( list.length > 0 )
        {
            list.options[0].selected=true;
        }
    }


    /*******************
    * FUNCTION HEADER *
    *******************/
    function addElement(controlName, resultsArray)
    {
        var list = document.OwnedCollections.CollectionList;

        // If no new items just return
        if(resultsArray.length == 0)
        {
            return;
        }

        // Remove empty list bracket
        if( (resultsArray.length > 0) && (list.length > 0) &&
            (list.options[0].text == emptyListBracket))
        {
            list.options[0] = null;
        }

        // Add the new items to the list
        for(var count = 0; count < resultsArray.length; count++)
        {
            var string = resultsArray[count];
            var addFlag = "true";

            for(var index = 0; index < list.length; index++)
            {
                if(string == list.options[index].value)
                {
                    alert("<%= c.string("RBSCollectionName.SelectionExist") %>");
                    addFlag = "false";
                    break;
                }
            }

            if(addFlag == "true")
            {
                newOption = new Option(string, string);
                list.options[list.length] = newOption;
                // Sort theList
                sortLists(list.options);
                document.OwnedCollections.elements["OwnedCollectionsFormChanged"].value = "true";
            }
        }

        // Set the selected item
        if(list.selectedIndex >= 0)
        {
            list.options[list.selectedIndex].selected=true;
        }
        else
        {
            list.options[0].selected=true;
        }
    }


   /*******************
    * FUNCTION HEADER *
    *******************/
    function removeElement()
    {
        var list = document.OwnedCollections.CollectionList;

        if((list.selectedIndex == -1) || (list.options[0].text == emptyListBracket))
        {
            return;
        }

        if(confirm("<%= c.string("RBSCollectionName.ConfirmDelete") %>")== false)
        {
            return;
        }

        var index = -1;
        for(var i = (list.length - 1); i >= 0; i--)
        {
            if(list.options[i].selected)
            {
                if(index == -1)
                {
                    index = i;
                }
                // Remove the selected item from the list
                list.options[i] = null;
                document.OwnedCollections.elements["OwnedCollectionsFormChanged"].value = "true";
            }
        }

	    // Set empty list bracket
        if (list.length == 0)
        {
            index = 0;
            newoption = new Option(emptyListBracket, "", false, false);
            list.options[0] = newoption;
        }

        // Sort the list
        sortLists(list.options);

        // Set the focus to the fromList and set the next option as selected
        list.focus();
        if(list.length > 0)
        {
            if((list.length-1) < index)
            {
                list.options[list.length-1].selected = true;
            }
            else
            {
                list.options[index].selected = true;
            }
        }
    }


   /*******************
    * FUNCTION HEADER *
    *******************/
    function onPageSubmit()
    {
        var list = document.OwnedCollections.CollectionList;

        // Get everything in the list
        listArray = new Array(list.length);

        for (i = 0; i < list.length; i++)
        {
            if (list.options[i].text != emptyListBracket)
            {
                listArray[i] = urlEncode(list.options[i].value);
            }
        }

        // Convert array into delimited string to be passed into the java file
        var strOwnedCollections = listArray.join(";");
        document.OwnedCollections.elements["OwnedCollectionsString"].value = strOwnedCollections;

        document.OwnedCollections.submit();
    }


</SCRIPT>
</HEAD>

<BODY   TEXT="#000000" LINK="#000000" VLINK="#000000" ALINK="#000000" bgcolor="#FFFFFF"
        onLoad="returnFromOS();onPageLoad()">

<FORM   name="OwnedCollections"
        method=post
        action="webacc">


        <input  type=hidden
                name="taskId"
                value="<%= c.var("taskId") %>">

        <input  type=hidden
                name="merge"
                value="dev.GenConf">

        <input  type=hidden
                name="error"
                value="dev.GenErr">

        <input  type=hidden
                name="User.context"
                value="<%= c.var("User.context") %>">

        <input  type=hidden
                name="nextState"
                value="saveList">

        <input   type=hidden
                name="OwnedCollectionsString"
                value="">

        <input  type=hidden
                name="OwnedCollectionsFormChanged"
                value="false">

   <% c.set("TaskHeader.title", c.string("OwnedCollections"));
      c.set("TaskHeader.iconUrl", "dir/rbsCollection2.gif");
      c.set("TaskHeader.helpFile", "base/modifycollectionowners.html"); %>
   <jsp:include page='<%= c.getPath("dev/TaskHeader_inc.jsp") %>' flush="true" /><BR>

   <TABLE border="0" cellspacing="0" >
      <TR>
            <TD class="mediumtext">
                <B><%= c.string("GetOwnerName.EnterOwnerObject") %></B>&nbsp;<%= c.toHTML(c.var("RBSCollectionContext")) %>
            </td>
      </TR>
        <TR>
            <TD class="mediumtext">
                &nbsp;
            </td>
        </TR>
      <TR>
        <TD class="mediumtext" valign=bottom>
            <%= c.string("GetMemberName.Collection") %>
        </TD>
      </TR>
   </table>
    <TABLE border="0" cellspacing="0" >
        <TR>
            <TD align=right valign=top>
                <SELECT name="CollectionList" size=10 style="WIDTH: 250px" multiple>
                    <% c.set("i", "0");
                       if (c.var("Owned.CollectionList.Count").equals("0")) { %>
                        <OPTION value=""><%= c.toHTML(c.string("Generic.EmptyListBracket")) %>
                    <% }
                       while (c.lt(c.var("i"), c.var("Owned.CollectionList.Count"))) { %>
                        <OPTION value="<%= c.toHTML(c.var("Owned.CollectionList."+c.var("i"))) %>"><%= c.toHTML(c.var("Owned.CollectionList."+c.var("i"))) %>
                        <% c.inc("i");
                       } %>
                </SELECT>
            </TD>
            <TD align=left valign=top>
                <TABLE border=0>
                    <TR>
                        <TD>
                            <% c.set("OS.TypeFilter", "rbsCollection2");
                               c.set("OS.Mode", "Search");
                               c.set("OS.IconName", "dev/images/iconadd.gif");
                               c.set("OS.CallBack", "addElement");
                               c.set("OS.Control", "CollectionList");
                               c.set("OS.MultiSelect", "true");
                               c.set("OS.History", "true"); %>
                            <jsp:include page='<%= c.getPath("dev/OS_inc.jsp") %>' flush="true" />
                        </TD>
                    </TR>
                    <TR>
                        <TD>
                            <a href="#" onClick="javascript:removeElement();return false">
                            <IMG src="<%= c.getModulesUrl() + "/dev/images/iconremove.gif" %>" alt="<%= c.string("Button.Delete.alt") %>" title="<%= c.string("Button.Delete.alt") %>" border=0></a>
                        </TD>
                    </TR>
                </TABLE>
            </TD>
        </TR>
        <TR>
            <TD class="mediumtext">
                &nbsp;
            </td>
        </TR>
    </TABLE>
   <jsp:include page='<%= c.getPath("dev/Bar_inc.jsp") %>' flush="true" />
    <a href="#" onClick="javascript:onPageSubmit();return false">
    <IMG src="<%= c.getModulesUrl() + "/dev/images/" + c.string("Button.OK.image") %>" alt="<%= c.string("Button.OK.alt") %>" title="<%= c.string("Button.OK.alt") %>" border=0></a>
    <jsp:include page='<%= c.getPath("dev/Cancel_inc.jsp") %>' flush="true" />
</FORM>
<jsp:include page='<%= c.getPath("dev/OSFooter_inc.jsp") %>' flush="true" />
</BODY></HTML>
