<%@  page pageEncoding="utf-8" contentType="text/html;charset=utf-8" import="com.novell.webaccess.common.JSPConduit, com.novell.emframe.dev.eMFrameUtils" %>
<%   JSPConduit c = JSPConduit.getJSPConduit(request);

  /* **************************************************************************
%name: WizNavigation_js.jsp %
%version: 5 %
%date_modified: Mon Feb 24 10:02:50 2003 %
Copyright (c) 2001, 2002 Novell, Inc. All Rights Reserved.
THIS WORK IS AN UNPUBLISHED WORK AND CONTAINS CONFIDENTIAL PROPRIETARY
AND TRADE SECRET INFORMATION OF NOVELL, INC. ACCESS TO THIS WORK IS
RESTRICTED TO (I) NOVELL, INC. EMPLOYEES WHO HAVE A NEED TO KNOW HOW
TO PERFORM TASKS WITHIN THE SCOPE OF THEIR ASSIGNMENTS AND (II)
ENTITIES OTHER THAN NOVELL, INC. WHO HAVE ENTERED INTO APPROPRIATE
LICENSE AGREEMENTS. NO PART OF THIS WORK MAY BE USED, PRACTICED,
PERFORMED COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED, ABRIDGED,
CONDENSED, EXPANDED, COLLECTED, COMPILED, LINKED, RECAST, TRANSFORMED
OR ADAPTED WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE
OR EXPLOITATION OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE
PERPETRATOR TO CRIMINAL AND CIVIL LIABILITY.
***************************************************************************  */


  /* --------------------------------------------------------------  */
  /* This file contains JavaScript specific to the navigation panel. */
  /* --------------------------------------------------------------  */

  /* Global Variables.  */

  /* The following object is used to track navigation data so that we  */
  /* don"t update the navigation panel unless it"s changing.           */%>
var oWiz_NavData = null;

<%/* The following objects are used to track the button images.  */%>
var m_backBtnImage				= new Image();
var m_backBtnDisabledImage		= new Image();
var m_closeBtnImage				= new Image();
var m_closeBtnDisabledImage		= new Image();
var m_nextBtnImage				= new Image();
var m_nextBtnDisabledImage		= new Image();
var m_startBtnImage			    = new Image();
var m_startBtnDisabledImage	    = new Image();


<%/* -------------------------------  */
  /* Enables/disables a push button.  */
  /* -------------------------------  */%>
function enableDisableButton(
	sBN,	<%/* The name of the push button to enable/disable.         */%>
	bState)	<%/* True -> Enable the push button.  False -> Disable it.  */%>
{
	var xi;
	var i;


	<%/* Get the image element for the button.  */%>
	i = getButtonImage( sBN );
	if (null == i)
	{
		return;
	} <%/* if  */


	  /* Get the image for the button.  */%>
	if (bState)
	     xi = getButtonEnabledImage(  sBN );
	else xi = getButtonDisabledImage( sBN );
	if (null == xi)
	{
		return;
	} <%/* if  */


	  /* Change the image used by the button to the disabled image.  */%>
	i.src = xi.src;
} <%/* enableDisableButton  */



  /* ---------------------------------------------  */
  /* Returns the disabled image for a push button.  */
  /* ---------------------------------------------  */%>
function getButtonDisabledImage(
	sBN)	<%/* The name of the push button whose disabled image is being requested.  */%>
{
	var	i;


	if      ("WizPB_Back"  == sBN) i = m_backBtnDisabledImage;
	else if ("WizPB_Close" == sBN) i = m_closeBtnDisabledImage;
	else if ("WizPB_Next"  == sBN) i = m_nextBtnDisabledImage;
	else if ("WizPB_Start" == sBN) i = m_startBtnDisabledImage;
	else                             i = null;

	return i;
} <%/* getButtonDisabledImage  */



  /* --------------------------------------------  */
  /* Returns the enabled image for a push button.  */
  /* --------------------------------------------  */%>
function getButtonEnabledImage(
	sBN)	<%/* The name of the push button whose enabled image is being requested.  */%>
{
	var	i;


	if      ("WizPB_Back"  == sBN) i = m_backBtnImage;
	else if ("WizPB_Close" == sBN) i = m_closeBtnImage;
	else if ("WizPB_Next"  == sBN) i = m_nextBtnImage;
	else if ("WizPB_Start" == sBN) i = m_startBtnImage;
	else                             i = null;

	return i;
} <%/* getButtonEnabledImage  */



  /* -------------------------------------------  */
  /* Returns the image Element of a push button.  */
  /* -------------------------------------------  */%>
function getButtonImage(
	sBN)	<%/* The name of the push button whose Element is being requested.  */%>
{
	var	e;


	if      ("WizPB_Back"  == sBN) e = document.WizPB_Back;
	else if ("WizPB_Close" == sBN) e = document.WizPB_Close;
	else if ("WizPB_Next"  == sBN) e = document.WizPB_Next;
	else if ("WizPB_Start" == sBN) e = document.WizPB_Start;
	else                             e = null;

	return e;
} <%/* getButtonImage  */



  /* --------------------------------------------------------  */
  /* Returns true if a button is enabled and false otherwise.  */
  /* --------------------------------------------------------  */%>
function getButtonState(
	sBN)	<%/* The name of the button whose state is being queried.  */%>
{
	<%/* Are we running in wizard mode?  */
	   if ( c.def("Wiz.Wizard")) { %>
		var	bState = false;


		<%/* Yes!  Return what we think the button state currently is.  */%>
		if (null != oWiz_NavData)
		{
			if      ("WizPB_Back"  == sBN) bState = oWiz_NavData.disableBack;
			else if ("WizPB_Close" == sBN) bState = oWiz_NavData.disableClose;
			else if ("WizPB_Next"  == sBN) bState = oWiz_NavData.disableNext;
			else if ("WizPB_Start" == sBN) bState = oWiz_NavData.disableFinish;
		} <%/* if  */%>

		return (!bState);

	<% } else {
		  /* No, we aren"t running in wizard mode!  All buttons are  */
		  /* always assumed to be enabled.                           */%>
		return( true );
	<% } %>
} <%/* getButtonState  */



  /* ------------------------------------------------------------------  */
  /* If the back button is enabled, forces its action to occur.          */
  /*                                                                     */
  /* Returns false if the key was handled and true otherwise.  Although  */
  /* this may be contrary to what you would expect it to return, this    */
  /* value is directly returnable to an onKeyDown handler.               */
  /* ------------------------------------------------------------------  */%>
function handleBackPB()
{
	<%/* Are we running in wizard mode?  */
	   if ( c.def("Wiz.Wizard")) {
		  /* Is back processing enabled?  */%>
		if ((null != oWiz_NavData) &&
			 (!oWiz_NavData.disableBack))
		{
			<%/* Yes!  Perform a back .  */%>
			handleNavigationPB( "WizPB_Back" );
		} <%/* if  */


		  /* We always return false since we never want the browser to do  */
		  /* back processing.                                              */%>
		return( false );

	<% } else {
		  /* No, we aren"t running in wizard mode!  There is no back  */
		  /* handling.                                                */%>
		return( true );
	<% } %>
} <%/* handleBackPB  */



  /* ------------------------------------------------------------------  */
  /* If the cancel/close button is enabled, forces its action to occur.  */
  /*                                                                     */
  /* Returns false if the key was handled and true otherwise.  Although  */
  /* this may be contrary to what you would expect it to return, this    */
  /* value is directly returnable to an onKeyDown handler.               */
  /* ------------------------------------------------------------------  */%>
function handleCancelPB()
{
	var	bReply;


	<%/* Are we running in wizard mode?  */
	   if ( c.def("Wiz.Wizard")) {
		  /* Is cancel/close processing enabled?  */%>
		bReply =
			((null == oWiz_NavData) ||
			 oWiz_NavData.disableClose);

		if (!bReply)
		{
			<%/* Yes!  Perform a cancel/close.  */%>
			handleNavigationPB( "WizPB_Close" );
		} <%/* if  */

	   } else {
		  /* No, we aren"t running in wizard mode!  Treat this as  */
		  /* though the close push button was pressed.             */%>
		handleNavigationPB( "WizPB_Close" );
		bReply = false;
	<% } %>

	return( bReply );
} <%/* handleCancelPB  */



  /* ------------------------------------------------------------------  */
  /* If the next button is enabled, forces its action to occur.          */
  /*                                                                     */
  /* Returns false if the key was handled and true otherwise.  Although  */
  /* this may be contrary to what you would expect it to return, this    */
  /* value is directly returnable to an onKeyDown handler.               */
  /* ------------------------------------------------------------------  */%>
function handleDefaultPB()
{
	var	bReply;


	<%/* Are we running in wizard mode?  */
	   if ( c.def("Wiz.Wizard")) {
		  /* Is next processing enabled?  */%>
		bReply =
			((null == oWiz_NavData) ||
			 oWiz_NavData.disableNext);

		if (!bReply)
		{
			<%/* Yes!  Perform a next.  */%>
			handleNavigationPB( "WizPB_Next" );
		} <%/* if  */

	   } else {
		  /* No, we aren"t running in wizard mode!  Treat this as  */
		  /* though the OK push button was pressed.                */%>
		handleNavigationPB( "WizPB_Ok" );
		bReply = false;
	<% } %>

	return( bReply );
} <%/* handleDefaultPB  */



  /* -------------------------------------------------  */
  /* Handles a navigation push button getting pressed.  */
  /* -------------------------------------------------  */%>
function handleNavigationPB(
	sPB)	<%/* The name of the navigation push button causing this function to be called.  */%>
{
	<%/* This function works on the main  form.  */%>
	with (getMainWizForm())
	{
		<%/* Is this button enabled?  */%>
		if (getButtonState( sPB ))
		{
			<%/* Yes!  Treat start...  */%>
			if ("WizPB_Start" == sPB)
			{
				<%/* ...as finish.  */%>
				sPB = "WizPB_Finish";
			} <%/* if  */

			  /* Track which button was pressed.  */%>
			Hidden_PBNavigation.value = sPB;

			if ( "WizPB_Close" == sPB )
			{
				performReturn();
				return;
			}

			<%/* Is the form valid?  */%>
			if (parent.window.Wiz_ContentFrame.validateForm())
			{
				<%/* Yes!  Submit it.  */%>
				submitMain();
			} <%/* if  */%>
		} <%/* if  */%>
	} <%/* with  */%>
} <%/* handleNavigationPB  */



  /* ---------------------------------  */
  /* Initializes the navigation panel.  */
  /* ---------------------------------  */%>
function initializeNavigationPanel()
{
	<%/* Load the images we need for the navigation panel.  */%>
	m_backBtnImage.src 			= "<%= c.getModulesUrl() %>/fw/images/wiz_Back_<%= c.string("CfgWiz.LangID") %>.gif";
	m_backBtnDisabledImage.src	= "<%= c.getModulesUrl() %>/fw/images/wiz_BackDis_<%= c.string("CfgWiz.LangID") %>.gif";
	m_closeBtnImage.src			= "<%= c.getModulesUrl() %>/fw/images/wiz_Close_<%= c.string("CfgWiz.LangID") %>.gif";
	m_closeBtnDisabledImage.src	= "<%= c.getModulesUrl() %>/fw/images/wiz_CloseDis_<%= c.string("CfgWiz.LangID") %>.gif";
	m_nextBtnImage.src			= "<%= c.getModulesUrl() %>/fw/images/wiz_Next_<%= c.string("CfgWiz.LangID") %>.gif";
	m_nextBtnDisabledImage.src	= "<%= c.getModulesUrl() %>/fw/images/wiz_NextDis_<%= c.string("CfgWiz.LangID") %>.gif";
	m_startBtnImage.src			= "<%= c.getModulesUrl() %>/fw/images/wiz_Start_<%= c.string("CfgWiz.LangID") %>.gif";
	m_startBtnDisabledImage.src	= "<%= c.getModulesUrl() %>/fw/images/wiz_StartDis_<%= c.string("CfgWiz.LangID") %>.gif";


	<%/* Ensure the buttons are positioned correctly.  */%>
	showDisabledButtons();


	<%/* Tell the frameset that another frameset component has  */
	  /* loaded.                                                     */%>
	parent.window.frameLoaded( "Wiz_NavigationFrame" );
} <%/* initializeNavigationPanel  */



  /* -----------------------------------------------------------  */
  /* Forces navigation frame to update using modified navigation  */
  /* information.                                                 */
  /* -----------------------------------------------------------  */%>
function modifyNavigation(
	oData)	<%/* Object containing the navigation information for modifying.  */%>
{
	<%/* Were we given navigation data to modify?  */%>
	if (null == oData)
	{
		<%/* No!  Bail.  */%>
		return;
	} <%/* if  */


	  /* Is there existing navigation data to modify?  */%>
	if (null != oWiz_NavData)
	{
		<%/* Yes!  Merge it into the modify data.  */%>
		if (!(isDefined( oData.disableBack   ))) oData.disableBack   = oWiz_NavData.disableBack;
		if (!(isDefined( oData.disableClose  ))) oData.disableClose  = oWiz_NavData.disableClose;
		if (!(isDefined( oData.disableFinish ))) oData.disableFinish = oWiz_NavData.disableFinish;
		if (!(isDefined( oData.disableNext   ))) oData.disableNext   = oWiz_NavData.disableNext;
	} <%/* if  */


	  /* Finally, use the modified navigation data to update the  */
	  /* navigation buttons.                                      */%>
	updateNavigation( oData );
} <%/* modifyNavigation  */



  /* --------------------------------------------------------------  */
  /* Compares two navigation data items and returns true if they"re  */
  /* equal and false otherwise.                                      */
  /* --------------------------------------------------------------  */%>
function navDataEqual(
	oData1,	<%/* The first  navigation data to compare.  */%>
	oData2)	<%/* The second navigation data to compare.  */%>
{
	<%/* If one or the other is null...  */%>
	if ((null == oData1) || (null == oData2))
	{
		<%/* ...they both must be null to be equal.  */%>
		return( oData1 == oData2 );
	} <%/* if  */


	  /* The data objects contain the same settings...  */%>
	if ((oData1.disableBack   == oData2.disableBack)   &&
		(oData1.disableClose  == oData2.disableClose)  &&
		(oData1.disableFinish == oData2.disableFinish) &&
		(oData1.disableNext   == oData2.disableNext))
	{
		<%/* ...return true...  */%>
		return( true );
	} <%/* if  */

	  /* ...otherwise, return false  */%>
	return( false );
} <%/* navDataEqual  */



  /* -------------------------------------------------------------  */
  /* Normalizes (i.e., ensures everything is defined) a navigation  */
  /* data object.                                                   */
  /* -------------------------------------------------------------  */%>
function normalizeNavData(
	oData) <%/* The navigation data object to normalize.  */%>
{
	var	r;


	<%/* Defined a navigation object if we weren"t given one...  */%>
	if (null == oData)
	     r = new Object();
	else r = oData;

	<%/* ...make sure everything is defined...  */%>
	if (!(isDefined( r.disableBack   ))) r.disableBack   = false;
	if (!(isDefined( r.disableClose  ))) r.disableClose  = false;
	if (!(isDefined( r.disableFinish ))) r.disableFinish = false;
	if (!(isDefined( r.disableNext   ))) r.disableNext   = false;

	<%/* ...and return the normalized object.  */%>
	return( r );
} <%/* normalizeNavData  */



  /* ----------------------------------  */
  /* Shows all of the disabled buttons.  */
  /* ----------------------------------  */%>
function showDisabledButtons()
{
	var	oData;


	<%/* Disable the buttons.  */%>
	oData               = new Object();
	oData.disableBack   = true;
	oData.disableClose  = true;
	oData.disableFinish = true;
	oData.disableNext   = true;
	updateNavigation( oData );
} <%/* showDisabledButtons  */



  /* ------------------------------------------------------  */
  /* Forces navigation frame to update using new navigation  */
  /* information.                                            */
  /* ------------------------------------------------------  */%>
function updateNavigation(
	oData)	<%/* Object containing the navigation information for updating.  */%>
{
	<%/* This function works on the navigation form.  */%>
	with (getNavigationWizForm())
	{
		var	i;
		var	u;


		<%/* If we"re updating the navigation panel to contain the same  */
		  /* thing it"s already displaying...                            */%>
		oData = normalizeNavData( oData );
		if (navDataEqual( oData, oWiz_NavData ))
		{
			<%/* ...ignore the request.  */%>
			return;
		} <%/* if  */%>
		oWiz_NavData = oData;


		<%/* Enable/disable the push buttons as per the request.  */%>
		enableDisableButton( "WizPB_Back",   !oData.disableBack   );
		enableDisableButton( "WizPB_Close",  !oData.disableClose  );
		enableDisableButton( "WizPB_Next",   !oData.disableNext   );
		enableDisableButton( "WizPB_Start",  !oData.disableFinish );
	} <%/* with  */%>
} <%/* updateNavigation  */



						     /* * * * * * *  */
                             /* End of File  */
                             /* * * * * * *  */%>
