<%@  page pageEncoding="utf-8" contentType="text/html;charset=utf-8" import="com.novell.webaccess.common.JSPConduit, com.novell.emframe.dev.eMFrameUtils" %>
<%   JSPConduit c = JSPConduit.getJSPConduit(request);

  /* **************************************************************************
%name: WizUtil_js.jsp %
%version: 8 %
%date_modified: Tue Jun  3 11:30:37 2003 %
Copyright (c) 2001, 2002 Novell, Inc. All Rights Reserved.
THIS WORK IS AN UNPUBLISHED WORK AND CONTAINS CONFIDENTIAL PROPRIETARY
AND TRADE SECRET INFORMATION OF NOVELL, INC. ACCESS TO THIS WORK IS
RESTRICTED TO (I) NOVELL, INC. EMPLOYEES WHO HAVE A NEED TO KNOW HOW
TO PERFORM TASKS WITHIN THE SCOPE OF THEIR ASSIGNMENTS AND (II)
ENTITIES OTHER THAN NOVELL, INC. WHO HAVE ENTERED INTO APPROPRIATE
LICENSE AGREEMENTS. NO PART OF THIS WORK MAY BE USED, PRACTICED,
PERFORMED COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED, ABRIDGED,
CONDENSED, EXPANDED, COLLECTED, COMPILED, LINKED, RECAST, TRANSFORMED
OR ADAPTED WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE
OR EXPLOITATION OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE
PERPETRATOR TO CRIMINAL AND CIVIL LIABILITY.
***************************************************************************  */

/* ---------------------------------------  */
/* Can a form element respond to an enter?  */
/* ---------------------------------------  */%>
function canEnter(
	e)	<%/* Can this form element respond to an enter?  */%>
{
	<%/* Anchor and push button form elements can respond to enters.  */%>
	return( isAnchor( e ) || isPB( e ) );
} <%/* canEnter  */


/* ------------------------  */
/* Is an element an anchor?  */
/* ------------------------  */%>
function isAnchor(
	e)	<%/* Element to check for being an anchor.  */%>
{
	var	bReply;


	<%/* Were we given an element to check?  */%>
	bReply = (null != e);
	if (bReply)
	{
		var	sT;


		<%/* Yes!  Does it have a tagName?  */%>
		sT     = e.tagName;
		bReply = hasString( sT );
		if (bReply)
		{
			<%/* Yes!  Is it an anchor?  */%>
			bReply = (("a" == sT) || ("A" == sT));
		} <%/* if  */%>
	} <%/* if  */


		/* If we get here, bReply is true if e is an anchor and false  */
		/* otherwise.  Return it.                                      */%>
	return( bReply );
} <%/* isAnchor  */

  /* ---------------------------------  */
  /* Can a form element be typed into?  */
  /* ---------------------------------  */%>
function canType(
	e)	<%/* Can this form element be typed into?  */%>
{
	var	sT;


	<%/* If the element is not defined or is disabled...  */%>
	if ((null == e) || e.disabled)
	{
		<%/* ...it can"t be typed into.  */%>
		return( false );
	} <%/* if  */


	  /* ...otherwise, file, text and password elements can be typed  */
	  /* ...into.                                                     */%>
	sT = e.type;
	return(
		("file"     == e.type) ||
		("text"     == e.type) ||
		("textarea" == e.type) ||
		("password" == e.type));
} <%/* canType  */



  /* --------------------------------------------------------------  */
  /* Returns an Object containing information about how to center a  */
  /* window on the screen.                                           */
  /* --------------------------------------------------------------  */%>
function centeredWindowInfo(
	cx,	<%/* Width  of window.  */%>
	cy)	<%/* Height of window.  */%>
{
	var	oReply;
	var	wsh;
	var	wsw;


	<%/* Range check the cx/cy values passed in.  */%>
	wsh = window.screen.height; if (cy > wsh) cy = wsh;
	wsw = window.screen.width;  if (cx > wsw) cx = wsw;


	<%/* Allocate a reply object...  */%>
	oReply = new Object();

	<%/* ...initialize...  */%>
	oReply.cx = cx;
	oReply.cy = cy;
	oReply.x  = ((wsw - cx) / 2);
	oReply.y  = ((wsh - cy) / 2);

	<%/* ...and return it.  */%>
	return( oReply );
} <%/* centeredWindowInfo  */



  /* ----------------------------------------------------  */
  /* Checks a radio button from a group of radio buttons.  */
  /* ----------------------------------------------------  */%>
function checkRB(
	sRB,		<%/* The name of the radio button group and item is to be checked in.  */%>
	sRBValue)	<%/* The radio button to check.                                        */%>
{
	<%/* This function works on the main form.  */%>
	with (getMainWizForm())
	{
		var	i;


		<%/* Scan the document for all widgets in the group of radio  */
		  /* radio buttons...                                         */%>
		for (i = 0; i < elements.length; i += 1)
		{
			<%/* ...is this the radio button that"s supposed to  */
			  /* ...be checked?                                  */%>
			if ((elements[i].name  == sRB) &&
				(elements[i].value == sRBValue))
			{
				<%/* Yes!  Check it and bail.  */%>
				elements[i].checked = true;
				break;
			} <%/* if  */%>
		} <%/* for  */%>
	} <%/* with  */%>
} <%/* checkRB  */



  /* --------------------------------------------------  */
  /* Return various forms from any of the panels.  */
  /* --------------------------------------------------  */%>
function getBannerWizForm()     {return( getWizForm_Impl( "Wiz_BannerForm"     ));}
function getMainWizForm()       {return( getWizForm_Impl( "Wiz_MainForm"       ));}
function getNavigationWizForm() {return( getWizForm_Impl( "Wiz_NavigationForm" ));}
function getQuestionWizForm()   {return( getWizForm_Impl( "Wiz_QuestionForm"   ));}
function getReturnWizForm()     {return( getWizForm_Impl( "Wiz_ReturnForm"     ));}



<%/* ----------------------------------------------------  */
  /* Returns an element by name from the main Wiz form.  */
  /* ----------------------------------------------------  */%>
function getWizElement(
	eName,		<%/* The name of the element to get.                                  */%>
	fGetForm)	<%/* The function to call to access the form containing the element.  */%>
{
	<%/* We"re we given the function to call to access the element"s  */
	  /* form?                                                        */%>
	if ((!(isDefined( fGetForm ))) || (null == fGetForm))
	{
		<%/* No!  Default to the main Wiz form.  */%>
		fGetForm = getMainWizForm;
	} <%/* if  */


	  /* This function works on the main Wiz form.  */%>
	with (fGetForm())
	{
		var	eElement;
		var	i;


		<%/* Scan the form"s elements.  */%>
		for (i = 0; i < elements.length; i += 1)
		{
			<%/* Is this form element the one in question?  */%>
			eElement = elements[i];
			if (eElement.name == eName)
			{
				<%/* Yes!  Return it.  */%>
				return( eElement );
			} <%/* if  */%>
		} <%/* for  */


		  /* If we get here, we couldn"t find the element.  Return  */
		  /* null.                                                  */%>
		return( null );
	} <%/* with  */%>
} <%/* getWizElement  */



  /* --------------------------------------------------------  */
  /* Returns a named form from any of the panels. 			 */
  /* --------------------------------------------------------  */%>
function getWizForm_Impl(
	sForm)	<%/* The form being requested.  */%>
{
	var	oReply;


	<%/* Do we have the name of a form to return?  */%>
	oReply = null;
	if (hasString( sForm ))
	{
		<%/* Yes!  Is the banner form being requested?  */%>
		if ("Wiz_BannerForm" == sForm)
		{
			<%/* Yes!  Return it.  */%>
			if      (isDefined(      document.Wiz_BannerForm  )) oReply =                                 document.Wiz_BannerForm;
			else if (isDefined(        window.Wiz_BannerFrame )) oReply =        window.Wiz_BannerFrame.document.Wiz_BannerForm;
			else if (isDefined( parent.window.Wiz_BannerFrame )) oReply = parent.window.Wiz_BannerFrame.document.Wiz_BannerForm;
		} <%/* if  */


		  /* No, the banner form isn"t being requested!  Is the main  */
		  /* form being requested?                                    */%>
		else if ("Wiz_MainForm" == sForm)
		{
			<%/* Yes!  Can we access it without worrying about activity  */
			  /* banners?                                                */%>
			if      (isDefined(      document.Wiz_MainForm     )) oReply =                                  document.Wiz_MainForm;
			else if (isDefined(        window.Wiz_ContentFrame )) oReply =        window.Wiz_ContentFrame.document.Wiz_MainForm;
			else if (isDefined( parent.window.Wiz_ContentFrame ))
			{
				if (isDefined( parent.window.Wiz_ContentFrame.document.Wiz_MainForm ))
					oReply = parent.window.Wiz_ContentFrame.document.Wiz_MainForm;
				else
				<%/* it is ok to return a string here since we dont really use the form once we get it */%>
					oReply = "Simple OS must have replaced my content frame document...";
			}


			<%/* Are we running on Netscape 4?  */
			   if (("true".equals(c.var("Wiz.BrowserIsNetscape4")))) {
				  /* Yes!  Do we have the form?  */%>
				if (null == oReply)
				{
					<%/* No!  Try taking activity banners into account.  */%>
					oReply = parent.window.Wiz_ContentFrame.document.layers["<%= c.var("Wiz.ActivityStyles.Action") %>"].document.Wiz_MainForm;
				} <%/* if  */
			   } %>
		} <%/* else if  */


		  /* No, the main form isn"t being requested either!  Is the  */
		  /* navigation form being requested?                         */%>
		else if ("Wiz_NavigationForm" == sForm)
		{
			<%/* Yes!  Return it.  */%>
			if      (isDefined(      document.Wiz_NavigationForm  )) oReply =                                     document.Wiz_NavigationForm;
			else if (isDefined(        window.Wiz_NavigationFrame )) oReply =        window.Wiz_NavigationFrame.document.Wiz_NavigationForm;
			else if (isDefined( parent.window.Wiz_NavigationFrame )) oReply = parent.window.Wiz_NavigationFrame.document.Wiz_NavigationForm;
		} <%/* else if  */


		  /* No, the navigation form isn"t being requested either!  Is  */
		  /* the question form being requested?                         */%>
		else if ("Wiz_QuestionForm" == sForm)
		{
			<%/* Yes!  Return it.  */%>
			if      (isDefined(      document.Wiz_QuestionForm )) oReply =                                  document.Wiz_QuestionForm;
			else if (isDefined(        window.Wiz_ContentFrame )) oReply =        window.Wiz_ContentFrame.document.Wiz_QuestionForm;
			else if (isDefined( parent.window.Wiz_ContentFrame )) oReply = parent.window.Wiz_ContentFrame.document.Wiz_QuestionForm;
		} <%/* else if  */


		  /* No, the question form isn"t being requested either!  Is  */
		  /* the return form being requested?                         */%>
		else if ("Wiz_ReturnForm" == sForm)
		{
			<%/* Yes!  Return it.  */%>
			if      (isDefined(      document.Wiz_ReturnForm      )) oReply =                                     document.Wiz_ReturnForm;
			else if (isDefined(        window.Wiz_NavigationFrame )) oReply =        window.Wiz_NavigationFrame.document.Wiz_ReturnForm;
			else if (isDefined( parent.window.Wiz_NavigationFrame )) oReply = parent.window.Wiz_NavigationFrame.document.Wiz_ReturnForm;
		} <%/* else if  */%>
	} <%/* if  */


	  /* If we get here, oReply is null or refers to the requested  */
	  /* form.  Return it.                                          */%>
	return( oReply );
} <%/* getWizForm_Impl  */



  /* ------------------------------------------------------------  */
  /* Determines the push button pressed when a form is submitted.  */
  /* ------------------------------------------------------------  */%>
function getPBClicked()
{
	<%/* This function works on the main Wiz form.  */%>
	with (getMainWizForm())
	{
		<%/* Is the push button tracker tracking a button name?  */%>
		return( Hidden_PBNavigation.value );
	} <%/* with  */%>
} <%/* getPBClicked  */



  /* ---------------------------------------------------------------  */
  /* Returns the value of the currently selected radio button from a  */
  /* group of radio buttons.                                          */
  /* ---------------------------------------------------------------  */%>
function getRBSelected(
	sRBGroup)	<%/* The name of the group of radio buttons to find the selected one out of.  */%>
{
	var	eRB;


	<%/* Return the value of the selected radio button or an empty  */
	  /* string if one couldn"t be determined.                      */%>
	eRB = getRBSelected_Element( sRBGroup );
	if (null == eRB )
		 return "";
	else return eRB.value;
} <%/* getRBSelected  */



  /* -----------------------------------------------------------------  */
  /* Returns the Element of the currently selected radio button from a  */
  /* group of radio buttons.                                            */
  /* -----------------------------------------------------------------  */%>
function getRBSelected_Element(
	sRBGroup)	<%/* The name of the group of radio buttons to find the selected one out of.  */%>
{
	<%/* This function works on the main Wiz form.  */%>
	with (getMainWizForm())
	{
		var	eRB;
		var	i;


		<%/* Scan the elements of the form... */%>
		for (i = 0; i < elements.length; i += 1)
		{
			<%/* Is this a checked radio button in the group in  */
			  /* question?                                       */%>
			eRB = elements[i];
			if ((eRB.name == sRBGroup) &&
				 eRB.checked)
			{
				<%/* Yes!  Return it.  */%>
				return( eRB );
			} <%/* if  */%>
		} <%/* for  */


		  /* If we get here, we couldn"t find the checked radio button.  */
		  /* Return null.                                                */%>
		return( null );
	} <%/* with  */%>
} <%/* getRBSelected_Element  */



  /* -----------------------------------------------------------------  */
  /* Handles a non-navigation push button getting pressed on the form.  */
  /* -----------------------------------------------------------------  */%>
function handleOtherPB(
	sPB)	<%/* The name of the non-navigation push button causing this function to be called.  */%>
{
	<%/* This function works on the main Wiz form.  */%>
	with (getMainWizForm())
	{
		<%/* Is the form valid?  */%>
		Hidden_PBOther.value      = sPB;
		Hidden_PBNavigation.value = "";

		if (validateForm())
		{
			<%/* Yes!  Submit it.  */%>
			submitMain();
		} <%/* if  */%>
	} <%/* with  */%>
} <%/* handleOtherPB  */



  /* -------------------------------------------------------------  */
  /* Does a string contain a value?                                 */
  /* -------------------------------------------------------------  */%>
function hasString(
	sValue)	<%/* Does this string contain a value?  */%>
{
	return(
		(null != sValue) &&
		(0    <  sValue.length) );
} <%/* hasString  */



  /* ------------------------------------------------------------  */
  /* Returns an Object containing information about how to open a  */
  /* window that"s hidden from view.                               */
  /* ------------------------------------------------------------  */%>
function hiddenWindowInfo()
{
	var	oReply;


	<%/* Allocate a reply object...  */%>
	oReply = new Object();

	<%/* ...initialize...  */%>
	oReply.cx = 1;
	oReply.cy = 1;
	oReply.x  = (window.screen.width  + 1);
	oReply.y  = (window.screen.height + 1);

	<%/* ...and return it.  */%>
	return( oReply );
} <%/* hiddenWindowInfo  */



  /* ----------------------------------------------------  */
  /* Performs initializations common to all Wiz panels.  */
  /* ----------------------------------------------------  */%>
function initializePanel_Common()
{
	<%/* Simply make sure nothing is left over in the status line.  */%>
	window.status = "";
} <%/* initializePanel_Common  */



  /* ---------------------------------------------------------  */
  /* Returns true of an object is defined and false otherwise.  */
  /* ---------------------------------------------------------  */%>
function isDefined(
	o)	<%/* Is this object defined?  */%>
{
	var	sType;


	sType = typeof o;
	return(
		("undefined" != sType) &&
		("unknown"   != sType));
} <%/* isDefined  */



  /* ----------------------------------------------------------------  */
  /* Returns true of an object"s name is defined and false otherwise.  */
  /* ----------------------------------------------------------------  */%>
function isNameDefined(
	o)	<%/* Is this object"s name defined?  */%>
{
	var	r;


	<%/* We"re we given an object to check?  */%>
	r = (null != o);
	if (r)
	{
		var	s;


		<%/* Yes!  Is the object defined?  */%>
		s = typeof o;
		r = (("undefined" != s) && ("unknown" != s));
		if (r)
		{
			<%/* Yes!  Does the object have a name?  */%>
			s = typeof o.name;
			r = (("string" == s) && (0 < o.name.length));
		} <%/* if  */%>
	} <%/* if  */


	  /* If we get here, r contains true if the object"s name is  */
	  /* defined and false otherwise.  Return it.                 */%>
	return( r );
} <%/* isNameDefined  */



  /* -----------------------------------------------------------  */
  /* Does a button name correspond to one of the navigation push  */
  /* buttons?                                                     */
  /* -----------------------------------------------------------  */%>
function isNavigationPB(
	sPB)	<%/* The name to validate as a navigation push button.  */%>
{
	return(
		hasString( sPB ) &&
			(("WizPB_Back"   == sPB) ||
			 ("WizPB_Cancel" == sPB) ||
			 ("WizPB_Close"  == sPB) ||
			 ("WizPB_Finish" == sPB) ||
			 ("WizPB_Next"   == sPB) ||
			 ("WizPB_Ok"     == sPB) ||
			 ("WizPB_Start"  == sPB)) );
} <%/* isNavigationPB  */



  /* ---------------------------------------------------------------  */
  /* Returns true if the window opener is valid and false otherwise.  */
  /* ---------------------------------------------------------------  */%>
function isOpenerValid()
{
	return(
		isDefined( window.opener ) &&
		(typeof window.opener.name == "string" ));
} <%/* isOpenerValid  */



  /* ---------------------------------------------------  */
  /* Does a button type correspond to one a push button?  */
  /* ---------------------------------------------------  */%>
function isPB(
	sButtonType)	<%/* The type to validate as being an other push button.  */%>
{
	return(
		hasString( sButtonType )       &&
			(("button" == sButtonType) ||
			 ("image"  == sButtonType) ||
		 	 ("submit" == sButtonType)) );
} <%/* isPB  */



  /* ------------------------------------------------------------------  */
  /* Handles onKeyDown"s from the various form elements watching for an  */
  /* accelerator key to be pressed.                                      */
  /*                                                                     */
  /* Returns false if the key was handled and true otherwise.  Although  */
  /* this may be contrary to what you would expect it to return, this    */
  /* value is directly returnable to an onKeyDown handler.               */
  /* ------------------------------------------------------------------  */%>
function onKeyDown_Accelerator()
{
	<%/* Are we running in a Microsoft IE browser?  */
	   if (("true".equals(c.var("Wiz.BrowserIsIE")))) {
		  /* Yes!  This function works on the main Wiz form.  */%>
		with (getMainWizForm())
		{
			var	bReply;
			var	eSrc;
			var	iKey;
			var	oEvent;


			<%/* Which key was pressed?  */%>
			oEvent = window.event;
			eSrc   = oEvent.srcElement;
			iKey   = oEvent.keyCode;
			switch (iKey)
			{
			case 8:
				<%/* The backspace key!  Can the widget use the key?  */%>
				bReply = canType( eSrc );
				if (!bReply)
				{
					<%/* No!  Handle it as a back action.  */%>
					bReply = parent.window.Wiz_NavigationFrame.handleBackPB();
				} <%/* if  */%>
				break;


			case 13:
				<%/* The enter key!  Can the widget use the key?  */%>
				bReply = canEnter( eSrc );
				if (!bReply)
				{
					<%/* No!  Handle it as the default action.  */%>
					bReply = parent.window.Wiz_NavigationFrame.handleDefaultPB();
				} <%/* if  */%>
				break;


			case 27:
				<%/* The escape key!  Handle it as a cancel action.  */%>
				bReply = parent.window.Wiz_NavigationFrame.handleCancelPB();
				break;


			default:
				<%/* For any other key, return true since we didn"t  */
				  /* handle it as an accelerator.                    */%>
				bReply = true;
				break;
			} <%/* switch  */


			  /* If we get here, bReply contains false if we handled    */
			  /* the key as an accelerator and true otherwise.  Return  */
			  /* it.                                                    */%>
			return( bReply );
		} <%/* with  */


	   } else {
		  /* Return true since we don"t implement accelerators in this  */
		  /* browser.                                                   */%>
		return( true );
	<% } %>
} <%/* onKeyDown_Accelerator  */



  /* -----------------------------------------------------------  */
  /* Parses the iManage login string into its constituent parts.  */
  /* -----------------------------------------------------------  */%>
function parseLogin(
	sLogin)	<%/* The login information from iManage.  */%>
{
	var	parsedLogin;


	<%/* Allocate an array of string"s that we can use to hold the  */
	  /* information we parse out of the login information.         */%>
	parsedLogin    = new Array();
	parsedLogin[0] = "";	<%/* User ID.  */%>
	parsedLogin[1] = "";	<%/* Context.  */%>
	parsedLogin[2] = "";	<%/* Address.  */


	   if (("true".equals(c.var("User.disconnected")) == false)) { %>
		var	i;
		var	l;
		var	pi;


		<%/* Scan the login String...  */%>
		for (
			i = 0, l = sLogin.length, pi = 0;
			((i < l) && (pi < parsedLogin.length));
			i += 1)
		{
			<%/* Is the next character a seperator?  */%>
			if ((l - 1) == i)
				 nextChar = sLogin.substring( i          );
			else nextChar = sLogin.substring( i, (i + 1) );
			if ("|" == nextChar )
			{
				<%/* Yes!  Skip to the next login component and ignore the  */
				  /* character...                                           */%>
				pi += 1;
				continue;
			} <%/* if  */

			  /* ...otherwise, append the next character to the current  */
			  /* ...login component.                                     */%>
			parsedLogin[pi] += nextChar ;
		} <%/* for  */
	   }


	  /* Finally, return the array of parsed login information.  */%>
	return parsedLogin;
} <%/* parseLogin  */



  /* -------------------------------------  */
  /* Performs a back from any Wiz panel.  */
  /* -------------------------------------  */%>
function performBack()
{
	<%/* This function works on the main Wiz form.  */%>
	with (getMainWizForm())
	{
		<%/* Let the servlet decide where to backup to.  */%>
		Hidden_PBNavigation.value = "WizPB_Back";
		submitMain();
	} <%/* with  */%>
} <%/* performBack  */



  /* ---------------------------------------  */
  /* Performs a return from any Wiz panel.  */
  /* ---------------------------------------  */%>
function performReturn()
{
	<%/* Simply call the frameset"s onComplete processor.  */%>
	parent.window.processOnComplete();
} <%/* performReturn  */



  /* ------------------------------------  */
  /* Opens a help file in a popup window.  */
  /* ------------------------------------  */%>
function runHelp(
	sHelpKey)	<%/* The help key to open.  */%>
{
	<%/* Run the help file in a popup window.  */%>
	window.open(
		//("<%= c.var("Help.url") %>/<%= c.string("CfgWiz.LangID") %>/fw/" + sHelpKey),
        "<%= c.getModulesUrl() %>/base/help/<%= c.string("CfgWiz.LangID") %>/" + sHelpKey,
		"<%= c.string("Help.WindowName") %>",
		("toolbar=no"                       +
		 ",location=no"                     +
		 ",directories=no"                  +
		 ",menubar=yes"                     +
		 ",scrollbars=yes"                  +
		 ",resizable=yes"                   +
		 ",width=<%= c.string("Help.WindowWidth") %>" +
		 ",height=<%= c.string("Help.WindowHeight") %>") );
} <%/* runHelp  */



  /* ---------------------------------------------  */
  /* Prepares for and submits the main Wiz form.  */
  /* ---------------------------------------------  */%>
function submitMain()
{
	<%/* This function works on the main Wiz form.  */%>
	with (getMainWizForm())
	{
		<%/* Yes!  Show the buttons as disabled...  */%>
		if      (isDefined(        window.Wiz_NavigationFrame ))        window.Wiz_NavigationFrame.showDisabledButtons();
		else if (isDefined( parent.window.Wiz_NavigationFrame )) parent.window.Wiz_NavigationFrame.showDisabledButtons();

		<%/* ...and submit the form.  */%>
		submit();
	} <%/* with  */%>
} <%/* submitMain  */



  /* -------------------------------------------------------------  */
  /* Validates the form as button input items are clicked and text  */
  /* input items are modified.                                      */
  /* -------------------------------------------------------------  */%>
function validateForm()
{
	<%/* Simply let each content form valdiate.  */%>
	return( validateForm_PerPanel() );
} <%/* validateForm */



						     /* * * * * * *  */
                             /* End of File  */
                             /* * * * * * *  */%>
