<%@ page pageEncoding="utf-8" contentType="text/html;charset=utf-8"  import="com.novell.webaccess.common.JSPConduit2" %>
<%@ taglib uri="/WEB-INF/iman.tld" prefix="iman" %>
<%@ taglib uri="/WEB-INF/c.tld" prefix="c" %>
<%   JSPConduit2 c = JSPConduit2.getJSPConduit(request); 
     c.stringTable("DevResources");
     c.stringTable("FwResources"); %>

<HTML>
<HEAD><TITLE>OSPrefs</TITLE>
   <iman:stylesheet/>
   <iman:eMFrameScripts/>
   <iman:validationScripts/>
   <iman:osScripts/>
   <script>
      var ENABLED_COLOR = "white";
      var DISABLED_COLOR = "#EFEEE9";
      
      //get all possible input parameters
      var m_windowWidth =          "<%= c.toScript(c.var("OS.WindowWidth")) %>";
      var m_windowHeight =         "<%= c.toScript(c.var("OS.WindowHeight")) %>";
      var m_queryColumnWidth =     "<%= c.toScript(c.var("OS.QueryColumnWidth")) %>";
      var m_ssResultsPerPage =     "<%= c.toScript(c.var("OS.SSResultsPerPage")) %>";
//      var m_msResultsPerPage =     "<%= c.toScript(c.var("OS.MSResultsPerPage")) %>";   Use same setting for single and multi RPP
      var m_startupMode =          "<%= c.toScript(c.var("OS.StartupMode")) %>";
      var m_searchOnStartup =      "<%= c.toScript(c.var("OS.StartupSearch")) %>";
      var m_startingContext =      "<%= c.toScript(c.var("OS.StartingContext")) %>";
      var m_alwaysContext =        "<%= c.toScript(c.var("OS.AlwaysContext")) %>";
      var m_showSubordinateCount = "<%= c.toScript(c.var("OS.ShowSubordinateCount")) %>";
      
      //use defaults if no value present
      if (m_windowWidth=="")       m_windowWidth="<%= c.string("OS.Browser.WindowWidth") %>";
      if (m_windowHeight=="")      m_windowHeight="<%= c.string("OS.Browser.WindowHeight") %>";
      if (m_queryColumnWidth=="")  m_queryColumnWidth="<%= c.string("OS.Browser.QueryColumnWidth") %>";
      if (m_startupMode=="")       m_startupMode="browse";
      if (m_searchOnStartup=="")   m_searchOnStartup="false";
      if (m_showSubordinateCount=="") m_showSubordinateCount="true";
      
      var contextIdx = 0;  //assume last, first
      if ((m_startingContext=="") && (m_alwaysContext==""))
      {
         //hmmm.. no context specified.  assume last, first=[root]
         m_startingContext="<%= c.toScript(c.string("OS.Browser.RootName")) %>";
         m_alwaysContext="<%= c.toScript(c.string("OS.Browser.RootName")) %>";
      }
      else if (m_alwaysContext!="")
      {
         //always context specified
         m_startingContext="<%= c.toScript(c.string("OS.Browser.RootName")) %>";
         contextIdx = 1;
      }
      else
      {
         //starting context specified
         m_alwaysContext="<%= c.toScript(c.string("OS.Browser.RootName")) %>";
      }
      
      function getCurrentValues()
      {
         m_windowWidth = document.getElementById("windowWidth").value;
         m_windowHeight = document.getElementById("windowHeight").value;
         m_queryColumnWidth = document.getElementById("queryColumnWidth").value;
         m_ssResultsPerPage = document.getElementById("ssRPP").value;
//         m_msResultsPerPage = document.getElementById("msRPP").value;
         
         //get startup mode
         var e = document.getElementById("startupMode");
         m_startupMode = e.options[e.selectedIndex].value;
         
         //do a search on startup?
         m_searchOnStartup = ((document.OSPrefs.searchOnStartupRadio[1].checked)?"true":"false");
         
         //get starting context
         if (document.OSPrefs.scRadio[0].checked)
         {
            //last context, otherwise
            m_startingContext = document.getElementById("startingContext").value;
            m_alwaysContext = "";
         }
         else
         {
            //always
            m_alwaysContext = document.getElementById("alwaysContext").value;
            m_startingContext = "";
         }
         
         //get subordinate count option
         m_showSubordinateCount = (document.OSPrefs.showSubordinateCount.checked?"true":"false");
      }
      
      function doOK()
      { 
         if (isFormDataValid())
         {
            //get the current state of the GUI
            getCurrentValues();
            
            //create action command
            var strURL = "webacc?taskId=<%= c.toScript(c.var("taskId")) %>&merge=dev.GenConf&error=dev.GenErr&nextState=doSetPrefs";
      
            //create dynamic HTML input fields
            var strHTML="";
            strHTML += '<input type=hidden name="OS.WindowWidth" value="'       + m_windowWidth+'">\n';
            strHTML += '<input type=hidden name="OS.WindowHeight" value="'      + m_windowHeight+'">\n';
            strHTML += '<input type=hidden name="OS.QueryColumnWidth" value="'  + m_queryColumnWidth+'">\n';
            strHTML += '<input type=hidden name="OS.SSResultsPerPage" value="'  + m_ssResultsPerPage+'">\n';
//            strHTML += '<input type=hidden name="OS.MSResultsPerPage" value="'  + m_msResultsPerPage+'">\n';
            strHTML += '<input type=hidden name="OS.StartupMode" value="'       + m_startupMode+'">\n';
            strHTML += '<input type=hidden name="OS.StartupSearch" value="'     + m_searchOnStartup+'">\n';
            strHTML += '<input type=hidden name="OS.StartingContext" value="'   + toTag(m_startingContext)+'">\n';
            strHTML += '<input type=hidden name="OS.AlwaysContext" value="'     + toTag(m_alwaysContext)+'">\n';            
            strHTML += '<input type=hidden name="OS.ShowSubordinateCount" value="' + m_showSubordinateCount+'">';
      
            //alert("doGenericSearch: url = "+strURL);
            //alert("doGenericSearch: html = "+strHTML);
            document.PostPrefs.action = strURL;
            document.getElementById("PostPrefsData").innerHTML = strHTML;
            document.PostPrefs.submit();
         }
      }
      
      function doReset()
      { 
         //create action command
         var strURL = "webacc?taskId=<%= c.toScript(c.var("taskId")) %>&merge=fw.OS.Prefs&error=dev.GenErr&nextState=doResetPrefs";
   
         //alert("doGenericSearch: url = "+strURL);
         //alert("doGenericSearch: html = "+strHTML);
         document.PostPrefs.action = strURL;
         document.getElementById("PostPrefsData").innerHTML = "";
         document.PostPrefs.submit();
      }
      
      function onContextChange(idx)
      {
         if (idx==0)
         {
            //last, first time
            document.getElementById("startingContext").disabled=false;
            document.getElementById("startingContext").style.backgroundColor = ENABLED_COLOR;
            document.getElementById("alwaysContext").disabled=true;
            document.getElementById("alwaysContext").style.backgroundColor = DISABLED_COLOR;
         }
         else
         {
            //always
            document.getElementById("alwaysContext").disabled=false;
            document.getElementById("alwaysContext").style.backgroundColor = ENABLED_COLOR;
            document.getElementById("startingContext").disabled=true;
            document.getElementById("startingContext").style.backgroundColor = DISABLED_COLOR;
         }
      }
      
      function isValidRPP(s,def)
      {
         if (s==null || s.length==0) s=def;
         else if (s<1)               s=1;
         else if (s>500)             s=500;
         return s;
      }

      function doOnLoad()
      {
         //set the window size parameters
         document.getElementById("windowWidth").value = m_windowWidth;
         document.getElementById("windowHeight").value = m_windowHeight;
         document.getElementById("queryColumnWidth").value = m_queryColumnWidth;
         
         //set the results per page parameters
         document.getElementById("ssRPP").value = isValidRPP(m_ssResultsPerPage,22);
//         document.getElementById("msRPP").value = isValidRPP(m_msResultsPerPage,15);
         
         //set the startupMode selection
         document.getElementById("startupMode").selectedIndex = ((m_startupMode.toLowerCase()=="search")?1:0);

         //set the starting context parameters
         document.getElementById("startingContext").value = m_startingContext;
         document.getElementById("alwaysContext").value = m_alwaysContext;
         
         //set the searchOnStartup parameters
         if (m_searchOnStartup.toLowerCase()=="true")
         {
            document.OSPrefs.searchOnStartupRadio[1].checked=true;
         }
         else
         {
            document.OSPrefs.searchOnStartupRadio[0].checked=true;
         }
         onContextChange(contextIdx);
         document.OSPrefs.scRadio[contextIdx].checked=true;
         
         document.OSPrefs.showSubordinateCount.checked = (m_showSubordinateCount.toLowerCase()=="true");
      }
      
      function disableOS(controlName)
      {
         return (!document.getElementById(controlName).disabled);
      }
      
   </script>
</HEAD>



<body onLoad="doOnLoad();">
   <c:set var="imageName" >dev/<%= c.string("Button.OS.image") %></c:set>
   <iman:taskHeader iconUrl="${imageName}" titleKey="OS.Browser.PrefsTaskTitle" titleBundle="FwResources"/>
   <% String errorImage = c.getModulesUrl() + "/dev/images/" + c.string("Icon.Error16.image"); %>
   <br>
   <form name="OSPrefs" method=post action="webacc">
      <span class="largetext"><b><%= c.toTag(c.string("OS.Browser.WinSizeTitle")) %></b></span><br>
      <table class="mediumtext" style="margin-top:5">
         <tr><td style="width:10">&nbsp;</td><td><%= c.toTag(c.string("OS.Browser.WinWidthTitle")) %></td><td style="width:10">&nbsp;</td><td><input id="windowWidth" type=text size=3 style="padding-left:3px" onBlur="return validateIntegerField(this,true,1,screen.availWidth)" value=""><div id=windowWidthError style="display:none"><img src="<%= errorImage %>" border=0></div></td></tr>
         <tr><td style="width:10">&nbsp;</td><td><%= c.toTag(c.string("OS.Browser.WinHeightTitle")) %></td><td style="width:10">&nbsp;</td><td><input id="windowHeight" type=text size=3 style="padding-left:3px" onBlur="return validateIntegerField(this,true,1,screen.availHeight)" value=""><div id=windowHeightError style="display:none"><img src="<%= errorImage %>" border=0></div></td></tr>
         <tr><td style="width:10">&nbsp;</td><td><%= c.toTag(c.string("OS.Browser.QueryColumnWidthTitle")) %></td><td style="width:10">&nbsp;</td><td><input id="queryColumnWidth" type=text size=3 style="padding-left:3px" onBlur="return validateIntegerField(this,true,1,Number(document.getElementById('windowWidth').value));" value=""><div id=queryColumnWidthError style="display:none"><img src="<%= errorImage %>" border=0></div></td></tr>
      </table>
      <br>
      
      <span class="largetext"><b><%=c.toTag(c.string("OS.Browser.UserDefaultsTitle")) %></b></span><br>
      <div class="smalltext">
      <br>
      <%= c.toDisplay(c.string("OS.Browser.UserDefaultsNote")) %>
      </div>
      <br>
      <table>
      <tr><td style="width:10">&nbsp;</td>
      <td>
      <span class="largetext"><b><%= c.toDisplay(c.string("OS.Browser.StartupModeTitle")) %></b></span>&nbsp;&nbsp;&nbsp;
      <select id="startupMode">
         <option style="font-size:1.1em" value="browse" selected><%= c.toTag(c.string("OS.Browser.BrowseMode")) %>&nbsp;&nbsp;&nbsp;
         <option style="font-size:1.1em" value="search"><%= c.toTag(c.string("OS.Browser.SearchMode")) %>&nbsp;&nbsp;&nbsp;
      </select><br>
      <br>

      <span class="largetext"><b><%= c.toDisplay(c.string("OS.Browser.RPPTitle")) %></b></span>&nbsp;&nbsp;&nbsp;
        <input id="ssRPP" type=text size=3 maxlength=3 style="padding-left:3px" onBlur="return validateIntegerField(this,true,1,500)" value=""><div id=ssRPPError style="display:none"><img src="<%= errorImage %>" border=0></div>&nbsp;&nbsp;&nbsp;
        <span class="smalltext"><%= c.toDisplay(c.string("OS.Browser.RPPTitle1")) %></span>
      <br><br>
      
      <span class="largetext"><b><%= c.toDisplay(c.string("OS.Browser.SContextTitle")) %></b></span>&nbsp;&nbsp;<span class="smalltext"><%= c.toDisplay(c.string("OS.Browser.SContextTitle1")) %></span>
      <table class="mediumtext">
      <tr>
         <td style="width:10">&nbsp;</td>
         <td><input type="radio" name="scRadio" onClick="onContextChange(0);"><%= c.toTag(c.string("OS.Browser.LastContextTitle")) %></td>
         <td style="width:10">&nbsp;</td>
         <td><input id="startingContext" type=text size=30 maxlength=128 style="padding-left:3px" value=""><iman:os typeFilter="[containers]" control="startingContext" isOSAllowed="disableOS" history="true" /></td>
      </tr>
      
      <tr>
         <td style="width:10">&nbsp;</td>
         <td><input type="radio" name="scRadio" onClick="onContextChange(1);"><%= c.toTag(c.string("OS.Browser.AlwaysTitle")) %></td>
         <td style="width:10">&nbsp;</td>
         <td><input id="alwaysContext" type=text size=30 maxlength=128 style="padding-left:3px" value=""><iman:os typeFilter="[containers]" control="alwaysContext" isOSAllowed="disableOS" history="true"/></td>
      </tr>
      </table>
      <br>
      
      <span class="largetext"><b><%= c.toDisplay(c.string("OS.Browser.SOStartupTitle")) %></b></span>&nbsp;&nbsp;<span class="smalltext"><%= c.toDisplay(c.string("OS.Browser.SOStartupTitle1")) %></span><br>
      <table class="mediumtext">
         <tr><td style="width:10">&nbsp;</td><td><input type="radio" name="searchOnStartupRadio"><%= c.toDisplay(c.string("OS.Browser.SOStartupNOTitle")) %></td></tr>
         <tr><td style="width:10">&nbsp;</td><td><input type="radio" name="searchOnStartupRadio"><%= c.toDisplay(c.string("OS.Browser.SOStartupYESTitle")) %></td></tr>
      </table>
      <br>
      
      <span class="largetext"><b><%= c.toDisplay(c.string("OS.Browser.SubcountTitle")) %></b></span>&nbsp;&nbsp;
      <table class="mediumtext">
         <tr><td style="width:10">&nbsp;</td><td><input type="checkbox" name="showSubordinateCount" <c:if test="${OS.ShowSubordinateCount=='true'}">checked</c:if>>
         <%= c.toDisplay(c.string("OS.Browser.SubcountText")) %></td></tr>
      </table>
               
      </td>
      </tr>
      </table>
      <div class="smalltext"><br></div>     
      <iman:bar/>
      <iman:button key="OK" onClick="doOK()"/>
      <iman:button key="Default" onClick="doReset()" />
      <iman:cancelBtn/>
   </form>
   <form name="PostPrefs" method=post action="webacc">
      <span id="PostPrefsData">
      <!-- posted data goes here -->
      </span>
   </form>
   <iman:osFooter/>
</body>
</HTML>