<%@ page pageEncoding="utf-8" contentType="text/html;charset=utf-8"  import="com.novell.webaccess.common.JSPConduit2" %>
<%@ taglib uri="/WEB-INF/iman.tld" prefix="iman" %>
<%@ taglib uri="/WEB-INF/c.tld" prefix="c" %>
<%   JSPConduit2 c = JSPConduit2.getJSPConduit(request); 
     c.stringTable("DevResources");
     c.stringTable("FwResources"); %>

<HTML>
<HEAD><TITLE>OVPrefs</TITLE>
   <iman:stylesheet/>
   <iman:eMFrameScripts/>
   <iman:validationScripts/>
   <iman:osScripts/>
   <script>
      var ENABLED_COLOR = "white";
      var DISABLED_COLOR = "#EFEEE9";
      
      //get all possible input parameters
      var m_columnWidth =          "<%= c.toScript(c.var("OV.ColumnWidth")) %>";
      var m_selectionMode =        "<%= c.toScript(c.var("OV.SelectionMode")) %>";
      var m_ssResultsPerPage =     "<%= c.toScript(c.var("OV.SSResultsPerPage")) %>";
//      var m_msResultsPerPage =     "<%= c.toScript(c.var("OV.MSResultsPerPage")) %>";   Use same setting for single and multi RPP
      var m_startupMode =          "<%= c.toScript(c.var("OV.StartupMode")) %>";
      var m_searchOnStartup =      "<%= c.toScript(c.var("OV.StartupSearch")) %>";
      var m_startingContext =      "<%= c.toScript(c.var("OV.StartingContext")) %>";
      var m_alwaysContext =        "<%= c.toScript(c.var("OV.AlwaysContext")) %>";
      var m_showSubordinateCount = "<%= c.toScript(c.var("OV.ShowSubordinateCount")) %>";
      var m_tvcResultsPerPage =     "<%= c.toScript(c.var("TVC.ResultsPerPage")) %>";
      
      //use defaults if no value present
      if (m_columnWidth=="")       m_columnWidth="<%= c.string("OV.Browser.ColumnWidth") %>";
      if (m_selectionMode=="")     m_selectionMode="single";
      if (m_startupMode=="")       m_startupMode="tree";
      if (m_searchOnStartup=="")   m_searchOnStartup="false";
      if (m_showSubordinateCount=="") m_showSubordinateCount="true";
      
      var contextIdx = 0;  //assume last, first
      if ((m_startingContext=="") && (m_alwaysContext==""))
      {
         //hmmm.. no context specified.  assume last, first=[root]
         m_startingContext="<%= c.toScript(c.string("OV.Browser.RootName")) %>";
         m_alwaysContext="<%= c.toScript(c.string("OV.Browser.RootName")) %>";
      }
      else if (m_alwaysContext!="")
      {
         //always context specified
         m_startingContext="<%= c.toScript(c.string("OV.Browser.RootName")) %>";
         contextIdx = 1;
      }
      else
      {
         //starting context specified
         m_alwaysContext="<%= c.toScript(c.string("OV.Browser.RootName")) %>";
      }
      
      function getCurrentValues()
      {
         m_columnWidth = document.getElementById("columnWidth").value;
         m_ssResultsPerPage = document.getElementById("ssRPP").value;
         m_tvcResultsPerPage = document.getElementById("tvcRPP").value;
//         m_msResultsPerPage = document.getElementById("msRPP").value;
         
         //get startup mode
         var e = document.getElementById("startupMode");
         m_startupMode = e.options[e.selectedIndex].value;
         
         //get selection mode
         var e = document.getElementById("selectionMode");
         m_selectionMode = e.options[e.selectedIndex].value;
         
         //do a search on startup?
         m_searchOnStartup = ((document.OVPrefs.searchOnStartupRadio[1].checked)?"true":"false");
         
         //get starting context
         if (document.OVPrefs.scRadio[0].checked)
         {
            //last context, otherwise
            m_startingContext = document.getElementById("startingContext").value;
            m_alwaysContext = "";
         }
         else
         {
            //always
            m_alwaysContext = document.getElementById("alwaysContext").value;
            m_startingContext = "";
         }
         
         //get subordinate count option
         m_showSubordinateCount = (document.OVPrefs.showSubordinateCount.checked?"true":"false");
      }
      
      function doOK()
      { 
         if (isFormDataValid())
         {
            //get the current state of the GUI
            getCurrentValues();
            
            //create action command
            var strURL = "webacc?taskId=<%= c.toScript(c.var("taskId")) %>&merge=dev.GenConf&error=dev.GenErr&nextState=doSetPrefs";
      
            //create dynamic HTML input fields
            var strHTML="";
            strHTML += '<input type=hidden name="OV.ColumnWidth" value="'  + m_columnWidth+'">\n';
            strHTML += '<input type=hidden name="OV.SelectionMode" value="'  + m_selectionMode+'">\n';
            strHTML += '<input type=hidden name="OV.SSResultsPerPage" value="'  + m_ssResultsPerPage+'">\n';
//            strHTML += '<input type=hidden name="OV.MSResultsPerPage" value="'  + m_msResultsPerPage+'">\n';
            strHTML += '<input type=hidden name="OV.StartupMode" value="'       + m_startupMode+'">\n';
            strHTML += '<input type=hidden name="OV.StartupSearch" value="'     + m_searchOnStartup+'">\n';
            strHTML += '<input type=hidden name="OV.StartingContext" value="'   + toTag(m_startingContext)+'">\n';
            strHTML += '<input type=hidden name="OV.AlwaysContext" value="'     + toTag(m_alwaysContext)+'">\n';            
            strHTML += '<input type=hidden name="OV.ShowSubordinateCount" value="' + m_showSubordinateCount+'">\n';
            strHTML += '<input type=hidden name="TVC.ResultsPerPage" value="' + m_tvcResultsPerPage+'">';
      
            //alert("doGenericSearch: url = "+strURL);
            //alert("doGenericSearch: html = "+strHTML);
            document.PostPrefs.action = strURL;
            document.getElementById("PostPrefsData").innerHTML = strHTML;
            document.PostPrefs.submit();
         }
      }
      
      function doReset()
      { 
         //create action command
         var strURL = "webacc?taskId=<%= c.toScript(c.var("taskId")) %>&merge=fw.OV.Prefs&error=dev.GenErr&nextState=doResetPrefs";
   
         //alert("doGenericSearch: url = "+strURL);
         //alert("doGenericSearch: html = "+strHTML);
         document.PostPrefs.action = strURL;
         document.getElementById("PostPrefsData").innerHTML = "";
         document.PostPrefs.submit();
      }
      
      function onContextChange(idx)
      {
         if (idx==0)
         {
            //last, first time
            document.getElementById("startingContext").disabled=false;
            document.getElementById("startingContext").style.backgroundColor = ENABLED_COLOR;
            document.getElementById("alwaysContext").disabled=true;
            document.getElementById("alwaysContext").style.backgroundColor = DISABLED_COLOR;
         }
         else
         {
            //always
            document.getElementById("alwaysContext").disabled=false;
            document.getElementById("alwaysContext").style.backgroundColor = ENABLED_COLOR;
            document.getElementById("startingContext").disabled=true;
            document.getElementById("startingContext").style.backgroundColor = DISABLED_COLOR;
         }
      }
      
      function isValidRPP(s,def)
      {
         if (s==null || s.length==0) s=def;
         else if (s<1)               s=1;
         else if (s>500)             s=500;
         return s;
      }

      function doOnLoad()
      {
         //set the window size parameters
         document.getElementById("columnWidth").value = m_columnWidth;
         
         //set the results per page parameters
         document.getElementById("ssRPP").value = isValidRPP(m_ssResultsPerPage,100);
         document.getElementById("tvcRPP").value = isValidRPP(m_tvcResultsPerPage,100);
//         document.getElementById("msRPP").value = isValidRPP(m_msResultsPerPage,100);
         
         //set the startupMode selection
         document.getElementById("startupMode").selectedIndex = ((m_startupMode.toLowerCase()=="search")?2:((m_startupMode.toLowerCase()=="tree")?0:1));
         
         //set the selectionMode selection
         document.getElementById("selectionMode").selectedIndex = ((m_selectionMode.toLowerCase()=="single")?0:1);

         //set the starting context parameters
         document.getElementById("startingContext").value = m_startingContext;
         document.getElementById("alwaysContext").value = m_alwaysContext;
         
         //set the searchOnStartup parameters
         if (m_searchOnStartup.toLowerCase()=="true")
         {
            document.OVPrefs.searchOnStartupRadio[1].checked=true;
         }
         else
         {
            document.OVPrefs.searchOnStartupRadio[0].checked=true;
         }
         onContextChange(contextIdx);
         document.OVPrefs.scRadio[contextIdx].checked=true;
         
         document.OVPrefs.showSubordinateCount.checked = (m_showSubordinateCount.toLowerCase()=="true");
      }
      
      function disableOV(controlName)
      {
         return (!document.getElementById(controlName).disabled);
      }
      
   </script>
</HEAD>


<body onLoad="doOnLoad();">
   <c:set var="imageName" >fw/<%= c.string("Button.OV.image") %></c:set>
   <iman:taskHeader iconUrl="${imageName}" titleKey="OV.Browser.PrefsTaskTitle" titleBundle="FwResources"/>
   <% String errorImage = c.getModulesUrl() + "/dev/images/" + c.string("Icon.Error16.image"); %>
   <br>
   <form name="OVPrefs" method=post action="webacc">
      <table>
         <tr>
            <td style="width:10">&nbsp;</td>
            <td>
               <table cellpadding=0 cellspacing=0>
                  <tr style="">
                  <td><span class="largetext"><b><%= c.toTag(c.string("OV.Browser.ColumnWidthTitle")) %></b></span></td>
                  <td style="width:10">&nbsp;</td>
                  <td><input id="columnWidth" type=text size=3 style="padding-left:3px" onBlur="return validateIntegerField(this,true,1,screen.availWidth);" value=""><div id=columnWidthError style="display:none"><img src="<%= errorImage %>" border=0></div></td>
                  </tr>
                  
                  <tr style="height:15"><td></td></tr>
                  <tr>
                  <td><span class="largetext"><b><%= c.toDisplay(c.string("OV.Browser.StartupModeTitle")) %></b></span></td>
                  <td style="width:10">&nbsp;</td>
                  <td>
                     <select id="startupMode">
                        <option style="font-size:1.1em" value="tree" selected><%= c.toTag(c.string("OV.Browser.TreeMode")) %>&nbsp;&nbsp;&nbsp;
                        <option style="font-size:1.1em" value="browse" selected><%= c.toTag(c.string("OV.Browser.BrowseMode")) %>&nbsp;&nbsp;&nbsp;
                        <option style="font-size:1.1em" value="search"><%= c.toTag(c.string("OV.Browser.SearchMode")) %>&nbsp;&nbsp;&nbsp;
                     </select>
                  </td>
                  </tr>
                  
                  <tr style="height:15"><td></td></tr>
                  <tr>
                  <td><span class="largetext"><b><%= c.toDisplay(c.string("OV.Browser.SelectionModeTitle")) %></b></span></td>
                  <td style="width:10">&nbsp;</td>
                  <td>
                     <select id="selectionMode">
                        <option style="font-size:1.1em" value="single" selected><%= c.toTag(c.string("OV.Browser.SingleSelectMode")) %>&nbsp;&nbsp;&nbsp;
                        <option style="font-size:1.1em" value="multiple"><%= c.toTag(c.string("OV.Browser.MultipleSelectMode")) %>&nbsp;&nbsp;&nbsp;
                     </select>
                  </td>
                  </tr>
               </table>
               <br>
               
             <span class="largetext"><b><%= c.toDisplay(c.string("OV.Browser.LeftPaneTitle")) %></b></span><br>
		       <span class="smalltext"><%= c.toDisplay(c.string("OV.Browser.RPPCTitle")) %></span>&nbsp;&nbsp;&nbsp;
		         <input id="ssRPP" type=text size=3 maxlength=3 style="padding-left:3px" onBlur="return validateIntegerField(this,true,1,500)" value=""><div id=ssRPPError style="display:none"><img src="<%= errorImage %>" border=0></div>&nbsp;&nbsp;&nbsp;
		         <span class="smalltext"><%= c.toDisplay(c.string("OV.Browser.RPPCTitle1")) %></span>
		       <br><br>
      
             <span class="largetext"><b><%= c.toDisplay(c.string("OV.Browser.RightPaneTitle")) %></b></span><br>
  		       <span class="smalltext"><%= c.toDisplay(c.string("OV.Browser.RPPTitle")) %></span>&nbsp;&nbsp;&nbsp;
		         <input id="tvcRPP" type=text size=3 maxlength=3 style="padding-left:3px" onBlur="return validateIntegerField(this,true,1,500)" value=""><div id=tvcRPPError style="display:none"><img src="<%= errorImage %>" border=0></div>&nbsp;&nbsp;&nbsp;
		         <span class="smalltext"><%= c.toDisplay(c.string("OV.Browser.RPPTitle1")) %></span>
		       <br><br>
      
               <span class="largetext"><b><%= c.toDisplay(c.string("OV.Browser.SContextTitle")) %></b></span>&nbsp;&nbsp;<span class="smalltext"><%= c.toDisplay(c.string("OV.Browser.SContextTitle1")) %></span>
               <table class="mediumtext">
                  <tr>
                     <td style="width:10">&nbsp;</td>
                     <td><input type="radio" name="scRadio" onClick="onContextChange(0);"><%= c.toTag(c.string("OV.Browser.LastContextTitle")) %></td>
                     <td style="width:10">&nbsp;</td>
                     <td><input id="startingContext" type=text size=30 maxlength=128 style="padding-left:3px" value=""><iman:os typeFilter="[containers]" control="startingContext" isOSAllowed="disableOV" history="true" /></td>
                  </tr>
                  
                  <tr>
                     <td style="width:10">&nbsp;</td>
                     <td><input type="radio" name="scRadio" onClick="onContextChange(1);"><%= c.toTag(c.string("OV.Browser.AlwaysTitle")) %></td>
                     <td style="width:10">&nbsp;</td>
                     <td><input id="alwaysContext" type=text size=30 maxlength=128 style="padding-left:3px" value=""><iman:os typeFilter="[containers]" control="alwaysContext" isOSAllowed="disableOV" history="true"/></td>
                  </tr>
               </table>
               <br>
               
               <span class="largetext"><b><%= c.toDisplay(c.string("OV.Browser.SOStartupTitle")) %></b></span>&nbsp;&nbsp;<span class="smalltext"><%= c.toDisplay(c.string("OV.Browser.SOStartupTitle1")) %></span><br>
               <table class="mediumtext">
                  <tr><td style="width:10">&nbsp;</td><td><input type="radio" name="searchOnStartupRadio"><%= c.toDisplay(c.string("OV.Browser.SOStartupNOTitle")) %></td></tr>
                  <tr><td style="width:10">&nbsp;</td><td><input type="radio" name="searchOnStartupRadio"><%= c.toDisplay(c.string("OV.Browser.SOStartupYESTitle")) %></td></tr>
               </table>
               <br>
               
               <span class="largetext"><b><%= c.toDisplay(c.string("OV.Browser.SubcountTitle")) %></b></span>&nbsp;&nbsp;
               <table class="mediumtext">
                  <tr><td style="width:10">&nbsp;</td><td><input type="checkbox" name="showSubordinateCount" <c:if test="${OV.ShowSubordinateCount=='true'}">checked</c:if>>
                  <%= c.toDisplay(c.string("OV.Browser.SubcountText")) %></td></tr>
               </table>
               
            </td>
         </tr>
      </table>
      <div class="smalltext"><br></div>     
      <iman:bar/>
      <iman:button key="OK" onClick="doOK()"/>
      <iman:button key="Default" onClick="doReset()" />
      <iman:cancelBtn/>
   </form>
   <form name="PostPrefs" method=post action="webacc">
      <span id="PostPrefsData">
      <!-- posted data goes here -->
      </span>
   </form>
   <iman:osFooter/>
</body>
</HTML>