<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
    <!--
<xsl:variable name="Portal.ConfigData.Title.Color.Background">#FFFFFF</xsl:variable>

<xsl:variable name="Portal.ConfigData.Title.Color.Foreground">#663</xsl:variable>

<xsl:variable name="Portal.ConfigData.Items.Color.Background">#FFFFFF</xsl:variable>

<xsl:variable name="Portal.ConfigData.Items.Color.Foreground">#000000</xsl:variable>

<xsl:variable name="Portal.ConfigData.AltItems.Color.Background">#efeee9</xsl:variable>
-->
    <xsl:template match="*|/">
        <xsl:apply-templates/>
    </xsl:template>
    <xsl:template match="text()|@*">
        <xsl:value-of select="."/>
    </xsl:template>
    <xsl:template match="ShowUserConfig">
        <div class="npsadmin">
            <TABLE bgcolor="FFFFFF" border="0" cellpadding="3" cellspacing="0">
                <FORM action="{$Portal.Servlet.Normal}" method="POST">
                    <input name="GI_ID" type="hidden" value="{../@id}"/>
                    <!--		    <INPUT type="HIDDEN" name="FULLPAGE" value="branding"/>-->
                    <INPUT name="NPAction" type="HIDDEN" value="ShowUserConfig"/>
                    <TR>
                        <TD colspan="4">
                            <div class="head2b">
                                <xsl:value-of select="$com.novell.nps.ConfigData.PersonalizationsForText"/> <xsl:value-of select="../@title"/>
                            </div>
                            <div class="formdescriptext">
                                <xsl:value-of select="$com.novell.nps.ConfigData.ConfigureTheSettingsToPersonalizeTheGadget"/>
                            </div>
                            <p class="head1"/>
                        </TD>
                    </TR>
                    <TR class="tablehead2">
                        <TD COLSPAN="4">
                            <div class="tablehead2">
                                <xsl:value-of select="$com.novell.nps.ConfigData.ConfigurationHeadingText"/>
                            </div>
                        </TD>
                    </TR>
                    <xsl:apply-templates select="ConfigData"/>
                    <xsl:if test="ConfigData/@advanced[.!=&apos;&apos;]">
                        <TR height="10">
                            <td colspan="4" height="10" nowrap="true"/>
                        </TR>
                        <TR class="tablehead1">
                            <TD nowrap="true">
                                <div class="tablehead1">
                                    <xsl:value-of select="$com.novell.nps.ConfigData.NewSettingNamePromptText"/>
                                </div>
                            </TD>
                            <TD colspan="3" nowrap="true">
                                <div class="tablehead1">
                                    <xsl:value-of select="$com.novell.nps.ConfigData.NewSettingValuePromptText"/>
                                </div>
                            </TD>
                        </TR>
                        <TR>
                            <TD>
                                <INPUT name="NewSettingName" size="25" type="text"/>
                            </TD>
                            <TD colspan="3">
                                <INPUT name="NewSettingValue" size="30" type="text"/>                              <INPUT alt="{$com.novell.nps.ConfigData.AddNewSettingAltText}" name="NewSetting" src="{$Portal.ResourcePath}{$com.novell.nps.ConfigData.ButtonAdd}" type="image"/>
                            </TD>
                        </TR>
                    </xsl:if>
                    <TR height="10">
                        <td colspan="4" height="10" nowrap="true"/>
                    </TR>
                    <TR>
                        <TD class="ruleabove" colspan="4">
                            <INPUT alt="{$com.novell.nps.ConfigData.OKAltText}" name="ConfigurableSubmit" src="{$Portal.ResourcePath}{$com.novell.nps.ConfigData.ButtonOK}" type="image"/>                                                   <INPUT alt="{$com.novell.nps.ConfigData.CancelAltText}" name="ConfigurableCancel" src="{$Portal.ResourcePath}{$com.novell.nps.ConfigData.ButtonCancel}" type="image"/>                                                    <xsl:choose>
                                <xsl:when test="ConfigData/@advanced[.!=&apos;&apos;]">
                                    <INPUT alt="{$com.novell.nps.ConfigData.HideAdvancedAltText}" name="basic" src="{$Portal.ResourcePath}{$com.novell.nps.ConfigData.ButtonBasicSettings}" type="image"/>                                                               </xsl:when>
                                <xsl:otherwise>
                                    <INPUT alt="{$com.novell.nps.ConfigData.AllSettingsAltText}" name="advanced" src="{$Portal.ResourcePath}{$com.novell.nps.ConfigData.ButtonAllSettings}" type="image"/>                                                               </xsl:otherwise>
                            </xsl:choose>
                            <xsl:choose>
                                <xsl:when test="ConfigData/@ShowDescriptions[.!=&apos;&apos;]">
                                    <INPUT alt="{$com.novell.nps.ConfigData.HideDescriptionsAltText}" name="hidedescriptions" src="{$Portal.ResourcePath}{$com.novell.nps.ConfigData.ButtonHideDescriptions}" type="image"/>
                                </xsl:when>
                                <xsl:otherwise>
                                    <INPUT alt="{$com.novell.nps.ConfigData.DescriptionsAltText}" name="showdescriptions" src="{$Portal.ResourcePath}{$com.novell.nps.ConfigData.ButtonDescriptions}" type="image"/>
                                </xsl:otherwise>
                            </xsl:choose>
                        </TD>
                    </TR>
                </FORM>
            </TABLE>
        </div>
    </xsl:template>
    <xsl:template match="ConfigData">
        <xsl:if test="@InternalConfigData[.!=&apos;&apos;]">
            <TR>
                <TD>
                    <!-- put in a hidden parameter telling us we are in the ConfigData -->
                    <!-- only if we are coming from internal ConfigData -->
                    <INPUT name="ConfigDataForm" type="HIDDEN" value="true"/>
                </TD>
            </TR>
        </xsl:if>
        <xsl:if test="@ShowColumnHeaders[.!=&apos;&apos;]">
            <TR>
                <TH nowrap="true">
                    <div class="tablecolumnhead1">
                        <xsl:value-of select="$com.novell.nps.ConfigData.SettingNamePromptText"/>
                    </div>
                </TH>
                <TH nowrap="true">
                    <div class="tablecolumnhead1">
                        <xsl:value-of select="$com.novell.nps.ConfigData.SettingValuePromptText"/>
                    </div>
                </TH>
                <xsl:if test="@overwriteable[.!=&apos;&apos;]">
                    <TH>
                        <div class="tablecolumnhead1">
                            <xsl:value-of select="$com.novell.nps.ConfigData.OverwritablePromptText"/>
                        </div>
                    </TH>
                </xsl:if>
                <xsl:if test="@cumulative[.!=&apos;&apos;]">
                    <TH>
                        <div class="tablecolumnhead1">
                            <xsl:value-of select="$com.novell.nps.ConfigData.CumulativePromptText"/>
                        </div>
                    </TH>
                </xsl:if>
                <xsl:if test="@ShowDescriptions[.!=&apos;&apos;]">
                    <TH>
                        <div class="tablecolumnhead1">
                            <xsl:value-of select="$com.novell.nps.ConfigData.RangePromptText"/>
                        </div>
                    </TH>
                    <TH>
                        <div class="tablecolumnhead1">
                            <xsl:value-of select="$com.novell.nps.ConfigData.DescriptionPromptText"/>
                        </div>
                    </TH>
                </xsl:if>
            </TR>
        </xsl:if>
        <!-- Do regular settings first -->
        <xsl:apply-templates select="Property">
            <xsl:with-param name="advanced" select="&apos;false&apos;"/>
        </xsl:apply-templates>
        <!-- Do advanced settings last -->
        <xsl:if test="@advanced[.!=&apos;&apos;]">
            <TR height="10">
                <td colspan="7" height="10" nowrap="true"/>
            </TR>
            <TR class="tablehead1">
                <TD COLSPAN="7">
                    <div class="tablehead1">
                        <xsl:value-of select="$com.novell.nps.ConfigData.AdvancedConfiguration"/>
                    </div>
                </TD>
            </TR>
            <!-- Show the headers again -->
            <xsl:if test="@ShowColumnHeaders[.!=&apos;&apos;]">
                <TR>
                    <TH nowrap="true">
                        <div class="tablecolumnhead1">
                            <xsl:value-of select="$com.novell.nps.ConfigData.SettingNamePromptText"/>
                        </div>
                    </TH>
                    <TH nowrap="true">
                        <div class="tablecolumnhead1">
                            <xsl:value-of select="$com.novell.nps.ConfigData.SettingValuePromptText"/>
                        </div>
                    </TH>
                    <xsl:if test="@overwriteable[.!=&apos;&apos;]">
                        <TH>
                            <div class="tablecolumnhead1">
                                <xsl:value-of select="$com.novell.nps.ConfigData.OverwritablePromptText"/>
                            </div>
                        </TH>
                    </xsl:if>
                    <xsl:if test="@cumulative[.!=&apos;&apos;]">
                        <TH>
                            <div class="tablecolumnhead1">
                                <xsl:value-of select="$com.novell.nps.ConfigData.CumulativePromptText"/>
                            </div>
                        </TH>
                    </xsl:if>
                    <xsl:if test="@ShowDescriptions[.!=&apos;&apos;]">
                        <TH>
                            <div class="tablecolumnhead1">
                                <xsl:value-of select="$com.novell.nps.ConfigData.RangePromptText"/>
                            </div>
                        </TH>
                        <TH>
                            <div class="tablecolumnhead1">
                                <xsl:value-of select="$com.novell.nps.ConfigData.DescriptionPromptText"/>
                            </div>
                        </TH>
                    </xsl:if>
                </TR>
            </xsl:if>
            <xsl:apply-templates select="Property">
                <xsl:with-param name="advanced" select="&apos;true&apos;"/>
            </xsl:apply-templates>
        </xsl:if>
    </xsl:template>
    <xsl:template match="Property">
        <xsl:param name="advanced"/>
        <xsl:if test="@advanced=$advanced">
            <TR valign="top">
                <xsl:choose>
                    <xsl:when test="@AlternateColor[.=&apos;true&apos;]">
                        <xsl:attribute name="bgcolor">#efeee9</xsl:attribute>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:attribute name="bgcolor">#FFFFFF</xsl:attribute>
                    </xsl:otherwise>
                </xsl:choose>
                <TD>
                    <xsl:value-of select="DisplayName"/>
                </TD>
                <TD>
                    <TABLE cellpadding="0" cellspacing="0">
                        <TR>
                            <TD>
                                <xsl:choose>
                                    <xsl:when test="@Select[.!=&apos;&apos;]">
                                        <xsl:choose>
                                            <xsl:when test="../@UserConfiguring[.=&apos;true&apos;] and overwriteable[.=&apos;false&apos;]">
                                                <xsl:for-each select="Value">
                                                    <xsl:choose>
                                                        <xsl:when test="@Selected[.!=&apos;&apos;]">
                                                            <xsl:value-of select="DisplayValue"/>
                                                            <INPUT name="{../Name}" type="HIDDEN" value="{ActualValue}"/>
                                                        </xsl:when>
                                                    </xsl:choose>
                                                </xsl:for-each>
                                            </xsl:when>
                                            <xsl:otherwise>
                                                <SELECT width="40">
                                                    <xsl:attribute name="name">
                                                        <xsl:value-of select="Name"/>
                                                    </xsl:attribute>
                                                    <xsl:for-each select="Value">
                                                        <xsl:choose>
                                                            <xsl:when test="@Selected[.!=&apos;&apos;]">
                                                                <OPTION value="{ActualValue}" selected="true">
                                                                    <xsl:value-of select="DisplayValue"/>
                                                                </OPTION>
                                                            </xsl:when>
                                                            <xsl:otherwise>
                                                                <OPTION value="{ActualValue}">
                                                                    <xsl:value-of select="DisplayValue"/>
                                                                </OPTION>
                                                            </xsl:otherwise>
                                                        </xsl:choose>
                                                    </xsl:for-each>
                                                </SELECT>
                                            </xsl:otherwise>
                                        </xsl:choose>
                                    </xsl:when>
                                    <xsl:when test="@Boolean[.!=&apos;&apos;]">
                                        <xsl:attribute name="nowrap">true</xsl:attribute>
                                        <xsl:choose>
                                            <xsl:when test="../@UserConfiguring[.=&apos;true&apos;] and overwriteable[.=&apos;false&apos;]">
                                                <xsl:choose>
                                                    <xsl:when test="Value[.!=&apos;true&apos;]">              false              <INPUT name="{Name}" type="HIDDEN" value="false"/>
                                                    </xsl:when>
                                                    <xsl:otherwise>              true              <INPUT name="{Name}" type="HIDDEN" value="true"/>
                                                    </xsl:otherwise>
                                                </xsl:choose>
                                            </xsl:when>
                                            <xsl:otherwise>
                                                <xsl:choose>
                                                    <xsl:when test="Value[.!=&apos;true&apos;]">
                                                        <INPUT name="{Name}" type="radio" value="true">
                                                            <xsl:value-of select="$com.novell.nps.ConfigData.TrueText"/>
                                                        </INPUT>
                                                        <BR/>
                                                        <INPUT checked="true" name="{Name}" type="radio" value="false">
                                                            <xsl:value-of select="$com.novell.nps.ConfigData.FalseText"/>
                                                        </INPUT>
                                                    </xsl:when>
                                                    <xsl:otherwise>
                                                        <INPUT checked="true" name="{Name}" type="radio" value="true">
                                                            <xsl:value-of select="$com.novell.nps.ConfigData.TrueText"/>
                                                        </INPUT>
                                                        <BR/>
                                                        <INPUT name="{Name}" type="radio" value="false">
                                                            <xsl:value-of select="$com.novell.nps.ConfigData.FalseText"/>
                                                        </INPUT>
                                                    </xsl:otherwise>
                                                </xsl:choose>
                                            </xsl:otherwise>
                                        </xsl:choose>
                                    </xsl:when>
                                    <xsl:when test="@OnOff[.!=&apos;&apos;]">
                                        <xsl:attribute name="nowrap">true</xsl:attribute>
                                        <xsl:choose>
                                            <xsl:when test="../@UserConfiguring[.=&apos;true&apos;] and overwriteable[.=&apos;false&apos;]">
                                                <xsl:choose>
                                                    <xsl:when test="Value[.!=&apos;1&apos;]">
                                                        <xsl:value-of select="$com.novell.nps.ConfigData.OffText"/>
                                                        <INPUT name="{Name}" type="HIDDEN" value="0"/>
                                                    </xsl:when>
                                                    <xsl:otherwise>
                                                        <xsl:value-of select="$com.novell.nps.ConfigData.OnText"/>
                                                        <INPUT name="{Name}" type="HIDDEN" value="1"/>
                                                    </xsl:otherwise>
                                                </xsl:choose>
                                            </xsl:when>
                                            <xsl:otherwise>
                                                <xsl:choose>
                                                    <xsl:when test="Value[.!=&apos;1&apos;]">
                                                        <INPUT name="{Name}" type="radio" value="1">
                                                            <xsl:value-of select="$com.novell.nps.ConfigData.OnText"/>
                                                        </INPUT>
                                                        <INPUT checked="true" name="{Name}" type="radio" value="0">
                                                            <xsl:value-of select="$com.novell.nps.ConfigData.OffText"/>
                                                        </INPUT>
                                                    </xsl:when>
                                                    <xsl:otherwise>
                                                        <INPUT checked="true" name="{Name}" type="radio" value="1">
                                                            <xsl:value-of select="$com.novell.nps.ConfigData.OnText"/>
                                                        </INPUT>
                                                        <INPUT name="{Name}" type="radio" value="0">
                                                            <xsl:value-of select="$com.novell.nps.ConfigData.OffText"/>
                                                        </INPUT>
                                                    </xsl:otherwise>
                                                </xsl:choose>
                                            </xsl:otherwise>
                                        </xsl:choose>
                                    </xsl:when>
                                    <xsl:when test="@Wizard[.!=&apos;&apos;]">
                                        <xsl:choose>
                                            <xsl:when test="../@UserConfiguring[.=&apos;true&apos;] and overwriteable[.=&apos;false&apos;]">
                                                <xsl:value-of disable-output-escaping="yes" select="Value"/>
                                                <br/>
                                            </xsl:when>
                                            <xsl:otherwise>
                                                <xsl:value-of disable-output-escaping="yes" select="Value"/>
                                                <br/>
                                                <INPUT alt="{$com.novell.nps.ConfigData.EditSettingAltText}" name="wizard:{Name}" src="{$Portal.ResourcePath}{$com.novell.nps.ConfigData.ButtonEdit}" type="image"/>
                                            </xsl:otherwise>
                                        </xsl:choose>
                                    </xsl:when>
                                    <xsl:when test="@MultipleLineString[.!=&apos;&apos;]">
                                        <xsl:choose>
                                            <xsl:when test="../@UserConfiguring[.=&apos;true&apos;] and (overwriteable[.=&apos;false&apos;] or (cumulative[.=&apos;true&apos;] and Value/@Inherited[.=&apos;true&apos;]) )">
                                                <xsl:value-of disable-output-escaping="yes" select="Value"/>
                                                <br/>
                                                <INPUT name="{Name}" type="HIDDEN" value="{Value}"/>
                                            </xsl:when>
                                            <xsl:otherwise>
                                                <TEXTAREA name="{Name}">
                                                    <xsl:if test="@Length[.!=&apos;&apos;]">
                                                        <xsl:attribute name="rows">
                                                            <xsl:value-of select="@Length"/>
                                                        </xsl:attribute>
                                                    </xsl:if>
                                                    <xsl:if test="@Width[.!=&apos;&apos;]">
                                                        <xsl:attribute name="cols">
                                                            <xsl:value-of select="@Width"/>
                                                        </xsl:attribute>
                                                    </xsl:if>
                                                    <xsl:value-of disable-output-escaping="yes" select="Value"/>
                                                </TEXTAREA>
                                                <xsl:if test="(@TranslatableValues[.=&apos;true&apos;])">
                                                    <INPUT alt="{$com.novell.nps.ConfigData.TranslateAltText}" name="Languages:{Name}" src="{$Portal.ResourcePath}{$com.novell.nps.ConfigData.ButtonLanguages}" type="image"/>
                                                </xsl:if>
                                            </xsl:otherwise>
                                        </xsl:choose>
                                    </xsl:when>
                                    <xsl:otherwise>
                                        <xsl:choose>
                                            <xsl:when test="../@UserConfiguring[.=&apos;true&apos;] and (overwriteable[.=&apos;false&apos;] or (cumulative[.=&apos;true&apos;] and Value/@Inherited[.=&apos;true&apos;]) )">
                                                <xsl:value-of select="Value"/>
                                                <br/>
                                                <INPUT name="{Name}" type="HIDDEN" value="{Value}"/>
                                            </xsl:when>
                                            <xsl:otherwise>
                                                <INPUT name="{Name}" size="30" value="{Value}">
                                                    <xsl:choose>
                                                        <xsl:when test="@Password[.!=&apos;&apos;]">
                                                            <xsl:attribute name="type">password</xsl:attribute>
                                                        </xsl:when>
                                                        <xsl:otherwise>
                                                            <xsl:attribute name="type">text</xsl:attribute>
                                                        </xsl:otherwise>
                                                    </xsl:choose>
                                                    <xsl:if test="@Length[.!=&apos;&apos;]">
                                                        <xsl:attribute name="maxlength">
                                                            <xsl:value-of select="@Length"/>
                                                        </xsl:attribute>
                                                    </xsl:if>
                                                </INPUT>
                                                <xsl:if test="(@TranslatableValues[.=&apos;true&apos;])">
                                                    <INPUT alt="{$com.novell.nps.ConfigData.TranslateAltText}" name="Languages:{Name}" src="{$Portal.ResourcePath}{$com.novell.nps.ConfigData.ButtonLanguages}" type="image"/>
                                                </xsl:if>
                                                <xsl:if test="@Password[.!=&apos;&apos;]">
                                                    <br/>
                                                    <xsl:value-of select="$com.novell.nps.ConfigData.RetypePasswordText"/>
                                                    <br/>
                                                    <INPUT name="Retype:{Name}" size="30" type="password" value="{Value}">
                                                        <xsl:if test="@Length[.!=&apos;&apos;]">
                                                            <xsl:attribute name="maxlength">
                                                                <xsl:value-of select="@Length"/>
                                                            </xsl:attribute>
                                                        </xsl:if>
                                                    </INPUT>
                                                </xsl:if>
                                            </xsl:otherwise>
                                        </xsl:choose>
                                    </xsl:otherwise>
                                </xsl:choose>
                            </TD>
                        </TR>
                        <xsl:for-each select="ExtraValue">
                            <TR>
                                <TD>
                                    <xsl:choose>
                                        <xsl:when test="../@Wizard[.=&apos;true&apos;] or ../@OnOff[.=&apos;true&apos;] or ../@Boolean[.=&apos;true&apos;] or ../@Select[.=&apos;true&apos;]">
                                            <!-- Do Nothing -->
                                        </xsl:when>
                                        <xsl:otherwise>
                                            <xsl:choose>
                                                <xsl:when test="../../@UserConfiguring[.=&apos;true&apos;] and (../overwriteable[.=&apos;false&apos;] or (../cumulative[.=&apos;true&apos;] and @Inherited[.=&apos;true&apos;]) )">
                                                    <xsl:value-of select="."/>
                                                    <br/>
                                                    <INPUT name="{../Name}" type="HIDDEN" value="{.}"/>
                                                </xsl:when>
                                                <xsl:otherwise>
                                                    <xsl:if test="../@Password[.!=&apos;&apos;]">
                                                        <!-- For multiple passwords, put a horizontal row in between for visual clarity -->
                                                        <hr/>
                                                    </xsl:if>
                                                    <INPUT name="{../Name}" size="30" value="{.}">
                                                        <xsl:choose>
                                                            <xsl:when test="../@Password[.!=&apos;&apos;]">
                                                                <xsl:attribute name="type">password</xsl:attribute>
                                                            </xsl:when>
                                                            <xsl:otherwise>
                                                                <xsl:attribute name="type">text</xsl:attribute>
                                                            </xsl:otherwise>
                                                        </xsl:choose>
                                                        <xsl:if test="../@Length[.!=&apos;&apos;]">
                                                            <xsl:attribute name="maxlength">
                                                                <xsl:value-of select="../@Length"/>
                                                            </xsl:attribute>
                                                        </xsl:if>
                                                    </INPUT>
                                                    <xsl:if test="../@Password[.!=&apos;&apos;]">
                                                        <br/>
                                                        <xsl:value-of select="$com.novell.nps.ConfigData.RetypePasswordText"/>
                                                        <br/>
                                                        <INPUT name="Retype:{../Name}" size="30" type="password" value="{.}">
                                                            <xsl:if test="../@Length[.!=&apos;&apos;]">
                                                                <xsl:attribute name="maxlength">
                                                                    <xsl:value-of select="../@Length"/>
                                                                </xsl:attribute>
                                                            </xsl:if>
                                                        </INPUT>
                                                    </xsl:if>
                                                </xsl:otherwise>
                                            </xsl:choose>
                                        </xsl:otherwise>
                                    </xsl:choose>
                                </TD>
                            </TR>
                        </xsl:for-each>
                    </TABLE>
                    <xsl:choose>
                        <xsl:when test="../@UserConfiguring[.=&apos;true&apos;]">
                            <xsl:if test="(@Multiple[.=&apos;true&apos;] and overwriteable[.=&apos;true&apos;])">
                                <xsl:choose>
                                    <xsl:when test="@Wizard[.=&apos;true&apos;] or @OnOff[.=&apos;true&apos;] or @Boolean[.=&apos;true&apos;] or @Select[.=&apos;true&apos;]">
                                        <!-- Do Nothing -->
                                    </xsl:when>
                                    <xsl:otherwise>
                                        <div>
                                            <xsl:if test="(@Multiple[.=&apos;true&apos;] and overwriteable[.=&apos;true&apos;])">
                                                <INPUT alt="{$com.novell.nps.ConfigData.NewSettingValueAltText}" name="New:{Name}" src="{$Portal.ResourcePath}{$com.novell.nps.ConfigData.ButtonNewValue}" type="image"/>
                                                &#160;
                                            </xsl:if>
                                        </div>
                                    </xsl:otherwise>
                                </xsl:choose>
                            </xsl:if>
                        </xsl:when>
                        <xsl:otherwise>
                            <xsl:if test="(@Multiple[.=&apos;true&apos;])">
                                <xsl:choose>
                                    <xsl:when test="@Wizard[.=&apos;true&apos;] or @OnOff[.=&apos;true&apos;] or @Boolean[.=&apos;true&apos;] or @Select[.=&apos;true&apos;]">
                                        <!-- Do Nothing -->
                                    </xsl:when>
                                    <xsl:otherwise>
                                        <div>
                                            <xsl:if test="@Multiple[.=&apos;true&apos;]">
                                                <INPUT alt="{$com.novell.nps.ConfigData.NewSettingValueAltText}" name="New:{Name}" src="{$Portal.ResourcePath}{$com.novell.nps.ConfigData.ButtonNewValue}" type="image"/>
                                                &#160;
                                            </xsl:if>
                                        </div>
                                    </xsl:otherwise>
                                </xsl:choose>
                            </xsl:if>
                        </xsl:otherwise>
                    </xsl:choose>
                </TD>
                <xsl:if test="../@overwriteable[.!=&apos;&apos;]">
                    <TD align="left">
                        <xsl:choose>
                            <xsl:when test="overwriteable[.=&apos;true&apos;]">
                                <INPUT checked="true" name="overwriteable:{Name}" type="radio" value="true">
                                    <b>
                                        <xsl:value-of select="$com.novell.nps.ConfigData.TrueText"/>
                                    </b>
                                </INPUT>
                                <BR/>
                                <INPUT name="overwriteable:{Name}" type="radio" value="false">
                                    <xsl:value-of select="$com.novell.nps.ConfigData.FalseText"/>
                                </INPUT>
                            </xsl:when>
                            <xsl:otherwise>
                                <INPUT name="overwriteable:{Name}" type="radio" value="true">
                                    <xsl:value-of select="$com.novell.nps.ConfigData.TrueText"/>
                                </INPUT>
                                <BR/>
                                <INPUT checked="true" name="overwriteable:{Name}" type="radio" value="false">
                                    <b>
                                        <xsl:value-of select="$com.novell.nps.ConfigData.FalseText"/>
                                    </b>
                                </INPUT>
                            </xsl:otherwise>
                        </xsl:choose>
                    </TD>
                </xsl:if>
                <xsl:if test="../@cumulative[.!=&apos;&apos;]">
                    <TD align="left">
                        <xsl:choose>
                            <xsl:when test="cumulative[.=&apos;true&apos;]">
                                <INPUT checked="true" name="cumulative:{Name}" type="radio" value="true">
                                    <b>
                                        <xsl:value-of select="$com.novell.nps.ConfigData.TrueText"/>
                                    </b>
                                </INPUT>
                                <BR/>
                                <INPUT name="cumulative:{Name}" type="radio" value="false">
                                    <xsl:value-of select="$com.novell.nps.ConfigData.FalseText"/>
                                </INPUT>
                            </xsl:when>
                            <xsl:otherwise>
                                <INPUT name="cumulative:{Name}" type="radio" value="true">
                                    <xsl:value-of select="$com.novell.nps.ConfigData.TrueText"/>
                                </INPUT>
                                <BR/>
                                <INPUT checked="true" name="cumulative:{Name}" type="radio" value="false">
                                    <b>
                                        <xsl:value-of select="$com.novell.nps.ConfigData.FalseText"/>
                                    </b>
                                </INPUT>
                            </xsl:otherwise>
                        </xsl:choose>
                    </TD>
                </xsl:if>
                <xsl:if test="../@ShowDescriptions[.!=&apos;&apos;]">
                    <TD>
                        <xsl:value-of disable-output-escaping="yes" select="Range"/>
                    </TD>
                    <TD>
                        <xsl:value-of disable-output-escaping="yes" select="Description"/>
                    </TD>
                </xsl:if>
            </TR>
        </xsl:if>
    </xsl:template>

    <xsl:template match="ConfigDataLanguages">
        <FORM action="{$Portal.Servlet.Normal}" method="POST">
            <input name="GI_ID" type="hidden" value="{ID}"/>
            <INPUT name="ConfigDataLanaguageForm" type="HIDDEN" value="true"/>
            <TABLE bgcolor="FFFFFF" border="0" cellpadding="3" cellspacing="0">
                <TR>
                    <TD>
                        <div class="head2b">
                            <xsl:value-of select="$com.novell.nps.ConfigData.SpecifyLanguageTranslationsText"/>
                        </div>
                        <div class="formdescriptext">
                            <xsl:value-of select="$com.novell.nps.ConfigData.HowToSpecifyLanguageTranslationsText"/>
                        </div>
                        <p class="head1"/>
                    </TD>
                </TR>
                <TR class="tablehead2">
                    <TD>
                        <div class="tablehead2">
                            <xsl:value-of select="$com.novell.nps.ConfigData.LanguageTranslationsHeadingText"/>
                        </div>
                    </TD>
                </TR>
                <xsl:for-each select="SettingValue">
                    <TR>
                        <TD>
                            <TABLE cellpadding="3" cellspacing="0" width="100%">
                                <TR bgcolor="#efeee9">
                                    <TD colspan="2">
                                        <xsl:value-of select="$com.novell.nps.ConfigData.SettingValueText"/>
                                        &#160;
                                        <b><xsl:value-of select="ActualValue"/></b>
                                    </TD>
                                </TR>
                                <TR>
                                    <TH>
                                        <div class="tablecolumnhead1">
                                            <xsl:value-of select="$com.novell.nps.ConfigData.LanguageCodeText"/>
                                        </div>
                                    </TH>
                                    <TH>
                                        <div class="tablecolumnhead1">
                                            <xsl:value-of select="$com.novell.nps.ConfigData.TranslationText"/>
                                        </div>
                                    </TH>
                                </TR>
                                <xsl:for-each select="DisplayValue">
                                    <TR>
                                        <xsl:if test="not (position() mod 2)">
                                            <xsl:attribute name="bgcolor">#efeee9</xsl:attribute>
                                        </xsl:if>
                                        <xsl:choose>
                                            <xsl:when test="@extra[.!='']">
                                                <TD>
                                                    <INPUT name="Languages:{../Number}" size="10" type="text"/>
                                                </TD>
                                                <TD>
                                                    <INPUT name="DisplayValue:{../Number}" size="50" type="text"/>
                                                </TD>
                                            </xsl:when>
                                            <xsl:otherwise>
                                                <TD>
                                                    <xsl:value-of select="LanguageString"/>
                                                    <INPUT name="Languages:{../Number}" type="hidden" value="{LanguageCode}"/>
                                                </TD>
                                                <TD>
                                                    <INPUT name="DisplayValue:{../Number}" size="50" type="text" value="{Value}"/>
                                                </TD>
                                            </xsl:otherwise>
                                        </xsl:choose>
                                    </TR>
                                </xsl:for-each>
                                <TR>
                                    <TD colspan="2">
                                        <INPUT alt="{$com.novell.nps.ConfigData.NewTranslationAltText}" name="New:{Number}" src="{$Portal.ResourcePath}{$com.novell.nps.ConfigData.ButtonNewTranslation}" type="image"/>
                                    </TD>
                                </TR>
                            </TABLE>
                        </TD>
                    </TR>
                </xsl:for-each>
                <TR height="10">
                    <td height="10" nowrap="true"/>
                </TR>
                <TR>
                    <TD class="ruleabove">
                        <INPUT alt="{$com.novell.nps.ConfigData.OKAltText}" name="OK" src="{$Portal.ResourcePath}{$com.novell.nps.ConfigData.ButtonOK}" type="image"/>
                        &#160;
                        <INPUT alt="{$com.novell.nps.ConfigData.CancelAltText}" name="Cancel" src="{$Portal.ResourcePath}{$com.novell.nps.ConfigData.ButtonCancel}" type="image"/>
                    </TD>
                </TR>
            </TABLE>
        </FORM>
    </xsl:template>

    <xsl:template match="ConfigDataNewLanguage">
        <FORM action="{$Portal.Servlet.Normal}" method="POST">
            <input name="GI_ID" type="hidden" value="{ID}"/>
            <INPUT name="ConfigDataNewLanguageForm" type="HIDDEN" value="true"/>
            <TABLE bgcolor="FFFFFF" border="0" cellpadding="3" cellspacing="0">
                <TR>
                    <TD>
                        <div class="head2b">
                            <xsl:value-of select="$com.novell.nps.ConfigData.AvailableLanguagesText"/>
                        </div>
                        <div class="formdescriptext">
                            <xsl:value-of select="$com.novell.nps.ConfigData.AvailableLanguagesDescriptionText"/>
                        </div>
                        <p class="head1"/>
                    </TD>
                </TR>
                <TR>
                    <TD>
                        <xsl:value-of select="$com.novell.nps.ConfigData.AllLanguagesHeaderText"/>
                    </TD>
                </TR>
                <TR>
                    <TD valign="top">
                        <SELECT multiple="true" name="AllLanguageSource" size="10">
                            <xsl:for-each select="AllLanguageSource">
                                <xsl:sort order="ascending" select="DisplayName"/>
                                <OPTION value="{ActualName}">
                                    <xsl:value-of select="DisplayName"/>
                                </OPTION>
                            </xsl:for-each>
                            <!-- Dummy entry to help the list box width -->
                            <option value="">                                                                                                                                           </option>
                        </SELECT>
                    </TD>
                </TR>
                <TR>
                    <TD>
                        <div class="formdescriptext">
                            <xsl:value-of select="$com.novell.nps.ConfigData.UseCtrlShiftToMultipleSelect"/>
                        </div>
                    </TD>
                </TR>
                <TR>
                    <TD>
                        <xsl:value-of select="$com.novell.nps.ConfigData.EnterNewLanguageCodeText"/>
                        <br/>
                        <INPUT type="text" size="15" name="NewLanguageCode"/>
                    </TD>
                </TR>
                <TR height="10">
                    <td height="10" nowrap="true"/>
                </TR>
                <TR>
                    <TD class="ruleabove">
                        <INPUT alt="{$com.novell.nps.ConfigData.AddNewLanguageAltText}" name="Add" src="{$Portal.ResourcePath}{$com.novell.nps.ConfigData.ButtonAdd}" type="image"/>
                        &#160;
                        <INPUT alt="{$com.novell.nps.ConfigData.CancelAltText}" name="Cancel" src="{$Portal.ResourcePath}{$com.novell.nps.ConfigData.ButtonCancel}" type="image"/>
                    </TD>
                </TR>
            </TABLE>
        </FORM>
    </xsl:template>

</xsl:stylesheet>

<!-- Stylus Studio meta-information - (c)1998-2002 eXcelon Corp.
<metaInformation>
<scenarios/><MapperInfo srcSchemaPath="" srcSchemaRoot="" srcSchemaPathIsRelative="yes" destSchemaPath="" destSchemaRoot="" destSchemaPathIsRelative="yes"/>
</metaInformation>
-->