<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:variable name="Portal.Layout.BackgroundImage"/>
	<xsl:variable name="Portal.Layout.Color.Background">
		<xsl:value-of select="/PortalData/Layout/Portal.Layout.Color.Background"/>
	</xsl:variable>
	<xsl:variable name="Portal.Layout.Text.Color.Normal">
		<xsl:value-of select="/PortalData/Layout/Portal.Layout.Text.Color.Normal"/>
	</xsl:variable>
	<xsl:variable name="Portal.Layout.Text.Color.Heading">
		<xsl:value-of select="/PortalData/Layout/Portal.Layout.Text.Color.Heading"/>
	</xsl:variable>
	<xsl:variable name="Portal.Layout.Text.Color.Alternate">
		<xsl:value-of select="/PortalData/Layout/Portal.Layout.Text.Color.Alternate"/>
	</xsl:variable>
	<xsl:variable name="Portal.Layout.Text.Color.Link">
		<xsl:value-of select="/PortalData/Layout/Portal.Layout.Text.Color.Link"/>
	</xsl:variable>
	<xsl:variable name="Portal.Layout.Text.Color.VisitedLink">
		<xsl:value-of select="/PortalData/Layout/Portal.Layout.Text.Color.VisitedLink"/>
	</xsl:variable>
	<xsl:variable name="Portal.Layout.Text.Color.ActiveLink">
		<xsl:value-of select="/PortalData/Layout/Portal.Layout.Text.Color.ActiveLink"/>
	</xsl:variable>
	<xsl:variable name="Portal.BrandingArea.Color.Background">
		<xsl:value-of select="/PortalData/Layout/Portal.BrandingArea.Color.Background"/>
	</xsl:variable>
	<xsl:variable name="Portal.InheritableArea.Color.Background">
		<xsl:value-of select="/PortalData/Layout/Portal.InheritableArea.Color.Background"/>
	</xsl:variable>
	<xsl:variable name="Portal.ObjectScheme.Color.Background">
		<xsl:value-of select="/PortalData/Layout/Portal.ObjectScheme.Color.Background"/>
	</xsl:variable>
	<xsl:variable name="Portal.Gadget.Color.Background">
		<xsl:value-of select="/PortalData/Layout/Portal.Gadget.Color.Background"/>
	</xsl:variable>
	<xsl:variable name="Portal.Gadget.TitleBar.Color.Background">
		<xsl:value-of select="/PortalData/Layout/Portal.Gadget.TitleBar.Color.Background"/>
	</xsl:variable>
	<xsl:variable name="Portal.Gadget.TitleBar.Color.Foreground">
		<xsl:value-of select="/PortalData/Layout/Portal.Gadget.TitleBar.Color.Foreground"/>
	</xsl:variable>
	<xsl:variable name="Portal.ObjectScheme.Select.Active.Color.Background">
		<xsl:value-of select="/PortalData/Layout/Portal.ObjectScheme.Select.Active.Color.Background"/>
	</xsl:variable>
	<xsl:variable name="Portal.ObjectScheme.Select.Active.Color.Foreground">
		<xsl:value-of select="/PortalData/Layout/Portal.ObjectScheme.Select.Active.Color.Foreground"/>
	</xsl:variable>
	<xsl:variable name="Portal.ObjectScheme.Select.Inactive.Color.Background">
		<xsl:value-of select="/PortalData/Layout/Portal.ObjectScheme.Select.Inactive.Color.Background"/>
	</xsl:variable>
	<xsl:variable name="Portal.ObjectScheme.Select.Inactive.Color.Foreground">
		<xsl:value-of select="/PortalData/Layout/Portal.ObjectScheme.Select.Inactive.Color.Foreground"/>
	</xsl:variable>
	<xsl:attribute-set name="Portal.Layout.Attributes">
		<xsl:attribute name="background">
			<xsl:value-of select="$Portal.Layout.BackgroundImage"/>
		</xsl:attribute>
		<xsl:attribute name="bgcolor">
			<xsl:value-of select="$Portal.Layout.Color.Background"/>
		</xsl:attribute>
		<xsl:attribute name="text">
			<xsl:value-of select="$Portal.Layout.Text.Color.Normal"/>
		</xsl:attribute>
		<xsl:attribute name="link">
			<xsl:value-of select="$Portal.Layout.Text.Color.Link"/>
		</xsl:attribute>
		<xsl:attribute name="alink">
			<xsl:value-of select="$Portal.Layout.Text.Color.ActiveLink"/>
		</xsl:attribute>
		<xsl:attribute name="vlink">
			<xsl:value-of select="$Portal.Layout.Text.Color.VisitedLink"/>
		</xsl:attribute>
		<xsl:attribute name="topmargin">0</xsl:attribute>
		<xsl:attribute name="leftmargin">0</xsl:attribute>
		<xsl:attribute name="marginheight">0</xsl:attribute>
		<xsl:attribute name="marginwidth">0</xsl:attribute>
	</xsl:attribute-set>
	<xsl:attribute-set name="Portal.Gadget.TitleBar.Attributes">
		<xsl:attribute name="bgcolor">
			<xsl:value-of select="$Portal.Gadget.TitleBar.Color.Background"/>
		</xsl:attribute>
		<xsl:attribute name="width">100%</xsl:attribute>
		<xsl:attribute name="align">left</xsl:attribute>
		<xsl:attribute name="valign">middle</xsl:attribute>
	</xsl:attribute-set>
	<xsl:attribute-set name="Portal.Gadget.TitleBar.Font.Attributes">
		<xsl:attribute name="color">
			<xsl:value-of select="$Portal.Gadget.TitleBar.Color.Foreground"/>
		</xsl:attribute>
		<xsl:attribute name="size">+1</xsl:attribute>
	</xsl:attribute-set>
	<xsl:variable name="Portal.Layout.CSS">
		<STYLE>
			<!-- Human Factors Styles -->
			a { color: #039; text-decoration: underline }
         body, th, tr, td, table  { font-family: "Trebuchet MS", Arial, Helvetica, Geneva, Swiss, SunSans-Regular }
			input, select, textarea, option, button { font-family: "Trebuchet MS", Arial, Helvetica, Geneva, Swiss, SunSans-Regular }
			p, option, li, ol, ul  { font-size: 1em }

			h1  { font-weight: bold; font-size: 1.3em; line-height: 1.3em; margin-bottom: 0.6em }
			h2  { font-weight: bold; font-size: 1.2em; line-height: 1.2em; margin-bottom: 0.4em }
			h3  { font-weight: bold; font-size: 1em; line-height: 1.1em; margin-bottom: 0.2em }
			h4  { font-weight: bold; font-size: 0.85em; line-height: 1em; margin-bottom: 0.1em }

			img.margin1 { margin: 1px }
			img.margin2 { margin: 2px }
			img.margin4 { margin: 4px }
			img.margin5r { margin-right: 5px }
			img.margin6 { margin: 6px }
			img.margin8 { margin: 8px }
			img.margin10 { margin: 10px }
			img.margin10l { margin-left: 10px; margin-right: 5px }

			span.tab1u { color: black }
			span.tab2u { text-decoration: underline }
<!--
			span.tab2s { text-decoration: underline }
-->
			.activitycolor { background-color: #e8e887 }
			.errorlink { color: #c82727; text-decoration: underline; margin-top: 2px }
			.errorhead { color: #c82727; font-style: normal; font-weight: 800; font-size: 1.2em; line-height: 1.5em; margin-bottom: 1.5em }

			.formcolumnhead1 { color: #556c79; font-weight: bold; font-size: 0.7em; text-align: center }
			.formhead1 { color: white; font-weight: bold; font-size: 1em; line-height: 1.2em; background-color: #6b8899; text-align: left; text-indent: 0.5em; letter-spacing: 0.1em; vertical-align: middle }
			.formhead1b { color: white; font-weight: bold; font-size: 1em; line-height: 1.2em; background-color: #6b8899; text-align: left; text-indent: 0.5em; vertical-align: middle }
			.formdescriptext { color: #355263; font-size: 0.8em; margin-left: 1em }
			.formdescriptextml0 { color: #355263; font-size: 0.8em }
			.head1 { color: black; font-weight: bold; font-size: 1.3em; line-height: 1.3em; margin-bottom: 0.6em }
			.head1a { color: #663; font-weight: bold; font-size: 1.3em; line-height: 1.3em; margin-bottom: 0.6em; margin-left: 1em }
			.head1b { color: black; font-weight: bold; font-size: 1.3em; line-height: 1.3em }
			.head1w { color: white; font-weight: bold; font-size: 1.3em; line-height: 1.3em }

			.head2 { color: black; font-weight: bold; font-size: 1.2em; margin-top: 0.4em }
			.head2a { color: #663; font-weight: bold; font-size: 1.2em; margin-top: 0.4em }
			.head2b { color: black; font-weight: 600; font-size: 1.2em; letter-spacing: 0.1em; margin-top: 0.4em; margin-bottom: 0.3em; border-bottom: 2px solid #458ab9 }
			.head2tm6 { color: black; font-weight: bold; font-size: 1.2em; margin-top: 0.6em }
			.head2w { color: #fff; font-weight: bold; font-size: 1.2em; }
			.head2indent { color: black; font-weight: bold; font-size: 1.2em; margin-top: 0.4em; margin-left: 0.5em }

			.head3 { color: black; font-weight: bold; font-size: 1em; margin-top: 0.3em }
			.head3a { color: #663; font-weight: bold; font-size: 1em; margin-top: 0.3em }
			.head3b { color: black; font-weight: bold; font-size: 1em; letter-spacing: 0.1em; margin-top: 0.2em; margin-bottom: 0.3em; border-bottom: 2px solid #458ab9 }
			.head3d { color: black; font-weight: bold; font-size: 1em }
			.head3center { color: black; font-weight: bold; font-size: 1em; text-align: center }
			.head3indent { color: black; font-weight: bold; font-size: 1em; margin-top: 0.3em; margin-left: 1em }
			.head3tm6 { color: black; font-weight: bold; font-size: 1em; margin-top: 0.6em }
			.head3w { color: #fff; font-weight: bold; font-size: 1em }

			.head4 { color: black; font-weight: bold; font-size: 0.85em; margin-top: 0.2em }
			.head4center { color: black; font-weight: bold; font-size: 0.85em; text-align: center }
			.head4b { color: #663; font-weight: bold; font-size: 0.85em; margin-top: 0.2em }
			.head4tm6 { color: black; font-weight: bold; font-size: 0.85em; margin-top: 0.6em }
			.head4margin4 { color: black; font-weight: bold; font-size: 0.85em; background-color: #dfddd5; margin: 0.4em }

			.head5 { color: black; font-weight: 600; font-size: 0.75em; margin-top: 0.2em }
			.head5b { color: #663; font-weight: 600; font-size: 0.75em; margin-top: 0.2em }
			.head5tm6 { color: black; font-weight: 600; font-size: 0.75em; margin-top: 0.6em; margin-left: 1em }

			.hint1 { color: #663; font-size: 12px; line-height: 14px }

			.inactive  { color: #458ab9 }
			.margintop1 { margin-top: 0.3em }
			.margintop2 { margin-top: 0.5em }
			.margintop3 { margin-top: 1em }
			.marginleft1 { margin-left: 1em }
			.marginleft1b { font-size: 0.85em; margin-left: 1em }
			.marginleft2 { margin-left: 2em }
			.marginleft3 { margin-left: 3em }
			.marginleft4 { margin-left: 4em }

			.nonproportional  { font-size: 10pt; font-family: "Courier New", Courier, Monaco }
			.padding8 { padding: 8px }
			.padding2x4 { padding-top: 2px; padding-bottom: 2px; padding-right: 4px; padding-left: 4px }
			.padding2 { padding: 2px }
			.scroll1 { background-color: #efeee9; padding: 10px 12px 10px 10px; overflow: auto }
			.padding4 { padding: 4px }
			.rowaltcolor { background-color: #efeee9 }

			.ruleblue { color: #458ab9 }
			.rulebelow { padding-bottom: 4px; border-bottom: 2px solid #458ab9 }
			.ruleabove { padding-top: 4px; border-top: 2px solid #458ab9 }

			.smalltext { font-size: 0.75em; line-height: 1em }
			.smalltext2a { color: #663; font-size: 0.75em; line-height: 1em }
			.smalltext2b { color: black; font-weight: bold; font-size: 0.75em; line-height: 1em }
			.smalltext2c  { color: #355263; font-size: 0.75em; line-height: 1.1em; width: 480px }
			.smalltext2d { color: #355263; font-size: 0.75em; line-height: 1em }
			.mediumtext { font-size: 0.85em; line-height: 1.1em }
			.textblue1  { color: #355263; font-size: 0.9em; line-height: 1.2em }

			.tablecolumnhead1 { color: #663; font-weight: bold; font-size: 0.7em; text-align: center }
			.tablecolumnhead2 { color: #663; font-weight: 600; font-size: 0.75em }
			.tablehead1 { font-weight: bold; font-size: 1em; line-height: 1.1em; background-color: #cc9; text-align: left; text-indent: 0.5em; letter-spacing: 0.1em }
			.tablehead2 { font-weight: bold; font-size: 1em; line-height: 1.1em; background-color: #cc9; text-align: left; text-indent: 0.5em; letter-spacing: 0.1em }
			.tablehead1b { font-weight: bold; font-size: 1em; line-height: 1.1em; background-color: #cc9; text-align: left; text-indent: 0.5em }
			.tablesubhead1 { color: black; font-weight: bold; font-size: 0.85em; background-color: #efeee9; text-align: left; text-indent: 0.5em }

			.tabb { font-weight: bold; font-size: 14pt;}
			.tabw { color: white; font-weight: bold; font-size: 14pt; }

			.task1 { margin-top: 0.3em; margin-left: 1em; font-size: 0.8em }
			.task2 { margin-top: 0.3em; margin-left: 2em; font-size: 0.8em }

			.windowheaddgrey { color: #5a5958; font-weight: bold; font-size: 18pt; line-height: 18pt; letter-spacing: 1px }
			.windowheadblack { color: #5a5958; font-weight: bold; font-size: 18pt; line-height: 18pt; letter-spacing: 1px }
			.windowheadwhite { color: white; font-weight: bold; font-size: 18pt; line-height: 18pt; letter-spacing: 1px }

			.width350 { width: 350px }
			.width300 { width: 300px }
			.width400 { width: 400px }
			.width450 { width: 450px }
			.width500 { width: 500px }

			.headcapwide { color: #663; font-weight: 600; font-size: 0.6em; letter-spacing: 0.2em }
			.subtitle1 { color: black; font-weight: bold; font-size: 14px; line-height: 14px }
			.subtitle2 { color: white; font-weight: bold; font-size: 14px; line-height: 14px }

			.headpb { color: black; font-weight: bold; font-size: 15px; text-align: left; vertical-align: top; letter-spacing:2px;}
			.tab1s { color: white; font-weight: bold; font-size: 12px; line-height: 17px; text-decoration: none; background-color: #6b8899; text-align: center }
			.tab1u { color: black; background-color: #DFDDD5; font-size: 12px; text-decoration: none; font-weight: bold; text-align: center }
			.tab2s { color: white; font-weight: bold; font-size: 11px; text-decoration: none; background-color: #6b8899 }
			.tab2u { color: white; font-weight: normal; font-size: 11px; text-decoration: none; background-color: #6b8899 }

			.npsadmin A
			{
				COLOR: #039;
				FONT-FAMILY: "Trebuchet MS", Arial, Helvetica, Geneva, Swiss, SunSans-Regular;
				TEXT-DECORATION: underline
			}
			.npsadmin BODY
			{
				COLOR: black;
				FONT-FAMILY: "Trebuchet MS", Arial, Helvetica, Geneva, Swiss, SunSans-Regular;
				FONT-SIZE: 0.8em;
				LINE-HEIGHT: 1.3em
			}
			.npsadmin P
			{
				COLOR: black;
				FONT-FAMILY: "Trebuchet MS", Arial, Helvetica, Geneva, Swiss, SunSans-Regular
			}
			.npsadmin TD
			{
				COLOR: black;
				FONT-FAMILY: "Trebuchet MS", Arial, Helvetica, Geneva, Swiss, SunSans-Regular;
				FONT-SIZE: 0.8em
			}
			.npsadmin TH
			{
				COLOR: black;
				FONT-FAMILY: "Trebuchet MS", Arial, Helvetica, Geneva, Swiss, SunSans-Regular;
				FONT-SIZE: 0.8em;
				FONT-STYLE: normal;
				FONT-WEIGHT: 800;
				TEXT-INDENT: 4px
			}

			.exampledescriptext
			{
				COLOR: #355263;
				FONT-SIZE: 0.9em;
			}
			.columnhead1
			{
				FONT-WEIGHT: 800;
				LETTER-SPACING: 2px;
				MARGIN-BOTTOM: 4px;
				MARGIN-TOP: 10px;
				TEXT-INDENT: 2px
			}
			.alttabletext
			{
				BACKGROUND-COLOR: #efeee9
			}
			.tabletext
			{
				BACKGROUND-COLOR: #ffffff
			}
			.tableheadnotavailable
			{
				BACKGROUND-COLOR: #999999;
				COLOR: white;
				FONT-WEIGHT: bold;
				LETTER-SPACING: 2px;
				MARGIN-LEFT: 8px
			}
			.normaltext
			{
				color: black;
				font-size: 0.8em;
				line-height: 1.3em;
				font-family: Trebuchet MS, Arial, Helvetica, Geneva
			}

			<!-- Skin Specific Styles -->
		</STYLE>
	</xsl:variable>

	<xsl:template match="*|/">
		<xsl:apply-templates/>
	</xsl:template>
	<xsl:template match="text()|@*">
		<xsl:value-of select="."/>
	</xsl:template>
	<xsl:variable name="Portal.Servlet.Normal" select="/PortalData/SessionInfo/WebAppInfo/Servlets/Normal"/>
	<xsl:variable name="Portal.Servlet.FullPage" select="/PortalData/SessionInfo/WebAppInfo/Servlets/FullPage"/>
	<xsl:variable name="Portal.Servlet.CustomContent" select="/PortalData/SessionInfo/WebAppInfo/Servlets/CustomContent"/>
    <xsl:variable name="Portal.Servlet.FullFrame" select="/PortalData/SessionInfo/WebAppInfo/Servlets/FullFrame"/>
	<xsl:variable name="Portal.ResourcePath" select="/PortalData/SessionInfo/WebAppInfo/ResourcePath"/>

	<xsl:variable name="Portal.WebAppContext" select="substring-before(substring-after($Portal.Servlet.Normal,'/'),'/servlet/')"/>
	<xsl:variable name="Portal.Session.BrowserXSLSupport"><xsl:value-of select="/PortalData/SessionInfo/BrowserXSLSupport"/></xsl:variable>
	<xsl:variable name="Portal.Servlet.Service">/<xsl:value-of select="$Portal.WebAppContext"/>/servlet/<xsl:if test="$Portal.Session.BrowserXSLSupport='true'">xml</xsl:if>service?</xsl:variable>

	<xsl:variable name="Portal.Session.UserCN" select="/PortalData/SessionInfo/User/CN"/>
	<xsl:variable name="Portal.Session.UserDN" select="/PortalData/SessionInfo/User/DN"/>
</xsl:stylesheet>
<!-- Stylesheet edited using Stylus Studio - (c)1998-2002 eXcelon Corp. -->