/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestEvent;
import javax.servlet.ServletRequestListener;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.Context;
import org.apache.catalina.HttpRequest;
import org.apache.catalina.Logger;
import org.apache.catalina.Request;
import org.apache.catalina.Response;
import org.apache.catalina.ValveContext;
import org.apache.catalina.Wrapper;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.util.StringManager;
import org.apache.catalina.valves.ValveBase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tomcat.util.buf.MessageBytes;
import org.apache.tomcat.util.log.SystemLogHandler;

final class StandardContextValve
extends ValveBase {
    private static final String info = "org.apache.catalina.core.StandardContextValve/1.0";
    private static final StringManager sm = StringManager.getManager("org.apache.catalina.core");
    private static Log log = LogFactory.getLog((Class)(class$org$apache$catalina$core$StandardContextValve == null ? (class$org$apache$catalina$core$StandardContextValve = StandardContextValve.class$("org.apache.catalina.core.StandardContextValve")) : class$org$apache$catalina$core$StandardContextValve));
    static /* synthetic */ Class class$org$apache$catalina$core$StandardContextValve;

    StandardContextValve() {
    }

    public String getInfo() {
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void invoke(Request request, Response response, ValveContext valveContext) throws IOException, ServletException {
        block10: {
            Wrapper wrapper;
            block9: {
                HttpRequest hreq = (HttpRequest)request;
                MessageBytes requestPathMB = hreq.getRequestPathMB();
                if (requestPathMB.startsWithIgnoreCase("/META-INF/", 0) || requestPathMB.equalsIgnoreCase("/META-INF") || requestPathMB.startsWithIgnoreCase("/WEB-INF/", 0) || requestPathMB.equalsIgnoreCase("/WEB-INF")) {
                    String requestURI = hreq.getDecodedRequestURI();
                    this.notFound(requestURI, (HttpServletResponse)response.getResponse());
                    return;
                }
                while (((StandardContext)this.container).getPaused()) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {}
                }
                wrapper = request.getWrapper();
                if (wrapper == null) {
                    String requestURI = hreq.getDecodedRequestURI();
                    this.notFound(requestURI, (HttpServletResponse)response.getResponse());
                    return;
                }
                if (!((StandardContext)this.container).getSwallowOutput()) break block9;
                try {
                    SystemLogHandler.startCapture();
                    this.invokeInternal(wrapper, request, response);
                    Object var9_10 = null;
                }
                catch (Throwable throwable) {
                    Object var9_11 = null;
                    String log = SystemLogHandler.stopCapture();
                    if (log != null && log.length() > 0) {
                        this.container.getLogger().log(log);
                    }
                    throw throwable;
                }
                String log = SystemLogHandler.stopCapture();
                if (log != null && log.length() > 0) {
                    this.container.getLogger().log(log);
                }
                break block10;
            }
            this.invokeInternal(wrapper, request, response);
        }
    }

    private void invokeInternal(Wrapper wrapper, Request request, Response response) throws IOException, ServletException {
        ServletRequestListener listener;
        int i;
        Object[] instances = ((Context)this.container).getApplicationEventListeners();
        ServletRequestEvent event = null;
        if (instances != null && instances.length > 0) {
            event = new ServletRequestEvent(((StandardContext)this.container).getServletContext(), request.getRequest());
            for (i = 0; i < instances.length; ++i) {
                if (instances[i] == null || !(instances[i] instanceof ServletRequestListener)) continue;
                listener = (ServletRequestListener)instances[i];
                try {
                    listener.requestInitialized(event);
                    continue;
                }
                catch (Throwable t) {
                    this.log(sm.getString("requestListenerValve.requestInit", instances[i].getClass().getName()), t);
                    ServletRequest sreq = request.getRequest();
                    sreq.setAttribute("javax.servlet.error.exception", (Object)t);
                    return;
                }
            }
        }
        wrapper.getPipeline().invoke(request, response);
        if (instances != null && instances.length > 0) {
            for (i = 0; i < instances.length; ++i) {
                if (instances[i] == null || !(instances[i] instanceof ServletRequestListener)) continue;
                listener = (ServletRequestListener)instances[i];
                try {
                    listener.requestDestroyed(event);
                    continue;
                }
                catch (Throwable t) {
                    this.log(sm.getString("requestListenerValve.requestDestroy", instances[i].getClass().getName()), t);
                    ServletRequest sreq = request.getRequest();
                    sreq.setAttribute("javax.servlet.error.exception", (Object)t);
                }
            }
        }
    }

    private void badRequest(String requestURI, HttpServletResponse response) {
        try {
            response.sendError(400, requestURI);
        }
        catch (IllegalStateException e) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void forbidden(String requestURI, HttpServletResponse response) {
        try {
            response.sendError(403, requestURI);
        }
        catch (IllegalStateException e) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void notFound(String requestURI, HttpServletResponse response) {
        try {
            response.sendError(404, requestURI);
        }
        catch (IllegalStateException e) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void log(String message) {
        Logger logger = null;
        if (this.container != null) {
            logger = this.container.getLogger();
        }
        if (logger != null) {
            logger.log("StandardContextValve[" + this.container.getName() + "]: " + message);
        } else {
            String containerName = null;
            if (this.container != null) {
                containerName = this.container.getName();
            }
            System.out.println("StandardContextValve[" + containerName + "]: " + message);
        }
    }

    private void log(String message, Throwable throwable) {
        Logger logger = null;
        if (this.container != null) {
            logger = this.container.getLogger();
        }
        if (logger != null) {
            logger.log("StandardContextValve[" + this.container.getName() + "]: " + message, throwable);
        } else {
            String containerName = null;
            if (this.container != null) {
                containerName = this.container.getName();
            }
            System.out.println("StandardContextValve[" + containerName + "]: " + message);
            System.out.println("" + throwable);
            throwable.printStackTrace(System.out);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

