/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.realm;

import java.security.Principal;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Properties;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.Realm;
import org.apache.catalina.realm.GenericPrincipal;
import org.apache.catalina.realm.RealmBase;
import org.apache.catalina.util.StringManager;

public class JDBCRealm
extends RealmBase {
    protected String connectionName = null;
    protected String connectionPassword = null;
    protected String connectionURL = null;
    protected Connection dbConnection = null;
    protected Driver driver = null;
    protected String driverName = null;
    protected static final String info = "org.apache.catalina.realm.JDBCRealm/1.0";
    protected static final String name = "JDBCRealm";
    protected PreparedStatement preparedCredentials = null;
    protected PreparedStatement preparedRoles = null;
    protected String roleNameCol = null;
    protected static final StringManager sm = StringManager.getManager((String)"org.apache.catalina.realm");
    protected String userCredCol = null;
    protected String userNameCol = null;
    protected String userRoleTable = null;
    protected String userTable = null;

    public String getConnectionName() {
        return this.connectionName;
    }

    public void setConnectionName(String connectionName) {
        this.connectionName = connectionName;
    }

    public String getConnectionPassword() {
        return this.connectionPassword;
    }

    public void setConnectionPassword(String connectionPassword) {
        this.connectionPassword = connectionPassword;
    }

    public String getConnectionURL() {
        return this.connectionURL;
    }

    public void setConnectionURL(String connectionURL) {
        this.connectionURL = connectionURL;
    }

    public String getDriverName() {
        return this.driverName;
    }

    public void setDriverName(String driverName) {
        this.driverName = driverName;
    }

    public String getRoleNameCol() {
        return this.roleNameCol;
    }

    public void setRoleNameCol(String roleNameCol) {
        this.roleNameCol = roleNameCol;
    }

    public String getUserCredCol() {
        return this.userCredCol;
    }

    public void setUserCredCol(String userCredCol) {
        this.userCredCol = userCredCol;
    }

    public String getUserNameCol() {
        return this.userNameCol;
    }

    public void setUserNameCol(String userNameCol) {
        this.userNameCol = userNameCol;
    }

    public String getUserRoleTable() {
        return this.userRoleTable;
    }

    public void setUserRoleTable(String userRoleTable) {
        this.userRoleTable = userRoleTable;
    }

    public String getUserTable() {
        return this.userTable;
    }

    public void setUserTable(String userTable) {
        this.userTable = userTable;
    }

    public synchronized Principal authenticate(String username, String credentials) {
        for (int numberOfTries = 2; numberOfTries > 0; --numberOfTries) {
            try {
                this.open();
                Principal principal = this.authenticate(this.dbConnection, username, credentials);
                return principal;
            }
            catch (SQLException e) {
                this.log(sm.getString("jdbcRealm.exception"), e);
                if (this.dbConnection == null) continue;
                this.close(this.dbConnection);
                continue;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Principal authenticate(Connection dbConnection, String username, String credentials) throws SQLException {
        GenericPrincipal genericPrincipal;
        block19: {
            ResultSet rs;
            PreparedStatement stmt;
            block17: {
                Principal principal;
                block18: {
                    String dbCredentials;
                    block15: {
                        Principal principal2;
                        block16: {
                            dbCredentials = null;
                            stmt = null;
                            rs = null;
                            stmt = this.credentials(dbConnection, username);
                            rs = stmt.executeQuery();
                            if (rs.next()) {
                                dbCredentials = rs.getString(1);
                            }
                            rs.close();
                            rs = null;
                            if (dbCredentials != null) break block15;
                            principal2 = null;
                            Object var11_9 = null;
                            if (rs == null) break block16;
                            try {
                                rs.close();
                            }
                            catch (SQLException e) {
                                this.log(sm.getString("jdbcRealm.abnormalCloseResultSet"));
                            }
                        }
                        dbConnection.commit();
                        return principal2;
                    }
                    dbCredentials = dbCredentials.trim();
                    boolean validated = false;
                    validated = this.hasMessageDigest() ? this.digest(credentials).equalsIgnoreCase(dbCredentials) : this.digest(credentials).equals(dbCredentials);
                    if (validated) {
                        if (this.debug >= 2) {
                            this.log(sm.getString("jdbcRealm.authenticateSuccess", (Object)username));
                        }
                        break block17;
                    }
                    if (this.debug >= 2) {
                        this.log(sm.getString("jdbcRealm.authenticateFailure", (Object)username));
                    }
                    principal = null;
                    Object var11_10 = null;
                    if (rs == null) break block18;
                    try {
                        rs.close();
                    }
                    catch (SQLException e) {
                        this.log(sm.getString("jdbcRealm.abnormalCloseResultSet"));
                    }
                }
                dbConnection.commit();
                return principal;
            }
            try {
                ArrayList<String> roleList = new ArrayList<String>();
                stmt = this.roles(dbConnection, username);
                rs = stmt.executeQuery();
                while (rs.next()) {
                    String role = rs.getString(1);
                    if (null == role) continue;
                    roleList.add(role.trim());
                }
                rs.close();
                rs = null;
                genericPrincipal = new GenericPrincipal((Realm)this, username, credentials, roleList);
                Object var11_11 = null;
                if (rs == null) break block19;
            }
            catch (Throwable throwable) {
                Object var11_12 = null;
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (SQLException e) {
                        this.log(sm.getString("jdbcRealm.abnormalCloseResultSet"));
                    }
                }
                dbConnection.commit();
                throw throwable;
            }
            try {
                rs.close();
            }
            catch (SQLException e) {
                this.log(sm.getString("jdbcRealm.abnormalCloseResultSet"));
            }
        }
        dbConnection.commit();
        return genericPrincipal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void close(Connection dbConnection) {
        if (dbConnection == null) {
            return;
        }
        try {
            this.preparedCredentials.close();
        }
        catch (Throwable f) {
            // empty catch block
        }
        this.preparedCredentials = null;
        try {
            this.preparedRoles.close();
        }
        catch (Throwable f) {
            // empty catch block
        }
        this.preparedRoles = null;
        try {
            dbConnection.close();
        }
        catch (SQLException e) {
            this.log(sm.getString("jdbcRealm.close"), e);
        }
        finally {
            this.dbConnection = null;
        }
    }

    protected PreparedStatement credentials(Connection dbConnection, String username) throws SQLException {
        if (this.preparedCredentials == null) {
            StringBuffer sb = new StringBuffer("SELECT ");
            sb.append(this.userCredCol);
            sb.append(" FROM ");
            sb.append(this.userTable);
            sb.append(" WHERE ");
            sb.append(this.userNameCol);
            sb.append(" = ?");
            this.preparedCredentials = dbConnection.prepareStatement(sb.toString());
        }
        if (username == null) {
            this.preparedCredentials.setNull(1, 12);
        } else {
            this.preparedCredentials.setString(1, username);
        }
        return this.preparedCredentials;
    }

    protected String getName() {
        return name;
    }

    protected String getPassword(String username) {
        return null;
    }

    protected Principal getPrincipal(String username) {
        return null;
    }

    protected Connection open() throws SQLException {
        if (this.dbConnection != null) {
            return this.dbConnection;
        }
        if (this.driver == null) {
            try {
                Class<?> clazz = Class.forName(this.driverName);
                this.driver = (Driver)clazz.newInstance();
            }
            catch (Throwable e) {
                throw new SQLException(e.getMessage());
            }
        }
        Properties props = new Properties();
        if (this.connectionName != null) {
            props.put("user", this.connectionName);
        }
        if (this.connectionPassword != null) {
            props.put("password", this.connectionPassword);
        }
        this.dbConnection = this.driver.connect(this.connectionURL, props);
        this.dbConnection.setAutoCommit(false);
        return this.dbConnection;
    }

    protected void release(Connection dbConnection) {
    }

    protected PreparedStatement roles(Connection dbConnection, String username) throws SQLException {
        if (this.preparedRoles == null) {
            StringBuffer sb = new StringBuffer("SELECT ");
            sb.append(this.roleNameCol);
            sb.append(" FROM ");
            sb.append(this.userRoleTable);
            sb.append(" WHERE ");
            sb.append(this.userNameCol);
            sb.append(" = ?");
            this.preparedRoles = dbConnection.prepareStatement(sb.toString());
        }
        this.preparedRoles.setString(1, username);
        return this.preparedRoles;
    }

    public void start() throws LifecycleException {
        try {
            this.open();
        }
        catch (SQLException e) {
            this.log(sm.getString("jdbcRealm.open"), e);
        }
        super.start();
    }

    public void stop() throws LifecycleException {
        super.stop();
        this.close(this.dbConnection);
    }
}

