/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.launcher;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.apache.commons.launcher.LaunchCommand;
import org.apache.commons.launcher.LaunchFilter;
import org.apache.commons.launcher.Launcher;
import org.apache.commons.launcher.StreamConnector;
import org.apache.commons.launcher.types.ArgumentSet;
import org.apache.commons.launcher.types.ConditionalArgument;
import org.apache.commons.launcher.types.ConditionalVariable;
import org.apache.commons.launcher.types.JVMArgumentSet;
import org.apache.commons.launcher.types.SysPropertySet;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;

public class LaunchTask
extends Task {
    public static final String ARG_PROP_NAME = "launch.arg.";
    public static final String TASK_NAME = "launch";
    private static ArrayList childProcesses = new ArrayList();
    private boolean appendOutput = false;
    private Process childProc = null;
    private Path classpath = null;
    private boolean debug = false;
    private boolean displayMinimizedWindow = false;
    private boolean disposeMinimizedWindow = true;
    private boolean failOnError = false;
    private LaunchFilter filter = null;
    private String filterClassName = null;
    private Path filterClasspath = null;
    private String mainClassName = null;
    private File minimizedWindowIcon = null;
    private String minimizedWindowTitle = null;
    private File outputFile = null;
    private boolean print = false;
    private boolean redirect = false;
    private boolean requireTools = false;
    private ArgumentSet taskArgumentSet = new ArgumentSet();
    private JVMArgumentSet taskJVMArgumentSet = new JVMArgumentSet();
    private SysPropertySet taskSysPropertySet = new SysPropertySet();
    private boolean useArgs = true;
    private boolean useSystemIn = true;
    private boolean waitForChild = true;
    static /* synthetic */ Class class$org$apache$commons$launcher$ChildMain;

    public static Process[] getChildProcesses() {
        return childProcesses.toArray(new Process[childProcesses.size()]);
    }

    public void addArg(ConditionalArgument arg) {
        this.taskArgumentSet.addArg(arg);
    }

    public void addArgset(ArgumentSet set) {
        this.taskArgumentSet.addArgset(set);
    }

    public void addJvmarg(ConditionalArgument jvmArg) {
        this.taskJVMArgumentSet.addJvmarg(jvmArg);
    }

    public void addJvmargset(JVMArgumentSet set) {
        this.taskJVMArgumentSet.addJvmargset(set);
    }

    public void addSysproperty(ConditionalVariable var) {
        this.taskSysPropertySet.addSysproperty(var);
    }

    public void addSyspropertyset(SysPropertySet set) {
        this.taskSysPropertySet.addSyspropertyset(set);
    }

    public Path createClasspath() {
        if (this.classpath == null) {
            this.classpath = new Path(this.project);
        }
        return this.classpath;
    }

    public Path createFilterclasspath() {
        if (this.filterClasspath == null) {
            this.filterClasspath = new Path(this.project);
        }
        return this.filterClasspath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws BuildException {
        try {
            if (!Launcher.isStarted()) {
                throw new BuildException(Launcher.getLocalizedString("no.run.standalone", ((Object)((Object)this)).getClass().getName()));
            }
            if (Launcher.isStopped()) {
                throw new BuildException();
            }
            if (this.mainClassName == null) {
                throw new BuildException(Launcher.getLocalizedString("classname.null", ((Object)((Object)this)).getClass().getName()));
            }
            ArrayList taskJVMArgs = this.taskJVMArgumentSet.getList();
            ArrayList<String> jvmArgs = new ArrayList<String>(taskJVMArgs.size());
            int i = 0;
            while (i < taskJVMArgs.size()) {
                ConditionalArgument value = (ConditionalArgument)((Object)taskJVMArgs.get(i));
                if (this.testIfCondition(value.getIf()) && this.testUnlessCondition(value.getUnless())) {
                    String[] list = value.getParts();
                    int j = 0;
                    while (j < list.length) {
                        jvmArgs.add(list[j]);
                        ++j;
                    }
                }
                ++i;
            }
            ArrayList taskSysProps = this.taskSysPropertySet.getList();
            HashMap<String, String> sysProps = new HashMap<String, String>(taskSysProps.size());
            int i2 = 0;
            while (i2 < taskSysProps.size()) {
                ConditionalVariable variable = (ConditionalVariable)((Object)taskSysProps.get(i2));
                if (this.testIfCondition(variable.getIf()) && this.testUnlessCondition(variable.getUnless())) {
                    sysProps.put(variable.getKey(), variable.getValue());
                }
                ++i2;
            }
            ArrayList taskArgs = this.taskArgumentSet.getList();
            ArrayList<String> appArgs = new ArrayList<String>(taskArgs.size());
            int i3 = 0;
            while (i3 < taskArgs.size()) {
                ConditionalArgument value = (ConditionalArgument)((Object)taskArgs.get(i3));
                if (this.testIfCondition(value.getIf()) && this.testUnlessCondition(value.getUnless())) {
                    String[] list = value.getParts();
                    int j = 0;
                    while (j < list.length) {
                        appArgs.add(list[j]);
                        ++j;
                    }
                }
                ++i3;
            }
            if (this.useArgs) {
                int currentArg = 0;
                String arg = null;
                while ((arg = this.project.getUserProperty(ARG_PROP_NAME + Integer.toString(currentArg++))) != null) {
                    appArgs.add(arg);
                }
            }
            String filteredClasspath = null;
            if (this.classpath != null) {
                filteredClasspath = this.classpath.toString();
            }
            String filteredMainClassName = this.mainClassName;
            boolean filteredRedirect = this.redirect;
            File filteredOutputFile = this.outputFile;
            boolean filteredAppendOutput = this.appendOutput;
            boolean filteredDebug = this.debug;
            boolean filteredDisplayMinimizedWindow = this.displayMinimizedWindow;
            boolean filteredDisposeMinimizedWindow = this.disposeMinimizedWindow;
            boolean filteredFailOnError = this.failOnError;
            String filteredMinimizedWindowTitle = this.minimizedWindowTitle;
            File filteredMinimizedWindowIcon = this.minimizedWindowIcon;
            boolean filteredPrint = this.print;
            boolean filteredRequireTools = this.requireTools;
            boolean filteredUseSystemIn = this.useSystemIn;
            boolean filteredWaitForChild = this.waitForChild;
            if (this.filterClassName != null && this.filter == null) {
                try {
                    ClassLoader loader = ((Object)((Object)this)).getClass().getClassLoader();
                    if (this.filterClasspath != null) {
                        String[] fileList = this.filterClasspath.list();
                        URL[] urls = new URL[fileList.length];
                        int i4 = 0;
                        while (i4 < fileList.length) {
                            urls[i4] = new File(fileList[i4]).toURL();
                            ++i4;
                        }
                        loader = new URLClassLoader(urls, loader);
                    }
                    Class<?> filterClass = loader.loadClass(this.filterClassName);
                    this.filter = (LaunchFilter)filterClass.newInstance();
                    LaunchCommand command = new LaunchCommand();
                    command.setJvmargs(jvmArgs);
                    command.setSysproperties(sysProps);
                    command.setArgs(appArgs);
                    command.setClasspath(filteredClasspath);
                    command.setClassname(filteredMainClassName);
                    command.setRedirectoutput(filteredRedirect);
                    command.setOutput(filteredOutputFile);
                    command.setAppendoutput(filteredAppendOutput);
                    command.setDebug(filteredDebug);
                    command.setDisplayminimizedwindow(filteredDisplayMinimizedWindow);
                    command.setDisposeminimizedwindow(filteredDisposeMinimizedWindow);
                    command.setFailonerror(filteredFailOnError);
                    command.setMinimizedwindowtitle(filteredMinimizedWindowTitle);
                    command.setMinimizedwindowicon(filteredMinimizedWindowIcon);
                    command.setPrint(filteredPrint);
                    command.setRequiretools(filteredRequireTools);
                    command.setUsesystemin(filteredUseSystemIn);
                    command.setWaitforchild(filteredWaitForChild);
                    this.filter.filter(command);
                    jvmArgs = command.getJvmargs();
                    sysProps = command.getSysproperties();
                    appArgs = command.getArgs();
                    filteredClasspath = command.getClasspath();
                    filteredMainClassName = command.getClassname();
                    filteredRedirect = command.getRedirectoutput();
                    filteredOutputFile = command.getOutput();
                    filteredAppendOutput = command.getAppendoutput();
                    filteredDebug = command.getDebug();
                    filteredDisplayMinimizedWindow = command.getDisplayminimizedwindow();
                    filteredDisposeMinimizedWindow = command.getDisposeminimizedwindow();
                    filteredFailOnError = command.getFailonerror();
                    filteredMinimizedWindowTitle = command.getMinimizedwindowtitle();
                    filteredMinimizedWindowIcon = command.getMinimizedwindowicon();
                    filteredPrint = command.getPrint();
                    filteredRequireTools = command.getRequiretools();
                    filteredUseSystemIn = command.getUsesystemin();
                    filteredWaitForChild = command.getWaitforchild();
                    if (filteredMainClassName == null) {
                        throw new BuildException(Launcher.getLocalizedString("classname.null", ((Object)((Object)this)).getClass().getName()));
                    }
                    if (jvmArgs == null) {
                        jvmArgs = new ArrayList<String>();
                    }
                    if (sysProps == null) {
                        sysProps = new HashMap<String, String>();
                    }
                    if (appArgs == null) {
                        appArgs = new ArrayList<String>();
                    }
                }
                catch (BuildException be) {
                    throw new BuildException(this.filterClassName + " " + Launcher.getLocalizedString("filter.exception", ((Object)((Object)this)).getClass().getName()), (Throwable)be);
                }
                catch (ClassCastException cce) {
                    throw new BuildException(this.filterClassName + " " + Launcher.getLocalizedString("filter.not.filter", ((Object)((Object)this)).getClass().getName()));
                }
                catch (Exception e) {
                    throw new BuildException((Throwable)e);
                }
            }
            if (filteredDebug) {
                filteredWaitForChild = true;
                filteredUseSystemIn = true;
            }
            StringBuffer fullClasspath = new StringBuffer(Launcher.getBootstrapFile().getPath());
            if (filteredRequireTools) {
                fullClasspath.append(File.pathSeparator);
                fullClasspath.append(Launcher.getToolsClasspath());
            }
            if (filteredClasspath != null) {
                fullClasspath.append(File.pathSeparator);
                fullClasspath.append(filteredClasspath);
            }
            sysProps.remove("org.apache.commons.launcher.waitForChild");
            if (filteredWaitForChild) {
                sysProps.put("org.apache.commons.launcher.waitForChild", "");
            }
            sysProps.remove("org.apache.commons.launcher.displayMinimizedWindow");
            sysProps.remove("org.apache.commons.launcher.minimizedWindowTitle");
            sysProps.remove("org.apache.commons.launcher.minimizedWindowIcon");
            sysProps.remove("org.apache.commons.launcher.disposeMinimizedWindow");
            if (!filteredWaitForChild && filteredDisplayMinimizedWindow) {
                sysProps.put("org.apache.commons.launcher.displayMinimizedWindow", "");
                if (filteredMinimizedWindowTitle != null) {
                    sysProps.put("org.apache.commons.launcher.minimizedWindowTitle", filteredMinimizedWindowTitle);
                } else {
                    sysProps.put("org.apache.commons.launcher.minimizedWindowTitle", this.getOwningTarget().getName());
                }
                if (filteredMinimizedWindowIcon != null) {
                    sysProps.put("org.apache.commons.launcher.minimizedWindowIcon", filteredMinimizedWindowIcon.getCanonicalPath());
                }
                if (filteredDisposeMinimizedWindow) {
                    sysProps.put("org.apache.commons.launcher.disposeMinimizedWindow", "");
                }
            }
            sysProps.remove("org.apache.commons.launcher.outputFile");
            if (!filteredWaitForChild && filteredRedirect) {
                if (filteredOutputFile != null) {
                    String outputFilePath = filteredOutputFile.getCanonicalPath();
                    try {
                        filteredOutputFile.createNewFile();
                    }
                    catch (IOException ioe) {
                        throw new BuildException(outputFilePath + " " + Launcher.getLocalizedString("output.file.not.creatable", ((Object)((Object)this)).getClass().getName()));
                    }
                    if (!filteredOutputFile.canWrite()) {
                        throw new BuildException(outputFilePath + " " + Launcher.getLocalizedString("output.file.not.writable", ((Object)((Object)this)).getClass().getName()));
                    }
                    sysProps.put("org.apache.commons.launcher.outputFile", outputFilePath);
                    if (filteredAppendOutput) {
                        sysProps.put("org.apache.commons.launcher.appendOutput", "");
                    }
                    Launcher.getLog().println(Launcher.getLocalizedString("redirect.notice", ((Object)((Object)this)).getClass().getName()) + " " + outputFilePath);
                } else {
                    throw new BuildException(Launcher.getLocalizedString("output.file.null", ((Object)((Object)this)).getClass().getName()));
                }
            }
            File heartbeatFile = null;
            FileOutputStream heartbeatOutputStream = null;
            if (filteredWaitForChild) {
                File tmpDir = null;
                String tmpDirName = (String)sysProps.get("java.io.tmpdir");
                if (tmpDirName != null) {
                    tmpDir = new File(tmpDirName);
                }
                heartbeatFile = File.createTempFile("org.apache.commons.launcher.heartbeatFile.", "", tmpDir);
                heartbeatOutputStream = new FileOutputStream(heartbeatFile);
                sysProps.put("org.apache.commons.launcher.heartbeatFile", heartbeatFile.getCanonicalPath());
            }
            String[] cmd = new String[5 + jvmArgs.size() + sysProps.size() + appArgs.size()];
            int nextCmdArg = 0;
            cmd[nextCmdArg++] = filteredDebug ? Launcher.getJDBCommand() : Launcher.getJavaCommand();
            int i5 = 0;
            while (i5 < jvmArgs.size()) {
                cmd[nextCmdArg++] = (String)jvmArgs.get(i5);
                ++i5;
            }
            Iterator sysPropsKeys = sysProps.keySet().iterator();
            while (sysPropsKeys.hasNext()) {
                String key = (String)sysPropsKeys.next();
                if (key == null) continue;
                String value = (String)sysProps.get(key);
                if (value == null) {
                    value = "";
                }
                cmd[nextCmdArg++] = "-D" + key + "=" + value;
            }
            cmd[nextCmdArg++] = "-classpath";
            cmd[nextCmdArg++] = fullClasspath.toString();
            int mainClassArg = nextCmdArg;
            cmd[nextCmdArg++] = (class$org$apache$commons$launcher$ChildMain == null ? (class$org$apache$commons$launcher$ChildMain = LaunchTask.class$("org.apache.commons.launcher.ChildMain")) : class$org$apache$commons$launcher$ChildMain).getName();
            cmd[nextCmdArg++] = filteredMainClassName;
            int i6 = 0;
            while (i6 < appArgs.size()) {
                cmd[nextCmdArg++] = (String)appArgs.get(i6);
                ++i6;
            }
            if (filteredPrint) {
                String osname = System.getProperty("os.name").toLowerCase();
                StringBuffer buf = new StringBuffer(cmd.length * 100);
                String quote = null;
                String replaceQuote = null;
                if (osname.indexOf("windows") >= 0) {
                    quote = "\"";
                    replaceQuote = quote + quote + quote;
                } else {
                    quote = "'";
                    replaceQuote = quote + "\\" + quote + quote;
                }
                int i7 = 0;
                while (i7 < cmd.length) {
                    if (i7 != mainClassArg) {
                        if (i7 > 0) {
                            buf.append(" ");
                        }
                        buf.append(quote);
                        StringTokenizer tokenizer = new StringTokenizer(cmd[i7], quote, true);
                        while (tokenizer.hasMoreTokens()) {
                            String token = tokenizer.nextToken();
                            if (quote.equals(token)) {
                                buf.append(replaceQuote);
                                continue;
                            }
                            buf.append(token);
                        }
                        buf.append(quote);
                    }
                    ++i7;
                }
                System.err.println(Launcher.getLocalizedString("executing.child.command", ((Object)((Object)this)).getClass().getName()) + ":");
                System.err.println(buf.toString());
            }
            if (Launcher.isStopped()) {
                throw new BuildException();
            }
            Process proc = null;
            ArrayList arrayList = childProcesses;
            synchronized (arrayList) {
                proc = Runtime.getRuntime().exec(cmd);
                if (filteredWaitForChild) {
                    this.childProc = proc;
                    childProcesses.add(proc);
                }
            }
            if (filteredWaitForChild) {
                StreamConnector stdout = new StreamConnector(proc.getInputStream(), System.out);
                StreamConnector stderr = new StreamConnector(proc.getErrorStream(), System.err);
                stdout.start();
                stderr.start();
                if (filteredUseSystemIn) {
                    StreamConnector stdin = new StreamConnector(System.in, proc.getOutputStream());
                    stdin.start();
                }
                proc.waitFor();
                stdout.join();
                stderr.join();
                if (heartbeatOutputStream != null) {
                    heartbeatOutputStream.close();
                }
                if (heartbeatFile != null) {
                    heartbeatFile.delete();
                }
                int exitValue = proc.exitValue();
                if (filteredFailOnError && exitValue != 0) {
                    throw new BuildException(Launcher.getLocalizedString("child.failed", ((Object)((Object)this)).getClass().getName()) + " " + exitValue);
                }
            }
            if (Launcher.isStopped()) {
                throw new BuildException();
            }
        }
        catch (BuildException be) {
            throw be;
        }
        catch (Exception e) {
            if (Launcher.isStopped()) {
                throw new BuildException(Launcher.getLocalizedString("launch.task.stopped", ((Object)((Object)this)).getClass().getName()));
            }
            throw new BuildException((Throwable)e);
        }
    }

    public void setUseargs(boolean useArgs) {
        this.useArgs = useArgs;
    }

    public void setUsesystemin(boolean useSystemIn) {
        this.useSystemIn = useSystemIn;
    }

    public void setWaitforchild(boolean waitForChild) {
        this.waitForChild = waitForChild;
    }

    public void setClassname(String mainClassName) {
        this.mainClassName = mainClassName;
    }

    public void setClasspath(Path classpath) {
        this.createClasspath().append(classpath);
    }

    public void setClasspathref(Reference ref) {
        this.createClasspath().setRefid(ref);
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public void setDisplayminimizedwindow(boolean displayMinimizedWindow) {
        this.displayMinimizedWindow = displayMinimizedWindow;
    }

    public void setDisposeminimizedwindow(boolean disposeMinimizedWindow) {
        this.disposeMinimizedWindow = this.displayMinimizedWindow;
    }

    public void setFailonerror(boolean failOnError) {
        this.failOnError = failOnError;
    }

    public void setFilterclassname(String filterClassName) {
        this.filterClassName = filterClassName;
    }

    public void setFilterclasspath(Path filterClasspath) {
        this.createFilterclasspath().append(filterClasspath);
    }

    public void setMinimizedwindowtitle(String minimizedWindowTitle) {
        this.minimizedWindowTitle = minimizedWindowTitle;
    }

    public void setMinimizedwindowicon(File minimizedWindowIcon) {
        this.minimizedWindowIcon = minimizedWindowIcon;
    }

    public void setOutput(File outputFile) {
        this.outputFile = outputFile;
    }

    public void setPrint(boolean print) {
        this.print = print;
    }

    public void setAppendoutput(boolean appendOutput) {
        this.appendOutput = appendOutput;
    }

    public void setRedirectoutput(boolean redirect) {
        this.redirect = redirect;
    }

    public void setRequiretools(boolean requireTools) {
        this.requireTools = requireTools;
    }

    private boolean testIfCondition(String ifCondition) {
        if (ifCondition == null || "".equals(ifCondition)) {
            return true;
        }
        return this.project.getProperty(ifCondition) != null;
    }

    private boolean testUnlessCondition(String unlessCondition) {
        if (unlessCondition == null || "".equals(unlessCondition)) {
            return true;
        }
        return this.project.getProperty(unlessCondition) == null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

