/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.authDev;

import com.novell.emframe.authDev.AuthRoleList;
import com.novell.emframe.authDev.ConnectionProfile;
import com.novell.emframe.authDev.MCredentials;
import com.novell.emframe.dev.D;
import com.novell.emframe.dev.MContext;
import com.novell.emframe.dev.MUtils;
import com.novell.emframe.dev.authenticator.AuthContext;
import com.novell.emframe.dev.authenticator.AuthNotAuthenticatedException;
import com.novell.emframe.dev.authenticator.iMgrAuthenticator;
import com.novell.emframe.dev.eMFrameUtils;
import com.novell.emframe.fw.FwAttr;
import com.novell.emframe.fw.FwTaskContext;
import com.novell.emframe.fw.FwUtils;
import com.novell.emframe.fw.Registry;
import com.novell.emframe.fw.authenticator.FwAuthUtils;
import com.novell.emframe.fw.util.infos.RoleInfo;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;

public abstract class iMgrAuthenticatorImpl
implements iMgrAuthenticator {
    public static final String INVALIDATE_CACHE_CALLED_BY_FRAMEWORK = "InvalidateCacheCalledByFramework";
    public static final String IMGR_AUTH_KEYROOT = "Auth.";
    public static final String IMGR_AUTH_HASHMAP = "AuthMap";
    private AuthRoleList roles = new AuthRoleList();

    public abstract void init(AuthContext var1);

    public abstract boolean isAuthenticated(HttpServletRequest var1);

    public boolean handleLogin(HttpServletRequest req, HttpServletResponse resp) {
        this.login(req);
        if (this.shouldShowUI(req)) {
            this.showUI(req, resp);
            return false;
        }
        return this.isAuthenticated(req);
    }

    protected abstract void login(HttpServletRequest var1);

    protected final void setUIPage(String sUIPage, HttpServletRequest req) {
        FwAttr.setFwRequestAttribute("AuthUIPage", sUIPage, req);
    }

    protected boolean shouldShowUI(HttpServletRequest req) {
        if (!this.isAuthenticated(req)) {
            if (FwAuthUtils.getUIPage(req) == null || FwAuthUtils.getUIPage(req).equals("")) {
                this.setUIPage(FwAuthUtils.getUIPageFromAuthDoc(this.getAuthContext().getName()), req);
            }
            return true;
        }
        return false;
    }

    protected void showUI(HttpServletRequest req, HttpServletResponse resp) {
        FwUtils.dispatchJsp(FwAuthUtils.getUIPage(req), req, resp);
    }

    public abstract void setAttribute(Object var1, Object var2);

    public abstract Object getAttribute(Object var1);

    public abstract void removeAttribute(Object var1);

    public abstract AuthContext getAuthContext();

    public abstract void logout();

    public abstract void destroy();

    public Map getRunnablesDocs(HttpSession session) {
        return Collections.EMPTY_MAP;
    }

    public Map getUpdatedRoles(MContext context) {
        this.updateRoles(context);
        return this.roles.getRolesById();
    }

    protected void updateRoles(MContext context) {
    }

    public void addRole(Document roleDoc, Map taskDocsById, MContext context) {
        RoleInfo roleInfo = new RoleInfo(roleDoc, context);
        roleInfo.setTasks(taskDocsById, context);
        this.roles.add(roleInfo);
    }

    protected void clearRoles(MContext context) {
        this.roles.clear(context);
    }

    protected Document parsexmlfile(File file) throws JDOMException, IOException {
        Document doc = null;
        doc = Registry.parseXMLFile(file);
        return doc;
    }

    public abstract String getConfigScope(MContext var1);

    public abstract boolean isPluginAvailable(MContext var1, Document var2);

    public void invalidateRolesAndTasks(FwTaskContext context) {
        D.assrt(FwAttr.getFwAuthAttribute(INVALIDATE_CACHE_CALLED_BY_FRAMEWORK, this) != null, "Authenticator: " + this.getAuthContext().getName() + " method invalidateRolesAndTasks should not be called directly. Use FwAuthUtils.invalidateRolesAndTasks().");
        this.invalidateCachedRolesAndTasks(context);
    }

    protected void invalidateCachedRolesAndTasks(MContext context) {
        D.assrt(FwAttr.getFwAuthAttribute(INVALIDATE_CACHE_CALLED_BY_FRAMEWORK, this) != null, "Authenticator:" + this.getAuthContext().getName() + "method invalidateCachedRolesAndTasks should not be called directly.");
        FwAttr.removeFwAuthAttribute(INVALIDATE_CACHE_CALLED_BY_FRAMEWORK, this);
    }

    public abstract ConnectionProfile getConnectionProfile(HttpServletRequest var1);

    public abstract MCredentials getCredentials(HttpServletRequest var1) throws AuthNotAuthenticatedException;

    public String getDisplayName(Element root, String tagName, HttpServletRequest req) {
        String resBundle = root.getChildTextTrim("resource-properties-file");
        String displayNameKey = root.getChildTextTrim(tagName);
        String s = null;
        if (resBundle != null && displayNameKey != null) {
            s = MUtils.getLocalizedString(resBundle, displayNameKey, "fw.NotFound", FwUtils.getMContext(req));
        }
        if (s == null || "fw.NotFound".equals(s)) {
            Properties params = eMFrameUtils.getUrlParams(root.getDocument());
            String defaultDisplayName = params.getProperty("defaultDisplayName");
            if ((defaultDisplayName == null || defaultDisplayName.length() == 0) && (defaultDisplayName = root.getChildTextTrim("id")) != null) {
                defaultDisplayName = defaultDisplayName.substring(defaultDisplayName.lastIndexOf(".") + 1, defaultDisplayName.length());
                defaultDisplayName = defaultDisplayName.replace('_', ' ');
                defaultDisplayName = eMFrameUtils.replaceWith(defaultDisplayName, "\\.", ".");
            }
            s = defaultDisplayName;
        }
        if (s == null) {
            s = "";
        }
        return s;
    }
}

