/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.dev;

import com.novell.admin.common.exceptions.SPIException;
import com.novell.admin.ns.ClassDefinition;
import com.novell.admin.ns.MOOManager;
import com.novell.admin.ns.NSObject;
import com.novell.admin.ns.NamespaceException;
import com.novell.admin.ns.ObjectAttribute;
import com.novell.admin.ns.ObjectOperation;
import com.novell.admin.ns.Value;
import com.novell.admin.ns.ldap.LDAPNSObject;
import com.novell.admin.ns.nds.NDSNamespace;
import com.novell.application.console.snapin.ObjectEntry;
import com.novell.emframe.dev.BookException;
import com.novell.emframe.dev.D;
import com.novell.emframe.dev.DirPropertyBookPage;
import com.novell.emframe.dev.DirUtils;
import com.novell.emframe.dev.MContext;
import com.novell.emframe.dev.PluginException;
import com.novell.emframe.dev.PropertyBook;
import com.novell.emframe.dev.PropertyBookPage;
import com.novell.emframe.dev.RuntimePlugin;
import com.novell.emframe.dev.TargetObjects;
import com.novell.emframe.dev.TaskContext;
import com.novell.emframe.dev.eDirAccessServiceException;
import com.novell.emframe.dev.eMFrameUtils;
import com.novell.emframe.fw.FwUtils;
import com.novell.emframe.fw.PageComparator;
import com.novell.emframe.fw.Target;
import com.novell.emframe.fw.TargetCollection;
import com.novell.webaccess.common.I18NServletRequest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import org.jdom.Document;
import org.jdom.Element;

public class DirPropertyBook
extends PropertyBook {
    private static final long serialVersionUID = 1L;
    private static final String OBJECT_TYPE_DISPLAYKEY_KEY = "Book.objectTypeDisplayNameKey";
    private static final String FRIENDLY_TARGETS_KEY = "Book.Target.displayName";
    private static final String TARGET_TYPE_KEY = "Book.Target.type";
    private static final String TARGET_ICON_KEY = "Book.Target.icon";
    private static final String TARGET_KEY = "eDir$target";
    protected static final String TEMPLATE_SEARCH = "dev.TC";
    protected TargetCollection m_targets = null;
    protected String m_targetType = null;
    protected Vector m_validTargetTypes = null;
    protected String m_validObjectTypeDisplayName = null;
    protected boolean m_mooEnabled = false;
    protected String m_eDirTarget = null;
    protected boolean m_useShortName = false;
    protected boolean m_modifyGroupMembers = false;
    protected boolean m_overrideDisplay = false;
    protected String m_overrideDisplayName = null;

    protected Vector getValidTargetTypes() {
        return this.m_validTargetTypes;
    }

    /*
     * Unable to fully structure code
     */
    protected void instantiatePages() throws BookException {
        objectTypes = null;
        if (this.isMoo()) {
            try {
                superTypes = this.m_context.getDirUtils().getSuperClasses(this.m_targetType);
                objectTypes = new ArrayList<String>();
                objectTypes.add(this.m_targetType);
                if (superTypes == null) ** GOTO lbl18
                for (i = 0; i < superTypes.length; ++i) {
                    objectTypes.add(superTypes[i]);
                }
            }
            catch (Exception e) {
                D.log(e);
                throw new BookException(e);
            }
        } else {
            objectTypes = FwUtils.getAllClassesInOrder(this.getNSObject());
        }
lbl18:
        // 3 sources

        allPages = new ArrayList<Document>();
        for (i = 0; i < this.m_pageDocs.length; ++i) {
            allPages.add(this.m_pageDocs[i]);
        }
        pageCompare = new PageComparator();
        objectTypeIter = objectTypes.iterator();
        while (objectTypeIter.hasNext()) {
            strType = (String)objectTypeIter.next();
            pagesFromType = new ArrayList<Document>();
            pagesIter = allPages.iterator();
            block5: while (pagesIter.hasNext()) {
                doc = (Document)pagesIter.next();
                list = doc.getRootElement().getChildren("object-type-name");
                if (list != null && list.size() > 0) {
                    iterator = list.listIterator();
                    block6: while (iterator.hasNext()) {
                        strPageType = ((Element)iterator.next()).getTextTrim();
                        if (strType.equalsIgnoreCase(strPageType)) {
                            pagesFromType.add(doc);
                            pagesIter.remove();
                            continue block5;
                        }
                        if (!strPageType.equalsIgnoreCase("[containers]") || (cTypes = this.m_context.getDirUtils().getSelectableContainerTypes()) == null) continue;
                        for (i = 0; i < cTypes.length; ++i) {
                            if (!strType.equalsIgnoreCase(cTypes[i])) continue;
                            pagesFromType.add(doc);
                            pagesIter.remove();
                            continue block6;
                        }
                    }
                    continue;
                }
                D.log("PropertyBook: Missing object-type-name, so ignoring page: " + eMFrameUtils.getDisplayName(doc, (MContext)this.m_context));
            }
            Collections.sort(pagesFromType, pageCompare);
            for (pageIndex = 0; pageIndex < pagesFromType.size(); ++pageIndex) {
                p = this.getInstance((Document)pagesFromType.get(pageIndex));
                if (p == null) continue;
                this.addPage(p);
            }
        }
        this.verifyPagesExist();
    }

    protected final void verifyPagesExist() throws BookException {
        if (this.m_pages == null || this.m_pages.size() == 0) {
            String strBody = null;
            if (this.isMoo()) {
                strBody = eMFrameUtils.getLocalizedString("FwResources", "Book.NoPagesMessage", this.m_context);
            } else {
                String objectType = this.getNSObject().getObjectEntry().getTypeName();
                String pattern = eMFrameUtils.getLocalizedString("FwResources", "DirBook.NoPagesMessage", this.m_context);
                strBody = eMFrameUtils.formatMessage(pattern, new String[]{objectType});
            }
            String title = eMFrameUtils.getLocalizedString("FwResources", "Book.NoPagesTitle", this.m_context);
            throw new BookException(title, strBody);
        }
    }

    public final void init(TaskContext context, Document doc) {
        String shortName;
        String modifyGroupMembers;
        Element root = doc.getRootElement();
        Object[] validTargetTypes = root.getChildren("object-type-name").toArray();
        if (validTargetTypes != null) {
            this.m_validTargetTypes = new Vector();
            for (int index = 0; index < validTargetTypes.length; ++index) {
                String objectTypeName = ((Element)validTargetTypes[index]).getTextTrim();
                if (this.m_validTargetTypes.contains(objectTypeName)) continue;
                this.m_validTargetTypes.addElement(objectTypeName);
            }
        }
        Properties params = eMFrameUtils.getUrlParams(doc);
        String strKey = params.getProperty(OBJECT_TYPE_DISPLAYKEY_KEY);
        String resBundle = root.getChildTextTrim("resource-properties-file");
        this.m_validObjectTypeDisplayName = eMFrameUtils.getLocalizedString(resBundle, strKey, context);
        String mooEnabled = params.getProperty("mooEnabled");
        if (mooEnabled != null && mooEnabled.equalsIgnoreCase("true")) {
            this.m_mooEnabled = true;
        }
        if ((modifyGroupMembers = params.getProperty("ModifyGroupMembers")) != null && modifyGroupMembers.equalsIgnoreCase("true")) {
            this.m_modifyGroupMembers = true;
        }
        if ((shortName = params.getProperty("useShortName")) != null && shortName.equals("true")) {
            this.m_useShortName = true;
        }
        super.init(context, doc);
    }

    public final MOOManager getMooManager() {
        D.assrt(this.m_targets != null && this.m_targets.getTarget("target").isMOO(), "DONT call getMooManager when in single object mode.  Call getNSObject.");
        return (MOOManager)this.m_targets.getTarget("target").getObject();
    }

    public final NSObject getNSObject() {
        D.assrt(this.m_targets != null && !this.m_targets.getTarget("target").isMOO(), "DONT call getNSObject when in Moo mode.  Call getMooManager.");
        return (NSObject)this.m_targets.getTarget("target").getObject();
    }

    public final NSObject getPrimaryTarget() {
        return this.getNSObject();
    }

    public final TargetCollection getEdasTargetCollection() {
        return this.m_targets;
    }

    public final boolean isMoo() {
        return this.m_targets.getTarget("target").isMOO();
    }

    protected final void updateMooProgressDialog() throws BookException {
        this.m_targets.outputProgressInformation(this.m_context);
        this.setMerge("dev.Exchanger");
    }

    protected final void abortMooUpdate() throws BookException {
        try {
            this.m_targets.abortUpdate(this.m_context);
        }
        catch (Exception e) {
            throw new BookException(e);
        }
        String header = eMFrameUtils.getLocalizedString("FwResources", "Book.StopSuccessful", this.m_context);
        String body = eMFrameUtils.getLocalizedString("FwResources", "Book.StopInfo", this.m_context);
        eMFrameUtils.setMessage("success", header, body, this.m_context);
        this.setMerge("dev.GenConf");
    }

    protected final void refresh() throws BookException {
        HttpServletRequest req = this.m_context.getRequest();
        Enumeration myenum = req.getParameterNames();
        while (myenum.hasMoreElements()) {
            String key = (String)myenum.nextElement();
            if (!key.startsWith("eDir$")) continue;
            req.setAttribute(key, (Object)"");
        }
        try {
            this.m_targets.clearMOOTargets(this.m_context);
        }
        catch (Exception e) {
            throw new BookException(e);
        }
    }

    protected final boolean readData() throws BookException {
        String strTargets;
        block16: {
            strTargets = this.m_req.getParameter(TARGET_KEY);
            if (strTargets == null) {
                strTargets = this.m_req.getParameter("targetNames");
            }
            if (strTargets == null) {
                return false;
            }
            if (this.m_modifyGroupMembers) {
                ObjectEntry treeOE = (ObjectEntry)this.m_context.getAuthenticationBroker().getAPIObject("NDSNamespace");
                NDSNamespace ns = (NDSNamespace)treeOE.getNamespace();
                ObjectAttribute attrib = null;
                try {
                    String[] targets = eMFrameUtils.unpack(strTargets, this.m_context);
                    ObjectEntry oe = ns.getObjectEntry(targets[0]);
                    attrib = ns.getAttribute(oe, "Member");
                }
                catch (SPIException e) {
                    D.log(e);
                    eMFrameUtils.setErrorMessage(e, this.m_context);
                    this.m_targets = null;
                    return false;
                }
                ArrayList<String> list = new ArrayList<String>();
                if (attrib != null) {
                    Enumeration myenum = attrib.getValueComponents();
                    while (myenum.hasMoreElements()) {
                        Value value = (Value)myenum.nextElement();
                        list.add(value.toString());
                    }
                }
                if (list.size() == 0) {
                    FwUtils.setLocalizedMessage("error", "FwResources", "Book.NoObjectsFound", "Book.GroupNoMembers", this.m_context);
                    this.m_targets = null;
                    return false;
                }
                String[] array = list.toArray(new String[list.size()]);
                strTargets = eMFrameUtils.pack(array, this.m_context);
            }
            try {
                String types = this.toCommanDelimitedSafenames(this.getValidTargetTypes(), this.m_context);
                ((I18NServletRequest)this.m_req).setParameter("eDirSearch", types);
                this.m_targets = new TargetCollection();
                if (this.m_modifyGroupMembers) {
                    this.m_targets.addTargetDefinition("target", strTargets, "*", this.m_delayedAttributes, this.m_context);
                } else {
                    this.m_targets.addTargetDefinition("target", strTargets, this.m_delayedAttributes, this.m_context);
                }
                if (this.m_targets.getTarget("target").isMOO()) {
                    this.m_targetType = this.m_req.getParameter("targetType");
                    TargetObjects targetObjects = this.m_targets.getTarget("target").getTargetObjects();
                    if (targetObjects.isQuery()) break block16;
                    try {
                        String[] commonTypes = targetObjects.getCommonObjectClasses(this.m_context);
                        if (commonTypes == null || commonTypes.length == 0) {
                            commonTypes = new String[]{"Top"};
                        }
                        this.m_targetType = commonTypes[0];
                        break block16;
                    }
                    catch (Exception e) {
                        D.log(e);
                        throw new BookException(e);
                    }
                }
                NSObject nsobj = (NSObject)this.m_targets.getTarget("target").getObject();
                this.m_targetType = nsobj.getObjectEntry().getTypeName();
            }
            catch (PluginException e) {
                D.log(e);
                eMFrameUtils.setErrorMessage(e, this.m_context);
                this.m_targets = null;
                return false;
            }
        }
        this.m_eDirTarget = strTargets;
        this.m_pages.clear();
        return true;
    }

    protected final void writeData() throws BookException {
        try {
            this.m_targets.update(this.m_context);
        }
        catch (eDirAccessServiceException e) {
            throw new BookException(e);
        }
    }

    protected void canCommit() throws PluginException {
        if (this.isMoo()) {
            MOOManager mooManager = this.getMooManager();
            boolean empty = true;
            ObjectOperation[] allObjectOperations = mooManager.getAllObjectOperations();
            if (allObjectOperations != null || allObjectOperations.length > 0) {
                for (int i = 0; i < allObjectOperations.length; ++i) {
                    if (allObjectOperations[i].getMode() == 5) continue;
                    empty = false;
                    break;
                }
            }
            if (empty) {
                String title = eMFrameUtils.getLocalizedString("FwResources", "PropertyBook.noChanges", this.m_context);
                String body = eMFrameUtils.getLocalizedString("FwResources", "PropertyBook.noChangesDetails", this.m_context);
                this.m_context.getRequest().setAttribute("GeneralMsg.Url", (Object)"Javascript:window.close();");
                throw new PluginException(title, body);
            }
        }
    }

    protected final boolean shouldThreadUpdate() {
        return this.m_targets.getTarget("target").isMOO();
    }

    protected final void doSearch() {
        this.m_req.setAttribute("TC.multipleObjectEnabled", (Object)("" + this.m_mooEnabled));
        this.m_req.setAttribute("TC.advancedSelectionEnabled", (Object)("" + this.m_mooEnabled));
        this.m_req.setAttribute("TC.showObjectTypeSelectionInMultiSelect", (Object)"false");
        this.m_req.setAttribute("TC.showObjectTypeSelectionInAdvancedSelect", (Object)"true");
        this.m_req.setAttribute("Task.nextState", (Object)"selectTarget");
        if (this.m_validObjectTypeDisplayName != null && this.m_validObjectTypeDisplayName.length() > 0) {
            this.m_req.setAttribute("TC.prompt", (Object)this.m_validObjectTypeDisplayName);
        }
        Vector targetTypes = this.getValidTargetTypes();
        String[] targetsTypesArray = targetTypes.toArray(new String[targetTypes.size()]);
        eMFrameUtils.setupTargetChooser(targetsTypesArray, this.m_context);
        this.setMerge(TEMPLATE_SEARCH);
    }

    protected final void outputMisc() throws BookException {
        super.outputMisc();
        if (this.m_targets != null) {
            Target primaryTarget = this.m_targets.getTarget("target");
            this.m_req.setAttribute(TARGET_KEY, (Object)this.m_eDirTarget);
            if (primaryTarget.isMOO()) {
                int primaryTargetGroupSize = primaryTarget.getCount();
                Object[] params = new String[]{"" + primaryTargetGroupSize};
                String pattern = eMFrameUtils.getLocalizedString("DevResources", "General.nObjects", this.m_context);
                String targetDisplayName = eMFrameUtils.formatMessage(pattern, params);
                this.m_req.setAttribute(TARGET_TYPE_KEY, (Object)this.m_targetType);
                this.m_req.setAttribute("Book.Target.Type.displayName", (Object)this.m_context.getDirUtils().getObjectTypeDisplayName(this.m_targetType, this.m_context));
                this.m_req.setAttribute(TARGET_ICON_KEY, (Object)this.m_context.getDirUtils().getObjectTypeImageName(this.m_targetType));
                if (!this.m_overrideDisplay) {
                    this.m_req.setAttribute(FRIENDLY_TARGETS_KEY, (Object)targetDisplayName);
                } else {
                    this.m_req.setAttribute(FRIENDLY_TARGETS_KEY, (Object)this.m_overrideDisplayName);
                }
                this.m_req.setAttribute("Task.moo", (Object)"true");
                this.m_req.setAttribute("taskIsMoo", (Object)"true");
                String warning = primaryTarget.getCountReliablityMessage();
                if (warning != null) {
                    this.m_req.setAttribute("Book.countWarning", (Object)warning);
                    int reliablity = primaryTarget.getCountReliablity();
                    if (reliablity == 3 || reliablity == 4) {
                        this.m_req.setAttribute("Book.countWarnOnOpen", (Object)"true");
                    }
                }
                try {
                    String[] parentObjectTypes = this.m_context.getDirUtils().getSuperClasses(this.m_targetType);
                    this.m_req.setAttribute("parentObjectTypes", (Object)eMFrameUtils.pack(parentObjectTypes, this.m_context));
                }
                catch (NamespaceException e) {
                    D.log(e.getMessage());
                }
            } else {
                ObjectEntry oe = this.getNSObject().getObjectEntry();
                ObjectEntry oeTree = oe.getRoot();
                String objectName = null;
                objectName = this.m_useShortName ? oe.getName() : DirUtils.removeTreeFromFullName(oeTree, oe.getFullName());
                this.m_req.setAttribute("Task.moo", (Object)"false");
                this.m_req.setAttribute("taskIsMoo", (Object)"false");
                if (!this.m_overrideDisplay) {
                    this.m_req.setAttribute(FRIENDLY_TARGETS_KEY, (Object)objectName);
                } else {
                    this.m_req.setAttribute(FRIENDLY_TARGETS_KEY, (Object)this.m_overrideDisplayName);
                }
                this.m_req.setAttribute(TARGET_TYPE_KEY, (Object)this.m_targetType);
                this.m_req.setAttribute("Book.Target.Type.displayName", (Object)this.m_context.getDirUtils().getObjectTypeDisplayName(this.m_targetType, this.m_context));
                this.m_req.setAttribute(TARGET_ICON_KEY, (Object)this.m_context.getDirUtils().getObjectTypeImageName(this.m_targetType));
                try {
                    String[] parentObjectTypes = this.m_context.getDirUtils().getSuperClasses(this.m_targetType);
                    this.m_req.setAttribute("parentObjectTypes", (Object)eMFrameUtils.pack(parentObjectTypes, this.m_context));
                }
                catch (NamespaceException e) {
                    D.log(e.getMessage());
                }
            }
            this.checkForDSFWUser(this.m_targets);
        }
    }

    public void checkForDSFWUser(TargetCollection m_targets) {
        try {
            Target primaryTarget = m_targets.getTarget("target");
            ObjectEntry treeOE = (ObjectEntry)this.m_context.getAuthenticationBroker().getAPIObject("NDSNamespace");
            NDSNamespace ns = (NDSNamespace)treeOE.getNamespace();
            String dsfwUserIdentity = this.m_req.getParameter("dsfwIdentification");
            ObjectAttribute attrib = null;
            if (!primaryTarget.isMOO()) {
                ObjectEntry oe = primaryTarget.getOE();
                attrib = ns.getAttribute(oe, "sAMAccountName");
                if (attrib != null) {
                    dsfwUserIdentity = "true";
                    this.m_req.setAttribute("dsfwIdentification", (Object)dsfwUserIdentity);
                } else {
                    dsfwUserIdentity = "false";
                    this.m_req.setAttribute("dsfwIdentification", (Object)dsfwUserIdentity);
                }
            }
        }
        catch (SPIException e) {
            D.log(e);
        }
    }

    public void overrideDisplayName(String displayName) {
        this.m_overrideDisplay = true;
        this.m_overrideDisplayName = displayName;
    }

    protected final void addPage(PropertyBookPage page) {
        if (page instanceof DirPropertyBookPage) {
            DirPropertyBookPage dirPage = (DirPropertyBookPage)page;
            dirPage.m_propertyBook = this;
            if (this.isMoo()) {
                if (!dirPage.doesSupportMoo()) {
                    D.log("Skipping page because it doesn't support MOO: " + dirPage.getId());
                    return;
                }
                dirPage.m_nsobj = null;
                dirPage.m_mooManager = this.getMooManager();
                dirPage.m_propertyBook = this;
                if (page instanceof RuntimePlugin) {
                    D.log("Book: runtime plugins don't apply to moo! " + page.toString());
                    return;
                }
            } else {
                RuntimePlugin rt;
                dirPage.m_nsobj = this.getNSObject();
                dirPage.m_mooManager = null;
                dirPage.m_propertyBook = this;
                if (page instanceof RuntimePlugin && !(rt = (RuntimePlugin)((Object)page)).shouldShow(this.getNSObject(), this.m_context)) {
                    return;
                }
            }
            super.addPage(page);
        }
    }

    private String toCommanDelimitedSafenames(Collection c, TaskContext context) {
        Iterator iter = c.iterator();
        DirUtils dirUtils = context.getDirUtils();
        StringBuffer sb = new StringBuffer();
        while (iter.hasNext()) {
            String type = (String)iter.next();
            if (type.equals("*")) {
                sb.append(type);
            } else if (type.equals("[containers]")) {
                sb.append(type);
            } else {
                sb.append(dirUtils.getSafeName(type));
            }
            if (!iter.hasNext()) continue;
            sb.append(",");
        }
        return sb.toString();
    }

    public boolean isAttributeSupported(String attributeName) throws BookException {
        ClassDefinition[] cd;
        if (this.m_targets.getTarget("target").isMOO()) {
            MOOManager mooMgr = this.getMooManager();
            ObjectEntry oe = mooMgr.getObjectEntryEnumeration().next();
            LDAPNSObject nsObj = new LDAPNSObject(oe, null, 0L);
            cd = nsObj.getClassDefinitions();
        } else {
            cd = this.getNSObject().getClassDefinitions();
        }
        try {
            for (int i = 0; i < cd.length; ++i) {
                if (!cd[i].isClassUsingAttribute(attributeName)) continue;
                return true;
            }
        }
        catch (Exception e) {
            throw new BookException(e);
        }
        return false;
    }
}

