/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.dev;

import com.novell.emframe.dev.eMFrameUtils;

public class PluginException
extends Exception {
    private static final long serialVersionUID = 1L;
    private String m_header = null;
    private String m_body = null;
    private String m_subText = null;
    private Throwable m_throwable = null;
    private int m_errorCode = 0;
    private boolean m_rewriteURLs = true;

    private void initPluginException(String header, String body, String subText, Throwable rootCause, int errorCode, boolean rewriteURLs) {
        this.m_header = header;
        this.m_body = body;
        this.m_subText = subText;
        this.m_throwable = rootCause;
        this.m_errorCode = errorCode;
        this.m_rewriteURLs = rewriteURLs;
    }

    public PluginException(String header, String body, String subText) {
        this.initPluginException(header, body, subText, null, 0, true);
    }

    public PluginException(String header, String body, String subText, Throwable cause) {
        super(cause);
        this.initPluginException(header, body, subText, null, 0, true);
    }

    public PluginException(String header, String body) {
        this.initPluginException(header, body, null, null, 0, true);
    }

    public PluginException(String header, String body, Throwable cause) {
        super(cause);
        this.initPluginException(header, body, null, null, 0, true);
    }

    public PluginException(String header, String body, boolean rewriteURLs) {
        this.initPluginException(header, body, null, null, 0, rewriteURLs);
    }

    public PluginException(String header, String body, boolean rewriteURLs, Throwable cause) {
        super(cause);
        this.initPluginException(header, body, null, null, 0, rewriteURLs);
    }

    public PluginException(String header, String body, int errorCode) {
        this.initPluginException(header, body, null, null, errorCode, true);
    }

    public PluginException(String header, String body, int errorCode, Throwable cause) {
        super(cause);
        this.initPluginException(header, body, null, null, errorCode, true);
    }

    public PluginException(Exception rootExceptionCause) {
        super(rootExceptionCause);
        this.initPluginException(null, null, null, rootExceptionCause, 0, true);
    }

    public PluginException(Throwable rootCause) {
        super(rootCause);
        this.initPluginException(null, null, null, rootCause, 0, true);
    }

    public String getHeader() {
        return this.m_header;
    }

    public boolean getRewriteURLs() {
        return this.m_rewriteURLs;
    }

    public String getBody() {
        return this.m_body;
    }

    public String getBoldText() {
        return this.m_subText;
    }

    public String getMessage() {
        if (this.m_throwable != null) {
            return this.m_throwable.getMessage();
        }
        if (this.m_subText == null) {
            return this.m_body;
        }
        return eMFrameUtils.formatMessage(this.m_body, new String[]{this.m_subText});
    }

    public String getLocalizedMessage() {
        return this.getMessage();
    }

    public Exception getException() {
        if (this.m_throwable == null) {
            return null;
        }
        if (this.m_throwable instanceof Exception) {
            return (Exception)this.m_throwable;
        }
        return new Exception(this.m_throwable.toString(), this.m_throwable);
    }

    public int getErrorCode() {
        return this.m_errorCode;
    }
}

