/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.dev;

import com.novell.emframe.dev.D;
import com.novell.emframe.dev.MContext;
import com.novell.emframe.dev.UiHandlerActionTrigger;
import com.novell.emframe.dev.UiHandlerContext;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.jdom.Element;

public abstract class UiHandler {
    protected UiHandlerContext context = null;
    protected ArrayList m_params = new ArrayList();
    protected Hashtable m_parameterValues = new Hashtable();
    protected MContext m_taskContext = null;
    public static final String PARAM_REGULAR_EXPRESSION = "regularExpression";
    public static final String PARAM_REGULAR_EXPRESSION_ERROR_MSG = "regularExpressionErrorMsg";
    public static final String PARAM_CUSTOM_LABEL = "customLabel";
    public static final String PARAM_HIDE_LABEL = "hideLabel";

    public final void init(UiHandlerContext context) {
        this.context = context;
    }

    public boolean isEDirAttribute() {
        return true;
    }

    public String getId() {
        return this.context.getId();
    }

    public String getAttributeName() {
        return this.context.getAttributeName();
    }

    public String getEncodedAttributeName() {
        return this.context.getEncodedAttributeName();
    }

    public boolean isForceReadOnly() {
        return this.context.isForceReadOnly();
    }

    public String getActionHandlerName() {
        return null;
    }

    public String getNotificationName() {
        return null;
    }

    public Element[] getNeedUrlParams() {
        return null;
    }

    public boolean makeMultiPartFrom() {
        return false;
    }

    public void processParam(Element element) {
        String paramName = element.getAttributeValue("name");
        Iterator iter = this.m_params.iterator();
        while (iter.hasNext()) {
            Element current = (Element)iter.next();
            String currentName = current.getAttributeValue("name");
            if (!currentName.equals(paramName)) continue;
            iter.remove();
        }
        this.m_params.add(element);
        String name = element.getAttributeValue("name");
        List children = element.getChildren();
        if (element.getChildren().size() == 1) {
            String value = element.getChildTextTrim("value");
            if (value != null && value.length() > 0) {
                this.setParameterValue(name, value);
            }
        } else if (children.size() > 1) {
            String[] values = new String[children.size()];
            int i = 0;
            Iterator iter2 = children.iterator();
            while (iter2.hasNext()) {
                Element child = (Element)iter2.next();
                values[i++] = child.getTextTrim();
            }
            this.setParameterValues(name, values);
        }
    }

    public final ArrayList getParams() {
        return this.m_params;
    }

    public String[] getSharedHeaderCode() {
        return null;
    }

    public void printExitCode(PrintWriter pw, String indent) {
    }

    public void printInitCode(PrintWriter pw, String indent) {
    }

    public void printFocus(PrintWriter pw, String indent) {
    }

    public void printScript(PrintWriter pw, String indent) {
        String regExpError;
        String regExp = this.getParameterValue(PARAM_REGULAR_EXPRESSION);
        if (regExp == null) {
            regExp = "";
        }
        if ((regExpError = this.getParameterValue(PARAM_REGULAR_EXPRESSION_ERROR_MSG)) == null) {
            regExpError = "";
        }
        pw.println(indent + "<SCRIPT>");
        pw.println(indent + "   window.uiObject_" + this.context.getEncodedAttributeName() + " = new UiObject();");
        if (!this.context.isForceReadOnly()) {
            UiHandlerActionTrigger[] actionTriggers;
            pw.println(indent + "   <c:if test=\"${" + this.context.geteDasRights() + "}\">");
            String methodName = this.getNotificationName();
            if (methodName != null) {
                pw.println(indent + "      addToNotificationList('" + this.context.getEncodedAttributeName() + "', '" + methodName + "');");
            }
            if ((methodName = this.getActionHandlerName()) != null) {
                pw.println(indent + "      addActionHandler('" + this.context.getEncodedAttributeName() + "', '" + methodName + "');");
            }
            if ((actionTriggers = this.context.getActionTriggers()) != null && actionTriggers.length > 0) {
                for (int i = 0; i < this.context.getActionTriggers().length; ++i) {
                    pw.println(indent + "      addEventListener(\"" + this.context.getEncodedAttributeName() + "\", \"" + actionTriggers[i].getTrigger() + "\", \"" + actionTriggers[i].getTargetField() + "\", \"" + actionTriggers[i].getTargetAction() + "\");");
                }
            }
            pw.println(indent + "   </c:if>");
        }
        pw.println(indent + "</SCRIPT>");
    }

    public void printLabel(PrintWriter pw, String indent) {
        String hideLabel = this.getParameterValue(PARAM_HIDE_LABEL);
        D.assrt(hideLabel == null || hideLabel.equalsIgnoreCase("false"), "Should not call printLabel when hideLabel==true");
        String customLabel = this.getParameterValue(PARAM_CUSTOM_LABEL);
        if (customLabel == null) {
            String forceMandatory;
            String colon = this.context.isHideColon() ? "" : ":";
            String string = forceMandatory = this.context.isForceMandatory() ? "<font color=\"red\">*</font>" : "";
            if (this.context.getEncodedAttributeName() != null && this.context.getEncodedAttributeName().length() > 0) {
                pw.println(indent + "<c:out value=\"${" + this.context.getEncodedAttributeName() + "DisplayName}\"/>" + colon + forceMandatory + "&nbsp;&nbsp;");
            }
        } else {
            pw.println(indent + customLabel + ":&nbsp;");
        }
    }

    public void printMandatoryCheckCode(PrintWriter pw, String indent, boolean forceMandatory) {
        if (this.context.isForceMandatory() || forceMandatory) {
            pw.println(indent + "if(form." + this.context.geteDasName() + ".value.indexOf('<value')<0)");
            pw.println(indent + "{");
            String customLabel = this.getParameterValue(PARAM_CUSTOM_LABEL);
            if (customLabel == null) {
                pw.println(indent + "   alert(formatMessage(\"<iman:string key=\"General.provideMandatoryAttribute\"/>\", [\"<iman:toScript><c:out value=\"${" + this.context.getEncodedAttributeName() + "DisplayName}\"/></iman:toScript>\"]));");
            } else {
                pw.println(indent + "   alert(formatMessage(\"<iman:string key=\"General.provideMandatoryAttribute\"/>\", [\"" + customLabel + "\"]));");
            }
            pw.println(indent + "   return false;");
            pw.println(indent + "}");
        }
    }

    public void printLabelLeftOfControl(PrintWriter pw, String indent, MContext taskContext) {
        this.m_taskContext = taskContext;
        pw.println(indent + "<TR>");
        pw.println(indent + "   <TD align=left>");
        String hideLabel = this.getParameterValue(PARAM_HIDE_LABEL);
        if (hideLabel == null || !hideLabel.equalsIgnoreCase("true")) {
            this.printLabel(pw, indent + "      ");
        }
        pw.println(indent + "   </TD>");
        pw.println(indent + "   <c:if test=\" ${DEVICE_TYPE=='pocket'}\"></TR><TR></c:if>");
        pw.println(indent + "   <TD>");
        this.printHiddenInput(pw, indent + "      ");
        this.printUiCode(pw, indent + "      ");
        pw.println(indent + "   </TD>");
        pw.println(indent + "   <TD valign=top>");
        this.printModeSelectorCode(pw, indent + "      ");
        pw.println(indent + "   </TD>");
        pw.println(indent + "</TR>");
    }

    protected void printHiddenInput(PrintWriter pw, String indent) {
        if (!this.context.isForceReadOnly()) {
            pw.println(indent + "<c:if test=\"${" + this.context.geteDasRights() + "}\">");
            pw.println(indent + "   <INPUT type=\"hidden\" name=\"" + this.context.geteDasName() + "\" value=\"<c:out value=\"${" + this.context.geteDasName() + "}\" escapeXml=\"false\"/>\">");
            pw.println(indent + "</c:if>");
        }
    }

    public void printLabelAboveControl(PrintWriter pw, String indent, MContext taskContext) {
        this.m_taskContext = taskContext;
        String hideLabel = this.getParameterValue(PARAM_HIDE_LABEL);
        if (hideLabel == null || !hideLabel.equalsIgnoreCase("true")) {
            pw.println(indent + "<TR>");
            pw.println(indent + "   <TD align=\"left\" colspan=\"2\">");
            this.printLabel(pw, indent + "      ");
            pw.println(indent + "   </TD>");
            pw.println(indent + "</TR>");
        }
        pw.println(indent + "<TR>");
        pw.println(indent + "   <TD>");
        this.printHiddenInput(pw, indent + "      ");
        this.printUiCode(pw, indent + "      ");
        pw.println(indent + "   </TD>");
        pw.println(indent + "   <TD valign=\"top\">");
        this.printModeSelectorCode(pw, indent + "      ");
        pw.println(indent + "   </TD>");
        pw.println(indent + "</TR>");
    }

    protected void printModeSelectorCode(PrintWriter pw, String indent) {
        pw.println(indent + "<c:set var=\"mode\"><x:out select=\"$edasXml/edas/" + this.context.getEncodedAttributeName() + "/@mode\"/></c:set>");
        pw.println(indent + "<iman:mooMode name=\"_" + this.context.getEncodedAttributeName() + "_mode\" value=\"${mode}\" multi=\"" + !this.context.isForceReadOnly() + "\" />");
    }

    protected void printUiCode(PrintWriter pw, String indent) {
    }

    public void setParameterValue(String name, String value) {
        this.m_parameterValues.put(name, value);
    }

    public void setParameterValues(String name, String[] values) {
        this.m_parameterValues.put(name, values);
    }

    public String getParameterValue(String name) {
        Object o = this.m_parameterValues.get(name);
        if (o instanceof String) {
            return (String)o;
        }
        return null;
    }

    public String[] getParameterValues(String name) {
        Object o = this.m_parameterValues.get(name);
        if (o instanceof String[]) {
            return (String[])o;
        }
        if (o instanceof String) {
            return new String[]{(String)o};
        }
        return null;
    }
}

