/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.dev.rights;

import com.novell.emframe.dev.rights.eDirRightsData;

public class eDirPropertyRightsData
extends eDirRightsData {
    public static final int RIGHTS_COMPARE = 1;
    public static final int RIGHTS_READ = 2;
    public static final int RIGHTS_WRITE = 4;
    public static final int RIGHTS_SELF = 8;
    public static final int RIGHTS_SUPERVISOR = 32;
    public static final int RIGHTS_DYNAMIC = 0x20000000;
    public static final int RIGHTS_INHERITABLE = 64;
    public static final int RIGHTS_NESTED = Integer.MIN_VALUE;
    private boolean allProperties;
    private int rights;

    public eDirPropertyRightsData(int rights, boolean allProperties) {
        this.rights = rights;
        this.allProperties = allProperties;
    }

    public int getRights() {
        return this.rights;
    }

    public boolean hasCompareRights() {
        return (this.rights & 1) != 0;
    }

    public boolean hasReadRights() {
        return (this.rights & 2) != 0;
    }

    public boolean hasWriteRights() {
        return (this.rights & 4) != 0;
    }

    public boolean hasSelfRights() {
        return (this.rights & 8) != 0;
    }

    public boolean hasSupervisorRights() {
        return (this.rights & 0x20) != 0;
    }

    public boolean hasDynamicRights() {
        return (this.rights & 0x20000000) != 0;
    }

    public boolean hasInheritableRights() {
        if (this.allProperties) {
            return (this.rights & 0x40) == 0;
        }
        return (this.rights & 0x40) != 0;
    }

    public boolean hasNestedRights() {
        return (this.rights & Integer.MIN_VALUE) != 0;
    }

    public void setCompare(boolean set) {
        if (set) {
            if (!this.hasCompareRights()) {
                this.rights |= 1;
                this.setDirty();
            }
        } else if (this.hasCompareRights()) {
            this.rights &= 0xFFFFFFFE;
            this.setDirty();
        }
    }

    public void setRead(boolean set) {
        if (set) {
            if (!this.hasReadRights()) {
                this.rights |= 2;
                this.setDirty();
            }
        } else if (this.hasReadRights()) {
            this.rights &= 0xFFFFFFFD;
            this.setDirty();
        }
    }

    public void setWrite(boolean set) {
        if (set) {
            if (!this.hasWriteRights()) {
                this.rights |= 4;
                this.setDirty();
            }
        } else if (this.hasWriteRights()) {
            this.rights &= 0xFFFFFFFB;
            this.setDirty();
        }
    }

    public void setSelf(boolean set) {
        if (set) {
            if (!this.hasSelfRights()) {
                this.rights |= 8;
                this.setDirty();
            }
        } else if (this.hasSelfRights()) {
            this.rights &= 0xFFFFFFF7;
            this.setDirty();
        }
    }

    public void setSupervisor(boolean set) {
        if (set) {
            if (!this.hasSupervisorRights()) {
                this.rights |= 0x20;
                this.setDirty();
            }
        } else if (this.hasSupervisorRights()) {
            this.rights &= 0xFFFFFFDF;
            this.setDirty();
        }
    }

    public void setDynamic(boolean set) {
        if (set) {
            if (!this.hasDynamicRights()) {
                this.rights |= 0x20000000;
                this.setDirty();
            }
        } else if (this.hasDynamicRights()) {
            this.rights &= 0xDFFFFFFF;
            this.setDirty();
        }
    }

    public void setInheritable(boolean set) {
        if (this.allProperties) {
            if (set) {
                if (!this.hasInheritableRights()) {
                    this.rights &= 0xFFFFFFBF;
                    this.setDirty();
                }
            } else if (this.hasInheritableRights()) {
                this.rights |= 0x40;
                this.setDirty();
            }
        } else if (set) {
            if (!this.hasInheritableRights()) {
                this.rights |= 0x40;
                this.setDirty();
            }
        } else if (this.hasInheritableRights()) {
            this.rights &= 0xFFFFFFBF;
            this.setDirty();
        }
    }

    public void setNestedRights(boolean set) {
        if (set) {
            if (!this.hasNestedRights()) {
                this.rights |= Integer.MIN_VALUE;
                this.setDirty();
            }
        } else if (this.hasNestedRights()) {
            this.rights &= Integer.MAX_VALUE;
            this.setDirty();
        }
    }
}

