/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.dev.rights;

import com.novell.admin.common.exceptions.AdminError;
import com.novell.admin.common.exceptions.SPIException;
import com.novell.admin.ns.AdminNamespace;
import com.novell.admin.ns.AttributeDefinition;
import com.novell.admin.ns.ClassDefinition;
import com.novell.admin.ns.ComponentCreationException;
import com.novell.admin.ns.LongValue;
import com.novell.admin.ns.MODObject;
import com.novell.admin.ns.NSObject;
import com.novell.admin.ns.NamespaceException;
import com.novell.admin.ns.ObjectAttribute;
import com.novell.admin.ns.Syntax;
import com.novell.admin.ns.ValueComponent;
import com.novell.admin.ns.ValueList;
import com.novell.admin.ns.nds.NDSObjectRights;
import com.novell.admin.ns.nds.NDSPropertyRights;
import com.novell.admin.ns.nds.ObjectACLFacade;
import com.novell.application.console.snapin.NamespaceSnapin;
import com.novell.application.console.snapin.ObjectEntry;
import com.novell.application.console.snapin.SnapinVetoException;
import com.novell.emframe.dev.D;
import com.novell.emframe.dev.rights.eDirObjectRightsData;
import com.novell.emframe.dev.rights.eDirPropertyRightsData;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;

public final class eDirRightsObject {
    public static final int NO_ASSIGNMENT = -16777216;
    public static final int ALL_OBJ_RIGHTS = 31;
    public static final int ALL_PROP_RIGHTS = 47;
    public static final int OBJECT_EXCEPTION = 1;
    private AdminNamespace adminNS = null;
    private NSObject nsObject = null;
    private boolean isDirty = false;
    private boolean normalObj = true;
    private ObjectEntry entry = null;
    static final Comparator stringCmp = new Comparator(){

        public int compare(Object o1, Object o2) {
            String s1 = (String)o1;
            String s2 = (String)o2;
            int len1 = s1.length();
            int len2 = s2.length();
            int n = Math.min(len1, len2);
            for (int i = 0; i < n; ++i) {
                char c2;
                char c1 = s1.charAt(i);
                if (c1 == (c2 = s2.charAt(i))) continue;
                return c1 - c2;
            }
            return len1 - len2;
        }
    };

    public eDirRightsObject(NSObject nsObject) {
        this.nsObject = nsObject;
        this.entry = nsObject.getObjectEntry();
        NamespaceSnapin namespace = this.entry.getObjectType().getNamespace();
        if (namespace instanceof AdminNamespace) {
            this.adminNS = (AdminNamespace)namespace;
        }
    }

    public eDirRightsObject(String specialObject) {
        this.normalObj = false;
    }

    public boolean updateData() {
        boolean rVal = true;
        if (this.normalObj && this.isDirty()) {
            try {
                this.adminNS.update(this.nsObject);
                this.clearDirty();
            }
            catch (SPIException e) {
                D.log(e);
                rVal = false;
            }
            catch (SnapinVetoException e) {
                D.log(e);
                rVal = false;
            }
        }
        return rVal;
    }

    public void updateDataNoCatch() throws SPIException, SnapinVetoException {
        if (this.normalObj && this.isDirty()) {
            this.adminNS.update(this.nsObject);
            this.clearDirty();
        }
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    public Enumeration getTrustees() {
        return new TrusteesEnumeration();
    }

    public Enumeration getAttributeNames() {
        return new AttributeEnumeration();
    }

    public AdminNamespace getNameSpace() {
        return this.adminNS;
    }

    public boolean aclReadRights() {
        boolean rVal = false;
        if (this.normalObj) {
            eDirPropertyRightsData rights = this.getACLPropertyRights();
            rVal = rights.hasReadRights();
        }
        return rVal;
    }

    public boolean aclWriteRights() {
        boolean rVal = false;
        if (this.normalObj) {
            eDirPropertyRightsData rights = this.getACLPropertyRights();
            rVal = rights.hasWriteRights();
        }
        return rVal;
    }

    public eDirObjectRightsData getEffectiveObjectRights(ObjectEntry trusteeObj) {
        if (this.normalObj) {
            try {
                NDSObjectRights obj = (NDSObjectRights)this.adminNS.getObjectEffectiveRights(this.entry, trusteeObj);
                return new eDirObjectRightsData(obj.getPrivileges());
            }
            catch (SPIException e) {
                D.log(e);
            }
        }
        return new eDirObjectRightsData(0);
    }

    public eDirPropertyRightsData getEffectiveAllPropertyRights(ObjectEntry trusteeObj) {
        if (this.normalObj) {
            return this.getEffectivePropertyRights(trusteeObj, "[All Attributes Rights]");
        }
        return new eDirPropertyRightsData(0, true);
    }

    public NDSPropertyRights[] getArrayOfEffectivePropertyRights(ObjectEntry trusteeObj, String[] properties) {
        NDSPropertyRights[] props = null;
        try {
            props = (NDSPropertyRights[])this.adminNS.getPropertyEffectiveRights(this.entry, trusteeObj, properties);
        }
        catch (SPIException e) {
            D.log(e);
        }
        return props;
    }

    public eDirPropertyRightsData getEffectivePropertyRights(ObjectEntry trusteeObj, String property) {
        if (this.normalObj) {
            try {
                String[] properties = new String[]{property};
                NDSPropertyRights prop = (NDSPropertyRights)this.adminNS.getPropertyEffectiveRights(this.entry, trusteeObj, properties)[0];
                if (property.equals("[All Attributes Rights]")) {
                    return new eDirPropertyRightsData(prop.getPrivileges(), true);
                }
                return new eDirPropertyRightsData(prop.getPrivileges(), false);
            }
            catch (SPIException e) {
                D.log(e);
            }
        }
        if (property.equals("[All Attributes Rights]")) {
            return new eDirPropertyRightsData(0, true);
        }
        return new eDirPropertyRightsData(0, false);
    }

    public eDirObjectRightsData getObjectInheritedFilters() {
        Vector v = this.getACLRights("[Entry Rights]", "[Inheritance Mask]");
        if (v.size() > 1) {
            throw new AdminError(1, this.getClass());
        }
        return new eDirObjectRightsData((Integer)v.elementAt(0));
    }

    public eDirPropertyRightsData getAllPropertyInheritedFilters() {
        return this.getPropertyInheritedFilters("[All Attributes Rights]");
    }

    public eDirPropertyRightsData getPropertyInheritedFilters(String property) {
        Vector v = this.getACLRights(property, "[Inheritance Mask]");
        if (v.size() > 1) {
            throw new AdminError(1, this.getClass());
        }
        if (property.equals("[All Attributes Rights]")) {
            return new eDirPropertyRightsData((Integer)v.elementAt(0), true);
        }
        return new eDirPropertyRightsData((Integer)v.elementAt(0), false);
    }

    public Vector getAssignedObjectRights(String trustee) {
        Vector vInteger = new Vector();
        Vector<eDirObjectRightsData> vData = new Vector<eDirObjectRightsData>();
        vInteger = this.getACLRights("[Entry Rights]", trustee);
        if (vInteger.size() > 2) {
            throw new AdminError(1, this.getClass());
        }
        if ((Integer)vInteger.elementAt(0) == -16777216) {
            return null;
        }
        vData.addElement(new eDirObjectRightsData((Integer)vInteger.elementAt(0)));
        if (vInteger.size() > 1) {
            vData.addElement(new eDirObjectRightsData((Integer)vInteger.elementAt(1)));
        }
        return vData;
    }

    public Vector getAssignedAllPropertyRights(String trustee) {
        return this.getAssignedPropertyRights(trustee, "[All Attributes Rights]");
    }

    public Vector getAssignedPropertyRights(String trustee, String property) {
        Vector vInteger = new Vector();
        Vector<eDirPropertyRightsData> vData = new Vector<eDirPropertyRightsData>();
        vInteger = this.getACLRights(property, trustee);
        if (vInteger.size() > 2) {
            throw new AdminError(1, this.getClass());
        }
        if ((Integer)vInteger.elementAt(0) == -16777216) {
            return null;
        }
        if (property.equals("[All Attributes Rights]")) {
            vData.addElement(new eDirPropertyRightsData((Integer)vInteger.elementAt(0), true));
            if (vInteger.size() > 1) {
                vData.addElement(new eDirPropertyRightsData((Integer)vInteger.elementAt(1), true));
            }
            return vData;
        }
        vData.addElement(new eDirPropertyRightsData((Integer)vInteger.elementAt(0), false));
        if (vInteger.size() > 1) {
            vData.addElement(new eDirPropertyRightsData((Integer)vInteger.elementAt(1), false));
        }
        return vData;
    }

    public ObjectAttribute getACLAttribute() {
        return this.nsObject.getAttribute("ACL");
    }

    public boolean deleteTrustee(String trustee) {
        ObjectAttribute acl = this.getACLAttribute();
        boolean rVal = false;
        if (acl != null) {
            ValueComponent comp;
            while ((comp = this.getACLValueComponent(acl, null, trustee, null)) != null) {
                if (!acl.removeComponent(comp)) continue;
                rVal = true;
                this.setDirty();
            }
        }
        return rVal;
    }

    public boolean deleteACL(String trustee, String protectedName, int rights) {
        boolean rVal = false;
        ObjectAttribute acl = this.getACLAttribute();
        if (acl != null) {
            ValueComponent comp;
            while ((comp = this.getACLValueComponent(acl, protectedName, trustee, new Integer(rights))) != null) {
                if (!acl.removeComponent(comp)) continue;
                rVal = true;
                this.setDirty();
            }
        }
        return rVal;
    }

    public boolean needToPreventOrphaning(String objNotToCheck) {
        String currentName;
        Enumeration eTrustees = this.getTrustees();
        Vector v = new Vector();
        boolean noIRM = true;
        if (!objNotToCheck.equals("")) {
            while (eTrustees.hasMoreElements()) {
                currentName = (String)eTrustees.nextElement();
                if (currentName == null || !currentName.equals("[Inheritance Mask]")) continue;
                noIRM = false;
                v = this.getAssignedObjectRights(currentName);
                if (v != null) {
                    if (((eDirObjectRightsData)v.elementAt(0)).hasSupervisorRights()) {
                        return false;
                    }
                } else {
                    return false;
                }
                v = this.getAssignedObjectRights(currentName);
                if (v == null || !(v.size() == 1 ? ((eDirObjectRightsData)v.elementAt(0)).hasSupervisorRights() : ((eDirObjectRightsData)v.elementAt(0)).hasSupervisorRights() || ((eDirObjectRightsData)v.elementAt(1)).hasSupervisorRights())) continue;
                return false;
            }
            if (noIRM) {
                return false;
            }
        }
        eTrustees = this.getTrustees();
        while (eTrustees.hasMoreElements()) {
            currentName = (String)eTrustees.nextElement();
            if (currentName == null || currentName.equals("[Inheritance Mask]") || currentName.equals(objNotToCheck) || (v = this.getAssignedObjectRights(currentName)) == null || !(v.size() == 1 ? ((eDirObjectRightsData)v.elementAt(0)).hasSupervisorRights() : ((eDirObjectRightsData)v.elementAt(0)).hasSupervisorRights() || ((eDirObjectRightsData)v.elementAt(1)).hasSupervisorRights())) continue;
            return false;
        }
        return true;
    }

    public void setAllObjectRights(String subject, int rights) {
        this.setACLValue("[Entry Rights]", subject, rights, null);
    }

    public void setAllObjectInheritedFilters(int rights) {
        this.setPropertyInheritedFilters("[Entry Rights]", rights);
    }

    public void setAllPropertyInheritedFilters(int rights) {
        this.setPropertyInheritedFilters("[All Attributes Rights]", rights);
    }

    public void setPropertyInheritedFilters(String property, int rights) {
        this.setACLValue(property, "[Inheritance Mask]", rights, null);
    }

    public void setAllPropertyRights(String subject, int rights) {
        this.setACLValue("[All Attributes Rights]", subject, rights, null);
    }

    public void setPropertyRights(String property, String subject, int newRights, int oldRights) {
        this.setACLValue(property, subject, newRights, new Integer(oldRights));
    }

    public NSObject getNSObject() {
        return this.nsObject;
    }

    public void externalSetDirty() {
        this.setDirty();
    }

    private void setACLValue(String protectedAttr, String subject, int newRights, Integer oldRights) {
        ValueComponent oldComp = null;
        ValueComponent newComp = null;
        ObjectAttribute attribute = null;
        AttributeDefinition def = null;
        Vector<Object> v = new Vector<Object>();
        ValueComponent vc = null;
        ObjectAttribute acl = this.getACLAttribute();
        v.addElement(protectedAttr);
        v.addElement(subject);
        v.addElement(new Long(newRights));
        if (this.normalObj) {
            if (acl == null) {
                try {
                    def = this.adminNS.getAttributeDefinition(this.entry, "ACL");
                    Syntax syn = def.getSyntax();
                    attribute = new ObjectAttribute(def);
                    vc = syn.createValueComponent(v);
                    attribute.addComponent(vc);
                    this.getNSObject().addAttribute(attribute);
                    this.setDirty();
                }
                catch (SPIException e) {
                    D.log(e);
                }
                catch (NamespaceException e) {
                    D.log(e);
                    attribute = null;
                }
                catch (ComponentCreationException e) {
                    D.log(e);
                    attribute = null;
                }
            } else {
                try {
                    Syntax syn = acl.getAttributeDefinition().getSyntax();
                    newComp = syn.createValueComponent(v);
                    if (!(this.nsObject instanceof MODObject)) {
                        oldComp = this.getACLValueComponent(acl, protectedAttr, subject, oldRights);
                    }
                    if (oldComp != null) {
                        acl.replaceComponent(oldComp, newComp);
                        this.setDirty();
                    } else {
                        acl.addComponent(newComp);
                        this.setDirty();
                    }
                }
                catch (ComponentCreationException e) {
                    D.log(e);
                }
                catch (NamespaceException e) {
                    D.log(e);
                }
            }
        }
    }

    private Vector getACLRights(String protectedName, String subjectName) {
        Enumeration values;
        Vector<Integer> v = new Vector<Integer>();
        boolean foundACL = false;
        ObjectAttribute attr = this.getACLAttribute();
        if (attr != null && (values = attr.getValueComponents()) != null) {
            block5: while (values.hasMoreElements()) {
                ValueComponent comp = (ValueComponent)values.nextElement();
                if (comp == null || !(comp instanceof ValueList)) continue;
                Enumeration childValues = ((ValueList)comp).getComponents();
                int count = 0;
                block6: while (childValues.hasMoreElements()) {
                    ValueComponent aclComp = (ValueComponent)childValues.nextElement();
                    if (!(aclComp instanceof ValueComponent)) continue;
                    switch (count) {
                        case 0: {
                            if (!aclComp.toString().equals(protectedName)) continue block5;
                            ++count;
                            continue block6;
                        }
                        case 1: {
                            if (!aclComp.toString().equalsIgnoreCase(subjectName)) continue block5;
                            ++count;
                            continue block6;
                        }
                        case 2: {
                            foundACL = true;
                            v.addElement(new Integer((int)((LongValue)aclComp).getValue()));
                            continue block5;
                        }
                    }
                    continue block5;
                }
            }
        }
        if (subjectName == "[Inheritance Mask]" && !foundACL) {
            if (protectedName == "[Entry Rights]") {
                v.addElement(new Integer(31));
                return v;
            }
            v.addElement(new Integer(47));
            return v;
        }
        if (!foundACL) {
            v.addElement(new Integer(-16777216));
        }
        return v;
    }

    private ValueComponent getACLValueComponent(ObjectAttribute acl, String protectedName, String subject, Integer rights) {
        Enumeration values;
        if (this.normalObj && (values = acl.getValueComponents()) != null) {
            while (values.hasMoreElements()) {
                ValueComponent comp = (ValueComponent)values.nextElement();
                if (comp == null || !(comp instanceof ValueList)) continue;
                ObjectACLFacade facade = (ObjectACLFacade)((ValueList)comp).createFacade();
                if (protectedName != null && !protectedName.equals(facade.getProtectedAttrName())) continue;
                if (subject == null) {
                    return comp;
                }
                if (!subject.equalsIgnoreCase(facade.getSubjectName())) continue;
                if (rights == null) {
                    return comp;
                }
                if ((long)rights.intValue() != facade.getPrivileges()) continue;
                return comp;
            }
        }
        return null;
    }

    private eDirPropertyRightsData getACLPropertyRights() {
        if (this.normalObj) {
            try {
                return this.getEffectivePropertyRights(this.adminNS.getAuthenticatedIdentity(this.entry), "ACL");
            }
            catch (SPIException e) {
                D.log(e);
            }
        }
        return new eDirPropertyRightsData(0, false);
    }

    private void setDirty() {
        this.isDirty = true;
    }

    public void clearDirty() {
        this.isDirty = false;
    }

    class TrusteesEnumeration
    implements Enumeration {
        private Vector v = new Vector();
        private Iterator vi = null;

        public TrusteesEnumeration() {
            if (eDirRightsObject.this.normalObj && eDirRightsObject.this.getNSObject() != null) {
                this.enumerateACLs();
                Collections.sort(this.v, stringCmp);
                this.vi = this.v.iterator();
            }
        }

        public boolean hasMoreElements() {
            if (this.vi != null) {
                return this.vi.hasNext();
            }
            return false;
        }

        public Object nextElement() {
            Object rVal = null;
            if (this.vi != null) {
                rVal = this.vi.next();
            }
            return rVal;
        }

        private void enumerateACLs() {
            Enumeration values;
            ObjectAttribute attr = eDirRightsObject.this.getACLAttribute();
            if (attr != null && (values = attr.getValueComponents()) != null) {
                while (values.hasMoreElements()) {
                    ValueComponent comp = (ValueComponent)values.nextElement();
                    if (comp == null || !(comp instanceof ValueList)) continue;
                    ObjectACLFacade fac = (ObjectACLFacade)((ValueList)comp).createFacade();
                    this.v.add(fac.getSubjectName());
                }
            }
        }
    }

    class AttributeEnumeration
    implements Enumeration {
        private Vector v = new Vector();
        private Iterator vi = null;

        public AttributeEnumeration() {
            NSObject nsObj = eDirRightsObject.this.getNSObject();
            if (eDirRightsObject.this.normalObj && nsObj != null) {
                int i;
                ClassDefinition classDef = nsObj.getClassDefinitions()[0];
                AttributeDefinition[] attrs = classDef.getMandatoryAttributes();
                for (i = 0; i < attrs.length; ++i) {
                    if (attrs[i].isHidden()) continue;
                    this.v.add(attrs[i].getName());
                }
                attrs = classDef.getOptionalAttributes();
                for (i = 0; i < attrs.length; ++i) {
                    if (attrs[i].isHidden()) continue;
                    this.v.add(attrs[i].getName());
                }
                Collections.sort(this.v, stringCmp);
                this.vi = this.v.iterator();
            }
        }

        public boolean hasMoreElements() {
            if (this.vi != null) {
                return this.vi.hasNext();
            }
            return false;
        }

        public Object nextElement() {
            Object rVal = null;
            if (this.vi != null) {
                rVal = this.vi.next();
            }
            return rVal;
        }
    }
}

