/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.fw;

import com.novell.admin.ns.AttributeDefinition;
import com.novell.admin.ns.ComponentCreationException;
import com.novell.admin.ns.IncompatibleComponentException;
import com.novell.admin.ns.Syntax;
import com.novell.admin.ns.ValueComponent;
import com.novell.admin.ns.ValueList;
import com.novell.admin.ns.nds.NetAddressFacade;
import com.novell.emframe.dev.D;
import com.novell.emframe.dev.DataHandlerHelper;
import com.novell.emframe.dev.MContext;
import com.novell.emframe.dev.XmlUtils;
import com.novell.emframe.dev.eDirAccessServiceException;
import com.novell.emframe.dev.eMFrameUtils;
import org.jdom.Element;

public class AddressSyntaxHandler
extends DataHandlerHelper {
    protected void valueComponentToXml(ValueComponent vc, StringBuffer resultValue, String attrName, Syntax syntax) throws eDirAccessServiceException {
        long aLong = ((NetAddressFacade)((ValueList)vc).createFacade()).getAddressType();
        byte[] bytes = ((NetAddressFacade)((ValueList)vc).createFacade()).getAddress();
        String value = null;
        value = aLong == 9L || aLong == 8L ? AddressSyntaxHandler.makeAddressString(aLong, bytes) : ((NetAddressFacade)((ValueList)vc).createFacade()).getAddressString();
        resultValue.append("<value>");
        resultValue.append(XmlUtils.xmlEncode(value));
        resultValue.append("</value>");
    }

    protected ValueComponent xmlToValueComponent(AttributeDefinition attributeDefinition, Element xml, MContext context) throws ComponentCreationException, IncompatibleComponentException {
        long addrType = this.getAddressType(xml.getText());
        byte[] bytes = this.getAddressBytes(xml.getText());
        return NetAddressFacade.createValueList((long)addrType, (byte[])bytes);
    }

    private static String makeAddressString(long addrType, byte[] address) {
        String hByte;
        String UDP_TYPE = "UDP";
        String TCP_TYPE = "TCP";
        int offset = 0;
        StringBuffer sb = new StringBuffer();
        if (addrType == 8L) {
            sb.append(UDP_TYPE);
        } else {
            sb.append(TCP_TYPE);
        }
        sb = sb.append(": ");
        String lByte = null;
        if (Integer.toHexString(eMFrameUtils.byteToDecimal(address[offset])).length() < 2) {
            hByte = "0";
            hByte = hByte.concat(Integer.toHexString(eMFrameUtils.byteToDecimal(address[offset++])));
        } else {
            hByte = Integer.toHexString(eMFrameUtils.byteToDecimal(address[offset++]));
        }
        if (Integer.toHexString(eMFrameUtils.byteToDecimal(address[offset])).length() < 2) {
            lByte = "0";
            lByte = lByte.concat(Integer.toHexString(eMFrameUtils.byteToDecimal(address[offset++])));
        } else {
            lByte = Integer.toHexString(eMFrameUtils.byteToDecimal(address[offset++]));
        }
        sb.append(String.valueOf(eMFrameUtils.byteToDecimal(address[offset++])));
        sb.append(".");
        sb.append(String.valueOf(eMFrameUtils.byteToDecimal(address[offset++])));
        sb.append(".");
        sb.append(String.valueOf(eMFrameUtils.byteToDecimal(address[offset++])));
        sb.append(".");
        sb.append(String.valueOf(eMFrameUtils.byteToDecimal(address[offset++])));
        sb.append(":");
        String portString = hByte + lByte;
        sb.append(Integer.toString(Integer.valueOf(portString, 16)));
        return sb.toString();
    }

    private int getAddressType(String src) {
        String IPX_TYPE = "IPX";
        String IP_TYPE = "IP";
        String SDLC_TYPE = "SDLC";
        String ET_TYPE = "Ethernet/Tokenring";
        String OSI_TYPE = "OSI";
        String APPLETALK_TYPE = "Appletalk";
        String UDP_TYPE = "UDP";
        String TCP_TYPE = "TCP";
        String URL_TYPE = "URL";
        int x = src.indexOf(58);
        if (x != -1) {
            String addrType = src.substring(0, x);
            if ((addrType = addrType.trim()).equals(IPX_TYPE)) {
                return 0;
            }
            if (addrType.equals(IP_TYPE)) {
                return 1;
            }
            if (addrType.equals(SDLC_TYPE)) {
                return 2;
            }
            if (addrType.equalsIgnoreCase(ET_TYPE)) {
                return 3;
            }
            if (addrType.equals(OSI_TYPE)) {
                return 4;
            }
            if (addrType.equalsIgnoreCase(APPLETALK_TYPE)) {
                return 5;
            }
            if (addrType.equals(UDP_TYPE)) {
                return 8;
            }
            if (addrType.equals(TCP_TYPE)) {
                return 9;
            }
            if (addrType.equals(URL_TYPE)) {
                return 13;
            }
            D.assrt(false, "EDAS: Unsupported network address type:" + addrType);
            return -1;
        }
        D.assrt(false, "EDAS: Unsupported network address type or wrong format:" + src);
        return -1;
    }

    private byte[] getAddressBytes(String src) {
        int sd = -1;
        int ed = -1;
        long addrType = this.getAddressType(src);
        byte[] address = null;
        String part1 = null;
        String part2 = null;
        String part3 = null;
        String part4 = null;
        switch ((int)addrType) {
            case -1: {
                return null;
            }
            case 0: 
            case 2: 
            case 3: {
                sd = src.indexOf(":", 0) + 1;
                ed = src.indexOf(":", sd);
                part1 = src.substring(sd, ed);
                part1 = part1.trim();
                sd = ed + 1;
                ed = src.indexOf(":", sd);
                part2 = src.substring(sd, ed);
                sd = ed + 1;
                part3 = src.substring(sd);
                String composit = part1;
                composit = composit.concat(part2);
                composit = composit.concat(part3);
                address = eMFrameUtils.hexStringToByteArray(composit);
                break;
            }
            case 1: {
                sd = src.indexOf(":", 0) + 1;
                ed = src.indexOf(".", sd);
                part1 = src.substring(sd, ed);
                part1 = part1.trim();
                sd = ed + 1;
                ed = src.indexOf(".", sd);
                part2 = src.substring(sd, ed);
                sd = ed + 1;
                ed = src.indexOf(".", sd);
                part3 = src.substring(sd, ed);
                sd = ed + 1;
                part4 = src.substring(sd);
                address = new byte[]{(byte)Integer.valueOf(part1).intValue(), (byte)Integer.valueOf(part2).intValue(), (byte)Integer.valueOf(part3).intValue(), (byte)Integer.valueOf(part4).intValue()};
                break;
            }
            case 4: 
            case 5: {
                sd = src.indexOf(":", 0) + 1;
                part1 = src.substring(sd);
                part1 = part1.trim();
                address = eMFrameUtils.hexStringToByteArray(part1);
                break;
            }
            case 8: 
            case 9: {
                String portField = null;
                sd = src.indexOf(":", 0) + 1;
                ed = src.indexOf(".", sd);
                part1 = src.substring(sd, ed);
                part1 = part1.trim();
                sd = ed + 1;
                ed = src.indexOf(".", sd);
                part2 = src.substring(sd, ed);
                sd = ed + 1;
                ed = src.indexOf(".", sd);
                part3 = src.substring(sd, ed);
                sd = ed + 1;
                ed = src.indexOf(":", sd);
                part4 = src.substring(sd, ed);
                sd = ed + 1;
                portField = src.substring(sd);
                portField = portField.trim();
                String port = new String("");
                String hexString = Integer.toHexString(Integer.valueOf(portField));
                int portPaddLength = 4 - hexString.length();
                for (int x = 0; x < portPaddLength; ++x) {
                    port = port.concat("0");
                }
                port = port.concat(hexString);
                address = new byte[]{(byte)Integer.valueOf(port.substring(0, 2), 16).intValue(), (byte)Integer.valueOf(port.substring(2, 4), 16).intValue(), (byte)Integer.valueOf(part1).intValue(), (byte)Integer.valueOf(part2).intValue(), (byte)Integer.valueOf(part3).intValue(), (byte)Integer.valueOf(part4).intValue()};
                break;
            }
        }
        return address;
    }
}

