/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.fw;

import com.novell.emframe.dev.D;
import com.novell.emframe.dev.config.SystemConfig;
import com.novell.naudit.LogEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;

public class AuditLog {
    public static long LOGEVENT_SYSTEM_STARTED = 0x150001L;
    public static long LOGEVENT_SYSTEM_SHUTDOWN = 1376258L;
    public static long LOGEVENT_PORTAL_AUTHENTICATION_SUCCEEDED = 1376259L;
    public static long LOGEVENT_IMANAGER_AUTHENTICATION_SUCCEEDED = 1376260L;
    public static long LOGEVENT_PORTAL_AUTHENTICATION_FAILED = 0x150005L;
    public static long LOGEVENT_IMANAGER_AUTHENTICATION_FAILED = 1376262L;
    public static long LOGEVENT_PORTAL_LOGOUT = 1376263L;
    public static long LOGEVENT_IMANAGER_LOGOUT = 1376264L;
    public static long LOGEVENT_MODULE_INSTALL = 1376265L;
    public static long LOGEVENT_MODULE_INSTALL_FAILED = 0x150010L;
    public static long LOGEVENT_FAILED_SSL_CONNECTION = 0x150011L;
    public static long LOGEVENT_SYSTEM_CONFIGURATION_CHANGED = 1376274L;
    public static long LOGEVENT_AUTHORIZED_USER_ADDED = 1376275L;
    public static long LOGEVENT_AUTHORIZED_USER_REMOVED = 1376276L;
    public static final String ENABLE_NSURE_AUDIT_LOG = "Audit.EnableNSureAuditLog";
    public static final String LOG_ITEM_AUTHORIZED_USERS = "Audit.AuthorizedUsers";
    public static final String LOG_ITEM_FAILED_SSL_CONNECTION = "Audit.FailedSSLConnection";
    public static final String LOG_ITEM_LOGIN_FAILED = "Audit.LoginFailed";
    public static final String LOG_ITEM_LOGIN_SUCCESS = "Audit.LoginSuccess";
    public static final String LOG_ITEM_LOGOUT = "Audit.Logout";
    public static final String LOG_ITEM_NPM_FAILED_INSTALL = "Audit.NPMFailedInstall";
    public static final String LOG_ITEM_NPM_INSTALLED = "Audit.NPMInstalled";
    public static final String LOG_ITEM_CHANGED_CONFIGURATION = "Audit.ChangedConfiguration";
    public static final String LOG_ITEM_SYSTEM_STARTUP = "Audit.Startup";
    public static final String LOG_ITEM_SYSTEM_SHUTDOWN = "Audit.Shutdown";
    private static LogEvent m_logEvent = null;
    private static boolean m_bNSureAuditAvailable = true;
    public static final String linuxCertFilePath = "/etc/imanicert.pem";
    public static final String linuxKeyFilePath = "/etc/imanipkey.pem";
    public static final String windowsCertFilePath = "c:\\windows\\imanicert.pem";
    public static final String windowsKeyFilePath = "c:\\windows\\imanipkey.pem";
    public static final String netwareCertFilePath = "sys:\\system\\imanicert.pem";
    public static final String netwareKeyFilePath = "sys:\\system\\imanipkey.pem";
    public static final String solarisCertFilePath = "/etc/imanicert.pem";
    public static final String solarisKeyFilePath = "/etc/imanipkey.pem";

    public static void logEvent(String sComponent, long lEventID) {
        block3: {
            LogEvent le = AuditLog.getLogEvent();
            if (le != null) {
                try {
                    le.LogEventDirect(sComponent, lEventID, 7L, 0L, 0L, null, null, 0L, 0L, 0L, 0L, null);
                }
                catch (Throwable t) {
                    if (!D.isDebugEnabled(1)) break block3;
                    D.log("Problem with LogEventDirect to NSure Audit.", 1);
                    D.log(t);
                }
            }
        }
    }

    public static void logEvent(String eventName, String a, String b, long eventKey) {
        block3: {
            LogEvent le = AuditLog.getLogEvent();
            if (le != null) {
                try {
                    le.LogEventDirect(eventName, eventKey, 7L, 0L, 0L, a, b, 0L, 0L, 0L, 0L, null);
                }
                catch (Throwable t) {
                    if (!D.isDebugEnabled(1)) break block3;
                    D.log("Problem with LogEventDirect to NSure Audit.", 1);
                    D.log(t);
                }
            }
        }
    }

    public static void logSuccessfulLogin(String userName, String host, boolean bPortal) {
        String sEnableNSureAuditLog = new SystemConfig().getSetting(LOG_ITEM_LOGIN_SUCCESS, "false");
        if (sEnableNSureAuditLog.equalsIgnoreCase("false")) {
            return;
        }
        if (bPortal) {
            AuditLog.logEvent("Authentication", userName, host, LOGEVENT_PORTAL_AUTHENTICATION_SUCCEEDED);
        } else {
            AuditLog.logEvent("Authentication", userName, host, LOGEVENT_IMANAGER_AUTHENTICATION_SUCCEEDED);
        }
    }

    public static void logFailedLogin(String userName, String host, boolean bPortal) {
        String sEnableNSureAuditLog = new SystemConfig().getSetting(LOG_ITEM_LOGIN_FAILED, "false");
        if (sEnableNSureAuditLog.equalsIgnoreCase("false")) {
            return;
        }
        if (bPortal) {
            AuditLog.logEvent("Authentication", userName, host, LOGEVENT_PORTAL_AUTHENTICATION_FAILED);
        } else {
            AuditLog.logEvent("Authentication", userName, host, LOGEVENT_IMANAGER_AUTHENTICATION_FAILED);
        }
    }

    public static void logLogout(String userName, String host, boolean bPortal) {
        String sEnableNSureAuditLog = new SystemConfig().getSetting(LOG_ITEM_LOGOUT, "false");
        if (sEnableNSureAuditLog.equalsIgnoreCase("false")) {
            return;
        }
        if (bPortal) {
            AuditLog.logEvent("Authentication", userName, host, LOGEVENT_PORTAL_LOGOUT);
        } else {
            AuditLog.logEvent("Authentication", userName, host, LOGEVENT_IMANAGER_LOGOUT);
        }
    }

    public static void logModuleInstall(String sModuleTitle, String sPackageName) {
        String sEnableNSureAuditLog = new SystemConfig().getSetting(LOG_ITEM_NPM_INSTALLED, "false");
        if (sEnableNSureAuditLog.equalsIgnoreCase("false")) {
            return;
        }
        AuditLog.logEvent("ModuleInstall", sModuleTitle, sPackageName, LOGEVENT_MODULE_INSTALL);
    }

    public static void logModuleInstallFailed(String sModuleTitle, String sPackageName) {
        String sEnableNSureAuditLog = new SystemConfig().getSetting(LOG_ITEM_NPM_FAILED_INSTALL, "false");
        if (sEnableNSureAuditLog.equalsIgnoreCase("false")) {
            return;
        }
        AuditLog.logEvent("ModuleInstallFailed", sModuleTitle, sPackageName, LOGEVENT_MODULE_INSTALL_FAILED);
    }

    public static void logAuthorizedUserAdded(String userName, String host) {
        String sEnableNSureAuditLog = new SystemConfig().getSetting(LOG_ITEM_AUTHORIZED_USERS, "false");
        if (sEnableNSureAuditLog.equalsIgnoreCase("false")) {
            return;
        }
        AuditLog.logEvent("AuthorizedUserAdded", userName, host, LOGEVENT_AUTHORIZED_USER_ADDED);
    }

    public static void logAuthorizedUserRemoved(String userName, String host) {
        String sEnableNSureAuditLog = new SystemConfig().getSetting(LOG_ITEM_AUTHORIZED_USERS, "false");
        if (sEnableNSureAuditLog.equalsIgnoreCase("false")) {
            return;
        }
        AuditLog.logEvent("AuthorizedUserRemoved", userName, host, LOGEVENT_AUTHORIZED_USER_REMOVED);
    }

    public static void logSystemStartup() {
        String sEnableNSureAuditLog = new SystemConfig().getSetting(LOG_ITEM_SYSTEM_STARTUP, "false");
        if (sEnableNSureAuditLog.equalsIgnoreCase("false")) {
            return;
        }
        AuditLog.logEvent("Servlet", LOGEVENT_SYSTEM_STARTED);
    }

    public static void logSystemShutdown() {
        String sEnableNSureAuditLog = new SystemConfig().getSetting(LOG_ITEM_SYSTEM_SHUTDOWN, "false");
        if (sEnableNSureAuditLog.equalsIgnoreCase("false")) {
            return;
        }
        AuditLog.logEvent("Servlet", LOGEVENT_SYSTEM_SHUTDOWN);
    }

    public static void logFailedSSLConnection(String userName, String host) {
        String sEnableNSureAuditLog = new SystemConfig().getSetting(LOG_ITEM_FAILED_SSL_CONNECTION, "false");
        if (sEnableNSureAuditLog.equalsIgnoreCase("false")) {
            return;
        }
        AuditLog.logEvent("FailedSSLConnection", userName, host, LOGEVENT_FAILED_SSL_CONNECTION);
    }

    public static void logSystemConfigurationChanged(String userName, String host) {
        String sEnableNSureAuditLog = new SystemConfig().getSetting(LOG_ITEM_CHANGED_CONFIGURATION, "false");
        if (sEnableNSureAuditLog.equalsIgnoreCase("false")) {
            return;
        }
        AuditLog.logEvent("SystemConfigurationChanged", userName, host, LOGEVENT_SYSTEM_CONFIGURATION_CHANGED);
    }

    public static LogEvent getLogEvent() {
        long rv = 0L;
        if (m_logEvent != null) {
            String sEnableNSureAuditLog = new SystemConfig().getSetting(ENABLE_NSURE_AUDIT_LOG, "false");
            if (sEnableNSureAuditLog.equalsIgnoreCase("false")) {
                return null;
            }
            return m_logEvent;
        }
        String sEnableNSureAuditLog = new SystemConfig().getSetting(ENABLE_NSURE_AUDIT_LOG, "false");
        if (sEnableNSureAuditLog.equalsIgnoreCase("false")) {
            return null;
        }
        if (!m_bNSureAuditAvailable) {
            return null;
        }
        File certFile = null;
        File keyFile = null;
        String sCertificate = "";
        String sKey = "";
        String osname = System.getProperty("os.name").toLowerCase();
        if (osname.indexOf("linux") != -1) {
            certFile = new File("/etc/imanicert.pem");
            keyFile = new File("/etc/imanipkey.pem");
        } else if (osname.indexOf("windows") != -1) {
            certFile = new File(windowsCertFilePath);
            keyFile = new File(windowsKeyFilePath);
        } else if (osname.indexOf("netware") != -1) {
            certFile = new File(netwareCertFilePath);
            keyFile = new File(netwareKeyFilePath);
        } else if (osname.indexOf("solaris") != -1) {
            certFile = new File("/etc/imanicert.pem");
            keyFile = new File("/etc/imanipkey.pem");
        }
        if (certFile != null && keyFile != null && certFile.exists() && keyFile.exists()) {
            sCertificate = AuditLog.getContentFromPemFile(certFile);
            sKey = AuditLog.getContentFromPemFile(keyFile);
        }
        if (sCertificate.equals("") || sKey.equals("")) {
            sCertificate = "-----BEGIN CERTIFICATE-----\r\nMIIBljCCAUCgAwIBAgIBFTANBgkqhkiG9w0BAQQFADAqMQswCQYDVQQGEwJVUzEb\r\nMBkGA1UEAxMSTm92ZWxsIE5TdXJlIEF1ZGl0MB4XDTA0MDIxOTE2NDIyMVoXDTE0\r\nMDIxNjE2NDIyMVowIDELMAkGA1UEBhMCVVMxETAPBgNVBAMTCGlNYW5hZ2VyMFww\r\nDQYJKoZIhvcNAQEBBQADSwAwSAJBAL1GR2LPkItu+uNmeVlv2xfwkbNOGYshn65+\r\nlsxnqG0vaEun2DRcxdvc1+53gpWwc5vaIPm5DoQi+ITZeQsNz/8CAwEAAaNbMFkw\r\nDgYDVR0PAQH/BAQDAgWgMBgGA1UdEQQRMA+BDWFyZ2xAYmxhaC5jb20wEQYJYIZI\r\nAYb4QgEBBAQDAgWgMBoGDGCGSAGG+DcBglsKAQQKFghpTWFuYWdlcjANBgkqhkiG\r\n9w0BAQQFAANBAKlCZssE5BDfgHqjBnNGss8p3LFiXxTcK6vShHi76xeFT96tsGyV\r\nMj1uTWVnsKpdAyZie5rd/uq+BPe+9N9WK9w=\r\n-----END CERTIFICATE-----\r\n";
            sKey = "-----BEGIN RSA PRIVATE KEY-----\r\nMIIBOwIBAAJBAL1GR2LPkItu+uNmeVlv2xfwkbNOGYshn65+lsxnqG0vaEun2DRc\r\nxdvc1+53gpWwc5vaIPm5DoQi+ITZeQsNz/8CAwEAAQJANNZEoVHeQP5XLVny8EOo\r\nftNaaRqZSNy3Degqwp8BRpElfyRVr7RLI3YBiVS0OGZaGDAulQio3dTX/DfgYvoY\r\nkQIhANxaUXAixURRMvag1GPxCLxVzpqkHr408keYcMoBjpnnAiEA2+Ti3p2wX6Pr\r\nMu7fuq0uy+CpojgdytaW6WlzjDmORikCIQDH9spqmZMswQcfmqnDHEwSJUg9O2yO\r\nrZuj7ymDl9AhxwIhAIZclFesiPHXqkaD+YcKfTasf1qU6XdgqfPTsHv1Sz8JAiAd\r\najVZD8Qq5I4KVjsc7f8/tRsRzXskTStZQtkcCLsZLA==\r\n-----END RSA PRIVATE KEY-----\r\n";
        }
        try {
            m_logEvent = new LogEvent();
            rv = m_logEvent.LogOpen(sCertificate, sKey, 0L);
        }
        catch (Throwable t) {
            if (D.isDebugEnabled(1)) {
                D.log("NSure Audit is not available.", 1);
                D.log(t);
            }
            m_bNSureAuditAvailable = false;
            return null;
        }
        if (rv > 0L) {
            if (D.isDebugEnabled(1)) {
                D.log("NSure Audit is not available.", 1);
            }
            m_bNSureAuditAvailable = false;
            return null;
        }
        m_bNSureAuditAvailable = true;
        return m_logEvent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getContentFromPemFile(File pemFile) {
        StringBuffer contents = new StringBuffer();
        BufferedReader input = null;
        try {
            input = new BufferedReader(new FileReader(pemFile));
            String line = null;
            while ((line = input.readLine()) != null) {
                contents.append(line);
                contents.append(System.getProperty("line.separator"));
            }
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        finally {
            try {
                if (input != null) {
                    input.close();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        return contents.toString();
    }
}

