/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.fw;

import com.novell.admin.common.exceptions.SPIException;
import com.novell.admin.ns.AdminNamespace;
import com.novell.admin.ns.AttributeDefinition;
import com.novell.admin.ns.ComponentCreationException;
import com.novell.admin.ns.NSObject;
import com.novell.admin.ns.NamespaceException;
import com.novell.admin.ns.ObjectAttribute;
import com.novell.admin.ns.SchemaUtil;
import com.novell.admin.ns.Syntax;
import com.novell.admin.ns.ValueComponent;
import com.novell.application.console.snapin.ObjectEntry;
import com.novell.application.console.snapin.SnapinVetoException;
import com.novell.emframe.dev.Task;
import com.novell.emframe.dev.TaskContext;
import com.novell.emframe.dev.eMFrameUtils;
import com.novell.emframe.fw.FwUtils;
import com.novell.emframe.fw.RBSUtil;
import com.novell.emframe.fw.RoleData;
import com.novell.rbs.RBSCategory;
import com.novell.rbs.RBSCollection;
import com.novell.rbs.RBSRole;
import java.util.ArrayList;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;

public final class CreateCategoryTask
extends Task {
    private static final long serialVersionUID = 1L;
    private static final String HTMLPARAM_CATEGORY_NAME = "CategoryName";
    private static final String HTMLPARAM_COLLECTION_FDN = "CategoryCollectionFDN";
    private static final String HTMLPARAM_DESCRIPTION = "CategoryDescription";
    private static final String STATE_START_CATEGORY_WIZARD = "startCategoryWizard";
    private static final String STATE_NEXT_ROLE_SELECTION = "nextRoleSelection";
    private static final String STATE_BACK_ROLE_SELECTION = "backRoleSelection";
    private static final String STATE_NEXT_SUMMARY = "nextSummary";
    private static final String STATE_BACK_SUMMARY = "backSummary";
    private static final String STATE_FINISH_CATEGORY_WIZARD = "finishCategoryWizard";
    private TaskContext m_context;
    private HttpServletRequest m_req;
    private Properties m_resultStrings;
    private String m_categoryName;
    private String m_collectionFDN;
    private String m_description;
    private ObjectEntry m_treeOE;
    private AdminNamespace m_ns;
    private boolean rolesRead = false;
    private ArrayList m_availableRoleList = new ArrayList();
    private ArrayList m_assignedRoleList = new ArrayList();
    private ObjectEntry m_collectionOE;

    public boolean execute(TaskContext context, Properties resultStrings) {
        this.m_context = context;
        this.m_resultStrings = resultStrings;
        this.m_req = context.getRequest();
        this.m_treeOE = RBSUtil.getTreeOE(this.m_context);
        this.m_ns = this.m_treeOE.getAdminNamespace();
        String nextState = this.m_req.getParameter("nextState");
        if (nextState == null || nextState.equalsIgnoreCase(STATE_START_CATEGORY_WIZARD)) {
            return this.startCategoryWizard();
        }
        if (nextState.equalsIgnoreCase(STATE_NEXT_ROLE_SELECTION)) {
            return this.nextRoleSelection();
        }
        if (nextState.equalsIgnoreCase(STATE_BACK_ROLE_SELECTION)) {
            return this.backRoleSelection();
        }
        if (nextState.equalsIgnoreCase(STATE_NEXT_SUMMARY)) {
            return this.nextSummary();
        }
        if (nextState.equalsIgnoreCase(STATE_BACK_SUMMARY)) {
            return this.backSummary();
        }
        if (nextState.equalsIgnoreCase(STATE_FINISH_CATEGORY_WIZARD)) {
            return this.finishCategoryWizard();
        }
        return true;
    }

    private boolean startCategoryWizard() {
        this.m_categoryName = "";
        this.m_collectionFDN = this.m_req.getParameter("selectedCollectionName");
        String[] strings = eMFrameUtils.unpack(this.m_collectionFDN, this.m_context);
        this.m_collectionFDN = strings[0];
        this.m_description = "";
        this.m_req.setAttribute(HTMLPARAM_CATEGORY_NAME, (Object)this.m_categoryName);
        this.m_req.setAttribute(HTMLPARAM_COLLECTION_FDN, (Object)this.m_collectionFDN);
        this.m_req.setAttribute(HTMLPARAM_DESCRIPTION, (Object)this.m_description);
        return true;
    }

    private boolean nextRoleSelection() {
        this.m_categoryName = this.m_req.getParameter(HTMLPARAM_CATEGORY_NAME);
        boolean isLDAP = this.m_ns.getUniqueID().equalsIgnoreCase("LDAP");
        if (isLDAP) {
            this.m_categoryName = RBSUtil.formatLDAPString(this.m_categoryName);
        }
        this.m_description = this.m_req.getParameter(HTMLPARAM_DESCRIPTION);
        if (!this.rolesRead) {
            RBSRole[] rbsRole = null;
            try {
                this.m_collectionOE = this.m_ns.getObjectEntry(this.m_treeOE, this.m_collectionFDN);
                RBSCollection rbsCollection = new RBSCollection(this.m_collectionOE);
                rbsRole = rbsCollection.getSpecifiedRoles(new String[]{"iManager"});
                this.rolesRead = true;
            }
            catch (Exception exc) {
                eMFrameUtils.setErrorMessage(exc, this.m_context);
                return false;
            }
            if (rbsRole != null) {
                for (int i = 0; i < rbsRole.length; ++i) {
                    ObjectEntry roleOE = rbsRole[i].getObjectEntry();
                    String roleName = RBSUtil.getLocalizedDisplayName(this.m_context, rbsRole[i].getObjectEntry());
                    String roleFDN = this.m_ns.getUnrootedName(roleOE);
                    String roleDesc = null;
                    try {
                        roleDesc = rbsRole[i].getDescription();
                        if (roleDesc == null) {
                            roleDesc = eMFrameUtils.getLocalizedString("FwResources", "eMFrameConsts.NO_DESCRIPTION", this.m_context.getLocale());
                        }
                    }
                    catch (Exception exc) {
                        roleDesc = "";
                    }
                    RoleData roleData = new RoleData(roleFDN, roleName, "", "", "", roleDesc, "", "", "");
                    this.m_availableRoleList.add(roleData);
                }
            }
        }
        this.m_req.setAttribute(HTMLPARAM_CATEGORY_NAME, (Object)this.m_categoryName);
        this.putAvailableRoles();
        this.putAssignedRoles();
        return true;
    }

    private boolean backRoleSelection() {
        this.getAssignedRoles();
        this.getAvailableRoles();
        this.m_req.setAttribute(HTMLPARAM_CATEGORY_NAME, (Object)this.m_categoryName);
        this.m_req.setAttribute(HTMLPARAM_COLLECTION_FDN, (Object)this.m_collectionFDN);
        this.m_req.setAttribute(HTMLPARAM_DESCRIPTION, (Object)this.m_description);
        return true;
    }

    private boolean nextSummary() {
        this.getAvailableRoles();
        this.getAssignedRoles();
        this.m_req.setAttribute(HTMLPARAM_CATEGORY_NAME, (Object)this.m_categoryName);
        this.putAvailableRoles();
        this.putAssignedRoles();
        return true;
    }

    private boolean backSummary() {
        this.m_req.setAttribute(HTMLPARAM_CATEGORY_NAME, (Object)this.m_categoryName);
        this.putAvailableRoles();
        this.putAssignedRoles();
        return true;
    }

    private boolean finishCategoryWizard() {
        this.m_resultStrings.put("TaskAfterGenConf", "fw.HomePage");
        this.m_resultStrings.put("MergeAfterGenConf", "fw.HomePage");
        try {
            NSObject categoryNSObj = this.createRBSCategory();
            RBSCategory rbsCategory = new RBSCategory(categoryNSObj);
            if (this.m_description != null && this.m_description.length() > 0) {
                rbsCategory.setDescription(this.m_description);
            }
            if (this.m_assignedRoleList.size() > 0) {
                ObjectEntry[] roleOE = new ObjectEntry[this.m_assignedRoleList.size()];
                for (int i = 0; i < this.m_assignedRoleList.size(); ++i) {
                    RoleData roleData = (RoleData)this.m_assignedRoleList.get(i);
                    roleOE[i] = this.m_ns.getObjectEntry(this.m_treeOE, roleData.getObjectFDN());
                }
                rbsCategory.setRoleMembers(roleOE);
                rbsCategory.update();
                FwUtils.refreshCRTCategories(this.m_context);
            }
        }
        catch (Exception exc) {
            eMFrameUtils.setErrorMessage(exc, this.m_context);
            return false;
        }
        this.m_resultStrings.put("GeneralMsg.MsgTitle", eMFrameUtils.getLocalizedString("FwResources", "CreateCategory.SuccessTitle", this.m_context.getLocale()));
        this.m_resultStrings.put("GeneralMsg.MsgBody", eMFrameUtils.getLocalizedString("FwResources", "CreateCategory.Success", this.m_context.getLocale()));
        return true;
    }

    private NSObject createRBSCategory() throws SPIException, SnapinVetoException, ComponentCreationException, NamespaceException {
        NSObject categoryObj = null;
        ObjectEntry categoryOE = null;
        ValueComponent[] vals = new ValueComponent[1];
        ValueComponent[] nameVal = new ValueComponent[1];
        AttributeDefinition objClassAttrDef = this.m_ns.getAttributeDefinition(this.m_collectionOE, SchemaUtil.translateNDAPAttr((ObjectEntry)this.m_collectionOE, (String)"Object Class"));
        Syntax objClassSyn = objClassAttrDef.getSyntax();
        vals[0] = objClassSyn.createValueComponent((Object)"rbsCategory2");
        ObjectAttribute attrObj = new ObjectAttribute(objClassAttrDef, vals);
        AttributeDefinition cnAttrDef = this.m_ns.getAttributeDefinition(this.m_collectionOE, SchemaUtil.translateNDAPAttr((ObjectEntry)this.m_collectionOE, (String)"CN"));
        Syntax cnSyn = cnAttrDef.getSyntax();
        nameVal[0] = cnSyn.createValueComponent((Object)this.m_categoryName);
        ObjectAttribute objNameAttr = new ObjectAttribute(cnAttrDef, nameVal);
        Vector<ObjectAttribute> attrOV = new Vector<ObjectAttribute>();
        attrOV.addElement(attrObj);
        attrOV.addElement(objNameAttr);
        categoryOE = this.m_ns.createObjectEntry(this.m_collectionOE, this.m_categoryName, "rbsCategory2");
        categoryObj = this.m_ns.createNSObject(categoryOE, attrOV);
        this.m_ns.create(categoryObj);
        return categoryObj;
    }

    private void putAvailableRoles() {
        this.m_resultStrings.put("AvailableRole.Count", Integer.toString(this.m_availableRoleList.size()));
        for (int i = 0; i < this.m_availableRoleList.size(); ++i) {
            RoleData roleData = (RoleData)this.m_availableRoleList.get(i);
            this.m_resultStrings.put("AvailableRoles." + i + ".ShortName", roleData.getDisplayName());
            this.m_resultStrings.put("AvailableRoles." + i + ".FullName", roleData.getObjectFDN());
            this.m_resultStrings.put("AvailableRoles." + i + ".Description", roleData.getRoleDesc());
        }
    }

    private void putAssignedRoles() {
        this.m_resultStrings.put("AssignedRole.Count", Integer.toString(this.m_assignedRoleList.size()));
        for (int i = 0; i < this.m_assignedRoleList.size(); ++i) {
            RoleData roleData = (RoleData)this.m_assignedRoleList.get(i);
            this.m_resultStrings.put("AssignedRoles." + i + ".ShortName", roleData.getDisplayName());
            this.m_resultStrings.put("AssignedRoles." + i + ".FullName", roleData.getObjectFDN());
            this.m_resultStrings.put("AssignedRoles." + i + ".Description", roleData.getRoleDesc());
        }
    }

    private void getAvailableRoles() {
        this.m_availableRoleList.clear();
        String availableRoleFullName = this.m_req.getParameter("AvailableRoleFullName");
        String availableRoleShortName = this.m_req.getParameter("AvailableRoleShortName");
        String availableRoleDescription = this.m_req.getParameter("AvailableRoleDescription");
        StringTokenizer fullNameTokenizer = new StringTokenizer(availableRoleFullName, ";");
        StringTokenizer shortNameTokenizer = new StringTokenizer(availableRoleShortName, ";");
        StringTokenizer descriptionTokenizer = new StringTokenizer(availableRoleDescription, ";");
        if (fullNameTokenizer.countTokens() == shortNameTokenizer.countTokens() && fullNameTokenizer.countTokens() == descriptionTokenizer.countTokens() && shortNameTokenizer.countTokens() == descriptionTokenizer.countTokens() && shortNameTokenizer.countTokens() > 0) {
            while (shortNameTokenizer.hasMoreTokens()) {
                RoleData roleData = new RoleData();
                roleData.setDisplayName(eMFrameUtils.urlDecode(shortNameTokenizer.nextToken(), this.m_req.getCharacterEncoding()));
                roleData.setObjectFDN(eMFrameUtils.urlDecode(fullNameTokenizer.nextToken(), this.m_req.getCharacterEncoding()));
                roleData.setRoleDesc(eMFrameUtils.urlDecode(descriptionTokenizer.nextToken(), this.m_req.getCharacterEncoding()));
                this.m_availableRoleList.add(roleData);
            }
        }
    }

    private void getAssignedRoles() {
        this.m_assignedRoleList.clear();
        String assignedRoleFullName = this.m_req.getParameter("AssignedRoleFullName");
        String assignedRoleShortName = this.m_req.getParameter("AssignedRoleShortName");
        String assignedRoleDescription = this.m_req.getParameter("AssignedRoleDescription");
        StringTokenizer fullNameTokenizer = new StringTokenizer(assignedRoleFullName, ";");
        StringTokenizer shortNameTokenizer = new StringTokenizer(assignedRoleShortName, ";");
        StringTokenizer descriptionTokenizer = new StringTokenizer(assignedRoleDescription, ";");
        if (fullNameTokenizer.countTokens() == shortNameTokenizer.countTokens() && fullNameTokenizer.countTokens() == descriptionTokenizer.countTokens() && shortNameTokenizer.countTokens() == descriptionTokenizer.countTokens() && shortNameTokenizer.countTokens() > 0) {
            while (shortNameTokenizer.hasMoreTokens()) {
                RoleData roleData = new RoleData();
                roleData.setDisplayName(eMFrameUtils.urlDecode(shortNameTokenizer.nextToken(), this.m_req.getCharacterEncoding()));
                roleData.setObjectFDN(eMFrameUtils.urlDecode(fullNameTokenizer.nextToken(), this.m_req.getCharacterEncoding()));
                roleData.setRoleDesc(eMFrameUtils.urlDecode(descriptionTokenizer.nextToken(), this.m_req.getCharacterEncoding()));
                this.m_assignedRoleList.add(roleData);
            }
        }
    }
}

