/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.fw;

import com.novell.emframe.dev.AuthBrokerAuthenticator;
import com.novell.emframe.dev.AuthBrokerException;
import com.novell.emframe.dev.AuthenticationBroker;
import com.novell.emframe.dev.D;
import com.novell.emframe.dev.ManagementServiceSet;
import java.lang.reflect.Method;

public final class ECBAuthenticator
extends AuthBrokerAuthenticator {
    private static final String ECB_AuthClassname = "com.novell.ecb.ldap.AuthenticateLdap";
    private static final String ECB_UnauthClassname = "com.novell.ecb.ldap.UnauthenticateLdap";
    private static final String ECB_LdapConnClassname = "com.novell.ecb.ldap.LdapConnection";
    private static final String DEF_CLEARPORT = ":389";
    private static final String DEF_SSLPORT = ":636";
    private static Class authClassObject;
    private static Method authSetDNMethod;
    private static Method authSetPasswordMethod;
    private static Method authSetURLMethod;
    private static Method authSetProtocol;
    private static Method authExecuteMethod;
    private static Method authGetConnectionMethod;
    private static Class unauthClassObject;
    private static Method unauthSetLdapConnectionMethod;
    private static Method unauthExecuteMethod;

    public static boolean init() throws AuthBrokerException {
        try {
            authClassObject = Class.forName(ECB_AuthClassname);
            unauthClassObject = Class.forName(ECB_UnauthClassname);
            Class<?> stringClass = Class.forName("java.lang.String");
            authSetDNMethod = authClassObject.getMethod("setDN", stringClass);
            authSetPasswordMethod = authClassObject.getMethod("setPassword", stringClass);
            authSetURLMethod = authClassObject.getMethod("setURL", stringClass);
            authSetProtocol = authClassObject.getMethod("setProtocol", stringClass);
            authExecuteMethod = authClassObject.getMethod("execute", new Class[0]);
            authGetConnectionMethod = authClassObject.getMethod("getConnection", new Class[0]);
            Class<?> lcClass = Class.forName(ECB_LdapConnClassname);
            unauthSetLdapConnectionMethod = unauthClassObject.getMethod("setLdapConnection", lcClass);
            unauthExecuteMethod = unauthClassObject.getMethod("execute", new Class[0]);
        }
        catch (Throwable te) {
            D.log(te);
            throw new AuthBrokerException("Could not initialize to eCommerce Beans - " + te.getLocalizedMessage());
        }
        return true;
    }

    public static void destroy() {
    }

    public Object login(String ldapName, String password, String ldapAccessDomain, ManagementServiceSet manageSS) throws AuthBrokerException {
        try {
            AuthenticationBroker broker = manageSS.getAuthenticationBroker();
            boolean ssl = broker.getAuthUseLdapSSL();
            String portedAccessDomain = ldapAccessDomain.indexOf(58) >= 0 ? "ldap://" + ldapAccessDomain : "ldap://" + ldapAccessDomain + (ssl ? DEF_SSLPORT : DEF_CLEARPORT);
            Object authClassInst = authClassObject.newInstance();
            authSetDNMethod.invoke(authClassInst, ldapName);
            authSetPasswordMethod.invoke(authClassInst, password);
            authSetURLMethod.invoke(authClassInst, portedAccessDomain);
            if (ssl) {
                authSetProtocol.invoke(authClassInst, "ssl");
            }
            authExecuteMethod.invoke(authClassInst, new Object[0]);
            Object ECBAPIObject = authGetConnectionMethod.invoke(authClassInst, new Object[0]);
            return ECBAPIObject;
        }
        catch (Throwable te) {
            D.log(te);
            throw new AuthBrokerException("Could not login to eCommerce Beans - " + te.getLocalizedMessage());
        }
    }

    public void logout(Object inApiObject) {
        try {
            Object unauthClassInst = unauthClassObject.newInstance();
            unauthSetLdapConnectionMethod.invoke(unauthClassInst, inApiObject);
            unauthExecuteMethod.invoke(unauthClassInst, new Object[0]);
        }
        catch (Throwable te) {
            D.log("Failed logout of eCommerce Beans" + te.getLocalizedMessage());
            D.log(te);
        }
    }
}

