/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.fw;

import com.novell.emframe.dev.D;
import com.novell.emframe.dev.HistoryNode;
import com.novell.emframe.dev.Task;
import com.novell.emframe.dev.TaskContext;
import com.novell.emframe.fw.FwTaskContext;
import java.util.ArrayList;
import java.util.Properties;

public class HistoryResultsTask
extends Task {
    private static final long serialVersionUID = 1L;

    public boolean execute(TaskContext context, Properties resultStrings) {
        String nextState = context.getRequest().getParameter("nextState");
        if (nextState != null && nextState.equals("clear")) {
            context.clearHistory();
            return true;
        }
        try {
            String typeFilter = context.getRequest().getParameter("typeFilter");
            ArrayList types = HistoryResultsTask.splitTypeFilter(typeFilter);
            HistoryNode[] historyResults = ((FwTaskContext)((Object)context)).getObjectNameHistory().getHistory(types.toArray(new String[types.size()]));
            resultStrings.put("Results.Count", String.valueOf(historyResults.length));
            for (int i = 0; i < historyResults.length; ++i) {
                resultStrings.put("Results." + i + ".name", historyResults[i].getObjectName());
                resultStrings.put("Results." + i + ".type", context.getDirUtils().getObjectTypeImageName(historyResults[i].getObjectType()));
            }
            return true;
        }
        catch (Exception e) {
            D.log(e);
            return true;
        }
    }

    public static ArrayList splitTypeFilter(String s) {
        ArrayList a = new ArrayList();
        if (s == null) {
            return a;
        }
        StringBuffer val = new StringBuffer("");
        for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            if (ch != ',') {
                val.append(ch);
                continue;
            }
            if (i + 1 < s.length() && s.charAt(i + 1) == ',') {
                val.append(',');
                ++i;
                continue;
            }
            HistoryResultsTask.addToArrayList(a, val.toString());
            val.setLength(0);
        }
        HistoryResultsTask.addToArrayList(a, val.toString());
        return a;
    }

    public static void addToArrayList(ArrayList a, String s) {
        if (s != null) {
            s = s.trim();
            a.add(s);
        }
    }
}

