/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.fw;

import com.novell.admin.common.exceptions.UniqueSPIException;
import com.novell.admin.ns.AdminNamespace;
import com.novell.application.console.snapin.ObjectEntry;
import com.novell.emframe.dev.D;
import com.novell.emframe.dev.PluginContext;
import com.novell.emframe.dev.Task;
import com.novell.emframe.dev.TaskContext;
import com.novell.emframe.dev.eMFrameUtils;
import com.novell.emframe.fw.FwUtils;
import com.novell.emframe.fw.InstallXMLInfo;
import com.novell.emframe.fw.RBSUtil;
import com.novell.emframe.fw.util.iManagerJDOMFactory;
import com.novell.nps.utils.Utils;
import com.novell.rbs.RBSModule;
import com.novell.rbs.RBSObject;
import com.novell.rbs.RBSRole;
import com.novell.rbs.RBSScope;
import com.novell.rbs.RBSTask;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.JDOMFactory;
import org.jdom.input.SAXBuilder;

public class InstalledModules
extends Task {
    private static final long serialVersionUID = 1L;
    public static final String CN = "cn=";
    private TaskContext m_context;
    private Properties m_resultStrings;
    private AdminNamespace m_ns;
    private ObjectEntry m_treeOE;
    private HttpServletRequest m_req;
    private InstallXMLInfo[] m_unInstallInfo;
    private ArrayList m_errors = new ArrayList();
    private InstallThread installThread;
    private boolean m_stopThread;
    private boolean m_threadDone;
    private String m_mainProgressMessage = "";
    private String m_alreadyMessage = "";
    private String m_abortMessage = "";
    private boolean m_err = false;
    private String m_collectionName;
    private int m_modulesNotInstalled = 0;
    private int m_totalModulesCount = 0;
    private int m_installingCount = 0;
    private boolean m_isLDAP = false;

    public boolean execute(TaskContext context, Properties resultStrings) {
        this.m_context = context;
        this.m_resultStrings = resultStrings;
        this.m_treeOE = RBSUtil.getTreeOE(this.m_context);
        this.m_req = this.m_context.getRequest();
        this.m_ns = this.m_treeOE.getAdminNamespace();
        this.m_isLDAP = this.m_treeOE.getAdminNamespace().getUniqueID().equalsIgnoreCase("LDAP");
        String nextState = this.m_req.getParameter("nextState");
        if (nextState == null || nextState.equals("initialState")) {
            return this.initialState();
        }
        if (nextState.equalsIgnoreCase("refresh")) {
            return this.refresh();
        }
        if (nextState.equalsIgnoreCase("cancel")) {
            return this.cancel();
        }
        if (nextState.equalsIgnoreCase("finished")) {
            return this.finished();
        }
        return true;
    }

    public boolean initialState() {
        InstallXMLInfo[] installXMLInfo;
        this.m_collectionName = this.m_req.getParameter("selectedCollectionNameModule");
        String[] collections = eMFrameUtils.unpack(this.m_collectionName, this.m_context);
        this.m_collectionName = collections[0];
        String moduleListPacked = this.m_req.getParameter("ModuleListPacked");
        String[] moduleList = eMFrameUtils.unpack(moduleListPacked, this.m_context);
        if (moduleList.length > 0 && (installXMLInfo = (InstallXMLInfo[])this.m_context.getAuthAttribute("InstallXMLInfo")) != null) {
            this.m_unInstallInfo = new InstallXMLInfo[moduleList.length];
            int count = 0;
            for (int i = 0; i < installXMLInfo.length; ++i) {
                for (int index = 0; index < moduleList.length; ++index) {
                    String moduleName = moduleList[index];
                    if (!moduleName.equalsIgnoreCase(installXMLInfo[i].getModuleName())) continue;
                    this.m_unInstallInfo[index] = installXMLInfo[i];
                    ++count;
                    break;
                }
                if (count == moduleList.length) break;
            }
        }
        if (this.m_unInstallInfo != null) {
            this.m_mainProgressMessage = eMFrameUtils.getLocalizedString("FwResources", "RBS.UninstallingModules", this.m_context.getLocale());
            this.m_abortMessage = eMFrameUtils.getLocalizedString("FwResources", "RBS.AbortStop", this.m_context.getLocale());
            this.m_totalModulesCount = this.m_unInstallInfo.length;
            this.m_alreadyMessage = eMFrameUtils.getLocalizedString("FwResources", "RBS.Initializing", this.m_context.getLocale());
            String url = new String("webacc?taskId=" + eMFrameUtils.urlEncode(this.m_req.getParameter("taskId"), this.m_context) + "&merge=fw.GenericProgress&User.context=" + this.m_req.getParameter("User.context") + "&nextState=refresh" + "&progressCount=" + "" + "&mainProgressMessage=" + this.m_mainProgressMessage + "&alreadyMessage=" + this.m_alreadyMessage + "&abortMessage=" + this.m_abortMessage);
            this.m_resultStrings.put("UrlTask.url", url);
            Utils.setMergeTemplate((PluginContext)this.m_context, (String)"fw.UrlTask");
            this.m_stopThread = false;
            this.m_threadDone = false;
            this.installThread = new InstallThread();
            this.installThread.start();
        }
        return true;
    }

    private boolean refresh() {
        String taskId = this.m_req.getParameter("taskId");
        String userContext = this.m_req.getParameter("User.context");
        if (!this.m_threadDone) {
            this.m_resultStrings.put("progressCount", "");
            if (this.m_installingCount == 0) {
                this.m_alreadyMessage = eMFrameUtils.getLocalizedString("FwResources", "RBS.Initializing", this.m_context.getLocale());
            } else {
                Object[] values = new String[]{Integer.toString(this.m_installingCount), Integer.toString(this.m_totalModulesCount)};
                this.m_alreadyMessage = eMFrameUtils.formatMessage(eMFrameUtils.getLocalizedString("FwResources", "RBS.UninstallingModuleNumber", this.m_context.getLocale()), values);
            }
            this.m_resultStrings.put("mainProgressMessage", this.m_mainProgressMessage);
            this.m_resultStrings.put("alreadyMessage", this.m_alreadyMessage);
            this.m_resultStrings.put("abortMessage", this.m_abortMessage);
        } else {
            String url = new String("webacc?taskId=" + eMFrameUtils.urlEncode(taskId, this.m_context) + "&User.context=" + userContext + "&nextState=finished");
            url = this.m_err ? url + "&merge=dev.MooGenErr&GeneralMsg.Mode=error" : url + "&merge=dev.GenMsg&GeneralMsg.Mode=success&dev.refreshOV=true";
            this.m_resultStrings.put("UrlTask.url", url);
            Utils.setMergeTemplate((PluginContext)this.m_context, (String)"fw.UrlTask");
        }
        return true;
    }

    private boolean cancel() {
        this.m_stopThread = true;
        String strTitle = eMFrameUtils.getLocalizedString("FwResources", "RBS.UninstallModuleRequestAborted", this.m_context.getLocale());
        String strBody = "\n" + eMFrameUtils.getLocalizedString("FwResources", "RBS.NumberModulesUninstalled", this.m_context.getLocale()) + "\n";
        Object[] values = new String[]{Integer.toString(this.m_installingCount), Integer.toString(this.m_totalModulesCount)};
        eMFrameUtils.setMessage("success", strTitle, eMFrameUtils.formatMessage(strBody, values), this.m_context);
        return true;
    }

    private boolean finished() {
        if (this.m_err) {
            String strTitle = eMFrameUtils.getLocalizedString("FwResources", "RBS.UninstallModuleRequestError", this.m_context.getLocale());
            String strBody = "\n" + eMFrameUtils.getLocalizedString("FwResources", "RBS.NumberModulesUninstalled", this.m_context.getLocale()) + "\n" + eMFrameUtils.getLocalizedString("FwResources", "RBS.ModulesNotUninstalled", this.m_context.getLocale());
            Object[] values = new String[]{Integer.toString(this.m_totalModulesCount - this.m_modulesNotInstalled), Integer.toString(this.m_totalModulesCount)};
            eMFrameUtils.setMooErrorMessage(this.m_resultStrings, strTitle, eMFrameUtils.formatMessage(strBody, values), this.m_errors);
        } else {
            String strTitle = eMFrameUtils.getLocalizedString("FwResources", "RBS.UninstallModuleRequestSucceeded", this.m_context.getLocale());
            String strBody = "\n" + eMFrameUtils.getLocalizedString("FwResources", "RBS.NumberModulesUninstalled", this.m_context.getLocale()) + "\n";
            Object[] values = new String[]{Integer.toString(this.m_installingCount), Integer.toString(this.m_totalModulesCount)};
            eMFrameUtils.setMessage("success", strTitle, eMFrameUtils.formatMessage(strBody, values), this.m_context);
        }
        return true;
    }

    private void doUninstall() {
        int i;
        this.m_errors.clear();
        ArrayList<InstalledModuleInfo> moduleArrayList = new ArrayList<InstalledModuleInfo>();
        if (this.m_unInstallInfo != null) {
            for (int index = 0; index < this.m_unInstallInfo.length; ++index) {
                Document doc;
                Vector<String> modulesV = new Vector<String>();
                Vector<String> rolesV = new Vector<String>();
                String[] xmlFiles = this.m_unInstallInfo[index].getFilePaths();
                if (xmlFiles != null) {
                    boolean errFlag = false;
                    for (int count = 0; count < xmlFiles.length; ++count) {
                        List roleChildren;
                        if (xmlFiles[count].toLowerCase().endsWith("category.xml")) continue;
                        SAXBuilder saxBuilder = new SAXBuilder(false);
                        saxBuilder.setFactory((JDOMFactory)iManagerJDOMFactory.getInstance());
                        File theFile = new File(xmlFiles[count]);
                        Document jdomDocumemt = null;
                        try {
                            jdomDocumemt = saxBuilder.build(theFile);
                        }
                        catch (Exception exc) {
                            if (!errFlag) {
                                ++this.m_modulesNotInstalled;
                                errFlag = true;
                                this.m_err = true;
                            }
                            D.log(exc);
                            this.m_errors.add(new String[]{this.m_unInstallInfo[index].getModuleName(), eMFrameUtils.getLocalizedString("FwResources", "RBS.UinstallModuleRequestFailed", this.m_context.getLocale()), eMFrameUtils.getExceptionMessage(exc, this.m_context), ""});
                            continue;
                        }
                        Element rootElement = jdomDocumemt.getRootElement();
                        Element moduleElement = rootElement.getChild("module");
                        if (moduleElement != null) {
                            modulesV.add(moduleElement.getChild("id").getTextTrim());
                        }
                        if ((roleChildren = rootElement.getChildren("role")) == null) continue;
                        for (i = 0; i < roleChildren.size(); ++i) {
                            Element currentElement = (Element)roleChildren.get(i);
                            if (currentElement.getChildren().isEmpty() || currentElement.getChild("non-ds") != null) continue;
                            rolesV.add(currentElement.getChild("id").getTextTrim());
                        }
                    }
                }
                if ((doc = this.m_unInstallInfo[index].getDocument()) != null) {
                    List roleChildren;
                    Element rootElement = doc.getRootElement();
                    Element moduleElement = rootElement.getChild("module");
                    if (moduleElement != null) {
                        modulesV.add(moduleElement.getChild("id").getTextTrim());
                    }
                    if ((roleChildren = rootElement.getChildren("role")) != null) {
                        for (int i2 = 0; i2 < roleChildren.size(); ++i2) {
                            Element currentElement = (Element)roleChildren.get(i2);
                            if (currentElement.getChildren().isEmpty() || currentElement.getChild("non-ds") != null) continue;
                            rolesV.add(currentElement.getChild("id").getTextTrim());
                        }
                    }
                }
                Object[] roles = null;
                if (rolesV.size() > 0) {
                    roles = new String[rolesV.size()];
                    rolesV.copyInto(roles);
                }
                Object[] modules = null;
                if (modulesV.size() > 0) {
                    modules = new String[modulesV.size()];
                    modulesV.copyInto(modules);
                }
                InstalledModuleInfo installedModuleInfo = new InstalledModuleInfo((String[])roles, (String[])modules);
                moduleArrayList.add(installedModuleInfo);
            }
        }
        String dynamicGroupSearchType = FwUtils.getDynamicSearchType(this.m_context);
        int index = -1;
        while (++index < moduleArrayList.size() && !this.m_stopThread) {
            int count;
            this.m_installingCount = index + 1;
            InstalledModuleInfo installedModuleInfo = (InstalledModuleInfo)moduleArrayList.get(index);
            String[] roles = installedModuleInfo.getRoles();
            String[] modules = installedModuleInfo.getModules();
            if (roles != null) {
                for (count = 0; count < roles.length; ++count) {
                    ObjectEntry roleOE = null;
                    String roleName = roles[count];
                    if (this.m_isLDAP) {
                        roleName = CN.concat(roleName);
                    }
                    String roleDN = RBSUtil.concatStr(this.m_ns, roleName, this.m_collectionName);
                    try {
                        if (!this.m_ns.doesExist(this.m_treeOE, roleDN)) continue;
                        roleOE = this.m_ns.getObjectEntry(this.m_treeOE, roleDN);
                    }
                    catch (Exception exc) {
                        D.log(exc);
                        this.m_err = true;
                        this.m_errors.add(new String[]{roleDN, eMFrameUtils.getLocalizedString("FwResources", "RBS.InstallModuleRequestFailed", this.m_context.getLocale()), eMFrameUtils.getExceptionMessage(exc, this.m_context), ""});
                        continue;
                    }
                    if (!roleOE.getObjectType().getName().equals("rbsRole2")) continue;
                    RBSRole rbsRole = new RBSRole(roleOE);
                    Vector<Object> contentV = new Vector<Object>();
                    try {
                        Object[] rbsContent = rbsRole.getContent();
                        if (rbsContent != null && modules != null) {
                            for (i = 0; i < rbsContent.length; ++i) {
                                boolean found = false;
                                String moduleName = rbsContent[i].getObjectEntry().getParent().getName();
                                for (int j = 0; j < modules.length; ++j) {
                                    String modName = modules[j];
                                    if (this.m_isLDAP) {
                                        modName = CN.concat(modName);
                                    }
                                    if (!moduleName.equalsIgnoreCase(modName)) continue;
                                    found = true;
                                    break;
                                }
                                if (found) continue;
                                contentV.add(rbsContent[i]);
                            }
                        }
                        if (contentV.size() > 0) {
                            rbsContent = new RBSObject[contentV.size()];
                            contentV.copyInto(rbsContent);
                            rbsRole.setContent((RBSObject[])rbsContent, dynamicGroupSearchType);
                            rbsRole.update();
                        } else {
                            rbsRole.setContent(null, dynamicGroupSearchType);
                            rbsRole.update();
                        }
                    }
                    catch (Exception exc) {
                        // empty catch block
                    }
                    if (contentV.size() != 0) continue;
                    try {
                        rbsRole.setMembers(null, dynamicGroupSearchType);
                        rbsRole.setCategoryMembership(null);
                        rbsRole.update();
                    }
                    catch (Exception exc) {
                        // empty catch block
                    }
                    try {
                        RBSScope[] rbsScope = rbsRole.getAllScopeObjects();
                        if (rbsScope != null) {
                            for (i = 0; i < rbsScope.length; ++i) {
                                this.m_ns.delete(rbsScope[i].getObjectEntry());
                            }
                        }
                    }
                    catch (Exception exc) {
                        // empty catch block
                    }
                    try {
                        this.m_ns.delete(roleOE);
                        continue;
                    }
                    catch (Exception exc) {
                        D.log(exc);
                        this.m_err = true;
                        this.m_errors.add(new String[]{roleDN, eMFrameUtils.getLocalizedString("FwResources", "RBS.InstallModuleRequestFailed", this.m_context.getLocale()), eMFrameUtils.getExceptionMessage(exc, this.m_context), ""});
                    }
                }
            }
            if (modules == null) continue;
            for (count = 0; count < modules.length; ++count) {
                ObjectEntry moduleOE = null;
                String moduleName = modules[count];
                if (this.m_isLDAP) {
                    moduleName = CN.concat(moduleName);
                }
                String moduleDN = RBSUtil.concatStr(this.m_ns, moduleName, this.m_collectionName);
                try {
                    moduleOE = this.m_ns.getObjectEntry(this.m_treeOE, moduleDN);
                }
                catch (Exception exc) {
                    if (exc instanceof UniqueSPIException && ((UniqueSPIException)exc).getErrorCode() == -601) continue;
                    D.log(exc);
                    this.m_err = true;
                    ++this.m_modulesNotInstalled;
                    this.m_errors.add(new String[]{moduleDN, eMFrameUtils.getLocalizedString("FwResources", "RBS.InstallModuleRequestFailed", this.m_context.getLocale()), eMFrameUtils.getExceptionMessage(exc, this.m_context), ""});
                    continue;
                }
                if (moduleOE.getObjectType().getName().equals("rbsModule2")) {
                    RBSObject[] rbsObject = null;
                    RBSModule rbsModule = new RBSModule(moduleOE);
                    try {
                        rbsObject = rbsModule.getTasks();
                    }
                    catch (Exception exc) {
                        D.log(exc);
                        this.m_err = true;
                        ++this.m_modulesNotInstalled;
                        this.m_errors.add(new String[]{moduleDN, eMFrameUtils.getLocalizedString("FwResources", "RBS.InstallModuleRequestFailed", this.m_context.getLocale()), eMFrameUtils.getExceptionMessage(exc, this.m_context), ""});
                        continue;
                    }
                    if (rbsObject != null) {
                        boolean errFlag = false;
                        for (i = 0; i < rbsObject.length; ++i) {
                            try {
                                ((RBSTask)rbsObject[i]).setContentMembership(null, dynamicGroupSearchType);
                                rbsObject[i].update();
                            }
                            catch (Exception exc) {
                                // empty catch block
                            }
                            try {
                                this.m_ns.delete(rbsObject[i].getObjectEntry());
                                continue;
                            }
                            catch (Exception exc) {
                                if (!errFlag) {
                                    ++this.m_modulesNotInstalled;
                                    errFlag = true;
                                    this.m_err = true;
                                }
                                D.log(exc);
                                this.m_errors.add(new String[]{moduleDN, eMFrameUtils.getLocalizedString("FwResources", "RBS.InstallModuleRequestFailed", this.m_context.getLocale()), eMFrameUtils.getExceptionMessage(exc, this.m_context), ""});
                            }
                        }
                    }
                }
                try {
                    this.m_ns.delete(moduleOE);
                    continue;
                }
                catch (Exception exc) {
                    D.log(exc);
                    this.m_err = true;
                    ++this.m_modulesNotInstalled;
                    this.m_errors.add(new String[]{moduleDN, eMFrameUtils.getLocalizedString("FwResources", "RBS.InstallModuleRequestFailed", this.m_context.getLocale()), eMFrameUtils.getExceptionMessage(exc, this.m_context), ""});
                }
            }
        }
    }

    class InstalledModuleInfo {
        private String[] roles;
        private String[] modules;

        public InstalledModuleInfo(String[] roles, String[] modules) {
            this.roles = roles;
            this.modules = modules;
        }

        public String[] getRoles() {
            return this.roles;
        }

        public void setRoles(String[] roles) {
            this.roles = roles;
        }

        public String[] getModules() {
            return this.modules;
        }

        public void setModules(String[] modules) {
            this.modules = modules;
        }
    }

    class InstallThread
    extends Thread {
        public InstallThread() {
            this.setPriority(4);
            this.setDaemon(true);
        }

        public void run() {
            InstalledModules.this.doUninstall();
            InstalledModules.this.m_threadDone = true;
        }
    }
}

