/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.fw;

import com.novell.admin.common.exceptions.SPIException;
import com.novell.admin.common.exceptions.UniqueSPIException;
import com.novell.admin.ns.AdminNamespaceFactory;
import com.novell.admin.ns.ldap.LDAPNamespace;
import com.novell.application.console.snapin.ObjectEntry;
import com.novell.emframe.dev.AuthBrokerAuthenticator;
import com.novell.emframe.dev.AuthBrokerException;
import com.novell.emframe.dev.AuthBrokerReport;
import com.novell.emframe.dev.D;
import com.novell.emframe.dev.ManagementServiceSet;
import com.novell.emframe.dev.eMFrameUtils;
import com.novell.emframe.fw.ldap.JndiLdapUtil;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Properties;
import javax.naming.ldap.InitialLdapContext;

public class LDAPNamespaceAuthenticator
extends AuthBrokerAuthenticator {
    private static String LDAPNS_PROTOCOLID = "LDAPNamespace";

    public Object login(String userName, String password, String accessDomain, ManagementServiceSet manageSS) throws AuthBrokerException {
        String resolvedAccessDomain;
        LDAPNamespace ldapns = null;
        try {
            ldapns = (LDAPNamespace)AdminNamespaceFactory.createAdminNamespace((int)1);
        }
        catch (SPIException spie) {
            throw new AuthBrokerException((Exception)((Object)spie));
        }
        if (userName != null && userName.length() > 0 && (password == null || password.length() == 0)) {
            password = "NoPasswordGiven!!";
        }
        String[] hostAndPort = accessDomain.split(":");
        try {
            resolvedAccessDomain = InetAddress.getByName(hostAndPort[0]).getHostAddress();
        }
        catch (UnknownHostException e) {
            String errMsg = eMFrameUtils.getLocalizedString("FwResources", "eMFrameConsts.RES_AUTHENTICATE_NOSERVER", manageSS.getLocale());
            if (errMsg == null) {
                errMsg = e.toString();
            }
            errMsg = errMsg + "  (" + accessDomain + ")";
            throw new AuthBrokerException(errMsg);
        }
        if (hostAndPort.length == 2) {
            resolvedAccessDomain = resolvedAccessDomain + ":" + hostAndPort[1];
        }
        int abrep_type = 1;
        Integer abrep_userData = null;
        AuthBrokerException abrep_aeInst = null;
        ObjectEntry abrep_oeRoot = null;
        try {
            boolean trySSL = manageSS.getAuthenticationBroker().getAuthUseLdapSSL();
            Properties additionalProps = new Properties();
            additionalProps.put("java.naming.referral", "throw");
            additionalProps.put("java.naming.ldap.derefAliases", "never");
            JndiLdapUtil jlUtil = new JndiLdapUtil();
            InitialLdapContext initDirCtx = jlUtil.createJNDILDAPContext(userName, password, resolvedAccessDomain, "389", "636", trySSL, additionalProps, manageSS.getLocale());
            try {
                ldapns.authenticate((Object)initDirCtx);
            }
            catch (SPIException spe) {
                if (spe instanceof UniqueSPIException && ((UniqueSPIException)spe).getErrorCode() == -223) {
                    abrep_type = 3;
                    abrep_userData = new Integer(((UniqueSPIException)spe).getErrorCode());
                    String sMsg2 = eMFrameUtils.getLocalizedString("FwResources", "Authenticate.Warn.GraceLogin", manageSS.getLocale());
                    String sMsg = ((UniqueSPIException)spe).getMessage() + "\n\n" + sMsg2;
                    int iErrCode = ((UniqueSPIException)spe).getErrorCode();
                    String sErrCode = String.valueOf(iErrCode);
                    Object[] sArgs = new String[]{sErrCode};
                    String sTitle = eMFrameUtils.getLocalizedString("DevResources", "GeneralMsg.NDSWarning", manageSS.getLocale());
                    sTitle = eMFrameUtils.formatMessage(sTitle, sArgs);
                    abrep_aeInst = new AuthBrokerException(sTitle, sMsg);
                }
                throw spe;
            }
            ObjectEntry[] ioes = ldapns.getInitialObjectEntries();
            if (ioes.length <= 0) {
                String message = eMFrameUtils.getLocalizedString("FwResources", "eMFrameConsts.RES_AUTHENTICATE_NOSERVER", manageSS.getLocale());
                if (message == null) {
                    message = "";
                }
                throw new AuthBrokerException(message);
            }
            abrep_oeRoot = ioes[0];
            return new AuthBrokerReport(abrep_type, LDAPNS_PROTOCOLID, abrep_oeRoot, abrep_userData, abrep_aeInst);
        }
        catch (Exception e) {
            throw new AuthBrokerException(e);
        }
    }

    public void logout(Object in_apiObject) {
        try {
            Object apiObject = in_apiObject instanceof AuthBrokerReport ? ((AuthBrokerReport)in_apiObject).getLoginAPIObject() : in_apiObject;
            ObjectEntry oeServer = (ObjectEntry)apiObject;
            LDAPNamespace ldapns = (LDAPNamespace)oeServer.getNamespace();
            ObjectEntry userOE = ldapns.getAuthenticatedIdentity(oeServer);
            if (ldapns != null && userOE != null) {
                try {
                    ldapns.unAuthenticate(userOE, "");
                    D.log("LDAPNamespaceAuthenticator::Logout successful for: " + userOE.getFullName());
                }
                catch (SPIException e) {
                    D.log("Failed UnAuthentication: error=" + e.toString() + ": " + userOE.getFullName());
                    D.log(e);
                }
            }
        }
        catch (Exception e) {
            D.log(e);
        }
    }
}

