/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.fw;

import com.novell.admin.ns.nds.NDSNamespace;
import com.novell.application.console.snapin.ObjectEntry;
import com.novell.emframe.dev.AuthenticationBroker;
import com.novell.emframe.dev.Task;
import com.novell.emframe.dev.TaskContext;
import com.novell.emframe.dev.config.SystemConfig;
import com.novell.emframe.dev.eMFrameUtils;
import com.novell.emframe.fw.FwUtils;
import java.io.File;
import java.util.Properties;

public class LauncheGuideTask
extends Task {
    private static final long serialVersionUID = 1L;

    public boolean execute(TaskContext context, Properties resultStrings) {
        try {
            AuthenticationBroker broker = context.getAuthenticationBroker();
            ObjectEntry treeOE = (ObjectEntry)broker.getAPIObject("NDSNamespace");
            NDSNamespace namespace = (NDSNamespace)treeOE.getNamespace();
            ObjectEntry loggedInUser = namespace.getAuthenticatedIdentity(treeOE);
            String[] identity = context.getAuthenticationBroker().getIdentity();
            String ldapDN = context.getDirUtils().getMappingObject().NDSNameToLDAPName(loggedInUser);
            String url = SystemConfig.getSystemConfig(context).getSetting("Provider.eMFrame.eGuide.location");
            if (url == null || url.equals("EMFRAME_SERVER")) {
                url = FwUtils.getDefaulteGuideLocation(context);
                String webappHome = SystemConfig.getSystemConfig(context).getSetting("WebApp.Home.path");
                if (webappHome.endsWith("eMFrame")) {
                    webappHome = webappHome.substring(0, webappHome.length() - "eMFrame".length());
                    File eGuideDir = new File(webappHome);
                    if (!(eGuideDir = new File(eGuideDir, "/eGuide")).exists()) {
                        eMFrameUtils.setMessage("error", eMFrameUtils.getLocalizedString("FwResources", "LauncheGuide.eGuideNotInstalledHeader", context), eMFrameUtils.getLocalizedString("FwResources", "LauncheGuide.eGuideNotInstalledBody", context), context);
                        return false;
                    }
                }
            }
            resultStrings.put("LauncheGuide.Url", url);
            resultStrings.put("LauncheGuide.Value1", ldapDN);
            resultStrings.put("LauncheGuide.Value2", identity[1]);
            return true;
        }
        catch (Exception e) {
            eMFrameUtils.setErrorMessage(e, context);
            return false;
        }
    }
}

