/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.fw;

import com.novell.admin.common.exceptions.SPIException;
import com.novell.admin.ns.AdminNamespace;
import com.novell.admin.ns.AttributeDefinition;
import com.novell.admin.ns.ComponentCreationException;
import com.novell.admin.ns.NSObject;
import com.novell.admin.ns.NamespaceException;
import com.novell.admin.ns.ObjectAttribute;
import com.novell.admin.ns.SchemaDefinition;
import com.novell.admin.ns.SchemaUtil;
import com.novell.admin.ns.Syntax;
import com.novell.admin.ns.ValueComponent;
import com.novell.application.console.snapin.ObjectEntry;
import com.novell.application.console.snapin.SnapinVetoException;
import com.novell.emframe.dev.D;
import com.novell.emframe.dev.TaskContext;
import com.novell.emframe.fw.FwUtils;
import com.novell.emframe.fw.MigrateRoleReport;
import com.novell.emframe.fw.RBSUtil;
import com.novell.rbs.RBSAssociation;
import com.novell.rbs.RBSBook;
import com.novell.rbs.RBSCollection;
import com.novell.rbs.RBSModule;
import com.novell.rbs.RBSObject;
import com.novell.rbs.RBSRights;
import com.novell.rbs.RBSRole;
import com.novell.rbs.RBSTask;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.jdom.Document;

public class MigrateRoleAssociations {
    private ObjectEntry treeOE;
    private TaskContext context;
    private AdminNamespace namespace;
    private SchemaDefinition schemaDef;
    private MigrateRoleReport m_migrateRoleReport;

    public MigrateRoleAssociations(ObjectEntry tOE, TaskContext cntxt, MigrateRoleReport migrateRoleReport) {
        this.treeOE = tOE;
        this.context = cntxt;
        this.namespace = this.treeOE.getAdminNamespace();
        this.m_migrateRoleReport = migrateRoleReport;
    }

    public void migrateRoleAssociations(String sourceCollectionName, String targetCollectionName, String dynamicGroupSearchType) throws Exception {
        int i;
        this.schemaDef = this.namespace.getSchemaDefinition(this.treeOE);
        RBSCollection sourceRBSCollection = new RBSCollection(this.namespace.getObjectEntry(this.treeOE, sourceCollectionName));
        RBSRole[] sourceRBSRoles = sourceRBSCollection.getRoles();
        if (sourceRBSRoles == null) {
            return;
        }
        Hashtable<String, RBSRole> targetRolesTable = new Hashtable<String, RBSRole>();
        Vector<RBSRole> sourceRolesToMigrateV = new Vector<RBSRole>();
        Vector<RBSRole> sourceRolesNewInTargetV = new Vector<RBSRole>();
        RBSCollection targetRBSCollection = new RBSCollection(this.namespace.getObjectEntry(this.treeOE, targetCollectionName));
        RBSRole[] targetRBSRoles = targetRBSCollection.getRoles();
        if (targetRBSRoles != null) {
            for (i = 0; i < targetRBSRoles.length; ++i) {
                String targetRoleShortName = targetRBSRoles[i].getObjectEntry().getName();
                targetRolesTable.put(targetRoleShortName, targetRBSRoles[i]);
            }
            for (i = 0; i < sourceRBSRoles.length; ++i) {
                String sourceRoleShortName = sourceRBSRoles[i].getObjectEntry().getName();
                RBSRole targetRBSRole = (RBSRole)targetRolesTable.get(sourceRoleShortName);
                if (targetRBSRole != null) {
                    sourceRolesToMigrateV.add(sourceRBSRoles[i]);
                    continue;
                }
                sourceRolesNewInTargetV.add(sourceRBSRoles[i]);
            }
        } else {
            for (i = 0; i < sourceRBSRoles.length; ++i) {
                sourceRolesNewInTargetV.add(sourceRBSRoles[i]);
            }
        }
        if (sourceRolesToMigrateV.size() > 0) {
            Object[] sourceRoleToMigrate = new RBSRole[sourceRolesToMigrateV.size()];
            sourceRolesToMigrateV.copyInto(sourceRoleToMigrate);
            for (int i2 = 0; i2 < sourceRoleToMigrate.length; ++i2) {
                Vector<RBSAssociation> targetRoleAssociationsToUpdate = new Vector<RBSAssociation>();
                String sourceRoleShortName = sourceRoleToMigrate[i2].getObjectEntry().getName();
                RBSRole targetRBSRole = (RBSRole)targetRolesTable.get(sourceRoleShortName);
                if (targetRBSRole != null) {
                    this.verifyContent((RBSRole)sourceRoleToMigrate[i2], targetRBSRole, targetCollectionName, dynamicGroupSearchType);
                    RBSAssociation[] sourceRBSAssoications = sourceRoleToMigrate[i2].getMembers();
                    if (sourceRBSAssoications != null) {
                        RBSAssociation[] targetRBSAssoications = targetRBSRole.getMembers();
                        for (int j = 0; j < sourceRBSAssoications.length; ++j) {
                            RBSAssociation existingTargetAssoication = this.doesSourceAssociationExistInTarget(sourceRBSAssoications[j], targetRBSAssoications);
                            if (existingTargetAssoication == null) {
                                sourceRBSAssoications[j].setRole(targetRBSRole);
                                targetRoleAssociationsToUpdate.add(sourceRBSAssoications[j]);
                                continue;
                            }
                            targetRoleAssociationsToUpdate.add(existingTargetAssoication);
                        }
                    }
                }
                if (targetRoleAssociationsToUpdate.size() <= 0) continue;
                Object[] targetAssoications = new RBSAssociation[targetRoleAssociationsToUpdate.size()];
                targetRoleAssociationsToUpdate.copyInto(targetAssoications);
                targetRBSRole.setMembers((RBSAssociation[])targetAssoications, dynamicGroupSearchType);
                targetRBSRole.update();
            }
        }
        if (sourceRolesNewInTargetV.size() > 0) {
            this.migrateCustomRoles(sourceRolesNewInTargetV, targetCollectionName, dynamicGroupSearchType);
        }
    }

    private RBSAssociation doesSourceAssociationExistInTarget(RBSAssociation sourceRBSAssoication, RBSAssociation[] targetRBSAssoications) {
        RBSAssociation targetRBSAssoication = null;
        if (targetRBSAssoications != null) {
            String sourceMemberName = this.namespace.getUnrootedName(sourceRBSAssoication.getMember());
            String sourceScopeName = this.namespace.getUnrootedName(sourceRBSAssoication.getScope());
            for (int i = 0; i < targetRBSAssoications.length; ++i) {
                String targetMemberName = this.namespace.getUnrootedName(targetRBSAssoications[i].getMember());
                String targetScopeName = this.namespace.getUnrootedName(targetRBSAssoications[i].getScope());
                if (!sourceMemberName.equalsIgnoreCase(targetMemberName) || !sourceScopeName.equalsIgnoreCase(targetScopeName)) continue;
                targetRBSAssoication = targetRBSAssoications[i];
                break;
            }
        }
        return targetRBSAssoication;
    }

    private void migrateCustomRoles(Vector sourceRolesNewInTargetV, String targetCollectionName, String dynamicGroupSearchType) {
        for (int i = 0; i < sourceRolesNewInTargetV.size(); ++i) {
            try {
                RBSRole rbsRole = (RBSRole)sourceRolesNewInTargetV.elementAt(i);
                String roleName = rbsRole.getObjectEntry().getName();
                Vector<RBSTask> rbsTaskV = new Vector<RBSTask>();
                Vector<RBSBook> rbsBookV = new Vector<RBSBook>();
                RBSObject[] rbsObject = rbsRole.getContent();
                if (rbsObject != null) {
                    for (int j = 0; j < rbsObject.length; ++j) {
                        ObjectEntry moduleOE;
                        String moduleName;
                        ObjectEntry rbsContentOE = rbsObject[j].getObjectEntry();
                        String rbsContentName = rbsContentOE.getName();
                        String newContentDN = RBSUtil.concatStr(this.namespace, RBSUtil.concatStr(this.namespace, rbsContentName, moduleName = (moduleOE = rbsContentOE.getParent()).getName()), targetCollectionName);
                        if (this.namespace.doesExist(this.treeOE, newContentDN)) {
                            String targetEntryPoint;
                            if (rbsObject[j] instanceof RBSBook) {
                                String[] targetPages;
                                String[] newPageList;
                                String[] sourceObjectTypes;
                                String[] allPages;
                                boolean addedPage = false;
                                ObjectEntry targetBookOE = this.namespace.getObjectEntry(newContentDN);
                                RBSBook targetBook = new RBSBook(targetBookOE);
                                String[] sourcePageMemebership = ((RBSBook)rbsObject[j]).getPageMemebership();
                                if (sourcePageMemebership != null && (allPages = FwUtils.getAllPageIds(this.context, sourceObjectTypes = ((RBSBook)rbsObject[j]).getTargetObjectType())) != null && (newPageList = this.getNewPageList(sourcePageMemebership, allPages)) != null && (targetPages = targetBook.getPageMemebership()) != null) {
                                    Hashtable<String, String> targetPageTable = new Hashtable<String, String>();
                                    for (int k = 0; k < targetPages.length; ++k) {
                                        targetPageTable.put(targetPages[k], targetPages[k]);
                                    }
                                    for (int l = 0; l < newPageList.length; ++l) {
                                        String page = (String)targetPageTable.get(newPageList[l]);
                                        if (page != null) continue;
                                        targetPageTable.put(newPageList[l], newPageList[l]);
                                        addedPage = true;
                                    }
                                    if (addedPage && !targetPageTable.isEmpty()) {
                                        String[] newPages = new String[targetPageTable.size()];
                                        Enumeration myenum = targetPageTable.elements();
                                        int p = 0;
                                        while (myenum.hasMoreElements()) {
                                            newPages[p] = (String)myenum.nextElement();
                                            ++p;
                                        }
                                        targetBook.setPageMembership(newPages);
                                        targetBook.update();
                                    }
                                }
                                rbsBookV.add(targetBook);
                                continue;
                            }
                            ObjectEntry targetTaskOE = this.namespace.getObjectEntry(newContentDN);
                            RBSTask targetTask = new RBSTask(targetTaskOE);
                            String sourceEntryPoint = ((RBSTask)rbsObject[j]).getEntryPoint();
                            if (sourceEntryPoint.startsWith("java:")) {
                                sourceEntryPoint = sourceEntryPoint.substring("java:".length());
                            }
                            if ((targetEntryPoint = targetTask.getEntryPoint()).startsWith("java:")) {
                                targetEntryPoint = targetEntryPoint.substring("java:".length());
                            }
                            if (!sourceEntryPoint.equalsIgnoreCase(targetEntryPoint)) continue;
                            rbsTaskV.add(targetTask);
                            continue;
                        }
                        if (rbsObject[j] instanceof RBSBook) {
                            String[] newPageList;
                            String[] sourceObjectTypes;
                            String[] targetPages;
                            RBSBook sourceRBSBook = new RBSBook(rbsContentOE);
                            String[] sourcePageMemebership = sourceRBSBook.getPageMemebership();
                            if (sourcePageMemebership == null || (targetPages = FwUtils.getAllPageIds(this.context, sourceObjectTypes = sourceRBSBook.getTargetObjectType())) == null || (newPageList = this.getNewPageList(sourcePageMemebership, targetPages)) == null) continue;
                            String targetModuleDN = RBSUtil.concatStr(this.namespace, moduleName, targetCollectionName);
                            if (!this.namespace.doesExist(this.treeOE, targetModuleDN)) {
                                RBSModule sourceRBSModule = new RBSModule(moduleOE);
                                NSObject moduleObj = this.createRBSModule(targetCollectionName, moduleName);
                                this.updateModule(sourceRBSModule, moduleObj);
                            }
                            NSObject bookObj = this.createRBSBook(targetModuleDN, rbsContentName);
                            RBSBook targetBook = this.updateBook(sourceRBSBook, bookObj, newPageList);
                            rbsBookV.add(targetBook);
                            continue;
                        }
                        String taskName = this.namespace.getUnrootedName(rbsContentOE);
                        this.m_migrateRoleReport.putTask(taskName, taskName);
                    }
                }
                if (rbsTaskV.size() + rbsBookV.size() <= 0) continue;
                int count = 0;
                RBSObject[] rbsTargetObjects = new RBSObject[rbsTaskV.size() + rbsBookV.size()];
                if (rbsTaskV.size() > 0) {
                    for (int t = 0; t < rbsTaskV.size(); ++t) {
                        rbsTargetObjects[count] = (RBSObject)rbsTaskV.elementAt(t);
                        ++count;
                    }
                }
                if (rbsBookV.size() > 0) {
                    for (int b = 0; b < rbsBookV.size(); ++b) {
                        rbsTargetObjects[count] = (RBSObject)rbsBookV.elementAt(b);
                        ++count;
                    }
                }
                NSObject targetRoleObj = this.createRBSRole(targetCollectionName, roleName);
                RBSRole targetRole = this.updateRole(rbsRole, targetRoleObj, rbsTargetObjects, dynamicGroupSearchType);
                this.updateRoleAssociations(rbsRole, targetRole, dynamicGroupSearchType);
                continue;
            }
            catch (Exception e) {
                D.log(e.toString());
            }
        }
    }

    private void updateRoleAssociations(RBSRole rbsRole, RBSRole targetRole, String dynamicGroupSearchType) throws Exception {
        RBSAssociation[] rbsAssociation = rbsRole.getMembers();
        if (rbsAssociation != null) {
            for (int i = 0; i < rbsAssociation.length; ++i) {
                rbsAssociation[i].setRole(targetRole);
                rbsAssociation[i].setRights(true);
            }
            targetRole.setMembers(rbsAssociation, dynamicGroupSearchType);
            targetRole.update();
        }
    }

    private void updateModule(RBSModule sourceRBSModule, NSObject moduleObj) throws Exception {
        Document sourceXMLInfo;
        boolean update = false;
        RBSModule targetRBSModule = new RBSModule(moduleObj);
        String sourceDesc = sourceRBSModule.getDescription();
        if (sourceDesc != null) {
            targetRBSModule.setDescription(sourceDesc);
            update = true;
        }
        if ((sourceXMLInfo = sourceRBSModule.getrbsXMLInfo()) != null) {
            targetRBSModule.setrbsXMLInfo(sourceXMLInfo);
            update = true;
        }
        if (update) {
            targetRBSModule.update();
        }
    }

    private RBSRole updateRole(RBSRole sourceRBSRole, NSObject roleObj, RBSObject[] rbsObjects, String dynamicGroupSearchType) throws Exception {
        Document XMLInfo;
        String description;
        boolean update = false;
        RBSRole targetRBSRole = new RBSRole(roleObj);
        String parameters = sourceRBSRole.getParameters();
        if (parameters != null) {
            targetRBSRole.setParameters(parameters);
            update = true;
        }
        if ((description = sourceRBSRole.getDescription()) != null) {
            targetRBSRole.setDescription(description);
            update = true;
        }
        if ((XMLInfo = sourceRBSRole.getrbsXMLInfo()) != null) {
            targetRBSRole.setrbsXMLInfo(XMLInfo);
            update = true;
        }
        if (rbsObjects != null) {
            targetRBSRole.setContent(rbsObjects, dynamicGroupSearchType);
            update = true;
        }
        if (update) {
            targetRBSRole.update();
        }
        return targetRBSRole;
    }

    private RBSBook updateBook(RBSBook sourceRBSBook, NSObject bookObj, String[] newPageList) throws Exception {
        String[] pageList;
        String[] objectTypes;
        Document XMLInfo;
        String description;
        String parameters;
        boolean update = false;
        RBSBook targetRBSBook = new RBSBook(bookObj);
        String entryPoint = sourceRBSBook.getEntryPoint();
        if (entryPoint != null) {
            targetRBSBook.setEntryPoint(entryPoint);
            update = true;
        }
        if ((parameters = sourceRBSBook.getParameters()) != null) {
            targetRBSBook.setParameters(parameters);
            update = true;
        }
        if ((description = sourceRBSBook.getDescription()) != null) {
            targetRBSBook.setDescription(description);
            update = true;
        }
        if ((XMLInfo = sourceRBSBook.getrbsXMLInfo()) != null) {
            targetRBSBook.setrbsXMLInfo(XMLInfo);
            update = true;
        }
        if ((objectTypes = sourceRBSBook.getTargetObjectType()) != null) {
            targetRBSBook.setTargetObjectType(objectTypes);
        }
        if ((pageList = newPageList) != null && pageList.length > 0) {
            Vector<String> pagesV = new Vector<String>();
            for (int i = 0; i < pageList.length; ++i) {
                boolean add = true;
                RBSRights[] rights = FwUtils.getPagesRights(new String[]{pageList[i]}, this.treeOE);
                if (rights != null) {
                    for (int j = 0; j < rights.length; ++j) {
                        if (rights[j].getProtectedAttrName().equalsIgnoreCase("[Entry Rights]") || rights[j].getProtectedAttrName().equalsIgnoreCase("[All Attributes Rights]") || rights[j].getProtectedAttrName().equalsIgnoreCase("[No Self Rights Assignment]") || this.schemaDef.isAttributeDefined(rights[j].getProtectedAttrName())) continue;
                        D.log("--  Discarding page: " + pageList[i] + " in book: " + this.namespace.getUnrootedName(bookObj.getObjectEntry()) + " attribute undefined: " + rights[j].getProtectedAttrName());
                        add = false;
                        break;
                    }
                }
                if (!add) continue;
                pagesV.addElement(pageList[i]);
            }
            pageList = null;
            if (pagesV.size() > 0) {
                pageList = pagesV.toArray(new String[pagesV.size()]);
                targetRBSBook.setPageMembership(pageList);
                update = true;
            } else {
                targetRBSBook.setPageMembership(null);
                targetRBSBook.setRights(null);
                update = true;
            }
        }
        if (pageList != null) {
            RBSRights[] pageRights = FwUtils.getPagesRights(pageList, this.treeOE);
            if (pageRights != null && pageRights.length > 0) {
                targetRBSBook.setRights(pageRights);
                update = true;
            }
        } else {
            RBSRights[] rights;
            String[] specialType = sourceRBSBook.getTargetObjectType();
            if (specialType.length > 0 && specialType[0].equals("*") && (rights = sourceRBSBook.getRights()) != null && rights.length > 0) {
                targetRBSBook.setRights(rights);
                update = true;
            }
        }
        if (update) {
            targetRBSBook.update();
        }
        return targetRBSBook;
    }

    private NSObject createRBSModule(String selectedContext, String moduleName) throws SPIException, SnapinVetoException, ComponentCreationException, NamespaceException {
        ObjectEntry contextOE = this.namespace.getObjectEntry(this.treeOE, selectedContext);
        ValueComponent[] vals = new ValueComponent[1];
        ValueComponent[] nameVal = new ValueComponent[1];
        AttributeDefinition objClassAttrDef = this.namespace.getAttributeDefinition(contextOE, SchemaUtil.translateNDAPAttr((ObjectEntry)contextOE, (String)"Object Class"));
        Syntax objClassSyn = objClassAttrDef.getSyntax();
        vals[0] = objClassSyn.createValueComponent((Object)"rbsModule2");
        ObjectAttribute attrObj = new ObjectAttribute(objClassAttrDef, vals);
        AttributeDefinition cnAttrDef = this.namespace.getAttributeDefinition(contextOE, SchemaUtil.translateNDAPAttr((ObjectEntry)contextOE, (String)"CN"));
        Syntax cnSyn = cnAttrDef.getSyntax();
        nameVal[0] = cnSyn.createValueComponent((Object)moduleName);
        ObjectAttribute objNameAttr = new ObjectAttribute(cnAttrDef, nameVal);
        Vector<ObjectAttribute> attrOV = new Vector<ObjectAttribute>();
        attrOV.addElement(attrObj);
        attrOV.addElement(objNameAttr);
        ObjectEntry moduleOE = this.namespace.createObjectEntry(contextOE, moduleName, "rbsModule2");
        NSObject moduleObj = this.namespace.createNSObject(moduleOE, attrOV);
        this.namespace.create(moduleObj);
        return moduleObj;
    }

    private NSObject createRBSBook(String moduleDN, String bookName) throws SPIException, SnapinVetoException, ComponentCreationException, NamespaceException {
        ObjectEntry moduleOE = this.namespace.getObjectEntry(this.treeOE, moduleDN);
        ValueComponent[] vals = new ValueComponent[1];
        ValueComponent[] nameVal = new ValueComponent[1];
        AttributeDefinition objClassAttrDef = this.namespace.getAttributeDefinition(moduleOE, SchemaUtil.translateNDAPAttr((ObjectEntry)moduleOE, (String)"Object Class"));
        Syntax objClassSyn = objClassAttrDef.getSyntax();
        vals[0] = objClassSyn.createValueComponent((Object)"rbsBook2");
        ObjectAttribute attrObj = new ObjectAttribute(objClassAttrDef, vals);
        AttributeDefinition cnAttrDef = this.namespace.getAttributeDefinition(moduleOE, SchemaUtil.translateNDAPAttr((ObjectEntry)moduleOE, (String)"CN"));
        Syntax cnSyn = cnAttrDef.getSyntax();
        nameVal[0] = cnSyn.createValueComponent((Object)bookName);
        ObjectAttribute objNameAttr = new ObjectAttribute(cnAttrDef, nameVal);
        Vector<ObjectAttribute> attrOV = new Vector<ObjectAttribute>();
        attrOV.addElement(attrObj);
        attrOV.addElement(objNameAttr);
        ObjectEntry bookOE = this.namespace.createObjectEntry(moduleOE, bookName, "rbsBook2");
        NSObject bookObj = this.namespace.createNSObject(bookOE, attrOV);
        this.namespace.create(bookObj);
        return bookObj;
    }

    private NSObject createRBSRole(String targetCollectionName, String roleName) throws SPIException, SnapinVetoException, ComponentCreationException, NamespaceException {
        ObjectEntry collectionOE = this.namespace.getObjectEntry(this.treeOE, targetCollectionName);
        ValueComponent[] vals = new ValueComponent[1];
        ValueComponent[] nameVal = new ValueComponent[1];
        AttributeDefinition objClassAttrDef = this.namespace.getAttributeDefinition(collectionOE, SchemaUtil.translateNDAPAttr((ObjectEntry)collectionOE, (String)"Object Class"));
        Syntax objClassSyn = objClassAttrDef.getSyntax();
        vals[0] = objClassSyn.createValueComponent((Object)"rbsRole2");
        ObjectAttribute attrObj = new ObjectAttribute(objClassAttrDef, vals);
        AttributeDefinition cnAttrDef = this.namespace.getAttributeDefinition(collectionOE, SchemaUtil.translateNDAPAttr((ObjectEntry)collectionOE, (String)"CN"));
        Syntax cnSyn = cnAttrDef.getSyntax();
        nameVal[0] = cnSyn.createValueComponent((Object)roleName);
        ObjectAttribute objNameAttr = new ObjectAttribute(cnAttrDef, nameVal);
        Vector<ObjectAttribute> attrOV = new Vector<ObjectAttribute>();
        attrOV.addElement(attrObj);
        attrOV.addElement(objNameAttr);
        ObjectEntry roleOE = this.namespace.createObjectEntry(collectionOE, roleName, "rbsRole2");
        NSObject roleObj = this.namespace.createNSObject(roleOE, attrOV);
        this.namespace.create(roleObj);
        return roleObj;
    }

    private String[] getNewPageList(String[] sourcePageList, String[] targetPageList) {
        int i;
        Object[] retStr = null;
        Hashtable<String, String> targetTable = new Hashtable<String, String>();
        Vector<String> stringV = new Vector<String>();
        for (i = 0; i < targetPageList.length; ++i) {
            targetTable.put(targetPageList[i], targetPageList[i]);
        }
        for (i = 0; i < sourcePageList.length; ++i) {
            String page;
            if (sourcePageList[i].startsWith("ndps.")) {
                sourcePageList[i] = sourcePageList[i].substring("ndps.".length());
                sourcePageList[i] = "iPrint.".concat(sourcePageList[i]);
            }
            if ((page = (String)targetTable.get(sourcePageList[i])) != null) {
                stringV.add(page);
                continue;
            }
            this.m_migrateRoleReport.putPage(sourcePageList[i], sourcePageList[i]);
        }
        if (stringV.size() > 0) {
            retStr = new String[stringV.size()];
            stringV.copyInto(retStr);
        }
        return retStr;
    }

    private void verifyContent(RBSRole sourceRole, RBSRole targetRole, String targetCollectionName, String dynamicGroupSearchType) throws Exception {
        Hashtable<String, Object> targetTable = new Hashtable<String, Object>();
        boolean contentAdded = false;
        RBSObject[] sourceContent = sourceRole.getContent();
        RBSObject[] targetContent = targetRole.getContent();
        if (targetContent != null) {
            for (int i = 0; i < targetContent.length; ++i) {
                targetTable.put(targetContent[i].getObjectEntry().getName(), targetContent[i]);
            }
        }
        if (sourceContent != null) {
            RBSObject content = null;
            for (int i = 0; i < sourceContent.length; ++i) {
                content = (RBSObject)targetTable.get(sourceContent[i].getObjectEntry().getName());
                if (content != null) continue;
                ObjectEntry rbsContentOE = sourceContent[i].getObjectEntry();
                String rbsContentName = rbsContentOE.getName();
                ObjectEntry moduleOE = rbsContentOE.getParent();
                String moduleName = moduleOE.getName();
                String newContentDN = RBSUtil.concatStr(this.namespace, RBSUtil.concatStr(this.namespace, rbsContentName, moduleName), targetCollectionName);
                if (sourceContent[i] instanceof RBSBook) {
                    String[] newPageList;
                    String[] sourceObjectTypes;
                    String[] targetPages;
                    if (this.namespace.doesExist(this.treeOE, newContentDN)) {
                        String[] targetPages2;
                        String[] newPageList2;
                        String[] sourceObjectTypes2;
                        String[] allPages;
                        boolean addedPage = false;
                        ObjectEntry targetBookOE = this.namespace.getObjectEntry(newContentDN);
                        RBSBook targetBook = new RBSBook(targetBookOE);
                        String[] sourcePageMemebership = ((RBSBook)sourceContent[i]).getPageMemebership();
                        if (sourcePageMemebership == null || (allPages = FwUtils.getAllPageIds(this.context, sourceObjectTypes2 = ((RBSBook)sourceContent[i]).getTargetObjectType())) == null || (newPageList2 = this.getNewPageList(sourcePageMemebership, allPages)) == null || (targetPages2 = targetBook.getPageMemebership()) == null) continue;
                        Hashtable<String, String> targetPageTable = new Hashtable<String, String>();
                        for (int k = 0; k < targetPages2.length; ++k) {
                            targetPageTable.put(targetPages2[k], targetPages2[k]);
                        }
                        for (int l = 0; l < newPageList2.length; ++l) {
                            String page = (String)targetPageTable.get(newPageList2[l]);
                            if (page != null) continue;
                            targetPageTable.put(newPageList2[l], newPageList2[l]);
                            addedPage = true;
                        }
                        if (!addedPage || targetPageTable.isEmpty()) continue;
                        String[] newPages = new String[targetPageTable.size()];
                        Enumeration myenum = targetPageTable.elements();
                        int p = 0;
                        while (myenum.hasMoreElements()) {
                            newPages[p] = (String)myenum.nextElement();
                            ++p;
                        }
                        targetBook.setPageMembership(newPages);
                        targetBook.update();
                        continue;
                    }
                    RBSBook sourceRBSBook = new RBSBook(rbsContentOE);
                    String[] sourcePageMemebership = sourceRBSBook.getPageMemebership();
                    if (sourcePageMemebership == null || (targetPages = FwUtils.getAllPageIds(this.context, sourceObjectTypes = sourceRBSBook.getTargetObjectType())) == null || (newPageList = this.getNewPageList(sourcePageMemebership, targetPages)) == null) continue;
                    String targetModuleDN = RBSUtil.concatStr(this.namespace, moduleName, targetCollectionName);
                    if (!this.namespace.doesExist(this.treeOE, targetModuleDN)) {
                        RBSModule sourceRBSModule = new RBSModule(moduleOE);
                        NSObject moduleObj = this.createRBSModule(targetCollectionName, moduleName);
                        this.updateModule(sourceRBSModule, moduleObj);
                    }
                    NSObject bookObj = this.createRBSBook(targetModuleDN, rbsContentName);
                    RBSBook targetBook = this.updateBook(sourceRBSBook, bookObj, newPageList);
                    targetTable.put(targetBook.getObjectEntry().getName(), targetBook);
                    contentAdded = true;
                    continue;
                }
                if (this.namespace.doesExist(this.treeOE, newContentDN)) {
                    ObjectEntry targetContentOE = this.namespace.getObjectEntry(this.treeOE, newContentDN);
                    RBSTask newTargetObject = new RBSTask(targetContentOE);
                    targetTable.put(targetContentOE.getName(), newTargetObject);
                    contentAdded = true;
                    continue;
                }
                String taskName = this.namespace.getUnrootedName(sourceContent[i].getObjectEntry());
                this.m_migrateRoleReport.putTask(taskName, taskName);
            }
            if (contentAdded && !targetTable.isEmpty()) {
                RBSObject[] tasks = new RBSObject[targetTable.size()];
                Enumeration myenum = targetTable.elements();
                int i = 0;
                while (myenum.hasMoreElements()) {
                    tasks[i] = (RBSObject)myenum.nextElement();
                    ++i;
                }
                targetRole.setContent(tasks, dynamicGroupSearchType);
            }
        }
    }
}

