/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.fw;

import com.novell.admin.ns.AdminNamespace;
import com.novell.application.console.snapin.ObjectEntry;
import com.novell.emframe.dev.D;
import com.novell.emframe.dev.Task;
import com.novell.emframe.dev.TaskContext;
import com.novell.emframe.dev.eMFrameUtils;
import com.novell.emframe.fw.CategoryData;
import com.novell.emframe.fw.RBSUtil;
import com.novell.rbs.RBSCategory;
import com.novell.rbs.RBSCollection;
import com.novell.rbs.RBSRole;
import java.util.ArrayList;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;

public class ModifyRoleCategoryAssignment
extends Task {
    private static final long serialVersionUID = 1L;
    private HttpServletRequest m_req;
    private TaskContext m_context;
    private Properties m_resultStrings;
    private AdminNamespace m_ns;
    private ObjectEntry m_treeOE;
    private ArrayList m_availableCategoryList = new ArrayList();
    private ArrayList m_assignedCategoryList = new ArrayList();
    private ObjectEntry m_roleOE;

    public boolean execute(TaskContext context, Properties resultStrings) {
        this.m_context = context;
        this.m_resultStrings = resultStrings;
        this.m_req = context.getRequest();
        this.m_treeOE = RBSUtil.getTreeOE(this.m_context);
        this.m_ns = this.m_treeOE.getAdminNamespace();
        String nextState = this.m_req.getParameter("nextState");
        if (nextState.equalsIgnoreCase("showRoleCategoryAssignment")) {
            return this.showRoleCategoryAssignment();
        }
        if (nextState.equalsIgnoreCase("saveRoleCategoryAssignment")) {
            return this.saveRoleCategoryAssignment();
        }
        return false;
    }

    private boolean showRoleCategoryAssignment() {
        block13: {
            String selectedCollectionName = this.m_req.getParameter("selectedCollectionName");
            String[] strings = eMFrameUtils.unpack(selectedCollectionName, this.m_context);
            selectedCollectionName = strings[0];
            String roleName = this.m_req.getParameter("RoleName");
            strings = eMFrameUtils.unpack(roleName, this.m_context);
            roleName = strings[0];
            try {
                ObjectEntry collectionOE;
                RBSCollection rbsCollection;
                RBSCategory[] rbsCategory;
                this.m_roleOE = this.m_ns.getObjectEntry(this.m_treeOE, roleName);
                String roleDisplayName = RBSUtil.getLocalizedDisplayName(this.m_context, this.m_roleOE);
                this.m_resultStrings.put("RoleDisplayName", roleDisplayName);
                RBSRole rbsRole = new RBSRole(this.m_roleOE);
                ObjectEntry[] categoryOEs = rbsRole.getCategoryMembership();
                if (categoryOEs != null) {
                    for (int i = 0; i < categoryOEs.length; ++i) {
                        RBSCategory rbsCategory2 = new RBSCategory(categoryOEs[i]);
                        ObjectEntry categoryOE = rbsCategory2.getObjectEntry();
                        String categoryName = RBSUtil.getLocalizedDisplayName(this.m_context, categoryOE);
                        String categoryFDN = this.m_ns.getUnrootedName(categoryOE);
                        String categoryDesc = null;
                        try {
                            categoryDesc = rbsRole.getDescription();
                            if (categoryDesc == null) {
                                categoryDesc = eMFrameUtils.getLocalizedString("FwResources", "eMFrameConsts.NO_DESCRIPTION", this.m_context.getLocale());
                            }
                        }
                        catch (Exception exc) {
                            categoryDesc = "";
                        }
                        CategoryData categoryData = new CategoryData(categoryFDN, categoryName, categoryDesc, "");
                        this.m_assignedCategoryList.add(categoryData);
                    }
                }
                if ((rbsCategory = (rbsCollection = new RBSCollection(collectionOE = this.m_ns.getObjectEntry(this.m_treeOE, selectedCollectionName))).getCategories()) == null) break block13;
                for (int i = 0; i < rbsCategory.length; ++i) {
                    ObjectEntry categoryOE = rbsCategory[i].getObjectEntry();
                    String categoryFDN = this.m_ns.getUnrootedName(categoryOE);
                    boolean found = false;
                    if (this.m_assignedCategoryList.size() > 0) {
                        for (int j = 0; j < this.m_assignedCategoryList.size(); ++j) {
                            CategoryData categoryData = (CategoryData)this.m_assignedCategoryList.get(j);
                            if (!categoryData.getObjectFDN().equalsIgnoreCase(categoryFDN)) continue;
                            found = true;
                            break;
                        }
                    }
                    if (found) continue;
                    String categoryName = RBSUtil.getLocalizedDisplayName(this.m_context, categoryOE);
                    String categoryDesc = null;
                    try {
                        categoryDesc = rbsCategory[i].getDescription();
                        if (categoryDesc == null) {
                            categoryDesc = eMFrameUtils.getLocalizedString("FwResources", "eMFrameConsts.NO_DESCRIPTION", this.m_context.getLocale());
                        }
                    }
                    catch (Exception exc) {
                        categoryDesc = "";
                    }
                    CategoryData categoryData = new CategoryData(categoryFDN, categoryName, categoryDesc, "");
                    this.m_availableCategoryList.add(categoryData);
                }
            }
            catch (Exception e) {
                D.log(e);
                eMFrameUtils.setErrorMessage(e, this.m_context);
                return false;
            }
        }
        this.putAvailableCategories();
        this.putAssignedCategories();
        return true;
    }

    private boolean saveRoleCategoryAssignment() {
        this.m_resultStrings.put("TaskAfterGenConf", "fw.HomePage");
        this.m_resultStrings.put("MergeAfterGenConf", "fw.HomePage");
        String formChanged = this.m_req.getParameter("RoleCategoryFormChanged");
        if (formChanged.equals("true")) {
            this.getAssignedCategories();
            RBSRole rbsRole = new RBSRole(this.m_roleOE);
            try {
                if (this.m_assignedCategoryList.size() > 0) {
                    ObjectEntry[] categoryOEs = new ObjectEntry[this.m_assignedCategoryList.size()];
                    for (int i = 0; i < this.m_assignedCategoryList.size(); ++i) {
                        CategoryData categoryData = (CategoryData)this.m_assignedCategoryList.get(i);
                        categoryOEs[i] = this.m_ns.getObjectEntry(this.m_treeOE, categoryData.getObjectFDN());
                    }
                    rbsRole.setCategoryMembership(categoryOEs);
                } else {
                    rbsRole.setCategoryMembership(null);
                }
                rbsRole.update();
                this.m_resultStrings.put("GeneralMsg.MsgTitle", eMFrameUtils.getLocalizedString("FwResources", "ModifyRoleCategoryAssignment", this.m_context.getLocale()));
                this.m_resultStrings.put("GeneralMsg.MsgBody", eMFrameUtils.getLocalizedString("FwResources", "CreateCategory.Modified", this.m_context.getLocale()));
            }
            catch (Exception e) {
                D.log(e);
                eMFrameUtils.setErrorMessage(e, this.m_context);
                return false;
            }
        } else {
            this.m_resultStrings.put("GeneralMsg.MsgTitle", eMFrameUtils.getLocalizedString("FwResources", "ModifyRoleCategoryAssignment", this.m_context.getLocale()));
            this.m_resultStrings.put("GeneralMsg.MsgBody", eMFrameUtils.getLocalizedString("FwResources", "GetBookName.NO_UPDATE_PAGE_RBSBOOK", this.m_context.getLocale()));
        }
        return true;
    }

    private void putAvailableCategories() {
        this.m_resultStrings.put("AvailableCategory.Count", Integer.toString(this.m_availableCategoryList.size()));
        for (int i = 0; i < this.m_availableCategoryList.size(); ++i) {
            CategoryData categoryData = (CategoryData)this.m_availableCategoryList.get(i);
            this.m_resultStrings.put("AvailableCategories." + i + ".ShortName", categoryData.getDisplayName());
            this.m_resultStrings.put("AvailableCategories." + i + ".FullName", categoryData.getObjectFDN());
            this.m_resultStrings.put("AvailableCategories." + i + ".Description", categoryData.getCategoryDesc());
        }
    }

    private void putAssignedCategories() {
        this.m_resultStrings.put("AssignedCategory.Count", Integer.toString(this.m_assignedCategoryList.size()));
        for (int i = 0; i < this.m_assignedCategoryList.size(); ++i) {
            CategoryData categoryData = (CategoryData)this.m_assignedCategoryList.get(i);
            this.m_resultStrings.put("AssignedCategories." + i + ".ShortName", categoryData.getDisplayName());
            this.m_resultStrings.put("AssignedCategories." + i + ".FullName", categoryData.getObjectFDN());
            this.m_resultStrings.put("AssignedCategories." + i + ".Description", categoryData.getCategoryDesc());
        }
    }

    private void getAssignedCategories() {
        this.m_assignedCategoryList.clear();
        String assignedCategoryFullName = this.m_req.getParameter("AssignedCategoryFullName");
        String assignedCategoryShortName = this.m_req.getParameter("AssignedCategoryShortName");
        String assignedCategoryDescription = this.m_req.getParameter("AssignedCategoryDescription");
        StringTokenizer fullNameTokenizer = new StringTokenizer(assignedCategoryFullName, ";");
        StringTokenizer shortNameTokenizer = new StringTokenizer(assignedCategoryShortName, ";");
        StringTokenizer descriptionTokenizer = new StringTokenizer(assignedCategoryDescription, ";");
        if (fullNameTokenizer.countTokens() == shortNameTokenizer.countTokens() && fullNameTokenizer.countTokens() == descriptionTokenizer.countTokens() && shortNameTokenizer.countTokens() == descriptionTokenizer.countTokens() && shortNameTokenizer.countTokens() > 0) {
            while (shortNameTokenizer.hasMoreTokens()) {
                CategoryData categoryData = new CategoryData();
                categoryData.setDisplayName(eMFrameUtils.urlDecode(shortNameTokenizer.nextToken(), this.m_req.getCharacterEncoding()));
                categoryData.setObjectFDN(eMFrameUtils.urlDecode(fullNameTokenizer.nextToken(), this.m_req.getCharacterEncoding()));
                categoryData.setCategoryDesc(eMFrameUtils.urlDecode(descriptionTokenizer.nextToken(), this.m_req.getCharacterEncoding()));
                this.m_assignedCategoryList.add(categoryData);
            }
        }
    }
}

