/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.fw;

import com.novell.emframe.dev.D;
import com.novell.emframe.dev.MContext;
import com.novell.emframe.dev.MTask;
import com.novell.emframe.dev.config.SystemConfig;
import com.novell.emframe.dev.eMFrameUtils;
import com.novell.emframe.fw.AsyncProgressFormat;
import com.novell.emframe.fw.DownloadAndInstallWorker;
import com.novell.emframe.fw.FwUtils;
import com.novell.emframe.fw.RBSUtil;
import com.novell.emframe.fw.ReadXml;
import com.novell.emframe.fw.Registry;
import com.novell.emframe.fw.VersionInfo;
import com.novell.emframe.fw.config.ModuleInfo;
import com.novell.emframe.fw.config.ModuleManager;
import com.novell.emframe.fw.config.SystemConfigManager;
import com.novell.emframe.fw.servlet.FwRequest;
import com.novell.emframe.fw.util.FwAsyncUtils;
import com.novell.nps.gadgetManager.GadgetInstance;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public class ModulesToInstall
extends MTask {
    private MContext m_context;
    private HttpServletRequest m_req;
    private DownloadAndInstallWorker downLoadWorker;
    private boolean downLoading;
    private String[] arrModules;
    private static File fPackages;
    private boolean installing;

    public void execute(MContext context) {
        block52: {
            String sAction;
            block58: {
                String selectedModule;
                boolean meetsCriteria;
                Hashtable htModules;
                block60: {
                    String copiedModuleName;
                    block59: {
                        block57: {
                            block56: {
                                block55: {
                                    block54: {
                                        String[] arrModules;
                                        String sPackedModule;
                                        block53: {
                                            ModuleInfo moduleInfo;
                                            this.m_context = context;
                                            this.m_req = this.m_context.getRequest();
                                            if (!FwUtils.canConfigureiManager(this.m_req)) {
                                                eMFrameUtils.setMessage("error", eMFrameUtils.getLocalizedString("FwResources", "Error", this.m_context), eMFrameUtils.getLocalizedString("FwResources", "Configure.UserNotAuthorizedToConfigureiManager", this.m_context), this.m_context);
                                                return;
                                            }
                                            if (this.m_req == null) break block52;
                                            htModules = null;
                                            sAction = this.m_req.getParameter("moduleaction");
                                            if (!(sAction != null && sAction.length() != 0 || (sAction = (String)this.m_req.getAttribute("moduleAction")) != null && sAction.length() != 0)) {
                                                sAction = "initialState";
                                            }
                                            if (sAction.equalsIgnoreCase("PluginDependency")) {
                                                htModules = ModuleManager.getModulesToInstall();
                                                sPackedModule = this.m_req.getParameter("selectedItems");
                                                this.m_req.setAttribute("selectedItems", (Object)sPackedModule);
                                                arrModules = eMFrameUtils.unpack(sPackedModule, this.m_context);
                                                LinkedHashSet<ModuleInfo> arrModulesSelected = new LinkedHashSet<ModuleInfo>();
                                                for (int i = 0; i < arrModules.length; ++i) {
                                                    moduleInfo = (ModuleInfo)htModules.get(arrModules[i]);
                                                    arrModulesSelected.add(moduleInfo);
                                                }
                                                if (arrModules.length == 0) {
                                                    this.setModules(htModules);
                                                    eMFrameUtils.setMessage("warning", eMFrameUtils.getLocalizedString("FwResources", "Warning", this.m_context), eMFrameUtils.getLocalizedString("FwResources", "ModulesToInstall.NoModulesSelected", this.m_context), this.m_context);
                                                    this.setUIPage("fw/ModulesToInstall.jsp");
                                                    return;
                                                }
                                                LinkedHashSet<ModuleInfo> availableSet = new LinkedHashSet<ModuleInfo>();
                                                LinkedHashSet notavailableSet = new LinkedHashSet();
                                                for (int i = 0; i < arrModules.length; ++i) {
                                                    Iterator iterator;
                                                    ModuleInfo moduleInfo2 = null;
                                                    if (!htModules.containsKey(arrModules[i])) continue;
                                                    moduleInfo2 = (ModuleInfo)htModules.get(arrModules[i]);
                                                    Hashtable temp_dependencies = FwUtils.getDependsonCriteria(moduleInfo2);
                                                    LinkedHashSet available = (LinkedHashSet)temp_dependencies.get("availablemodules");
                                                    LinkedHashSet notavailable = (LinkedHashSet)temp_dependencies.get("nonavailablemodules");
                                                    if (available != null) {
                                                        iterator = available.iterator();
                                                        while (iterator.hasNext()) {
                                                            ModuleInfo mInfo = (ModuleInfo)iterator.next();
                                                            availableSet.add(mInfo);
                                                        }
                                                    }
                                                    if (notavailable == null) continue;
                                                    iterator = notavailable.iterator();
                                                    while (iterator.hasNext()) {
                                                        Object element = iterator.next();
                                                        notavailableSet.add(element);
                                                    }
                                                }
                                                Set availabletodisplay = (Set)availableSet.clone();
                                                availabletodisplay.removeAll(arrModulesSelected);
                                                this.m_req.setAttribute("availableSet", (Object)availabletodisplay);
                                                this.m_req.setAttribute("notavailableSet", notavailableSet);
                                                String[] moduleList = new String[availableSet.size()];
                                                int k = 0;
                                                Iterator iterator = availableSet.iterator();
                                                while (iterator.hasNext()) {
                                                    ModuleInfo mInfo = (ModuleInfo)iterator.next();
                                                    moduleList[k++] = mInfo.getModuleID();
                                                }
                                                String sPackedModuletemp = eMFrameUtils.pack(moduleList, context);
                                                this.m_req.setAttribute("moduledependencies", (Object)sPackedModuletemp);
                                                if (moduleList.length == 1 || availabletodisplay.size() == 0 && notavailableSet.size() == 0) {
                                                    sAction = "LicenseAgreement";
                                                } else {
                                                    this.setUIPage("fw/PluginDependency.jsp");
                                                }
                                            } else if (sAction.equalsIgnoreCase("LicenseDisagreement")) {
                                                htModules = ModuleManager.getModulesToInstall();
                                                this.setModules(htModules);
                                                this.setUIPage("fw/ModulesToInstall.jsp");
                                            }
                                            if (sAction.equalsIgnoreCase("LicenseAgreement")) {
                                                sPackedModule = this.m_req.getParameter("selectedItems");
                                                this.m_req.setAttribute("selectedItems", (Object)sPackedModule);
                                                arrModules = eMFrameUtils.unpack(sPackedModule, this.m_context);
                                                if (arrModules.length == 0) {
                                                    htModules = ModuleManager.getModulesToInstall();
                                                    this.setModules(htModules);
                                                    eMFrameUtils.setMessage("warning", eMFrameUtils.getLocalizedString("FwResources", "Warning", this.m_context), eMFrameUtils.getLocalizedString("FwResources", "ModulesToInstall.NoModulesSelected", this.m_context), this.m_context);
                                                    this.setUIPage("fw/ModulesToInstall.jsp");
                                                    return;
                                                }
                                                htModules = ModuleManager.getModulesToInstall();
                                                boolean flag = false;
                                                for (int i = 0; i < arrModules.length; ++i) {
                                                    moduleInfo = null;
                                                    if (htModules.containsKey(arrModules[i])) {
                                                        moduleInfo = (ModuleInfo)htModules.get(arrModules[i]);
                                                    }
                                                    if (moduleInfo == null || moduleInfo.isLocal()) continue;
                                                    flag = true;
                                                    break;
                                                }
                                                if (!flag) {
                                                    sAction = "InstallModules";
                                                } else {
                                                    this.setUIPage("fw/PluginLicenseAgreement.jsp");
                                                }
                                            }
                                            if (!sAction.equalsIgnoreCase("InstallModules") && (!this.installing && !this.downLoading || !"true".equals(this.m_req.getParameter("taskComplete")))) break block53;
                                            if (fPackages == null) {
                                                fPackages = ModuleManager.getPackagesDir();
                                            }
                                            if (!fPackages.exists()) {
                                                fPackages.mkdirs();
                                            }
                                            D.log("Looking in Directory:  " + fPackages.getPath() + " for NPM files.");
                                            if (this.arrModules == null) {
                                                sPackedModule = this.m_req.getParameter("selectedItems");
                                                this.arrModules = eMFrameUtils.unpack(sPackedModule, this.m_context);
                                                Arrays.sort(this.arrModules, new Comparator(){

                                                    public int compare(Object o1, Object o2) {
                                                        if (o1.toString().startsWith("iMan26_") && o2.toString().startsWith("iMan26_")) {
                                                            return o1.toString().compareTo(o2.toString());
                                                        }
                                                        if (o1.toString().startsWith("iMan26_")) {
                                                            return 1;
                                                        }
                                                        if (o2.toString().startsWith("iMan26_")) {
                                                            return -1;
                                                        }
                                                        return o1.toString().compareTo(o2.toString());
                                                    }
                                                });
                                            }
                                            htModules = ModuleManager.getModulesToInstall();
                                            if (this.arrModules.length == 0) {
                                                this.setModules(htModules);
                                                eMFrameUtils.setMessage("warning", eMFrameUtils.getLocalizedString("FwResources", "Warning", this.m_context), eMFrameUtils.getLocalizedString("FwResources", "ModulesToInstall.NoModulesSelected", this.m_context), this.m_context);
                                                this.setUIPage("fw/ModulesToInstall.jsp");
                                                return;
                                            }
                                            if (!this.installing) {
                                                this.startModulesDownloadAndInstall(this.arrModules, htModules, fPackages, this.m_context);
                                                this.setUIPage("fw/AsyncProgress.jsp");
                                                this.installing = true;
                                                return;
                                            }
                                            this.installing = false;
                                            if (this.downLoadWorker.getContext().getErrorMsgs().size() > 0) {
                                                htModules = ModuleManager.getModulesToInstall();
                                                this.setModules(htModules);
                                                eMFrameUtils.setMessage("warning", eMFrameUtils.getLocalizedString("FwResources", "Warning", this.m_context), "Some of the selected NPM could not be installed!", this.m_context);
                                                this.setUIPage("fw/ModulesToInstall.jsp");
                                                return;
                                            }
                                            this.setUIPage("fw/ModulesToConfirm.jsp");
                                            this.m_req.setAttribute("ConfirmMessageTitle", (Object)eMFrameUtils.getLocalizedString("FwResources", "ModulesToInstall.ConfirmMessageTitle", this.m_context));
                                            this.m_req.setAttribute("ConfigureRBSMessage", (Object)eMFrameUtils.getLocalizedString("FwResources", "ModulesToInstall.ConfigureRBS", this.m_context));
                                            this.m_req.setAttribute("ConfirmMessage", (Object)eMFrameUtils.getLocalizedString("FwResources", "ModulesToInstall.ConfirmMessage", this.m_context));
                                            this.m_req.setAttribute("ConfirmBody", (Object)eMFrameUtils.getLocalizedString("FwResources", "ModulesToInstall.ConfirmBody", this.m_context));
                                            if (RBSUtil.isRBSInstalled(this.m_context)) {
                                                Registry.refreshInstallRegistry();
                                                this.m_req.setAttribute("RBSConfirmMessageTitle", (Object)eMFrameUtils.getLocalizedString("FwResources", "ModulesToInstall.RBSConfirmMessageTitle", this.m_context));
                                                this.m_req.setAttribute("RBSConfirmMessage", (Object)eMFrameUtils.formatMessage(eMFrameUtils.getLocalizedString("FwResources", "ModulesToInstall.RBSConfirmMessage", this.m_context), new String[]{"<A href=\"#\" onClick=\"loadRBSConfig();\"> " + eMFrameUtils.getLocalizedString("FwResources", "ModulesToInstall.RBSInstallLink", this.m_context) + "</A>"}));
                                            }
                                            ModuleManager.readModulesToInstall();
                                            ModuleManager.readModules();
                                            break block52;
                                        }
                                        if (!sAction.equalsIgnoreCase("Remove")) break block54;
                                        sPackedModule = this.m_req.getParameter("selectedItems");
                                        arrModules = eMFrameUtils.unpack(sPackedModule, this.m_context);
                                        if (arrModules.length == 0) {
                                            htModules = ModuleManager.getModulesToInstall();
                                            this.setModules(htModules);
                                            eMFrameUtils.setMessage("warning", eMFrameUtils.getLocalizedString("FwResources", "Warning", this.m_context), eMFrameUtils.getLocalizedString("FwResources", "ModulesToInstall.NoModulesSelected", this.m_context), this.m_context);
                                            this.setUIPage("fw/ModulesToInstall.jsp");
                                            return;
                                        }
                                        htModules = ModuleManager.getModulesToInstall();
                                        for (int i = 0; i < arrModules.length; ++i) {
                                            ModuleInfo moduleInfo = null;
                                            if (htModules.containsKey(arrModules[i])) {
                                                moduleInfo = (ModuleInfo)htModules.get(arrModules[i]);
                                            }
                                            String sFileName = moduleInfo.getFilename();
                                            if (!moduleInfo.isLocal()) {
                                                eMFrameUtils.setMessage("warning", eMFrameUtils.getLocalizedString("FwResources", "Warning", this.m_context), eMFrameUtils.getLocalizedString("FwResources", "ModulesToInstall.CannotRemoveMessage", this.m_context), this.m_context);
                                                continue;
                                            }
                                            ModuleManager.moveModuleToDeleted(sFileName);
                                        }
                                        ModuleManager.readModulesToInstall();
                                        htModules = ModuleManager.getModulesToInstall();
                                        this.setModules(htModules);
                                        this.setUIPage("fw/ModulesToInstall.jsp");
                                        break block52;
                                    }
                                    if (!sAction.equalsIgnoreCase("Refresh")) break block55;
                                    htModules = this.initialState(true);
                                    break block52;
                                }
                                if (!sAction.equalsIgnoreCase("initialState")) break block56;
                                htModules = this.initialState(false);
                                break block52;
                            }
                            if (!sAction.equalsIgnoreCase("SelectModulesToCopy")) break block57;
                            this.setUIPage("fw/ModulesToCopy.jsp");
                            htModules = ModuleManager.getModulesToInstall();
                            D.log("Get Selected Modules To Copy... ");
                            break block52;
                        }
                        if (!sAction.equalsIgnoreCase("CopyModule")) break block58;
                        meetsCriteria = true;
                        selectedModule = this.m_req.getParameter("NPMFileName");
                        if (null != selectedModule || selectedModule.length() != 0) {
                            String tempDirPath = this.m_context.getWebappHome() + "/packages";
                            File tempDir = new File(tempDirPath);
                            if (!tempDir.exists()) {
                                tempDir.mkdirs();
                            }
                            try {
                                ((FwRequest)this.m_req).parseMultipartRequest(tempDir.getAbsolutePath());
                            }
                            catch (Exception e) {
                                D.log("parseMultipartFormData() has thrown an exception, IIS has a problem with larger files!\n" + e);
                                eMFrameUtils.setMessage("error", eMFrameUtils.getLocalizedString("FwResources", "Error", this.m_context), eMFrameUtils.formatMessage(eMFrameUtils.getLocalizedString("FwResources", "ModulesToInstall.CannotCopy", this.m_context), new String[]{selectedModule}), this.m_context);
                            }
                        }
                        if (null != selectedModule && selectedModule.length() != 0 && selectedModule.endsWith(".npm")) break block59;
                        eMFrameUtils.setMessage("error", eMFrameUtils.getLocalizedString("FwResources", "Error", this.m_context), eMFrameUtils.getLocalizedString("FwResources", "ModulesToInstall.InvalidModulesSelected", this.m_context), this.m_context);
                        if (null == selectedModule || selectedModule.endsWith(".npm")) break block60;
                        File selectedFile = new File(selectedModule);
                        File badFile = null;
                        badFile = new File(this.m_context.getWebappHome() + "/packages/" + selectedFile.getName());
                        if (badFile != null) {
                            badFile.delete();
                        }
                        break block60;
                    }
                    String selectedModuleName = new File(selectedModule).getName();
                    if (selectedModuleName.indexOf(":\\") != -1) {
                        selectedModuleName = selectedModuleName.substring(selectedModuleName.lastIndexOf("\\") + 1);
                    }
                    String[] strTokens = selectedModuleName.split(".npm");
                    String dirPath = this.m_context.getWebappHome() + "/packages";
                    int i = 1;
                    while (true) {
                        File sModule = new File(dirPath + File.separator + strTokens[0] + i + ".npm");
                        if (i == 1 && !sModule.exists()) {
                            copiedModuleName = selectedModuleName;
                            break;
                        }
                        if (!sModule.exists()) {
                            copiedModuleName = strTokens[0] + --i + ".npm";
                            break;
                        }
                        ++i;
                    }
                    ModuleInfo mInfo = new ModuleInfo();
                    ModuleManager.getNPMInfo(this.m_context.getWebappHome() + "/packages" + File.separator + copiedModuleName, mInfo);
                    VersionInfo copiedModuleVersion = new VersionInfo(mInfo.getModuleVersion());
                    meetsCriteria = FwUtils.doesModuleMeetCriteria(mInfo, new VersionInfo(ModuleManager.getiManagerVersion()), System.getProperty("os.name").toLowerCase(), FwUtils.getiManagerPlatform());
                    boolean isPluginVersionDiscardWarnMsg = false;
                    htModules = ModuleManager.getModulesToInstall();
                    Enumeration enumModuleIDs = htModules.keys();
                    while (enumModuleIDs.hasMoreElements()) {
                        String sKey = (String)enumModuleIDs.nextElement();
                        if (!mInfo.getModuleID().equalsIgnoreCase(sKey)) continue;
                        ModuleInfo htModuleInfo = (ModuleInfo)htModules.get(sKey);
                        VersionInfo htModuleVersion = new VersionInfo(htModuleInfo.getModuleVersion());
                        if (copiedModuleVersion.compareTo(htModuleVersion) >= 0 || !meetsCriteria) break;
                        isPluginVersionDiscardWarnMsg = true;
                        eMFrameUtils.setMessage("warning", eMFrameUtils.getLocalizedString("FwResources", "Warning", this.m_context), eMFrameUtils.getLocalizedString("FwResources", "PluginNotUpdatedVersion", this.m_context), this.m_context);
                        break;
                    }
                    if (!isPluginVersionDiscardWarnMsg) {
                        htModules = ModuleManager.getAllInstalledModules();
                        Enumeration enumInstalledModuleIDs = htModules.keys();
                        while (enumInstalledModuleIDs.hasMoreElements()) {
                            String sKey = (String)enumInstalledModuleIDs.nextElement();
                            if (!mInfo.getModuleID().equalsIgnoreCase(sKey)) continue;
                            ModuleInfo htModuleInfo = (ModuleInfo)htModules.get(sKey);
                            VersionInfo htModuleVersion = new VersionInfo(htModuleInfo.getModuleVersion());
                            if (copiedModuleVersion.compareTo(htModuleVersion) >= 0 || !meetsCriteria) break;
                            eMFrameUtils.setMessage("warning", eMFrameUtils.getLocalizedString("FwResources", "Warning", this.m_context), eMFrameUtils.getLocalizedString("FwResources", "PluginNotUpdatedVersionCompareToAlreadyInstalledOne", this.m_context), this.m_context);
                            break;
                        }
                    }
                }
                this.setUIPage("fw/ModulesToInstall.jsp");
                ModuleManager.readModulesToInstall();
                if (!meetsCriteria) {
                    eMFrameUtils.setMessage("warning", eMFrameUtils.getLocalizedString("FwResources", "Warning", this.m_context), eMFrameUtils.getLocalizedString("FwResources", "PluginNotAdded", this.m_context), this.m_context);
                    ModuleManager.setMeetsCriteria(true);
                }
                htModules = ModuleManager.getModulesToInstall();
                this.setModules(htModules);
                this.m_req.setAttribute("moduleaction", (Object)"Refresh");
                D.log("Copying Selected Module: " + selectedModule);
                break block52;
            }
            if (sAction.equalsIgnoreCase("AfterRBSIsInstalled")) {
                D.log("RBS is installed or has been closed and control is back to ModulesToInstall.java");
                this.setUIPage("fw/ModulesToConfirm.jsp");
                this.m_req.setAttribute("ConfirmBody", (Object)eMFrameUtils.getLocalizedString("FwResources", "ModulesToInstall.LastConfirmBody", this.m_context));
                this.m_req.setAttribute("RBSConfirmMessageTitle", (Object)eMFrameUtils.getLocalizedString("FwResources", "ModulesToInstall.LastConfirmMessageTitle", this.m_context));
                this.m_req.setAttribute("RBSConfirmMessage", (Object)eMFrameUtils.getLocalizedString("FwResources", "ModulesToInstall.LastConfirmMessage", this.m_context));
            } else if (sAction.equalsIgnoreCase("ShowInfo")) {
                String xmlname = this.m_req.getParameter("xmlname");
                StringBuffer str = new StringBuffer();
                ReadXml readxml = new ReadXml();
                URL hp = null;
                URLConnection hpCon = null;
                try {
                    int c;
                    hp = new URL(xmlname);
                    hpCon = hp.openConnection();
                    InputStream input = null;
                    input = hpCon.getInputStream();
                    InputStreamReader isr = new InputStreamReader(input);
                    BufferedReader inReader = new BufferedReader(isr);
                    while ((c = ((Reader)inReader).read()) != -1) {
                        str.append((char)c);
                    }
                    input.close();
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
                try {
                    String str1 = str.toString();
                    readxml.setcontext(this.m_context);
                    readxml.read(str1);
                }
                catch (Exception e) {
                    D.log("Exception" + e + "was encountered");
                }
                this.m_req.setAttribute("misc", (Object)readxml.getMisc());
                this.m_req.setAttribute("supportedplatforms", (Object)readxml.getSupportedPlatforms());
                this.m_req.setAttribute("recommendedversions", (Object)readxml.getRecommendedVersions());
                this.m_req.setAttribute("changelog", (Object)readxml.getChangeLog());
                this.m_req.setAttribute("specialinstructions", (Object)readxml.getSpecialInstructions());
                this.m_req.setAttribute("dependencies", (Object)readxml.getDependencies());
                this.setUIPage("fw/ShowPluginInfo.jsp");
                D.log("Show Information... ");
            }
        }
    }

    public Hashtable initialState(boolean restCache) {
        this.setUIPage("fw/ModulesToInstall.jsp");
        ModuleManager.resetCache(restCache);
        try {
            SystemConfig config = SystemConfig.getSystemConfig(this.m_context);
            String sDownloadURL = config.getSetting("ModuleDownloadDescriptorURL", "http://www.novell.com/products/consoles/imanager/iman_mod_desc.xml");
            config.setSetting("ModuleDownloadDescriptorURL", sDownloadURL);
            String whichShouldDownload = SystemConfigManager.getSingleSetting(null, "WhichModuleToDownload", "All");
            SystemConfigManager.setSetting(null, "WhichModuleToDownload", whichShouldDownload);
            config.writeSettings();
        }
        catch (Exception e) {
            D.log(e);
        }
        ModuleManager.readModulesToInstall();
        Hashtable htModules = ModuleManager.getModulesToInstall();
        this.setModules(htModules);
        return htModules;
    }

    public void processSecondaryGadgetResults(HttpServletRequest req, GadgetInstance secondaryGadgetInstance, String status, Object results) {
        D.log("processSecondaryGadgetResults is called after returning from RBS Install.");
        req.setAttribute("moduleaction", (Object)"AfterRBSIsInstalled");
    }

    private void startModulesDownloadAndInstall(String[] arrModules, Map htModules, File fPackagesDir, MContext context) {
        List<String> modulesToInstall = Arrays.asList(arrModules);
        this.downLoadWorker = new DownloadAndInstallWorker(modulesToInstall, htModules, fPackagesDir, context);
        AsyncProgressFormat format = new AsyncProgressFormat();
        format.setTitle(eMFrameUtils.getLocalizedString("FwResources", "ModulesToInstall.ModulesToInstall", context));
        format.setIconUrl("dir/object16.gif");
        format.setNumberOfObjectsUpdatedKey("RBS.NumberModulesUpdated");
        format.setInterruptedMsg(eMFrameUtils.getLocalizedString("FwResources", "RBS.InstallModuleRequestAbortedInfo", context));
        FwAsyncUtils.startAsyncWorker(this.downLoadWorker, format, context);
    }

    public static void shouldRun(HttpServletRequest req, String sServiceName) throws Exception {
        MTask.shouldRun(req, sServiceName);
        if (!FwUtils.canConfigureiManager(req)) {
            MContext context = FwUtils.getMContext(req);
            throw new Exception(eMFrameUtils.getLocalizedString("FwResources", "Configure.UserNotAuthorizedToConfigureiManager", context));
        }
    }

    private void setModules(Hashtable htModules) {
        ArrayList<ModuleInfo> ar = new ArrayList<ModuleInfo>();
        if (htModules != null) {
            Collection modCollection = htModules.values();
            Iterator iter = modCollection.iterator();
            while (iter.hasNext()) {
                ar.add((ModuleInfo)iter.next());
            }
        }
        Collections.sort(ar, new ModuleInfoCompare(this.m_context));
        this.m_req.setAttribute("ModulesToInstall", ar);
    }

    public class ModuleInfoCompare
    implements Comparator {
        Collator m_collator = null;

        public ModuleInfoCompare(MContext context) {
            this.m_collator = Collator.getInstance(context.getLocale());
        }

        public int compare(Object obj1, Object obj2) {
            ModuleInfo mInfo1 = (ModuleInfo)obj1;
            String str1 = mInfo1.getModuleTitle();
            ModuleInfo mInfo2 = (ModuleInfo)obj2;
            String str2 = mInfo2.getModuleTitle();
            return this.m_collator.compare(str1, str2);
        }
    }
}

