/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.fw;

import com.novell.application.console.snapin.ObjectEntry;
import com.novell.emframe.dev.D;
import com.novell.emframe.dev.PluginContext;
import com.novell.emframe.dev.Task;
import com.novell.emframe.dev.TaskContext;
import com.novell.emframe.dev.eMFrameUtils;
import com.novell.emframe.fw.FwUtils;
import com.novell.emframe.fw.InstallXMLInfo;
import com.novell.emframe.fw.RBSUtil;
import com.novell.emframe.fw.util.eMFrameComponentInstall;
import com.novell.nps.utils.Utils;
import java.util.ArrayList;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import org.jdom.Document;

public class NotInstalledModules
extends Task {
    private static final long serialVersionUID = 1L;
    private TaskContext m_context;
    private Properties m_resultStrings;
    private ObjectEntry m_treeOE;
    private HttpServletRequest m_req;
    private InstallXMLInfo[] m_installInfo;
    private ArrayList m_errors = new ArrayList();
    private InstallThread installThread;
    private boolean m_stopThread;
    private boolean m_threadDone;
    private String m_mainProgressMessage = "";
    private String m_alreadyMessage = "";
    private String m_abortMessage = "";
    private boolean m_err = false;
    private String m_collectionName;
    private int m_modulesNotInstalled = 0;
    private int m_totalModulesCount = 0;
    private int m_installingCount = 0;
    private boolean m_reinstallModule = false;

    public boolean execute(TaskContext context, Properties resultStrings) {
        this.m_context = context;
        this.m_resultStrings = resultStrings;
        this.m_treeOE = RBSUtil.getTreeOE(this.m_context);
        this.m_req = this.m_context.getRequest();
        String nextState = this.m_req.getParameter("nextState");
        if (nextState == null || nextState.equals("initialState")) {
            return this.initialState();
        }
        if (nextState.equalsIgnoreCase("refresh")) {
            return this.refresh();
        }
        if (nextState.equalsIgnoreCase("cancel")) {
            return this.cancel();
        }
        if (nextState.equalsIgnoreCase("finished")) {
            return this.finished();
        }
        return true;
    }

    public boolean initialState() {
        InstallXMLInfo[] installXMLInfo;
        String moduleListPacked;
        String[] moduleList;
        this.m_collectionName = this.m_req.getParameter("selectedCollectionNameModule");
        String[] collections = eMFrameUtils.unpack(this.m_collectionName, this.m_context);
        this.m_collectionName = collections[0];
        String reinstallModule = this.m_req.getParameter("reinstallModule");
        if (reinstallModule != null && reinstallModule.equalsIgnoreCase("true")) {
            this.m_reinstallModule = true;
        }
        if ((moduleList = eMFrameUtils.unpack(moduleListPacked = this.m_req.getParameter("ModuleListPacked"), this.m_context)).length > 0 && (installXMLInfo = (InstallXMLInfo[])this.m_context.getAuthAttribute("InstallXMLInfo")) != null) {
            this.m_installInfo = new InstallXMLInfo[moduleList.length];
            int count = 0;
            for (int i = 0; i < installXMLInfo.length; ++i) {
                for (int index = 0; index < moduleList.length; ++index) {
                    String moduleName = moduleList[index];
                    if (!moduleName.equalsIgnoreCase(installXMLInfo[i].getModuleName())) continue;
                    this.m_installInfo[index] = installXMLInfo[i];
                    ++count;
                    break;
                }
                if (count == moduleList.length) break;
            }
        }
        if (this.m_installInfo != null) {
            this.m_mainProgressMessage = this.m_reinstallModule ? eMFrameUtils.getLocalizedString("FwResources", "RBS.ReinstallingModules", this.m_context.getLocale()) : eMFrameUtils.getLocalizedString("FwResources", "RBS.InstallingModules", this.m_context.getLocale());
            this.m_abortMessage = eMFrameUtils.getLocalizedString("FwResources", "RBS.AbortStop", this.m_context.getLocale());
            this.m_totalModulesCount = this.m_installInfo.length;
            this.m_alreadyMessage = eMFrameUtils.getLocalizedString("FwResources", "RBS.Initializing", this.m_context.getLocale());
            String url = new String("webacc?taskId=" + eMFrameUtils.urlEncode(this.m_req.getParameter("taskId"), this.m_context) + "&merge=fw.GenericProgress&User.context=" + this.m_req.getParameter("User.context") + "&nextState=refresh" + "&progressCount=" + "" + "&mainProgressMessage=" + this.m_mainProgressMessage + "&alreadyMessage=" + this.m_alreadyMessage + "&abortMessage=" + this.m_abortMessage);
            this.m_resultStrings.put("UrlTask.url", url);
            Utils.setMergeTemplate((PluginContext)this.m_context, (String)"fw.UrlTask");
            this.m_stopThread = false;
            this.m_threadDone = false;
            this.installThread = new InstallThread();
            this.installThread.start();
        }
        return true;
    }

    private boolean refresh() {
        String taskId = this.m_req.getParameter("taskId");
        String userContext = this.m_req.getParameter("User.context");
        if (!this.m_threadDone) {
            this.m_resultStrings.put("progressCount", "");
            if (this.m_installingCount == 0) {
                this.m_alreadyMessage = eMFrameUtils.getLocalizedString("FwResources", "RBS.Initializing", this.m_context.getLocale());
            } else {
                Object[] values = new String[]{Integer.toString(this.m_installingCount), Integer.toString(this.m_totalModulesCount)};
                this.m_alreadyMessage = this.m_reinstallModule ? eMFrameUtils.formatMessage(eMFrameUtils.getLocalizedString("FwResources", "RBS.ReinstallingModuleNumber", this.m_context.getLocale()), values) : eMFrameUtils.formatMessage(eMFrameUtils.getLocalizedString("FwResources", "RBS.InstallingModuleNumber", this.m_context.getLocale()), values);
            }
            this.m_resultStrings.put("mainProgressMessage", this.m_mainProgressMessage);
            this.m_resultStrings.put("alreadyMessage", this.m_alreadyMessage);
            this.m_resultStrings.put("abortMessage", this.m_abortMessage);
        } else {
            String url = new String("webacc?taskId=" + eMFrameUtils.urlEncode(taskId, this.m_context) + "&User.context=" + userContext + "&nextState=finished");
            url = this.m_err ? url + "&merge=dev.MooGenErr&GeneralMsg.Mode=error" : url + "&merge=dev.GenMsg&GeneralMsg.Mode=success&dev.refreshOV=true";
            this.m_resultStrings.put("UrlTask.url", url);
            Utils.setMergeTemplate((PluginContext)this.m_context, (String)"fw.UrlTask");
        }
        return true;
    }

    private boolean cancel() {
        String strBody;
        String strTitle;
        this.m_stopThread = true;
        if (this.m_reinstallModule) {
            strTitle = eMFrameUtils.getLocalizedString("FwResources", "RBS.ReinstallModuleRequestAborted", this.m_context.getLocale());
            strBody = "\n" + eMFrameUtils.getLocalizedString("FwResources", "RBS.NumberModulesReinstalled", this.m_context.getLocale()) + "\n";
        } else {
            strTitle = eMFrameUtils.getLocalizedString("FwResources", "RBS.InstallModuleRequestAborted", this.m_context.getLocale());
            strBody = "\n" + eMFrameUtils.getLocalizedString("FwResources", "RBS.NumberModulesInstalled", this.m_context.getLocale()) + "\n";
        }
        Object[] values = new String[]{Integer.toString(this.m_installingCount), Integer.toString(this.m_totalModulesCount)};
        eMFrameUtils.setMessage("success", strTitle, eMFrameUtils.formatMessage(strBody, values), this.m_context);
        return true;
    }

    private boolean finished() {
        if (this.m_err) {
            String strBody;
            String strTitle;
            if (this.m_reinstallModule) {
                strTitle = eMFrameUtils.getLocalizedString("FwResources", "RBS.ReinstallModuleRequestError", this.m_context.getLocale());
                strBody = "\n" + eMFrameUtils.getLocalizedString("FwResources", "RBS.NumberModulesReinstalled", this.m_context.getLocale()) + "\n" + eMFrameUtils.getLocalizedString("FwResources", "RBS.ModulesNotReinstalled", this.m_context.getLocale());
            } else {
                strTitle = eMFrameUtils.getLocalizedString("FwResources", "RBS.InstallModuleRequestError", this.m_context.getLocale());
                strBody = "\n" + eMFrameUtils.getLocalizedString("FwResources", "RBS.NumberModulesInstalled", this.m_context.getLocale()) + "\n" + eMFrameUtils.getLocalizedString("FwResources", "RBS.ModulesNotInstalled", this.m_context.getLocale());
            }
            Object[] values = new String[]{Integer.toString(this.m_totalModulesCount - this.m_modulesNotInstalled), Integer.toString(this.m_totalModulesCount)};
            eMFrameUtils.setMooErrorMessage(this.m_resultStrings, strTitle, eMFrameUtils.formatMessage(strBody, values), this.m_errors);
        } else {
            String strBody;
            String strTitle;
            if (this.m_reinstallModule) {
                strTitle = eMFrameUtils.getLocalizedString("FwResources", "RBS.ReinstallModuleRequestSucceeded", this.m_context.getLocale());
                strBody = "\n" + eMFrameUtils.getLocalizedString("FwResources", "RBS.NumberModulesReinstalled", this.m_context.getLocale()) + "\n";
            } else {
                strTitle = eMFrameUtils.getLocalizedString("FwResources", "RBS.InstallModuleRequestSucceeded", this.m_context.getLocale());
                strBody = "\n" + eMFrameUtils.getLocalizedString("FwResources", "RBS.NumberModulesInstalled", this.m_context.getLocale()) + "\n";
            }
            Object[] values = new String[]{Integer.toString(this.m_installingCount), Integer.toString(this.m_totalModulesCount)};
            eMFrameUtils.setMessage("success", strTitle, eMFrameUtils.formatMessage(strBody, values), this.m_context);
        }
        return true;
    }

    private void doInstall() {
        this.m_errors.clear();
        String dynamicGroupSearchType = FwUtils.getDynamicSearchType(this.m_context);
        for (int index = 0; index < this.m_installInfo.length && !this.m_stopThread; ++index) {
            this.m_installingCount = index + 1;
            eMFrameComponentInstall installer = new eMFrameComponentInstall(this.m_treeOE, this.m_context);
            String[] xmlFiles = this.m_installInfo[index].getFilePaths();
            Document doc = this.m_installInfo[index].getDocument();
            try {
                installer.installPlugin(this.m_collectionName, xmlFiles, dynamicGroupSearchType, doc, this.m_reinstallModule);
                continue;
            }
            catch (Exception exc) {
                D.log(exc);
                this.m_err = true;
                ++this.m_modulesNotInstalled;
                exc.printStackTrace();
                if (this.m_reinstallModule) {
                    this.m_errors.add(new String[]{this.m_installInfo[index].getDisplayName(), eMFrameUtils.getLocalizedString("FwResources", "RBS.ReinstallModuleRequestFailed", this.m_context.getLocale()), eMFrameUtils.getExceptionMessage(exc, this.m_context), ""});
                    continue;
                }
                this.m_errors.add(new String[]{this.m_installInfo[index].getDisplayName(), eMFrameUtils.getLocalizedString("FwResources", "RBS.InstallModuleRequestFailed", this.m_context.getLocale()), eMFrameUtils.getExceptionMessage(exc, this.m_context), ""});
            }
        }
    }

    class InstallThread
    extends Thread {
        public InstallThread() {
            this.setPriority(4);
            this.setDaemon(true);
        }

        public void run() {
            NotInstalledModules.this.doInstall();
            NotInstalledModules.this.m_threadDone = true;
        }
    }
}

