/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.fw;

import com.novell.admin.common.exceptions.SPIException;
import com.novell.admin.ns.AdminNamespace;
import com.novell.admin.ns.FilterResultModifier;
import com.novell.admin.ns.nds.NDSNamespace;
import com.novell.admin.ns.nds.ObjectFlags;
import com.novell.application.console.snapin.BrowserObjectEntryEnumeration;
import com.novell.application.console.snapin.DefaultIndexedObjectEntryEnumeration;
import com.novell.application.console.snapin.ObjectEntry;
import com.novell.application.console.snapin.ObjectEntryEnumeration;
import com.novell.application.console.snapin.ObjectType;
import com.novell.application.console.snapin.ResultModifier;
import com.novell.application.console.snapin.ResultModifierFilterEntry;
import com.novell.application.console.snapin.SnapinException;
import com.novell.emframe.dev.AuthBrokerException;
import com.novell.emframe.dev.AuthenticationBroker;
import com.novell.emframe.dev.D;
import com.novell.emframe.dev.DirUtils;
import com.novell.emframe.dev.MContext;
import com.novell.emframe.dev.Task;
import com.novell.emframe.dev.TaskContext;
import com.novell.emframe.dev.XmlUtils;
import com.novell.emframe.dev.eMFrameUtils;
import com.novell.emframe.fw.FwDirUtils;
import com.novell.emframe.fw.FwUtils;
import com.novell.emframe.fw.RoleList;
import com.novell.emframe.fw.SearchObjectContext;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ObjectView
extends Task {
    private static final long serialVersionUID = 1L;
    public static final String OV_START_PARAM = "OV.Start";
    public static final String SEARCH_CMD_CONTEXTID = "Search.ContextId";
    public static final String SEARCH_CMD_MOVEMENT = "Movement";
    public static final String SEARCH_CMD_PARENTCONTAINER = "Search.ParentContainer";
    public static final String SEARCH_CMD_PSEUDOOBJECTS = "Search.PseudoObjects";
    public static final String SEARCH_CMD_SHOWRESULTSET = "Search.ShowResultSet";
    public static final String SEARCH_CMD_TOKEN_PARAM = "SearchToken";
    public static final String SEARCH_CMD_TREENAME = "Search.TreeName";
    public static final String SEARCH_MOVEMENT_NEXT = "Next";
    public static final String SEARCH_MOVEMENT_PREV = "Prev";
    public static final String SEARCH_TOKEN_INIT = "SearchTokenInit";
    public static final String SEARCH_TOKEN_POST = "SearchTokenPost";
    public static final String SEARCH_TOKEN_UPDATE = "SearchTokenUpdate";
    public static final String SEARCH_TOKEN_SELECT_ALL = "SearchTokenSelectAll";
    public static final String SEARCH_TOKEN_RESTART = "SearchTokenRestart";
    private static final int DEFAULT_ENTRIES_PER_PAGECOUNT = 100;
    private static final int MAX_ENTRIES_PER_PAGECOUNT = 500;
    private String m_strContainer;
    private boolean m_bCurrentContextSelectable;
    private boolean m_bMovementPrev;
    private String m_strNameFilter;
    private String[] m_arStrTypeFilter;
    private String m_strTypeFilter;
    private HashSet m_hsTypeFilter;
    private HashSet m_hsAuxTypeFilterEntries;
    private Hashtable m_hAdvSelCriterion;
    private String m_selectedType;
    private boolean m_bSearchOnStartup;
    private boolean m_bSearchSubContainers;
    private boolean m_bShowAuxClasses;
    private boolean m_bShowSubClasses;
    private boolean m_bShowGlue;
    private boolean m_bRootSelectable;
    private boolean m_bThisSelectable;
    private boolean m_bPublicSelectable;
    private boolean m_bBrowseMode;
    private boolean m_bTreeMode;
    private boolean m_bExcludeMode;
    private boolean m_bMatchAllTypes;
    private boolean m_bMatchAllContainers;
    private boolean m_bMatchLeafObjects;
    private boolean m_bMatchNonPartitionedContainers;
    private boolean m_bMatchAllPartitions;
    private boolean m_bMultiSelect;
    private boolean m_bAdvancedSelection;
    private int m_iMaxEntriesPerPage;
    private int m_iNumPseudoObjects;
    private String m_strContextId;
    private String m_strCmdToken;
    private TaskContext m_taskContext;
    private Properties m_resultStrings;
    private HttpServletRequest m_req;
    private AdminNamespace m_namespace;
    private ObjectEntry m_treeOE;
    private String m_PostError;
    private boolean m_showSubordinateCount;
    private boolean m_bShowFileSystemDirectory;
    private boolean m_bShowFileSystemFile;
    private boolean m_bFileSystemBrowseVolume;
    private boolean m_bShowVolumeObjectForFileSystem;
    private boolean m_bDojoGetChildren = false;
    static int uniqueStringCtr = 1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(TaskContext context, Properties resultStrings) {
        boolean bl;
        boolean bPostSuccess;
        boolean bRet;
        block38: {
            block37: {
                block36: {
                    block35: {
                        D.log("--->>> ObjectView: entering execute....");
                        bRet = false;
                        bPostSuccess = false;
                        if (context != null && resultStrings != null) break block35;
                        D.log("OV: context or resultString == null");
                        boolean bl2 = bRet;
                        Object var10_8 = null;
                        D.log("<<<--- OV: exiting execute, cache size = " + context.getAuthenticator().getAuthContext().size() + ", returning " + bRet);
                        if (!bRet) {
                            String errMsgTitle = null;
                            String errMsgDesc = null;
                            if (!bPostSuccess) {
                                errMsgTitle = eMFrameUtils.getLocalizedString("FwResources", "OV.DirectorySearchErrorTitle", context);
                                errMsgDesc = this.m_PostError;
                            } else {
                                errMsgTitle = eMFrameUtils.getLocalizedString("FwResources", "OV.InternalErrorTitle", context);
                                errMsgDesc = eMFrameUtils.getLocalizedString("FwResources", "OV.InternalErrorDesc", context);
                            }
                            this.m_resultStrings.setProperty("GeneralMsg.suppressButtons", "true");
                            eMFrameUtils.setMessage("error", errMsgTitle, errMsgDesc, context);
                        }
                        this.m_resultStrings = null;
                        this.m_taskContext = null;
                        return bl2;
                    }
                    this.m_resultStrings = resultStrings;
                    this.m_taskContext = context;
                    AuthenticationBroker broker = context.getAuthenticationBroker();
                    this.m_treeOE = (ObjectEntry)broker.getProtocolObject("AdminNamespace");
                    this.m_namespace = this.m_treeOE.getAdminNamespace();
                    String treeName = this.m_treeOE.getName();
                    if (!this.isStrValid(treeName)) {
                        treeName = "[root]";
                    }
                    this.m_resultStrings.put(SEARCH_CMD_TREENAME, treeName);
                    this.m_req = this.m_taskContext.getRequest();
                    if (this.m_req != null) break block36;
                    D.log("OV:  Http request == null");
                    boolean bl3 = bRet;
                    Object var10_9 = null;
                    D.log("<<<--- OV: exiting execute, cache size = " + context.getAuthenticator().getAuthContext().size() + ", returning " + bRet);
                    if (!bRet) {
                        String errMsgTitle = null;
                        String errMsgDesc = null;
                        if (!bPostSuccess) {
                            errMsgTitle = eMFrameUtils.getLocalizedString("FwResources", "OV.DirectorySearchErrorTitle", context);
                            errMsgDesc = this.m_PostError;
                        } else {
                            errMsgTitle = eMFrameUtils.getLocalizedString("FwResources", "OV.InternalErrorTitle", context);
                            errMsgDesc = eMFrameUtils.getLocalizedString("FwResources", "OV.InternalErrorDesc", context);
                        }
                        this.m_resultStrings.setProperty("GeneralMsg.suppressButtons", "true");
                        eMFrameUtils.setMessage("error", errMsgTitle, errMsgDesc, context);
                    }
                    this.m_resultStrings = null;
                    this.m_taskContext = null;
                    return bl3;
                }
                D.log("OV: Cache size = " + context.getAuthenticator().getAuthContext().size());
                if (this.m_namespace != null) break block37;
                D.log("OV:  AdminNamespace not found.");
                boolean bl4 = bRet;
                Object var10_10 = null;
                D.log("<<<--- OV: exiting execute, cache size = " + context.getAuthenticator().getAuthContext().size() + ", returning " + bRet);
                if (!bRet) {
                    String errMsgTitle = null;
                    String errMsgDesc = null;
                    if (!bPostSuccess) {
                        errMsgTitle = eMFrameUtils.getLocalizedString("FwResources", "OV.DirectorySearchErrorTitle", context);
                        errMsgDesc = this.m_PostError;
                    } else {
                        errMsgTitle = eMFrameUtils.getLocalizedString("FwResources", "OV.InternalErrorTitle", context);
                        errMsgDesc = eMFrameUtils.getLocalizedString("FwResources", "OV.InternalErrorDesc", context);
                    }
                    this.m_resultStrings.setProperty("GeneralMsg.suppressButtons", "true");
                    eMFrameUtils.setMessage("error", errMsgTitle, errMsgDesc, context);
                }
                this.m_resultStrings = null;
                this.m_taskContext = null;
                return bl4;
            }
            String startParam = this.m_req.getParameter(OV_START_PARAM);
            if (startParam == null || !startParam.equalsIgnoreCase("true")) break block38;
            boolean bl5 = bRet = this.startOV();
            Object var10_11 = null;
            D.log("<<<--- OV: exiting execute, cache size = " + context.getAuthenticator().getAuthContext().size() + ", returning " + bRet);
            if (!bRet) {
                String errMsgTitle = null;
                String errMsgDesc = null;
                if (!bPostSuccess) {
                    errMsgTitle = eMFrameUtils.getLocalizedString("FwResources", "OV.DirectorySearchErrorTitle", context);
                    errMsgDesc = this.m_PostError;
                } else {
                    errMsgTitle = eMFrameUtils.getLocalizedString("FwResources", "OV.InternalErrorTitle", context);
                    errMsgDesc = eMFrameUtils.getLocalizedString("FwResources", "OV.InternalErrorDesc", context);
                }
                this.m_resultStrings.setProperty("GeneralMsg.suppressButtons", "true");
                eMFrameUtils.setMessage("error", errMsgTitle, errMsgDesc, context);
            }
            this.m_resultStrings = null;
            this.m_taskContext = null;
            return bl5;
        }
        try {
            bRet = true;
            this.parseParameters();
            this.performInit();
            if (this.m_strCmdToken.compareTo(SEARCH_TOKEN_POST) == 0) {
                this.m_PostError = null;
                bRet = bPostSuccess = this.performPost();
            } else if (this.m_strCmdToken.compareTo(SEARCH_TOKEN_UPDATE) == 0) {
                this.performUpdate();
            } else if (this.m_strCmdToken.compareTo(SEARCH_TOKEN_RESTART) == 0) {
                this.performRestart();
            }
            bl = bRet;
            Object var10_12 = null;
        }
        catch (AuthBrokerException e) {
            boolean bl6;
            try {
                D.log(e);
                bl6 = bRet;
                Object var10_13 = null;
            }
            catch (Throwable throwable) {
                Object var10_14 = null;
                D.log("<<<--- OV: exiting execute, cache size = " + context.getAuthenticator().getAuthContext().size() + ", returning " + bRet);
                if (!bRet) {
                    String errMsgTitle = null;
                    String errMsgDesc = null;
                    if (!bPostSuccess) {
                        errMsgTitle = eMFrameUtils.getLocalizedString("FwResources", "OV.DirectorySearchErrorTitle", context);
                        errMsgDesc = this.m_PostError;
                    } else {
                        errMsgTitle = eMFrameUtils.getLocalizedString("FwResources", "OV.InternalErrorTitle", context);
                        errMsgDesc = eMFrameUtils.getLocalizedString("FwResources", "OV.InternalErrorDesc", context);
                    }
                    this.m_resultStrings.setProperty("GeneralMsg.suppressButtons", "true");
                    eMFrameUtils.setMessage("error", errMsgTitle, errMsgDesc, context);
                }
                this.m_resultStrings = null;
                this.m_taskContext = null;
                throw throwable;
            }
            D.log("<<<--- OV: exiting execute, cache size = " + context.getAuthenticator().getAuthContext().size() + ", returning " + bRet);
            if (!bRet) {
                String errMsgTitle = null;
                String errMsgDesc = null;
                if (!bPostSuccess) {
                    errMsgTitle = eMFrameUtils.getLocalizedString("FwResources", "OV.DirectorySearchErrorTitle", context);
                    errMsgDesc = this.m_PostError;
                } else {
                    errMsgTitle = eMFrameUtils.getLocalizedString("FwResources", "OV.InternalErrorTitle", context);
                    errMsgDesc = eMFrameUtils.getLocalizedString("FwResources", "OV.InternalErrorDesc", context);
                }
                this.m_resultStrings.setProperty("GeneralMsg.suppressButtons", "true");
                eMFrameUtils.setMessage("error", errMsgTitle, errMsgDesc, context);
            }
            this.m_resultStrings = null;
            this.m_taskContext = null;
            return bl6;
        }
        D.log("<<<--- OV: exiting execute, cache size = " + context.getAuthenticator().getAuthContext().size() + ", returning " + bRet);
        if (!bRet) {
            String errMsgTitle = null;
            String errMsgDesc = null;
            if (!bPostSuccess) {
                errMsgTitle = eMFrameUtils.getLocalizedString("FwResources", "OV.DirectorySearchErrorTitle", context);
                errMsgDesc = this.m_PostError;
            } else {
                errMsgTitle = eMFrameUtils.getLocalizedString("FwResources", "OV.InternalErrorTitle", context);
                errMsgDesc = eMFrameUtils.getLocalizedString("FwResources", "OV.InternalErrorDesc", context);
            }
            this.m_resultStrings.setProperty("GeneralMsg.suppressButtons", "true");
            eMFrameUtils.setMessage("error", errMsgTitle, errMsgDesc, context);
        }
        this.m_resultStrings = null;
        this.m_taskContext = null;
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean startOV() {
        D.log("OV:   >startOV: Entering...");
        boolean bRet = false;
        try {
            ArrayList types;
            RoleList.getInstance(this.m_taskContext);
            ArrayList hiddenTasks = (ArrayList)this.m_taskContext.getAuthAttribute("fw.HiddenTasks");
            if (hiddenTasks != null && hiddenTasks.size() > 0 && this.m_req.getParameter("OV.ShowHiddenTasksMessage") == null) {
                this.m_resultStrings.put("OV.ShowHiddenTasksMessage", "true");
            }
            if ((types = FwUtils.getOVTypes(this.m_taskContext)) == null || types.size() < 1) {
                D.log("OV:    startOV: ObjectView not available to this user.");
                boolean bl = bRet;
                return bl;
            }
            this.m_strTypeFilter = null;
            for (int i = 0; i < types.size(); ++i) {
                this.m_strTypeFilter = this.addType(this.m_strTypeFilter, (String)types.get(i));
            }
            D.log("OV:   <startOV: OV.TypeFilter = " + this.m_strTypeFilter);
            this.setPropObject(this.m_resultStrings, "OV.TypeFilter", this.m_strTypeFilter);
            bRet = true;
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            D.log("OV:    startOV: Exception encountered.");
            D.log(e);
            bRet = false;
            boolean bl = false;
            return bl;
        }
        finally {
            D.log("OV:   <startOV: Completed... bRet=" + bRet);
        }
    }

    private void setPropObject(Properties p, String key, String value) {
        if (p != null && key != null && key.length() > 0) {
            if (value == null) {
                value = "";
            }
            p.put(key, value);
        }
    }

    private String addType(String s, String type) {
        if (s == null) {
            s = "";
        }
        if (type != null) {
            if (s.length() > 0) {
                s = s + (type.charAt(0) == ',' ? ",," : ",");
            }
            s = s + type;
        }
        return s;
    }

    private boolean isStrValid(String s) {
        return s != null && s.length() > 0;
    }

    private void parseParameters() {
        String strTemp = null;
        this.m_strCmdToken = null;
        this.m_bMovementPrev = false;
        this.m_strContextId = null;
        this.m_bMultiSelect = false;
        this.m_bDojoGetChildren = false;
        this.m_iMaxEntriesPerPage = 100;
        this.m_strContextId = this.m_req.getParameter(SEARCH_CMD_CONTEXTID);
        if (!this.isStrValid(this.m_strContextId)) {
            String action = this.m_req.getParameter("action");
            this.m_bDojoGetChildren = "getChildren".equals(action);
            this.m_strContextId = "";
        }
        D.log("OV: Search.ContextId=" + this.m_strContextId);
        this.m_strCmdToken = this.m_req.getParameter(SEARCH_CMD_TOKEN_PARAM);
        if (!this.isStrValid(this.m_strCmdToken)) {
            this.m_strCmdToken = SEARCH_TOKEN_INIT;
        }
        D.log("OV: SearchCmdToken = " + this.m_strCmdToken);
        strTemp = this.m_req.getParameter(SEARCH_CMD_MOVEMENT);
        if (this.isStrValid(strTemp)) {
            if (strTemp.compareTo(SEARCH_MOVEMENT_NEXT) == 0) {
                this.m_bMovementPrev = false;
                D.log("OV: Move NEXT command");
            } else if (strTemp.compareTo(SEARCH_MOVEMENT_PREV) == 0) {
                this.m_bMovementPrev = true;
                D.log("OV: Move PREV command");
            }
        }
        if (!this.isStrValid(strTemp = this.m_req.getParameter("OV.MultiSelect"))) {
            D.log("OV: No selection mode param; checking preferences.");
            strTemp = this.m_taskContext.getPersistentData("OVPrefs", "OV.SelectionMode");
            if (this.isStrValid(strTemp)) {
                D.log("OV: Retrieved selection mode preference = " + strTemp);
                strTemp = strTemp.equalsIgnoreCase("multiple") ? "true" : "false";
            } else {
                D.log("OV: No selection mode preference found.");
            }
        }
        if (this.isStrValid(strTemp) && strTemp.equalsIgnoreCase("true")) {
            this.m_bMultiSelect = true;
            D.log("OV: OV.Multiselect = true");
        } else if (this.isStrValid(strTemp) && strTemp.equalsIgnoreCase("false")) {
            this.m_bMultiSelect = false;
            D.log("OV: OV.Multiselect = false");
        } else {
            this.m_bMultiSelect = false;
            D.log("OV: OV.Multiselect = defaulting to false");
        }
        this.m_resultStrings.put("OV.MultiSelect", this.m_bMultiSelect ? "true" : "false");
        strTemp = this.m_req.getParameter("OV.ResultsPerPage");
        if (!this.isStrValid(strTemp)) {
            strTemp = this.m_taskContext.getPersistentData("OVPrefs", "OV." + (this.m_bMultiSelect ? "MS" : "SS") + "ResultsPerPage");
        }
        if (this.isStrValid(strTemp)) {
            try {
                this.m_iMaxEntriesPerPage = Integer.parseInt(strTemp);
            }
            catch (Exception e) {
                D.log("OV: Can't parse OV.ResultsPerPage = <" + strTemp + ">");
                D.log(e);
                strTemp = "";
            }
            if (this.m_iMaxEntriesPerPage < 1) {
                this.m_iMaxEntriesPerPage = 1;
                strTemp = "1";
                D.log("OV: OV.ResultsPerPage can't be < 1");
            } else if (this.m_iMaxEntriesPerPage > 500) {
                this.m_iMaxEntriesPerPage = 500;
                strTemp = "500";
                D.log("OV: OV.ResultsPerPage can't be > 500");
            }
        } else {
            strTemp = "";
        }
        this.m_resultStrings.put("OV.ResultsPerPage", strTemp);
        D.log("OV: OV.ResultsPerPage = <" + strTemp + ">");
        if (!this.m_strCmdToken.equalsIgnoreCase(SEARCH_TOKEN_UPDATE)) {
            this.m_strContainer = null;
            this.m_bCurrentContextSelectable = false;
            this.m_strNameFilter = null;
            this.m_arStrTypeFilter = null;
            this.m_strTypeFilter = null;
            this.m_hsTypeFilter = new HashSet();
            this.m_hsAuxTypeFilterEntries = new HashSet();
            this.m_hAdvSelCriterion = new Hashtable();
            this.m_selectedType = null;
            this.m_bSearchOnStartup = false;
            this.m_bSearchSubContainers = true;
            this.m_bShowAuxClasses = false;
            this.m_bShowSubClasses = true;
            this.m_bShowGlue = false;
            this.m_bRootSelectable = false;
            this.m_bThisSelectable = false;
            this.m_bPublicSelectable = false;
            this.m_bBrowseMode = true;
            this.m_bTreeMode = true;
            this.m_bExcludeMode = false;
            this.m_bMatchAllTypes = false;
            this.m_bMatchAllContainers = false;
            this.m_bMatchLeafObjects = false;
            this.m_bMatchNonPartitionedContainers = false;
            this.m_bMatchAllPartitions = false;
            this.m_bAdvancedSelection = false;
            this.m_showSubordinateCount = true;
            this.m_bShowFileSystemDirectory = false;
            this.m_bShowFileSystemFile = false;
            this.m_bFileSystemBrowseVolume = false;
            this.m_bShowVolumeObjectForFileSystem = true;
            strTemp = this.m_req.getParameter("OV.AdvancedSelection");
            if (this.isStrValid(strTemp) && strTemp.equalsIgnoreCase("true")) {
                this.m_bAdvancedSelection = true;
                D.log("OV: OV.AdvancedSelection = true");
            } else if (this.isStrValid(strTemp) && strTemp.equalsIgnoreCase("false")) {
                this.m_bAdvancedSelection = false;
                D.log("OV: OV.AdvancedSelection = false");
            } else {
                this.m_bAdvancedSelection = false;
                D.log("OV: OV.AdvancedSelection = defaulting to false");
            }
            D.log("OV: Determining starting container/context...");
            if (!this.isStrValid(this.m_strCmdToken) || this.m_strCmdToken.equalsIgnoreCase(SEARCH_TOKEN_INIT)) {
                D.log("OV:    In Init state...");
                this.m_strContainer = this.m_req.getParameter("OV.InitialContext");
                if (this.isStrValid(this.m_strContainer)) {
                    D.log("OV:    Using OV.InitialContext param = " + this.m_strContainer);
                } else {
                    D.log("OV:    No OV.InitialContext param.");
                    this.m_strContainer = this.m_taskContext.getPersistentData("OVPrefs", "OV.AlwaysContext");
                    if (this.isStrValid(this.m_strContainer)) {
                        D.log("OV:    Using OV.AlwaysContext param = " + this.m_strContainer);
                    } else {
                        D.log("OV:    No OV.AlwaysContext pref.");
                        this.m_strContainer = (String)this.m_taskContext.getAuthAttribute("OV.LastContainer");
                        if (this.isStrValid(this.m_strContainer)) {
                            D.log("OV:    Using cached context = " + this.m_strContainer);
                        } else {
                            D.log("OV:    No cached context.");
                            this.m_strContainer = this.m_taskContext.getPersistentData("OVPrefs", "OV.StartingContext");
                            if (this.isStrValid(this.m_strContainer)) {
                                D.log("OV:    Using first-time OV.StartingContext pref = " + this.m_strContainer);
                            } else {
                                D.log("OV:    No first-time OV.StartingContext preference...");
                            }
                        }
                    }
                }
            } else {
                D.log("OV:    In " + this.m_strCmdToken + " state...");
            }
            if (!this.isStrValid(this.m_strContainer)) {
                this.m_strContainer = this.m_req.getParameter("OV.Container");
                if (this.isStrValid(this.m_strContainer)) {
                    D.log("OV:    Using OV.Container param = " + this.m_strContainer);
                } else {
                    D.log("OV:    No OV.Container param. Check to see if we are getting dojo data");
                    if (this.m_bDojoGetChildren) {
                        D.log("OV:    Dojo getChildren = true");
                        try {
                            JSONObject data = new JSONObject(this.m_req.getParameter("data"));
                            JSONObject node = data.getJSONObject("node");
                            String context = node.getString("widgetId");
                            if ("rootTreeNode".equals(context)) {
                                context = "";
                            }
                            if (context != null && context.length() > 0) {
                                this.m_strContainer = XmlUtils.xmlDecode(context);
                                D.log("OV:    Using OV.Container from dojo request for getChildren = " + this.m_strContainer);
                            } else if (context != null && context.length() == 0) {
                                D.log("OV:    Using root for the context from the dojo request since it is the root node.");
                                this.m_strContainer = "[root]";
                            }
                        }
                        catch (JSONException e) {
                            D.log(e);
                        }
                    }
                }
            }
            if (!this.isStrValid(this.m_strContainer) || !this.oeExists(this.m_strContainer)) {
                if (this.m_bDojoGetChildren) {
                    D.log("OV:    The name of the context was not valid aborting the request: " + this.m_strContainer, 1);
                } else if (this.m_strContainer == null) {
                    D.log("OV:    The name of a valid context was not found; defaulting to [root]");
                    this.m_strContainer = "[root]";
                } else if (this.m_strContainer.equals("root")) {
                    D.log("OV:    If user give 'root' ; defaulting to [root]");
                    this.m_strContainer = "[root]";
                }
            }
            try {
                ObjectEntry oe = this.m_namespace.getObjectEntry(this.m_treeOE, this.m_strContainer);
                String objectType = oe.getObjectType().getName();
                if (!(objectType.equalsIgnoreCase("File") || objectType.equalsIgnoreCase("Directory") || objectType.equalsIgnoreCase("NetWare Volume"))) {
                    this.m_taskContext.setAuthAttribute("OV.LastContainer", this.m_strContainer);
                    D.log("OV: Starting container = " + this.m_strContainer + "; cached it!");
                }
            }
            catch (Exception exc) {
                D.log(exc);
            }
            strTemp = this.m_req.getParameter("OV.Mode");
            if (!this.isStrValid(strTemp)) {
                strTemp = this.m_taskContext.getPersistentData("OVPrefs", "OV.StartupMode");
            }
            if (this.isStrValid(strTemp) && strTemp.equalsIgnoreCase("Search")) {
                this.m_bBrowseMode = false;
                D.log("OV: OV.Mode = Search");
                this.m_bTreeMode = false;
            } else {
                this.m_bBrowseMode = true;
                D.log("OV: OV.Mode = Browse");
                if ("Tree".equalsIgnoreCase(strTemp) || strTemp == null) {
                    this.m_bTreeMode = true;
                    D.log("OV: OV.Mode = Tree");
                } else {
                    this.m_bTreeMode = false;
                    D.log("OV: OV.Mode = Browse");
                }
            }
            this.m_strNameFilter = this.m_req.getParameter("OV.NameFilter");
            if (!this.isStrValid(this.m_strNameFilter)) {
                this.m_strNameFilter = "*";
            }
            D.log("OV: OV.NameFilter = " + this.m_strNameFilter);
            this.m_strTypeFilter = this.m_req.getParameter("OV.TypeFilter");
            int numCrit = this.readAdvancedTypeFilters();
            this.m_selectedType = this.m_req.getParameter("OV.SelectedType");
            if (this.m_selectedType == null) {
                this.m_selectedType = "";
            }
            if (!this.isStrValid(this.m_strTypeFilter) && numCrit == 0) {
                this.m_strTypeFilter = "*";
                D.log("OV: No typeFilter found.  Defaulting to '" + this.m_strTypeFilter + "'");
            } else if (numCrit > 0) {
                this.m_selectedType = this.m_req.getParameter("OV.TypeFilter.0.name");
            }
            this.m_resultStrings.put("OV.SelectedType", this.m_selectedType);
            D.log("OV: OV.SelectedType = " + this.m_selectedType);
            ArrayList tf = this.splitTypeFilter(this.m_strTypeFilter, this.m_hAdvSelCriterion);
            tf = this.simplifySpecialOptions(tf);
            if (this.m_bExcludeMode) {
                tf = this.doExcludeProcessing(tf);
            }
            if (this.m_strCmdToken.compareTo(SEARCH_TOKEN_INIT) == 0) {
                this.outputTypesInfoToPropertyObject(tf, this.m_hAdvSelCriterion);
            }
            String tp = null;
            for (int i = 0; i < tf.size(); ++i) {
                tp = (String)tf.get(i);
                if (!this.isStrValid(tp) || tp.equalsIgnoreCase("*")) continue;
                this.m_hsTypeFilter.add(tp);
                if (!this.m_taskContext.getDirUtils().isAuxClass(tp)) continue;
                this.m_hsAuxTypeFilterEntries.add(tp);
            }
            boolean addVolume = true;
            for (int i = 0; i < tf.size(); ++i) {
                String type = (String)tf.get(i);
                if (type.equalsIgnoreCase("Directory")) {
                    this.m_bShowFileSystemDirectory = true;
                    continue;
                }
                if (type.equalsIgnoreCase("File")) {
                    this.m_bShowFileSystemFile = true;
                    continue;
                }
                if (type.equalsIgnoreCase("Volume")) {
                    this.m_bShowVolumeObjectForFileSystem = false;
                    continue;
                }
                if (!type.equalsIgnoreCase("*")) continue;
                this.m_bShowFileSystemDirectory = true;
                this.m_bShowFileSystemFile = true;
                addVolume = false;
            }
            if (this.m_bShowFileSystemDirectory || this.m_bShowFileSystemFile) {
                this.m_bFileSystemBrowseVolume = true;
            }
            if (addVolume && this.m_bShowVolumeObjectForFileSystem && (this.m_bShowFileSystemDirectory || this.m_bShowFileSystemFile)) {
                tf.add("Volume");
            }
            if (!this.m_bFileSystemBrowseVolume) {
                this.m_taskContext.setAuthAttribute("OS.LastContainer", this.m_strContainer);
            }
            this.m_arStrTypeFilter = new String[tf.size()];
            tf.toArray(this.m_arStrTypeFilter);
            if (!this.m_hsAuxTypeFilterEntries.isEmpty()) {
                this.m_bShowAuxClasses = true;
            }
            D.log("OV: OV.TypeFilter = " + this.m_strTypeFilter);
            D.log("OV: m_bMatchAllTypes = " + this.m_bMatchAllTypes);
            D.log("OV: m_bMatchAllContainers = " + this.m_bMatchAllContainers);
            D.log("OV: m_bMatchLeafObjects = " + this.m_bMatchLeafObjects);
            D.log("OV: m_bMatchNonPartitionedContainers = " + this.m_bMatchNonPartitionedContainers);
            D.log("OV: m_bMatchAllPartitions = " + this.m_bMatchAllPartitions);
            D.log("OV: m_bShowGlue = " + this.m_bShowGlue);
            strTemp = this.m_req.getParameter("OV.SearchSubContainers");
            if (this.isStrValid(strTemp) && strTemp.equalsIgnoreCase("false")) {
                this.m_bSearchSubContainers = false;
            }
            D.log("OV: OV.SearchSubContainers = " + this.m_bSearchSubContainers);
            strTemp = this.m_req.getParameter("OV.ShowSubClasses");
            if (this.isStrValid(strTemp) && strTemp.equalsIgnoreCase("false")) {
                this.m_bShowSubClasses = false;
            }
            D.log("OV: OV.ShowSubClasses = " + this.m_bShowSubClasses);
            strTemp = this.m_req.getParameter("OV.SearchOnStartup");
            if (!this.isStrValid(strTemp)) {
                strTemp = this.m_taskContext.getPersistentData("OVPrefs", "OV.StartupSearch");
            }
            if (this.isStrValid(strTemp) && strTemp.equalsIgnoreCase("true")) {
                this.m_bSearchOnStartup = true;
                D.log("OV: OV.SearchOnStartup = true");
            } else if (this.isStrValid(strTemp) && strTemp.equalsIgnoreCase("false")) {
                this.m_bSearchOnStartup = false;
                D.log("OV: OV.SearchOnStartup = false");
            } else {
                this.m_bSearchOnStartup = false;
                D.log("OV: OV.SearchOnStartup = defaulting to false");
            }
            if (this.m_bDojoGetChildren) {
                this.m_bSearchSubContainers = false;
                this.m_bMatchLeafObjects = false;
            }
            if (!this.isStrValid(strTemp = this.m_req.getParameter("OV.ShowSubordinateCount"))) {
                strTemp = this.m_taskContext.getPersistentData("OVPrefs", "OV.ShowSubordinateCount");
            }
            if (!this.isStrValid(strTemp) || strTemp.equalsIgnoreCase("true")) {
                this.m_showSubordinateCount = true;
                D.log("OV: OV.ShowSubordinateCount = true");
            } else if (this.isStrValid(strTemp) && strTemp.equalsIgnoreCase("false")) {
                this.m_showSubordinateCount = false;
                D.log("OV: OV.ShowSubordinateCount = false");
            } else {
                this.m_showSubordinateCount = true;
                D.log("OV: OV.ShowSubordinateCount = defaulting to true");
            }
        }
    }

    private boolean oeExists(String containerName) {
        try {
            return this.m_namespace.doesExist(this.m_treeOE, containerName);
        }
        catch (SPIException e) {
            return false;
        }
    }

    private int readAdvancedTypeFilters() {
        String strTemp = this.m_req.getParameter("OV.TypeFilter.cnt");
        int numCrit = 0;
        if (this.isStrValid(strTemp)) {
            try {
                numCrit = Integer.parseInt(strTemp);
            }
            catch (Exception e) {
                D.log("OV: Can't parse OV.TypeFilter.cnt = <" + strTemp + ">");
                D.log(e);
            }
        }
        if (numCrit > 0) {
            String name = null;
            String crit = null;
            for (int i = 0; i < numCrit; ++i) {
                name = this.m_req.getParameter("OV.TypeFilter." + i + ".name");
                crit = this.m_req.getParameter("OV.TypeFilter." + i + ".crit");
                if (!this.isStrValid(name) || !this.isStrValid(crit)) continue;
                this.m_hAdvSelCriterion.put(name, crit);
                this.m_hsTypeFilter.add(name);
                if (this.m_taskContext.getDirUtils().isAuxClass(name)) {
                    this.m_hsAuxTypeFilterEntries.add(name);
                }
                D.log("OV: Advanced selection for type[" + i + "] = " + name + "  crit=" + crit);
            }
        }
        return numCrit;
    }

    private ArrayList simplifySpecialOptions(ArrayList tf) {
        if (this.m_bMatchAllPartitions && this.m_bMatchNonPartitionedContainers) {
            this.m_bMatchAllContainers = true;
        }
        if (this.m_bMatchAllContainers) {
            this.m_bMatchAllPartitions = false;
            this.m_bMatchNonPartitionedContainers = false;
        }
        if (this.m_bMatchAllTypes || this.m_bMatchLeafObjects && this.m_bMatchAllContainers) {
            tf = new ArrayList<String>();
            tf.add("*");
            this.m_bMatchAllTypes = true;
            this.m_bMatchAllContainers = false;
            this.m_bMatchAllPartitions = false;
            this.m_bMatchLeafObjects = false;
            this.m_bMatchNonPartitionedContainers = false;
        }
        return tf;
    }

    private ArrayList doExcludeProcessing(ArrayList tf) {
        if (this.m_bMatchAllTypes) {
            tf = new ArrayList<String>();
        } else if (tf.size() > 0) {
            String tp = null;
            HashSet<String> hsTmp = new HashSet<String>();
            for (int i = 0; i < tf.size(); ++i) {
                tp = (String)tf.get(i);
                if (!this.isStrValid(tp) || tp.equalsIgnoreCase("*")) continue;
                hsTmp.add(tp);
            }
            String[] saTmp = this.m_taskContext.getDirUtils().getSelectableTypes(hsTmp);
            if (saTmp != null) {
                tf = new ArrayList();
                for (int i = 0; i < saTmp.length; ++i) {
                    tf.add(saTmp[i]);
                }
            }
        }
        return tf;
    }

    private void outputTypesInfoToPropertyObject(ArrayList tf, Hashtable hAdvSelCriterion) {
        Enumeration advSelTypes;
        if (this.m_bMatchAllTypes) {
            String[] allTypes = this.m_taskContext.getDirUtils().getSortedClasses();
            for (int i = 0; i < allTypes.length; ++i) {
                tf.add(allTypes[i]);
            }
            tf.add("File");
            tf.add("Directory");
        } else if (hAdvSelCriterion != null && (advSelTypes = hAdvSelCriterion.keys()) != null) {
            while (advSelTypes.hasMoreElements()) {
                tf.add(advSelTypes.nextElement());
            }
        }
        ArrayList dtf = new ArrayList();
        this.m_taskContext.getDirUtils().createSortedTypeArrays(tf, dtf, this.m_taskContext);
        int cnt = 0;
        String name = null;
        String dname = null;
        String crit = null;
        for (int i = 0; i < tf.size(); ++i) {
            name = (String)tf.get(i);
            if (name == null || name.length() <= 0 || name.equals("*")) continue;
            dname = (String)dtf.get(i);
            crit = (String)this.m_hAdvSelCriterion.get(name);
            this.m_resultStrings.put("OV.TypeFilter." + cnt + ".name", name);
            this.m_resultStrings.put("OV.TypeFilter." + cnt + ".displayname", dname);
            this.m_resultStrings.put("OV.TypeFilter." + cnt + ".crit", crit == null || crit.length() == 0 ? "" : crit);
            ++cnt;
        }
        this.m_resultStrings.put("OV.TypeFilter.cnt", "" + cnt);
        ArrayList<String> pt = new ArrayList<String>();
        ArrayList<String> dpt = new ArrayList<String>();
        if (this.m_bMatchAllTypes) {
            pt.add("*");
            dpt.add(eMFrameUtils.getLocalizedString("FwResources", "OV.All", this.m_taskContext));
        }
        if (this.m_bMatchAllContainers) {
            pt.add("[containers]");
            dpt.add(eMFrameUtils.getLocalizedString("FwResources", "OV.AllContainers", this.m_taskContext));
        }
        if (this.m_bMatchLeafObjects) {
            pt.add("[non-containers]");
            dpt.add(eMFrameUtils.getLocalizedString("FwResources", "OV.AllLeafObjects", this.m_taskContext));
        }
        if (this.m_bMatchNonPartitionedContainers) {
            pt.add("[non-partitions]");
            dpt.add(eMFrameUtils.getLocalizedString("FwResources", "OV.NonPartitionedContainers", this.m_taskContext));
        }
        if (this.m_bMatchAllPartitions) {
            pt.add("[partitions]");
            dpt.add(eMFrameUtils.getLocalizedString("FwResources", "OV.AllPartitions", this.m_taskContext));
        }
        if (this.m_bRootSelectable) {
            pt.add("[root]");
            dpt.add(eMFrameUtils.getLocalizedString("FwResources", "OV.Root", this.m_taskContext));
        }
        if (this.m_bThisSelectable) {
            pt.add("[this]");
            dpt.add(eMFrameUtils.getLocalizedString("FwResources", "OV.This", this.m_taskContext));
        }
        if (this.m_bPublicSelectable) {
            pt.add("[public]");
            dpt.add(eMFrameUtils.getLocalizedString("FwResources", "OV.Public", this.m_taskContext));
        }
        if (this.m_bShowGlue) {
            pt.add("[glue]");
            dpt.add(eMFrameUtils.getLocalizedString("FwResources", "OV.ShowGlue", this.m_taskContext));
        }
        eMFrameUtils.sortKeyValues(dpt, pt, this.m_taskContext);
        for (int i = 0; i < pt.size(); ++i) {
            this.m_resultStrings.put("OV.PseudoTypeFilter." + i + ".name", pt.get(i));
            this.m_resultStrings.put("OV.PseudoTypeFilter." + i + ".displayname", dpt.get(i));
        }
        this.m_resultStrings.put("OV.PseudoTypeFilter.cnt", "" + pt.size());
    }

    private void performInit() {
        D.log("OV:   >performInit: Performing INIT...");
        this.m_resultStrings.put(SEARCH_CMD_SHOWRESULTSET, "false");
        if (this.m_strContextId != null) {
            this.m_resultStrings.put(SEARCH_CMD_CONTEXTID, this.m_strContextId);
        }
        if (this.m_bBrowseMode) {
            if (this.m_bTreeMode) {
                this.m_resultStrings.put("OV.Mode", "Tree");
            } else {
                this.m_resultStrings.put("OV.Mode", "Browse");
            }
        } else {
            this.m_resultStrings.put("OV.Mode", "Search");
        }
        this.m_iNumPseudoObjects = 0;
        StringBuffer pObjs = new StringBuffer("...");
        if (this.m_bRootSelectable) {
            pObjs.setCharAt(0, 'R');
            ++this.m_iNumPseudoObjects;
        }
        if (this.m_bThisSelectable) {
            pObjs.setCharAt(1, 'T');
            ++this.m_iNumPseudoObjects;
        }
        if (this.m_bPublicSelectable) {
            pObjs.setCharAt(2, 'P');
            ++this.m_iNumPseudoObjects;
        }
        String po = pObjs.toString();
        this.m_resultStrings.put(SEARCH_CMD_PSEUDOOBJECTS, po);
        D.log("OV:    performInit: Search.PseudoObjects = <" + po + ">");
        if (this.m_strCmdToken.compareTo(SEARCH_TOKEN_UPDATE) != 0) {
            this.m_resultStrings.put("OV.Container", this.m_strContainer);
            this.m_resultStrings.put("OV.TypeFilter", this.m_strTypeFilter);
            this.m_resultStrings.put("OV.NameFilter", this.m_strNameFilter);
            if (this.m_bSearchSubContainers) {
                this.m_resultStrings.put("OV.SearchSubContainers", "true");
            } else {
                this.m_resultStrings.put("OV.SearchSubContainers", "false");
            }
            if (this.m_bShowSubClasses) {
                this.m_resultStrings.put("OV.ShowSubClasses", "true");
            } else {
                this.m_resultStrings.put("OV.ShowSubClasses", "false");
            }
            if (this.m_bSearchOnStartup) {
                this.m_resultStrings.put("OV.SearchOnStartup", "true");
            } else {
                this.m_resultStrings.put("OV.SearchOnStartup", "false");
            }
            if (this.m_bAdvancedSelection) {
                this.m_resultStrings.put("OV.AdvancedSelection", "true");
            } else {
                this.m_resultStrings.put("OV.AdvancedSelection", "false");
            }
        }
        D.log("OV:   <performInit: Completed INIT...");
    }

    private boolean performPost() {
        ObjectType ot;
        boolean bOptimizedMatchAll;
        int sortMode;
        D.log("OV:   >performPost: Performing POST...");
        boolean bRet = true;
        if (this.m_strContextId != null && this.m_strContextId.length() > 0) {
            this.m_taskContext.removeAuthAttribute(this.m_strContextId);
            D.log("OV:    performPost: Removed from session cache searchContext = " + this.m_strContextId);
        }
        SearchObjectContext searchContext = new SearchObjectContext(this.m_taskContext, this.m_treeOE, null);
        this.m_strContextId = ObjectView.getUniqueString();
        this.m_taskContext.setAuthAttribute(this.m_strContextId, searchContext);
        D.log("OV:    performPost: Cached Search.ContextId = " + this.m_strContextId);
        this.m_resultStrings.put(SEARCH_CMD_CONTEXTID, this.m_strContextId);
        D.log("OV:    performPost: Put Search.ContextId = " + this.m_strContextId + " in property object.");
        ResultModifier rm = null;
        int n = sortMode = !this.m_bSearchSubContainers && this.m_namespace instanceof NDSNamespace ? 0 : 3;
        if (this.m_bAdvancedSelection) {
            rm = new FilterResultModifier("AdvancedSearchModifier", sortMode, null, this.m_bSearchSubContainers);
            Enumeration types = this.m_hAdvSelCriterion.keys();
            while (types.hasMoreElements()) {
                String typeName = (String)types.nextElement();
                String typeCrit = (String)this.m_hAdvSelCriterion.get(typeName);
                ((FwDirUtils)this.m_taskContext.getDirUtils()).addASXMLFilterInfoToRM((FilterResultModifier)rm, typeName, typeCrit, (MContext)this.m_taskContext);
            }
        } else {
            rm = new ResultModifier("SearchModifier");
            rm.setSortByKey(sortMode);
            rm.setSubContainerSearch(this.m_bSearchSubContainers);
        }
        rm.setIncludeSubClasses(this.m_bShowSubClasses);
        rm.setIncludeAuxClasses(this.m_bShowAuxClasses);
        rm.setShowGlue(this.m_bShowGlue);
        if (this.m_bShowFileSystemDirectory || this.m_bShowFileSystemFile) {
            int allowFileSystemBrowse = 0;
            if (this.m_bFileSystemBrowseVolume) {
                allowFileSystemBrowse |= 1;
            }
            rm.setAllowFileSystemBrowse(allowFileSystemBrowse);
        }
        boolean bl = bOptimizedMatchAll = this.m_bBrowseMode && this.m_bMatchLeafObjects;
        if (bOptimizedMatchAll) {
            this.m_arStrTypeFilter = new String[]{"*"};
            D.log("OV:    performPost: Matching leaf objects in browse mode; optimizing type filter to '*'");
        }
        ResultModifierFilterEntry filterEntry = null;
        if (this.isStrValid(this.m_strNameFilter) && this.m_arStrTypeFilter != null && this.m_arStrTypeFilter.length > 0) {
            filterEntry = new ResultModifierFilterEntry(this.m_strNameFilter, this.m_arStrTypeFilter);
            rm.addFilter(filterEntry);
        }
        if (!this.m_bMatchAllTypes && !bOptimizedMatchAll || this.isStrValid(this.m_strNameFilter) && !this.m_strNameFilter.equals("*")) {
            String[] c;
            if (this.m_bBrowseMode || this.m_bMatchAllContainers || this.m_bMatchNonPartitionedContainers || this.m_bMatchAllPartitions) {
                HashSet hsTmp = this.isStrValid(this.m_strNameFilter) && this.m_strNameFilter.equals("*") ? this.m_hsTypeFilter : null;
                String[] c2 = this.m_taskContext.getDirUtils().getSelectableContainerTypes(hsTmp);
                if (c2 != null) {
                    String tmpNameFilter = this.m_bBrowseMode ? "*" : this.m_strNameFilter;
                    filterEntry = new ResultModifierFilterEntry(tmpNameFilter, c2);
                    rm.addFilter(filterEntry);
                }
            }
            if (this.m_bMatchLeafObjects && (c = this.m_taskContext.getDirUtils().getSelectableLeafTypes(this.m_hsTypeFilter)) != null) {
                filterEntry = new ResultModifierFilterEntry(this.m_strNameFilter, c);
                rm.addFilter(filterEntry);
            }
        }
        searchContext.setModifier(rm);
        ObjectEntry oeContainer = null;
        D.log("OV:    performPost: Getting oe for m_strContainer = " + this.m_strContainer);
        if (this.m_strContainer == null || this.m_strContainer.length() == 0 || this.m_strContainer.equalsIgnoreCase("[root]") || this.m_strContainer.equalsIgnoreCase(this.m_treeOE.getName())) {
            oeContainer = this.m_treeOE;
        } else {
            try {
                oeContainer = this.m_namespace.getObjectEntry(this.m_treeOE, this.m_strContainer);
            }
            catch (SPIException e) {
                // empty catch block
            }
        }
        if (!this.m_bShowFileSystemDirectory && !this.m_bShowFileSystemFile && oeContainer != null && (ot = oeContainer.getObjectType()).getName().equalsIgnoreCase("Volume")) {
            rm.setAllowFileSystemBrowse(1);
        }
        searchContext.setContainer(oeContainer);
        D.log("OV:    performPost: Set search context Container oe = " + oeContainer);
        searchContext.setChildrenEnumeration(null);
        D.log("OV:    performPost: Set result modifier for search = ");
        this.dumpRM(searchContext.getModifier());
        DefaultIndexedObjectEntryEnumeration oeeChildren = new DefaultIndexedObjectEntryEnumeration(null, null);
        if (oeContainer == null) {
            this.m_PostError = eMFrameUtils.getLocalizedString("FwResources", "OV.DirectorySearchErrorDesc", this.m_taskContext) + " '" + this.m_strContainer + "'.";
            bRet = false;
        } else if (this.isValidRM(rm)) {
            try {
                oeeChildren = this.m_namespace.getChildren(oeContainer, rm);
                if (oeeChildren == null) {
                    D.log("OV:    performPost: getChildren() returned null enum");
                } else {
                    D.log("OV:    performPost: getChildren() returned valid enum");
                }
                if (!(oeeChildren instanceof BrowserObjectEntryEnumeration)) {
                    DefaultIndexedObjectEntryEnumeration dioee;
                    D.log("OV:    performPost: oeeChildren is not virtual.  Create an indexed enumeration...");
                    oeeChildren = dioee = new DefaultIndexedObjectEntryEnumeration((ObjectEntryEnumeration)oeeChildren, null);
                }
            }
            catch (SPIException spie) {
                this.m_PostError = spie.getMessage();
                D.log("OV:    performPost: ERROR -- getObjectEntry or getChildren failed, e = " + spie.toString());
                oeeChildren = new DefaultIndexedObjectEntryEnumeration(null, null);
                bRet = false;
            }
        }
        searchContext.setChildrenEnumeration((ObjectEntryEnumeration)oeeChildren);
        this.showSearchResults(searchContext, true);
        D.log("OV:   <performPost: Completed POST...");
        return bRet;
    }

    private void performUpdate() {
        int iMoveNum;
        int i;
        ObjectEntryEnumeration oeeToMove;
        D.log("OV:   >performUpdate: Performing UPDATE...");
        SearchObjectContext searchContext = null;
        if (this.m_strContextId != null && this.m_strContextId.length() != 0) {
            searchContext = (SearchObjectContext)this.m_taskContext.getAuthAttribute(this.m_strContextId);
        }
        if (searchContext == null) {
            D.log("OV:    performUpdate:  ERROR! searchContext'" + this.m_strContextId + "'not found...");
            return;
        }
        if (this.m_bMovementPrev && (oeeToMove = searchContext.getChildrenEnumeration()) instanceof BrowserObjectEntryEnumeration && (i = this.moveEnumerationLeft((BrowserObjectEntryEnumeration)oeeToMove, iMoveNum = this.m_iMaxEntriesPerPage + searchContext.getLastMovementCount())) == iMoveNum) {
            iMoveNum = this.getNumOverheadLines(searchContext, this.atFirst((BrowserObjectEntryEnumeration)oeeToMove));
            this.moveEnumerationRight((BrowserObjectEntryEnumeration)oeeToMove, iMoveNum);
        }
        this.showSearchResults(searchContext, false);
        D.log("OV:   <performUpdate: Completed UPDATE...");
    }

    private void performRestart() {
        D.log("OV:   >performRestart: Performing RESTART...");
        if (this.m_strContextId != null && this.m_strContextId.length() != 0) {
            SearchObjectContext searchContext = (SearchObjectContext)this.m_taskContext.getAuthAttribute(this.m_strContextId);
            if (searchContext != null) {
                this.m_resultStrings.remove(SEARCH_CMD_CONTEXTID);
            }
            this.m_taskContext.removeAuthAttribute(this.m_strContextId);
            D.log("OV:   performRestart: Removed from session cache searchContext = " + this.m_strContextId);
        }
        this.m_strContextId = null;
        D.log("OV:   <performRestart: Completed RESTART...");
    }

    private void showSearchResults(SearchObjectContext searchContext, boolean bFirstHit) {
        BrowserObjectEntryEnumeration enumr = (BrowserObjectEntryEnumeration)searchContext.getChildrenEnumeration();
        if (enumr == null) {
            D.log("OV:      showSearchResults: No results, myenum = null...");
            this.m_resultStrings.put(SEARCH_CMD_SHOWRESULTSET, "true");
            this.m_resultStrings.put("Search.ResultList.Count", "0");
            this.m_resultStrings.put("Search.PreviousElements", "false");
            this.m_resultStrings.put("Search.NextElements", "false");
        } else {
            ObjectEntry oeThisContainer = searchContext.getContainer();
            D.log("OV:      showSearchResults: Searching from = " + oeThisContainer);
            this.m_bCurrentContextSelectable = false;
            if (oeThisContainer != null) {
                this.m_resultStrings.put("OV.Container.Type", this.m_taskContext.getDirUtils().getObjectEntryImageName(oeThisContainer));
                this.m_bCurrentContextSelectable = this.isContainerSelectable(oeThisContainer);
                this.m_resultStrings.put("OV.Container.Selectable", this.m_bCurrentContextSelectable ? "true" : "false");
            }
            this.m_resultStrings.put(SEARCH_CMD_SHOWRESULTSET, "true");
            boolean bAtFirstBeforeMove = true;
            if (!bFirstHit) {
                bAtFirstBeforeMove = this.atFirst(enumr);
            }
            int iChildrenShown = this.showChildEntries(searchContext, bAtFirstBeforeMove);
            searchContext.setLastMovementCount(iChildrenShown);
            boolean bAtLastAfterMove = this.atLast(enumr);
            this.m_resultStrings.put("Search.PreviousElements", "false");
            this.m_resultStrings.put("Search.NextElements", "false");
            if (!bAtFirstBeforeMove || !bAtLastAfterMove) {
                if (bAtFirstBeforeMove && !bAtLastAfterMove) {
                    this.m_resultStrings.put("Search.NextElements", "true");
                } else if (!bAtFirstBeforeMove && bAtLastAfterMove) {
                    this.m_resultStrings.put("Search.PreviousElements", "true");
                } else if (!bAtFirstBeforeMove && !bAtLastAfterMove) {
                    this.m_resultStrings.put("Search.PreviousElements", "true");
                    this.m_resultStrings.put("Search.NextElements", "true");
                }
            }
        }
        if (this.m_bTreeMode) {
            this.setUIPage("fw/OV/TreeViewJSON.jsp");
        }
        D.log("OV:      showSearchResults: Exiting...");
    }

    private int computeMaxNumToRetrieve(SearchObjectContext searchContext, boolean bAtFirstBeforeMove) {
        int overheadLines = this.getNumOverheadLines(searchContext, bAtFirstBeforeMove);
        return overheadLines < this.m_iMaxEntriesPerPage ? this.m_iMaxEntriesPerPage - overheadLines : 1;
    }

    private int getNumOverheadLines(SearchObjectContext searchContext, boolean bAtFirst) {
        int overheadLines = 0;
        if (this.m_bBrowseMode) {
            boolean bAtRoot;
            boolean bl = bAtRoot = searchContext.getParentContainer() == null;
            if (bAtFirst) {
                if (bAtRoot) {
                    overheadLines = this.m_iNumPseudoObjects;
                } else {
                    overheadLines = 1;
                    if (this.m_bCurrentContextSelectable) {
                        ++overheadLines;
                    }
                    overheadLines += this.m_iNumPseudoObjects;
                    if (this.m_bRootSelectable) {
                        --overheadLines;
                    }
                }
            } else if (!bAtRoot) {
                overheadLines = 1;
                if (this.m_bCurrentContextSelectable) {
                    ++overheadLines;
                }
            }
        } else if (bAtFirst) {
            overheadLines = this.m_iNumPseudoObjects;
        }
        return overheadLines;
    }

    boolean showCurrentContainer(SearchObjectContext searchContext, boolean bAtFirst) {
        boolean ret = false;
        if (this.m_bCurrentContextSelectable && this.m_bBrowseMode) {
            boolean bAtRoot;
            boolean bl = bAtRoot = searchContext.getParentContainer() == null;
            if (bAtFirst) {
                if (!bAtRoot) {
                    ret = true;
                }
            } else if (!bAtRoot) {
                ret = true;
            }
        }
        return ret;
    }

    public int showChildEntries(SearchObjectContext searchContext, boolean bAtFirstBeforeMove) {
        D.log("OV:       showChildEntries: Entering...");
        int iMaxNumToRetrieve = this.computeMaxNumToRetrieve(searchContext, bAtFirstBeforeMove);
        if (this.m_bBrowseMode) {
            this.m_resultStrings.put(SEARCH_CMD_PARENTCONTAINER, searchContext.getParentContainerName());
        }
        int iCountShown = 0;
        int iContainerCountShown = 0;
        int i = 0;
        ObjectEntryEnumeration oee = searchContext.getChildrenEnumeration();
        if (oee == null) {
            D.log("OV:       showChildEntries:  oee is null.");
        } else {
            if (this.showCurrentContainer(searchContext, bAtFirstBeforeMove)) {
                ObjectEntry oe = searchContext.getContainer();
                String name = this.m_namespace.getUnrootedName(oe);
                String currLevel = eMFrameUtils.getLocalizedString("FwResources", "OV.Browser.CurrentLevel", this.m_taskContext);
                String typeDisplayName = this.m_taskContext.getDirUtils().getObjectTypeDisplayName(oe.getTypeName(), this.m_taskContext);
                String typeIconName = this.m_taskContext.getDirUtils().getObjectEntryImageName(oe);
                int subcount = -1;
                if (this.m_showSubordinateCount) {
                    subcount = oe.getSubordinateCount();
                }
                this.outputDisplayInfo(i, name, currLevel, typeDisplayName, typeIconName, ".S...", subcount);
                ++i;
            }
            JSONArray jsonArray = new JSONArray();
            while (iCountShown < iMaxNumToRetrieve) {
                String oeName = null;
                String oeTypeName = null;
                String oeTypeDisplayName = null;
                String oeIconName = null;
                String oeDisplayName = null;
                ObjectEntry oe = null;
                ObjectType ot = null;
                int subcount = -1;
                try {
                    oe = oee.next();
                    if (oe == null) break;
                    ot = oe.getObjectType();
                    if (ot == null || (oeTypeName = ot.getName()).equalsIgnoreCase("File") && !this.m_bShowFileSystemFile || oeTypeName.equals("Tree Root")) continue;
                    oeName = this.m_namespace.getUnrootedName(oe);
                    this.m_resultStrings.put("Search.ResultList." + i + ".Name", oeName);
                    oeDisplayName = this.m_bBrowseMode ? oe.getName() : oeName;
                    oeIconName = this.m_taskContext.getDirUtils().getObjectEntryImageName(oe);
                    oeTypeDisplayName = this.m_taskContext.getDirUtils().getObjectTypeDisplayName(oeTypeName, this.m_taskContext);
                    StringBuffer dAttribs = new StringBuffer(".S....");
                    long flags = oe.getObjectFlags();
                    boolean isContainer = ObjectFlags.isContainer((long)flags);
                    boolean isPartition = ObjectFlags.isPartition((long)flags);
                    boolean isAlias = ObjectFlags.isAlias((long)flags);
                    boolean isGlue = ObjectFlags.isGlue((long)flags);
                    boolean isJunction = ObjectFlags.isJunctionFile((long)flags);
                    if (isPartition) {
                        dAttribs.setCharAt(2, 'P');
                    }
                    if (isContainer) {
                        dAttribs.setCharAt(0, 'C');
                        boolean nameMatches = true;
                        if (!this.isStrValid(this.m_strNameFilter)) {
                            this.m_strNameFilter = "*";
                        }
                        if (this.m_bBrowseMode && !this.m_strNameFilter.equals("*") && this.isStrValid(oeName)) {
                            nameMatches = oeName.toLowerCase().matches(eMFrameUtils.replaceWith(this.m_strNameFilter, "*", ".*").toLowerCase());
                        }
                        if (!nameMatches) {
                            dAttribs.setCharAt(1, '.');
                        } else {
                            boolean bSelectable;
                            boolean bl = bSelectable = this.m_bMatchAllTypes || this.m_bMatchAllContainers || isGlue && this.m_bShowGlue || isAlias && this.m_hsTypeFilter.contains("Alias") || this.isContainerSelectable(oe) || this.isDirectorySelectable(oe);
                            if (!bSelectable) {
                                if (this.m_bMatchNonPartitionedContainers || this.m_bMatchAllPartitions) {
                                    if (this.m_bMatchNonPartitionedContainers && isPartition || this.m_bMatchAllPartitions && !isPartition) {
                                        dAttribs.setCharAt(1, '.');
                                    }
                                } else {
                                    dAttribs.setCharAt(1, '.');
                                }
                            }
                        }
                    }
                    if (isAlias) {
                        dAttribs.setCharAt(3, 'A');
                    }
                    if (isGlue) {
                        dAttribs.setCharAt(4, 'G');
                    }
                    if (isJunction) {
                        dAttribs.setCharAt(5, 'J');
                    }
                    String da = dAttribs.toString();
                    if (this.m_showSubordinateCount) {
                        subcount = oe.getSubordinateCount();
                    }
                    this.outputDisplayInfo(i, oeName, oeDisplayName, oeTypeDisplayName, oeIconName, da, subcount);
                    if (isContainer && !oeName.equals(this.m_strContainer)) {
                        String title = oeDisplayName;
                        if (this.m_showSubordinateCount && subcount > 0) {
                            title = title + " (" + subcount + ")";
                        }
                        JSONObject tempJSONObject = new JSONObject();
                        try {
                            tempJSONObject.put("widgetId", oeName);
                            tempJSONObject.put("title", title);
                            tempJSONObject.put("objectTypeDisplayName", oeTypeDisplayName);
                            tempJSONObject.put("iconUrl", oeIconName);
                            tempJSONObject.put("dispAttrs", dAttribs);
                            tempJSONObject.put("isFolder", "true");
                        }
                        catch (JSONException e) {
                            D.log(e);
                        }
                        jsonArray.put(tempJSONObject);
                        ++iContainerCountShown;
                    }
                    ++iCountShown;
                    ++i;
                }
                catch (NoSuchElementException nsee) {
                    break;
                }
            }
            if (iContainerCountShown >= iMaxNumToRetrieve) {
                JSONObject tempJSONObject = new JSONObject();
                try {
                    tempJSONObject.put("widgetId", "specialMoreIndicator");
                    tempJSONObject.put("title", eMFrameUtils.getLocalizedString("FwResources", "OV.Tree.MoreTitle", this.m_taskContext));
                    tempJSONObject.put("objectTypeDisplayName", eMFrameUtils.getLocalizedString("FwResources", "OV.Tree.MoreAltText", this.m_taskContext));
                    tempJSONObject.put("iconUrl", "../../../fw/images/16px_spacer.gif");
                    tempJSONObject.put("dispAttrs", null);
                    tempJSONObject.put("isFolder", false);
                }
                catch (JSONException e) {
                    D.log(e);
                }
                jsonArray.put(tempJSONObject);
            }
            String jsonTreeData = jsonArray.toString();
            this.m_req.setAttribute("JSONTreeData", (Object)jsonTreeData);
        }
        this.m_resultStrings.put("Search.ResultList.Count", Integer.toString(i));
        D.log("OV:       showChildEntries: Exiting.  Displayed " + iCountShown + " of " + this.m_iMaxEntriesPerPage + " entries...");
        return iCountShown;
    }

    private void outputDisplayInfo(int cnt, String oeName, String oeDisplayName, String oeTypeDisplayName, String oeIconName, String oeDisplayAttribs, int subcount) {
        this.m_resultStrings.put("Search.ResultList." + cnt + ".Name", oeName);
        this.m_resultStrings.put("Search.ResultList." + cnt + ".DisplayName", oeDisplayName);
        this.m_resultStrings.put("Search.ResultList." + cnt + ".TypeName", oeTypeDisplayName);
        this.m_resultStrings.put("Search.ResultList." + cnt + ".TypeIcon", oeIconName);
        this.m_resultStrings.put("Search.ResultList." + cnt + ".DisplayAttributes", oeDisplayAttribs);
        String subcountString = "";
        if (subcount > 0) {
            subcountString = "(" + subcount + ")";
        }
        this.m_resultStrings.put("Search.ResultList." + cnt + ".SubordinateCount", subcountString);
    }

    private boolean isDirectorySelectable(ObjectEntry oe) {
        String otName = oe.getObjectType().getName();
        return oe != null && ObjectFlags.isContainer((long)oe.getObjectFlags()) && otName.equalsIgnoreCase("Directory") && this.m_bShowFileSystemDirectory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isContainerSelectable(ObjectEntry oe) {
        String crit;
        Iterator i;
        String s;
        if (oe == null || !ObjectFlags.isContainer((long)oe.getObjectFlags())) {
            return false;
        }
        if (this.m_bMatchAllTypes || this.m_bMatchAllContainers) {
            return true;
        }
        boolean bSelectable = false;
        String matchedTypeFilterEntryName = null;
        String typeName = "";
        ObjectType ot = oe.getObjectType();
        typeName = ot.getName();
        if (this.m_hsTypeFilter.contains(typeName)) {
            bSelectable = true;
            matchedTypeFilterEntryName = typeName;
        }
        if (!bSelectable && this.m_bShowSubClasses) {
            s = null;
            i = this.m_hsTypeFilter.iterator();
            while (!bSelectable && i.hasNext()) {
                s = (String)i.next();
                bSelectable = DirUtils.isOfType(ot, s, true);
                if (!bSelectable) continue;
                matchedTypeFilterEntryName = s;
            }
        }
        if (!bSelectable && this.m_bShowAuxClasses) {
            s = null;
            i = this.m_hsAuxTypeFilterEntries.iterator();
            while (!bSelectable && i.hasNext()) {
                s = (String)i.next();
                bSelectable = this.m_taskContext.getDirUtils().isOfAuxClass(oe, s);
                matchedTypeFilterEntryName = s;
            }
        }
        if (bSelectable && this.m_hAdvSelCriterion != null && (crit = (String)this.m_hAdvSelCriterion.get(matchedTypeFilterEntryName)) != null) {
            bSelectable = this.isAdvCritMatch(oe, crit);
        }
        boolean bl = bSelectable;
        return bl;
    }

    private boolean isAdvCritMatch(ObjectEntry oe, String criterion) {
        boolean bMatch = false;
        String objName = oe.getName();
        FilterResultModifier rm = new FilterResultModifier("AdvCritMatchRM", 0, null, false);
        String critType = ((FwDirUtils)this.m_taskContext.getDirUtils()).getFirstTypeFromASXMLCriterion(criterion, this.m_taskContext);
        ((FwDirUtils)this.m_taskContext.getDirUtils()).addASXMLFilterInfoToRM(rm, critType, criterion, (MContext)this.m_taskContext);
        ResultModifierFilterEntry filterEntry = null;
        if (objName != null && objName.length() > 0) {
            filterEntry = new ResultModifierFilterEntry(objName, new String[0]);
            rm.addFilter(filterEntry);
        }
        rm.setIncludeSubClasses(this.m_bShowSubClasses);
        rm.setIncludeAuxClasses(this.m_bShowAuxClasses);
        rm.setShowGlue(this.m_bShowGlue);
        rm.setSimpleAndOpAdvanced(true);
        try {
            ObjectEntryEnumeration oee = this.m_namespace.getChildren(oe.getParent(), (ResultModifier)rm);
            bMatch = oee.hasMoreElements();
        }
        catch (Exception e) {
            // empty catch block
        }
        return bMatch;
    }

    public int moveEnumerationLeft(BrowserObjectEntryEnumeration boee, int count) {
        int iCount = 0;
        if (boee != null) {
            for (int i = 0; i < count; ++i) {
                block6: {
                    try {
                        if (boee.previous() == null) {
                        }
                        break block6;
                    }
                    catch (SnapinException se) {
                    }
                    catch (NoSuchElementException nsee) {}
                    break;
                }
                ++iCount;
            }
        }
        return iCount;
    }

    public int moveEnumerationRight(BrowserObjectEntryEnumeration boee, int count) {
        int iCount = 0;
        if (boee != null) {
            for (int i = 0; i < count && boee.hasMoreElements() && boee.next() != null; ++i) {
                ++iCount;
            }
        }
        return iCount;
    }

    public boolean atFirst(BrowserObjectEntryEnumeration boee) {
        if (boee == null) {
            return true;
        }
        try {
            ObjectEntry prev = boee.previous();
            if (prev == null) {
                return true;
            }
            boee.next();
        }
        catch (SnapinException se) {
        }
        catch (NoSuchElementException nsee) {
            return true;
        }
        return false;
    }

    public boolean atLast(BrowserObjectEntryEnumeration boee) {
        if (boee == null) {
            return true;
        }
        try {
            ObjectEntry next = boee.next();
            if (next == null) {
                return true;
            }
            boee.previous();
        }
        catch (SnapinException se) {
        }
        catch (NoSuchElementException nsee) {
            return true;
        }
        return false;
    }

    public static String getUniqueString() {
        return "fw.OV" + uniqueStringCtr++;
    }

    private ArrayList splitTypeFilter(String s, Hashtable hAdvSelCrit) {
        ArrayList a = new ArrayList();
        if (s == null) {
            return a;
        }
        StringBuffer val = new StringBuffer("");
        for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            if (ch != ',') {
                val.append(ch);
                continue;
            }
            if (i + 1 < s.length() && s.charAt(i + 1) == ',') {
                val.append(',');
                ++i;
                continue;
            }
            this.addToArrayList(a, val.toString(), hAdvSelCrit);
            val.setLength(0);
        }
        this.addToArrayList(a, val.toString(), hAdvSelCrit);
        return a;
    }

    private void addToArrayList(ArrayList a, String s, Hashtable h) {
        if (s != null && (s = s.trim()).length() > 0 && h != null && h.get(s) == null) {
            if (s.equalsIgnoreCase("[root]")) {
                this.m_bRootSelectable = true;
            } else if (s.equalsIgnoreCase("[this]")) {
                this.m_bThisSelectable = true;
            } else if (s.equalsIgnoreCase("[public]")) {
                this.m_bPublicSelectable = true;
            } else if (s.equals("*")) {
                this.m_bMatchAllTypes = true;
            } else if (s.equals("[exclude-types]")) {
                this.m_bExcludeMode = true;
            } else if (s.equalsIgnoreCase("[containers]")) {
                this.m_bMatchAllContainers = true;
            } else if (s.equalsIgnoreCase("[non-partitions]")) {
                this.m_bMatchNonPartitionedContainers = true;
            } else if (s.equalsIgnoreCase("[partitions]")) {
                this.m_bMatchAllPartitions = true;
            } else if (s.equalsIgnoreCase("[non-containers]")) {
                this.m_bMatchLeafObjects = true;
            } else if (s.equalsIgnoreCase("[glue]")) {
                this.m_bShowGlue = true;
            } else {
                a.add(s);
            }
        }
    }

    private boolean isValidRM(ResultModifier rm) {
        boolean bRet = false;
        if (rm != null) {
            FilterResultModifier.Filter[] rmfa;
            ResultModifierFilterEntry[] rmfe = rm.getFilters();
            if (rmfe != null && rmfe.length > 0) {
                bRet = true;
            } else if (rm instanceof FilterResultModifier && (rmfa = ((FilterResultModifier)rm).getFRMFilters()) != null && rmfa.length > 0) {
                bRet = true;
            }
        }
        return bRet;
    }

    private void dumpRM(ResultModifier rm) {
        if (!D.isDebugEnabled()) {
            return;
        }
        if (rm != null) {
            FilterResultModifier.Filter[] rmfa;
            D.log("OV: " + rm.getDescriptiveName());
            D.log("OV:      RM subcontainer search = " + rm.isSubContainerSearch());
            D.log("OV:      RM matchAdvCrit = " + rm.getSimpleAndOpAdvanced());
            D.log("OV:      RM showGlue = " + rm.getShowGlue());
            ResultModifierFilterEntry[] rmfe = rm.getFilters();
            if (rmfe != null && rmfe.length > 0) {
                for (int i = 0; i < rmfe.length; ++i) {
                    D.log("OV:      RM FilterEntry[" + i + "]");
                    D.log("OV:         nameFilter = <" + rmfe[i].getNameFilter() + ">");
                    String[] tf = rmfe[i].getTypeFilter();
                    if (tf == null || tf.length <= 0) continue;
                    for (int j = 0; j < tf.length; ++j) {
                        D.log("OV:         typeFilter[" + j + "] = " + tf[j]);
                    }
                }
            }
            if (rm instanceof FilterResultModifier && (rmfa = ((FilterResultModifier)rm).getFRMFilters()) != null && rmfa.length > 0) {
                for (int i = 0; i < rmfa.length; ++i) {
                    FilterResultModifier.Filter f = rmfa[i];
                    D.log("OV:      FRM Filter[" + i + "] type = " + f.getFilterTypeName());
                    FilterResultModifier.Filter.FilterItemGroupPair[] figp = f.getFilterItemGroupPairs();
                    if (figp == null || figp.length <= 0) continue;
                    for (int g = 0; g < figp.length; ++g) {
                        FilterResultModifier.FilterItemGroup.FilterItem[] fi;
                        D.log("OV:         FRM FilterGroup[" + g + "]  <" + figp[g].getLogicalFilter() + ">");
                        FilterResultModifier.FilterItemGroup fig = figp[g].getFilterItemGroup();
                        if (fig == null || (fi = fig.getFilterItems()) == null || fi.length <= 0) continue;
                        for (int r = 0; r < fi.length; ++r) {
                            String crit = fi[r].getAttributeName() + " " + fi[r].getCompareFilter() + " " + fi[r].getAttributeValue() + "  <" + fi[r].getLogicalFilter() + ">";
                            D.log("OV:            FRM criterion[" + r + "] => " + crit);
                        }
                    }
                }
            }
        }
    }
}

