/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.fw;

import com.novell.admin.common.exceptions.SPIException;
import com.novell.admin.ns.NSObject;
import com.novell.admin.ns.nds.NDSNamespace;
import com.novell.application.console.snapin.ObjectEntry;
import com.novell.emframe.dev.MappingObject;
import com.novell.emframe.dev.TaskContext;
import com.novell.rbs.RBSAssociatedObject;
import com.novell.rbs.RBSCollection;
import com.novell.rbs.RBSRights;
import com.novell.rbs.RBSUtil;

public class PortalUtil {
    public static NSObject getPortalObjectNSObject(TaskContext context, NDSNamespace ns, ObjectEntry treeOE) throws SPIException {
        NSObject portalNSObject = null;
        MappingObject mappingObject = context.getDirUtils().getMappingObject();
        String portalObjDN = "cn=portal,o=nps";
        if ((portalObjDN = mappingObject.LDAPNameToNDSName(portalObjDN, false, false)).startsWith(".")) {
            portalObjDN = portalObjDN.substring(1, portalObjDN.length());
        }
        ObjectEntry portalObjectOE = ns.getObjectEntry(treeOE, portalObjDN);
        portalNSObject = ns.getDetails(portalObjectOE);
        return portalNSObject;
    }

    public static void removeCollectionOwnerFromPoral(NSObject taskNSObject, NSObject portalNSObject, ObjectEntry[] oldOwnerListOE, NDSNamespace ns) throws Exception {
        if (oldOwnerListOE == null) {
            return;
        }
        for (int i = 0; i < oldOwnerListOE.length; ++i) {
            RBSAssociatedObject rbsAssociatedObject = new RBSAssociatedObject(oldOwnerListOE[i]);
            RBSCollection[] rbsCollection = rbsAssociatedObject.getOwnedCollections2();
            if (rbsCollection != null) continue;
            RBSRights bhObjectRights = new RBSRights(ns.getUnrootedName(oldOwnerListOE[i]), "bhObjectList", 32L);
            RBSUtil.removeACLRights((NSObject)portalNSObject, (RBSRights)bhObjectRights);
            RBSRights bhConfigRights = new RBSRights(ns.getUnrootedName(oldOwnerListOE[i]), "bhConfig", 32L);
            RBSUtil.removeACLRights((NSObject)portalNSObject, (RBSRights)bhConfigRights);
            RBSRights bhObjectGuidRights = new RBSRights(ns.getUnrootedName(oldOwnerListOE[i]), "bhObjectGUID", 2L);
            RBSUtil.removeACLRights((NSObject)portalNSObject, (RBSRights)bhObjectGuidRights);
            RBSRights entryRights = new RBSRights(ns.getUnrootedName(oldOwnerListOE[i]), "[Entry Rights]", RBSUtil.setInheritableBit((String)"[Entry Rights]", (long)80L, (String)"true"));
            RBSUtil.removeACLRights((NSObject)taskNSObject, (RBSRights)entryRights);
        }
    }

    public static void addCollectionOwnerToPoral(NSObject taskNSObject, NSObject portalNSObject, ObjectEntry[] newOwnerListOE, NDSNamespace ns) throws Exception {
        if (newOwnerListOE == null) {
            return;
        }
        for (int i = 0; i < newOwnerListOE.length; ++i) {
            RBSRights bhObjectRights = new RBSRights(ns.getUnrootedName(newOwnerListOE[i]), "bhObjectList", 32L);
            RBSUtil.addACLRights((NSObject)portalNSObject, (RBSRights)bhObjectRights);
            RBSRights bhConfigRights = new RBSRights(ns.getUnrootedName(newOwnerListOE[i]), "bhConfig", 32L);
            RBSUtil.addACLRights((NSObject)portalNSObject, (RBSRights)bhConfigRights);
            RBSRights bhObjectGuidRights = new RBSRights(ns.getUnrootedName(newOwnerListOE[i]), "bhObjectGUID", 2L);
            RBSUtil.addACLRights((NSObject)portalNSObject, (RBSRights)bhObjectGuidRights);
            RBSRights entryRights = new RBSRights(ns.getUnrootedName(newOwnerListOE[i]), "[Entry Rights]", RBSUtil.setInheritableBit((String)"[Entry Rights]", (long)80L, (String)"true"));
            RBSUtil.addACLRights((NSObject)taskNSObject, (RBSRights)entryRights);
        }
    }
}

