/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.fw;

import com.novell.emframe.dev.TaskContext;
import com.novell.rbs.RBSRoleReport;
import java.text.Collator;
import java.util.Comparator;

public class RBSRoleReportSort
implements Comparator {
    public static final String SORT_DESCENDING = "descending";
    public static final String SORT_ASCENDING = "ascending";
    public static final String SORT_ROLE_NAME = "sortRoleName";
    public static final String SORT_ROLE_OBJECT = "sortRoleObject";
    public static final String SORT_TYPE = "sortType";
    public static final String SORT_MEMBER = "sortMember";
    public static final String SORT_SCOPE = "sortScope";
    public static final String SORT_ASSIGNED = "sortAssigned";
    public static final String SORT_INHERIT = "sortInherit";
    Collator m_collator = null;
    TaskContext m_context = null;
    String m_sortColumn = null;
    String m_sortDirection = null;

    public RBSRoleReportSort(TaskContext context, String sortColumn, String sortDirection) {
        this.m_context = context;
        this.m_sortColumn = sortColumn;
        this.m_sortDirection = sortDirection;
        this.m_collator = Collator.getInstance(this.m_context.getBrowserLocale().getLocale());
    }

    public int compare(Object object1, Object object2) {
        int compare = 0;
        if (this.m_sortColumn.equalsIgnoreCase(SORT_ROLE_NAME)) {
            String roleName1 = ((RBSRoleReport)object1).getRoleDisplayName();
            String roleName2 = ((RBSRoleReport)object2).getRoleDisplayName();
            compare = this.compareString(this.m_sortDirection, roleName1, roleName2);
        } else if (this.m_sortColumn.equalsIgnoreCase(SORT_ROLE_OBJECT)) {
            String roleObject1 = ((RBSRoleReport)object1).getRoleFDN();
            String roleObject2 = ((RBSRoleReport)object2).getRoleFDN();
            compare = this.compareString(this.m_sortDirection, roleObject1, roleObject2);
        } else if (this.m_sortColumn.equalsIgnoreCase(SORT_TYPE)) {
            int type1 = ((RBSRoleReport)object1).getType();
            int type2 = ((RBSRoleReport)object2).getType();
            compare = this.compareType(this.m_sortDirection, type1, type2);
        } else if (this.m_sortColumn.equalsIgnoreCase(SORT_MEMBER)) {
            String member1 = ((RBSRoleReport)object1).getMemberFDN();
            String member2 = ((RBSRoleReport)object2).getMemberFDN();
            compare = this.compareString(this.m_sortDirection, member1, member2);
        } else if (this.m_sortColumn.equalsIgnoreCase(SORT_SCOPE)) {
            String scope1 = ((RBSRoleReport)object1).getScopeFDN();
            String scope2 = ((RBSRoleReport)object2).getScopeFDN();
            compare = this.compareString(this.m_sortDirection, scope1, scope2);
        } else if (this.m_sortColumn.equalsIgnoreCase(SORT_ASSIGNED)) {
            boolean scope1 = ((RBSRoleReport)object1).getRightsSet();
            boolean scope2 = ((RBSRoleReport)object2).getRightsSet();
            compare = this.compareBoolean(this.m_sortDirection, scope1, scope2);
        } else if (this.m_sortColumn.equalsIgnoreCase(SORT_INHERIT)) {
            String scope1 = ((RBSRoleReport)object1).getInherited();
            String scope2 = ((RBSRoleReport)object2).getInherited();
            compare = this.compareString(this.m_sortDirection, scope1, scope2);
        }
        return compare;
    }

    private int compareString(String sortDirection, String object1, String object2) {
        int compare = 0;
        compare = sortDirection.equals(SORT_DESCENDING) ? this.m_collator.compare(object1, object2) : this.m_collator.compare(object2, object1);
        return compare;
    }

    private int compareType(String sortDirection, int object1, int object2) {
        int compare = 0;
        compare = sortDirection.equals(SORT_DESCENDING) ? (object1 == object2 ? 0 : (object1 > object2 ? 1 : -1)) : (object2 == object1 ? 0 : (object2 > object1 ? 1 : -1));
        return compare;
    }

    private int compareBoolean(String sortDirection, boolean object1, boolean object2) {
        int compare = 0;
        compare = sortDirection.equals(SORT_DESCENDING) ? (object1 && object2 || !object1 && !object2 ? 0 : (object1 && !object2 ? 1 : -1)) : (object1 && object2 || !object1 && !object2 ? 0 : (!object1 && object2 ? 1 : -1));
        return compare;
    }
}

