/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.fw;

import com.novell.admin.common.exceptions.SPIException;
import com.novell.admin.ns.AdminNamespace;
import com.novell.admin.ns.AttributeDefinition;
import com.novell.admin.ns.Rights;
import com.novell.admin.ns.SchemaDefinition;
import com.novell.application.console.snapin.ObjectEntry;
import com.novell.emframe.dev.D;
import com.novell.emframe.dev.DirUtils;
import com.novell.emframe.dev.TaskContext;
import com.novell.emframe.fw.MapHelper;
import com.novell.emframe.fw.RightsBean;
import java.util.ArrayList;
import java.util.HashMap;

public class RightsCache
extends MapHelper {
    ObjectEntry m_targetOE = null;
    ObjectEntry m_trusteeOE = null;
    HashMap m_rightsCache = new HashMap();
    AdminNamespace m_namespace = null;
    SchemaDefinition m_schema = null;
    DirUtils m_dirUtils = null;

    RightsCache() {
    }

    public RightsCache(ObjectEntry targetOE, ObjectEntry trusteeOE, TaskContext context) throws SPIException {
        this.m_targetOE = targetOE;
        this.m_trusteeOE = trusteeOE;
        this.m_namespace = this.m_targetOE.getAdminNamespace();
        this.m_schema = this.m_namespace.getSchemaDefinition(this.m_targetOE);
        this.m_dirUtils = context.getDirUtils();
    }

    public Object get(Object object) {
        String attribute = this.m_dirUtils.getRealName((String)object);
        Object value = this.m_rightsCache.get(attribute);
        if (value == null) {
            String[] attrs = new String[]{attribute};
            this.readRights(attrs);
            value = this.m_rightsCache.get(attribute);
        }
        return value;
    }

    public void readRights(String[] attributes) {
        int i = 0;
        ArrayList<String> attrsToRead = new ArrayList<String>();
        for (int j = 0; j < attributes.length; ++j) {
            if (this.m_rightsCache.get(attributes[j]) != null) continue;
            attrsToRead.add(attributes[j]);
        }
        attributes = attrsToRead.toArray(new String[attrsToRead.size()]);
        try {
            Rights[] rights = this.m_namespace.getPropertyEffectiveRights(this.m_targetOE, this.m_trusteeOE, attributes);
            for (i = 0; rights != null && i < rights.length; ++i) {
                AttributeDefinition attrDef = this.m_schema.getAttributeDefinition(attributes[i]);
                if (attrDef.isReadOnly()) {
                    this.m_rightsCache.put(attributes[i], new RightsBean(true, false));
                    continue;
                }
                this.m_rightsCache.put(attributes[i], new RightsBean(rights[i]));
            }
        }
        catch (Exception e) {
            D.log("Attribute does not exist: " + attributes[i]);
            D.log(e);
        }
    }
}

