/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.fw;

import com.novell.admin.ns.AdminNamespace;
import com.novell.emframe.dev.DirUtils;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;

public final class RoleAssocObject
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String objectName = null;
    private String objectDisplayName = null;
    private Hashtable scopeList = new Hashtable();
    private int tempScopeCount = 0;

    public RoleAssocObject(AdminNamespace ns, String objectName) {
        this.objectName = objectName;
        this.objectDisplayName = DirUtils.getLeftMostName(ns, objectName);
    }

    public RoleAssocObject(AdminNamespace ns, String objectName, String scopeName, String inheritable, String assignRights) {
        this.objectName = objectName;
        this.objectDisplayName = DirUtils.getLeftMostName(ns, objectName);
        this.addScope(scopeName, inheritable, assignRights);
    }

    public String getName() {
        return this.objectName;
    }

    public String getDisplayName() {
        return this.objectDisplayName;
    }

    public void addScope(String scopeName, String inheritable, String assignRights) {
        String genericScopeName = scopeName.toLowerCase();
        String tempScopeName = "tempscope";
        Enumeration scopesEnum = this.getScopes();
        boolean foundScope = false;
        String[] rightsInherit = new String[]{"false", "false"};
        while (scopesEnum.hasMoreElements()) {
            String scopeFromTable = ((String)scopesEnum.nextElement()).toLowerCase();
            scopeFromTable.toLowerCase();
            if (scopeFromTable.startsWith(tempScopeName)) {
                this.removeScope(scopeFromTable);
            }
            if (!genericScopeName.equals(scopeFromTable)) continue;
            foundScope = true;
        }
        if (!foundScope) {
            rightsInherit[0] = assignRights;
            rightsInherit[1] = inheritable;
            this.scopeList.put(scopeName, rightsInherit);
        }
    }

    public void addTempScope() {
        String tempScopeName = "tempscope";
        Enumeration scopesEnum = this.getScopes();
        boolean foundTempScope = false;
        String[] rightsInherit = new String[]{"false", "false"};
        while (scopesEnum.hasMoreElements()) {
            String scopeFromTable = (String)scopesEnum.nextElement();
            scopeFromTable.toLowerCase();
            if (!scopeFromTable.startsWith(tempScopeName)) continue;
            foundTempScope = true;
            tempScopeName = tempScopeName + (this.tempScopeCount + 1);
            ++this.tempScopeCount;
        }
        if (!foundTempScope) {
            this.scopeList.put(tempScopeName, rightsInherit);
        }
    }

    public void removeScope(String scopeName) {
        this.scopeList.remove(scopeName);
    }

    public void modifyScopeInheritance(String scopeName, String inheritable) {
        if (this.scopeList.containsKey(scopeName)) {
            String[] rightsInherit = (String[])this.scopeList.get(scopeName);
            rightsInherit[1] = inheritable;
            this.scopeList.put(scopeName, rightsInherit);
        }
    }

    public void modifyScopeAssignRights(String scopeName, String assignRights) {
        String[] rightsInherit = (String[])this.scopeList.get(scopeName);
        rightsInherit[0] = assignRights;
        this.scopeList.put(scopeName, rightsInherit);
    }

    public boolean doesScopeExist(String scopeName) {
        return this.scopeList.containsKey(scopeName);
    }

    public int getScopeCount() {
        int count = 0;
        if (this.scopeList == null || this.scopeList.isEmpty()) {
            return count;
        }
        count = this.scopeList.size();
        return count;
    }

    public Enumeration getScopes() {
        return this.scopeList.keys();
    }

    public Hashtable getScopeHastable() {
        return this.scopeList;
    }
}

