/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.fw;

import com.novell.admin.ns.nds.NDSNamespace;
import com.novell.admin.ns.nds.ObjectFlags;
import com.novell.application.console.snapin.ObjectEntry;
import com.novell.application.console.snapin.ObjectType;
import com.novell.emframe.dev.D;
import com.novell.emframe.dev.DirUtils;
import com.novell.emframe.dev.Task;
import com.novell.emframe.dev.TaskContext;
import com.novell.emframe.dev.eMFrameUtils;
import com.novell.emframe.fw.FwUtils;
import com.novell.emframe.fw.RBSReportUtil;
import com.novell.emframe.fw.RBSRoleReportSort;
import com.novell.emframe.fw.ReportsExportUtil;
import com.novell.nps.gadgetManager.GadgetInstanceException;
import com.novell.rbs.RBSAssociatedObject;
import com.novell.rbs.RBSRoleReport;
import com.novell.webaccess.common.I18NServletRequest;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Locale;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public final class RolesToUserReport
extends Task {
    private static final long serialVersionUID = 1L;
    private TaskContext m_context;
    private Properties m_resultStrings;
    private HttpServletRequest m_req;
    private NDSNamespace m_ns;
    private ObjectEntry m_treeOE;
    private String m_directReport;
    private String m_groupReport;
    private String m_containerReport;
    private String m_dynamicGroupReport;
    private String m_orgRoleReport;
    private ReportThread reportThread;
    private boolean m_stopThread;
    private boolean m_threadDone;
    ArrayList m_errors = new ArrayList();
    private String m_progressMessage = "";
    private int m_reportsNotRead = 0;
    private int m_totalReportsCount = 0;
    private int m_reportCount = 0;
    private ArrayList m_reportList = new ArrayList();
    private String m_sortColumn;
    private String m_sortDirection;
    private String m_selectedUserFDN;
    private ObjectEntry m_userOE;
    private String m_reportTime;
    private String m_selectedMemberTypes;
    private String m_roleDiscoveryDomain;
    private String m_dynamicGroupEnabled;
    private String m_dynamicGroupDiscoveryDomain;
    private String m_dynamicGroupSearchType;
    private String m_inProgress = "false";
    private String m_progressCancelled = "false";
    private String m_roleDiscoveryDomainDisplayName;
    private ReportsExportUtil m_exportUtil = null;

    public static void shouldRun(HttpServletRequest req, String sServiceName) throws Exception {
        FwUtils.verifyRbsInstalled(req, sServiceName);
    }

    public boolean execute(TaskContext context, Properties resultStrings) {
        this.m_context = context;
        this.m_resultStrings = resultStrings;
        this.m_req = this.m_context.getRequest();
        this.m_treeOE = (ObjectEntry)this.m_context.getAuthenticationBroker().getAPIObject("NDSNamespace");
        this.m_ns = (NDSNamespace)this.m_treeOE.getNamespace();
        String nextState = this.m_req.getParameter("nextState");
        if (nextState == null || nextState.equalsIgnoreCase("initialState")) {
            return this.initialState();
        }
        if (nextState.equalsIgnoreCase("getRolesReport")) {
            return this.getRolesReport();
        }
        if (nextState.equalsIgnoreCase("refresh")) {
            return this.refresh();
        }
        if (nextState.equalsIgnoreCase("cancel")) {
            return this.cancel();
        }
        if (nextState.equalsIgnoreCase("finished")) {
            return this.finished();
        }
        if (nextState.equalsIgnoreCase("sortByColumn")) {
            return this.sortByColumn();
        }
        if (nextState.equalsIgnoreCase("exportReport")) {
            return this.handleExportFile();
        }
        return true;
    }

    private boolean initialState() {
        this.m_dynamicGroupEnabled = RBSReportUtil.isDynamicGroupEnabled(this.m_context);
        this.m_req.setAttribute("dynamicGroupEnabled", (Object)this.m_dynamicGroupEnabled);
        this.m_req.setAttribute("inProgress", (Object)this.m_inProgress);
        this.m_req.setAttribute("progressCancelled", (Object)this.m_progressCancelled);
        this.m_req.setAttribute("directChecked", (Object)"true");
        this.m_req.setAttribute("groupChecked", (Object)"true");
        this.m_req.setAttribute("dGroupChecked", (Object)"true");
        this.m_req.setAttribute("orgRoleChecked", (Object)"true");
        this.m_req.setAttribute("containerChecked", (Object)"true");
        this.m_req.setAttribute("SelectedUserFDN", (Object)"");
        return true;
    }

    private boolean getRolesReport() {
        this.m_selectedMemberTypes = "";
        this.m_totalReportsCount = 0;
        this.m_reportCount = 0;
        this.m_selectedUserFDN = this.m_req.getParameter("SelectedUserFDN");
        this.m_reportList.clear();
        this.m_directReport = this.m_req.getParameter("directCB");
        if (this.m_directReport != null) {
            this.m_selectedMemberTypes = this.formatMemberTypeString(this.m_totalReportsCount, eMFrameUtils.getLocalizedString("FwResources", "RolesToUserReport.User", this.m_context), this.m_selectedMemberTypes);
            this.m_directReport = "true";
            ++this.m_totalReportsCount;
        } else {
            this.m_directReport = "false";
        }
        this.m_groupReport = this.m_req.getParameter("groupCB");
        if (this.m_groupReport != null) {
            this.m_selectedMemberTypes = this.formatMemberTypeString(this.m_totalReportsCount, eMFrameUtils.getLocalizedString("FwResources", "RolesToUserReport.Group", this.m_context), this.m_selectedMemberTypes);
            this.m_groupReport = "true";
            ++this.m_totalReportsCount;
        } else {
            this.m_groupReport = "false";
        }
        this.m_dynamicGroupReport = this.m_req.getParameter("dynamicGroupCB");
        if (this.m_dynamicGroupReport != null) {
            this.m_selectedMemberTypes = this.formatMemberTypeString(this.m_totalReportsCount, eMFrameUtils.getLocalizedString("FwResources", "RolesToUserReport.DynamicGroup", this.m_context), this.m_selectedMemberTypes);
            this.m_dynamicGroupReport = "true";
            ++this.m_totalReportsCount;
        } else {
            this.m_dynamicGroupReport = "false";
        }
        this.m_orgRoleReport = this.m_req.getParameter("orgRoleCB");
        if (this.m_orgRoleReport != null) {
            this.m_selectedMemberTypes = this.formatMemberTypeString(this.m_totalReportsCount, eMFrameUtils.getLocalizedString("FwResources", "RolesToUserReport.OrganizationalRole", this.m_context), this.m_selectedMemberTypes);
            this.m_orgRoleReport = "true";
            ++this.m_totalReportsCount;
        } else {
            this.m_orgRoleReport = "false";
        }
        this.m_containerReport = this.m_req.getParameter("containerCB");
        if (this.m_containerReport != null) {
            this.m_selectedMemberTypes = this.formatMemberTypeString(this.m_totalReportsCount, eMFrameUtils.getLocalizedString("FwResources", "RolesToUserReport.Container", this.m_context), this.m_selectedMemberTypes);
            this.m_containerReport = "true";
            ++this.m_totalReportsCount;
        } else {
            this.m_containerReport = "false";
        }
        try {
            this.m_userOE = this.m_ns.getObjectEntry(this.m_treeOE, this.m_selectedUserFDN);
            ObjectType objectType = this.m_userOE.getObjectType();
            if (!DirUtils.isOfType(objectType, "User", true)) {
                String strError = eMFrameUtils.getLocalizedString("FwResources", "RolesToUserReport.WrongObject", this.m_context);
                String strTitle = eMFrameUtils.getLocalizedString("FwResources", "Error", this.m_context);
                eMFrameUtils.setMessage("error", strTitle, strError, this.m_context);
                return false;
            }
            this.m_context.addToHistory(this.m_userOE);
        }
        catch (Exception exc) {
            D.log(exc);
            eMFrameUtils.setErrorMessage(exc, this.m_context);
            return false;
        }
        this.m_roleDiscoveryDomain = RBSReportUtil.getRoleDiscoveryDomain(this.m_context);
        this.m_dynamicGroupDiscoveryDomain = RBSReportUtil.getDynamicGroupDiscoveryDomain(this.m_context);
        this.m_dynamicGroupSearchType = RBSReportUtil.getDynamicGroupSearchType(this.m_context);
        this.m_progressMessage = eMFrameUtils.getLocalizedString("FwResources", "RolesToUserReport.Initializing", this.m_context);
        this.m_inProgress = "true";
        String url = new String("webacc?taskId=" + eMFrameUtils.urlEncode(this.m_req.getParameter("taskId"), this.m_context) + "&merge=fw.GetRolesUserNameForm&User.context=" + this.m_req.getParameter("User.context") + "&nextState=refresh" + "&inProgress=" + this.m_inProgress + "&progressMessage=" + this.m_progressMessage + "&directChecked=" + this.m_directReport + "&groupChecked=" + this.m_groupReport + "&dGroupChecked=" + this.m_dynamicGroupReport + "&orgRoleChecked=" + this.m_orgRoleReport + "&containerChecked=" + this.m_containerReport + "&dynamicGroupEnabled=" + this.m_dynamicGroupEnabled + "&SelectedUserFDN=" + this.m_selectedUserFDN);
        this.m_resultStrings.put("UrlTask.url", url);
        ((I18NServletRequest)this.m_req).setParameter("merge", "fw.UrlTask");
        Date date = new Date();
        Locale locale = this.m_context.getLocale();
        String reportTime = DateFormat.getDateInstance(0, locale).format(date);
        String reportDate = DateFormat.getTimeInstance(0, locale).format(date);
        this.m_reportTime = eMFrameUtils.formatMessage("{0} ({1})", new String[]{reportTime, reportDate});
        this.m_stopThread = false;
        this.m_threadDone = false;
        this.reportThread = new ReportThread(this.m_userOE);
        this.reportThread.start();
        return true;
    }

    private boolean refresh() {
        String taskId = this.m_req.getParameter("taskId");
        String userContext = this.m_req.getParameter("User.context");
        if (!this.m_threadDone) {
            if (this.m_reportCount == 0) {
                this.m_progressMessage = eMFrameUtils.getLocalizedString("FwResources", "RolesToUserReport.Initializing", this.m_context);
            } else {
                Object[] values = new String[]{Integer.toString(this.m_reportCount), Integer.toString(this.m_totalReportsCount)};
                this.m_progressMessage = eMFrameUtils.formatMessage(eMFrameUtils.getLocalizedString("FwResources", "RolesToUserReport.ReadingReport", this.m_context), values);
            }
            this.m_resultStrings.put("progressMessage", this.m_progressMessage);
        } else {
            String url = new String("webacc?taskId=" + eMFrameUtils.urlEncode(taskId, this.m_context) + "&User.context=" + userContext + "&nextState=finished");
            if (this.m_errors.size() > 0) {
                url = url + "&merge=dev.MooGenErr&GeneralMsg.Mode=error";
            }
            this.m_resultStrings.put("UrlTask.url", url);
            ((I18NServletRequest)this.m_req).setParameter("merge", "fw.UrlTask");
        }
        return true;
    }

    private boolean cancel() {
        this.m_stopThread = true;
        this.m_inProgress = "false";
        this.m_progressCancelled = "true";
        this.m_req.setAttribute("inProgress", (Object)this.m_inProgress);
        this.m_req.setAttribute("progressCancelled", (Object)this.m_progressCancelled);
        this.m_req.setAttribute("dynamicGroupEnabled", (Object)this.m_dynamicGroupEnabled);
        this.m_req.setAttribute("dynamicGroupEnabledDisplayName", (Object)this.getDynamicGroupEnabledDisplayName(this.m_dynamicGroupEnabled));
        this.m_req.setAttribute("inProgress", (Object)this.m_inProgress);
        this.m_req.setAttribute("directChecked", (Object)this.m_directReport);
        this.m_req.setAttribute("groupChecked", (Object)this.m_groupReport);
        this.m_req.setAttribute("dGroupChecked", (Object)this.m_dynamicGroupReport);
        this.m_req.setAttribute("orgRoleChecked", (Object)this.m_orgRoleReport);
        this.m_req.setAttribute("containerChecked", (Object)this.m_containerReport);
        this.m_req.setAttribute("SelectedUserFDN", (Object)this.m_selectedUserFDN);
        return true;
    }

    private boolean finished() {
        if (this.m_errors.size() > 0) {
            String strTitle = eMFrameUtils.getLocalizedString("FwResources", "RolesToUserReport.ErrorTitle", this.m_context);
            String strBody = eMFrameUtils.getLocalizedString("FwResources", "RolesToUserReport.ErrorBody", this.m_context);
            Object[] values = new String[]{Integer.toString(this.m_totalReportsCount - this.m_reportsNotRead), Integer.toString(this.m_totalReportsCount)};
            eMFrameUtils.setMooErrorMessage(this.m_resultStrings, strTitle, eMFrameUtils.formatMessage(strBody, values), this.m_errors);
        } else {
            this.m_req.setAttribute("roleReportData", (Object)this.m_reportList);
            this.m_req.setAttribute("sortColumn", (Object)this.m_sortColumn);
            this.m_req.setAttribute("sortDirection", (Object)this.m_sortDirection);
            this.m_req.setAttribute("selectedUserFDN", (Object)this.m_selectedUserFDN);
            this.m_req.setAttribute("reportTime", (Object)this.m_reportTime);
            this.m_req.setAttribute("selectedMemberTypes", (Object)this.m_selectedMemberTypes);
            this.m_req.setAttribute("dynamicGroupEnabled", (Object)this.m_dynamicGroupEnabled);
            this.m_req.setAttribute("dynamicGroupEnabledDisplayName", (Object)this.getDynamicGroupEnabledDisplayName(this.m_dynamicGroupEnabled));
            this.m_roleDiscoveryDomainDisplayName = this.getRoleDiscoveryDomainDisplayName(this.m_roleDiscoveryDomain);
            this.m_req.setAttribute("roleDiscoveryDomain", (Object)this.m_roleDiscoveryDomainDisplayName);
            this.m_req.setAttribute("dynamicGroupDiscoveryDomain", (Object)this.m_dynamicGroupDiscoveryDomain);
            this.m_req.setAttribute("dynamicGroupDiscoveryDomainDisplayName", (Object)this.getDynamicGroupDiscoveryDomainDisplayName(this.m_dynamicGroupDiscoveryDomain));
            this.m_req.setAttribute("dynamicGroupSearchType", (Object)this.m_dynamicGroupSearchType);
            this.m_req.setAttribute("dynamicGroupSearchTypeDisplayName", (Object)this.getDynamicGroupSearchTypeDisplayName(this.m_dynamicGroupSearchType));
            this.m_req.setAttribute("containerChecked", (Object)this.m_containerReport);
            this.m_req.setAttribute("dGroupChecked", (Object)this.m_dynamicGroupReport);
            String taskId = this.m_req.getParameter("taskId");
            String userContext = this.m_req.getParameter("User.context");
            String url = new String("webacc?taskId=" + eMFrameUtils.urlEncode(taskId, this.m_context) + "&User.context=" + userContext);
            this.m_resultStrings.put("UrlTask.url", url);
            ((I18NServletRequest)this.m_req).setParameter("merge", "fw.RolesToUserReport");
        }
        return true;
    }

    private boolean sortByColumn() {
        this.m_sortColumn = this.m_req.getParameter("sortColumn");
        this.m_sortDirection = this.m_req.getParameter("sortDirection");
        Collections.sort(this.m_reportList, new RBSRoleReportSort(this.m_context, this.m_sortColumn, this.m_sortDirection));
        this.m_req.setAttribute("roleReportData", (Object)this.m_reportList);
        this.m_req.setAttribute("selectedUserFDN", (Object)this.m_selectedUserFDN);
        this.m_req.setAttribute("reportTime", (Object)this.m_reportTime);
        this.m_req.setAttribute("sortColumn", (Object)this.m_sortColumn);
        this.m_req.setAttribute("sortDirection", (Object)this.m_sortDirection);
        this.m_req.setAttribute("selectedMemberTypes", (Object)this.m_selectedMemberTypes);
        this.m_req.setAttribute("dynamicGroupEnabled", (Object)this.m_dynamicGroupEnabled);
        this.m_req.setAttribute("dynamicGroupEnabledDisplayName", (Object)this.getDynamicGroupEnabledDisplayName(this.m_dynamicGroupEnabled));
        this.m_req.setAttribute("roleDiscoveryDomain", (Object)this.m_roleDiscoveryDomainDisplayName);
        this.m_req.setAttribute("dynamicGroupDiscoveryDomain", (Object)this.m_dynamicGroupDiscoveryDomain);
        this.m_req.setAttribute("dynamicGroupDiscoveryDomainDisplayName", (Object)this.getDynamicGroupDiscoveryDomainDisplayName(this.m_dynamicGroupDiscoveryDomain));
        this.m_req.setAttribute("dynamicGroupSearchType", (Object)this.m_dynamicGroupSearchType);
        this.m_req.setAttribute("dynamicGroupSearchTypeDisplayName", (Object)this.getDynamicGroupSearchTypeDisplayName(this.m_dynamicGroupSearchType));
        this.m_req.setAttribute("containerChecked", (Object)this.m_containerReport);
        this.m_req.setAttribute("dGroupChecked", (Object)this.m_dynamicGroupReport);
        return true;
    }

    private String getDynamicGroupDiscoveryDomainDisplayName(String dynamicGroupDiscoveryDomain) {
        String displayName = null;
        if (dynamicGroupDiscoveryDomain.equalsIgnoreCase("parent")) {
            String parentName = this.m_ns.getUnrootedName(this.m_userOE.getParent());
            String parent = eMFrameUtils.getLocalizedString("FwResources", "RBSReport.FromParent", this.m_context);
            displayName = eMFrameUtils.formatMessage("{0} ({1})", new String[]{parent, parentName});
        } else if (dynamicGroupDiscoveryDomain.equalsIgnoreCase("partition")) {
            ObjectEntry partitionOE;
            for (partitionOE = this.m_userOE.getParent(); partitionOE != null && !ObjectFlags.isPartition((long)partitionOE.getObjectFlags()); partitionOE = partitionOE.getParent()) {
            }
            String partitionName = this.m_ns.getUnrootedName(partitionOE);
            if (partitionName.equals("")) {
                partitionName = partitionOE.getFullName();
            }
            String partition = eMFrameUtils.getLocalizedString("FwResources", "RBSReport.FromPartition", this.m_context);
            displayName = eMFrameUtils.formatMessage("{0} ({1})", new String[]{partition, partitionName});
        } else {
            String rootName = this.m_userOE.getRoot().getFullName();
            String root = eMFrameUtils.getLocalizedString("FwResources", "RBSReport.FromRoot", this.m_context);
            displayName = eMFrameUtils.formatMessage("{0} ({1})", new String[]{root, rootName});
        }
        return displayName;
    }

    private String getDynamicGroupSearchTypeDisplayName(String dynamicGroupSearchType) {
        String displayName = eMFrameUtils.getLocalizedString("FwResources", "RBSReport.DynamicGroupObjects", this.m_context);
        if (dynamicGroupSearchType.equalsIgnoreCase("DynamicGroupObjects&AuxClasses")) {
            displayName = displayName + ", ";
            displayName = displayName + eMFrameUtils.getLocalizedString("FwResources", "RBSReport.DynamicGroupAuxClassObjects", this.m_context);
        }
        return displayName;
    }

    private String getDynamicGroupEnabledDisplayName(String dynamicGroupEnabled) {
        String displayName = null;
        displayName = dynamicGroupEnabled.equalsIgnoreCase("true") ? eMFrameUtils.getLocalizedString("FwResources", "RBSReport.Yes", this.m_context) : eMFrameUtils.getLocalizedString("FwResources", "RBSReport.No", this.m_context);
        return displayName;
    }

    private String getRoleDiscoveryDomainDisplayName(String roleDiscoveryDomain) {
        String displayName = null;
        if (roleDiscoveryDomain.equalsIgnoreCase("parent")) {
            String parentName = this.m_ns.getUnrootedName(this.m_userOE.getParent());
            String parent = eMFrameUtils.getLocalizedString("FwResources", "RBSReport.UpToParent", this.m_context);
            displayName = eMFrameUtils.formatMessage("{0} ({1})", new String[]{parent, parentName});
        } else if (roleDiscoveryDomain.equalsIgnoreCase("partition")) {
            ObjectEntry partitionOE;
            for (partitionOE = this.m_userOE.getParent(); partitionOE != null && !ObjectFlags.isPartition((long)partitionOE.getObjectFlags()); partitionOE = partitionOE.getParent()) {
            }
            String partitionName = this.m_ns.getUnrootedName(partitionOE);
            if (partitionName.equals("")) {
                partitionName = partitionOE.getFullName();
            }
            String partition = eMFrameUtils.getLocalizedString("FwResources", "RBSReport.UpToPartition", this.m_context);
            displayName = eMFrameUtils.formatMessage("{0} ({1})", new String[]{partition, partitionName});
        } else {
            String rootName = this.m_userOE.getRoot().getFullName();
            String root = eMFrameUtils.getLocalizedString("FwResources", "RBSReport.UpToRoot", this.m_context);
            displayName = eMFrameUtils.formatMessage("{0} ({1})", new String[]{root, rootName});
        }
        return displayName;
    }

    private String formatMemberTypeString(int totalReportsCount, String newType, String selectedMemberTypes) {
        if (totalReportsCount > 0) {
            selectedMemberTypes = selectedMemberTypes + ", ";
        }
        selectedMemberTypes = selectedMemberTypes + newType;
        return selectedMemberTypes;
    }

    private void getReportAssociations(ObjectEntry userOE) {
        String roleDisplayName;
        int i;
        this.m_errors.clear();
        RBSAssociatedObject rbsAssociatedObject = new RBSAssociatedObject(userOE);
        if (this.m_directReport.equals("true") && !this.m_stopThread) {
            ++this.m_reportCount;
            try {
                RBSRoleReport[] directRoleReport = rbsAssociatedObject.getDirectRoleReport(userOE);
                if (directRoleReport != null) {
                    for (i = 0; i < directRoleReport.length; ++i) {
                        roleDisplayName = RBSReportUtil.getRoleDisplayName(this.m_context, this.m_treeOE, directRoleReport[i].getRoleFDN());
                        if (roleDisplayName != null) {
                            directRoleReport[i].setRoleDisplayName(roleDisplayName);
                        }
                        this.m_reportList.add(directRoleReport[i]);
                    }
                }
            }
            catch (Exception exc) {
                D.log(exc);
                ++this.m_reportsNotRead;
                this.m_errors.add(new String[]{eMFrameUtils.getLocalizedString("FwResources", "RolesToUserReport.UserReport", this.m_context), eMFrameUtils.getLocalizedString("FwResources", "RolesToUserReport.ReadingReportRequestFailed", this.m_context), eMFrameUtils.getExceptionMessage(exc, this.m_context), ""});
            }
        }
        if (this.m_groupReport.equals("true") && !this.m_stopThread) {
            ++this.m_reportCount;
            try {
                RBSRoleReport[] groupRoleReport = rbsAssociatedObject.getGroupRoleReport();
                if (groupRoleReport != null) {
                    for (i = 0; i < groupRoleReport.length; ++i) {
                        roleDisplayName = RBSReportUtil.getRoleDisplayName(this.m_context, this.m_treeOE, groupRoleReport[i].getRoleFDN());
                        if (roleDisplayName != null) {
                            groupRoleReport[i].setRoleDisplayName(roleDisplayName);
                        }
                        this.m_reportList.add(groupRoleReport[i]);
                    }
                }
            }
            catch (Exception exc) {
                D.log(exc);
                ++this.m_reportsNotRead;
                this.m_errors.add(new String[]{eMFrameUtils.getLocalizedString("FwResources", "RolesToUserReport.GroupReport", this.m_context), eMFrameUtils.getLocalizedString("FwResources", "RolesToUserReport.ReadingReportRequestFailed", this.m_context), eMFrameUtils.getExceptionMessage(exc, this.m_context), ""});
            }
        }
        if (this.m_containerReport.equals("true") && !this.m_stopThread) {
            ++this.m_reportCount;
            try {
                RBSRoleReport[] containerRoleReport = rbsAssociatedObject.getContainerRoleReport(this.m_roleDiscoveryDomain);
                if (containerRoleReport != null) {
                    for (i = 0; i < containerRoleReport.length; ++i) {
                        roleDisplayName = RBSReportUtil.getRoleDisplayName(this.m_context, this.m_treeOE, containerRoleReport[i].getRoleFDN());
                        if (roleDisplayName != null) {
                            containerRoleReport[i].setRoleDisplayName(roleDisplayName);
                        }
                        this.m_reportList.add(containerRoleReport[i]);
                    }
                }
            }
            catch (Exception exc) {
                D.log(exc);
                ++this.m_reportsNotRead;
                this.m_errors.add(new String[]{eMFrameUtils.getLocalizedString("FwResources", "RolesToUserReport.ContainerReport", this.m_context), eMFrameUtils.getLocalizedString("FwResources", "RolesToUserReport.ReadingReportRequestFailed", this.m_context), eMFrameUtils.getExceptionMessage(exc, this.m_context), ""});
            }
        }
        if (this.m_dynamicGroupReport.equals("true") && !this.m_stopThread) {
            ++this.m_reportCount;
            try {
                RBSRoleReport[] dynamicGroupRoleReport = rbsAssociatedObject.getDynamicGroupRoleReport(this.m_dynamicGroupDiscoveryDomain, this.m_dynamicGroupSearchType);
                if (dynamicGroupRoleReport != null) {
                    for (i = 0; i < dynamicGroupRoleReport.length; ++i) {
                        roleDisplayName = RBSReportUtil.getRoleDisplayName(this.m_context, this.m_treeOE, dynamicGroupRoleReport[i].getRoleFDN());
                        if (roleDisplayName != null) {
                            dynamicGroupRoleReport[i].setRoleDisplayName(roleDisplayName);
                        }
                        this.m_reportList.add(dynamicGroupRoleReport[i]);
                    }
                }
            }
            catch (Exception exc) {
                D.log(exc);
                ++this.m_reportsNotRead;
                this.m_errors.add(new String[]{eMFrameUtils.getLocalizedString("FwResources", "RolesToUserReport.DynamicGroupReport", this.m_context), eMFrameUtils.getLocalizedString("FwResources", "RolesToUserReport.ReadingReportRequestFailed", this.m_context), eMFrameUtils.getExceptionMessage(exc, this.m_context), ""});
            }
        }
        if (this.m_orgRoleReport.equals("true") && !this.m_stopThread) {
            ++this.m_reportCount;
            try {
                RBSRoleReport[] orgRoleRoleReport = rbsAssociatedObject.getOrgRolesRoleReport();
                if (orgRoleRoleReport != null) {
                    for (i = 0; i < orgRoleRoleReport.length; ++i) {
                        roleDisplayName = RBSReportUtil.getRoleDisplayName(this.m_context, this.m_treeOE, orgRoleRoleReport[i].getRoleFDN());
                        if (roleDisplayName != null) {
                            orgRoleRoleReport[i].setRoleDisplayName(roleDisplayName);
                        }
                        this.m_reportList.add(orgRoleRoleReport[i]);
                    }
                }
            }
            catch (Exception exc) {
                D.log(exc);
                ++this.m_reportsNotRead;
                this.m_errors.add(new String[]{eMFrameUtils.getLocalizedString("FwResources", "RolesToUserReport.OrganizationalRoleReport", this.m_context), eMFrameUtils.getLocalizedString("FwResources", "RolesToUserReport.ReadingReportRequestFailed", this.m_context), eMFrameUtils.getExceptionMessage(exc, this.m_context), ""});
            }
        }
        this.m_sortColumn = "sortRoleName";
        this.m_sortDirection = "descending";
        Collections.sort(this.m_reportList, new RBSRoleReportSort(this.m_context, this.m_sortColumn, this.m_sortDirection));
    }

    public boolean handleExportFile() {
        String[] reportHeaderData = new String[]{this.m_selectedUserFDN, this.m_reportTime, this.m_selectedMemberTypes, this.m_dynamicGroupReport, this.getDynamicGroupEnabledDisplayName(this.m_dynamicGroupEnabled), this.m_dynamicGroupEnabled, this.getDynamicGroupDiscoveryDomainDisplayName(this.m_dynamicGroupDiscoveryDomain), this.getDynamicGroupSearchTypeDisplayName(this.m_dynamicGroupSearchType), this.m_containerReport, this.getRoleDiscoveryDomainDisplayName(this.m_roleDiscoveryDomain)};
        for (int i = 0; i < reportHeaderData.length; ++i) {
            if (reportHeaderData[i] != null && reportHeaderData[i].length() != 0) continue;
            System.out.println(i + " is Null");
            reportHeaderData[i] = "None";
        }
        if (this.m_context != null && this.m_reportList != null) {
            this.m_exportUtil = new ReportsExportUtil(this.m_context, this.m_reportList);
            this.m_exportUtil.exportRolesToUserReport(reportHeaderData);
        }
        return true;
    }

    public boolean handlePostRequestActions(HttpServletRequest req, HttpServletResponse resp) throws GadgetInstanceException {
        return this.m_exportUtil.sendRedirect(req, resp);
    }

    class ReportThread
    extends Thread {
        private ObjectEntry m_userOE;

        public ReportThread(ObjectEntry userOE) {
            this.setPriority(4);
            this.setDaemon(true);
            this.m_userOE = userOE;
        }

        public void run() {
            RolesToUserReport.this.getReportAssociations(this.m_userOE);
            RolesToUserReport.this.m_threadDone = true;
        }
    }
}

