/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.fw;

import com.novell.emframe.dev.D;
import com.novell.emframe.dev.MContext;
import com.novell.emframe.dev.MTask;
import com.novell.emframe.dev.config.SystemConfig;
import com.novell.emframe.fw.FwTaskContext;
import com.novell.emframe.fw.FwUtils;
import com.novell.emframe.fw.authenticator.FwAuthUtils;
import java.util.Locale;
import java.util.Vector;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class SelectLanguage
extends MTask {
    private static final long serialVersionUID = 1L;
    private SystemConfig m_sc = null;

    public void execute(MContext context) {
        if (this.m_sc == null) {
            this.m_sc = SystemConfig.getSystemConfig(context);
        }
        context.getPersistentData(null, "ClientLocale");
        HttpServletRequest req = context.getRequest();
        if (req != null) {
            String sAction;
            String[] saAvailableLangs = null;
            this.setUIPage("fw/SelectLanguage.jsp");
            saAvailableLangs = FwUtils.getAvailableLanguages();
            if (saAvailableLangs != null) {
                req.setAttribute("AvailableLanguages", (Object)saAvailableLangs);
            }
            if ((sAction = req.getParameter("moduleaction")) == null || sAction.length() == 0) {
                Locale loc = context.getLocale();
                if (loc != null) {
                    req.setAttribute("UserLocale", (Object)loc);
                }
            } else if (sAction.equalsIgnoreCase("SelectLanguageAction")) {
                Locale loc;
                String sTemp = req.getParameter("AvailableLanguages");
                Locale[] locales = FwUtils.getLocales(context.getSession());
                if (locales != null) {
                    int iFound = -1;
                    Locale targetLocale = FwUtils.instantiateLocale(sTemp);
                    Locale[] newLocales = new Locale[locales.length + 1];
                    newLocales[0] = targetLocale;
                    for (int i = 0; i < locales.length; ++i) {
                        newLocales[i + 1] = locales[i];
                        if (!targetLocale.equals(locales[i])) continue;
                        iFound = i;
                    }
                    if (iFound != -1) {
                        if (iFound != 0) {
                            Vector<Locale> v = new Vector<Locale>();
                            v.add(locales[iFound]);
                            for (int i = 0; i < locales.length; ++i) {
                                if (i == iFound) continue;
                                v.add(locales[i]);
                            }
                            v.toArray(locales);
                            FwUtils.setLocales(context.getSession(), locales);
                        }
                    } else {
                        FwUtils.setLocales(context.getSession(), newLocales);
                    }
                    this.setUIPage("fw/SelectLanguageClose.jsp");
                    FwAuthUtils.invalidateRolesAndTasksForAllAuths((FwTaskContext)context);
                }
                if ((loc = FwUtils.getCurrentLocale(context.getSession())) != null) {
                    req.setAttribute("UserLocale", (Object)loc);
                    String lang = loc.getLanguage();
                    if ("zh".equals(lang)) {
                        lang = loc.toString();
                    }
                    req.getSession().setAttribute("ClientLocale", (Object)lang);
                }
            }
        }
    }

    public void render(MContext context, HttpServletResponse response) {
        String cookieFlag = context.getRequest().getParameter("moduleaction");
        if (cookieFlag != null && cookieFlag.equalsIgnoreCase("SelectLanguageAction")) {
            Cookie ck = new Cookie("language", (String)context.getSession().getAttribute("ClientLocale"));
            String checked = context.getRequest().getParameter("langCookie");
            if ("on".equalsIgnoreCase(checked)) {
                ck.setMaxAge(2678400);
                D.log("Setting the language cookie");
            } else {
                ck.setMaxAge(0);
                D.log("Clearing the language cookie");
            }
            response.addCookie(ck);
        }
        super.render(context, response);
    }
}

