/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.fw;

import com.novell.application.console.snapin.ObjectEntry;
import com.novell.emframe.dev.AuthenticationBroker;
import com.novell.emframe.dev.D;
import com.novell.emframe.dev.Task;
import com.novell.emframe.dev.TaskContext;
import com.novell.emframe.dev.config.ConfigException;
import com.novell.emframe.dev.config.SystemConfig;
import com.novell.emframe.dev.eMFrameFactory;
import com.novell.emframe.dev.eMFrameUtils;
import com.novell.emframe.fw.AuditLog;
import com.novell.emframe.fw.DebugLogging;
import com.novell.emframe.fw.FwUtils;
import com.novell.emframe.fw.LookAndFeelDefaults;
import com.novell.emframe.fw.authenticator.DirAuthenticator;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;

public class SystemConfigurationTask
extends Task {
    private static final long serialVersionUID = 1L;
    private int m_iLoggingLevel = 0;
    private boolean m_bLoggingToErr = false;
    private boolean m_bLoggingToOut = true;
    private boolean m_bLoggingToFile = false;
    private String m_tabSelection = "SecurityTab";
    private String m_authenticatedProtocol = "eDirectory";
    private static final String NOVELL_DOWNLOAD_URL = "http://www.novell.com/products/consoles/imanager/iman_mod_desc.xml";

    public boolean execute(TaskContext context, Properties resultStrings) {
        HttpServletRequest req = context.getRequest();
        SystemConfig config = SystemConfig.getSystemConfig(context);
        if (!FwUtils.canConfigureiManager(req)) {
            eMFrameUtils.setMessage("error", eMFrameUtils.getLocalizedString("FwResources", "Error", context), eMFrameUtils.getLocalizedString("FwResources", "Configure.UserNotAuthorizedToConfigureiManager", context), context);
            return false;
        }
        if (req != null) {
            String nextState = req.getParameter("nextState");
            this.m_tabSelection = null == req.getParameter("selectedTab") ? "SecurityTab" : req.getParameter("selectedTab");
            if (nextState == null || nextState.length() == 0 || nextState.equalsIgnoreCase("initialState")) {
                this.initialState(req, resultStrings, config, context);
            } else if (nextState.equals("SaveConfiguration")) {
                try {
                    this.applyLookAndFeelSettings(config, req, context);
                    this.readLoggingSettings(req);
                    this.applyLoggingSettings(context, resultStrings);
                    this.applyAuthSettings(context);
                    this.applyRBSSettings(config, req, context);
                    this.applyMiscSettings(config, req);
                    this.applySecuritySettings(config, req, context);
                    config.writeSettings();
                    String userName = DirAuthenticator.getDirAuth(context).getUserId(context);
                    String host = context.getRequest().getRemoteAddr();
                    AuditLog.logSystemConfigurationChanged(userName, host);
                    D.log("Success Save Configuration: Your settings have been saved and will be visible after next login.\r\n");
                    req.setAttribute("nextState", (Object)"initialState");
                    eMFrameUtils.setMessage("success", eMFrameUtils.getLocalizedString("FwResources", "Success", context), eMFrameUtils.getLocalizedString("FwResources", "ChangesSaved", context), context);
                    this.setUIPage("fw/SystemConfigurationPage1.jsp");
                    this.initialState(req, resultStrings, config, context);
                }
                catch (ConfigException e) {
                    D.log("Error Saving Configuration: Your settings could not be saved.\r\n");
                    D.log(e);
                    req.setAttribute("nextState", (Object)"initialState");
                    eMFrameUtils.setMessage("error", eMFrameUtils.getLocalizedString("FwResources", "Error", context), eMFrameUtils.getLocalizedString("DevResources", "ParentWindowChangedErrorAlertMessage", context) + e.getMessage(), context);
                    this.setUIPage("fw/SystemConfigurationPage1.jsp");
                    this.initialState(req, resultStrings, config, context);
                }
            } else if (nextState.equals("LoggingClear")) {
                this.readLoggingSettings(req);
                String sFile = DebugLogging.getLogFileName();
                DebugLogging.stop();
                File f = new File(sFile);
                f.delete();
                DebugLogging.start();
                req.setAttribute("nextState", (Object)"initialState");
                this.setUIPage("fw/SystemConfigurationPage1.jsp");
                this.initialState(req, resultStrings, config, context);
                req.setAttribute("selectedIndex", (Object)"2");
            } else if (nextState.equals("QuickLogClearing")) {
                this.readLoggingSettings(req);
                String sFile = DebugLogging.getLogFileName();
                DebugLogging.stop();
                File f = new File(sFile);
                f.delete();
                DebugLogging.start();
                this.setUIPage("fw/Empty.jsp");
                req.setAttribute("quickLogClearing", (Object)"true");
            } else if (nextState.equals("LoggingView")) {
                this.doLoggingView(req);
            } else if (nextState.equals("QuickLogViewing")) {
                this.doLoggingView(req);
                req.setAttribute("quickLogViewing", (Object)"true");
            } else {
                this.initialState(req, resultStrings, config, context);
            }
        }
        req.setAttribute("selectedTab", (Object)this.m_tabSelection);
        return true;
    }

    private void applyLookAndFeelSettings(SystemConfig config, HttpServletRequest req, TaskContext context) throws ConfigException {
        this.validateLAFFilePaths(req, context);
        config.setSetting("LookAndFeel_OrganizationName", req.getParameter("LookAndFeel_OrganizationName"));
        config.setSetting("LookAndFeel_iManagerHeaderBackgroundImage", req.getParameter("LookAndFeel_iManagerHeaderBackgroundImage"));
        config.setSetting("LookAndFeel_iManagerHeaderFillerImage", req.getParameter("LookAndFeel_iManagerHeaderFillerImage"));
        config.setSetting("LookAndFeel_iManagerBrandingImage", req.getParameter("LookAndFeel_iManagerBrandingImage"));
        config.setSetting("LookAndFeel_MenuHeaderColor", req.getParameter("LookAndFeel_MenuHeaderColor"));
        config.setSetting("LookAndFeel_MenuColor", req.getParameter("LookAndFeel_MenuColor"));
        config.setSetting("LookAndFeel_HomeImage", req.getParameter("LookAndFeel_HomeImage"));
        String doShowHomeImage = req.getParameter("LookAndFeel_ShowHomeImage");
        config.setSetting("LookAndFeel_ShowHomeImage", null == doShowHomeImage ? "false" : doShowHomeImage);
    }

    private void readLookAndFeelInfoAndSet(HttpServletRequest req, Properties resultStrings, SystemConfig config) {
        resultStrings.put("LookAndFeel_OrganizationName", config.getSetting("LookAndFeel_OrganizationName", LookAndFeelDefaults.OrganizationName));
        resultStrings.put("LookAndFeel_iManagerHeaderBackgroundImage", config.getSetting("LookAndFeel_iManagerHeaderBackgroundImage", LookAndFeelDefaults.HeaderBackgroundImage));
        resultStrings.put("LookAndFeel_iManagerHeaderFillerImage", config.getSetting("LookAndFeel_iManagerHeaderFillerImage", LookAndFeelDefaults.HeaderFillerImage));
        resultStrings.put("LookAndFeel_iManagerBrandingImage", config.getSetting("LookAndFeel_iManagerBrandingImage", LookAndFeelDefaults.BrandingImage));
        resultStrings.put("LookAndFeel_MenuHeaderColor", config.getSetting("LookAndFeel_MenuHeaderColor", LookAndFeelDefaults.MenuHeaderColor));
        resultStrings.put("LookAndFeel_MenuColor", config.getSetting("LookAndFeel_MenuColor", LookAndFeelDefaults.MenuColor));
        resultStrings.put("LookAndFeel_HomeImage", config.getSetting("LookAndFeel_HomeImage", LookAndFeelDefaults.HomeImage));
        resultStrings.put("LookAndFeel_ShowHomeImage", config.getSetting("LookAndFeel_ShowHomeImage", LookAndFeelDefaults.ShowHomeImage));
    }

    private void validateLAFFilePaths(HttpServletRequest req, TaskContext context) throws ConfigException {
        String errmsg = "";
        String path = "";
        boolean valid = true;
        path = req.getParameter("LookAndFeel_iManagerHeaderBackgroundImage");
        File infile = new File(path = eMFrameUtils.getRealPath(path));
        if (!infile.exists()) {
            errmsg = errmsg + eMFrameUtils.getLocalizedString("FwResources", "SysConfig.LAFHeaderImgLoc", context);
            errmsg = errmsg + eMFrameUtils.getLocalizedString("FwResources", "SysConfig.LAFFilePathInvalid", context) + "\n  ";
            valid = false;
        }
        path = req.getParameter("LookAndFeel_iManagerHeaderFillerImage");
        infile = new File(path = eMFrameUtils.getRealPath(path));
        if (!infile.exists()) {
            errmsg = errmsg + eMFrameUtils.getLocalizedString("FwResources", "SysConfig.LAFHeaderFillerImgLoc", context);
            errmsg = errmsg + eMFrameUtils.getLocalizedString("FwResources", "SysConfig.LAFFilePathInvalid", context) + "\n  ";
            valid = false;
        }
        path = req.getParameter("LookAndFeel_iManagerBrandingImage");
        infile = new File(path = eMFrameUtils.getRealPath(path));
        if (!infile.exists()) {
            errmsg = errmsg + eMFrameUtils.getLocalizedString("FwResources", "SysConfig.LAFBrandingImgLoc", context);
            errmsg = errmsg + eMFrameUtils.getLocalizedString("FwResources", "SysConfig.LAFFilePathInvalid", context) + "\n  ";
            valid = false;
        }
        if (!valid) {
            throw new ConfigException(errmsg);
        }
    }

    private void doLoggingView(HttpServletRequest req) {
        this.readLoggingSettings(req);
        this.setUIPage("fw/ViewLog.jsp");
        req.setAttribute("loggingLevel", (Object)String.valueOf(this.m_iLoggingLevel));
        req.setAttribute("loggingToErr", (Object)String.valueOf(this.m_bLoggingToErr));
        req.setAttribute("loggingToOut", (Object)String.valueOf(this.m_bLoggingToOut));
        req.setAttribute("loggingToFile", (Object)String.valueOf(this.m_bLoggingToFile));
        req.setAttribute("loggingFile", (Object)DebugLogging.getLogFileName());
        req.setAttribute("loggingFileSize", (Object)String.valueOf(DebugLogging.getLogFileSize()));
    }

    private void initialState(HttpServletRequest req, Properties resultStrings, SystemConfig config, TaskContext context) {
        this.setUIPage("fw/SystemConfigurationPage1.jsp");
        req.setAttribute("selectedIndex", (Object)"1");
        req.setAttribute("selectedTab", (Object)"SecurityTab");
        AuthenticationBroker broker = context.getAuthenticationBroker();
        try {
            ObjectEntry treeOE = (ObjectEntry)broker.getProtocolObject("AdminNamespace");
            this.m_authenticatedProtocol = treeOE.getAdminNamespace().getUniqueID().equalsIgnoreCase("NDS") ? "eDirectory" : "LDAP";
            req.setAttribute("authenticatedProtocol", (Object)this.m_authenticatedProtocol);
        }
        catch (Exception e) {
            D.log(e);
        }
        this.readLookAndFeelInfoAndSet(req, resultStrings, config);
        this.readLoggingInfoAndSet(context.getRequest());
        this.readAuthInfoAndSet(context);
        try {
            this.readRBSSettings(context);
        }
        catch (ConfigException e) {
            D.log("SystemConfigurationTask::readRBSSettings: RBS configuration cannot be read from config.");
            D.log(e);
        }
        this.readMiscInfoAndSet(context);
        this.readSecurityInfoAndSet(context);
    }

    private void readSecurityInfoAndSet(TaskContext context) {
        HttpServletRequest req = context.getRequest();
        SystemConfig config = SystemConfig.getSystemConfig(context);
        Boolean bSecurityWarnNonSecure = new Boolean(true);
        Boolean bSecurityEnableNSureAudit = new Boolean(false);
        Boolean bSecurityEnableNSureAuditAuthorizedUsers = new Boolean(false);
        Boolean bSecurityEnableNSureAuditFailedSSLConnection = new Boolean(false);
        Boolean bSecurityEnableNSureAuditLoginFailed = new Boolean(false);
        Boolean bSecurityEnableNSureAuditLoginSuccess = new Boolean(false);
        Boolean bSecurityEnableNSureAuditLogout = new Boolean(false);
        Boolean bSecurityEnableNSureAuditNPMFailedInstall = new Boolean(false);
        Boolean bSecurityEnableNSureAuditNPMInstalled = new Boolean(false);
        Boolean bSecurityEnableNSureAuditChangedConfiguration = new Boolean(false);
        Boolean bSecurityEnableNSureAuditStartup = new Boolean(false);
        Boolean bSecurityEnableNSureAuditShutdown = new Boolean(false);
        Boolean bSecurityAutoImportCertificate = new Boolean(true);
        bSecurityWarnNonSecure = Boolean.valueOf(config.getSetting("Security.Warn.nonSecure", String.valueOf(bSecurityWarnNonSecure)));
        bSecurityEnableNSureAudit = Boolean.valueOf(config.getSetting("Audit.EnableNSureAuditLog", String.valueOf(bSecurityEnableNSureAudit)));
        bSecurityEnableNSureAuditAuthorizedUsers = Boolean.valueOf(config.getSetting("Audit.AuthorizedUsers", String.valueOf(bSecurityEnableNSureAuditAuthorizedUsers)));
        bSecurityEnableNSureAuditFailedSSLConnection = Boolean.valueOf(config.getSetting("Audit.FailedSSLConnection", String.valueOf(bSecurityEnableNSureAuditFailedSSLConnection)));
        bSecurityEnableNSureAuditLoginFailed = Boolean.valueOf(config.getSetting("Audit.LoginFailed", String.valueOf(bSecurityEnableNSureAuditLoginFailed)));
        bSecurityEnableNSureAuditLoginSuccess = Boolean.valueOf(config.getSetting("Audit.LoginSuccess", String.valueOf(bSecurityEnableNSureAuditLoginSuccess)));
        bSecurityEnableNSureAuditLogout = Boolean.valueOf(config.getSetting("Audit.Logout", String.valueOf(bSecurityEnableNSureAuditLogout)));
        bSecurityEnableNSureAuditNPMFailedInstall = Boolean.valueOf(config.getSetting("Audit.NPMFailedInstall", String.valueOf(bSecurityEnableNSureAuditNPMFailedInstall)));
        bSecurityEnableNSureAuditNPMInstalled = Boolean.valueOf(config.getSetting("Audit.NPMInstalled", String.valueOf(bSecurityEnableNSureAuditNPMInstalled)));
        bSecurityEnableNSureAuditChangedConfiguration = Boolean.valueOf(config.getSetting("Audit.ChangedConfiguration", String.valueOf(bSecurityEnableNSureAuditChangedConfiguration)));
        bSecurityEnableNSureAuditStartup = Boolean.valueOf(config.getSetting("Audit.Startup", String.valueOf(bSecurityEnableNSureAuditStartup)));
        bSecurityEnableNSureAuditShutdown = Boolean.valueOf(config.getSetting("Audit.Shutdown", String.valueOf(bSecurityEnableNSureAuditShutdown)));
        bSecurityAutoImportCertificate = Boolean.valueOf(config.getSetting("Security.KeyStore.AutoUpdate", String.valueOf(bSecurityAutoImportCertificate)));
        req.setAttribute("SecurityWarnNonSecure", (Object)String.valueOf(bSecurityWarnNonSecure));
        req.setAttribute("SecurityEnableNSureAudit", (Object)String.valueOf(bSecurityEnableNSureAudit));
        req.setAttribute("SecurityEnableNSureAuditAuthorizedUsers", (Object)String.valueOf(bSecurityEnableNSureAuditAuthorizedUsers));
        req.setAttribute("SecurityEnableNSureAuditFailedSSLConnection", (Object)String.valueOf(bSecurityEnableNSureAuditFailedSSLConnection));
        req.setAttribute("SecurityEnableNSureAuditLoginFailed", (Object)String.valueOf(bSecurityEnableNSureAuditLoginFailed));
        req.setAttribute("SecurityEnableNSureAuditLoginSuccess", (Object)String.valueOf(bSecurityEnableNSureAuditLoginSuccess));
        req.setAttribute("SecurityEnableNSureAuditLogout", (Object)String.valueOf(bSecurityEnableNSureAuditLogout));
        req.setAttribute("SecurityEnableNSureAuditNPMFailedInstall", (Object)String.valueOf(bSecurityEnableNSureAuditNPMFailedInstall));
        req.setAttribute("SecurityEnableNSureAuditNPMInstalled", (Object)String.valueOf(bSecurityEnableNSureAuditNPMInstalled));
        req.setAttribute("SecurityEnableNSureAuditChangedConfiguration", (Object)String.valueOf(bSecurityEnableNSureAuditChangedConfiguration));
        req.setAttribute("SecurityEnableNSureAuditStartup", (Object)String.valueOf(bSecurityEnableNSureAuditStartup));
        req.setAttribute("SecurityEnableNSureAuditShutdown", (Object)String.valueOf(bSecurityEnableNSureAuditShutdown));
        req.setAttribute("SecurityAutoImportCertificate", (Object)String.valueOf(bSecurityAutoImportCertificate));
        this.readSecurityConfigIman(req, context);
    }

    private void readSecurityConfigIman(HttpServletRequest req, TaskContext context) {
        Properties propFile = new Properties();
        String sPath = eMFrameUtils.getRealPath("/WEB-INF") + "/configiman.properties";
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(sPath);
            if (inputStream != null) {
                int size = ((InputStream)inputStream).available();
                byte[] bArray = new byte[size];
                ((InputStream)inputStream).read(bArray, 0, size);
                String sTemp = new String(bArray, 0, size);
                ByteArrayInputStream byteAis = new ByteArrayInputStream(sTemp.getBytes());
                propFile.load(byteAis);
                int i = 0;
                Enumeration<Object> myenum = propFile.keys();
                String[] sArray = new String[propFile.entrySet().size()];
                while (myenum.hasMoreElements()) {
                    String sKey = (String)myenum.nextElement();
                    String sValue = propFile.getProperty(sKey);
                    if (sValue.equalsIgnoreCase("eDirectory") || sValue.equalsIgnoreCase("LDAP")) {
                        if (sKey.endsWith(".")) {
                            sKey = sKey.substring(0, sKey.lastIndexOf("."));
                        }
                        sArray[i++] = new String(sKey);
                        continue;
                    }
                    sArray[i++] = new String(sKey);
                }
                if (sArray.length > 0 && !sArray[0].equals("")) {
                    req.setAttribute("SecurityAuthorizedUsers", (Object)eMFrameUtils.pack(sArray, context));
                }
                ((InputStream)inputStream).close();
            }
        }
        catch (Exception e) {
            D.log(e);
            inputStream = null;
        }
    }

    private void applySecuritySettings(SystemConfig config, HttpServletRequest req, TaskContext context) throws ConfigException {
        String sTemp = req.getParameter("SecurityWarnNonSecure");
        config.setSetting("Security.Warn.nonSecure", null == sTemp ? "false" : sTemp);
        sTemp = req.getParameter("SecurityEnableNSureAudit");
        config.setSetting("Audit.EnableNSureAuditLog", null == sTemp ? "false" : sTemp);
        sTemp = req.getParameter("SecurityEnableNSureAuditAuthorizedUsers");
        config.setSetting("Audit.AuthorizedUsers", null == sTemp ? "false" : sTemp);
        sTemp = req.getParameter("SecurityEnableNSureAuditFailedSSLConnection");
        config.setSetting("Audit.FailedSSLConnection", null == sTemp ? "false" : sTemp);
        sTemp = req.getParameter("SecurityEnableNSureAuditLoginFailed");
        config.setSetting("Audit.LoginFailed", null == sTemp ? "false" : sTemp);
        sTemp = req.getParameter("SecurityEnableNSureAuditLoginSuccess");
        config.setSetting("Audit.LoginSuccess", null == sTemp ? "false" : sTemp);
        sTemp = req.getParameter("SecurityEnableNSureAuditLogout");
        config.setSetting("Audit.Logout", null == sTemp ? "false" : sTemp);
        sTemp = req.getParameter("SecurityEnableNSureAuditNPMFailedInstall");
        config.setSetting("Audit.NPMFailedInstall", null == sTemp ? "false" : sTemp);
        sTemp = req.getParameter("SecurityEnableNSureAuditNPMInstalled");
        config.setSetting("Audit.NPMInstalled", null == sTemp ? "false" : sTemp);
        sTemp = req.getParameter("SecurityEnableNSureAuditChangedConfiguration");
        config.setSetting("Audit.ChangedConfiguration", null == sTemp ? "false" : sTemp);
        sTemp = req.getParameter("SecurityEnableNSureAuditStartup");
        config.setSetting("Audit.Startup", null == sTemp ? "false" : sTemp);
        sTemp = req.getParameter("SecurityEnableNSureAuditShutdown");
        config.setSetting("Audit.Shutdown", null == sTemp ? "false" : sTemp);
        sTemp = req.getParameter("SecurityAutoImportCertificate");
        config.setSetting("Security.KeyStore.AutoUpdate", null == sTemp ? "false" : sTemp);
        this.applySecurityConfigIman(context, req);
    }

    private void applySecurityConfigIman(TaskContext context, HttpServletRequest req) {
        String sTreeName = DirAuthenticator.getDirAuth(context).getConnectionProfile(context.getRequest()).getUniqueHostId();
        Properties propFile = new Properties();
        String sPath = eMFrameUtils.getRealPath("/WEB-INF") + "/configiman.properties";
        FileInputStream inputStream = null;
        try {
            File fconfig = new File(sPath);
            if (!fconfig.exists()) {
                fconfig.createNewFile();
            }
            if ((inputStream = new FileInputStream(sPath)) != null) {
                int size = ((InputStream)inputStream).available();
                byte[] bArray = new byte[size];
                ((InputStream)inputStream).read(bArray, 0, size);
                String sTemp = new String(bArray, 0, size);
                ByteArrayInputStream byteInputStream = new ByteArrayInputStream(sTemp.getBytes());
                propFile.load(byteInputStream);
                String[] sArray = eMFrameUtils.unpack(req.getParameter("SecurityAuthorizedUsers_packedValues"), context);
                propFile.clear();
                for (int i = 0; i < sArray.length; ++i) {
                    if (sArray[i].equalsIgnoreCase("AllUsers")) {
                        propFile.setProperty(sArray[i], "true");
                        continue;
                    }
                    if (propFile.getProperty(sArray[i]) == null) {
                        AuditLog.logAuthorizedUserAdded(sArray[i], sTreeName);
                    }
                    propFile.setProperty(sArray[i], this.m_authenticatedProtocol);
                }
                ((InputStream)inputStream).close();
                FileOutputStream outputStream = new FileOutputStream(sPath);
                propFile.store(outputStream, "");
                ((OutputStream)outputStream).close();
            }
        }
        catch (Exception e) {
            D.log(e);
            inputStream = null;
        }
    }

    private void readMiscInfoAndSet(TaskContext context) {
        HttpServletRequest req = context.getRequest();
        SystemConfig config = SystemConfig.getSystemConfig(context);
        String sMisceGuideURL = "EMFRAME_SERVER";
        Boolean bShouldModuleDownload = new Boolean(true);
        String sWhichModuleToDownload = new String("All");
        Boolean bModulesDownloadEnableProxy = new Boolean(false);
        String sModulesDownloadProxyHost = new String("127.0.0.1");
        String sModulesDownloadProxyPort = new String("80");
        String sModulesDownloadProxyUserName = "";
        String sModulesDownloadProxyPassword = "";
        sMisceGuideURL = config.getSetting("Provider.eMFrame.eGuide.location", sMisceGuideURL);
        bShouldModuleDownload = Boolean.valueOf(config.getSetting("ShouldModuleDownload", String.valueOf(bShouldModuleDownload)));
        sWhichModuleToDownload = config.getSetting("WhichModuleToDownload", sWhichModuleToDownload);
        bModulesDownloadEnableProxy = Boolean.valueOf(config.getSetting("ModulesDownloadEnableProxy", String.valueOf(bModulesDownloadEnableProxy)));
        sModulesDownloadProxyHost = config.getSetting("ModulesDownloadProxyHost", sModulesDownloadProxyHost);
        sModulesDownloadProxyPort = config.getSetting("ModulesDownloadProxyPort", sModulesDownloadProxyPort);
        sModulesDownloadProxyUserName = config.getSetting("ModulesDownloadProxyUserName", sModulesDownloadProxyUserName);
        sModulesDownloadProxyPassword = config.getSetting("ModulesDownloadProxyPassword", sModulesDownloadProxyPassword);
        req.setAttribute("MisceGuideURL", (Object)sMisceGuideURL);
        req.setAttribute("ShouldModuleDownload", (Object)String.valueOf(bShouldModuleDownload));
        if (null != sWhichModuleToDownload && sWhichModuleToDownload.equalsIgnoreCase("All")) {
            req.setAttribute("AllModulesToDownload", (Object)"true");
            req.setAttribute("PartialModulesToDownload", (Object)"false");
        } else {
            req.setAttribute("AllModulesToDownload", (Object)"false");
            req.setAttribute("PartialModulesToDownload", (Object)"true");
        }
        req.setAttribute("ModulesDownloadEnableProxy", (Object)String.valueOf(bModulesDownloadEnableProxy));
        req.setAttribute("ModulesDownloadProxyHost", (Object)sModulesDownloadProxyHost);
        req.setAttribute("ModulesDownloadProxyPort", (Object)sModulesDownloadProxyPort);
        req.setAttribute("ModulesDownloadProxyUserName", (Object)sModulesDownloadProxyUserName);
        req.setAttribute("ModulesDownloadProxyPassword", (Object)sModulesDownloadProxyPassword);
    }

    private void applyMiscSettings(SystemConfig config, HttpServletRequest req) throws ConfigException {
        config.setSetting("Provider.eMFrame.eGuide.location", req.getParameter("MisceGuideURL"));
        String sShouldModuleDownload = req.getParameter("ShouldModuleDownload");
        String sAllModuleToDownload = req.getParameter("AllModulesToDownload");
        if (null == sShouldModuleDownload) {
            sShouldModuleDownload = "false";
        }
        config.setSetting("ShouldModuleDownload", sShouldModuleDownload);
        if (null == sAllModuleToDownload && null == sShouldModuleDownload) {
            config.removeSetting("WhichModuleToDownload");
        } else if (null != sAllModuleToDownload && sAllModuleToDownload.equalsIgnoreCase("true")) {
            config.setSetting("WhichModuleToDownload", "All");
        } else {
            config.setSetting("WhichModuleToDownload", "Partial");
        }
        String sModulesDownloadEnableProxy = req.getParameter("ModulesDownloadEnableProxy");
        String sModulesDownloadProxyHost = req.getParameter("ModulesDownloadProxyHost");
        String sModulesDownloadProxyPort = req.getParameter("ModulesDownloadProxyPort");
        String sModulesDownloadProxyUserName = req.getParameter("ModulesDownloadProxyUserName");
        String sModulesDownloadProxyPassword = req.getParameter("ModulesDownloadProxyPassword");
        config.setSetting("ModulesDownloadEnableProxy", null == sModulesDownloadEnableProxy ? "false" : sModulesDownloadEnableProxy);
        if (null != sModulesDownloadProxyHost) {
            config.setSetting("ModulesDownloadProxyHost", sModulesDownloadProxyHost);
        }
        if (null != sModulesDownloadProxyPort) {
            config.setSetting("ModulesDownloadProxyPort", sModulesDownloadProxyPort);
        }
        if (null != sModulesDownloadProxyUserName) {
            config.setSetting("ModulesDownloadProxyUserName", sModulesDownloadProxyUserName);
        }
        if (null != sModulesDownloadProxyPassword) {
            config.setSetting("ModulesDownloadProxyPassword", sModulesDownloadProxyPassword);
        }
    }

    private void readRBSSettings(TaskContext context) throws ConfigException {
        Boolean bRBSEnableThis = new Boolean(false);
        Boolean bRBSEnableGroup = new Boolean(true);
        Boolean bRBSUnrestrictedAccess = new Boolean(false);
        Boolean bsRBShowRoleInCollec = new Boolean(true);
        String sRBSRoleDiscover = "Parent";
        String sRBSGroupDomain = "Root";
        String sRBSGroupSearchType = "DynamicGroupObjects&AuxClasses";
        HttpServletRequest req = context.getRequest();
        SystemConfig config = SystemConfig.getSystemConfig(context);
        sRBSRoleDiscover = config.getSetting("Provider.eMFrame.Role.discoveryDomain", sRBSRoleDiscover);
        sRBSGroupDomain = config.getSetting("Provider.eMFrame.DynamicGroup.discoveryDomain", sRBSGroupDomain);
        sRBSGroupSearchType = config.getSetting("Provider.eMFrame.DynamicGroup.Searchtype", sRBSGroupSearchType);
        bRBSEnableThis = Boolean.valueOf(config.getSetting("Provider.eMFrame.This.enable", String.valueOf(bRBSEnableThis)));
        bRBSUnrestrictedAccess = Boolean.valueOf(config.getSetting("RBS.forceUnrestricted", String.valueOf(bRBSUnrestrictedAccess)));
        bRBSEnableGroup = Boolean.valueOf(config.getSetting("Provider.eMFrame.DynamicGroup.enable", String.valueOf(bRBSEnableGroup)));
        bsRBShowRoleInCollec = Boolean.valueOf(config.getSetting("Provider.eMFrame.ShowRolesInOwnedCollections.enable", String.valueOf(bsRBShowRoleInCollec)));
        String[] sRBSTreeList = config.getSettings("RBS.Installed.Trees.List");
        if (null == sRBSTreeList) {
            sRBSTreeList = new String[]{};
        }
        req.setAttribute("RBSEnableThis", (Object)String.valueOf(bRBSEnableThis));
        req.setAttribute("RBSUnrestrictedAccess", (Object)String.valueOf(bRBSUnrestrictedAccess));
        req.setAttribute("RBSEnableDynamicGroup", (Object)String.valueOf(bRBSEnableGroup));
        req.setAttribute("RBSShowRolesInCollection", (Object)String.valueOf(bsRBShowRoleInCollec));
        req.setAttribute("RBSRoleDiscovery", (Object)sRBSRoleDiscover);
        req.setAttribute("RBSGroupDiscovery", (Object)sRBSGroupDomain);
        req.setAttribute("RBSGroupSearchType", (Object)sRBSGroupSearchType);
        req.setAttribute("RBSTreeListParam", (Object)sRBSTreeList);
    }

    private void applyRBSSettings(SystemConfig config, HttpServletRequest req, TaskContext context) throws ConfigException {
        config.setSetting("Provider.eMFrame.Role.discoveryDomain", req.getParameter("RBSRoleDiscovery").toLowerCase());
        config.setSetting("Provider.eMFrame.DynamicGroup.discoveryDomain", req.getParameter("RBSGroupDiscovery").toLowerCase());
        config.setSetting("Provider.eMFrame.DynamicGroup.Searchtype", req.getParameter("RBSGroupSearchType"));
        String sTemp = req.getParameter("RBSEnableThis");
        config.setSetting("Provider.eMFrame.This.enable", null == sTemp ? "false" : sTemp);
        sTemp = req.getParameter("RBSEnableDynamicGroup");
        config.setSetting("Provider.eMFrame.DynamicGroup.enable", null == sTemp ? "false" : sTemp);
        sTemp = req.getParameter("RBSUnrestrictedAccess");
        config.setSetting("RBS.forceUnrestricted", null == sTemp ? "false" : sTemp);
        sTemp = req.getParameter("RBSShowRolesInCollection");
        config.setSetting("Provider.eMFrame.ShowRolesInOwnedCollections.enable", null == sTemp ? "false" : sTemp);
        String[] sTree = eMFrameUtils.unpack(req.getParameter("RBSTreeListParam"), context);
        req.setAttribute("RBSTreeListParam", (Object)sTree);
        config.setSetting("RBS.Installed.Trees.List", sTree);
    }

    private void readLoggingSettings(HttpServletRequest req) {
        String sTemp = req.getParameter("loggingLevel");
        if (sTemp != null) {
            try {
                this.m_iLoggingLevel = Integer.parseInt(sTemp);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (this.m_iLoggingLevel > 0) {
            this.m_bLoggingToErr = req.getParameter("loggingToErr") != null;
            this.m_bLoggingToOut = req.getParameter("loggingToOut") != null;
            this.m_bLoggingToFile = req.getParameter("loggingToFile") != null;
        }
    }

    private void applyLoggingSettings(TaskContext context, Properties resultStrings) throws ConfigException {
        DebugLogging.stop();
        DebugLogging.setLoggingLevel(this.m_iLoggingLevel);
        DebugLogging.setLoggingToErr(this.m_bLoggingToErr);
        DebugLogging.setLoggingToOut(this.m_bLoggingToOut);
        DebugLogging.setLoggingToFile(this.m_bLoggingToFile);
        HttpServletRequest req = context.getRequest();
        req.setAttribute("loggingLevel", (Object)String.valueOf(this.m_iLoggingLevel));
        req.setAttribute("loggingToErr", (Object)String.valueOf(this.m_bLoggingToErr));
        req.setAttribute("loggingToOut", (Object)String.valueOf(this.m_bLoggingToOut));
        req.setAttribute("loggingToFile", (Object)String.valueOf(this.m_bLoggingToFile));
        req.setAttribute("loggingFile", (Object)DebugLogging.getLogFileName());
        req.setAttribute("loggingFileSize", (Object)String.valueOf(DebugLogging.getLogFileSize()));
        DebugLogging.start();
        SystemConfig config = SystemConfig.getSystemConfig(context);
        DebugLogging.saveToConfig(config);
    }

    public void readLoggingInfoAndSet(HttpServletRequest req) {
        this.m_iLoggingLevel = DebugLogging.getLoggingLevel();
        this.m_bLoggingToErr = DebugLogging.getLoggingToErr();
        this.m_bLoggingToOut = DebugLogging.getLoggingToOut();
        this.m_bLoggingToFile = DebugLogging.getLoggingToFile();
        req.setAttribute("loggingLevel", (Object)String.valueOf(this.m_iLoggingLevel));
        req.setAttribute("loggingToErr", (Object)String.valueOf(this.m_bLoggingToErr));
        req.setAttribute("loggingToOut", (Object)String.valueOf(this.m_bLoggingToOut));
        req.setAttribute("loggingToFile", (Object)String.valueOf(this.m_bLoggingToFile));
        req.setAttribute("loggingFile", (Object)DebugLogging.getLogFileName());
        req.setAttribute("loggingFileSize", (Object)String.valueOf(DebugLogging.getLogFileSize()));
    }

    private void readAuthInfoAndSet(TaskContext context) {
        String[] sAuthSelectedTree;
        String sAuthDefProtocol = "";
        String sAuthDefTree = "";
        String sAuthEnableCxtlessLogin = "true";
        String sAuthPublicPassword = "";
        String sAuthPublicUser = "";
        String sAuthShowProtocol = "true";
        String sAuthShowTree = "true";
        String sAuthUseCookies = "false";
        String sHideLoginFailReason = "false";
        String sAuthSecondayLDAPUsingSSL = "false";
        String sPostLogoutURL = "";
        String sPostLogoutURLEnable = "false";
        String sNeverTimeoutEnable = "false";
        String sTimeoutInSeconds = "1800";
        String sNovellDownloadSiteOption = "true";
        String sBoxDownloadURL = NOVELL_DOWNLOAD_URL;
        HttpServletRequest req = context.getRequest();
        SystemConfig config = SystemConfig.getSystemConfig(context);
        sAuthDefProtocol = config.getSetting("Authenticate.Form.DefaultProtocol", "NDAP");
        sAuthDefTree = config.getSetting("Authenticate.Form.DefaultTree");
        if (null == sAuthDefTree || sAuthDefTree.length() == 0) {
            sAuthDefTree = DirAuthenticator.getDirAuth(context).getConnectionProfile(context.getRequest()).getUniqueHostId();
        } else {
            req.setAttribute("AuthDefTree", (Object)sAuthDefTree.toLowerCase());
        }
        sAuthEnableCxtlessLogin = config.getSetting("Authenticate.Form.EnableContextlessLogin", sAuthEnableCxtlessLogin);
        sAuthShowProtocol = config.getSetting("Authenticate.Form.ShowProtocol");
        sAuthShowTree = config.getSetting("Authenticate.Form.ShowTree");
        sAuthUseCookies = config.getSetting("Authenticate.Form.UseCookies");
        sHideLoginFailReason = config.getSetting("Authenticate.Form.HideLoginFailReason");
        sAuthSecondayLDAPUsingSSL = config.getSetting("Authenticate.LDAP.useSSL");
        sNovellDownloadSiteOption = config.getSetting("NovellDownloadSiteOption", sNovellDownloadSiteOption);
        sNeverTimeoutEnable = config.getSetting("NeverTimeoutEnable", sNeverTimeoutEnable);
        sTimeoutInSeconds = config.getSetting("TimeoutInSeconds", sTimeoutInSeconds);
        String[] sPostLogoutURLStrings = config.getSettings("PostLogoutURL");
        sBoxDownloadURL = config.getSetting("BoxModuleDownloadDescriptorURL", sBoxDownloadURL);
        if (sPostLogoutURLStrings != null) {
            sPostLogoutURLEnable = sPostLogoutURLStrings[0];
            if (sPostLogoutURLStrings.length == 2 && sPostLogoutURLStrings[1] != null) {
                sPostLogoutURL = sPostLogoutURLStrings[1];
            }
        }
        if (null == (sAuthSelectedTree = config.getSettings("Authenticate.Form.Trees.List"))) {
            sAuthSelectedTree = new String[]{sAuthDefTree};
        } else {
            String currentTreeName = DirAuthenticator.getDirAuth(context).getConnectionProfile(context.getRequest()).getUniqueHostId();
            boolean found = false;
            for (int i = 0; i < sAuthSelectedTree.length; ++i) {
                if (!currentTreeName.equalsIgnoreCase(sAuthSelectedTree[i])) continue;
                found = true;
            }
            if (!found) {
                String[] tempArray = new String[sAuthSelectedTree.length + 1];
                for (int i = 0; i < sAuthSelectedTree.length; ++i) {
                    tempArray[i] = sAuthSelectedTree[i];
                }
                tempArray[tempArray.length - 1] = currentTreeName;
                sAuthSelectedTree = tempArray;
            }
        }
        String authSelectedTree = DirAuthenticator.getDirAuth(context).getConnectionProfile(context.getRequest()).getUniqueHostId();
        sAuthPublicPassword = config.getSetting("Authenticate.Form.PublicPassword." + sAuthDefProtocol + "." + authSelectedTree.toLowerCase());
        sAuthPublicUser = config.getSetting("Authenticate.Form.PublicUser." + sAuthDefProtocol + "." + authSelectedTree.toLowerCase());
        String[] sAuthSearchContainers = config.getSettings("Authenticate.Form.SearchContainers." + sAuthDefProtocol + "." + authSelectedTree.toLowerCase());
        req.setAttribute("SelectedAuthTreeList", (Object)sAuthSelectedTree[0].toLowerCase());
        String searchContainerOption = "root";
        if (sAuthSearchContainers != null && sAuthSearchContainers.length > 0) {
            searchContainerOption = "containers";
        }
        if (sAuthDefProtocol.equalsIgnoreCase("NDAP")) {
            sAuthDefProtocol = eMFrameUtils.getLocalizedString("FwResources", "SysConfig.AutheDirectory", context);
        } else if (sAuthDefProtocol.equalsIgnoreCase("LDAP")) {
            sAuthDefProtocol = eMFrameUtils.getLocalizedString("FwResources", "SysConfig.AuthLDAP", context);
        }
        if (sAuthDefProtocol.equalsIgnoreCase("LDAPS")) {
            sAuthDefProtocol = eMFrameUtils.getLocalizedString("FwResources", "SysConfig.AuthLDAPUsingSSL", context);
        }
        req.setAttribute("AuthDefProtocol", (Object)sAuthDefProtocol);
        req.setAttribute("AuthEnableCxtlessLogin", (Object)sAuthEnableCxtlessLogin);
        req.setAttribute("AuthPublicPassword", (Object)sAuthPublicPassword);
        req.setAttribute("AuthPublicUser", (Object)sAuthPublicUser);
        req.setAttribute("AuthSearchContainers", (Object)sAuthSearchContainers);
        req.setAttribute("AuthShowProtocol", (Object)sAuthShowProtocol);
        req.setAttribute("AuthShowTree", (Object)sAuthShowTree);
        req.setAttribute("AuthUseCookies", (Object)sAuthUseCookies);
        req.setAttribute("AuthHideLoginFailReason", (Object)sHideLoginFailReason);
        req.setAttribute("AuthSecondayLDAPUsingSSL", (Object)sAuthSecondayLDAPUsingSSL);
        req.setAttribute("AuthTreeListParam", (Object)sAuthSelectedTree);
        req.setAttribute("AuthSelectedTree", (Object)authSelectedTree);
        req.setAttribute("SearchContainerOption", (Object)searchContainerOption);
        req.setAttribute("PostLogoutURL", (Object)sPostLogoutURL);
        req.setAttribute("PostLogoutURLEnable", (Object)sPostLogoutURLEnable);
        req.setAttribute("DownloadURL", (Object)sBoxDownloadURL);
        req.setAttribute("NovellSite", (Object)sNovellDownloadSiteOption);
        req.setAttribute("NeverTimeoutEnable", (Object)sNeverTimeoutEnable);
        req.setAttribute("TimeoutInSeconds", (Object)sTimeoutInSeconds);
    }

    private void applyAuthSettings(TaskContext context) throws ConfigException {
        SystemConfig config = SystemConfig.getSystemConfig(context);
        HttpServletRequest req = context.getRequest();
        String sProtocol = req.getParameter("AuthDefProtocol");
        if (sProtocol.equalsIgnoreCase(eMFrameUtils.getLocalizedString("FwResources", "SysConfig.AutheDirectory", context)) || null == sProtocol) {
            sProtocol = "NDAP";
        } else if (sProtocol.equalsIgnoreCase(eMFrameUtils.getLocalizedString("FwResources", "SysConfig.AuthLDAP", context))) {
            sProtocol = "LDAP";
        } else if (sProtocol.equalsIgnoreCase(eMFrameUtils.getLocalizedString("FwResources", "SysConfig.AuthLDAPUsingSSL", context))) {
            sProtocol = "LDAPS";
        }
        String sTree = req.getParameter("AuthDefTree");
        config.setSetting("Authenticate.Form.DefaultTree", sTree.toLowerCase());
        String sTemp = req.getParameter("AuthEnableCxtlessLogin");
        config.setSetting("Authenticate.Form.EnableContextlessLogin", null == sTemp ? "false" : sTemp);
        sTemp = req.getParameter("AuthShowProtocol");
        config.setSetting("Authenticate.Form.ShowProtocol", null == sTemp ? "false" : sTemp);
        sTemp = req.getParameter("AuthShowTree");
        config.setSetting("Authenticate.Form.ShowTree", null == sTemp ? "false" : sTemp);
        sTemp = req.getParameter("AuthSecondayLDAPUsingSSL");
        config.setSetting("Authenticate.LDAP.useSSL", null == sTemp ? "false" : sTemp);
        sTemp = req.getParameter("AuthUseCookies");
        config.setSetting("Authenticate.Form.UseCookies", null == sTemp ? "false" : sTemp);
        sTemp = req.getParameter("AuthHideLoginFailReason");
        config.setSetting("Authenticate.Form.HideLoginFailReason", null == sTemp ? "false" : sTemp);
        config.setSetting("Authenticate.Form.DefaultProtocol", sProtocol);
        sTemp = req.getParameter("DownloadURL");
        if (sTemp != null) {
            config.setSetting("BoxModuleDownloadDescriptorURL", sTemp);
        }
        if ((sTemp = req.getParameter("DownloadModulesOption")) != null) {
            if (sTemp.equals("novell-site")) {
                config.setSetting("NovellDownloadSiteOption", "true");
                config.setSetting("ModuleDownloadDescriptorURL", NOVELL_DOWNLOAD_URL);
            } else {
                config.setSetting("NovellDownloadSiteOption", "false");
                sTemp = req.getParameter("DownloadURL");
                if (sTemp != null) {
                    config.setSetting("ModuleDownloadDescriptorURL", sTemp);
                }
            }
        }
        config.setSetting("NeverTimeoutEnable", null != (sTemp = req.getParameter("NeverTimeout")) ? "true" : "false");
        sTemp = req.getParameter("ServerTimeoutSettings");
        config.setSetting("TimeoutInSeconds", sTemp);
        sTemp = req.getParameter("PostLogoutURLEnable");
        String[] sPostLogoutURLStrings = new String[]{sTemp != null ? new String("true") : new String("false"), new String(req.getParameter("PostLogoutURLFinal"))};
        if (sPostLogoutURLStrings[1] == null) {
            sPostLogoutURLStrings[1] = "";
        } else {
            sTemp = sPostLogoutURLStrings[1];
            if (sTemp.length() > 0 && sTemp.indexOf("://") < 0) {
                sTemp = "http://" + sTemp;
            }
            sPostLogoutURLStrings[1] = sTemp;
        }
        config.setSetting("PostLogoutURL", sPostLogoutURLStrings);
        String sAuthTree = req.getParameter("AuthSelectedTreeName");
        req.setAttribute("AuthTreeListParam", (Object)sAuthTree);
        config.setSetting("Authenticate.Form.Trees.List", sAuthTree);
        String sSelectedAuthTreeList = sAuthTree;
        if (sSelectedAuthTreeList != null && sSelectedAuthTreeList.length() > 0) {
            sProtocol = this.m_authenticatedProtocol.equals("eDirectory") ? "NDAP" : this.m_authenticatedProtocol;
            config.setSetting("Authenticate.Form.PublicPassword." + sProtocol + "." + sSelectedAuthTreeList.toLowerCase(), req.getParameter("AuthPublicPassword"));
            config.setSetting("Authenticate.Form.PublicUser." + sProtocol + "." + sSelectedAuthTreeList.toLowerCase(), req.getParameter("AuthPublicUser"));
            String[] sContainers = eMFrameUtils.unpack(req.getParameter("AuthSearchContainers_mvedData"), context);
            config.setSetting("Authenticate.Form.SearchContainers." + sProtocol + "." + sSelectedAuthTreeList.toLowerCase(), sContainers);
        }
    }

    public static void shouldRun(HttpServletRequest req, String sServiceName) throws Exception {
        Task.shouldRun(req, sServiceName);
        if (!FwUtils.canConfigureiManager(req)) {
            TaskContext context = eMFrameFactory.getTaskContext(req);
            throw new Exception(eMFrameUtils.getLocalizedString("FwResources", "Configure.UserNotAuthorizedToConfigureiManager", context));
        }
    }
}

