/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.fw;

import com.novell.admin.common.exceptions.SPIException;
import com.novell.admin.common.exceptions.UniqueSPIException;
import com.novell.admin.ns.AdminNamespace;
import com.novell.admin.ns.FilterResultModifier;
import com.novell.application.console.snapin.BrowserObjectEntryEnumeration;
import com.novell.application.console.snapin.DefaultObjectEntryEnumeration;
import com.novell.application.console.snapin.ObjectEntry;
import com.novell.application.console.snapin.ObjectEntryEnumeration;
import com.novell.application.console.snapin.ResultModifier;
import com.novell.application.console.snapin.ResultModifierFilterEntry;
import com.novell.application.console.snapin.SnapinException;
import com.novell.emframe.dev.D;
import com.novell.emframe.dev.MContext;
import com.novell.emframe.dev.eMFrameUtils;
import com.novell.emframe.fw.ContainerObjectEntryNode;
import com.novell.emframe.fw.FwDirUtils;
import com.novell.emframe.fw.FwUtils;
import com.novell.emframe.fw.ObjectEntryNode;
import com.novell.emframe.fw.TreeViewContentMenuItem;
import com.novell.emframe.fw.util.PluginDocComparator;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.CollationKey;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.NoSuchElementException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.output.XMLOutputter;

public class TreeViewContentUtils {
    public static final String TVC_DISPLAY_BLOCK_SIZE = "TVC_DisplayBlockSize";
    public static final String TVC_OBJECT_ENTRTY_ENUMERATION = "TVC_ObjectEntryEnumeration";
    public static final String TVC_CONTAINER_OBJECT_ENTRY_NODE = "TVC_ContainerObjectEntryNode";
    public static final String TVC_START_INDEX = "TVC_StartIndex";
    public static final String TVC_END_INDEX = "TVC_EndIndex";
    public static final String TVC_DIRECTION = "TVC_Direction";
    public static final String TVC_LAST_BLOCK_READ_SIZE = "TVC_LastBlockReadSize";
    public static final String TVC_NAME_FILTER_CACHE = "TVC_NameFilterCache";
    public static final String TVC_TYPE_FILTER_CACHE = "TVC_TypeFilterCache";
    public static final String TVC_ADVANCED_FILTER_CACHE = "TVC_AdvancedFilterCache";
    public static final String TVC_SHOW_ALL_CONTAINERS_CACHE = "TVC_ShowAllContainersCache";
    public static final String TVC_NAMEFILTER_PARAM = "TVC_NameFilter";
    public static final String TVC_FILTERTYPELIST_PARAM = "TVC_FilterTypeList";
    public static final String TVC_SELECTEDTYPE_PARAM = "TVC_SelectedType";
    public static final String TVC_ADVFILTER_PARAM = "TVC_AdvFilterXML";
    public static final String TVC_SHOW_ALL_CONTAINERS_PARAM = "TVC_ShowAllContainers";
    private static final int DEFAULT_BLOCK_SIZE = 100;

    public static void initialContainerRead(MContext context, ObjectEntry containerOE) throws Exception {
        ContainerObjectEntryNode containerOEN;
        ArrayList menuList;
        context.removeAuthAttribute(TVC_OBJECT_ENTRTY_ENUMERATION);
        Long displayBlockSize = TreeViewContentUtils.getDisplayBlockSize(context);
        ObjectEntryEnumeration oeeChildren = TreeViewContentUtils.getObjectEntryEnumeration(containerOE, context);
        String direction = TreeViewContentUtils.getDirection(context);
        if (direction.equals("ascending")) {
            ((BrowserObjectEntryEnumeration)oeeChildren).moveLast();
            oeeChildren.next();
        }
        if ((menuList = TreeViewContentUtils.getTasksForObjects(new String[]{(containerOEN = new ContainerObjectEntryNode(containerOE, context)).getDN()}, context)) != null && menuList.size() > 0) {
            for (int i = 0; i < menuList.size(); ++i) {
                TreeViewContentMenuItem menuItem = (TreeViewContentMenuItem)menuList.get(i);
                String menuType = menuItem.getMenuType();
                if (menuType == null) continue;
                if (menuType.equals("create")) {
                    containerOEN.addCreateMenuItem(menuItem);
                    continue;
                }
                if (!menuType.equals("edit")) continue;
                containerOEN.addEditMenuItem(menuItem);
            }
        }
        context.setAuthAttribute(TVC_CONTAINER_OBJECT_ENTRY_NODE, containerOEN);
        context.setAuthAttribute(TVC_OBJECT_ENTRTY_ENUMERATION, oeeChildren);
        context.setAuthAttribute(TVC_DISPLAY_BLOCK_SIZE, displayBlockSize);
    }

    public static ArrayList getNextDescendingObjectEntryNodeList(ObjectEntryEnumeration oeEnum, MContext context, int blockSize) {
        ArrayList<ObjectEntryNode> oenList = new ArrayList<ObjectEntryNode>(blockSize);
        if (oeEnum != null) {
            for (int index = 0; oeEnum.hasMoreElements() && index < blockSize; ++index) {
                ObjectEntry oe = oeEnum.next();
                if (oe == null) break;
                ObjectEntryNode oeNode = new ObjectEntryNode(oe, context);
                oenList.add(oeNode);
            }
        }
        return oenList;
    }

    public static ArrayList getPreviousDescendingObjectEntryNodeList(ObjectEntryEnumeration oeEnum, MContext context, int blockSize, int lastReadBlockSize) throws SnapinException {
        ArrayList oenList = new ArrayList();
        if (oeEnum instanceof BrowserObjectEntryEnumeration) {
            try {
                for (int index = 0; index < blockSize + lastReadBlockSize; ++index) {
                    ObjectEntry oe = ((BrowserObjectEntryEnumeration)oeEnum).previous();
                    if (oe != null) continue;
                    break;
                }
            }
            catch (NoSuchElementException e) {
                // empty catch block
            }
            oenList = TreeViewContentUtils.getNextDescendingObjectEntryNodeList(oeEnum, context, blockSize);
        }
        return oenList;
    }

    public static ObjectEntryEnumeration getObjectEntryEnumeration(ObjectEntry containerOE, MContext context) throws SPIException {
        ObjectEntryEnumeration oeeChildren = (ObjectEntryEnumeration)context.getAuthAttribute(TVC_OBJECT_ENTRTY_ENUMERATION);
        if (oeeChildren == null) {
            HttpServletRequest req = context.getRequest();
            String nameFilter = (String)context.getAuthAttribute(TVC_NAME_FILTER_CACHE);
            if (nameFilter == null) {
                nameFilter = "*";
            }
            req.setAttribute(TVC_NAMEFILTER_PARAM, (Object)nameFilter);
            String typeFilter = (String)context.getAuthAttribute(TVC_TYPE_FILTER_CACHE);
            if (typeFilter == null || typeFilter.length() == 0) {
                typeFilter = "*";
            }
            req.setAttribute(TVC_SELECTEDTYPE_PARAM, (Object)typeFilter);
            String[] typeFilterArr = new String[]{typeFilter};
            String typeOrNull = typeFilter.equals("*") ? null : typeFilter;
            String advFiltXML = (String)context.getAuthAttribute(TVC_ADVANCED_FILTER_CACHE);
            if (advFiltXML == null) {
                advFiltXML = "";
            }
            req.setAttribute(TVC_ADVFILTER_PARAM, (Object)advFiltXML);
            String showAllContainers = (String)context.getAuthAttribute(TVC_SHOW_ALL_CONTAINERS_CACHE);
            if (showAllContainers == null || !showAllContainers.equals("true")) {
                showAllContainers = "false";
            }
            req.setAttribute(TVC_SHOW_ALL_CONTAINERS_PARAM, (Object)showAllContainers);
            FilterResultModifier rm = null;
            if (nameFilter.equals("*") && typeFilter.equals("*") && advFiltXML.length() == 0) {
                rm = new ResultModifier("TreeViewFilter1", 3, 0, new ResultModifierFilterEntry("*", null), false, true);
            } else if (showAllContainers.equals("true")) {
                String[] allConts = context.getDirUtils().getSelectableContainerTypes();
                ResultModifierFilterEntry allContsRMFE = new ResultModifierFilterEntry("*", allConts);
                if (advFiltXML.length() > 0) {
                    rm = new FilterResultModifier("TreeViewFilter5", 3, null, false);
                    ((FwDirUtils)context.getDirUtils()).addASXMLFilterInfoToRM(rm, typeOrNull, advFiltXML, context);
                    rm.addFilter(allContsRMFE);
                } else {
                    rm = new ResultModifier("TreeViewFilter4", 3, 0, new ResultModifierFilterEntry(nameFilter, typeFilterArr), false, true);
                    rm.addFilter(allContsRMFE);
                }
            } else if (advFiltXML.length() > 0) {
                rm = new FilterResultModifier("TreeViewFilter3", 3, null, false);
                ((FwDirUtils)context.getDirUtils()).addASXMLFilterInfoToRM(rm, typeOrNull, advFiltXML, context);
                rm.addFilter(new ResultModifierFilterEntry(nameFilter, null));
                rm.setSimpleAndOpAdvanced(true);
            } else {
                rm = new ResultModifier("TreeViewFilter2", 3, 0, new ResultModifierFilterEntry(nameFilter, typeFilterArr), false, true);
            }
            if (((FwDirUtils)context.getDirUtils()).isAuxClass(typeFilter)) {
                rm.setIncludeAuxClasses(true);
            }
            ArrayList typeList = TreeViewContentUtils.getTypeList(context);
            req.setAttribute(TVC_FILTERTYPELIST_PARAM, (Object)typeList);
            if (containerOE.getObjectType().getName().equals("Volume")) {
                rm.setAllowFileSystemBrowse(1);
            }
            if (containerOE.getObjectType().getName().equals("NCP Server")) {
                rm.setAllowFileSystemBrowse(2);
            }
            try {
                AdminNamespace ns = containerOE.getAdminNamespace();
                oeeChildren = ns.getChildren(containerOE, (ResultModifier)rm);
            }
            catch (SPIException spi) {
                String objectType = containerOE.getObjectType().getName();
                if (objectType.equals("NCP Server") && spi instanceof UniqueSPIException && ((UniqueSPIException)spi).getErrorCode() == -251) {
                    oeeChildren = new DefaultObjectEntryEnumeration();
                }
                throw spi;
            }
        }
        return oeeChildren;
    }

    private static ArrayList getTypeList(MContext context) {
        ArrayList<String> typeList = new ArrayList<String>();
        String[] types = context.getDirUtils().getSortedClasses();
        for (int i = 0; i < types.length; ++i) {
            typeList.add(types[i]);
        }
        Collections.sort(typeList, new CollatorComparator());
        return typeList;
    }

    public static void setExceptionMessage(Exception exc, MContext context) {
        D.log(exc);
        String strException = eMFrameUtils.getExceptionMessage(exc, context);
        String strTitle = eMFrameUtils.getLocalizedString("FwResources", "Error", context.getLocale());
        eMFrameUtils.setMessage("error", strTitle, strException, context);
        String title = null;
        String errorLink = null;
        if (exc instanceof UniqueSPIException) {
            int iErrCode = ((UniqueSPIException)exc).getErrorCode();
            String sErrCode = String.valueOf(iErrCode);
            Object[] sArgs = new String[]{sErrCode};
            String sHexErrCode = FwUtils.getUniqueSPIMessage((UniqueSPIException)exc);
            title = eMFrameUtils.getLocalizedString("DevResources", "GeneralMsg.NDSError", context);
            title = eMFrameUtils.formatMessage(title, sArgs);
            errorLink = sHexErrCode + ".htm";
        } else {
            title = "";
        }
        Element root = new Element("object-entry-table");
        root.setAttribute("error-title", title);
        root.setAttribute("error-message", strException);
        if (errorLink != null) {
            root.setAttribute("error-link", errorLink);
        }
        Document doc = new Document();
        doc.setRootElement(root);
        XMLOutputter xmlOutputter = new XMLOutputter();
        String docString = xmlOutputter.outputString(doc);
        context.getRequest().setAttribute("TVC_xmlDocString", (Object)docString);
    }

    public static String createXMLDoc(MContext context, ContainerObjectEntryNode containerOEN, ArrayList oenList, String direction, int startIndex, int endIndex) {
        Element[] editMenuElement;
        String iteratorEnabled = "false";
        ObjectEntryEnumeration oeeChildren = (ObjectEntryEnumeration)context.getAuthAttribute(TVC_OBJECT_ENTRTY_ENUMERATION);
        if (oeeChildren != null && oeeChildren instanceof BrowserObjectEntryEnumeration) {
            iteratorEnabled = "true";
        }
        Long blockSize = TreeViewContentUtils.getDisplayBlockSize(context);
        Element root = new Element("object-entry-table");
        int totalCount = -1;
        if (!TreeViewContentUtils.isFilterSet(context)) {
            totalCount = containerOEN.getObjectEntry().getSubordinateCount();
        }
        if (totalCount == -1) {
            if (endIndex < blockSize.intValue()) {
                totalCount = endIndex;
            }
        } else if (totalCount == 0 && containerOEN.getObjectTypeName().equals("Volume")) {
            totalCount = endIndex < blockSize.intValue() ? endIndex : -1;
        }
        root.setAttribute("total-count", new Long(totalCount).toString());
        root.setAttribute("start-index", new Long(startIndex).toString());
        root.setAttribute("end-index", new Long(endIndex).toString());
        root.setAttribute("display-block-size", blockSize.toString());
        root.setAttribute("direction", direction);
        root.setAttribute("iterator-enabled", iteratorEnabled);
        String fsFlag = containerOEN.getObjectType().isFileSystem() ? "true" : "false";
        root.setAttribute("is-file-system", fsFlag);
        root.addContent(containerOEN.getRecordElement(context));
        Element[] createMenuElement = containerOEN.getCreateMenuItemElement();
        if (createMenuElement != null) {
            for (int i = 0; i < createMenuElement.length; ++i) {
                root.addContent(createMenuElement[i]);
            }
        }
        if ((editMenuElement = containerOEN.getEditMenuItemElement()) != null) {
            for (int i = 0; i < editMenuElement.length; ++i) {
                root.addContent(editMenuElement[i]);
            }
        }
        if (oenList != null) {
            for (int index = 0; index < oenList.size(); ++index) {
                ObjectEntryNode recordEntry = (ObjectEntryNode)oenList.get(index);
                root.addContent(recordEntry.getRecordElement());
            }
        }
        ArrayList<Element> breadCrumbElements = new ArrayList<Element>();
        Element nsElement = new Element("name-space");
        ObjectEntry parentOE = containerOEN.getObjectEntry().getParent();
        if (parentOE != null) {
            ObjectEntryNode oen;
            ObjectEntry currentOE;
            String objectType = parentOE.getObjectType().getName();
            if (objectType.equals("File") || objectType.equals("Directory") || objectType.equals("Netware Volume") || objectType.equals("Volume") || objectType.equals("NCP Server")) {
                nsElement.setAttribute("ns-type", "filesystem");
                root.addContent(nsElement);
                for (currentOE = containerOEN.getObjectEntry(); currentOE != null; currentOE = currentOE.getParent()) {
                    oen = new ObjectEntryNode(currentOE, context);
                    breadCrumbElements.add(0, oen.getBreadCrumbElement());
                    objectType = currentOE.getObjectType().getName();
                    if (!objectType.equals("Volume") && !objectType.equals("NCP Server")) {
                        continue;
                    }
                    break;
                }
            } else {
                nsElement.setAttribute("ns-type", "eDirectory");
                root.addContent(nsElement);
                while (currentOE != null) {
                    oen = new ObjectEntryNode(currentOE, context);
                    breadCrumbElements.add(0, oen.getBreadCrumbElement());
                    currentOE = currentOE.getParent();
                }
            }
            for (int i = 0; i < breadCrumbElements.size(); ++i) {
                root.addContent((Element)breadCrumbElements.get(i));
            }
        } else {
            nsElement.setAttribute("ns-type", "eDirectory");
            root.addContent(nsElement);
            root.addContent(containerOEN.getBreadCrumbElement());
        }
        Document doc = new Document();
        doc.setRootElement(root);
        XMLOutputter xmlOutputter = new XMLOutputter();
        return xmlOutputter.outputString(doc);
    }

    public static PrintWriter getPrintWriterFormResponse(MContext context, HttpServletResponse res) throws IOException {
        res.setContentType("text/xml;charset=utf-8");
        res.setHeader("Cache-Control", "no-cache");
        res.setHeader("Pragma", "no-cache");
        PrintWriter out = res.getWriter();
        return out;
    }

    public static Long getDisplayBlockSize(MContext context) {
        Long displayBlockSize = null;
        displayBlockSize = (Long)context.getAuthAttribute(TVC_DISPLAY_BLOCK_SIZE);
        if (displayBlockSize == null) {
            String blockSizeStr = context.getPersistentData("OVPrefs", "TVC.ResultsPerPage");
            displayBlockSize = blockSizeStr != null && blockSizeStr.length() > 0 ? new Long(blockSizeStr) : new Long(100L);
        }
        return displayBlockSize;
    }

    public static String getDirection(MContext context) {
        String direction = (String)context.getAuthAttribute(TVC_DIRECTION);
        if (direction == null) {
            direction = "descending";
        }
        return direction;
    }

    public static String changeDirection(MContext context) {
        String direction = TreeViewContentUtils.getDirection(context);
        direction = direction.equals("descending") ? "ascending" : "descending";
        context.setAuthAttribute(TVC_DIRECTION, direction);
        return direction;
    }

    public static ArrayList getNextAscendingObjectEntryNodeList(ObjectEntryEnumeration oeEnum, MContext context, int blockSize) throws SnapinException {
        ArrayList<ObjectEntryNode> oenList = new ArrayList<ObjectEntryNode>(blockSize);
        if (oeEnum instanceof BrowserObjectEntryEnumeration) {
            try {
                for (int index = 0; index < blockSize; ++index) {
                    ObjectEntry oe = ((BrowserObjectEntryEnumeration)oeEnum).previous();
                    if (oe != null) {
                        ObjectEntryNode oeNode = new ObjectEntryNode(oe, context);
                        oenList.add(oeNode);
                        continue;
                    }
                    break;
                }
            }
            catch (NoSuchElementException e) {
                // empty catch block
            }
        }
        return oenList;
    }

    public static ArrayList getPreviousAscendingObjectEntryNodeList(ObjectEntryEnumeration oeEnum, MContext context, int blockSize, int lastReadBlockSize) throws SnapinException {
        if (oeEnum != null) {
            for (int index = 0; index < blockSize + lastReadBlockSize; ++index) {
                ObjectEntry oe = oeEnum.next();
                if (oe != null) continue;
                break;
            }
        }
        ArrayList oenList = TreeViewContentUtils.getNextAscendingObjectEntryNodeList(oeEnum, context, blockSize);
        return oenList;
    }

    public static ResultModifierFilterEntry getNameTypeFilter(MContext context) {
        ResultModifierFilterEntry nameTypeFilter = (ResultModifierFilterEntry)context.getAuthAttribute(TVC_NAME_FILTER_CACHE);
        if (nameTypeFilter == null) {
            nameTypeFilter = new ResultModifierFilterEntry("*", null);
        }
        return nameTypeFilter;
    }

    public static ResultModifier getAdvancedFilter(MContext context) {
        ResultModifier rm = (ResultModifier)context.getAuthAttribute(TVC_ADVANCED_FILTER_CACHE);
        return rm;
    }

    public static String createMenuXMLDoc(MContext context, ArrayList menuItemList, ContainerObjectEntryNode containerOEN) {
        Element root = new Element("menu-item-list");
        root.addContent(containerOEN.getRecordElement(context));
        if (menuItemList != null) {
            for (int index = 0; index < menuItemList.size(); ++index) {
                TreeViewContentMenuItem menuItem = (TreeViewContentMenuItem)menuItemList.get(index);
                root.addContent(menuItem.getMenuElement());
            }
        }
        Document doc = new Document();
        doc.setRootElement(root);
        XMLOutputter xmlOutputter = new XMLOutputter();
        return xmlOutputter.outputString(doc);
    }

    public static ArrayList getTasksForObjects(String[] objectNames, MContext context) throws Exception {
        ArrayList<TreeViewContentMenuItem> menuItems = new ArrayList<TreeViewContentMenuItem>();
        ArrayList taskDocs = FwUtils.getOVTasksForObjects(objectNames, context);
        if (taskDocs != null || taskDocs.size() > 0) {
            Collections.sort(taskDocs, new PluginDocComparator(context));
            for (int i = 0; i < taskDocs.size(); ++i) {
                Document taskDoc = (Document)taskDocs.get(i);
                String displayName = eMFrameUtils.getDisplayName(taskDoc, context);
                String taskID = taskDoc.getRootElement().getChildTextTrim("id");
                String menuType = taskDoc.getRootElement().getChildTextTrim("menu-type");
                TreeViewContentMenuItem menuItem = new TreeViewContentMenuItem(taskID, displayName);
                if (menuType != null) {
                    menuItem.setMenuType(menuType);
                }
                menuItems.add(menuItem);
            }
        }
        return menuItems;
    }

    public static boolean isFilterSet(MContext context) {
        String nameFilter = (String)context.getAuthAttribute(TVC_NAME_FILTER_CACHE);
        if (nameFilter != null && nameFilter.length() > 0 && !nameFilter.equals("*")) {
            return true;
        }
        String typeFilter = (String)context.getAuthAttribute(TVC_TYPE_FILTER_CACHE);
        if (typeFilter != null && typeFilter.length() > 0 && !typeFilter.equals("*")) {
            return true;
        }
        String advFiltXML = (String)context.getAuthAttribute(TVC_ADVANCED_FILTER_CACHE);
        return advFiltXML != null && advFiltXML.length() > 0;
    }

    public static void addCurrentAndParentNode(ContainerObjectEntryNode containerOEN, ArrayList oenList, MContext context) {
        ObjectEntry containerOE = containerOEN.getObjectEntry();
        ObjectEntryNode oenCurrent = new ObjectEntryNode(containerOE, context);
        oenCurrent.setLevel(1);
        oenList.add(0, oenCurrent);
        if (containerOE.getParent() != null) {
            ObjectEntryNode oenParent = new ObjectEntryNode(containerOE.getParent(), context);
            oenParent.setLevel(2);
            oenList.add(0, oenParent);
        }
    }

    private static class CollatorComparator
    implements Comparator {
        Collator collator = Collator.getInstance();

        private CollatorComparator() {
        }

        public int compare(Object o1, Object o2) {
            CollationKey key1 = this.collator.getCollationKey(o1.toString());
            CollationKey key2 = this.collator.getCollationKey(o2.toString());
            return key1.compareTo(key2);
        }
    }
}

