/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.fw.authenticator;

import com.novell.admin.common.exceptions.SPIException;
import com.novell.admin.common.exceptions.UniqueSPIException;
import com.novell.admin.event.DirectoryEvent;
import com.novell.admin.event.DirectoryEventListener;
import com.novell.admin.ns.AdminNamespace;
import com.novell.admin.ns.AdminNamespaceFactory;
import com.novell.admin.ns.AuthenticationNamespace;
import com.novell.admin.ns.ClassDefinition;
import com.novell.admin.ns.FilterResultModifier;
import com.novell.admin.ns.ObjectAttribute;
import com.novell.admin.ns.ldap.LDAPAuthenticationNamespace;
import com.novell.admin.ns.ldap.LDAPNamespace;
import com.novell.admin.ns.nds.NDSNamespace;
import com.novell.application.console.snapin.ObjectEntry;
import com.novell.application.console.snapin.ObjectEntryEnumeration;
import com.novell.application.console.snapin.ResultModifier;
import com.novell.application.console.snapin.ResultModifierFilterEntry;
import com.novell.application.console.snapin.SnapinException;
import com.novell.emframe.authDev.AuthDevUtils;
import com.novell.emframe.authDev.ConnectionProfile;
import com.novell.emframe.authDev.MCredentials;
import com.novell.emframe.authDev.iMgrAuthenticatorImpl;
import com.novell.emframe.dev.AuthBrokerException;
import com.novell.emframe.dev.AuthBrokerReport;
import com.novell.emframe.dev.AuthenticationBroker;
import com.novell.emframe.dev.D;
import com.novell.emframe.dev.DirUtils;
import com.novell.emframe.dev.GlobalRegistry;
import com.novell.emframe.dev.IManagerPluginEventListener;
import com.novell.emframe.dev.MContext;
import com.novell.emframe.dev.ManagementServiceSet;
import com.novell.emframe.dev.TaskContext;
import com.novell.emframe.dev.authenticator.AuthClassContext;
import com.novell.emframe.dev.authenticator.AuthContext;
import com.novell.emframe.dev.authenticator.AuthNotAuthenticatedException;
import com.novell.emframe.dev.config.SystemConfig;
import com.novell.emframe.dev.eMFrameFactory;
import com.novell.emframe.dev.eMFrameUtils;
import com.novell.emframe.fw.AuditLog;
import com.novell.emframe.fw.DirRoleList;
import com.novell.emframe.fw.FwAttr;
import com.novell.emframe.fw.FwDirUtils;
import com.novell.emframe.fw.FwTaskContext;
import com.novell.emframe.fw.FwUtils;
import com.novell.emframe.fw.Registry;
import com.novell.emframe.fw.RoleList;
import com.novell.emframe.fw.authenticator.FwAuthUtils;
import com.novell.emframe.fw.authenticator.ManagementServiceSetImpl;
import com.novell.emframe.fw.authenticator.Profile;
import com.novell.emframe.fw.config.ModuleManager;
import com.novell.emframe.fw.security.KeyStore_IM;
import com.novell.emframe.fw.servlet.FwRequest;
import com.novell.nps.configManager.GUID;
import com.novell.webaccess.common.Browser;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.xpath.XPath;
import sun.misc.BASE64Decoder;

public class DirAuthenticator
extends iMgrAuthenticatorImpl
implements DirectoryEventListener {
    private static final String SETTING_FORCE_MASTER = "forceMaster";
    private static final String CONFIG_SETTING_FORCE_MASTER = "Authenticate.forceMaster";
    public static final String MSS_SESSION_KEY = "ManageSS";
    public static final int PRIMARY = 1;
    public static final int AUXILARY = 2;
    public static final int DEFAULT_HASHTABLE_CAPACITY = 60;
    public static final String SETTING_SHOW_PROTOCOL = "Authenticate.Form.ShowProtocol";
    public static final String ATTR_SHOW_PROTOCOL = "ShowProtocol";
    public static final String DEFAULT_SHOW_PROTOCOL = "true";
    public static final String SETTING_DEFAULT_PROTOCOL = "Authenticate.Form.DefaultProtocol";
    public static final String ATTR_DEFAULT_PROTOCOL = "DefaultProtocol";
    public static final String VALUE_DEFAULT_PROTOCOL_NDAP = "NDAP";
    public static final String VALUE_DEFAULT_PROTOCOL_LDAP = "LDAP";
    public static final String VALUE_DEFAULT_PROTOCOL_LDAPS = "LDAPS";
    public static final String DEFAULT_DEFAULT_PROTOCOL = "NDAP";
    public static final String SETTING_SHOW_TREE = "Authenticate.Form.ShowTree";
    public static final String ATTR_SHOW_TREE = "ShowTree";
    public static final String DEFAULT_SHOW_TREE = "true";
    public static final String SETTING_DEFAULT_TREE = "Authenticate.Form.DefaultTree";
    public static final String ATTR_DEFAULT_TREE = "DefaultTree";
    public static final String SETTING_USE_COOKIES = "Authenticate.Form.UseCookies";
    public static final String DEFAULT_USE_COOKIES = "false";
    public static final String SETTING_HIDE_LOGIN_FAIL_REASON = "Authenticate.Form.HideLoginFailReason";
    public static final String DEFAULT_HIDE_LOGIN_FAIL_REASON = "false";
    public static final String SETTING_SEARCH_CONTAINERS = "Authenticate.Form.SearchContainers.";
    public static final String SETTING_PUBLIC_USER = "Authenticate.Form.PublicUser.";
    public static final String SETTING_PUBLIC_PASSWORD = "Authenticate.Form.PublicPassword.";
    public static final String SETTING_ENABLE_CONTEXTLESS_LOGIN = "Authenticate.Form.EnableContextlessLogin";
    public static final String DEFAULT_ENABLE_CONTEXTLESS_LOGIN = "true";
    public static final String SETTING_CONTEXTLESS_LOGIN_CLASS = "Authenticate.Form.ContextlessLoginClass.";
    private static final String SETTING_CONTEXTLESS_LOGIN_SEARCH_ATTRIBUTES = "Authenticate.Form.ContextlessLoginSearchAttributes";
    protected HttpSession m_session = null;
    protected int m_mssType;
    private Hashtable authBrokers = new Hashtable();
    private String m_currentAuthBrokerKey;
    private AuthenticationBroker m_authBroker = null;
    private String m_ldapName;
    private String m_ndapName;
    private String m_password;
    private String m_ldapAccessDomain;
    private String m_ndapAccessDomain;
    private String m_username;
    private String m_tree;
    private boolean m_useLdapSSL;
    private String m_protocol;
    private Boolean m_boolUseCookies = null;
    private Boolean m_boolHideLoginFailReason = null;
    private ArrayList subclassList = new ArrayList();
    private static final String LOGIN_INSTANCE_KEY = "Login_Key";
    private static final String PROFILE_HASH_KEY = "HASHMAP";
    private Hashtable initializedListeners = new Hashtable();
    protected HashMap m_profileMap = null;
    protected AuthContext m_authContext = null;
    protected Profile m_defProfile = null;
    protected boolean m_bLoggedIn = false;
    protected static String sm_sTrusted = null;
    public static final String PRIMARY_TREE = "primary";
    public static final String SECONDARY_TREE = "secondary";
    private ManagementServiceSetImpl m_managementServicesSet;
    private boolean m_bLoggedInButNotDone;
    private boolean m_bBasicLogin;
    private Hashtable directoryEventListeners;
    private DirRoleList m_dirRoleList;
    private HashMap m_runnables;
    private String m_sAuthScope;
    private boolean m_bNVDS;
    private static HashMap sm_hmSystemSupportedXPathsBySystem = new HashMap();
    private ConnectionProfile m_profile;
    private MCredentials m_credentials;
    static /* synthetic */ Class class$java$lang$Object;

    public DirAuthenticator() {
        SystemConfig sc = new SystemConfig();
        sm_sTrusted = sc.getSetting("Trusted.addresses", "*");
        this.directoryEventListeners = new Hashtable();
        this.m_dirRoleList = new DirRoleList(null);
        this.m_bNVDS = false;
        this.m_managementServicesSet = new ManagementServiceSetImpl(this);
    }

    public synchronized void init(AuthContext ac) {
        this.m_authContext = ac;
        AuthClassContext acc = ac.getAuthClassContext();
        this.m_profileMap = (HashMap)ac.get(PROFILE_HASH_KEY);
        if (this.m_profileMap == null) {
            this.m_profileMap = this.buildProfiles(acc.getName(), acc);
            ac.put(PROFILE_HASH_KEY, this.m_profileMap);
        }
        this.assignDefaultProfile(acc);
        this.m_authContext.put("dev.DownloadableFiles", new Vector());
    }

    protected HashMap buildProfiles(String sName, AuthClassContext acc) {
        String sKeyRoot = "Profile.";
        int iKeyRootLen = sKeyRoot.length();
        HashMap<String, Profile> profileMap = new HashMap<String, Profile>();
        Enumeration myenum = acc.keys();
        while (myenum.hasMoreElements()) {
            String sProfName;
            int iNameEnd;
            String sKey = (String)myenum.nextElement();
            if (!sKey.startsWith(sKeyRoot) || (iNameEnd = (sProfName = sKey.substring(iKeyRootLen)).indexOf(".")) == -1) continue;
            try {
                sProfName = sProfName.substring(0, iNameEnd);
            }
            catch (IndexOutOfBoundsException iobe) {
                continue;
            }
            if (profileMap.get(sProfName) != null) continue;
            profileMap.put(sProfName, new Profile(sName, sProfName, acc));
        }
        return profileMap;
    }

    protected void assignDefaultProfile(AuthClassContext acc) {
        String sDefProfile = (String)acc.get("Profile.default");
        if (sDefProfile != null) {
            this.m_defProfile = (Profile)this.m_profileMap.get(sDefProfile);
        }
        if (this.m_defProfile == null) {
            this.m_defProfile = Profile.getGenericProfile();
            this.m_profileMap.put(this.m_defProfile.getName(), this.m_defProfile);
        }
    }

    public AuthContext getAuthContext() {
        return this.m_authContext;
    }

    public boolean isAuthenticated(HttpServletRequest req) {
        if (SECONDARY_TREE.equals(req.getParameter("rank"))) {
            return false;
        }
        return this.m_bLoggedIn;
    }

    private boolean getUseCookies() {
        if (this.m_boolUseCookies == null) {
            SystemConfig sc = this.getSystemConfig();
            String sValue = sc.getSetting(SETTING_USE_COOKIES, "false");
            this.m_boolUseCookies = new Boolean(sValue);
        }
        return this.m_boolUseCookies;
    }

    private boolean getHideLoginFailReason() {
        if (this.m_boolHideLoginFailReason == null) {
            SystemConfig sc = this.getSystemConfig();
            String sValue = sc.getSetting(SETTING_HIDE_LOGIN_FAIL_REASON, "false");
            this.m_boolHideLoginFailReason = new Boolean(sValue);
        }
        return this.m_boolHideLoginFailReason;
    }

    private SystemConfig getSystemConfig() {
        return new SystemConfig();
    }

    protected boolean headerAuthenticate(HttpServletRequest req, HttpServletResponse res) {
        String sRemoteIP = req.getRemoteAddr();
        String sRemoteHost = req.getRemoteHost();
        if (sm_sTrusted == null) {
            return false;
        }
        if (sm_sTrusted.charAt(0) == '*' || sm_sTrusted.indexOf(sRemoteHost) != -1 || sm_sTrusted.indexOf(sRemoteIP) != -1) {
            String[] s = DirAuthenticator.getHttpCredentials(req);
            this.m_username = s[0];
            this.m_password = s[1];
            if (this.m_username != null && this.m_username.length() > 0) {
                this.setCookiesAsAttrsIfEnabled(req);
                if (this.loginImpl(req)) {
                    return true;
                }
            }
        }
        return false;
    }

    protected void login(HttpServletRequest req) {
        String state = req.getParameter("fw_authState");
        if (state != null && state.equalsIgnoreCase("doChangePasswordState")) {
            this.doChangePasswordState(req);
            return;
        }
        if (state != null && state.equals("showChangePasswordDlg")) {
            AuthBrokerReport report = (AuthBrokerReport)FwAttr.getFwSessionAttribute("AuthenticatorServlet.AuthBrokerReport", req.getSession());
            this.showChangePwdDlg(req, report);
            return;
        }
        if (state != null && state.equals("dontChangePwd")) {
            this.m_bLoggedIn = true;
            this.m_bLoggedInButNotDone = false;
            return;
        }
        String sDoLogin = req.getParameter("DoLogin");
        String user = req.getParameter("username");
        this.setCookiesAsAttrsIfEnabled(req);
        this.m_bBasicLogin = false;
        if (req.getParameter("headerAuth") != null) {
            this.m_bBasicLogin = this.getCredentialFromHeader(req);
        }
        if ((sDoLogin != null || user != null | this.m_bBasicLogin) && !this.m_bBasicLogin) {
            this.m_username = this.getLoginParameter("username", req, 256);
            this.m_password = this.trimString(req.getParameter("password"), 256);
        }
        if (user != null) {
            if (this.loginImpl(req)) {
                if (!PRIMARY_TREE.equals(req.getParameter("rank"))) {
                    ((FwRequest)req).getResponse().setContentType("text/xml; charset=UTF-8");
                    ((FwRequest)req).getResponse().setHeader("Cache-Control", "no-cache");
                    try {
                        Enumeration myenum = this.getAuthenticationBrokers().keys();
                        PrintWriter writer = ((FwRequest)req).getResponse().getWriter();
                        writer.write("<authentications name=\"" + this.m_currentAuthBrokerKey + "\" >");
                        while (myenum.hasMoreElements()) {
                            String key = (String)myenum.nextElement();
                            writer.write("<key name=\"" + DirAuthenticator.getFriendlyAuthBrokerName(key) + "\" value=\"" + key + "\">" + key + "</key>");
                        }
                        writer.write("</authentications>");
                    }
                    catch (IOException e) {
                        D.log(e);
                    }
                }
                AuditLog.logSuccessfulLogin(this.m_username, this.m_tree, false);
            } else {
                AuditLog.logFailedLogin(this.m_username, this.m_tree, false);
                Boolean requestHandled = (Boolean)FwAttr.getFwRequestAttribute("MMS.requestHandled", req);
                if (requestHandled != null && requestHandled.booleanValue()) {
                    return;
                }
            }
        }
        if (SECONDARY_TREE.equals(req.getParameter("rank"))) {
            return;
        }
        this.showLoginDlg(req);
    }

    private boolean getCredentialFromHeader(HttpServletRequest req) {
        String sRemoteIP = req.getRemoteAddr();
        String sRemoteHost = req.getRemoteHost();
        if (sm_sTrusted == null) {
            return false;
        }
        if (sm_sTrusted.charAt(0) == '*' || sm_sTrusted.indexOf(sRemoteHost) != -1 || sm_sTrusted.indexOf(sRemoteIP) != -1) {
            String[] s = DirAuthenticator.getHttpCredentials(req);
            this.m_username = s[0];
            this.m_password = s[1];
            return true;
        }
        return false;
    }

    private static String getFriendlyAuthBrokerName(String authBrokerKey) {
        StringTokenizer stok = new StringTokenizer(authBrokerKey, ":");
        String retVal = new String();
        if (stok.hasMoreElements()) {
            String treeName = (String)stok.nextElement();
            String userName = (String)stok.nextElement();
            retVal = userName + "@" + treeName;
        }
        return retVal;
    }

    protected void showUI(HttpServletRequest req, HttpServletResponse resp) {
        String uiPage = FwAuthUtils.getUIPage(req);
        if (!PRIMARY_TREE.equals(req.getParameter("rank"))) {
            if (uiPage != null) {
                FwUtils.dispatchJsp(uiPage, req, resp);
            }
        } else if (uiPage != null) {
            FwUtils.dispatchJsp(FwAuthUtils.getUIPage(req), req, resp);
        }
    }

    private boolean loginImpl(HttpServletRequest req) {
        HttpSession session = req.getSession();
        if (AuthDevUtils.isLogoutRequest(req)) {
            return false;
        }
        if (!SECONDARY_TREE.equals(req.getParameter("rank")) && !this.isValidLoginSession(req)) {
            return false;
        }
        this.m_ldapName = null;
        this.m_ndapName = null;
        this.m_ldapAccessDomain = this.getLoginParameter("ldap", req, 256);
        this.m_ndapAccessDomain = this.getLoginParameter("ndap", req, 256);
        this.m_tree = this.getLoginParameter("tree", req, 256);
        SystemConfig sc = this.getSystemConfig();
        String sForceMaster = req.getParameter(SETTING_FORCE_MASTER);
        if (sForceMaster == null) {
            sForceMaster = sc.getSetting(CONFIG_SETTING_FORCE_MASTER, null);
        }
        if (sForceMaster != null) {
            this.setAttribute(SETTING_FORCE_MASTER, sForceMaster);
        }
        this.m_session = session;
        this.m_managementServicesSet.setSession(session);
        this.m_mssType = 2;
        String sValue = null;
        sValue = sc.getSetting(SETTING_SHOW_PROTOCOL, "true");
        if (!sValue.equals("true")) {
            this.m_protocol = sc.getSetting(SETTING_DEFAULT_PROTOCOL, "NDAP");
        } else {
            this.m_protocol = this.getLoginParameter("protocol", req, 256);
            if (this.m_protocol == null) {
                this.m_protocol = sc.getSetting(SETTING_DEFAULT_PROTOCOL, "NDAP");
            }
        }
        this.m_useLdapSSL = false;
        if (this.m_protocol.equals(VALUE_DEFAULT_PROTOCOL_LDAPS)) {
            this.m_useLdapSSL = true;
        } else if (this.m_protocol.equals("NDAP")) {
            String useSsl = sc.getSetting("Authenticate.LDAP.useSSL", "true");
            this.m_useLdapSSL = useSsl != null && useSsl.equalsIgnoreCase("true");
        }
        String sSsl = this.getLoginParameter("ssl", req, 256);
        if (sSsl != null && sSsl.equalsIgnoreCase("true")) {
            this.m_useLdapSSL = true;
        }
        if (this.m_ldapAccessDomain == null && this.m_ndapAccessDomain == null) {
            String sTree = null;
            sValue = sc.getSetting(SETTING_SHOW_TREE, "true");
            if (!sValue.equals("true")) {
                sTree = sc.getSetting(SETTING_DEFAULT_TREE, "");
            } else {
                sTree = this.m_tree;
                if (sTree == null && (this.m_username != null && this.m_protocol.equals("NDAP") || this.m_protocol.equals(VALUE_DEFAULT_PROTOCOL_LDAP))) {
                    eMFrameUtils.setMessage("error", null, eMFrameUtils.getLocalizedString("FwResources", "AuthenticateFailed.NoTree", this.getLocale()), FwUtils.getMContext(req));
                    return false;
                }
            }
            if (this.m_protocol.equals("NDAP")) {
                this.m_ndapAccessDomain = sTree;
            } else if (this.m_protocol.equals(VALUE_DEFAULT_PROTOCOL_LDAP) || this.m_protocol.equals(VALUE_DEFAULT_PROTOCOL_LDAPS)) {
                this.m_ldapAccessDomain = sTree;
            }
        }
        if (this.m_ldapName == null && this.m_ndapName == null) {
            if (this.m_protocol.equals("NDAP")) {
                boolean bFound;
                boolean bl = bFound = this.isCharFound(this.m_username, '.') && !this.isCharFound(this.m_username, '@');
                if (!bFound) {
                    this.m_username = this.lookupUser(this.m_username, this.m_protocol);
                }
                this.m_ndapName = this.m_username;
            } else if (this.m_protocol.equals(VALUE_DEFAULT_PROTOCOL_LDAP) || this.m_protocol.equals(VALUE_DEFAULT_PROTOCOL_LDAPS)) {
                boolean bFound;
                if (this.m_username == null) {
                    this.m_username = "";
                }
                if (!(bFound = this.isCharFound(this.m_username, ','))) {
                    this.m_username = this.lookupUser(this.m_username, this.m_protocol);
                }
                this.m_ldapName = this.m_username;
            }
        }
        session.removeAttribute(LOGIN_INSTANCE_KEY);
        if (this.m_ldapName != null || this.m_ndapName != null) {
            return this.loginAuthBroker(req);
        }
        return false;
    }

    private boolean loginAuthBroker(HttpServletRequest req) {
        String rank = this.getLoginParameter("rank", req, 256);
        if (rank == null) {
            rank = PRIMARY_TREE;
        }
        boolean bRet = false;
        String sProtocol = this.m_protocol;
        ObjectEntry oeTree = null;
        AuthenticationBroker authBroker = null;
        authBroker = AuthenticationBroker.createAuthenticationBroker(this.m_ldapName, this.m_ndapName, this.m_password, this.m_ldapAccessDomain, this.m_ndapAccessDomain, this.m_useLdapSSL, this);
        if (PRIMARY_TREE.equals(rank)) {
            this.m_authBroker = authBroker;
        }
        try {
            Integer code;
            String authBrokerProtocol = sProtocol.equals("NDAP") ? "NDSNamespace" : "LDAPNamespace";
            AuthBrokerReport report = authBroker.getAPIReport(authBrokerProtocol);
            oeTree = (ObjectEntry)report.getLoginAPIObject();
            if (PRIMARY_TREE.equals(rank)) {
                this.m_bLoggedInButNotDone = true;
            }
            this.setMssInfo(req, oeTree);
            if (report.getType() == 3 && (code = (Integer)report.getUserData()) == -223) {
                FwAttr.setFwSessionAttribute("AuthenticatorServlet.AuthBrokerReport", report, req.getSession());
                this.showChangePwdDlg(req, report);
                return false;
            }
            String string = this.m_currentAuthBrokerKey = "LDAPNamespace".equals(authBrokerProtocol) ? this.getConnectionProfile(req).getUniqueHostId() + ":" + authBroker.getAuthLdapName() + ":" + sProtocol + ":" + rank : this.getConnectionProfile(req).getUniqueHostId() + ":" + authBroker.getAuthNdapName() + ":" + sProtocol + ":" + rank;
            if (this.m_currentAuthBrokerKey.endsWith(SECONDARY_TREE)) {
                StringBuffer sbuff = new StringBuffer(this.m_currentAuthBrokerKey);
                String tempKey = sbuff.replace(this.m_currentAuthBrokerKey.lastIndexOf(58) + 1, this.m_currentAuthBrokerKey.length(), PRIMARY_TREE).toString();
                if (this.authBrokers.get(tempKey) == null) {
                    this.authBrokers.put(this.m_currentAuthBrokerKey, authBroker);
                }
            } else {
                this.authBrokers.put(this.m_currentAuthBrokerKey, authBroker);
            }
            if (FwUtils.canConfigureiManager(req)) {
                ModuleManager.readModulesToInstall();
                ModuleManager.getModulesToInstall();
            }
            this.registerDirectoryEventListeners(oeTree);
            bRet = true;
            if (D.isDebugEnabled(2)) {
                D.log("Login Succeeded: " + this.m_ldapName + " " + this.m_ndapName + ": " + this.m_ldapAccessDomain + " " + this.m_ndapAccessDomain);
            }
        }
        catch (Exception e2) {
            String sTemp;
            AuthBrokerException e2;
            int err;
            if (e2.getCause() instanceof UniqueSPIException && ((err = ((UniqueSPIException)e2.getCause()).getErrorCode()) == -601 || err == -669 || err == -220) && this.getHideLoginFailReason()) {
                e2 = new AuthBrokerException(eMFrameUtils.getLocalizedString("FwResources", "AuthenticateFailed.LoginFailureUserNameOrPassword", this.getLocale()));
            }
            if ((sTemp = ((Throwable)e2).getLocalizedMessage()) == null) {
                sTemp = ((Throwable)e2).getMessage();
            }
            D.log(e2);
            try {
                if (SECONDARY_TREE.equals(req.getParameter("rank"))) {
                    ((FwRequest)req).getResponse().setContentType("text/xml; charset=UTF-8");
                    ((FwRequest)req).getResponse().setHeader("Cache-Control", "no-cache");
                    PrintWriter writer = ((FwRequest)req).getResponse().getWriter();
                    writer.write("<error>");
                    writer.write("<errorBody>" + sTemp + "</errorBody>");
                    writer.write("</error>");
                    return bRet;
                }
            }
            catch (IOException ex) {
                D.log(ex);
            }
            req.setAttribute("Error", (Object)sTemp);
            req.setAttribute("GeneralMsg.MsgBody", (Object)sTemp);
            eMFrameUtils.setErrorMessage(e2, FwUtils.getMContext(req));
            D.log("Login failed:  " + this.m_ndapName + ": " + " " + this.m_ndapAccessDomain, 1);
        }
        this.m_bLoggedIn = bRet;
        if (this.m_bLoggedIn) {
            this.m_bLoggedInButNotDone = false;
        }
        return bRet;
    }

    private void registerDirectoryEventListeners(ObjectEntry apiObject) {
        try {
            Hashtable reg = GlobalRegistry.getDirectoryEventListenerRegistry();
            Enumeration keys = reg.keys();
            while (keys.hasMoreElements()) {
                String key = keys.nextElement().toString();
                Document doc = (Document)reg.get(key);
                String listenerClass = eMFrameUtils.getClassName(doc);
                IManagerPluginEventListener listener = (IManagerPluginEventListener)this.initializedListeners.get(listenerClass);
                if (listener == null) {
                    Class<?> c = Class.forName(listenerClass);
                    Constructor<?> listenerConstructor = c.getConstructor(class$java$lang$Object == null ? DirAuthenticator.class$("java.lang.Object") : class$java$lang$Object);
                    listener = listenerConstructor != null ? (IManagerPluginEventListener)listenerConstructor.newInstance(this.m_authContext) : (IManagerPluginEventListener)c.newInstance();
                    this.initializedListeners.put(listenerClass, listener);
                }
                List objectTypes = doc.getRootElement().getChildren("object-type-name");
                Iterator objectTypeItr = objectTypes.iterator();
                this.registerObjectClassListeners(apiObject, objectTypeItr, doc, listener);
            }
        }
        catch (Throwable ex) {
            D.log(ex);
        }
    }

    private void registerObjectClassListeners(ObjectEntry apiObject, Iterator objectTypeItr, Document doc, IManagerPluginEventListener listener) {
        try {
            while (objectTypeItr.hasNext()) {
                Element objectTypeElement = (Element)objectTypeItr.next();
                Element objectNameElement = objectTypeElement.getChild("object-name");
                String objectTypeName = objectNameElement.getTextTrim();
                boolean subclass = "true".equalsIgnoreCase(objectNameElement.getAttributeValue("subclass"));
                ArrayList list = null;
                if (subclass) {
                    list = this.getRecursiveSubclasses(apiObject, objectTypeName);
                }
                Object[] operations = eMFrameUtils.getOperationsByObjectType(doc, objectTypeName);
                for (int i = 0; i < operations.length; ++i) {
                    Class<?> c = Class.forName("com.novell.admin.event.DirectoryEvent");
                    int operation = c.getDeclaredField(operations[i].toString()).getInt(c);
                    if (list != null) {
                        Iterator subItr = list.iterator();
                        if (subItr == null) continue;
                        while (subItr.hasNext()) {
                            String objName = subItr.next().toString();
                            this.addPluginEventListener(operation, objName, listener);
                            apiObject.getAdminNamespace().addDirectoryEventListener((DirectoryEventListener)this, operation, objName);
                        }
                        continue;
                    }
                    this.addPluginEventListener(operation, objectTypeName, listener);
                    apiObject.getAdminNamespace().addDirectoryEventListener((DirectoryEventListener)this, operation, objectTypeName);
                }
            }
        }
        catch (Throwable ex) {
            D.log(ex);
        }
    }

    private ArrayList getRecursiveSubclasses(ObjectEntry apiObject, String typeName) {
        this.subclassList.add(typeName);
        try {
            ClassDefinition[] subclasses = apiObject.getAdminNamespace().getSchemaDefinition(apiObject).getSubClasses(typeName);
            for (int i = 0; i < subclasses.length; ++i) {
                this.subclassList = this.getRecursiveSubclasses(apiObject, subclasses[i].getName());
            }
        }
        catch (SPIException e) {
            D.log(e);
        }
        return this.subclassList;
    }

    private void showChangePwdDlg(HttpServletRequest req, AuthBrokerReport report) {
        ObjectEntry oeTree = (ObjectEntry)report.getLoginAPIObject();
        AdminNamespace ns = oeTree.getAdminNamespace();
        try {
            String username = this.m_authBroker.getAuthNdapName();
            ObjectEntry objectEntry = ns.getObjectEntry(oeTree, username);
            ObjectAttribute attribute = ns.getAttribute(objectEntry, "Login Grace Remaining");
            boolean forceChange = false;
            int numRemaining = -1;
            if (attribute != null && (numRemaining = Integer.parseInt(attribute.toString())) == 0) {
                forceChange = true;
            }
            TaskContext context = eMFrameFactory.getTaskContext(req);
            req.setAttribute("ChangePassword_forceChange", (Object)("" + forceChange));
            if (forceChange || numRemaining == -1) {
                String msg = eMFrameUtils.getLocalizedString("FwResources", "ChangePassword.enterNewPassword", context);
                req.setAttribute("AuthMsg", (Object)msg);
            } else {
                String pattern = eMFrameUtils.getLocalizedString("FwResources", "ChangePassword.changePasswordQuestion", context);
                String msg = eMFrameUtils.formatMessage(pattern, new Object[]{"" + numRemaining});
                req.setAttribute("AuthMsg", (Object)msg);
            }
        }
        catch (Throwable e) {
            D.log(e);
        }
        this.setUIPage("fw/ChangePassword.jsp", req);
        FwAttr.setFwRequestAttribute("MMS.requestHandled", Boolean.TRUE, req);
    }

    private boolean doChangePasswordState(HttpServletRequest req) {
        String password2;
        TaskContext context = eMFrameFactory.getTaskContext(req);
        String password1 = this.trimString(req.getParameter("password1"), 256);
        if (!password1.equals(password2 = this.trimString(req.getParameter("password2"), 256))) {
            String title = eMFrameUtils.getLocalizedString("FwResources", "Error", context);
            String body = eMFrameUtils.getLocalizedString("FwResources", "SetPassword.PasswordsDontMatch", context);
            eMFrameUtils.setMessage("error", title, body, context);
            this.setUIPage("dev/GenErr.jsp", req);
            return true;
        }
        String[] identity = this.m_authBroker.getIdentity();
        String oldPassword = identity[1];
        try {
            AdminNamespace ns;
            ObjectEntry treeOE = (ObjectEntry)this.m_authBroker.getProtocolObject("AdminNamespace");
            AdminNamespace authNamespace = ns = treeOE.getAdminNamespace();
            String username = this.m_authBroker.getAuthNdapName();
            ObjectEntry userObjectEntry = ns.getObjectEntry(treeOE, username);
            authNamespace.changePassword(userObjectEntry, oldPassword, password1);
            this.resetPIdentity(password1);
        }
        catch (Throwable e) {
            D.log(e);
            eMFrameUtils.setErrorMessage(e, context);
            req.setAttribute("GeneralMsg.Url", (Object)"frameservice?fw_authState=showChangePasswordDlg");
            this.setUIPage("fw/ChangePassword.jsp", req);
            return true;
        }
        this.m_bLoggedIn = true;
        this.m_bLoggedInButNotDone = false;
        return false;
    }

    private boolean isCharFound(String sStr, char ch) {
        boolean bRet = false;
        if (sStr != null) {
            boolean bEscapeChar = false;
            for (int i = 0; i < sStr.length(); ++i) {
                char chTemp = sStr.charAt(i);
                if (bEscapeChar) {
                    bEscapeChar = false;
                    continue;
                }
                if (chTemp == '\\') {
                    bEscapeChar = true;
                    continue;
                }
                if (chTemp != ch) continue;
                bRet = true;
                break;
            }
        }
        return bRet;
    }

    private String lookupUser(String sUser, String sProtocol) {
        SystemConfig sc = this.getSystemConfig();
        if (!sc.getSetting(SETTING_ENABLE_CONTEXTLESS_LOGIN, "true").equals("true")) {
            return sUser;
        }
        if (sUser == null || sUser.length() == 0) {
            return sUser;
        }
        AdminNamespace ns = null;
        AdminNamespace authNS = null;
        String[] saTypes = null;
        try {
            String sPublicPassword;
            String sPublicUser;
            String sTemp = null;
            String sSearchSetting = null;
            String searchAttributesSettingName = null;
            if (sProtocol.equals("NDAP")) {
                if (this.m_ndapAccessDomain == null) {
                    return sUser;
                }
                sPublicUser = "[public]";
                sPublicPassword = null;
                String sTempTreeName = null;
                sSearchSetting = SETTING_PUBLIC_USER + sProtocol + "." + this.m_ndapAccessDomain.toLowerCase();
                sTemp = sc.getSetting(sSearchSetting);
                if (sTemp == null) {
                    sTempTreeName = AdminNamespaceFactory.getNDSTreeNameFromID((String)this.m_ndapAccessDomain);
                    if (sTempTreeName != null) {
                        sSearchSetting = SETTING_PUBLIC_USER + sProtocol + "." + sTempTreeName.toLowerCase();
                        sTemp = sc.getSetting(sSearchSetting);
                    }
                } else {
                    sTempTreeName = this.m_ndapAccessDomain;
                }
                if (sTemp != null) {
                    sPublicUser = sTemp;
                    sSearchSetting = SETTING_PUBLIC_PASSWORD + sProtocol + "." + sTempTreeName.toLowerCase();
                    sPublicPassword = sc.getSetting(sSearchSetting);
                }
                authNS = ns = AdminNamespaceFactory.createAdminNamespace((int)2);
                authNS.authenticate(sPublicUser, this.m_ndapAccessDomain, sPublicPassword);
                saTypes = sc.getSettings(SETTING_CONTEXTLESS_LOGIN_CLASS + sProtocol + "." + sTempTreeName.toLowerCase());
                if (saTypes == null) {
                    saTypes = new String[]{"User"};
                }
                sSearchSetting = SETTING_SEARCH_CONTAINERS + sProtocol + "." + sTempTreeName.toLowerCase();
                searchAttributesSettingName = "Authenticate.Form.ContextlessLoginSearchAttributes." + sProtocol + "." + sTempTreeName.toLowerCase();
            } else if (sProtocol.equals(VALUE_DEFAULT_PROTOCOL_LDAP) || sProtocol.equals(VALUE_DEFAULT_PROTOCOL_LDAPS)) {
                if (this.m_ldapAccessDomain == null) {
                    return sUser;
                }
                sPublicUser = "";
                sPublicPassword = "";
                sSearchSetting = SETTING_PUBLIC_USER + sProtocol + "." + this.m_ldapAccessDomain.toLowerCase();
                sTemp = sc.getSetting(sSearchSetting);
                if (sTemp != null) {
                    sPublicUser = sTemp;
                    sSearchSetting = SETTING_PUBLIC_PASSWORD + sProtocol + "." + this.m_ldapAccessDomain.toLowerCase();
                    sPublicPassword = sc.getSetting(sSearchSetting);
                }
                authNS = ns = AdminNamespaceFactory.createAdminNamespace((int)1);
                LDAPAuthenticationNamespace authLDAPNS = (LDAPAuthenticationNamespace)ns;
                boolean bUseSSL = false;
                if (sProtocol.equals(VALUE_DEFAULT_PROTOCOL_LDAP)) {
                    bUseSSL = false;
                } else if (sProtocol.equals(VALUE_DEFAULT_PROTOCOL_LDAPS)) {
                    bUseSSL = true;
                }
                authLDAPNS.authenticate(sPublicUser, this.m_ldapAccessDomain, sPublicPassword, bUseSSL);
                saTypes = sc.getSettings("Authenticate.Form.ContextlessLoginClass.LDAP." + this.m_ldapAccessDomain.toLowerCase());
                if (saTypes == null) {
                    saTypes = new String[]{"person", "administrativeClass", "alias"};
                }
                sSearchSetting = "Authenticate.Form.SearchContainers.LDAP." + this.m_ldapAccessDomain.toLowerCase();
                searchAttributesSettingName = "Authenticate.Form.ContextlessLoginSearchAttributes." + sProtocol + "." + this.m_ldapAccessDomain.toLowerCase();
            }
            StringBuffer sb = new StringBuffer();
            char[] ca = sUser.toCharArray();
            for (int i = 0; i < ca.length; ++i) {
                if (ca[i] == '*') {
                    if (sProtocol.equals("NDAP")) {
                        sb.append("\\*");
                        continue;
                    }
                    sb.append("\\2a");
                    continue;
                }
                sb.append(ca[i]);
            }
            String sUserEsc = sb.toString();
            String[] saAttributes = sc.getSettings(searchAttributesSettingName);
            FilterResultModifier rm = null;
            if (saAttributes != null && saAttributes.length > 0) {
                rm = new FilterResultModifier("Filter2", 0, null, true);
                for (int i = 0; i < saTypes.length; ++i) {
                    FilterResultModifier.Filter filter = new FilterResultModifier.Filter((String)saTypes[i]);
                    FilterResultModifier.FilterItemGroup group = new FilterResultModifier.FilterItemGroup();
                    for (int j = 0; j < saAttributes.length; ++j) {
                        group.addFilterItem(saAttributes[j], "=", sUserEsc, "|");
                    }
                    filter.addFilterItemGroupPair(group, "|");
                    rm.addFilter(filter);
                }
            } else {
                rm = new ResultModifier("Filter1", 0, 0, new ResultModifierFilterEntry(sUserEsc, saTypes), true);
            }
            rm.setIncludeSubClasses(true);
            String[] saContainers = sc.getSettings(sSearchSetting);
            if (saContainers == null || saContainers.length == 0) {
                saContainers = new String[]{""};
            }
            ObjectEntry oe = null;
            Vector vUsers = new Vector();
            String sContainer = null;
            for (int i = 0; i < saContainers.length; ++i) {
                sContainer = saContainers[i];
                try {
                    this.searchForUsersInContext(ns, (ResultModifier)rm, oe, vUsers, sContainer);
                    if (vUsers.size() <= 0) continue;
                    break;
                }
                catch (SPIException spiEx) {
                    D.log(spiEx);
                }
            }
            if (vUsers.size() > 0) {
                sUser = (String)vUsers.elementAt(0);
            }
            if (oe != null) {
                authNS.unAuthenticate(oe);
            }
        }
        catch (SPIException e) {
            D.log(e);
        }
        catch (SnapinException e) {
            D.log(e);
        }
        return sUser;
    }

    private void searchForUsersInContext(AdminNamespace ns, ResultModifier rm, ObjectEntry oe, Vector vUsers, String sContainer) throws SnapinException, SPIException {
        ObjectEntryEnumeration oee;
        if (sContainer.length() == 0 || sContainer.equalsIgnoreCase("[root]")) {
            ObjectEntry[] oea = ns.getInitialObjectEntries();
            if (oea != null && oea.length > 0) {
                oe = oea[0];
            }
        } else {
            oe = ns.getObjectEntry(sContainer);
        }
        if (oe != null && (oee = ns.getChildren(oe, rm)) != null) {
            ObjectEntry oeChild = null;
            while (oee.hasMoreElements()) {
                oeChild = oee.next();
                vUsers.add(ns.getUnrootedName(oeChild));
            }
        }
    }

    private boolean isValidLoginSession(HttpServletRequest req) {
        HttpSession session = req.getSession();
        String sReqInstKey = req.getParameter(LOGIN_INSTANCE_KEY);
        String sSessInstKey = (String)session.getAttribute(LOGIN_INSTANCE_KEY);
        if (!(sReqInstKey == null || sSessInstKey != null && sReqInstKey.equals(sSessInstKey))) {
            String sErrMsg = eMFrameUtils.getLocalizedString("FwResources", "AuthenticateForm.Browser.OldLoginScreenMsg", FwUtils.getCurrentLocale(session));
            req.setAttribute("Error", (Object)sErrMsg);
            req.setAttribute("GeneralMsg.MsgBody", (Object)sErrMsg);
            return false;
        }
        return true;
    }

    protected String getLoginParameter(String sParam, HttpServletRequest req, int iMaxLength) {
        String sVal = null;
        sVal = req.getParameter(sParam);
        if (sVal == null && (sVal = (String)req.getAttribute(sParam)) == null) {
            sVal = "";
        }
        if (sParam.equals("username") || sParam.equals("tree") || sParam.equals("protocol") || sParam.equals("rank")) {
            Cookie ck = new Cookie(sParam, DirAuthenticator.getHexFromString(sVal));
            if (this.getUseCookies()) {
                ck.setMaxAge(2678400);
                req.setAttribute(sParam, (Object)sVal);
            } else {
                ck.setMaxAge(0);
            }
            HttpServletResponse res = ((FwRequest)req).getResponse();
            res.addCookie(ck);
        }
        if (sVal != null && sVal.length() == 0) {
            return null;
        }
        return this.trimString(sVal, iMaxLength);
    }

    public void logout() {
        AuditLog.logLogout(this.m_username, this.m_tree, false);
        this.destroyServiceSet(true);
        this.m_bLoggedIn = false;
    }

    public void destroy() {
    }

    private void setMssInfo(HttpServletRequest req, ObjectEntry oeTree) {
        try {
            byte[] baCert;
            String sFullUserNoTree;
            AuthenticationNamespace ndsns = (AuthenticationNamespace)oeTree.getNamespace();
            ObjectEntry oeAuthUser = ndsns.getAuthenticatedIdentity(oeTree);
            String sDispUser = oeAuthUser.getName();
            AdminNamespace nsadmin = (AdminNamespace)oeTree.getNamespace();
            this.m_bNVDS = nsadmin.isSupported("NVDS");
            String sFullUserTree = nsadmin.getFullName(oeAuthUser);
            if (sFullUserTree == null || sFullUserTree.length() < 1) {
                sFullUserTree = "anonymous";
            }
            if ((sFullUserNoTree = nsadmin.getUnrootedName(oeAuthUser)) == null || sFullUserNoTree.length() < 1) {
                sFullUserNoTree = "anonymous";
            }
            String sTreeNoDots = this.getDotlessTreeName(oeAuthUser);
            FwAttr.setFwAuthAttribute("User.FDN_WithTree", sFullUserTree, this);
            FwAttr.setFwAuthAttribute("User.CN", sDispUser, this);
            FwAttr.setFwAuthAttribute("User.FDN", sFullUserNoTree, this);
            FwAttr.setFwAuthAttribute("User.LdapFDN", this.m_authBroker.getAuthLdapName(), this);
            FwAttr.setFwAuthAttribute("User.tree", sTreeNoDots, this);
            FwAttr.setFwAuthAttribute("Session", req.getSession(), this);
            this.initCredentialsAndProfile(req);
            this.m_dirRoleList = new DirRoleList(oeAuthUser);
            FwAttr.setFwAuthAttribute("authentication.authenticatedroles", this.m_dirRoleList, this);
            TaskContext tContext = eMFrameFactory.getTaskContext(req);
            FwDirUtils.updateAccessMode(tContext);
            this.initConfigScope(tContext);
            SystemConfig sc = new SystemConfig();
            if (sc.getSetting("Security.KeyStore.AutoUpdate", "true").equalsIgnoreCase("true") && (FwUtils.canConfigureiManager(req) || sc.getSetting("Security.KeyStore.UpdateAllowAll", "true").equalsIgnoreCase("true")) && (baCert = FwUtils.getRootCertificate(tContext)) != null && baCert.length > 0) {
                KeyStore_IM imanKS = KeyStore_IM.getiManagerKeyStore();
                imanKS.importCertificate(baCert);
            }
        }
        catch (Throwable e) {
            D.log(e);
        }
    }

    private void showLoginDlg(HttpServletRequest req) {
        SystemConfig sc = this.getSystemConfig();
        String sSettingName = null;
        String sValue = null;
        HttpSession session = req.getSession();
        String sLoginKey = String.valueOf(System.currentTimeMillis());
        session.setAttribute(LOGIN_INSTANCE_KEY, (Object)sLoginKey);
        req.setAttribute(LOGIN_INSTANCE_KEY, (Object)sLoginKey);
        session.setAttribute("Request.scheme", (Object)req.getScheme());
        this.setCookiesAsAttrsIfEnabled(req);
        sValue = (String)req.getAttribute("protocol");
        if (sValue == null || sValue.length() == 0) {
            sValue = sc.getSetting(SETTING_DEFAULT_PROTOCOL);
        }
        if (sValue != null && sValue.length() > 0) {
            req.setAttribute(ATTR_DEFAULT_PROTOCOL, (Object)sValue);
        }
        sValue = sc.getSetting(SETTING_SHOW_PROTOCOL, "true");
        req.setAttribute(ATTR_SHOW_PROTOCOL, (Object)sValue);
        sValue = sc.getSetting(SETTING_SHOW_TREE, "true");
        req.setAttribute(ATTR_SHOW_TREE, (Object)sValue);
        sSettingName = SETTING_DEFAULT_TREE;
        sValue = sc.getSetting(sSettingName, (String)req.getAttribute("tree"));
        if (sValue != null && sValue.length() > 0) {
            req.setAttribute(ATTR_DEFAULT_TREE, (Object)sValue);
        }
        if ((sValue = req.getParameter(sSettingName = SETTING_FORCE_MASTER)) == null) {
            sValue = sc.getSetting(CONFIG_SETTING_FORCE_MASTER, null);
        }
        if (sValue != null) {
            req.setAttribute(sSettingName, (Object)sValue);
        }
        if (!Browser.getInstance(req).isSupported()) {
            req.setAttribute("unsupportedBrowserMsg", (Object)Boolean.TRUE.toString());
        }
        this.setUIPage("fw/AuthForm.jsp", req);
    }

    private void setCookiesAsAttrsIfEnabled(HttpServletRequest req) {
        Cookie[] cookies;
        if (this.getUseCookies() && (cookies = req.getCookies()) != null) {
            int iCount = cookies.length;
            String sName = null;
            for (int i = 0; i < iCount; ++i) {
                sName = cookies[i].getName();
                if (((FwRequest)req).getAttribute(sName, false, false) != null) continue;
                if (sName.equals("username") || sName.equals("tree") || sName.equals("protocol")) {
                    req.setAttribute(sName, (Object)DirAuthenticator.getStringFromHex(cookies[i].getValue()));
                    continue;
                }
                if (sName.equals("rank")) {
                    String val = DirAuthenticator.getStringFromHex(cookies[i].getValue());
                    if (val != null && val.length() > 0 && !val.toLowerCase().equals(SECONDARY_TREE)) {
                        val = PRIMARY_TREE;
                    }
                    req.setAttribute(sName, (Object)val);
                    continue;
                }
                req.setAttribute(sName, (Object)cookies[i].getValue());
            }
        }
    }

    protected String getDotlessTreeName(ObjectEntry oe) {
        String sName;
        block8: {
            sName = oe.getRoot().getName();
            try {
                AdminNamespace ns = (AdminNamespace)oe.getNamespace();
                if (ns instanceof NDSNamespace) {
                    int lastIdx;
                    if (sName.charAt(0) == '.') {
                        sName = sName.substring(1);
                    }
                    if (sName.charAt(lastIdx = sName.length() - 1) == '.') {
                        sName = sName.substring(0, lastIdx);
                    }
                    break block8;
                }
                if (!(ns instanceof LDAPNamespace) || sName != null && sName.length() != 0) break block8;
                String sUrl = ((LDAPNamespace)ns).getProviderURL();
                try {
                    URI uri = new URI(sUrl);
                    sName = uri.getHost();
                    if (!(uri.getPort() == 389 | uri.getPort() == 636)) {
                        sName = sName + ":" + uri.getPort();
                    }
                }
                catch (URISyntaxException e) {
                    D.log(e);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return sName;
    }

    public void destroyServiceSet(boolean removeAsListener) {
        if (removeAsListener) {
            // empty if block
        }
        if (this.m_authBroker != null) {
            this.m_authBroker.logoutAll();
            this.m_authBroker = null;
        }
        Enumeration brokers = this.authBrokers.elements();
        while (brokers.hasMoreElements()) {
            AuthenticationBroker broker = (AuthenticationBroker)brokers.nextElement();
            broker.logoutAll();
            this.authBrokers.clear();
        }
        this.m_authContext.clear();
        this.m_ldapName = null;
        this.m_ndapName = null;
        this.m_password = null;
        this.m_ldapAccessDomain = null;
        this.m_ndapAccessDomain = null;
        this.m_username = null;
        this.m_tree = null;
        this.m_useLdapSSL = false;
        this.m_session = null;
        this.m_mssType = 0;
    }

    public static void staticDestroyAll() {
    }

    public Locale getLocale() {
        return FwUtils.getCurrentLocale(this.m_session);
    }

    public Object getAttribute(Object attrKey) {
        return this.m_authContext.get(attrKey);
    }

    public void setAttribute(Object attrKey, Object attrValue) {
        this.m_authContext.put(attrKey, attrValue);
    }

    public void removeAttribute(Object attrKey) {
        this.m_authContext.remove(attrKey);
    }

    public DirUtils getDirUtils() {
        FwDirUtils dirUtils = (FwDirUtils)FwAttr.getFwAuthAttribute("fw.DirUtils", this);
        if (dirUtils == null) {
            dirUtils = new FwDirUtils();
            dirUtils.init(this);
            FwAttr.setFwAuthAttribute("fw.DirUtils", dirUtils, this);
        }
        return dirUtils;
    }

    public AuthenticationBroker getAuthenticationBroker() {
        if (this.m_authBroker == null) {
            this.m_authBroker = AuthenticationBroker.createAuthenticationBroker(this.m_ldapName, this.m_ndapName, this.m_password, this.m_ldapAccessDomain, this.m_ndapAccessDomain, this.m_useLdapSSL, this);
            this.m_password = null;
            this.m_protocol = null;
        }
        return this.m_authBroker;
    }

    public Hashtable getAuthenticationBrokers() {
        return this.authBrokers;
    }

    public AuthenticationBroker getAuthenticationBroker(String authBrokerKey) {
        if (authBrokerKey != null) {
            Enumeration keys = this.authBrokers.keys();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                if (!key.startsWith(authBrokerKey)) continue;
                return (AuthenticationBroker)this.authBrokers.get(key);
            }
        }
        return this.getAuthenticationBroker();
    }

    public void resetPIdentity(String new_PIdentity) throws AuthBrokerException {
        if (this.m_authBroker != null) {
            this.m_authBroker.resetAuthPIdentity(new_PIdentity);
            this.m_credentials.setSetting("password", this.getAuthenticationBroker().getAuthPIdentity());
        } else {
            this.m_password = new_PIdentity;
        }
    }

    public boolean isPrimaryDataStore() {
        return this.m_mssType == 1;
    }

    public static ManagementServiceSet getManagementServiceSet(HttpSession session) {
        return DirAuthenticator.getDirAuth(FwUtils.getRequest(session)).getManagementServicesSet();
    }

    public ManagementServiceSet getManagementServicesSet() {
        return this.m_managementServicesSet;
    }

    private static String getHexFromString(String sStr) {
        String sRet = null;
        byte[] ba = null;
        try {
            ba = sStr.getBytes("UTF-8");
            StringBuffer sb = new StringBuffer(sStr.length() * 2);
            for (int i = 0; i < ba.length; ++i) {
                sb.append(GUID.byteAsHexString((int)ba[i]));
            }
            sRet = sb.toString();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return sRet;
    }

    private static String getStringFromHex(String sStr) {
        String sRet = null;
        if (sStr == null) {
            return null;
        }
        if (sStr.length() % 2 == 1) {
            return sStr;
        }
        boolean bIsHexStr = true;
        for (int i = 0; i < sStr.length() && bIsHexStr; ++i) {
            char ch = sStr.charAt(i);
            if (Character.isDigit(ch)) continue;
            if (Character.isLetter(ch)) {
                switch (ch) {
                    case 'A': 
                    case 'B': 
                    case 'C': 
                    case 'D': 
                    case 'E': 
                    case 'F': 
                    case 'a': 
                    case 'b': 
                    case 'c': 
                    case 'd': 
                    case 'e': 
                    case 'f': {
                        break;
                    }
                    default: {
                        bIsHexStr = false;
                        break;
                    }
                }
                continue;
            }
            bIsHexStr = false;
        }
        if (!bIsHexStr) {
            return sStr;
        }
        try {
            byte[] ba = GUID.HexStringAsByte((String)sStr);
            sRet = new String(ba, "UTF-8");
        }
        catch (Exception e) {
            // empty catch block
        }
        return sRet;
    }

    protected static String[] getHttpCredentials(HttpServletRequest req) {
        String[] sResults = new String[2];
        String sAuthHdr = req.getHeader("Authorization");
        if (sAuthHdr != null && sAuthHdr.toUpperCase().startsWith("BASIC")) {
            String sBase64 = sAuthHdr.substring(6);
            BASE64Decoder dec = new BASE64Decoder();
            try {
                String sUserPass = new String(dec.decodeBuffer(sBase64));
                StringTokenizer st = new StringTokenizer(sUserPass, ":");
                sResults[0] = st.nextToken();
                sResults[1] = st.nextToken();
            }
            catch (Exception e) {
                sResults[0] = "";
                sResults[1] = "";
            }
        }
        return sResults;
    }

    private String trimString(String sStr, int iLength) {
        if (sStr == null) {
            return sStr;
        }
        if (sStr.length() > iLength) {
            String sRet = sStr.substring(0, iLength - 1);
            return sRet;
        }
        return sStr;
    }

    public String handleDirectoryEvent(DirectoryEvent event) {
        String retVal = null;
        if (event != null) {
            ObjectEntry obj = (ObjectEntry)event.getOldValue();
            String objType = obj.getTypeName().toUpperCase();
            String key = event.getOperation() + "," + objType;
            ArrayList listeners = (ArrayList)this.directoryEventListeners.get(key);
            if (listeners != null) {
                Iterator itr = listeners.iterator();
                retVal = this.postDirectoryEventNotification(event, itr);
            }
        }
        return retVal;
    }

    public void addPluginEventListener(int operation, String objectType, IManagerPluginEventListener listener) {
        ArrayList<IManagerPluginEventListener> list = (ArrayList<IManagerPluginEventListener>)this.directoryEventListeners.get(operation + "," + objectType.toUpperCase());
        if (list == null) {
            list = new ArrayList<IManagerPluginEventListener>();
        }
        list.add(listener);
        this.directoryEventListeners.put(operation + "," + objectType.toUpperCase(), list);
    }

    public void removePuginEventListener(int operation, String objectType, IManagerPluginEventListener listener) {
        ArrayList list = (ArrayList)this.directoryEventListeners.get(operation + "," + objectType.toUpperCase());
        if (list != null) {
            list.remove(listener);
        }
    }

    private String postDirectoryEventNotification(DirectoryEvent event, Iterator itr) {
        String retVal = null;
        if (itr != null) {
            while (itr.hasNext()) {
                DirectoryEventListener listener = (DirectoryEventListener)itr.next();
                retVal = listener.handleDirectoryEvent(event);
                if (retVal == null || retVal.length() <= 0) continue;
                return retVal;
            }
        }
        return retVal;
    }

    public Map getRunnablesDocs(HttpSession session) {
        if (this.m_runnables == null) {
            this.updateRoles(FwUtils.getMContext(FwUtils.getRequest(session)));
        }
        return this.m_runnables;
    }

    public Map getUpdatedRoles(MContext context) {
        this.updateRoles(context);
        return this.m_dirRoleList.getRolesById();
    }

    public void updateRoles(MContext context) {
        if (FwUtils.isRBSEnabled(context)) {
            this.m_dirRoleList.doUpdateFromDirectory(context, false);
        } else {
            this.m_dirRoleList.updateFromReg(context);
        }
        this.initDirRunnables(context);
    }

    private void initDirRunnables(MContext context) {
        HashMap privateRunnableDocs = new HashMap();
        if (FwUtils.isRBSEnabled(context)) {
            privateRunnableDocs.putAll(this.m_dirRoleList.getAllTasksById());
        } else {
            Registry installReg = Registry.getRegistry("Install");
            HashMap installDocs = installReg.getRunnablesForAuthenticator(this.m_authContext.getAuthClassContext().getName());
            if (installDocs != null) {
                privateRunnableDocs.putAll(installDocs);
            }
        }
        this.m_runnables = privateRunnableDocs;
    }

    private void initCredentialsAndProfile(HttpServletRequest req) {
        this.m_credentials = new MCredentials("FwResources", FwUtils.getCurrentLocale(req.getSession()));
        this.m_credentials.setSetting("Id", FwAttr.getFwAuthAttribute("User.CN", this));
        this.m_credentials.setSetting("FullId", FwAttr.getFwAuthAttribute("User.FDN", this));
        this.m_credentials.setSetting("DisplayName", FwAttr.getFwAuthAttribute("User.CN", this));
        this.m_credentials.setSetting("password", this.getAuthenticationBroker().getAuthPIdentity());
        this.m_profile = new ConnectionProfile("FwResources", FwUtils.getCurrentLocale(req.getSession()));
        this.m_profile.setSetting("UniqueHostName", FwAttr.getFwAuthAttribute("User.tree", this));
        this.m_profile.setSetting("HostURI", this.getAuthenticationBroker().getAuthLdapAccessDomain());
        this.m_profile.setSetting("RootName", FwAttr.getFwAuthAttribute("User.tree", this));
    }

    private void initConfigScope(MContext context) {
        try {
            AuthenticationBroker ab = this.getAuthenticationBroker();
            ObjectEntry oeRoot = (ObjectEntry)ab.getProtocolObject("AdminNamespace");
            AdminNamespace ns = oeRoot.getAdminNamespace();
            this.m_sAuthScope = oeRoot.getName();
            if (this.m_sAuthScope == null || this.m_sAuthScope.length() == 0) {
                if (ns instanceof LDAPNamespace) {
                    this.m_sAuthScope = ab.getAuthLdapAccessDomain();
                } else if (ns instanceof NDSNamespace) {
                    this.m_sAuthScope = ab.getAuthNdapAccessDomain();
                }
            }
            this.m_sAuthScope = ns.getUniqueID() + this.m_sAuthScope;
        }
        catch (AuthBrokerException e) {
            D.log(e);
        }
    }

    public String getUserId(MContext context) {
        return (String)FwAttr.getFwAuthAttribute("User.FDN", this);
    }

    public String getConfigScope(MContext context) {
        return this.m_sAuthScope;
    }

    public boolean isPluginAvailable(MContext context, Document doc) {
        if (!this.m_bLoggedIn) {
            return false;
        }
        Set values = FwAuthUtils.getAuthSettingForPlugin(context, doc, this.getAuthContext().getName(), "system");
        if (this.m_bNVDS) {
            return values.contains("NVDS");
        }
        return values.contains("eDir") || values.isEmpty();
    }

    public static DirAuthenticator getDirAuth(HttpServletRequest req) {
        return (DirAuthenticator)FwAuthUtils.getAuthenticator("dir", req);
    }

    public DirRoleList getDirRoleList(FwTaskContext context) {
        RoleList.getInstance(context);
        return this.m_dirRoleList;
    }

    public boolean hasRolesInDirectory(FwTaskContext context) {
        return this.m_dirRoleList.hasRolesInDirectory(context);
    }

    public static DirAuthenticator getDirAuth(MContext context) {
        return DirAuthenticator.getDirAuth(context.getRequest());
    }

    public boolean isAuthenticatedButNotComplete() {
        return this.m_bLoggedInButNotDone;
    }

    protected void invalidateCachedRolesAndTasks(MContext context) {
        super.invalidateCachedRolesAndTasks(context);
        this.m_dirRoleList.invalidate(context);
    }

    public boolean docSupportsSystem(Document doc, String systemName) {
        boolean bRet = false;
        XPath xpathSupportedAuths = (XPath)sm_hmSystemSupportedXPathsBySystem.get(systemName);
        try {
            if (xpathSupportedAuths == null) {
                xpathSupportedAuths = XPath.newInstance((String)(".//auth-assignment[(id=\"any\") or (id = \"" + this.getAuthContext().getName() + "\" and setting[name = \"system\" and value = \"" + systemName + "\"])]"));
                sm_hmSystemSupportedXPathsBySystem.put(systemName, xpathSupportedAuths);
            }
            Element authNode = (Element)xpathSupportedAuths.selectSingleNode((Object)doc);
            bRet = systemName.equals("eDir") && authNode == null ? FwAuthUtils.getSupportedAuthenticatorNamesForPlugin(doc).contains("dir") : authNode != null;
        }
        catch (JDOMException e) {
            D.log(e);
        }
        return bRet;
    }

    public String getSystem() {
        if (this.m_bNVDS) {
            return "NVDS";
        }
        return "eDir";
    }

    public ConnectionProfile getConnectionProfile(HttpServletRequest req) {
        return this.m_profile;
    }

    public MCredentials getCredentials(HttpServletRequest req) throws AuthNotAuthenticatedException {
        return this.m_credentials;
    }

    public Object getUserData() {
        return null;
    }
}

