/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.fw.config;

import com.novell.emframe.authDev.iMgrAuthenticatorImpl;
import com.novell.emframe.dev.D;
import com.novell.emframe.dev.MContext;
import com.novell.emframe.dev.eMFrameUtils;
import com.novell.emframe.fw.config.ConfigRecord;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.Random;
import java.util.Vector;

public class ConfigRecordManager
implements Serializable {
    private static final long serialVersionUID = -2096544924518412177L;
    public static final String SYSTEM_CONFIG_FILE = "WEB-INF" + File.separator + "config.xml";
    public static final String SYSTEM_CONFIG_FOLDER = "WEB-INF" + File.separator + "config";
    public static final String CONFIG_ATTRIBUTE = "mConfig";
    public static final String CONFIG_CLASS = "mConfigClass";
    private static final Object m_objSyncWrite = new Object();
    private String m_sUserID = null;
    private String m_sAuthScope = null;
    private String m_sUserFolderName = null;
    private boolean m_bIsDirectory = false;
    private int m_iMode = 1;
    private Vector m_vRecords = null;

    public static void init() {
        String sFolder = SYSTEM_CONFIG_FOLDER;
        String sTrueName = eMFrameUtils.getRealPath(sFolder);
        File f = new File(sTrueName);
        if (!f.exists()) {
            f.mkdir();
        }
    }

    public ConfigRecordManager(MContext ctx, int iMode) {
        this.create(ctx, this.m_sUserID, iMode);
    }

    public ConfigRecordManager(MContext ctx, String sObjectDN, int iMode) {
        this.create(ctx, sObjectDN, iMode);
    }

    private void create(MContext ctx, String sObjectDN, int iMode) {
        iMgrAuthenticatorImpl auth = (iMgrAuthenticatorImpl)ctx.getAuthenticator();
        this.m_sUserID = sObjectDN;
        this.m_sAuthScope = auth.getConfigScope(ctx);
        this.m_iMode = iMode;
        if (this.m_iMode == 2) {
            String sFolder = this.getUserFolderName();
            String sTrueName = eMFrameUtils.getRealPath(sFolder);
            File f = new File(sTrueName);
            if (!f.exists()) {
                f.mkdir();
            }
        } else if (this.m_iMode == 3) {
            this.m_bIsDirectory = true;
        }
    }

    private String getUserFolderName() {
        if (this.m_sUserFolderName == null) {
            this.generateUserFolderName();
        }
        return this.m_sUserFolderName;
    }

    private void generateUserFolderName() {
        char ch;
        int i;
        StringBuffer sb = new StringBuffer(10 + this.m_sUserID.length() + this.m_sAuthScope.length());
        sb.append(SYSTEM_CONFIG_FOLDER + File.separatorChar);
        for (i = 0; i < this.m_sAuthScope.length(); ++i) {
            ch = this.m_sAuthScope.charAt(i);
            if (!Character.isLetterOrDigit(ch)) continue;
            sb.append(Character.toUpperCase(ch));
        }
        sb.append("-");
        for (i = 0; i < this.m_sUserID.length(); ++i) {
            ch = this.m_sUserID.charAt(i);
            if (!Character.isLetterOrDigit(ch)) continue;
            sb.append(Character.toLowerCase(ch));
        }
        this.m_sUserFolderName = sb.toString();
    }

    public ConfigRecordManager(MContext ctx, String sObjectDN) {
        this.m_sUserID = sObjectDN;
        this.m_bIsDirectory = true;
    }

    public ConfigRecordManager() {
    }

    public void read() {
        this.m_vRecords = this.readInternal();
    }

    private Vector readInternal() {
        Vector vRet = null;
        switch (this.m_iMode) {
            case 1: {
                vRet = this.readFileSystem();
                break;
            }
            case 2: {
                vRet = this.readUserFileSystem();
                break;
            }
            case 3: {
                vRet = this.readDirectory(false);
            }
        }
        return vRet;
    }

    private Vector readFileSystem() {
        String sTrueName;
        File fConfig;
        String[] saFiles;
        Vector<ConfigRecord> vRet = new Vector<ConfigRecord>();
        ConfigRecord cr = null;
        cr = this.readFile(SYSTEM_CONFIG_FILE);
        if (cr != null) {
            vRet.add(cr);
        }
        if ((saFiles = (fConfig = new File(sTrueName = eMFrameUtils.getRealPath(SYSTEM_CONFIG_FOLDER))).list()) != null) {
            for (int i = 0; i < saFiles.length; ++i) {
                cr = this.readFile(SYSTEM_CONFIG_FOLDER + File.separator + saFiles[i]);
                if (cr == null || !cr.isValid()) continue;
                vRet.add(cr);
            }
        }
        return vRet;
    }

    private Vector readUserFileSystem() {
        Vector<ConfigRecord> vRet = new Vector<ConfigRecord>();
        ConfigRecord cr = null;
        String sFolderName = this.getUserFolderName();
        String sTrueName = eMFrameUtils.getRealPath(sFolderName);
        File fConfig = new File(sTrueName);
        String[] saFiles = fConfig.list();
        if (saFiles != null) {
            for (int i = 0; i < saFiles.length; ++i) {
                cr = this.readFile(sFolderName + File.separator + saFiles[i]);
                if (cr == null || !cr.isValid()) continue;
                vRet.add(cr);
            }
        }
        return vRet;
    }

    private ConfigRecord readFile(String sFileName) {
        ConfigRecord cr = null;
        FileInputStream fis = null;
        try {
            String sTrueName = eMFrameUtils.getRealPath(sFileName);
            fis = new FileInputStream(sTrueName);
            cr = new ConfigRecord();
            cr.read(fis);
            cr.setFileName(sFileName);
            fis.close();
        }
        catch (FileNotFoundException e) {
        }
        catch (IOException e) {
            D.log(e);
        }
        return cr;
    }

    private Vector readDirectory(boolean bSaveRaw) {
        return null;
    }

    public void writeRecord(ConfigRecord cr) {
        boolean bRootRecord = false;
        if (cr.isMatch(null)) {
            bRootRecord = true;
        }
        if (bRootRecord) {
            this.writeRecordFileSystem(cr);
        } else {
            switch (this.m_iMode) {
                case 1: {
                    this.writeRecordFileSystem(cr);
                    break;
                }
                case 2: {
                    this.writeRecordUserFileSystem(cr);
                    break;
                }
                case 3: {
                    this.writeRecordDirectory(cr);
                }
            }
        }
    }

    private void writeRecordDirectory(ConfigRecord cr) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeRecordFileSystem(ConfigRecord cr) {
        Object object = m_objSyncWrite;
        synchronized (object) {
            this.deleteRecord(cr);
            String sFileName = this.generateFileName(cr, SYSTEM_CONFIG_FOLDER);
            try {
                String sTrueName = eMFrameUtils.getRealPath(sFileName);
                FileOutputStream fos = new FileOutputStream(sTrueName);
                cr.write(fos);
                fos.close();
            }
            catch (FileNotFoundException e) {
                D.log(e);
            }
            catch (IOException e) {
                D.log(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeRecordUserFileSystem(ConfigRecord cr) {
        Object object = m_objSyncWrite;
        synchronized (object) {
            this.deleteRecord(cr);
            String sFileName = this.generateFileName(cr, this.getUserFolderName());
            try {
                String sTrueName = eMFrameUtils.getRealPath(sFileName);
                FileOutputStream fos = new FileOutputStream(sTrueName);
                cr.write(fos);
                fos.close();
            }
            catch (FileNotFoundException e) {
                D.log(e);
            }
            catch (IOException e) {
                D.log(e);
            }
        }
    }

    public String getUserConfigFileName(ConfigRecord cr) {
        return eMFrameUtils.getRealPath(this.generateFileName(cr, this.getUserFolderName()));
    }

    private String generateFileName(ConfigRecord cr, String sFolderName) {
        String sRet = null;
        if (cr.getConfigID() == null) {
            sRet = SYSTEM_CONFIG_FILE;
        } else {
            String sConfigID = this.stripID(cr.getConfigID());
            StringBuffer sb = new StringBuffer();
            String sTrueName = null;
            File f = null;
            Random randomNumber = null;
            while (true) {
                sb.setLength(0);
                sb.append(sFolderName).append(File.separator).append(sConfigID);
                if (randomNumber != null) {
                    int iExt = randomNumber.nextInt(1000);
                    sb.append("-").append(iExt);
                }
                sb.append(".xml");
                sRet = sb.toString();
                sTrueName = eMFrameUtils.getRealPath(sRet);
                f = new File(sTrueName);
                if (!f.exists()) break;
                if (randomNumber != null) continue;
                randomNumber = new Random();
            }
        }
        return sRet;
    }

    private String stripID(String sID) {
        String sRet = sID;
        if (sRet != null) {
            StringBuffer sb = new StringBuffer(sRet.length());
            for (int i = 0; i < sRet.length(); ++i) {
                char ch = sRet.charAt(i);
                if (!Character.isLetterOrDigit(ch) && ch != '-') continue;
                sb.append(ch);
            }
            sRet = sb.toString();
        }
        return sRet;
    }

    public void deleteRecord(ConfigRecord cr) {
        boolean bRootRecord = false;
        if (cr.isMatch(null)) {
            bRootRecord = true;
        }
        if (!this.m_bIsDirectory || bRootRecord) {
            String sFileName = cr.getFileName();
            if (sFileName == null) {
                Vector vRecords = null;
                if (bRootRecord || this.m_iMode == 1) {
                    vRecords = this.readFileSystem();
                } else if (this.m_iMode == 2) {
                    vRecords = this.readUserFileSystem();
                }
                cr = this.getRecordInternal(vRecords, cr.getConfigID());
                if (cr != null) {
                    sFileName = cr.getFileName();
                }
            }
            if (sFileName != null) {
                String sTrueName = eMFrameUtils.getRealPath(sFileName);
                File f = new File(sTrueName);
                f.delete();
            }
        }
    }

    public void deleteRecord(String sModuleID, String sTaskID) {
        ConfigRecord cr = new ConfigRecord(sModuleID, sTaskID);
        this.deleteRecord(cr);
    }

    public ConfigRecord[] getRecords() {
        ConfigRecord[] crArray = null;
        if (this.m_vRecords != null) {
            crArray = new ConfigRecord[this.m_vRecords.size()];
            this.m_vRecords.toArray(crArray);
        }
        return crArray;
    }

    public ConfigRecord getRecord(String sConfigID) {
        return this.getRecordInternal(this.m_vRecords, sConfigID);
    }

    private ConfigRecord getRecordInternal(Vector vRecords, String sConfigID) {
        ConfigRecord crRet = null;
        if (vRecords != null) {
            ConfigRecord cr = null;
            for (int i = 0; i < vRecords.size(); ++i) {
                cr = (ConfigRecord)vRecords.elementAt(i);
                if (!cr.isMatch(sConfigID)) continue;
                crRet = cr;
                break;
            }
        }
        return crRet;
    }
}

