/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.fw.config;

import com.novell.emframe.dev.D;
import com.novell.emframe.dev.MContext;
import com.novell.emframe.fw.Registry;
import com.novell.emframe.fw.config.ConfigManager;
import com.novell.emframe.fw.config.ConfigSettings;
import com.novell.emframe.fw.config.SystemConfigManager;
import java.util.HashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.jdom.Document;
import org.jdom.JDOMException;
import org.jdom.output.DOMOutputter;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class UserConfigManager {
    private ConfigManager m_configManager = null;
    private ConfigSettings m_csMerged = null;

    public UserConfigManager(MContext ctx, int iMode) {
        this.m_configManager = new ConfigManager(ctx, iMode);
        this.init();
    }

    public UserConfigManager(MContext ctx, String dn, int iMode) {
        this.m_configManager = new ConfigManager(ctx, dn, iMode);
        this.init();
    }

    public UserConfigManager(MContext ctx, String dn) {
        this.m_configManager = new ConfigManager(ctx, dn);
        this.init();
    }

    public void init() {
        this.m_configManager.setCacheSize(SystemConfigManager.getCacheSize());
    }

    public String[] getSettingNames(String userConfigID) {
        ConfigSettings config = this.getInheritedConfigSettings(userConfigID);
        if (config == null) {
            return null;
        }
        return config.getSettingNames();
    }

    public String[] getSetting(String userConfigID, String setting) {
        ConfigSettings config = this.getInheritedConfigSettings(userConfigID);
        if (config == null) {
            return null;
        }
        return config.getSetting(setting);
    }

    public String getSingleSetting(String userConfigID, String setting) {
        ConfigSettings config = this.getInheritedConfigSettings(userConfigID);
        if (config == null) {
            return null;
        }
        return config.getSingleSetting(setting);
    }

    public String getSingleSetting(String userConfigID, String setting, String defaultValue) {
        ConfigSettings config = this.getInheritedConfigSettings(userConfigID);
        if (config == null) {
            return null;
        }
        return config.getSingleSetting(setting, defaultValue);
    }

    public void setSetting(String userConfigID, String setting, String[] values) {
        ConfigSettings config = this.m_configManager.getConfigSettings(userConfigID);
        if (config == null) {
            return;
        }
        config.setSetting(setting, values);
        if (this.m_csMerged != null) {
            this.m_csMerged.setSetting(setting, values);
        }
    }

    public void setSetting(String userConfigID, String setting, String value) {
        ConfigSettings config = this.m_configManager.getConfigSettings(userConfigID);
        if (config == null) {
            return;
        }
        config.setSetting(setting, value);
        if (this.m_csMerged != null) {
            this.m_csMerged.setSetting(setting, value);
        }
    }

    public void addSettingValue(String userConfigID, String setting, String value) {
        ConfigSettings config = this.m_configManager.getConfigSettings(userConfigID);
        if (config == null) {
            return;
        }
        config.addSettingValue(setting, value);
        if (this.m_csMerged != null) {
            this.m_csMerged.addSettingValue(setting, value);
        }
    }

    public void removeSettingValue(String userConfigID, String setting, String value) {
        ConfigSettings config = this.m_configManager.getConfigSettings(userConfigID);
        if (config == null) {
            return;
        }
        config.removeSettingValue(setting, value);
        if (this.m_csMerged != null) {
            this.m_csMerged.removeSettingValue(setting, value);
        }
    }

    public void removeSetting(String userConfigID, String setting) {
        ConfigSettings config = this.m_configManager.getConfigSettings(userConfigID);
        if (config == null) {
            return;
        }
        config.removeSetting(setting);
        if (this.m_csMerged != null) {
            this.m_csMerged.removeSetting(setting);
        }
    }

    public void writeSettings(String userConfigID) {
        this.m_configManager.writeSettings(userConfigID);
    }

    public String getUserConfigFileName(String userConfigID) {
        return this.m_configManager.getUserConfigFileName(userConfigID);
    }

    private ConfigSettings parseSettingsFromDom(org.w3c.dom.Document doc, String userConfigID) {
        ConfigSettings rConfig = null;
        try {
            org.w3c.dom.Document root = doc;
            NodeList nl = root.getChildNodes();
            if (nl.getLength() == 0) {
                return null;
            }
            Node rootElement = nl.item(0);
            NodeList childList = rootElement.getChildNodes();
            for (int i = 0; i < childList.getLength(); ++i) {
                Node nElement = childList.item(i);
                if (nElement.getNodeType() == 1 && nElement.getNodeName().equals("rbs-xml-info")) {
                    rootElement = nElement;
                    childList = rootElement.getChildNodes();
                    i = -1;
                }
                if (nElement.getNodeType() != 1 || !nElement.getNodeName().equals("config")) continue;
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = factory.newDocumentBuilder();
                org.w3c.dom.Document nDoc = builder.newDocument();
                nDoc.appendChild(nDoc.importNode(nElement, true));
                rConfig = new ConfigSettings();
                rConfig.setDocument(nDoc);
                rConfig.readDom();
                rConfig.setConfigID(userConfigID);
                break;
            }
        }
        catch (Exception e) {
            D.log(e);
        }
        return rConfig;
    }

    private ConfigSettings getRegistryConfig(String userConfigID) {
        Registry installRegistry;
        HashMap installTaskDocs;
        int index = userConfigID.lastIndexOf(58);
        if (index != -1) {
            userConfigID = userConfigID.substring(index + 1);
        }
        ConfigSettings rConfig = null;
        Registry globalRegistry = Registry.getRegistry("Global");
        HashMap globalTaskDocs = globalRegistry.getRunnables();
        Document dom = (Document)globalTaskDocs.get(userConfigID);
        if (dom != null) {
            DOMOutputter domOutputter = new DOMOutputter();
            try {
                org.w3c.dom.Document doc = domOutputter.output(dom);
                if (doc != null) {
                    return this.parseSettingsFromDom(doc, userConfigID);
                }
            }
            catch (JDOMException e) {
                e.printStackTrace();
            }
        }
        if ((dom = (Document)(installTaskDocs = (installRegistry = Registry.getRegistry("Install")).getRunnables()).get(userConfigID)) != null) {
            DOMOutputter domOutputter = new DOMOutputter();
            try {
                org.w3c.dom.Document doc = domOutputter.output(dom);
                if (doc != null) {
                    return this.parseSettingsFromDom(doc, userConfigID);
                }
            }
            catch (JDOMException e) {
                e.printStackTrace();
            }
        }
        return rConfig;
    }

    private ConfigSettings getInheritedConfigSettings(String userConfigID) {
        if (this.m_csMerged != null) {
            return this.m_csMerged;
        }
        ConfigSettings mConfig = null;
        ConfigSettings rConfig = this.getRegistryConfig(userConfigID);
        ConfigSettings sConfig = SystemConfigManager.getConfigSettings(userConfigID);
        ConfigSettings uConfig = this.m_configManager.getConfigSettings(userConfigID);
        if (rConfig != null) {
            mConfig = rConfig;
            if (sConfig != null) {
                mConfig.mergeConfig(sConfig.copy());
            }
            mConfig.mergeConfig(uConfig);
        } else if (sConfig != null) {
            mConfig = sConfig.copy();
            mConfig.mergeConfig(uConfig);
        } else {
            mConfig = uConfig;
        }
        this.m_csMerged = mConfig;
        return mConfig;
    }
}

