/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.fw.security;

import com.novell.emframe.dev.D;
import com.novell.emframe.dev.eMFrameUtils;
import com.novell.emframe.fw.security.SecurityException_IM;
import com.novell.nps.WebappUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.Principal;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;

public class KeyStore_IM {
    private static final String KEYSTORE_FILENAME = "iMKS";
    private static final char[] KEYSTORE_PASSWORD = "iManagerSecureKeyStorePassword".toCharArray();
    private static KeyStore_IM singleton_keyStore_IM = null;
    private static Object singletonKeyStoreLock = new Object();
    public KeyStore iManagerKeyStore;
    private File m_keyStoreFile = null;

    private KeyStore_IM() throws SecurityException_IM {
        InputStream is_KeyStore = null;
        try {
            this.iManagerKeyStore = KeyStore.getInstance("JKS");
            File imKeyStoreFile = this.getIMKeyStoreFileObject();
            try {
                is_KeyStore = new FileInputStream(imKeyStoreFile);
            }
            catch (FileNotFoundException fe) {
                D.log("iManager KeyStore \"" + imKeyStoreFile.getPath() + "\" not found using null: " + fe.toString());
            }
            this.iManagerKeyStore.load(is_KeyStore, KEYSTORE_PASSWORD);
        }
        catch (Exception e) {
            throw new SecurityException_IM(2, (Throwable)e);
        }
        finally {
            try {
                if (is_KeyStore != null) {
                    is_KeyStore.close();
                }
            }
            catch (IOException ioe) {
                D.log("Unable to close iManager KeyStore input stream: " + ioe.toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static KeyStore_IM getiManagerKeyStore() throws SecurityException_IM {
        if (singleton_keyStore_IM == null) {
            Object object = singletonKeyStoreLock;
            synchronized (object) {
                if (singleton_keyStore_IM == null) {
                    try {
                        singleton_keyStore_IM = new KeyStore_IM();
                    }
                    catch (SecurityException_IM seim) {
                        D.log(seim);
                        throw seim;
                    }
                }
            }
        }
        return singleton_keyStore_IM;
    }

    public void importCertificate(byte[] encodedCertificateChain) throws SecurityException_IM {
        ByteArrayInputStream baisCert = new ByteArrayInputStream(encodedCertificateChain);
        try {
            CertificateFactory certFact = CertificateFactory.getInstance("X.509");
            Collection<? extends Certificate> certCollection = certFact.generateCertificates(baisCert);
            X509Certificate[] x509Certs = new X509Certificate[certCollection.size()];
            certCollection.toArray(x509Certs);
            this.importCertificateChain(x509Certs);
        }
        catch (CertificateException ce) {
            SecurityException_IM se = new SecurityException_IM(4, (Throwable)ce);
            throw se;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void importCertificateChain(X509Certificate[] certificateChain) throws SecurityException_IM {
        if (certificateChain.length <= 0) {
            throw new SecurityException_IM(6);
        }
        X509Certificate rootCertificate = certificateChain[certificateChain.length - 1];
        try {
            rootCertificate.checkValidity();
            File output = new File(WebappUtil.getRealPath((String)"/") + "WEB-INF" + File.separatorChar + "ServerCert.der");
            if (output.exists()) {
                output.delete();
            }
            output = new File(WebappUtil.getRealPath((String)"/") + "WEB-INF" + File.separatorChar + "ServerCert.der");
            FileOutputStream out = new FileOutputStream(output);
            out.write(rootCertificate.getEncoded());
            out.flush();
            out.close();
        }
        catch (Exception e) {
            D.log("Invalid certificate - not importing into iManager keystore: " + e.toString());
            throw new SecurityException_IM(6, (Throwable)e);
        }
        boolean needToAddCertificate = true;
        KeyStore keyStore = this.iManagerKeyStore;
        synchronized (keyStore) {
            try {
                String matchedAlias = this.iManagerKeyStore.getCertificateAlias(rootCertificate);
                if (matchedAlias != null) {
                    needToAddCertificate = false;
                }
            }
            catch (KeyStoreException e) {
                D.log(e);
            }
        }
        if (needToAddCertificate) {
            keyStore = this.iManagerKeyStore;
            synchronized (keyStore) {
                try {
                    String rootAlias = this.getCertificateAliasName(rootCertificate);
                    this.iManagerKeyStore.setCertificateEntry(rootAlias, rootCertificate);
                }
                catch (KeyStoreException e) {
                    throw new SecurityException_IM(4, (Throwable)e);
                }
                OutputStream os_KeyStore = null;
                try {
                    File imKeyStoreFile = this.getIMKeyStoreFileObject();
                    os_KeyStore = new FileOutputStream(imKeyStoreFile);
                    this.iManagerKeyStore.store(os_KeyStore, KEYSTORE_PASSWORD);
                }
                catch (Exception e) {
                    SecurityException_IM se = new SecurityException_IM(3, (Throwable)e);
                    D.log("Certicate stored in memory. However unable to save on filesystem: " + se.getLocalizedMessage(), 1);
                }
                finally {
                    try {
                        if (os_KeyStore != null) {
                            os_KeyStore.close();
                        }
                    }
                    catch (IOException ioe) {
                        D.log("Unable to close iManager KeyStore output stream: " + ioe.toString());
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public X509Certificate[] getAllCertificates() {
        try {
            ArrayList<X509Certificate> allCertList = new ArrayList<X509Certificate>(this.iManagerKeyStore.size());
            KeyStore keyStore = this.iManagerKeyStore;
            synchronized (keyStore) {
                Enumeration<String> ksEnum = this.iManagerKeyStore.aliases();
                while (ksEnum.hasMoreElements()) {
                    String aliasName = ksEnum.nextElement();
                    X509Certificate cert = (X509Certificate)this.iManagerKeyStore.getCertificate(aliasName);
                    if (cert == null) continue;
                    allCertList.add(cert);
                }
            }
            X509Certificate[] allCerts = new X509Certificate[allCertList.size()];
            allCerts = allCertList.toArray(allCerts);
            return allCerts;
        }
        catch (KeyStoreException ke) {
            D.log(ke);
            return new X509Certificate[0];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean validateCertificate(X509Certificate certToValidate) throws CertificateExpiredException, CertificateNotYetValidException {
        boolean foundValidCertificate = false;
        try {
            X509Certificate matchedCert = null;
            KeyStore keyStore = this.iManagerKeyStore;
            synchronized (keyStore) {
                String matchedAlias = this.iManagerKeyStore.getCertificateAlias(certToValidate);
                if (matchedAlias != null) {
                    matchedCert = (X509Certificate)this.iManagerKeyStore.getCertificate(matchedAlias);
                }
            }
            if (matchedCert != null) {
                matchedCert.checkValidity();
                foundValidCertificate = true;
            }
        }
        catch (KeyStoreException ke) {
            D.log(ke);
        }
        return foundValidCertificate;
    }

    private File getIMKeyStoreFileObject() {
        if (this.m_keyStoreFile == null) {
            String sKeyStorePath = eMFrameUtils.getRealPath("/WEB-INF");
            this.m_keyStoreFile = new File(sKeyStorePath, KEYSTORE_FILENAME);
        }
        return this.m_keyStoreFile;
    }

    private String getCertificateAliasName(X509Certificate certificate) throws SecurityException_IM {
        String tname;
        String aliasName = "";
        Principal principalSubjectDN = certificate.getSubjectDN();
        if (principalSubjectDN != null && (tname = principalSubjectDN.getName()) != null && tname.length() > 0) {
            aliasName = aliasName + tname;
        }
        if (aliasName.length() == 0) {
            throw new SecurityException_IM(5);
        }
        return aliasName;
    }
}

