/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.fw.studio;

import com.novell.admin.ns.AdminNamespace;
import com.novell.admin.ns.AttributeDefinition;
import com.novell.admin.ns.ClassDefinition;
import com.novell.admin.ns.NamespaceException;
import com.novell.admin.ns.SchemaDefinition;
import com.novell.admin.ns.nds.NDSClassDefinition;
import com.novell.admin.ns.nds.NDSSchemaDefinition;
import com.novell.application.console.snapin.ObjectEntry;
import com.novell.application.console.snapin.ObjectType;
import com.novell.emframe.dev.Chapter;
import com.novell.emframe.dev.D;
import com.novell.emframe.dev.DirUtils;
import com.novell.emframe.dev.GlobalRegistry;
import com.novell.emframe.dev.MContext;
import com.novell.emframe.dev.PluginException;
import com.novell.emframe.dev.Task;
import com.novell.emframe.dev.TaskContext;
import com.novell.emframe.dev.UiHandler;
import com.novell.emframe.dev.eMFrameUtils;
import com.novell.emframe.fw.CustomNpmFile;
import com.novell.emframe.fw.FwUtils;
import com.novell.emframe.fw.ListTargetChooser;
import com.novell.emframe.fw.RBSUtil;
import com.novell.emframe.fw.Registry;
import com.novell.emframe.fw.StaticListTargetChooser;
import com.novell.emframe.fw.iManager;
import com.novell.emframe.fw.npsCompat.NPSCompatUtils;
import com.novell.emframe.fw.studio.AttributeInfo;
import com.novell.emframe.fw.studio.AttributeInfoComparator;
import com.novell.emframe.fw.studio.PluginParams;
import com.novell.emframe.fw.studio.SortByNaming;
import com.novell.emframe.fw.studio.TemplateBuilderUtils;
import com.novell.emframe.fw.util.RBSObjectInstaller;
import com.novell.emframe.fw.xmlinfos.ModuleClassObject;
import com.novell.emframe.fw.xmlinfos.XMLFileReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.output.XMLOutputter;

public class CreateCustomPlugin
extends Task {
    private static final long serialVersionUID = 1L;
    public static final String CUSTOM_MODULE = "custom";
    public static final String TEMP_MODULE = "temp";
    private HttpServletRequest m_req = null;
    private TaskContext m_context = null;
    public NDSSchemaDefinition m_schema = null;
    public Document m_document = null;
    private PluginParams m_pluginParamsOnError = null;
    private static String[] blockedAttributesArray = new String[0];
    private static ArrayList blockedAttributes = new ArrayList();

    public CreateCustomPlugin() {
        for (int i = 0; i < blockedAttributesArray.length; ++i) {
            blockedAttributes.add(blockedAttributesArray[i]);
        }
    }

    public boolean execute(TaskContext context, Properties resultStrings) {
        try {
            String nextState;
            this.m_context = context;
            this.m_req = context.getRequest();
            this.m_req.setAttribute("CreateCustomPlugin", (Object)this);
            if (this.m_schema == null) {
                ObjectEntry treeOE = RBSUtil.getTreeOE(this.m_context);
                AdminNamespace namespace = treeOE.getAdminNamespace();
                this.m_schema = (NDSSchemaDefinition)namespace.getSchemaDefinition(treeOE);
            }
            if ((nextState = this.m_req.getParameter("nextState")) == null || nextState.equals("initialState")) {
                this.m_req.setAttribute("nextState", (Object)"chooseObjectClass");
                this.setUIPage("dev/WizardFrameSet.jsp");
            } else if (!nextState.equals("attributeDetails")) {
                PluginParams pluginParams;
                if (nextState.equals("chooseObjectClass")) {
                    this.stateGetObjects();
                } else if (nextState.equals("doInstall")) {
                    pluginParams = PluginParams.readFromRequest(this.m_context);
                    Document doc = pluginParams.createXmlFile(pluginParams.getJspFilename(), CUSTOM_MODULE);
                    D.log(doc);
                    try {
                        if (pluginParams.m_pluginType.equals("task")) {
                            String isModifyString = this.m_req.getParameter("modify");
                            boolean isModify = isModifyString != null && isModifyString.equals("true");
                            pluginParams.installTask(doc, isModify);
                        } else if (pluginParams.m_pluginType.equals("page")) {
                            String isModifyString = this.m_req.getParameter("modify");
                            boolean isModify = isModifyString != null && isModifyString.equals("true");
                            pluginParams.installPage(doc, isModify);
                        } else if (pluginParams.m_pluginType.equals("create")) {
                            String isModifyString = this.m_req.getParameter("modify");
                            boolean isModify = isModifyString != null && isModifyString.equals("true");
                            pluginParams.installTask(doc, isModify);
                        }
                        this.setUIPage("dev/GenConf.jsp");
                    }
                    catch (Exception e) {
                        D.log(e);
                        this.m_req.setAttribute("GeneralMsg.Url", (Object)("webacc?taskId=" + this.m_req.getParameter("taskId") + "&nextState=returnFromError&merge=fw.Studio_main"));
                        eMFrameUtils.setErrorMessage(e, context);
                        this.m_pluginParamsOnError = pluginParams;
                        this.setUIPage("dev/GenErr.jsp");
                    }
                } else if (nextState.equals("doCopy")) {
                    this.stateDoCopy(nextState);
                } else if (nextState.equals("doModify")) {
                    this.stateDoCopy(nextState);
                } else if (nextState.equals("doPreview")) {
                    pluginParams = PluginParams.readFromRequest(this.m_context);
                    String jspFile = pluginParams.buildPreview();
                    this.m_document = pluginParams.createXmlFile(jspFile, TEMP_MODULE);
                    String url = this.m_req.getParameter("nextUrl");
                    this.m_req.setAttribute("GoUrl.RedirectUrl", (Object)(url + "&templateName=temp." + jspFile));
                } else if (nextState.equals("GetAttributes")) {
                    this.outputChapterOptions(this.m_req.getParameter("objectTypeName"));
                    String addaux = this.m_req.getParameter("addaux");
                    String[] auxClasses = null;
                    if (addaux != null) {
                        auxClasses = this.m_req.getParameterValues("aux");
                    }
                    String pluginType = this.m_req.getParameter("pluginType");
                    String objectTypeName = this.m_req.getParameter("objectTypeName");
                    String client = this.m_req.getParameter("client");
                    this.stateShowStudio(client, objectTypeName, new String[]{objectTypeName}, pluginType, addaux != null, auxClasses, null, null);
                } else if (nextState.equals("InstallTask")) {
                    this.stateInstallDeleteTask();
                } else if (nextState.equals("returnFromError")) {
                    this.stateShowStudio(this.m_pluginParamsOnError);
                } else {
                    eMFrameUtils.setMessage("error", "Internal Error", "Unsupported nextState : " + nextState, this.m_context);
                    this.setUIPage("dev/GenErr.jsp");
                }
            }
        }
        catch (Throwable e) {
            D.log(e);
            eMFrameUtils.setErrorMessage(e, this.m_context);
            this.setUIPage("dev/GenFatal.jsp");
        }
        return true;
    }

    private void stateDoCopy(String mode) throws PluginException {
        block9: {
            String pluginType = this.m_req.getParameter("pluginType");
            String pluginId = this.m_req.getParameter("plugin");
            if (mode.equals("doModify")) {
                this.m_req.setAttribute("modify", (Object)"true");
                if (pluginType.equals("page")) {
                    this.m_req.setAttribute("pluginId", (Object)pluginId.substring(pluginId.indexOf(".") + 1, pluginId.length()));
                } else {
                    this.m_req.setAttribute("pluginId", (Object)pluginId.substring(0, pluginId.indexOf(".")));
                }
            }
            try {
                if (pluginType.equals("task")) {
                    PluginParams pluginParams = PluginParams.createPluginParamsFromRbsTask(pluginId, this.m_context);
                    this.stateShowStudio(pluginParams);
                    break block9;
                }
                if (!pluginType.equals("page")) break block9;
                File file = new File(iManager.getAbsModulesPath() + "/custom/plugins/plugins.xml");
                boolean isAdmin = false;
                String accessMode = eMFrameUtils.getAccessMode(this.m_context);
                if (accessMode.equals("Unrestricted") || accessMode.equals("CollectionOwner")) {
                    isAdmin = true;
                }
                if (isAdmin || TemplateBuilderUtils.hasPropertPageRights(file, pluginId, DirUtils.getUserCN(this.m_context))) {
                    Element root = CustomNpmFile.findPlugin(file, pluginId);
                    String pageOrder = root.getChildTextTrim("page-order");
                    if (pageOrder != null) {
                        this.m_req.setAttribute("page-order", (Object)pageOrder);
                    }
                    PluginParams pluginParams = PluginParams.readFromXml(root.getChild("rbs-xml-info").getChild("plugin-params"), this.m_context);
                    this.stateShowStudio(pluginParams);
                    break block9;
                }
                String errTitle = eMFrameUtils.getLocalizedString("FwResources", "Studio.pluginEditFailed", this.m_context);
                String errbody = eMFrameUtils.getLocalizedString("FwResources", "Studio.pluginEditFailedLong", this.m_context);
                throw new PluginException(errTitle, errbody);
            }
            catch (Exception e) {
                D.log(e);
                throw new PluginException(e);
            }
        }
    }

    private void stateGetObjects() throws Exception {
        ArrayList<String> classNames = new ArrayList<String>();
        ClassDefinition[] classes = this.m_schema.getClassDefinitions();
        for (int i = 0; i < classes.length; ++i) {
            if (classes[i] == null || classes[i].getName().equals("Alias") || classes[i].getName().equals("[Anything]") || classes[i].getName().equals("[Nothing]")) continue;
            classNames.add(new String(classes[i].getName()));
        }
        ClassDefinition[] auxclasses = this.m_schema.getAuxiliaryClassDefinitions();
        ArrayList<String> auxClassNames = new ArrayList<String>();
        for (int i = 0; i < auxclasses.length; ++i) {
            auxClassNames.add(auxclasses[i].getName());
        }
        Collections.sort(auxClassNames, new Comparator(){

            public int compare(Object o, Object o1) {
                return ((String)o).compareToIgnoreCase((String)o1);
            }
        });
        this.m_req.setAttribute("auxClass", auxClassNames);
        Locale locale = this.m_context.getLocale();
        Collections.sort(classNames, Collator.getInstance(locale));
        int index = 0;
        Iterator iter = classNames.iterator();
        while (iter.hasNext()) {
            this.m_req.setAttribute("TemplateObjects." + index, iter.next());
            ++index;
        }
        this.m_req.setAttribute("TemplateObjects.Count", (Object)Integer.toString(index));
        this.setUIPage("fw/TemplateBuilder_getObjectType.jsp");
    }

    private void stateShowStudio(PluginParams pluginParams) throws Exception {
        boolean addaux = pluginParams.m_auxClasses != null && pluginParams.m_auxClasses.length > 0;
        this.m_req.setAttribute("displayName", (Object)pluginParams.m_displayName);
        this.m_req.setAttribute("mooEnabled", (Object)("" + pluginParams.m_mooEnabled));
        this.m_req.setAttribute("labelAboveControl", (Object)("" + pluginParams.m_labelAboveControl));
        if (pluginParams.m_customTargetChooser != null) {
            Element tc = pluginParams.m_customTargetChooser;
            String className = tc.getChildTextTrim("class-name");
            if (className == null) {
                String defaultTcMode = tc.getChildTextTrim("param-value");
                if (defaultTcMode == null) {
                    defaultTcMode = "simple";
                }
                this.m_req.setAttribute("defaultTcMode", (Object)defaultTcMode);
            } else {
                this.m_req.setAttribute("tcClassName", (Object)className);
                if (className.equalsIgnoreCase(ListTargetChooser.class.getName())) {
                    this.m_req.setAttribute("tcListObjectName", (Object)tc.getChildTextTrim("list-object"));
                } else if (className.equalsIgnoreCase(StaticListTargetChooser.class.getName())) {
                    List children = tc.getChildren("target-objects");
                    String[] staticList = new String[children.size()];
                    int i = 0;
                    Iterator iter = children.iterator();
                    while (iter.hasNext()) {
                        Element element = (Element)iter.next();
                        staticList[i++] = element.getTextTrim();
                    }
                    String pack = eMFrameUtils.pack(staticList, this.m_context);
                    this.m_req.setAttribute("tcStaticList", (Object)pack);
                } else {
                    D.assrt(false, "Invalid TargetChooser classname.");
                }
            }
        }
        if (pluginParams.m_pluginType.equals("task") || pluginParams.m_pluginType.equals("create")) {
            this.m_req.setAttribute("rbsCollection", (Object)pluginParams.m_rbsCollectionName);
            this.m_req.setAttribute("rbsRole", (Object)pluginParams.m_roles);
            this.m_req.setAttribute("modifyTask", (Object)pluginParams.m_modifyTask);
            this.m_req.setAttribute("taskOrder", (Object)("" + pluginParams.m_taskOrder));
            this.m_req.setAttribute("addToCreateObject", (Object)("" + pluginParams.m_addToCreateObject));
        } else {
            this.outputChapterOptions(pluginParams.m_classDefinition.getName());
            if (pluginParams.m_pageOrder != -1) {
                this.m_req.setAttribute("pageOrder", (Object)("" + pluginParams.m_pageOrder));
            }
            this.m_req.setAttribute("isPublic", (Object)("" + pluginParams.m_isPublic));
            this.m_req.setAttribute("book", (Object)pluginParams.m_bookName);
            this.m_req.setAttribute("chapterId", (Object)pluginParams.m_chapterId);
            this.m_req.setAttribute("chapterSrc", (Object)pluginParams.m_chapterSrc);
        }
        this.stateShowStudio(pluginParams.m_client, pluginParams.m_classDefinition.getName(), pluginParams.m_objectTypeNameReg, pluginParams.m_pluginType, addaux, pluginParams.m_auxClasses, pluginParams.m_uihandlersMap, pluginParams.m_fieldNames);
    }

    private void stateShowStudio(String client, String objectTypeName, String[] objectTypeNameReg, String pluginType, boolean addaux, String[] auxClasses, Hashtable uihandlersMap, String[] copiedFieldNames) throws Exception {
        int attrIndex;
        if (pluginType.equals("delete")) {
            this.setUIPage("fw/TemplateBuilder_installTask.jsp");
            return;
        }
        this.m_req.setAttribute("client", (Object)client);
        this.m_req.setAttribute("objectTypeName", (Object)objectTypeName);
        this.m_req.setAttribute("objectTypeNameReg", (Object)eMFrameUtils.pack(objectTypeNameReg, this.m_context));
        this.m_req.setAttribute("pluginType", (Object)pluginType);
        AttributeInfo[] attributeInfos = null;
        attributeInfos = addaux ? CreateCustomPlugin.getAttributeInfos(this.m_schema, objectTypeName, auxClasses) : CreateCustomPlugin.getAttributeInfos(this.m_schema, objectTypeName, null);
        NDSClassDefinition classDefinition = (NDSClassDefinition)this.m_schema.getClassDefinition(objectTypeName);
        String[] superClasses = classDefinition.getSuperClasses();
        boolean isAux = this.m_context.getDirUtils().isAuxClass(objectTypeName);
        if (isAux && pluginType.equals("create")) {
            String title = eMFrameUtils.getLocalizedString("FwResources", "Error", this.m_context);
            String body = eMFrameUtils.getLocalizedString("FwResources", "TaskBuilder.NoCreateTaskForAuxClass", this.m_context);
            eMFrameUtils.setMessage("error", title, body, this.m_context);
            this.setUIPage("dev/GenErr.jsp");
            return;
        }
        ArrayList<String> allSelectedAuxClasses = new ArrayList<String>();
        if (classDefinition.isAuxiliary()) {
            allSelectedAuxClasses.add(objectTypeName);
        }
        if (auxClasses != null) {
            for (int i = 0; i < auxClasses.length; ++i) {
                allSelectedAuxClasses.add(auxClasses[i]);
            }
        }
        String[] array = allSelectedAuxClasses.toArray(new String[allSelectedAuxClasses.size()]);
        this.m_req.setAttribute("auxPack", (Object)eMFrameUtils.pack(array, this.m_context));
        ArrayList<String> list = new ArrayList<String>();
        list.add(objectTypeName);
        for (int i = 0; i < superClasses.length; ++i) {
            if (list.contains(superClasses[i])) continue;
            list.add(superClasses[i]);
        }
        if (addaux && auxClasses != null) {
            CreateCustomPlugin.addAuxClasses(this.m_schema, auxClasses, list);
        }
        String[] allClasses = list.toArray(new String[list.size()]);
        Locale locale = this.m_context.getLocale();
        Arrays.sort(attributeInfos, new AttributeInfoComparator(locale, allClasses));
        ArrayList requiredList = null;
        if (pluginType.equals("create") && copiedFieldNames == null) {
            requiredList = CreateCustomPlugin.getRequiredFields(this.m_schema, objectTypeName, auxClasses);
        }
        ArrayList<String> initialFields = new ArrayList<String>();
        if (requiredList != null) {
            initialFields.addAll(requiredList);
        }
        Hashtable<String, String> initialParams = new Hashtable<String, String>();
        if (copiedFieldNames != null && copiedFieldNames.length > 0) {
            for (int i = 0; i < copiedFieldNames.length; ++i) {
                String attributeName = copiedFieldNames[i];
                if (requiredList != null && requiredList.contains(attributeName)) continue;
                initialFields.add(attributeName);
            }
            Enumeration myenum = uihandlersMap.keys();
            while (myenum.hasMoreElements()) {
                String key = (String)myenum.nextElement();
                UiHandler uiHandler = (UiHandler)uihandlersMap.get(key);
                initialParams.put(FwUtils.getSafeName(key), uiHandler.getId());
            }
        }
        if (pluginType.equals("create")) {
            initialFields.add("createContext");
            if (uihandlersMap != null) {
                UiHandler uihandler = (UiHandler)uihandlersMap.get("createContext");
                initialParams.put("createContext", uihandler.getId());
            } else {
                initialParams.put("createContext", "fw.CreateContextTextfield");
            }
        }
        this.m_req.setAttribute("initialFields", initialParams);
        String[] fields = initialFields.toArray(new String[initialFields.size()]);
        this.m_req.setAttribute("initialFieldNames", (Object)fields);
        int startIndex = 0;
        ObjectEntry treeOE = RBSUtil.getTreeOE(this.m_context);
        AdminNamespace ns = treeOE.getAdminNamespace();
        ObjectType objectType = ns.getObjectType(treeOE, objectTypeName);
        if (pluginType.equals("create")) {
            startIndex = this.outputSpecialCreateControls(startIndex, objectType, uihandlersMap);
        } else if (pluginType.equals("page")) {
            startIndex = this.outputSpecialPageControls(startIndex);
        }
        startIndex = this.outputSpecialHTMLControls(startIndex, objectType, uihandlersMap);
        SortByNaming sortByNaming = new SortByNaming();
        for (attrIndex = 0; attrIndex < attributeInfos.length; ++attrIndex) {
            String prefix = "attributes." + (startIndex + attrIndex);
            AttributeInfo attributeInfo = attributeInfos[attrIndex];
            AttributeDefinition attr = attributeInfo.m_attributeDefinition;
            String fieldName = attr.getName();
            boolean fieldRequired = pluginType.equals("create") && requiredList != null && requiredList.contains(fieldName);
            this.m_req.setAttribute(prefix + ".name", (Object)fieldName);
            this.m_req.setAttribute(prefix + ".safeName", (Object)FwUtils.getSafeName(fieldName));
            this.m_req.setAttribute(prefix + ".image", (Object)this.m_context.getDirUtils().getObjectTypeImageName(attributeInfo.m_className));
            this.m_req.setAttribute(prefix + ".imageAlt", (Object)attributeInfo.m_className);
            this.m_req.setAttribute(prefix + ".required", (Object)("" + fieldRequired));
            Document[] docs = GlobalRegistry.getUiHandlerDocs(attr.getSyntax().getName(), fieldName, objectTypeName, superClasses, !attr.isSingleValued(), attr.isReadOnly(), client);
            if (attributeInfo.m_naming) {
                Arrays.sort(docs, sortByNaming);
            }
            if (docs != null) {
                String[] controlNames = new String[docs.length];
                String[] controlIds = new String[docs.length];
                String[] controlXmls = new String[docs.length];
                for (int controlIndex = 0; controlIndex < docs.length; ++controlIndex) {
                    Element root = docs[controlIndex].getRootElement();
                    String key = prefix + ".uihandler." + controlIndex;
                    this.m_req.setAttribute(key + ".name", (Object)eMFrameUtils.getDisplayName(docs[controlIndex], (MContext)this.m_context));
                    String id = root.getChildTextTrim("id");
                    this.m_req.setAttribute(key + ".id", (Object)id);
                    this.m_req.setAttribute(key + ".isRestricted", (Object)("" + (root.getChild("param") != null)));
                    UiHandler uihandler = null;
                    if (uihandlersMap != null) {
                        uihandler = (UiHandler)uihandlersMap.get(attr.getName());
                    }
                    if (uihandler != null && uihandler.getId().equals(id)) {
                        Element xmlToCopy = new Element("control");
                        ArrayList params = uihandler.getParams();
                        Iterator iter = params.iterator();
                        while (iter.hasNext()) {
                            Element param = (Element)iter.next();
                            xmlToCopy.addContent((Element)param.clone());
                        }
                        controlXmls[controlIndex] = TemplateBuilderUtils.getXmlOptionsString(docs[controlIndex], attr, fieldRequired, xmlToCopy, this.m_context);
                    } else {
                        controlXmls[controlIndex] = TemplateBuilderUtils.getXmlOptionsString(docs[controlIndex], attr, fieldRequired, this.m_context);
                    }
                    controlNames[controlIndex] = eMFrameUtils.getDisplayName(docs[controlIndex], (MContext)this.m_context);
                    controlIds[controlIndex] = root.getChildTextTrim("id");
                }
                this.m_req.setAttribute(prefix + ".uihandler.count", (Object)("" + docs.length));
                this.m_req.setAttribute(prefix + ".controlNames", (Object)eMFrameUtils.pack(controlNames, this.m_context));
                this.m_req.setAttribute(prefix + ".controlIds", (Object)eMFrameUtils.pack(controlIds, this.m_context));
                this.m_req.setAttribute(prefix + ".controlXmls", (Object)eMFrameUtils.pack(controlXmls, this.m_context));
                continue;
            }
            if (fieldRequired) {
                String title = eMFrameUtils.getLocalizedString("FwResources", "Studio.CannotCreateTask", this.m_context);
                String body = eMFrameUtils.getLocalizedString("FwResources", "Studio.noUihandlerForMandatoryAttr", this.m_context);
                throw new PluginException(title, body);
            }
            this.m_req.setAttribute(prefix + ".uihandler.count", (Object)"0");
        }
        this.m_req.setAttribute("attributes.count", (Object)("" + (startIndex + attrIndex)));
        this.setUIPage("fw/Studio_main.jsp");
    }

    private int outputSpecialPageControls(int startIndex) {
        String attrKey = "attributes." + startIndex + ".";
        String otherName = eMFrameUtils.getLocalizedString("FwResources", "Studio.otherName", this.m_context);
        this.m_req.setAttribute(attrKey + "name", (Object)otherName);
        this.m_req.setAttribute(attrKey + "safeName", (Object)"othername");
        this.m_req.setAttribute(attrKey + "image", (Object)"star.gif");
        this.m_req.setAttribute(attrKey + "imageAlt", (Object)otherName);
        this.m_req.setAttribute(attrKey + "required", (Object)"false");
        String displayName = eMFrameUtils.getLocalizedString("FwResources", "Studio.otherNameControl", this.m_context);
        String[] controlNames = new String[]{displayName};
        String[] controlIds = new String[]{"fw.OtherNameUiHandler"};
        String[] controlXmls = new String[]{"<control></control>"};
        this.m_req.setAttribute(attrKey + "controlNames", (Object)eMFrameUtils.pack(controlNames, this.m_context));
        this.m_req.setAttribute(attrKey + "controlIds", (Object)eMFrameUtils.pack(controlIds, this.m_context));
        this.m_req.setAttribute(attrKey + "controlXmls", (Object)eMFrameUtils.pack(controlXmls, this.m_context));
        return ++startIndex;
    }

    private static String combineXmlDescriptor(Hashtable uihandlersMap, String fieldName, String uihandlerId, String secondaryXml) {
        UiHandler uihandler = null;
        if (uihandlersMap != null) {
            uihandler = (UiHandler)uihandlersMap.get(fieldName);
        }
        if (uihandler != null && uihandler.getId().equals(uihandlerId)) {
            Element primaryXml = new Element("control");
            ArrayList params = uihandler.getParams();
            Iterator iter = params.iterator();
            while (iter.hasNext()) {
                Element param = (Element)iter.next();
                primaryXml.addContent((Element)param.clone());
            }
            Element resultXml = TemplateBuilderUtils.combineElements(primaryXml, secondaryXml);
            try {
                ByteArrayOutputStream targetStream = new ByteArrayOutputStream();
                new XMLOutputter().output(resultXml, (OutputStream)targetStream);
                return targetStream.toString();
            }
            catch (IOException e) {
                D.log(e);
                return "";
            }
        }
        return secondaryXml;
    }

    private int outputSpecialHTMLControls(int startIndex, ObjectType objectType, Hashtable uihandlersMap) {
        String attrKey = "attributes." + startIndex + ".";
        attrKey = "attributes." + startIndex + ".";
        this.m_req.setAttribute(attrKey + "name", (Object)eMFrameUtils.getLocalizedString("FwResources", "Studio.HTMLArea", this.m_context));
        this.m_req.setAttribute(attrKey + "safeName", (Object)"HTMLArea");
        this.m_req.setAttribute(attrKey + "image", (Object)"star.gif");
        this.m_req.setAttribute(attrKey + "imageAlt", (Object)eMFrameUtils.getLocalizedString("FwResources", "Studio.HTMLArea", this.m_context));
        this.m_req.setAttribute(attrKey + "required", (Object)"false");
        String displayName = eMFrameUtils.getLocalizedString("FwResources", "Studio.HTMLArea", this.m_context);
        String[] controlNames = new String[]{displayName};
        String[] controlIds = new String[]{"fw.HTMLAreaUiHandler"};
        StringBuffer valuesXml = new StringBuffer("");
        valuesXml.append("<param name=\"htmlarea\" ");
        valuesXml.append("type=\"htmlarea\" ");
        valuesXml.append("changeable=\"true\" ");
        valuesXml.append("required=\"false\" ");
        valuesXml.append("helpTextKey=\"Studio.params.html\" ");
        valuesXml.append("resourceFile=\"FwResources\" ");
        valuesXml.append("displayNameKey=\"Studio.HTML\" >");
        valuesXml.append("</param>");
        String[] controlXmls = new String[]{CreateCustomPlugin.combineXmlDescriptor(uihandlersMap, "HTMLArea", "fw.HTMLAreaUiHandler", "<control>" + valuesXml + "</control>")};
        this.m_req.setAttribute(attrKey + "controlNames", (Object)eMFrameUtils.pack(controlNames, this.m_context));
        this.m_req.setAttribute(attrKey + "controlIds", (Object)eMFrameUtils.pack(controlIds, this.m_context));
        this.m_req.setAttribute(attrKey + "controlXmls", (Object)eMFrameUtils.pack(controlXmls, this.m_context));
        return ++startIndex;
    }

    private int outputSpecialCreateControls(int startIndex, ObjectType objectType, Hashtable uihandlersMap) {
        String displayName;
        String attrKey = "attributes." + startIndex + ".";
        this.m_req.setAttribute(attrKey + "name", (Object)eMFrameUtils.getLocalizedString("FwResources", "Studio.Container", this.m_context));
        this.m_req.setAttribute(attrKey + "safeName", (Object)"createContext");
        this.m_req.setAttribute(attrKey + "image", (Object)"star.gif");
        this.m_req.setAttribute(attrKey + "imageAlt", (Object)eMFrameUtils.getLocalizedString("FwResources", "Studio.createContextDescription", this.m_context));
        this.m_req.setAttribute(attrKey + "required", (Object)"true");
        String name1 = eMFrameUtils.getLocalizedString("FwResources", "TextfieldUiHandlerName", this.m_context);
        String name2 = eMFrameUtils.getLocalizedString("FwResources", "MVRadioDisplayName", this.m_context);
        String name3 = eMFrameUtils.getLocalizedString("FwResources", "MVSelectDisplayName", this.m_context);
        String[] controlNames = new String[]{name1, name2, name3};
        String[] controlIds = new String[]{"fw.CreateContextTextfield", "fw.CreateContextRadio", "fw.CreateContextSelect"};
        String valuesXml = "<param name=\"values\" type=\"mvstring-container\" changeable=\"true\" required=\"true\" helpTextKey=\"Studio.params.values\" resourceFile=\"FwResources\" displayNameKey=\"Studio.values\"></param>";
        String noDefaultXml = "<param name=\"noDefault\" type=\"boolean\" changeable=\"true\" required=\"false\" helpTextKey=\"Studio.params.noDefault\" resourceFile=\"FwResources\" displayNameKey=\"Studio.noDefault\"><value>false</value></param>";
        String ccTextDefaultXml = "<param name=\"mandatory\" displayName=\"Mandatory\" type=\"boolean\" changeable=\"false\" helpTextKey=\"Studio.params.mandatory\" resourceFile=\"FwResources\" displayNameKey=\"TaskBuilder.Mandatory\"><value>true</value></param>";
        String[] controlXmls = new String[]{CreateCustomPlugin.combineXmlDescriptor(uihandlersMap, "createContext", "fw.CreateContextTextfield", "<control>" + ccTextDefaultXml + "</control>"), CreateCustomPlugin.combineXmlDescriptor(uihandlersMap, "createContext", "fw.CreateContextRadio", "<control>" + valuesXml + "</control>"), CreateCustomPlugin.combineXmlDescriptor(uihandlersMap, "createContext", "fw.CreateContextSelect", "<control>" + valuesXml + noDefaultXml + "</control>")};
        this.m_req.setAttribute(attrKey + "controlNames", (Object)eMFrameUtils.pack(controlNames, this.m_context));
        this.m_req.setAttribute(attrKey + "controlIds", (Object)eMFrameUtils.pack(controlIds, this.m_context));
        this.m_req.setAttribute(attrKey + "controlXmls", (Object)eMFrameUtils.pack(controlXmls, this.m_context));
        ++startIndex;
        if (DirUtils.isOfType(objectType, "ndsLoginProperties", true)) {
            attrKey = "attributes." + startIndex + ".";
            this.m_req.setAttribute(attrKey + "name", (Object)eMFrameUtils.getLocalizedString("FwResources", "Studio.SetPassword", this.m_context));
            this.m_req.setAttribute(attrKey + "safeName", (Object)"SetPassword");
            this.m_req.setAttribute(attrKey + "image", (Object)"star.gif");
            this.m_req.setAttribute(attrKey + "imageAlt", (Object)eMFrameUtils.getLocalizedString("FwResources", "Studio.setPassword", this.m_context));
            this.m_req.setAttribute(attrKey + "required", (Object)"false");
            displayName = eMFrameUtils.getLocalizedString("FwResources", "Studio.passwordField", this.m_context);
            controlNames = new String[]{displayName};
            controlIds = new String[]{"fw.SetPasswordUiHandler"};
            controlXmls = new String[]{"<control></control>"};
            this.m_req.setAttribute(attrKey + "controlNames", (Object)eMFrameUtils.pack(controlNames, this.m_context));
            this.m_req.setAttribute(attrKey + "controlIds", (Object)eMFrameUtils.pack(controlIds, this.m_context));
            this.m_req.setAttribute(attrKey + "controlXmls", (Object)eMFrameUtils.pack(controlXmls, this.m_context));
            ++startIndex;
        }
        if (DirUtils.isOfType(objectType, "User", true)) {
            displayName = eMFrameUtils.getLocalizedString("FwResources", "Studio.copyField", this.m_context);
            attrKey = "attributes." + startIndex + ".";
            this.m_req.setAttribute(attrKey + "name", (Object)displayName);
            this.m_req.setAttribute(attrKey + "safeName", (Object)"copyFrom");
            this.m_req.setAttribute(attrKey + "image", (Object)"star.gif");
            this.m_req.setAttribute(attrKey + "imageAlt", (Object)displayName);
            this.m_req.setAttribute(attrKey + "required", (Object)"false");
            controlNames = new String[]{displayName};
            controlIds = new String[]{"fw.CloneObjectUiHandler"};
            valuesXml = "<param name=\"values\" type=\"mvstring\" changeable=\"true\" required=\"false\" helpTextKey=\"Studio.params.values\" resourceFile=\"FwResources\" displayNameKey=\"Studio.values\"></param>";
            valuesXml = valuesXml + noDefaultXml;
            valuesXml = valuesXml + "<param name=\"hidden\" type=\"boolean\" changeable=\"true\" required=\"false\" helpTextKey=\"Studio.params.hidden\" resourceFile=\"FwResources\" displayNameKey=\"Studio.hideField\"></param>";
            valuesXml = valuesXml + "<param name=\"mandatory\" type=\"boolean\" changeable=\"true\" helpTextKey=\"Studio.params.mandatory\" resourceFile=\"FwResources\" displayNameKey=\"TaskBuilder.Mandatory\"></param>";
            valuesXml = valuesXml + "<param name=\"fieldSize\" type=\"integer\" changeable=\"true\" required=\"false\" resourceFile=\"FwResources\" helpTextKey=\"Studio.params.fieldSize\" displayNameKey=\"Studio.fieldSize\"><value></value></param>";
            controlXmls = new String[]{CreateCustomPlugin.combineXmlDescriptor(uihandlersMap, "copyFrom", "fw.CloneObjectUiHandler", "<control>" + valuesXml + "</control>")};
            this.m_req.setAttribute(attrKey + "controlNames", (Object)eMFrameUtils.pack(controlNames, this.m_context));
            this.m_req.setAttribute(attrKey + "controlIds", (Object)eMFrameUtils.pack(controlIds, this.m_context));
            this.m_req.setAttribute(attrKey + "controlXmls", (Object)eMFrameUtils.pack(controlXmls, this.m_context));
            ++startIndex;
        }
        return startIndex;
    }

    private static void addAuxClasses(NDSSchemaDefinition schema, String[] auxClasses, ArrayList list) throws NamespaceException {
        for (int i = 0; i < auxClasses.length; ++i) {
            if (!list.contains(auxClasses[i])) {
                list.add(auxClasses[i]);
            }
            NDSClassDefinition classDef = (NDSClassDefinition)schema.getClassDefinition(auxClasses[i]);
            String[] supers = classDef.getSuperClasses();
            for (int j = 0; j < supers.length; ++j) {
                if (list.contains(supers[j])) continue;
                list.add(supers[j]);
            }
        }
    }

    private void outputChapterOptions(String className) throws Exception {
        Chapter[] chapters = FwUtils.getChapterIds(this.m_context, className);
        Arrays.sort(chapters, new Comparator(){

            public int compare(Object o1, Object o2) {
                Chapter c1 = (Chapter)o1;
                Chapter c2 = (Chapter)o2;
                return c1.getName(CreateCustomPlugin.this.m_context).compareToIgnoreCase(c2.getName(CreateCustomPlugin.this.m_context));
            }
        });
        if (chapters != null) {
            for (int i = 0; i < chapters.length; ++i) {
                this.m_req.setAttribute("chapters." + i + ".name", (Object)chapters[i].getName(this.m_context));
                this.m_req.setAttribute("chapters." + i + ".id", (Object)chapters[i].getId());
            }
            this.m_req.setAttribute("chapters.length", (Object)("" + chapters.length));
        } else {
            this.m_req.setAttribute("chapters.length", (Object)"0");
        }
    }

    private void stateInstallDeleteTask() throws IOException, PluginException, JDOMException {
        String xmlDirPath;
        File xmlDirectory;
        String rbsCollectionName = this.m_req.getParameter("rbsCollection");
        String taskName = this.m_req.getParameter("taskName");
        String fullRoleName = this.m_req.getParameter("role");
        String client = this.m_req.getParameter("client");
        boolean mooEnabled = this.m_req.getParameter("mooEnabled") != null;
        String pluginType = this.m_req.getParameter("pluginType");
        TemplateBuilderUtils.validateContainment(rbsCollectionName, taskName, "rbsTask2", this.m_context);
        CustomNpmFile npm = new CustomNpmFile(this.m_context);
        String versionString = npm.getNextVersion().toString();
        String dstTemplateName = null;
        File dstFile = null;
        String objectTypeName = this.m_req.getParameter("objectTypeName");
        Document document = TemplateBuilderUtils.createXmlForDeleteTask(objectTypeName, versionString);
        String modulePath = iManager.getAbsModulesPath() + "/" + CUSTOM_MODULE;
        File moduleDirectory = new File(modulePath);
        if (!moduleDirectory.exists()) {
            moduleDirectory.mkdir();
        }
        if (!(xmlDirectory = new File(xmlDirPath = modulePath + "/install")).exists()) {
            xmlDirectory.mkdir();
        }
        NPSCompatUtils.refreshResourceFileMap(CUSTOM_MODULE);
        Element root = document.getRootElement();
        Element module = root.getChild("module");
        Element moduleId = module.getChild("id");
        moduleId.setText(CUSTOM_MODULE);
        Element task = root.getChild("task");
        task.removeChild("display-name-key");
        Element taskId = task.getChild("id");
        taskId.setText("custom." + taskName);
        Element merge = task.getChild("merge-template");
        if (pluginType.equals("delete")) {
            merge.setText("fw.DelObject");
        } else {
            merge.setText("custom." + dstTemplateName);
        }
        if (fullRoleName != null && fullRoleName.length() > 0) {
            D.assrt(fullRoleName.toLowerCase().endsWith(rbsCollectionName.toLowerCase()), "TaskBuilder: The role must be in the collection");
            String roleName = fullRoleName.substring(0, fullRoleName.length() - rbsCollectionName.length() - 1);
            Element role = task.getChild("role-assignment");
            if (role == null) {
                role = new Element("role-assignment");
                task.addContent(role);
            }
            role.setText(roleName);
        } else {
            task.removeChild("role-assignment");
        }
        if (mooEnabled) {
            Element param = new Element("url-param");
            param.addContent(TemplateBuilderUtils.newElement("param-key", "TC.multipleObjectEnabled"));
            param.addContent(TemplateBuilderUtils.newElement("param-value", "true"));
            task.addContent(param);
            param = new Element("url-param");
            param.addContent(TemplateBuilderUtils.newElement("param-key", "TC.advancedSelectionEnabled"));
            param.addContent(TemplateBuilderUtils.newElement("param-value", "true"));
            task.addContent(param);
        }
        ObjectEntry treeOE = RBSUtil.getTreeOE(this.m_context);
        AdminNamespace ns = treeOE.getAdminNamespace();
        String authName = "eDir";
        try {
            if (ns.isSupported("NVDS")) {
                authName = "NVDS";
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        ModuleClassObject moduleClassObject = null;
        XMLFileReader xmlFileReader = new XMLFileReader(ns);
        try {
            moduleClassObject = xmlFileReader.readFile(document, authName);
        }
        catch (JDOMException e) {
            D.log(e);
            this.m_req.setAttribute("GeneralMsg.MsgTitle", (Object)eMFrameUtils.getLocalizedString("FwResources", "eMFrameConsts.READ_XML_FILE_FAILURE", this.m_context));
            this.m_req.setAttribute("GeneralMsg.MsgBody", (Object)e.getMessage());
            this.setUIPage("dev/GenErr.jsp");
            return;
        }
        RBSObjectInstaller installer = new RBSObjectInstaller(treeOE, moduleClassObject);
        try {
            String dynamicGroupSearchType = FwUtils.getDynamicSearchType(this.m_context);
            installer.install(rbsCollectionName, dynamicGroupSearchType);
            this.m_req.setAttribute("GeneralMsg.MsgTitle", (Object)eMFrameUtils.getLocalizedString("FwResources", "TaskBuilder.InstallTaskSuccess", this.m_context));
            this.m_req.setAttribute("GeneralMsg.MsgBody", (Object)eMFrameUtils.getLocalizedString("FwResources", "TaskBuilder.InstallTaskSuccessLong", this.m_context));
        }
        catch (Exception e) {
            D.log(e);
            String format = eMFrameUtils.getLocalizedString("FwResources", "eMFrameConsts.INSTALL_PACKAGE_FAILURE", this.m_context);
            String title = eMFrameUtils.formatMessage(format, new Object[]{taskId});
            this.m_req.setAttribute("GeneralMsg.MsgTitle", (Object)title);
            this.m_req.setAttribute("GeneralMsg.MsgBody", (Object)eMFrameUtils.getExceptionMessage(e, this.m_context));
            this.setUIPage("dev/GenErr.jsp");
            return;
        }
        String version = TemplateBuilderUtils.outputNPM(document, this.m_context, dstFile, client, false);
        File xmlFile = new File(xmlDirectory, "install.xml");
        Document taskDoc = new Document((Element)task.clone());
        TemplateBuilderUtils.removePluginXmlFromFile(xmlFile, taskName);
        TemplateBuilderUtils.addInstallXml(xmlFile, (Element)task.clone(), version);
        Registry.getRegistry("Install").addOrReplaceNode(CUSTOM_MODULE, taskDoc, xmlFile, true);
        this.m_context.addToHistory("rbsRole2", fullRoleName);
        this.m_context.addToHistory("rbsTask2", taskName + "." + CUSTOM_MODULE + "." + rbsCollectionName);
    }

    public static String findBestNamingAttribute(SchemaDefinition schema, String objectTypeName) throws NamespaceException {
        AttributeDefinition[] naming = schema.getNamingAttributes(objectTypeName);
        if (objectTypeName.equalsIgnoreCase("Locality")) {
            return "L";
        }
        for (int i = 0; i < naming.length; ++i) {
            if (!naming[i].getName().equalsIgnoreCase("CN")) continue;
            return naming[i].getName();
        }
        return naming[0].getName();
    }

    private static ArrayList getRequiredFields(NDSSchemaDefinition schema, String objectTypeName, String[] auxClasses) throws NamespaceException {
        int i;
        AttributeDefinition[] mandatory = schema.getMandatoryAttributes(objectTypeName);
        ArrayList<String> requiredList = new ArrayList<String>();
        String namingAttribute = CreateCustomPlugin.findBestNamingAttribute((SchemaDefinition)schema, objectTypeName);
        requiredList.add(namingAttribute);
        for (i = 0; i < mandatory.length; ++i) {
            String name = mandatory[i].getName();
            if (name.equals(namingAttribute) || name.equalsIgnoreCase("Object Class")) continue;
            requiredList.add(name);
        }
        if (auxClasses != null) {
            for (i = 0; i < auxClasses.length; ++i) {
                mandatory = schema.getMandatoryAttributes(auxClasses[i]);
                for (int j = 0; j < mandatory.length; ++j) {
                    String name = mandatory[j].getName();
                    if (name.equalsIgnoreCase("Object Class") || requiredList.contains(name)) continue;
                    requiredList.add(name);
                }
                try {
                    String auxNamingAttribute = CreateCustomPlugin.findBestNamingAttribute((SchemaDefinition)schema, auxClasses[i]);
                    if (requiredList.contains(auxNamingAttribute)) continue;
                    requiredList.add(auxNamingAttribute);
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        return requiredList;
    }

    private static AttributeInfo[] getAttributeInfos(NDSSchemaDefinition schema, String className, String[] auxClasses) throws NamespaceException {
        int i;
        ArrayList list = new ArrayList();
        ClassDefinition classDefinition = schema.getRawClassDefinition(className);
        ClassDefinition expandedClassDefinition = schema.getClassDefinition(className);
        CreateCustomPlugin.getAttributeInfosImpl(classDefinition, list);
        String[] superclasses = expandedClassDefinition.getSuperClasses();
        for (i = 0; i < superclasses.length; ++i) {
            ClassDefinition parent = schema.getRawClassDefinition(superclasses[i]);
            CreateCustomPlugin.getAttributeInfosImpl(parent, list);
        }
        if (auxClasses != null) {
            for (i = 0; i < auxClasses.length; ++i) {
                CreateCustomPlugin.getAttributeInfosImpl(schema.getClassDefinition(auxClasses[i]), list);
            }
        }
        if (list.size() > 0) {
            AttributeDefinition[] attributeDefinitions = schema.getNamingAttributes(className);
            List<AttributeDefinition> namingList = Arrays.asList(attributeDefinitions);
            Iterator iter = list.iterator();
            while (iter.hasNext()) {
                AttributeInfo info = (AttributeInfo)iter.next();
                info.m_naming = namingList.contains(info.m_attributeDefinition);
            }
            return list.toArray(new AttributeInfo[list.size()]);
        }
        return null;
    }

    private static void getAttributeInfosImpl(ClassDefinition classDefinition, ArrayList list) {
        AttributeInfo info;
        int i;
        String className = classDefinition.getName();
        AttributeDefinition[] ad = classDefinition.getMandatoryAttributes();
        for (i = 0; i < ad.length; ++i) {
            info = new AttributeInfo(ad[i], className, false, true);
            if (list.contains(info)) continue;
            list.add(info);
        }
        ad = classDefinition.getOptionalAttributes();
        for (i = 0; i < ad.length; ++i) {
            if (ad[i].isHidden() || blockedAttributes.contains(ad[i].getName()) || list.contains(info = new AttributeInfo(ad[i], className, false, false))) continue;
            list.add(info);
        }
    }
}

