/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.fw.studio;

import com.novell.admin.common.exceptions.SPIException;
import com.novell.admin.common.exceptions.UniqueSPIException;
import com.novell.admin.ns.AdminNamespace;
import com.novell.admin.ns.AttributeDefinition;
import com.novell.admin.ns.ClassDefinition;
import com.novell.admin.ns.NamespaceException;
import com.novell.admin.ns.ObjectAttribute;
import com.novell.admin.ns.SchemaDefinition;
import com.novell.admin.ns.ValueComponent;
import com.novell.admin.ns.nds.NDSClassDefinition;
import com.novell.admin.ns.nds.NDSSchemaDefinition;
import com.novell.application.console.snapin.ObjectEntry;
import com.novell.emframe.dev.Chapter;
import com.novell.emframe.dev.D;
import com.novell.emframe.dev.DirUtils;
import com.novell.emframe.dev.GlobalRegistry;
import com.novell.emframe.dev.MContext;
import com.novell.emframe.dev.PluginException;
import com.novell.emframe.dev.UiHandler;
import com.novell.emframe.dev.UiHandlerContext;
import com.novell.emframe.dev.authenticator.AuthNotAuthenticatedException;
import com.novell.emframe.dev.eDirAccessServiceException;
import com.novell.emframe.dev.eMFrameUtils;
import com.novell.emframe.fw.CreatorWizardTask;
import com.novell.emframe.fw.CustomNpmFile;
import com.novell.emframe.fw.FwTaskContext;
import com.novell.emframe.fw.FwUtils;
import com.novell.emframe.fw.ListTargetChooser;
import com.novell.emframe.fw.RBSUtil;
import com.novell.emframe.fw.Registry;
import com.novell.emframe.fw.StaticListTargetChooser;
import com.novell.emframe.fw.authenticator.FwAuthUtils;
import com.novell.emframe.fw.iManager;
import com.novell.emframe.fw.npsCompat.NPSCompatUtils;
import com.novell.emframe.fw.studio.TemplateBuilder;
import com.novell.emframe.fw.studio.TemplateBuilderUtils;
import com.novell.emframe.fw.uihandlers.HTMLAreaUiHandler;
import com.novell.emframe.fw.uihandlers.OtherNameUihandler;
import com.novell.emframe.fw.uihandlers.SetPasswordUiHandler;
import com.novell.emframe.fw.util.Base64;
import com.novell.emframe.fw.util.RBSObjectInstaller;
import com.novell.emframe.fw.util.StudioUtils;
import com.novell.emframe.fw.xmlinfos.ModuleClassObject;
import com.novell.emframe.fw.xmlinfos.XMLFileReader;
import com.novell.nps.authentication.PortalDirectoryException;
import com.novell.rbs.RBSBook;
import com.novell.rbs.RBSException;
import com.novell.rbs.RBSRole;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public class PluginParams {
    static final String TEMP_MODULE = "temp";
    static final String CUSTOM_MODULE = "custom";
    Hashtable m_uihandlersMap = null;
    String m_client = null;
    boolean m_labelAboveControl = true;
    String m_pluginType = null;
    ClassDefinition m_classDefinition = null;
    MContext m_context = null;
    String m_pluginName = null;
    boolean m_mooEnabled = true;
    String[] m_auxClasses = null;
    String[] m_objectTypeNameReg = null;
    String[] m_fieldNames = null;
    String m_displayName = null;
    String m_rbsCollectionName = null;
    String[] m_roles = null;
    Element m_customTargetChooser = null;
    String m_bookName = null;
    String m_chapterDisplayNameKey = null;
    String m_chapterId = null;
    String m_chapterResourceFile = null;
    String m_chapterSrc = null;
    boolean m_isPublic = false;
    int m_pageOrder = -1;
    int m_taskOrder = 500;
    boolean m_addToCreateObject = false;
    String m_modifyTask = null;
    private String m_jspFilename = null;
    String m_jspFilenameFromRbsTask = null;

    private PluginParams(Hashtable uihandlersMap, String pluginType, String pluginName, String client, boolean labelAboveControl, ClassDefinition classDefinition, boolean mooEnabled, String[] auxClasses, String[] objectTypeNameReg, String[] fieldNames, String displayName, boolean addToCreateObject, String rbsCollection, String[] roles, String modifyTask, Element customTargetChooser, String taskOrder, MContext context) {
        this.m_uihandlersMap = uihandlersMap;
        this.m_client = client;
        this.m_labelAboveControl = labelAboveControl;
        this.m_pluginType = pluginType;
        this.m_classDefinition = classDefinition;
        this.m_context = context;
        this.m_pluginName = pluginName;
        this.m_mooEnabled = mooEnabled;
        this.m_auxClasses = auxClasses;
        this.m_objectTypeNameReg = objectTypeNameReg;
        this.m_fieldNames = fieldNames;
        this.m_displayName = displayName;
        this.m_addToCreateObject = addToCreateObject;
        this.m_modifyTask = modifyTask;
        this.m_customTargetChooser = customTargetChooser;
        this.m_rbsCollectionName = rbsCollection;
        this.m_roles = roles;
        if (taskOrder != null && !taskOrder.equals("")) {
            this.m_taskOrder = Integer.parseInt(taskOrder);
        }
        if (this.m_objectTypeNameReg != null && this.m_objectTypeNameReg.length == 1 && (this.m_objectTypeNameReg[0] == null || this.m_objectTypeNameReg[0].equals(""))) {
            this.m_objectTypeNameReg[0] = classDefinition.getName();
        } else if (this.m_objectTypeNameReg == null || this.m_objectTypeNameReg.length == 0) {
            this.m_objectTypeNameReg = new String[]{classDefinition.getName()};
        }
    }

    private PluginParams(Hashtable uihandlersMap, String pluginType, String pluginName, String client, boolean labelAboveControl, ClassDefinition classDefinition, boolean mooEnabled, String[] auxClasses, String[] objectTypeNameReg, String[] fieldNames, String displayName, String bookName, String chapterDisplayNameKey, String chapterId, String chapterResourceFile, boolean isPublic, String chapterSrc, int pageOrder, MContext context) {
        this.m_uihandlersMap = uihandlersMap;
        this.m_client = client;
        this.m_labelAboveControl = labelAboveControl;
        this.m_pluginType = pluginType;
        this.m_classDefinition = classDefinition;
        this.m_context = context;
        this.m_pluginName = pluginName;
        this.m_mooEnabled = mooEnabled;
        this.m_auxClasses = auxClasses;
        this.m_objectTypeNameReg = objectTypeNameReg;
        this.m_fieldNames = fieldNames;
        this.m_displayName = displayName;
        this.m_bookName = bookName;
        this.m_chapterDisplayNameKey = chapterDisplayNameKey;
        this.m_chapterId = chapterId;
        this.m_chapterResourceFile = chapterResourceFile;
        this.m_isPublic = isPublic;
        this.m_chapterSrc = chapterSrc;
        this.m_pageOrder = pageOrder;
        if (this.m_objectTypeNameReg != null && this.m_objectTypeNameReg.length == 1 && this.m_objectTypeNameReg[0].equals("")) {
            this.m_objectTypeNameReg[0] = classDefinition.getName();
        }
    }

    public static PluginParams readFromRequest(MContext context) throws PluginException {
        boolean labelAboveControl;
        HttpServletRequest req = context.getRequest();
        String pluginType = req.getParameter("pluginType");
        String objectTypeName = req.getParameter("objectTypeName");
        String[] objectTypeNameReg = null;
        objectTypeNameReg = eMFrameUtils.unpack(req.getParameter("objectTypeNameReg"), context);
        if (objectTypeNameReg == null || objectTypeNameReg.length == 0) {
            objectTypeNameReg = new String[]{objectTypeName};
        }
        String[] attributeNames = eMFrameUtils.unpack(req.getParameter("attributeNames"), context);
        String[] attributeHandlerIds = eMFrameUtils.unpack(req.getParameter("attributeHandlerIds"), context);
        String[] attributeHandlerXmls = eMFrameUtils.unpack(req.getParameter("attributeHandlerXmls"), context);
        String[] fieldNames = new String[attributeNames.length];
        String client = req.getParameter("client");
        String pluginName = req.getParameter("pluginName");
        String mooEnabledString = req.getParameter("mooEnabled");
        String labelAboveControlString = req.getParameter("labelAboveControl");
        boolean mooEnabled = mooEnabledString != null && mooEnabledString.equalsIgnoreCase("true");
        boolean bl = labelAboveControl = labelAboveControlString != null && labelAboveControlString.equalsIgnoreCase("true");
        if (attributeNames == null || attributeNames.length < 1) {
            String body = eMFrameUtils.getLocalizedString("FwResources", "TaskBuilder.SelectAnAttribute", context);
            String header = eMFrameUtils.getLocalizedString("FwResources", "Error", context);
            throw new PluginException(body, header);
        }
        NDSSchemaDefinition schema = null;
        NDSClassDefinition classDefinition = null;
        try {
            ObjectEntry treeOE = RBSUtil.getTreeOE(context);
            AdminNamespace ns = treeOE.getAdminNamespace();
            schema = (NDSSchemaDefinition)ns.getSchemaDefinition(treeOE);
            classDefinition = (NDSClassDefinition)schema.getClassDefinition(objectTypeName);
        }
        catch (Exception e) {
            D.log(e);
            throw new PluginException(e);
        }
        SAXBuilder saxBuilder = new SAXBuilder(false);
        Hashtable<String, UiHandler> uihandlers = new Hashtable<String, UiHandler>();
        DirUtils dirUtils = context.getDirUtils();
        for (int index = 0; index < attributeNames.length; ++index) {
            String safeAttributeName;
            String realAttributeName = safeAttributeName = attributeNames[index];
            String id = attributeHandlerIds[index];
            UiHandler uihandler = null;
            try {
                AttributeDefinition attrDefinition = null;
                Document doc = GlobalRegistry.getPluginDocument(id);
                D.assrt(doc != null, "PluginBuilder: no uihandler doc for id (" + id + ")");
                String name = doc.getRootElement().getName();
                if (!name.equals("ui-handler")) {
                    attrDefinition = schema.getAttributeDefinition(dirUtils.getRealName(safeAttributeName));
                    realAttributeName = dirUtils.getRealName(safeAttributeName);
                }
                fieldNames[index] = realAttributeName;
                String uihandlerClassName = eMFrameUtils.getClassName(doc);
                Class<?> c = Class.forName(uihandlerClassName);
                uihandler = (UiHandler)c.newInstance();
                Document paramDoc = saxBuilder.build((Reader)new StringReader(attributeHandlerXmls[index]));
                Element root = paramDoc.getRootElement();
                List list = root.getChildren("param");
                boolean forceReadOnly = false;
                boolean forceSingleValued = false;
                boolean forceMandatory = false;
                Iterator iter = list.iterator();
                while (iter.hasNext()) {
                    boolean value;
                    Element element = (Element)iter.next();
                    uihandler.processParam(element);
                    String textValue = element.getChildTextTrim("value");
                    boolean bl2 = value = textValue != null && textValue.equals("true");
                    if (element.getAttributeValue("name").equals("readOnly")) {
                        forceReadOnly = value;
                        continue;
                    }
                    if (element.getAttributeValue("name").equals("singleValued")) {
                        forceSingleValued = value;
                        continue;
                    }
                    if (!element.getAttributeValue("name").equals("mandatory")) continue;
                    forceMandatory = value;
                }
                if (forceReadOnly && forceMandatory) {
                    String header = eMFrameUtils.getLocalizedString("FwResources", "Error", context);
                    String body = eMFrameUtils.getLocalizedString("FwResources", "Studio.noMandatoryAndReadOnly", context);
                    throw new PluginException(header, body);
                }
                UiHandlerContext uiHandlerContext = new UiHandlerContext(attrDefinition, client, doc.getRootElement().getChildTextTrim("id"), forceReadOnly, forceSingleValued, forceMandatory);
                uihandler.init(uiHandlerContext);
            }
            catch (PluginException e) {
                throw e;
            }
            catch (Exception e) {
                D.log(e);
            }
            if (uihandler == null) continue;
            uihandlers.put(realAttributeName, uihandler);
        }
        D.assrt(uihandlers.size() > 0, "No valid attributes");
        String[] auxClasses = eMFrameUtils.unpack(req.getParameter("auxPack"), context);
        String displayName = req.getParameter("displayName");
        Element customTc = null;
        String tcClassName = req.getParameter("tcClassName");
        if (tcClassName != null && tcClassName.length() > 0 && !tcClassName.equalsIgnoreCase("none")) {
            String className = req.getParameter("tcClassName");
            customTc = new Element("custom-target-chooser");
            customTc.addContent(new Element("class-name").setText(className));
            if (className.equalsIgnoreCase(ListTargetChooser.class.getName())) {
                String listObject = req.getParameter("tcListObjectName");
                customTc.addContent(new Element("list-object").setText(listObject));
            } else if (className.equalsIgnoreCase(StaticListTargetChooser.class.getName())) {
                String tcStaticList = req.getParameter("tcStaticList");
                String[] memebers = eMFrameUtils.unpack(tcStaticList, context);
                for (int i = 0; i < memebers.length; ++i) {
                    customTc.addContent(new Element("target-objects").setText(memebers[i]));
                }
            } else {
                D.assrt(false, "Invalid TargetChooser classname.");
            }
        } else {
            String defaultTcMode = req.getParameter("defaultTcMode");
            if (defaultTcMode == null) {
                defaultTcMode = "simple";
            }
            customTc = new Element("url-param");
            PluginParams.addSimpleChild(customTc, "param-key", "TC.mode");
            PluginParams.addSimpleChild(customTc, "param-value", defaultTcMode);
        }
        if (pluginType.equals("task")) {
            String[] roles = eMFrameUtils.unpack(req.getParameter("roleName_packedValues"), context);
            String taskOrder = req.getParameter("taskOrder");
            return new PluginParams(uihandlers, pluginType, pluginName, client, labelAboveControl, (ClassDefinition)classDefinition, mooEnabled, auxClasses, objectTypeNameReg, fieldNames, displayName, false, req.getParameter("rbsCollection"), roles, null, customTc, taskOrder, context);
        }
        if (pluginType.equals("page")) {
            String chapterSrc;
            String book = req.getParameter("book");
            String chapterDisplayNameKey = null;
            String chapterId = null;
            String chapterResourceFile = null;
            boolean isPublic = req.getParameter("public") != null;
            int pageOrder = -1;
            String sPageOrder = req.getParameter("pageOrder");
            if (sPageOrder != null && sPageOrder.length() > 0) {
                try {
                    pageOrder = Integer.parseInt(sPageOrder);
                }
                catch (NumberFormatException e) {
                    D.log(e);
                }
            }
            if ((chapterSrc = req.getParameter("chapterSrc")).equals("existing")) {
                int chapterIndex = Integer.parseInt(req.getParameter("chapterName1"));
                Chapter[] chapters = null;
                try {
                    chapters = FwUtils.getChapterIds(context, objectTypeNameReg[0]);
                    chapters = PluginParams.getChaptersSortedByName(chapters);
                    chapterId = chapters[chapterIndex].getId();
                    chapterDisplayNameKey = chapters[chapterIndex].getDisplayNameKey();
                    chapterResourceFile = chapters[chapterIndex].getResourcePropertiesFile();
                }
                catch (Exception e) {
                    throw new PluginException(e);
                }
            } else {
                chapterId = chapterDisplayNameKey = req.getParameter("chapterName2");
                chapterResourceFile = "";
            }
            return new PluginParams(uihandlers, pluginType, pluginName, client, labelAboveControl, (ClassDefinition)classDefinition, mooEnabled, auxClasses, objectTypeNameReg, fieldNames, displayName, book, chapterDisplayNameKey, chapterId, chapterResourceFile, isPublic, chapterSrc, pageOrder, context);
        }
        if (pluginType.equals("create")) {
            String modifyTask = req.getParameter("modifyTask");
            String addToCreateObjectParam = req.getParameter("addToCreateObject");
            boolean addToCreateObject = addToCreateObjectParam != null && addToCreateObjectParam.equals("true");
            String rolesParam = req.getParameter("roleName_packedValues");
            String[] roles = null;
            if (rolesParam != null) {
                roles = eMFrameUtils.unpack(rolesParam, context);
            }
            String taskOrder = req.getParameter("taskOrder");
            return new PluginParams(uihandlers, pluginType, pluginName, client, labelAboveControl, (ClassDefinition)classDefinition, mooEnabled, auxClasses, objectTypeNameReg, fieldNames, displayName, addToCreateObject, req.getParameter("rbsCollection"), roles, modifyTask, null, taskOrder, context);
        }
        return null;
    }

    String buildPreview() throws IOException {
        UiHandler[] uihandlers = new UiHandler[this.m_fieldNames.length];
        for (int i = 0; i < this.m_fieldNames.length; ++i) {
            uihandlers[i] = (UiHandler)this.m_uihandlersMap.get(this.m_fieldNames[i]);
        }
        boolean onExitOnSubmit = !this.m_pluginType.equals("page");
        String templateFileName = TemplateBuilder.createTemplate(this.m_context, uihandlers, this.m_client, this.m_labelAboveControl, this.getSkeletonFilename(), this.m_auxClasses, false, TEMP_MODULE, null, onExitOnSubmit);
        NPSCompatUtils.refreshResourceFileMap(TEMP_MODULE);
        return templateFileName;
    }

    private String getSkeletonFilename() {
        if (this.m_pluginType.equalsIgnoreCase("page")) {
            return "TemplateBuilder_skeletonPage.jsp";
        }
        if (this.m_pluginType.equalsIgnoreCase("task")) {
            return "TemplateBuilder_skeleton.jsp";
        }
        if (this.m_pluginType.equalsIgnoreCase("create")) {
            return "TemplateBuilder_skeletonCreate.jsp";
        }
        D.assrt(false, "Invalid plugin type");
        return null;
    }

    Document createXmlFile(String templateFileName, String module) throws IOException {
        Document document = null;
        Collection collection = this.m_uihandlersMap.values();
        ArrayList<String> attributeNamesList = new ArrayList<String>();
        boolean otherName = false;
        boolean setPassword = false;
        Iterator iter = collection.iterator();
        while (iter.hasNext()) {
            UiHandler uiHandler = (UiHandler)iter.next();
            if (uiHandler.isEDirAttribute()) {
                attributeNamesList.add(uiHandler.getAttributeName());
            }
            if (uiHandler instanceof SetPasswordUiHandler) {
                setPassword = true;
                continue;
            }
            if (uiHandler instanceof OtherNameUihandler) {
                otherName = true;
                continue;
            }
            if (!(uiHandler instanceof HTMLAreaUiHandler)) continue;
        }
        String[] attributeNames = attributeNamesList.toArray(new String[attributeNamesList.size()]);
        if (this.m_pluginType.equalsIgnoreCase("page")) {
            document = new Document(this.createXmlForPage(attributeNames, templateFileName, otherName, module));
        } else if (this.m_pluginType.equalsIgnoreCase("task") || this.m_pluginType.equalsIgnoreCase("create")) {
            document = new Document(this.createXmlForTask(attributeNames, setPassword, templateFileName));
        }
        return document;
    }

    boolean installTask(Document document, boolean isModify) throws IOException, NamespaceException, PluginException, JDOMException, PortalDirectoryException {
        if (!isModify) {
            TemplateBuilderUtils.validateContainment(this.m_rbsCollectionName, this.m_pluginName, "rbsTask2", this.m_context);
        }
        ObjectEntry treeOE = RBSUtil.getTreeOE(this.m_context);
        AdminNamespace ns = treeOE.getAdminNamespace();
        for (int i = 0; i < this.m_roles.length; ++i) {
            String pattern;
            String title;
            try {
                ObjectEntry roleObjectEntry = ns.getObjectEntry(treeOE, this.m_roles[i]);
                RBSRole role = new RBSRole(roleObjectEntry);
                ArrayList errors = RBSUtil.checkMemberScopeRightsForRole(this.m_context, role);
                if (errors == null) continue;
                String title2 = eMFrameUtils.getLocalizedString("FwResources", "Error", this.m_context);
                String pattern2 = eMFrameUtils.getLocalizedString("FwResources", "Studio.insufficientRightsToRole", this.m_context);
                String body = eMFrameUtils.formatMessage(pattern2, new Object[]{this.m_roles[i]});
                throw new PluginException(title2, body);
            }
            catch (SPIException e) {
                D.log(e);
                title = eMFrameUtils.getLocalizedString("FwResources", "Error", this.m_context);
                pattern = eMFrameUtils.getLocalizedString("FwResources", "Studio.insufficientRightsToRole", this.m_context);
                String body = eMFrameUtils.formatMessage(pattern, new Object[]{this.m_roles[i]});
                throw new PluginException(title, body);
            }
            catch (RBSException e) {
                D.log(e);
                title = eMFrameUtils.getLocalizedString("FwResources", "Error", this.m_context);
                pattern = eMFrameUtils.getLocalizedString("FwResources", "Studio.insufficientRightsToRole", this.m_context);
                String body = eMFrameUtils.formatMessage(pattern, new Object[]{this.m_roles[i]});
                throw new PluginException(title, body);
            }
        }
        File dstFile = this.writeJsp(this.getSkeletonFilename());
        NPSCompatUtils.refreshResourceFileMap(CUSTOM_MODULE);
        CustomNpmFile npm = new CustomNpmFile(this.m_context);
        String versionString = npm.getNextVersion().toString();
        Element root = new Element("install");
        Document fulldoc = new Document(root);
        Element module = CustomNpmFile.makeModuleElement(versionString);
        root.addContent(module);
        root.addContent((Element)document.getRootElement().clone());
        PluginParams.runRbsInstaller(this.m_rbsCollectionName, fulldoc, this.m_context);
        String version = TemplateBuilderUtils.outputNPM(document, this.m_context, dstFile, this.m_client, false);
        String xmlDirPath = iManager.getAbsModulesPath() + "/" + CUSTOM_MODULE + "/install";
        File xmlDirectory = new File(xmlDirPath);
        if (!xmlDirectory.exists()) {
            xmlDirectory.mkdir();
        }
        File xmlFile = new File(xmlDirectory, "install.xml");
        Element taskElement = (Element)document.getRootElement().clone();
        TemplateBuilderUtils.removePluginXmlFromFile(xmlFile, "custom." + this.m_pluginName);
        TemplateBuilderUtils.addInstallXml(xmlFile, taskElement, version);
        Registry reg = Registry.getRegistry("Install");
        String pluginId = document.getRootElement().getChildText("id");
        String simpleName = pluginId.substring(pluginId.indexOf(".") + 1, pluginId.length());
        if (reg.getPluginDocument(pluginId) == null && pluginId.startsWith("custom.")) {
            document.getRootElement().getChild("id").setText(simpleName);
            reg.removeNode(document);
            document.getRootElement().getChild("id").setText(pluginId);
            Hashtable servicesNames = reg.get_realServiceNames();
            if (servicesNames.containsKey(pluginId)) {
                servicesNames.remove(pluginId);
            }
        } else {
            reg.removeNode(document);
        }
        reg.addNode(CUSTOM_MODULE, document, xmlFile, CUSTOM_MODULE, true, false);
        for (int i = 0; i < this.m_roles.length; ++i) {
            this.m_context.addToHistory("rbsRole2", this.m_roles[i]);
        }
        this.m_context.addToHistory("rbsTask2", this.m_pluginName + "." + CUSTOM_MODULE + "." + this.m_rbsCollectionName);
        String prevAddToCreateObject = this.m_context.getRequest().getParameter("prevAddToCreateObject");
        if (prevAddToCreateObject == null) {
            prevAddToCreateObject = "false";
        }
        if (this.m_addToCreateObject) {
            String className = this.m_classDefinition.getName();
            GlobalRegistry.getCreatorDoc(className, this.m_context);
            String name = dstFile.getName();
            name = name.substring(0, name.length() - 4);
            boolean success = CreatorWizardTask.registerClass(this.m_context, className, "com.novell.emframe.dev.eDirAccessService", "custom." + name, true);
            if (!success) {
                this.setMessage("FwResources", "TaskBuilder.InstallTaskSuccess", "TaskBuilder.InstallTaskNoCreator");
                return true;
            }
        } else if (!this.m_addToCreateObject && prevAddToCreateObject.equals("true")) {
            String className = this.m_classDefinition.getName();
            String name = dstFile.getName();
            name = name.substring(0, name.length() - 4);
            boolean success = CreatorWizardTask.unRegisterClass(this.m_context, className);
            if (!success) {
                this.setMessage("FwResources", "TaskBuilder.InstallTaskSuccess", "TaskBuilder.InstallTaskNoCreator");
                return true;
            }
        }
        this.setMessage("FwResources", "TaskBuilder.InstallTaskSuccess", "TaskBuilder.InstallTaskSuccessLong");
        return true;
    }

    public static void runRbsInstaller(String rbsCollectionName, Document document, MContext context) throws PluginException {
        ObjectEntry treeOE = RBSUtil.getTreeOE(context);
        AdminNamespace ns = treeOE.getAdminNamespace();
        String authName = "eDir";
        try {
            if (ns.isSupported("NVDS")) {
                authName = "NVDS";
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        ModuleClassObject moduleClassObject = null;
        XMLFileReader xmlFileReader = new XMLFileReader(ns);
        try {
            moduleClassObject = xmlFileReader.readFile(document, authName);
        }
        catch (JDOMException e) {
            D.log(e);
            throw new PluginException(eMFrameUtils.getLocalizedString("FwResources", "eMFrameConsts.READ_XML_FILE_FAILURE", context), e.getMessage());
        }
        RBSObjectInstaller installer = new RBSObjectInstaller(treeOE, moduleClassObject);
        try {
            String dynamicGroupSearchType = FwUtils.getDynamicSearchType(context);
            installer.install(rbsCollectionName, dynamicGroupSearchType);
            FwAuthUtils.invalidateRolesAndTasksForAllAuths((FwTaskContext)context);
        }
        catch (Exception e) {
            UniqueSPIException spi;
            int code;
            e.printStackTrace();
            if (e instanceof UniqueSPIException && (code = (spi = (UniqueSPIException)e).getErrorCode()) == -649) {
                String title = eMFrameUtils.getLocalizedString("FwResources", "Studio.installFailure", context);
                String body = eMFrameUtils.getLocalizedString("FwResources", "Studio.tooManyFields", context);
                throw new PluginException(title, body);
            }
            D.log(e);
            String format = eMFrameUtils.getLocalizedString("FwResources", "eMFrameConsts.INSTALL_PACKAGE_FAILURE", context);
            String title = eMFrameUtils.formatMessage(format, new Object[]{document.getRootElement().getChildTextTrim("id")});
            throw new PluginException(title, eMFrameUtils.getExceptionMessage(e, context));
        }
    }

    public String getJspFilename() {
        if (this.m_jspFilename == null) {
            this.m_jspFilename = this.m_context.getDirUtils().getSafeName(this.m_pluginName.replace(' ', '_')) + TemplateBuilderUtils.getDatePostfix();
        }
        return this.m_jspFilename;
    }

    private File writeJsp(String skeletonFileName) throws IOException {
        String dstTemplateName = this.getJspFilename();
        UiHandler[] uihandlers = new UiHandler[this.m_fieldNames.length];
        for (int i = 0; i < this.m_fieldNames.length; ++i) {
            uihandlers[i] = (UiHandler)this.m_uihandlersMap.get(this.m_fieldNames[i]);
        }
        ArrayList<String> auxClassesList = new ArrayList<String>();
        if (this.m_classDefinition.isAuxiliary()) {
            auxClassesList.add(this.m_classDefinition.getName());
        }
        boolean onExitOnSubmit = !this.m_pluginType.equals("page");
        TemplateBuilder.createTemplate(this.m_context, uihandlers, this.m_client, this.m_labelAboveControl, skeletonFileName, this.m_auxClasses, false, CUSTOM_MODULE, dstTemplateName + ".jsp", onExitOnSubmit);
        String dstPath = this.m_context.getWebappHome() + "/portal/modules/custom/skins/default/devices/" + this.m_client + "/";
        File dstFile = new File(dstPath + dstTemplateName + ".jsp");
        return dstFile;
    }

    boolean installPage(Document document, boolean isModify) throws IOException, Exception {
        Document doc;
        String pluginName = this.m_pluginName;
        if (!this.m_pluginName.startsWith("custom.")) {
            pluginName = "custom." + this.m_pluginName;
        }
        String pageId = pluginName;
        if (!isModify && (doc = GlobalRegistry.getPluginDocument(pageId)) != null) {
            String title = eMFrameUtils.getLocalizedString("FwResources", "TaskBuilder.DuplicatePageName", this.m_context);
            String body = eMFrameUtils.getLocalizedString("FwResources", "TaskBuilder.DuplicatePageNameDetails", this.m_context);
            throw new eDirAccessServiceException(title, body);
        }
        File newFile = this.writeJsp("TemplateBuilder_skeletonPage.jsp");
        NPSCompatUtils.refreshResourceFileMap(CUSTOM_MODULE);
        String xmlDirPath = this.m_context.getWebappHome() + "/portal/modules/" + CUSTOM_MODULE + "/plugins";
        File xmlDirectory = new File(xmlDirPath);
        if (!xmlDirectory.exists()) {
            xmlDirectory.mkdir();
        }
        File xmlFile = new File(xmlDirectory, "plugins.xml");
        Element page = (Element)document.getRootElement().clone();
        TemplateBuilderUtils.removePluginXmlFromDirectory(xmlDirectory, pageId);
        TemplateBuilderUtils.addPluginXml(xmlFile, page);
        Registry.getRegistry("Global").addOrReplaceNode(CUSTOM_MODULE, document, xmlFile, false);
        if (this.m_bookName != null && this.m_bookName.length() > 0) {
            ObjectEntry treeOE = RBSUtil.getTreeOE(this.m_context);
            AdminNamespace namespace = treeOE.getAdminNamespace();
            ObjectEntry bookObjectEntry = null;
            bookObjectEntry = namespace.getObjectEntry(treeOE, this.m_bookName);
            this.m_context.addToHistory(bookObjectEntry);
            if (!bookObjectEntry.getObjectType().getName().equalsIgnoreCase("rbsBook2")) {
                String strHeader = eMFrameUtils.getLocalizedString("FwResources", "TaskBuilder.Error", this.m_context);
                String strBody = eMFrameUtils.getLocalizedString("FwResources", "TaskBuilder.RbsBookDoesNotExist", this.m_context);
                eMFrameUtils.setMessage("error", strHeader, strBody, this.m_context);
                return false;
            }
            RBSBook rbsBook = new RBSBook(bookObjectEntry);
            String[] oldPageList = rbsBook.getPageMemebership();
            if (oldPageList == null) {
                oldPageList = new String[]{};
            }
            String[] newPageList = new String[oldPageList.length + 1];
            for (int i = 0; i < oldPageList.length; ++i) {
                newPageList[i] = oldPageList[i];
            }
            newPageList[newPageList.length - 1] = pageId;
            rbsBook.setPageMembership(newPageList);
            rbsBook.setRights(FwUtils.getPagesRights(newPageList, treeOE));
            rbsBook.update();
        }
        String header = eMFrameUtils.getLocalizedString("FwResources", "TaskBuilder.Success", this.m_context);
        String body = eMFrameUtils.getLocalizedString("FwResources", "TaskBuilder.pageInstalled", this.m_context);
        eMFrameUtils.setMessage("success", header, body, this.m_context);
        TemplateBuilderUtils.outputNPM(document, this.m_context, newFile, this.m_client, true);
        return true;
    }

    private Element createXmlForTask(String[] attributes, boolean setPassword, String jspFilename) {
        String className;
        int i;
        Element task = new Element("task");
        String pluginName = this.m_pluginName.startsWith("custom.") ? this.m_pluginName : "custom." + this.m_pluginName;
        task.addContent(TemplateBuilderUtils.newElement("id", pluginName));
        task.addContent(TemplateBuilderUtils.newElement("version", "1.0"));
        task.addContent(TemplateBuilderUtils.newElement("required-version", "1.0"));
        task.addContent(TemplateBuilderUtils.newElement("class-name", "com.novell.emframe.dev.eDirAccessService"));
        task.addContent(TemplateBuilderUtils.newElement("error-template", "dev.GenErr"));
        task.addContent(TemplateBuilderUtils.newElement("description", ""));
        task.addContent(TemplateBuilderUtils.newElement("resource-properties-file", "FwResources"));
        this.addUrlParamsFromUiHandlers(task);
        String merge = null;
        merge = this.m_pluginType.equals("delete") ? "fw.DelObject" : "custom." + jspFilename;
        task.addContent(TemplateBuilderUtils.newElement("merge-template", merge));
        if (this.m_roles != null && this.m_roles.length > 0) {
            for (i = 0; i < this.m_roles.length; ++i) {
                String roleName = this.m_roles[i];
                if (roleName == null || roleName.length() <= 0) continue;
                D.assrt(roleName.toLowerCase().endsWith(this.m_rbsCollectionName.toLowerCase()), "TaskBuilder: The role must be in the collection");
                String shortRoleName = roleName.substring(0, roleName.length() - this.m_rbsCollectionName.length() - 1);
                Element role = new Element("role-assignment");
                role.setText(shortRoleName);
                task.addContent(role);
            }
        }
        if (this.m_mooEnabled) {
            Element param = new Element("url-param");
            param.addContent(TemplateBuilderUtils.newElement("param-key", "TC.multipleObjectEnabled"));
            param.addContent(TemplateBuilderUtils.newElement("param-value", "true"));
            task.addContent(param);
            param = new Element("url-param");
            param.addContent(TemplateBuilderUtils.newElement("param-key", "TC.advancedSelectionEnabled"));
            param.addContent(TemplateBuilderUtils.newElement("param-value", "true"));
            task.addContent(param);
        }
        if (this.m_customTargetChooser != null && (className = this.m_customTargetChooser.getChildTextTrim("class-name")) == null) {
            task.addContent((Element)this.m_customTargetChooser.clone());
        }
        task.addContent(TemplateBuilderUtils.newElement("order", "" + this.m_taskOrder));
        if (this.m_pluginType.equals("create")) {
            ObjectEntry treeOE = RBSUtil.getTreeOE(this.m_context);
            AdminNamespace ns = treeOE.getAdminNamespace();
            try {
                ClassDefinition classDefinition = ns.getClassDefinition(treeOE, this.m_classDefinition.getName());
                String[] containers = classDefinition.getContainmentClasses();
                containers = this.buildContainment(containers);
                for (int i2 = 0; i2 < containers.length; ++i2) {
                    task.addContent(TemplateBuilderUtils.newElement("object-type-name", containers[i2]));
                }
            }
            catch (SPIException e) {
                D.log(e);
            }
            catch (NamespaceException e) {
                D.log(e);
            }
            task.addContent(TemplateBuilderUtils.newElement("menu-type", "create"));
        } else {
            for (i = 0; i < this.m_objectTypeNameReg.length; ++i) {
                task.addContent(TemplateBuilderUtils.newElement("object-type-name", this.m_objectTypeNameReg[i]));
            }
        }
        for (int index = 0; index < attributes.length; ++index) {
            UiHandler uiHandler = (UiHandler)this.m_uihandlersMap.get(attributes[index]);
            boolean readOnly = uiHandler.isForceReadOnly();
            if (attributes[index].equals("Member")) {
                task.addContent(PluginParams.createRightesElement("Group Membership", readOnly));
                task.addContent(PluginParams.createRightesElement("Security Equals", readOnly));
                task.addContent(PluginParams.createRightesElement("Equivalent To Me", readOnly));
            } else if (attributes[index].equals("Group Membership")) {
                task.addContent(PluginParams.createRightesElement("Member", readOnly));
                task.addContent(PluginParams.createRightesElement("Equivalent To Me", readOnly));
                task.addContent(PluginParams.createRightesElement("Security Equals", readOnly));
            } else if (attributes[index].equals("Security Equals")) {
                task.addContent(PluginParams.createRightesElement("Equivalent To Me", readOnly));
            } else if (attributes[index].equals("Equivalent To Me")) {
                task.addContent(PluginParams.createRightesElement("Security Equals", readOnly));
            } else if (attributes[index].equals("directReports")) {
                task.addContent(PluginParams.createRightesElement("manager", readOnly));
            } else if (attributes[index].equals("manager")) {
                task.addContent(PluginParams.createRightesElement("directReports", readOnly));
            }
            task.addContent(PluginParams.createRightesElement(attributes[index], readOnly));
        }
        if (this.m_pluginType.equals("create")) {
            Element rights = new Element("rights-assignment");
            rights.addContent(TemplateBuilderUtils.newElement("attribute-name", "[Entry Rights]"));
            rights.addContent(TemplateBuilderUtils.newElement("privilege", "Browse"));
            rights.addContent(TemplateBuilderUtils.newElement("privilege", "Create"));
            task.addContent(rights);
        }
        if (setPassword) {
            Element setPasswordRights = new Element("rights-assignment");
            setPasswordRights.addContent(TemplateBuilderUtils.newElement("attribute-name", "Password Management"));
            setPasswordRights.addContent(TemplateBuilderUtils.newElement("privilege", "Supervisor"));
            task.addContent(setPasswordRights);
        }
        if (this.m_auxClasses != null && this.m_auxClasses.length > 0) {
            Element auxExtensionRights = new Element("rights-assignment");
            auxExtensionRights.addContent(TemplateBuilderUtils.newElement("attribute-name", "Object Class"));
            auxExtensionRights.addContent(TemplateBuilderUtils.newElement("privilege", "Supervisor"));
            task.addContent(auxExtensionRights);
        }
        String safeName = this.m_context.getDirUtils().getSafeName(this.m_classDefinition.getName());
        Element param = new Element("url-param");
        param.addContent(TemplateBuilderUtils.newElement("param-key", "eDirSearch"));
        param.addContent(TemplateBuilderUtils.newElement("param-value", safeName));
        task.addContent(param);
        if (this.m_pluginType.equals("create")) {
            Element param1 = new Element("url-param");
            param1.addContent(TemplateBuilderUtils.newElement("param-key", "eDirCommand"));
            param1.addContent(TemplateBuilderUtils.newElement("param-value", "preCreate"));
            task.addContent(param1);
        }
        Element urlParam = new Element("url-param");
        PluginParams.addSimpleChild(urlParam, "param-key", "defaultDisplayName");
        PluginParams.addSimpleChild(urlParam, "param-value", this.m_displayName);
        task.addContent(urlParam);
        Element xmlinfo = new Element("rbs-xml-info");
        xmlinfo.addContent(this.buildTaskParamXml());
        task.addContent(xmlinfo);
        return task;
    }

    private String[] buildContainment(String[] containers) {
        ArrayList<String> containmentList = new ArrayList<String>(Arrays.asList(containers));
        if (containmentList.indexOf("Top") >= 0) {
            containmentList.remove("Top");
        }
        if (containmentList.indexOf("Tree Root") >= 0) {
            containmentList.add(containmentList.indexOf("Tree Root"), "[root]");
            containmentList.remove("Tree Root");
        }
        return containmentList.toArray(new String[0]);
    }

    private static Element createRightesElement(String attributeName, boolean readOnly) {
        String access = readOnly ? "Read" : "Supervisor";
        Element rights = new Element("rights-assignment");
        rights.addContent(TemplateBuilderUtils.newElement("attribute-name", attributeName));
        rights.addContent(TemplateBuilderUtils.newElement("privilege", access));
        return rights;
    }

    private Element createXmlForPage(String[] attributes, String jspFilename, boolean otherName, String module) {
        Element page = null;
        page = this.m_isPublic ? new Element("page") : new Element("private-page");
        String pluginName = this.m_pluginName;
        if (!this.m_pluginName.startsWith("custom.")) {
            pluginName = "custom." + pluginName;
        }
        page.addContent(TemplateBuilderUtils.newElement("id", pluginName));
        page.addContent(TemplateBuilderUtils.newElement("version", "1.0"));
        page.addContent(TemplateBuilderUtils.newElement("required-version", "1.0"));
        try {
            String userCN = DirUtils.getUserCN(this.m_context);
            if (userCN != null) {
                page.addContent(TemplateBuilderUtils.newElement("created-by", userCN));
            }
        }
        catch (AuthNotAuthenticatedException e) {
            D.log(e);
        }
        this.addUrlParamsFromUiHandlers(page);
        if (otherName) {
            page.addContent(TemplateBuilderUtils.newElement("class-name", "com.novell.emframe.base.SharedIdentificationPage"));
        } else {
            page.addContent(TemplateBuilderUtils.newElement("class-name", "com.novell.emframe.dev.DirPropertyBookPage"));
        }
        page.addContent(TemplateBuilderUtils.newElement("merge-template", module + "." + jspFilename));
        page.addContent(TemplateBuilderUtils.newElement("description", ""));
        page.addContent(TemplateBuilderUtils.newElement("resource-properties-file", "FwResources"));
        page.addContent(TemplateBuilderUtils.newElement("display-name-key", "previewPage"));
        for (int i = 0; i < this.m_objectTypeNameReg.length; ++i) {
            page.addContent(TemplateBuilderUtils.newElement("object-type-name", this.m_objectTypeNameReg[i]));
        }
        Element urlParam = new Element("url-param");
        PluginParams.addSimpleChild(urlParam, "param-key", "defaultDisplayName");
        PluginParams.addSimpleChild(urlParam, "param-value", this.m_displayName);
        page.addContent(urlParam);
        Element chapter = new Element("chapter");
        chapter.addContent(TemplateBuilderUtils.newElement("id", this.m_chapterId));
        chapter.addContent(TemplateBuilderUtils.newElement("display-name-key", this.m_chapterDisplayNameKey));
        chapter.addContent(TemplateBuilderUtils.newElement("resource-properties-file", this.m_chapterResourceFile));
        page.addContent(chapter);
        if (this.m_pageOrder != -1) {
            page.addContent(TemplateBuilderUtils.newElement("page-order", "" + this.m_pageOrder));
        }
        for (int index = 0; index < attributes.length; ++index) {
            Element rights = new Element("rights-assignment");
            rights.addContent(TemplateBuilderUtils.newElement("attribute-name", attributes[index]));
            UiHandler handler = (UiHandler)this.m_uihandlersMap.get(attributes[index]);
            if (handler.isForceReadOnly()) {
                rights.addContent(TemplateBuilderUtils.newElement("privilege", "Read"));
            } else {
                rights.addContent(TemplateBuilderUtils.newElement("privilege", "Supervisor"));
            }
            page.addContent(rights);
        }
        if (this.m_mooEnabled) {
            page.addContent(TemplateBuilderUtils.newElement("moo-enabled", "true"));
        }
        Element xmlinfo = new Element("rbs-xml-info");
        xmlinfo.addContent(this.buildPageParamXml());
        page.addContent(xmlinfo);
        return page;
    }

    private void addUrlParamsFromUiHandlers(Element page) {
        for (int i = 0; i < this.m_fieldNames.length; ++i) {
            UiHandler handler = (UiHandler)this.m_uihandlersMap.get(this.m_fieldNames[i]);
            Element[] elements = handler.getNeedUrlParams();
            if (elements == null) continue;
            for (int j = 0; j < elements.length; ++j) {
                page.addContent(elements[j]);
            }
        }
    }

    private Element buildPageParamXml() {
        Element root = this.buildCommonXml();
        PluginParams.addSimpleChild(root, "book", this.m_bookName);
        PluginParams.addSimpleChild(root, "public", "" + this.m_isPublic);
        PluginParams.addSimpleChild(root, "chapter-src", this.m_chapterSrc);
        PluginParams.addSimpleChild(root, "chapter-id", this.m_chapterId);
        return root;
    }

    private Element buildTaskParamXml() {
        Element root = this.buildCommonXml();
        if (this.m_roles != null) {
            for (int i = 0; i < this.m_roles.length; ++i) {
                PluginParams.addSimpleChild(root, "role", this.m_roles[i]);
            }
        }
        PluginParams.addSimpleChild(root, "rbsCollection", this.m_rbsCollectionName);
        if (this.m_customTargetChooser != null) {
            root.addContent((Element)this.m_customTargetChooser.clone());
        }
        if (this.m_pluginType.equals("create")) {
            PluginParams.addSimpleChild(root, "modify-task", this.m_modifyTask);
            PluginParams.addSimpleChild(root, "addToCreateObject", "" + this.m_addToCreateObject);
        }
        Element compressedElement = new Element("plugin-params-compressed");
        compressedElement.setAttribute("compressed-data", this.compressElement(root));
        return compressedElement;
    }

    private Element buildCommonXml() {
        int i;
        Element element = new Element("plugin-params");
        PluginParams.addSimpleChild(element, "client", this.m_client);
        PluginParams.addSimpleChild(element, "moo-enabled", "" + this.m_mooEnabled);
        PluginParams.addSimpleChild(element, "label-above-control", "" + this.m_labelAboveControl);
        PluginParams.addSimpleChild(element, "plugin-type", this.m_pluginType);
        PluginParams.addSimpleChild(element, "object-type-name", this.m_classDefinition.getName());
        for (i = 0; i < this.m_objectTypeNameReg.length; ++i) {
            PluginParams.addSimpleChild(element, "object-type-name-reg", this.m_objectTypeNameReg[i]);
        }
        if (this.m_auxClasses != null) {
            for (i = 0; i < this.m_auxClasses.length; ++i) {
                PluginParams.addSimpleChild(element, "additional-aux", this.m_auxClasses[i]);
            }
        }
        PluginParams.addSimpleChild(element, "display-name", this.m_displayName);
        Element fields = new Element("fields");
        for (int i2 = 0; i2 < this.m_fieldNames.length; ++i2) {
            UiHandler uihandler = (UiHandler)this.m_uihandlersMap.get(this.m_fieldNames[i2]);
            Element field = new Element("field");
            field.setAttribute("name", this.m_fieldNames[i2]);
            field.setAttribute("id", uihandler.getId());
            UiHandler uiHandler = (UiHandler)this.m_uihandlersMap.get(this.m_fieldNames[i2]);
            field.setAttribute("uihandler", uiHandler.getClass().getName());
            ArrayList params = uihandler.getParams();
            Iterator iter = params.iterator();
            while (iter.hasNext()) {
                Element param = (Element)iter.next();
                field.addContent((Element)param.clone());
            }
            fields.addContent(field);
        }
        element.addContent(fields);
        return element;
    }

    private String compressElement(Element element) {
        String xmlString = FwUtils.getDocStr(new Document((Element)element.clone()));
        return Base64.encodeObject((Serializable)((Object)xmlString), 2);
    }

    private void setMessage(String bundle, String titleKey, String bodyKey) {
        this.m_context.getRequest().setAttribute("GeneralMsg.MsgTitle", (Object)eMFrameUtils.getLocalizedString(bundle, titleKey, this.m_context));
        this.m_context.getRequest().setAttribute("GeneralMsg.MsgBody", (Object)eMFrameUtils.getLocalizedString(bundle, bodyKey, this.m_context));
    }

    public static PluginParams readFromXml(Element element, MContext context) throws PluginException {
        String client = element.getChildTextTrim("client");
        boolean mooEnabled = element.getChildTextTrim("moo-enabled").equals("true");
        boolean labelAboveControl = element.getChildTextTrim("label-above-control").equals("true");
        String pluginType = element.getChildTextTrim("plugin-type");
        List list = element.getChildren("object-type-name-reg");
        String[] objectClassNameReg = new String[list.size()];
        int index = 0;
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            Element typeElement = (Element)iter.next();
            objectClassNameReg[index++] = typeElement.getTextTrim();
        }
        String objectClassName = element.getChildTextTrim("object-type-name");
        String pluginId = element.getChildTextTrim("plugin-id");
        String displayName = element.getChildTextTrim("display-name");
        if (displayName == null) {
            displayName = "";
        }
        ObjectEntry treeOE = RBSUtil.getTreeOE(context);
        AdminNamespace ns = treeOE.getAdminNamespace();
        SchemaDefinition schema = null;
        try {
            schema = ns.getSchemaDefinition(treeOE);
        }
        catch (SPIException e) {
            throw new PluginException((Exception)((Object)e));
        }
        String[] auxClasses = null;
        list = element.getChildren("additional-aux");
        if (list != null && list.size() > 0) {
            auxClasses = new String[list.size()];
            int i = 0;
            Iterator iter2 = list.iterator();
            while (iter2.hasNext()) {
                Element item = (Element)iter2.next();
                auxClasses[i++] = item.getTextTrim();
            }
        }
        String[] fieldNames = null;
        Hashtable<String, UiHandler> uihandlersMap = new Hashtable<String, UiHandler>();
        List fields = element.getChild("fields").getChildren();
        if (fields != null && fields.size() > 0) {
            fieldNames = new String[fields.size()];
            int i = 0;
            Iterator iter3 = fields.iterator();
            while (iter3.hasNext()) {
                Element field = (Element)iter3.next();
                fieldNames[i] = field.getAttributeValue("name");
                String id = field.getAttributeValue("id");
                try {
                    String className = field.getAttributeValue("uihandler");
                    Class<?> c = Class.forName(className);
                    UiHandler uihandler = (UiHandler)c.newInstance();
                    List paramList = field.getChildren("param");
                    boolean forceReadOnly = false;
                    boolean forceSingleValued = false;
                    boolean forceMandatory = false;
                    Iterator paramIter = paramList.iterator();
                    while (paramIter.hasNext()) {
                        boolean value;
                        Element paramElement = (Element)paramIter.next();
                        uihandler.processParam(paramElement);
                        String textValue = paramElement.getChildTextTrim("value");
                        boolean bl = value = textValue != null && textValue.equals("true");
                        if (paramElement.getAttributeValue("name").equals("readOnly")) {
                            forceReadOnly = value;
                            continue;
                        }
                        if (paramElement.getAttributeValue("name").equals("singleValued")) {
                            forceSingleValued = value;
                            continue;
                        }
                        if (!paramElement.getAttributeValue("name").equals("mandatory")) continue;
                        forceMandatory = value;
                    }
                    if (forceReadOnly && forceMandatory) {
                        String header = eMFrameUtils.getLocalizedString("FwResources", "Error", context);
                        String body = eMFrameUtils.getLocalizedString("FwResources", "Studio.noMandatoryAndReadOnly", context);
                        throw new PluginException(header, body);
                    }
                    AttributeDefinition attrDefinition = null;
                    String name = fieldNames[i];
                    if (!(name.equals("createContext") || name.equals("SetPassword") || name.equals("copyFrom"))) {
                        if (!name.equals("HTMLArea") && !name.equals("othername")) {
                            attrDefinition = schema.getAttributeDefinition(fieldNames[i]);
                        }
                        UiHandlerContext uiHandlerContext = new UiHandlerContext(attrDefinition, client, id, forceReadOnly, forceSingleValued, forceMandatory);
                        uihandler.init(uiHandlerContext);
                    }
                    uihandlersMap.put(fieldNames[i], uihandler);
                    Iterator paramIter2 = paramList.iterator();
                    while (paramIter2.hasNext()) {
                        Element param = (Element)paramIter2.next();
                        uihandler.processParam(param);
                    }
                }
                catch (Exception e) {
                    D.log("Invalid attribute:" + fieldNames[i]);
                    D.log(e);
                    throw new PluginException(e);
                }
                ++i;
            }
        }
        NDSClassDefinition classDefinition = null;
        try {
            classDefinition = (NDSClassDefinition)schema.getClassDefinition(objectClassName);
        }
        catch (Exception e) {
            D.log(e);
            throw new PluginException(e);
        }
        if (pluginType.equals("page")) {
            boolean isPublic = element.getChildTextTrim("public").equals("true");
            String bookName = element.getChildTextTrim("book");
            String chapterId = element.getChildTextTrim("chapter-id");
            String chapterSrc = element.getChildTextTrim("chapter-src");
            String chapterDisplayNameKey = "";
            String chapterResourceId = "";
            int pageOrder = -1;
            String sPageOrder = (String)context.getRequest().getAttribute("page-order");
            if (sPageOrder != null && sPageOrder.length() > 0) {
                try {
                    pageOrder = Integer.parseInt(sPageOrder);
                }
                catch (NumberFormatException e) {
                    D.log(e);
                }
            }
            return new PluginParams(uihandlersMap, pluginType, pluginId, client, labelAboveControl, (ClassDefinition)classDefinition, mooEnabled, auxClasses, objectClassNameReg, fieldNames, displayName, bookName, chapterDisplayNameKey, chapterId, chapterResourceId, isPublic, chapterSrc, pageOrder, context);
        }
        String modifyTask = element.getChildTextTrim("modify-task");
        ArrayList<String> roleList = new ArrayList<String>();
        List roleElementList = element.getChildren("role");
        Iterator iter4 = roleElementList.iterator();
        while (iter4.hasNext()) {
            Element roleElement = (Element)iter4.next();
            roleList.add(roleElement.getTextTrim());
        }
        String[] roles = roleList.toArray(new String[roleList.size()]);
        String rbsCollectionName = element.getChildTextTrim("rbsCollection");
        Element customTc = element.getChild("custom-target-chooser");
        if (customTc == null) {
            customTc = element.getChild("url-param");
        }
        String taskOrder = (String)context.getRequest().getAttribute("taskOrder");
        boolean addToCreateObject = element.getChildTextTrim("addToCreateObject") != null && element.getChildTextTrim("addToCreateObject").equals("true");
        return new PluginParams(uihandlersMap, pluginType, pluginId, client, labelAboveControl, (ClassDefinition)classDefinition, mooEnabled, auxClasses, objectClassNameReg, fieldNames, displayName, addToCreateObject, rbsCollectionName, roles, modifyTask, customTc, taskOrder, context);
    }

    private static final void addSimpleChild(Element element, String tag, String text) {
        element.addContent(TemplateBuilderUtils.newElement(tag, text));
    }

    public static PluginParams createPluginParamsFromRbsTask(String pluginId, MContext context) throws PluginException, JDOMException, IOException {
        ObjectEntry treeOE = RBSUtil.getTreeOE(context);
        AdminNamespace ns = treeOE.getAdminNamespace();
        String xml = null;
        String merge = null;
        String taskOrder = "";
        try {
            ObjectEntry oe = ns.getObjectEntry(pluginId);
            ObjectAttribute attribute = ns.getAttribute(oe, "rbsXMLInfo");
            ValueComponent vc = (ValueComponent)attribute.getValueComponents().nextElement();
            xml = vc.toString();
            attribute = ns.getAttribute(oe, "rbsParameters");
            vc = (ValueComponent)attribute.getValueComponents().nextElement();
            Properties params = eMFrameUtils.parseParameters(vc.toString());
            taskOrder = params.getProperty("order");
            attribute = ns.getAttribute(oe, "rbsParameters");
            vc = (ValueComponent)attribute.getValueComponents().nextElement();
            params = eMFrameUtils.parseParameters(vc.toString());
            merge = params.getProperty("merge-template");
        }
        catch (Exception e) {
            String title = eMFrameUtils.getLocalizedString("FwResources", "Studio.cannotCopy", context);
            String body = eMFrameUtils.getLocalizedString("FwResources", "Studio.cannotCopyDetail", context);
            throw new PluginException(title, body);
        }
        SAXBuilder saxBuilder = new SAXBuilder(false);
        Document doc = saxBuilder.build((Reader)new StringReader(xml));
        PluginParams pluginParams = null;
        doc.getRootElement();
        pluginParams = PluginParams.readFromXml(StudioUtils.unCompressPluginParams(doc).getRootElement(), context);
        pluginParams.m_jspFilenameFromRbsTask = merge;
        if (taskOrder != null && !taskOrder.equals("")) {
            pluginParams.m_taskOrder = Integer.parseInt(taskOrder);
        }
        return pluginParams;
    }

    private static Chapter[] getChaptersSortedByName(Chapter[] arr) {
        D.log(">>> Entering getChaptersSortedByName <<<<");
        int numberOfChapters = arr.length;
        for (int out = 1; out < numberOfChapters; ++out) {
            Chapter temp = arr[out];
            for (int in = out; in > 0 && arr[in - 1].getName().compareToIgnoreCase(temp.getName()) > 0; --in) {
                arr[in] = arr[in - 1];
            }
            arr[in] = temp;
        }
        D.log(">>> Exiting getChaptersSortedByName <<<<");
        return arr;
    }
}

