/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.fw.studio;

import com.novell.admin.common.exceptions.SPIException;
import com.novell.admin.ns.NamespaceException;
import com.novell.admin.ns.nds.NDSFilterResultModifier;
import com.novell.admin.ns.nds.NDSNamespace;
import com.novell.application.console.snapin.ObjectEntry;
import com.novell.application.console.snapin.ObjectEntryEnumeration;
import com.novell.application.console.snapin.ResultModifier;
import com.novell.application.console.snapin.ResultModifierFilterEntry;
import com.novell.emframe.dev.AuthenticationBroker;
import com.novell.emframe.dev.D;
import com.novell.emframe.dev.DirUtils;
import com.novell.emframe.dev.MContext;
import com.novell.emframe.dev.MTask;
import com.novell.emframe.dev.PluginException;
import com.novell.emframe.dev.authenticator.AuthNotAuthenticatedException;
import com.novell.emframe.dev.eMFrameUtils;
import com.novell.emframe.fw.CustomNpmFile;
import com.novell.emframe.fw.FwUtils;
import com.novell.emframe.fw.Registry;
import com.novell.emframe.fw.iManager;
import com.novell.emframe.fw.npsCompat.NPSCompatUtils;
import com.novell.emframe.fw.studio.PageData;
import com.novell.emframe.fw.studio.PluginParams;
import com.novell.emframe.fw.studio.StudioPluginInfo;
import com.novell.emframe.fw.studio.TemplateBuilderUtils;
import com.novell.nps.WebappUtil;
import com.novell.nps.serviceProviders.PortalModuleInstallManager;
import com.novell.rbs.RBSAssociatedObject;
import com.novell.rbs.RBSCollection;
import com.novell.webaccess.common.Browser;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import javax.naming.NamingEnumeration;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.LdapContext;
import javax.servlet.ServletContext;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public class StudioOverview
extends MTask {
    String filename = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void render(MContext context, HttpServletResponse response) {
        if (this.filename == null) {
            super.render(context, response);
        } else {
            try {
                response.setHeader("Pragma", "public");
                response.setHeader("Cache-Control", "max-age=0");
                response.setContentType("application/octet-stream");
                response.setHeader("Content-Disposition", "attachment; filename=custom" + TemplateBuilderUtils.getDatePostfix() + ".npm");
                response.setHeader("Content-Length", String.valueOf(new File(this.filename).length()));
                ServletOutputStream out = response.getOutputStream();
                BufferedInputStream in = new BufferedInputStream(new FileInputStream(this.filename));
                FwUtils.copyData(in, (OutputStream)out);
                out.close();
            }
            catch (Throwable e) {
                D.log(e);
            }
            finally {
                this.filename = null;
            }
        }
    }

    public void execute(MContext context) {
        HttpServletRequest req = context.getRequest();
        String nextState = req.getParameter("nextState");
        ObjectEntry treeOE = (ObjectEntry)context.getAuthenticationBroker().getAPIObject("NDSNamespace");
        NDSNamespace ns = (NDSNamespace)treeOE.getNamespace();
        try {
            if (nextState == null || nextState.equals("initialState")) {
                this.initialState(ns, treeOE, context);
            } else if (nextState.equals("deletePlugin")) {
                this.deletePlugins(req, context, ns);
                this.initialState(ns, treeOE, context);
            } else if (nextState.equals("importGatherInfo")) {
                this.setUIPage("fw/Studio_import.jsp");
            } else if (nextState.equals("import")) {
                String filePath = req.getParameter("fileToUpload.tempFile");
                File npmFile = new File(filePath);
                ServletContext servletContext = WebappUtil.getStaticServletContext();
                if (null != servletContext) {
                    PortalModuleInstallManager installManager = new PortalModuleInstallManager(npmFile, new File(WebappUtil.getRealPath(null)));
                    Object oTempDir = servletContext.getAttribute("javax.servlet.context.tempdir");
                    String[] errors = installManager.install(WebappUtil.getRealPath((String)"/"), oTempDir.toString());
                    if (null != errors && 0 < errors.length) {
                        String title = eMFrameUtils.getLocalizedString("FwResources", "Error", context);
                        String body = eMFrameUtils.getLocalizedString("FwResources", "Studio.errorManifestVersion", context);
                        eMFrameUtils.setMessage("error", title, body, context);
                    }
                }
                String rbsCollection = req.getParameter("rbsCollection");
                File directory = new File(iManager.getAbsModulesPath() + "/custom/install");
                File[] installFiles = directory.listFiles();
                SAXBuilder saxBuilder = new SAXBuilder(false);
                if (installFiles != null) {
                    for (int i = 0; i < installFiles.length; ++i) {
                        Document document = saxBuilder.build(installFiles[i]);
                        PluginParams.runRbsInstaller(rbsCollection, document, context);
                    }
                    NPSCompatUtils.refreshResourceFileMap("custom");
                }
                this.initialState(ns, treeOE, context);
            } else if (nextState.equals("exportPlugin")) {
                this.exportPlugins(req, context);
            } else if (nextState.equals("deletePage")) {
                String pluginId = req.getParameter("pluginId");
                this.deletePage(pluginId, context);
                this.initialState(ns, treeOE, context);
            } else {
                D.assrt(false, "Invalid nextState for Studio");
            }
        }
        catch (Exception e) {
            D.log(e);
            eMFrameUtils.setErrorMessage(e, context);
            this.setUIPage("dev/GenFatal.jsp");
        }
    }

    public static void shouldRun(HttpServletRequest req, String sServiceName) throws Exception {
        Browser browser = Browser.getInstance(req);
        if (browser.getName().equals("NSN")) {
            int major = browser.getMajorVersionInt();
            int minor = browser.getMinorVersionInt();
            if (major <= 6 || major == 7 && minor < 1) {
                throw new Exception("Device not supported.  Please use Internet Explorer 6.0+, Mozilla 1.3+, or Netscape 7.1+.");
            }
        }
        FwUtils.verifyRbsInstalled(req, sServiceName);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void exportPlugins(HttpServletRequest req, MContext context) throws IOException, JDOMException, PluginException {
        String[] ids = eMFrameUtils.unpack(req.getParameter("pluginId"), context);
        String[] types = eMFrameUtils.unpack(req.getParameter("types"), context);
        File directory = new File(context.getWebappHome().getAbsolutePath() + "/temp");
        if (!directory.exists()) {
            directory.mkdir();
        }
        CustomNpmFile npm = new CustomNpmFile(directory, "custom" + TemplateBuilderUtils.getDatePostfix() + ".npm");
        String version = npm.getNextVersion().toString();
        this.filename = context.getWebappHome().getAbsolutePath() + "/temp/custom" + TemplateBuilderUtils.getDatePostfix() + ".npm";
        String jspDir = iManager.getAbsModulesPath() + "/custom/skins/default/devices/";
        try {
            block2: for (int i = 0; i < ids.length; ++i) {
                File[] pluginFiles;
                if (types[i].equals("page")) {
                    File pluginsDirectory = new File(iManager.getAbsModulesPath() + "/custom/plugins");
                    pluginFiles = pluginsDirectory.listFiles();
                } else {
                    PluginParams pluginParams = PluginParams.createPluginParamsFromRbsTask(ids[i], context);
                    pluginParams.m_pluginName = "custom." + ids[i].substring(0, ids[i].indexOf("."));
                    String merge = pluginParams.m_jspFilenameFromRbsTask.substring(pluginParams.m_jspFilenameFromRbsTask.indexOf(".") + 1);
                    String jspFile = merge + ".jsp";
                    String device = this.findJSP(jspDir, jspFile);
                    Document doc = pluginParams.createXmlFile(merge, "custom");
                    Element task = (Element)doc.getRootElement().clone();
                    npm.addInstallXml(task);
                    String name = "currentwebapp/portal/modules/custom/skins/default/devices/" + device + "/" + jspFile;
                    npm.addNpmEntry(name, new BufferedInputStream(new FileInputStream(jspDir + device + "/" + jspFile)));
                    continue;
                }
                for (int j = 0; j < pluginFiles.length; ++j) {
                    Element element = CustomNpmFile.findPlugin(pluginFiles[j], ids[i]);
                    if (element == null) continue;
                    npm.addPluginXml((Element)element.clone());
                    String merge = element.getChildTextTrim("merge-template");
                    String jspFile = merge.substring(merge.indexOf(".") + 1) + ".jsp";
                    String device = this.findJSP(jspDir, jspFile);
                    String name = "currentwebapp/portal/modules/custom/skins/default/devices/" + device + "/" + jspFile;
                    npm.addNpmEntry(name, new BufferedInputStream(new FileInputStream(jspDir + device + "/" + jspFile)));
                    continue block2;
                }
            }
        }
        catch (Throwable e) {
            D.log(e);
            eMFrameUtils.setErrorMessage(e, context);
            this.filename = null;
            throw new PluginException(e);
        }
        npm.writeFile(true);
    }

    private void deletePlugins(HttpServletRequest req, MContext context, NDSNamespace ns) throws Exception {
        String[] ids = eMFrameUtils.unpack(req.getParameter("pluginId"), context);
        String[] types = eMFrameUtils.unpack(req.getParameter("types"), context);
        for (int i = 0; i < ids.length; ++i) {
            if (types[i].equals("page")) {
                this.deletePage(ids[i], context);
                continue;
            }
            this.deleteTask(ids[i], ns, context);
        }
        String title = eMFrameUtils.getLocalizedString("FwResources", "Studio.pluginDeleted", context);
        String body = eMFrameUtils.getLocalizedString("FwResources", "Studio.pluginDeletedLong", context);
        eMFrameUtils.setMessage("success", title, body, context);
    }

    private void deletePage(String pluginId, MContext context) throws Exception {
        String userCN = null;
        boolean isAdmin = false;
        try {
            userCN = DirUtils.getUserCN(context);
            String accessMode = eMFrameUtils.getAccessMode(context);
            if (accessMode.equals("Unrestricted") || accessMode.equals("CollectionOwner")) {
                isAdmin = true;
            }
        }
        catch (AuthNotAuthenticatedException e) {
            D.log(e);
        }
        File directory = new File(iManager.getAbsModulesPath() + "/custom/plugins");
        if (!isAdmin && !TemplateBuilderUtils.hasPropertyPagePluginRights(directory, pluginId, userCN)) {
            String errTitle = eMFrameUtils.getLocalizedString("FwResources", "Studio.pluginDeletionFailed", context);
            String errbody = eMFrameUtils.getLocalizedString("FwResources", "Studio.pluginDeletionFailedLong", context);
            throw new PluginException(errTitle, errbody);
        }
        TemplateBuilderUtils.removePluginXmlFromDirectory(directory, pluginId);
        try {
            CustomNpmFile npm = new CustomNpmFile(context);
            Element pluginXml = npm.findPluginXml(pluginId);
            if (pluginXml != null) {
                String jspName = pluginXml.getChildTextTrim("merge-template");
                jspName = jspName.substring(jspName.indexOf(".") + 1, jspName.length());
                npm.removeEntry("/" + jspName + ".jsp");
                String path = iManager.getAbsModulesPath() + "/custom/skins/default/devices/";
                this.deleteAllJSPs(path, jspName + ".jsp");
                npm.removePluginXml(pluginId);
                npm.writeFile();
            }
        }
        catch (Throwable e) {
            D.log(e);
        }
        String filter = "(&(objectclass=rbsBook2)(rbsPageMembership=" + pluginId + "))";
        BasicAttributes attrs = new BasicAttributes("rbsPageMembership", pluginId);
        SearchControls sc = new SearchControls(2, 0L, 0, new String[0], false, false);
        LdapContext lctx = null;
        try {
            AuthenticationBroker broker = context.getAuthenticationBroker();
            lctx = (LdapContext)broker.getAPIObject("JndiLdap", null);
        }
        catch (Exception e) {
            D.log(e);
            String sErrorTitle = eMFrameUtils.getLocalizedString("BaseResources", "DynamicGroup.LDAPFailedErrorTitle", context);
            String sErrorBody = eMFrameUtils.getLocalizedString("BaseResources", "DynamicGroup.LDAPFailedErrorMsg", context);
            throw new PluginException(sErrorTitle, sErrorBody + e.toString());
        }
        NamingEnumeration<SearchResult> ne = lctx.search("", filter, sc);
        while (ne != null && ne.hasMore()) {
            SearchResult sr = ne.next();
            lctx.modifyAttributes(sr.getName(), 3, (Attributes)attrs);
        }
        Registry.refreshGlobalRegistry();
    }

    private void deleteTask(String pluginId, NDSNamespace ns, MContext context) throws Exception {
        ObjectEntry oe = ns.getObjectEntry(pluginId);
        String pluginName = oe.getParent().getName() + "." + oe.getName();
        ns.delete(oe);
        File directory = new File(iManager.getAbsModulesPath() + "/custom/install");
        TemplateBuilderUtils.removePluginXmlFromDirectory(directory, pluginName);
        try {
            String id = pluginId.substring(0, pluginId.indexOf("."));
            CustomNpmFile customNpmFile = new CustomNpmFile(new File(context.getWebappHome().getAbsolutePath() + "/packages"), "custom.npm");
            Element taskXml = customNpmFile.findInstallXml(id);
            if (taskXml == null) {
                taskXml = customNpmFile.findInstallXml("custom." + id);
            }
            if (taskXml != null) {
                String jspName = taskXml.getChildTextTrim("merge-template");
                jspName = jspName.substring(jspName.indexOf(".") + 1, jspName.length());
                customNpmFile.removeEntry("/" + jspName + ".jsp");
                customNpmFile.removeInstallXml(id);
                customNpmFile.writeFile();
                String path = iManager.getAbsModulesPath() + "/custom/skins/default/devices/";
                this.deleteAllJSPs(path, jspName + ".jsp");
            }
        }
        catch (Throwable e) {
            D.log(e);
        }
        context.removeFromHistory(ns.getUnrootedName(oe));
    }

    private void deleteAllJSPs(String path, String name) {
        File file = new File(path + "browser/" + name);
        if (file.exists()) {
            file.delete();
        }
        if ((file = new File(path + "default/" + name)).exists()) {
            file.delete();
        }
        if ((file = new File(path + "pocket/" + name)).exists()) {
            file.delete();
        }
    }

    private String findJSP(String path, String name) {
        File file = new File(path + "default/" + name);
        if (file.exists()) {
            return "default";
        }
        file = new File(path + "browser/" + name);
        if (file.exists()) {
            return "browser";
        }
        file = new File(path + "mozilla/" + name);
        if (file.exists()) {
            return "mozilla";
        }
        file = new File(path + "pocket/" + name);
        if (file.exists()) {
            return "pocket";
        }
        return null;
    }

    private boolean initialState(NDSNamespace ns, ObjectEntry treeOE, MContext context) throws Exception {
        ArrayList customPlugins = new ArrayList();
        this.discoverCustomTasks(ns, treeOE, customPlugins);
        this.discoverCustomPages(context, customPlugins);
        context.getRequest().setAttribute("customTasks", customPlugins);
        this.setUIPage("fw/Studio_overview.jsp");
        return true;
    }

    private void discoverCustomPages(MContext context, ArrayList customPlugins) {
        ArrayList pages = TemplateBuilderUtils.discoverPages(context);
        Iterator iterator = pages.iterator();
        while (iterator.hasNext()) {
            PageData pageData = (PageData)iterator.next();
            String fileName = pageData.getFileName();
            int index = fileName.indexOf("webapps");
            if (index >= 0) {
                fileName = fileName.substring(index + 8);
            }
            String isInstalled = "installed";
            customPlugins.add(new StudioPluginInfo(pageData.getPageDisplayName(), pageData.getPageId(), "page", fileName, isInstalled));
        }
    }

    private String checkIfInstalled(String taskName, String type) {
        if (taskName.indexOf(".custom.") != -1) {
            taskName = "custom." + taskName.substring(0, taskName.indexOf("."));
        }
        File installDir = new File(iManager.getAbsModulesPath() + File.separator + "custom" + File.separator + type + File.separator + "install.xml");
        Element root = null;
        try {
            root = CustomNpmFile.findPlugin(installDir, taskName);
        }
        catch (Exception e) {
            D.log(taskName + " was not installed.");
        }
        if (root == null) {
            return "not installed";
        }
        return "installed";
    }

    private void discoverCustomTasks(NDSNamespace ns, ObjectEntry treeOE, ArrayList customPlugins) throws PluginException, SPIException, NamespaceException {
        ObjectEntry[] customModules = this.getCustomModules(ns, treeOE);
        for (int i = 0; i < customModules.length; ++i) {
            NDSFilterResultModifier rm = new NDSFilterResultModifier("StudioFilter", 0, null, false);
            String[] typeFilter = new String[]{"rbsTask2"};
            rm.addFilter(new ResultModifierFilterEntry(null, typeFilter));
            ObjectEntryEnumeration myenum = ns.getChildren(customModules[i], (ResultModifier)rm);
            while (myenum.hasMoreElements()) {
                ObjectEntry oe = (ObjectEntry)myenum.nextElement();
                String fullname = oe.getFullName();
                fullname = fullname.substring(0, fullname.lastIndexOf(".", fullname.length() - 2));
                String rbsCollectionName = DirUtils.removeTreeFromFullName(oe.getRoot(), oe.getParent().getFullName());
                String isInstalled = this.checkIfInstalled(fullname, "install");
                customPlugins.add(new StudioPluginInfo(oe.getName(), fullname, "task", rbsCollectionName, isInstalled));
            }
        }
    }

    private ObjectEntry[] getCustomModules(NDSNamespace ns, ObjectEntry treeOE) throws PluginException, NamespaceException {
        ArrayList<ObjectEntry> list = new ArrayList<ObjectEntry>();
        try {
            ObjectEntry oeTrustee = ns.getAuthenticatedIdentity(treeOE);
            RBSAssociatedObject user = new RBSAssociatedObject(oeTrustee);
            RBSCollection[] rbsCollections = user.getAllOwnedCollections2();
            if (rbsCollections != null) {
                for (int i = 0; i < rbsCollections.length; ++i) {
                    String name = rbsCollections[i].getObjectEntry().getFullName();
                    try {
                        ObjectEntry oe = ns.getObjectEntry("custom." + name);
                        list.add(oe);
                        continue;
                    }
                    catch (SPIException e) {
                        // empty catch block
                    }
                }
            }
        }
        catch (SPIException e) {
            throw new PluginException((Exception)((Object)e));
        }
        return list.toArray(new ObjectEntry[list.size()]);
    }
}

