/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.fw.uihandlers;

import com.novell.emframe.dev.UiHandler;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Properties;

public class MVStringEditorUiHandler
extends UiHandler {
    private static final String[] m_hexSharedCode = new String[]{"iman:mvedScripts mode=\"mvsel\"", "iman:validateNumberScripts"};
    private static final String[] m_sharedCode = new String[]{"iman:mvedScripts", "iman:validateNumberScripts"};
    private static final String[] m_dnHeaderCode = new String[]{"iman:mvedScripts", "iman:validateNumberScripts", "iman:osScripts"};
    private String m_typeFilter = null;

    public String[] getSharedHeaderCode() {
        String syntax = this.context.getSyntaxName();
        if (syntax.equals("Distinguished Name") || syntax.equals("LDAP:DN")) {
            return m_dnHeaderCode;
        }
        if (syntax.equals("Octet String") || syntax.equals("LDAP:Octet String")) {
            return m_hexSharedCode;
        }
        return m_sharedCode;
    }

    public String getNotificationName() {
        if (this.context.getSyntaxName().equals("Case Ignore List") && !this.context.isSingleValued()) {
            return "uih_multivaluedCIList";
        }
        return "uih_mvStringEditor";
    }

    public String getActionHandlerName() {
        return null;
    }

    public void printUiCode(PrintWriter pw, String indent) {
        Properties attributes = new Properties();
        attributes.put("name", "_" + this.context.getEncodedAttributeName());
        String syntaxName = this.context.getSyntaxName();
        String regExp = this.getParameterValue("regularExpression");
        if (regExp != null && regExp.length() > 0) {
            attributes.put("regExpression", regExp);
            attributes.put("regExpressionMsg", this.getParameterValue("regularExpressionErrorMsg"));
        }
        if (this.context.isForceReadOnly()) {
            attributes.put("readonly", "true");
        } else {
            String upperbound = this.getParameterValue("upperbound");
            String lowerbound = this.getParameterValue("lowerbound");
            if (this.context.isSized()) {
                if (upperbound == null || upperbound.length() == 0) {
                    upperbound = "" + this.context.getUpperBound();
                }
                if (lowerbound == null || lowerbound.length() == 0) {
                    lowerbound = "" + this.context.getLowerBound();
                }
            }
            if (upperbound != null || lowerbound != null) {
                if (upperbound == null) {
                    upperbound = "999999";
                }
                if (lowerbound == null) {
                    lowerbound = "-999999";
                }
                if (syntaxName.equals("Counter") || syntaxName.equals("Integer") || syntaxName.equals("Interval") || syntaxName.equals("LDAP:Counter") || syntaxName.equals("LDAP:Integer")) {
                    attributes.put("numbersOnly", "true");
                    attributes.put("lowerBound", "" + lowerbound);
                    attributes.put("upperBound", "" + upperbound);
                } else {
                    attributes.put("minLength", "" + lowerbound);
                    attributes.put("maxLength", "" + upperbound);
                }
            }
            if (syntaxName.equals("Case Ignore String") || syntaxName.equals("LDAP:Case Ignore String")) {
                attributes.put("ignoreCase", "true");
            } else if (syntaxName.equals("Distinguished Name") || syntaxName.equals("LDAP:DN")) {
                String typeFilter = this.m_typeFilter;
                if (typeFilter == null) {
                    typeFilter = this.getParameterValue("objectTypeFilter");
                }
                if (typeFilter == null) {
                    attributes.put("objectTypeName", "*");
                } else {
                    attributes.put("objectTypeName", typeFilter);
                }
            } else if (syntaxName.equals("Octet String") || syntaxName.equals("LDAP:Octet String")) {
                attributes.put("hex", "true");
            }
            attributes.put("enforceUnique", "true");
            attributes.put("readonly", "${!" + this.context.geteDasRights() + "}");
        }
        String inputFieldSize = this.getParameterValue("fieldSize");
        if (inputFieldSize != null) {
            attributes.put("width", inputFieldSize);
        }
        pw.println(indent + "<x:set var=\"MVStringEditor_xmlNodeSet\" select=\"" + this.context.getxPathSet() + "\" scope=\"request\"/>");
        if (syntaxName.equals("Case Ignore List") && !this.context.isSingleValued()) {
            pw.println(indent + "<iman:include page=\"fw/MVCIListEditor.jsp\"/>");
        } else {
            pw.print(indent + "<iman:mved");
            Enumeration<Object> myenum = attributes.keys();
            while (myenum.hasMoreElements()) {
                String key = (String)myenum.nextElement();
                pw.print(" " + key + "=\"" + attributes.getProperty(key) + "\"");
            }
            pw.println(indent + "/>");
        }
    }

    public void setTypeFilter(String filter) {
        this.m_typeFilter = filter;
    }
}

