/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.fw.uihandlers;

import com.novell.emframe.dev.UiHandler;
import com.novell.emframe.fw.authenticator.DirAuthenticator;
import java.io.PrintWriter;

public class TextfieldUiHandler
extends UiHandler {
    private static final String[] m_sharedCode = new String[]{"iman:validateNumberScripts"};
    private static final String[] m_dnSharedCode = new String[]{"iman:validateNumberScripts", "iman:osScripts"};
    private boolean m_makeFieldSubmitable = false;

    public String[] getSharedHeaderCode() {
        return this.context.getSyntaxName().equals("Distinguished Name") || this.context.getSyntaxName().equals("LDAP:DN") ? m_dnSharedCode : m_sharedCode;
    }

    public String getActionHandlerName() {
        return "uiah_textfield";
    }

    public String getNotificationName() {
        return "uih_textfield";
    }

    public void printUiCode(PrintWriter pw, String indent) {
        String numberValidation = "";
        String charLengthString = " ";
        String controlWidth = "";
        String controlPixelWidth = "";
        String inputFieldSize = this.getParameterValue("fieldSize");
        String paramValue = this.getParameterValue("paramValue");
        boolean readOnly = this.context.isForceReadOnly();
        if (this.context.getSyntaxName().equals("Counter") || this.context.getSyntaxName().equals("Integer") || this.context.getSyntaxName().equals("Interval") || this.context.getSyntaxName().equals("LDAP:Counter") || this.context.getSyntaxName().equals("LDAP:Integer")) {
            controlWidth = "<iman:string key=\"UI.numberboxSize\"/>";
            controlPixelWidth = "<iman:string key=\"UI.numberboxPixel\"/>";
        } else if (this.context.getSyntaxName().equals("Numeric String") || this.context.getSyntaxName().equals("LDAP:Numeric String")) {
            controlWidth = "<iman:string key=\"UI.numberboxSize\"/>";
            controlPixelWidth = "<iman:string key=\"UI.numberboxPixel\"/>";
        } else {
            controlWidth = inputFieldSize != null ? inputFieldSize : "<iman:string key=\"UI.textboxSize\"/>";
            controlPixelWidth = "<iman:string key=\"UI.textboxPixel\"/>";
            String upperbound = this.getParameterValue("upperbound");
            String lowerbound = this.getParameterValue("lowerbound");
            if (this.context.isSized()) {
                if (upperbound == null || upperbound.length() == 0) {
                    upperbound = "" + this.context.getUpperBound();
                }
                if (lowerbound == null || lowerbound.length() == 0) {
                    lowerbound = "" + this.context.getLowerBound();
                }
            }
            if (lowerbound != null && upperbound != null) {
                charLengthString = " maxlength=" + upperbound + " onChange='return validateLengthField(this, " + lowerbound + ", " + upperbound + "); postUiHandlerEvent(\"" + this.context.getEncodedAttributeName() + "\", \"change\")'";
            } else if (lowerbound != null) {
                charLengthString = " maxlength=" + upperbound + " ";
            }
        }
        if (this.context.getSyntaxName().equals("Counter") || this.context.getSyntaxName().equals("Integer") || this.context.getSyntaxName().equals("LDAP:Counter") || this.context.getSyntaxName().equals("LDAP:Integer")) {
            pw.print("<TABLE cellpadding=\"0\" cellspacing=\"0\"><TR><TD>");
        }
        if (readOnly) {
            if (paramValue != null) {
                if (inputFieldSize != null) {
                    pw.println(indent + "<INPUT type=\"text\" name=\"_" + this.context.getEncodedAttributeName() + "\" value=\"" + this.context.getFirstValue() + paramValue + "\" size=" + controlWidth + "\" READONLY=\"true\">");
                } else {
                    pw.println(indent + "<INPUT type=\"text\" name=\"_" + this.context.getEncodedAttributeName() + "\" value=\"" + this.context.getFirstValue() + paramValue + "\" size=" + controlWidth + " style=\"width:" + controlPixelWidth + "\" READONLY=\"true\">");
                }
            } else {
                pw.println(indent + "<INPUT type=\"text\" name=\"_" + this.context.getEncodedAttributeName() + "\" value=\"" + this.context.getFirstValue() + "\" size=" + controlWidth + " style=\"width:" + controlPixelWidth + "\" DISABLED>");
            }
        } else {
            String eventHander = "";
            if (this.m_makeFieldSubmitable) {
                eventHander = " onkeypress=\"return checkDefaultKey(event)\" ";
            }
            if (paramValue != null) {
                if (inputFieldSize != null) {
                    pw.print(indent + "<INPUT type=\"text\" name=\"_" + this.context.getEncodedAttributeName() + "\" id=\"spinner_" + this.context.getEncodedAttributeName() + "\" value=\"" + this.context.getFirstValue() + paramValue + "\" size=" + controlWidth + " " + numberValidation + charLengthString + this.context.geteDasRightsStandard() + eventHander + " >");
                } else {
                    pw.print(indent + "<INPUT type=\"text\" name=\"_" + this.context.getEncodedAttributeName() + "\" id=\"spinner_" + this.context.getEncodedAttributeName() + "\" value=\"" + this.context.getFirstValue() + paramValue + "\" size=" + controlWidth + " style=\"width:" + controlPixelWidth + "\" " + numberValidation + charLengthString + this.context.geteDasRightsStandard() + eventHander + " >");
                }
            } else if (inputFieldSize != null) {
                pw.print(indent + "<INPUT type=\"text\" name=\"_" + this.context.getEncodedAttributeName() + "\" id=\"spinner_" + this.context.getEncodedAttributeName() + "\" value=\"" + this.context.getFirstValue() + "\" size=" + controlWidth + " " + numberValidation + charLengthString + this.context.geteDasRightsStandard() + eventHander + " >");
            } else {
                pw.print(indent + "<INPUT type=\"text\" name=\"_" + this.context.getEncodedAttributeName() + "\" id=\"spinner_" + this.context.getEncodedAttributeName() + "\" value=\"" + this.context.getFirstValue() + "\" size=" + controlWidth + " style=\"width:" + controlPixelWidth + "\" " + numberValidation + charLengthString + this.context.geteDasRightsStandard() + eventHander + " >");
            }
        }
        if (this.context.getSyntaxName().equals("Distinguished Name") || this.context.getSyntaxName().equals("LDAP:DN")) {
            if (DirAuthenticator.getDirAuth(this.m_taskContext).isAuthenticated(this.m_taskContext.getRequest())) {
                pw.println(indent + "<c:if test=\"${" + this.context.geteDasRights() + "}\">");
                if (this.context.getAttributeName().equals("Host Server")) {
                    pw.println(indent + "   <iman:os typeFilter=\"NCP Server\" control=\"_" + this.context.getEncodedAttributeName() + "\" showSubClasses=\"false\" />");
                } else {
                    pw.println(indent + "   <iman:os typeFilter=\"*\" control=\"_" + this.context.getEncodedAttributeName() + "\" />");
                }
                pw.println(indent + "</c:if>");
            }
        } else if (this.context.getSyntaxName().equals("Counter") || this.context.getSyntaxName().equals("Integer") || this.context.getSyntaxName().equals("LDAP:Counter") || this.context.getSyntaxName().equals("LDAP:Integer")) {
            pw.println("</TD><TD><iman:spinner elementId=\"spinner_" + this.context.getEncodedAttributeName() + "\"/></TD></TR></TABLE>");
        } else {
            pw.println();
        }
        if (this.context.getSyntaxName().equals("Interval")) {
            pw.print("<iman:string key=\"UIHandler.Second\"/>");
        }
    }

    public void printScript(PrintWriter pw, String indent) {
        super.printScript(pw, indent);
        pw.println(indent + "<SCRIPT>");
        String regExp = this.getParameterValue("regularExpression");
        String regExpError = this.getParameterValue("regularExpressionErrorMsg");
        if (regExpError == null) {
            regExpError = "";
        }
        if (regExp != null) {
            pw.println(indent + "   window.uiObject_" + this.context.getEncodedAttributeName() + ".m_regExpression = \"" + regExp + "\";");
            pw.println(indent + "   window.uiObject_" + this.context.getEncodedAttributeName() + ".m_regExpressionErrorMsg = \"" + regExpError + "\";");
        }
        String upperbound = this.getParameterValue("upperbound");
        String lowerbound = this.getParameterValue("lowerbound");
        if (this.context.isSized()) {
            if (upperbound == null || upperbound.length() == 0) {
                upperbound = "" + this.context.getUpperBound();
            }
            if (lowerbound == null || lowerbound.length() == 0) {
                lowerbound = "" + this.context.getLowerBound();
            }
        }
        pw.println(indent + "   window.uiObject_" + this.context.getEncodedAttributeName() + ".m_lowerBound = " + lowerbound + ";");
        pw.println(indent + "   window.uiObject_" + this.context.getEncodedAttributeName() + ".m_upperBound = " + upperbound + ";");
        if (this.context.getSyntaxName().equals("Counter") || this.context.getSyntaxName().equals("Integer") || this.context.getSyntaxName().equals("Interval") || this.context.getSyntaxName().equals("LDAP:Counter") || this.context.getSyntaxName().equals("LDAP:Integer")) {
            pw.println(indent + "   window.uiObject_" + this.context.getEncodedAttributeName() + ".m_type = \"integer\";");
        } else if (this.context.getSyntaxName().equals("Numeric String") || this.context.getSyntaxName().equals("LDAP:Numeric String")) {
            pw.println(indent + "   window.uiObject_" + this.context.getEncodedAttributeName() + ".m_type = \"number\";");
        } else {
            pw.println(indent + "   window.uiObject_" + this.context.getEncodedAttributeName() + ".m_type = \"string\";");
        }
        pw.println(indent + "</SCRIPT>");
    }

    public void setMakeFieldSubmitable(boolean makeFieldSubmitable) {
        this.m_makeFieldSubmitable = makeFieldSubmitable;
    }

    public void printFocus(PrintWriter pw, String indent) {
        if (!this.context.isForceReadOnly()) {
            pw.println(indent + "form._" + this.context.getEncodedAttributeName() + ".focus();");
        }
    }
}

